<?php

function renderLicenses( $block_attributes ) {
	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? Helper::get_default_theme_data( 'home_special_title' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';
	$text       = $block_attributes['about'] ?? '';

	$home_special_action_label = $block_attributes['counterTitle'] ?? '';
	$home_special_action_date  = $block_attributes['endByDate'] ?? '';
	$home_special_action_hours = $block_attributes['endByTime'] ?? '';

	$timer_type = $block_attributes['endType'] ?? '';
	if ( 'byTime' == $timer_type ) {
		$timer_data_attr = 'data-timer-by="' . $home_special_action_hours . '"';
	}
	else {
		$timer_data_attr = 'data-timer-stop="' . $home_special_action_date . '"';
	}

	$license_timer = false;
	if ( $home_special_action_date || $home_special_action_hours ) {
		$license_timer = true;
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();
	unset( $block_attributes['licenses'] );
	unset( $block_attributes['categories'] );
	unset( $block_attributes['formHtml'] );
	?>
    <div class="wp-block-wescle-blocks-licenses licenses <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <svg class="visually-hidden" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="22" height="22" viewbox="0 0 22 22">
            <defs>
                <radialgradient id="radial-orange" cx="0.564" cy="0.266" r="0.691" gradienttransform="matrix(0.986, 0.019, -0.019, 1, 0.014, -0.011)" gradientunits="objectBoundingBox">
                    <stop offset="0" stop-color="#ffbf00"></stop>
                    <stop offset="0.976" stop-color="#ff9300"></stop>
                </radialgradient>
            </defs>
        </svg>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="licenses__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="_section-about">
					<?php if ( isset( $block_attributes['aboutImg'] ) ) { ?>
						<?php echo wp_get_attachment_image( $block_attributes['aboutImg']['id'], 'medium_large' ); ?>
					<?php } ?>
                    <div class="_section-about__text"><?php echo $text; ?></div>
                </div>
			<?php } ?>
			<?php
			$args = [
				'license_timer'              => $license_timer,
				'timer_data_attr'            => $timer_data_attr,
				'home_licenses_action_label' => $home_special_action_label,
				'btn_flare'                  => isset( $block_attributes['buttonsView'] ) && $block_attributes['buttonsView'] ? 'btn-flare' : '',
			];
			get_template_part( 'template-parts/content/license', 'tabs', $args );
			?>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/licenses', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderLicenses'
) );