<?php

function renderInstruction( $block_attributes ) {
	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Инструкция', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text       = $block_attributes['about'] ?? '';
	$aboutImage = $block_attributes['aboutImage'] ?? '';

	$faq_items = $block_attributes['services'] ?? [];

	$term_ids = [];
	if ( $faq_items ) {
		foreach ( $faq_items as $faq_item ) {
			if ( intval( $faq_item['serviceId'] ) > 0 ) {
				$term_ids[] = intval( $faq_item['serviceId'] );
			}
		}
	}

	$terms = get_terms( [
		'taxonomy' => 'faqcat_wescle',
		'include'  => $term_ids,
		'orderby'  => 'include'
	] );
	if ( ! $terms ) {
		return;
	}
	$terms = array_values( $terms );

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	if ( isset( $block_attributes['allCategoriesToggle'] ) ) {
		$section_class .= ' _view-all-categories';
	}

	ob_start();
	?>
    <div class="wp-block-wescle-blocks-instruction instruction _tabs <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="instruction__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="_section-about">
					<?php if ( $aboutImage && isset( $aboutImage['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $aboutImage['id'], 'medium' ); ?>
					<?php } ?>
                    <div class="_section-about__text"><?php echo $text; ?></div>
                </div>
			<?php } ?>
            <div class="instruction__row">
                <div class="instruction__col instruction__nav">
                    <div class="instruction-list">
						<?php
						foreach ( $terms as $key => $term ) {
							$class = '';
							if ( $key == 0 ) {
								$class = '_active';
							}
							?>
                            <div class="instruction-list-item _tabs-item <?php echo $class; ?>">
                                <div class="instruction-list-item__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16">
                                        <g fill="#626262">
                                            <path d="M8.05 9.6c.336 0 .504-.24.554-.627c.04-.534.198-.815.847-1.26c.673-.475 1.049-1.09 1.049-1.986c0-1.325-.92-2.227-2.262-2.227c-1.02 0-1.792.492-2.1 1.29A1.71 1.71 0 0 0 6 5.48c0 .393.203.64.545.64c.272 0 .455-.147.564-.51c.158-.592.525-.915 1.074-.915c.61 0 1.03.446 1.03 1.084c0 .563-.208.885-.822 1.325c-.619.433-.926.914-.926 1.64v.111c0 .428.208.745.585.745z"></path>
                                            <path d="M10.273 2.513l-.921-.944l.715-.698l.622.637l.89-.011a2.89 2.89 0 0 1 2.924 2.924l-.01.89l.636.622a2.89 2.89 0 0 1 0 4.134l-.637.622l.011.89a2.89 2.89 0 0 1-2.924 2.924l-.89-.01l-.622.636a2.89 2.89 0 0 1-4.134 0l-.622-.637l-.89.011a2.89 2.89 0 0 1-2.924-2.924l.01-.89l-.636-.622a2.89 2.89 0 0 1 0-4.134l.637-.622l-.011-.89a2.89 2.89 0 0 1 2.924-2.924l.89.01l.622-.636a2.89 2.89 0 0 1 4.134 0l-.715.698a1.89 1.89 0 0 0-2.704 0l-.92.944l-1.32-.016a1.89 1.89 0 0 0-1.911 1.912l.016 1.318l-.944.921a1.89 1.89 0 0 0 0 2.704l.944.92l-.016 1.32a1.89 1.89 0 0 0 1.912 1.911l1.318-.016l.921.944a1.89 1.89 0 0 0 2.704 0l.92-.944l1.32.016a1.89 1.89 0 0 0 1.911-1.912l-.016-1.318l.944-.921a1.89 1.89 0 0 0 0-2.704l-.944-.92l.016-1.32a1.89 1.89 0 0 0-1.912-1.911l-1.318.016z"></path>
                                            <path d="M7.001 11a1 1 0 1 1 2 0a1 1 0 0 1-2 0z"></path>
                                        </g>
                                    </svg>
                                </div>
                                <div class="instruction-list-item__title"><?php echo $term->name; ?></div>
                            </div>
							<?php
						}
						?>
                    </div>
                    <div class="instruction-list_navigation">
                        <button class="btn btn-main hide" type="button"><?php _e( 'Навигация', 'wescle' ); ?></button>
                    </div>
                </div>
                <div class="instruction__col">
					<?php
					foreach ( $terms as $key => $term ) {
						$class = '';
						if ( $key == 0 ) {
							$class = '_active';
						}

						$posts_faq = get_posts( [
							'post_type'        => 'faq_wescle',
							'posts_per_page'   => - 1,
							'tax_query'        => [
								[
									'taxonomy' => $term->taxonomy,
									'terms'    => [ $term->term_id ],
								]
							],
							'suppress_filters' => false
						] );
						?>
                        <div class="_tabs-block <?php echo $class; ?>" data-spollers data-one-spoller>
							<?php foreach ( $posts_faq as $post_item ) { ?>
                                <div class="instruction-item">
                                    <button class="instruction-item__title" data-spoller><span><?php echo $post_item->post_title; ?></span>
                                        <svg class="feather feather-plus" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewbox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <line x1="12" y1="5" x2="12" y2="19"></line>
                                            <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                    </button>
                                    <div class="instruction-item__body">
										<?php echo apply_filters( 'the_content', $post_item->post_content ); ?>
                                    </div>
                                </div>
							<?php } ?>
                        </div>
						<?php
					}
					?>
                </div>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/instruction', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderInstruction'
) );