<?php

function renderInfoTabsBlock( $block_attributes ) {
	static $key_block = 0;
	$key_block ++;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Заголовок', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text       = $block_attributes['about'] ?? 'Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque in ipsum id orci porta dapibus.';
	$aboutImage = $block_attributes['aboutImage'] ?? '';

	if ( ! isset( $block_attributes['items'] ) || empty( $block_attributes['items'] ) ) {
		return;
	}

	$tab_post_ids = [];
	foreach ( $block_attributes['items'] as $item ) {
		if ( $item['tab']['id'] ) {
			$tab_post_ids[] = $item['tab']['id'];
		}
	}

	$info_tabs_data = Helper::get_info_tabs_data( 'wescle-block' );
	$tab_posts      = $info_tabs_data['tabs'];
	foreach ( $tab_posts as $key => $tab_post ) {
		if ( ! in_array( $tab_post->ID, $tab_post_ids ) ) {
			unset( $tab_posts[ $key ] );
		}
	}
	if ( ! $tab_posts ) {
		return;
	}

	$section_class = '';
	$style_bg      = '';

	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();

	unset( $block_attributes['pages'] );
	unset( $block_attributes['options'] );
	?>
    <div class="wp-block-wescle-blocks-info-tabs info-tabs <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="info-tabs__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="info-tabs__about _section-about">
					<?php if ( $aboutImage && isset( $aboutImage['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $aboutImage['id'], 'medium' ); ?>
					<?php } ?>
                    <div class="_section-about__text"><?php echo $text; ?></div>
                </div>
			<?php } ?>
			<?php get_template_part( 'template-parts/home/infotabs-tabs', null, [ 'tab_posts' => $tab_posts ] ); ?>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/info-tabs', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderInfoTabsBlock'
) );