<?php

function renderHighlightTabs( $block_attributes ) {

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Табы с объектами', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text      = $block_attributes['about'] ?? '';
	$tab_items = $block_attributes['items'] ?? [];

	$tab_post_ids = [];
	foreach ( $tab_items as $item ) {
		if ( $item['tab']['id'] ) {
			$tab_post_ids[] = $item['tab']['id'];
		}
	}

	if ( ! $tab_post_ids ) {
		return;
	}

	$posts_per_page = count( $tab_post_ids );
	$post__in       = $tab_post_ids;
	$orderby        = 'post__in';

	$service_posts = get_posts( [
		'post_type'        => 'tab_wescle',
		'posts_per_page'   => $posts_per_page,
		'post__in'         => $post__in,
		'orderby'          => $orderby,
		'suppress_filters' => false
	] );
	if ( ! $service_posts ) {
		return;
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();

	unset( $block_attributes['options'] );
	?>
    <div class="wp-block-wescle-blocks-highlight highlight <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="highlight__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="highlight__subtitle"><?php echo $text; ?></div>
			<?php } ?>
            <div class="_tabs">
                <ul class="highlight-tabs-nav">
					<?php foreach ( $service_posts as $key => $post_item ) { ?>
						<?php
						$class_active = '';
						if ( $key == 0 ) {
							$class_active = '_active';
						}
						?>
                        <li>
                            <button class="btn btn-main _tabs-item <?php echo $class_active; ?>" type="button"><?php echo $post_item->post_title; ?></button>
                        </li>
					<?php } ?>
                </ul>
                <ul class="highlight-tabs">
					<?php foreach ( $service_posts as $key => $post_item ) { ?>
						<?php
						$class_active = '';
						if ( $key == 0 ) {
							$class_active = '_active';
						}

						$tabs_items = get_post_meta( $post_item->ID, 'wescle_tab_info', 1 );
						?>
                        <li class="_tabs-block _fade <?php echo $class_active; ?>">
                            <div class="highlight-tabs__content">
								<?php foreach ( $tabs_items as $item ) { ?>
									<?php
									$bg_color_style = $item['bg_color'] ? 'style="background-color:' . $item['bg_color'] . '"' : '';
									$tag_open       = '<div class="highlight-tab-item">';
									$tag_close      = '</div>';
									if ( isset( $item['url'] ) && $item['url'] ) {
										$tag_open  = '<a href="' . $item['url'] . '" class="highlight-tab-item">';
										$tag_close = '</a>';
									}
									?>
                                    <div class="highlight-tabs__col">
										<?php echo $tag_open; ?>
										<?php if ( $item['img_id'] ) { ?>
                                            <div class="highlight-tab-item__img" <?php echo $bg_color_style; ?>>
												<?php echo wp_get_attachment_image( $item['img_id'] ); ?>
                                            </div>
										<?php } ?>
                                        <div class="highlight-tab-item__body">
											<?php if ( $item['title'] ) { ?>
                                                <div class="highlight-tab-item__title"><?php echo $item['title']; ?></div>
											<?php } ?>
											<?php if ( $item['text'] ) { ?>
                                                <div class="highlight-tab-item__text"><?php echo $item['text']; ?></div>
											<?php } ?>
                                        </div>
										<?php echo $tag_close; ?>
                                    </div>
								<?php } ?>
                            </div>
                        </li>
					<?php } ?>
                </ul>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/highlight-tabs', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderHighlightTabs'
) );