<?php

function renderEvents( $block_attributes ) {
	global $post;

	unset( $block_attributes['pages'] );
	unset( $block_attributes['events'] );

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? Helper::get_default_theme_data( 'home_events_title' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';
	$text       = $block_attributes['about'] ?? '';

	$link    = '';
	$link_id = $block_attributes['link'] ?? '';
	if ( $link_id ) {
		$link = get_permalink( $link_id );
	}
	$link_text = $block_attributes['allServices'] ?? Helper::get_default_theme_data( 'home_events_link_text' );
	$more_text = $block_attributes['button'] ?? Helper::get_default_theme_data( 'home_events_more_text' );

	$event_post_ids = [];
	if ( isset( $block_attributes['selectedEventsList'] ) ) {
		foreach ( $block_attributes['selectedEventsList'] as $item ) {
			$event_post_ids[] = $item['id'];
		}
	}

	$posts_per_page = $block_attributes['eventsOnPage'] ?? 8;
	$post__in       = [];
	$orderby        = [ 'meta_value_num' => 'ASC', 'menu_order' => 'ASC' ];
	if ( $event_post_ids ) {
		$posts_per_page = count( $event_post_ids );
		$post__in       = $event_post_ids;
		$orderby        = 'post__in';
	}

	$args = [
		'post_type'        => 'event_wescle',
		'posts_per_page'   => $posts_per_page,
		'post__in'         => $post__in,
		'orderby'          => $orderby,
		'meta_query'       => [
			[
				'key'     => 'event_date',
				'value'   => current_time( 'Ymd' ),
				'compare' => '>=',
				'type'    => 'NUMERIC'
			]
		],
		'suppress_filters' => false
	];
	$event_posts = get_posts( $args );
	if ( ! $event_posts ) {
		return;
	}

	$args_next                   = $args;
	$args_next['posts_per_page'] = $posts_per_page + 1;
	$args_next['fields']         = 'ids';

	$event_posts_next = get_posts( $args_next );

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	$btn_flare     = 0;
	$parse_content = parse_blocks( $post->post_content );
	foreach ( $parse_content as $item ) {
		if ( $item['blockName'] == 'wescle-blocks/events' ) {

			$button_type = $item['attrs']['buttonsView'] ?? '';
			if ( $button_type == 'animate' ) {
				$btn_flare = 1;
			}
		}
	}

	ob_start();
	?>
    <div class="wp-block-wescle-blocks-events-block events-block <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="events-block__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
            <div class="events-block__about">
				<?php if ( $text ) { ?>
                    <div class="events-block__text"><?php echo $text; ?></div>
				<?php } ?>
				<?php if ( $link && $link_text ) { ?>
                    <a class="events-block__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
				<?php } ?>
            </div>
            <div class="events-block__grid">
				<?php
				$event_post_ids = [];
				foreach ( $event_posts as $post ) {
					setup_postdata( $post );
					$event_post_ids[] = $post->ID;

					get_template_part( 'template-parts/content/event', 'item', [ 'btn_flare' => $btn_flare ] );
				}
				wp_reset_postdata();
				?>
            </div>
			<?php if ( $more_text && count( $event_posts_next ) > $posts_per_page ) { ?>
                <div class="events-block__more">
                    <a class="btn btn-main btn-more-events" data-paged="1" data-per_page="<?php echo $posts_per_page; ?>" data-event_post_ids="<?php echo implode( ',', $event_post_ids ); ?>" href="#"><?php echo $more_text; ?></a>
                </div>
			<?php } ?>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/events', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderEvents'
) );