<?php

function renderContactUs( $block_attributes, $content ) {
	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? Helper::get_default_theme_data( 'wescle_blocks_contact_title' );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$block_left_title  = $block_attributes['leftBlockTitle'] ?? '';
	$block_left_img    = $block_attributes['leftBlockAboutImg'] ?? '';
	$block_left_text   = $block_attributes['leftBlockAbout'] ?? '';
	$block_left_img2   = $block_attributes['leftBlockAboutAPImg'] ?? '';
	$block_left_text2  = $block_attributes['leftBlockAboutAP'] ?? '';
	$block_left_map    = $block_attributes['map'] ?? '';
	$block_left_phones = $block_attributes['services'] ?? '';

	$block_right_title = $block_attributes['rightBlockTitle'] ?? '';
	$block_right_img   = $block_attributes['rightBlockAboutImg'] ?? '';
	$block_right_text  = $block_attributes['rightBlockAbout'] ?? '';
	$home_contact_cf7  = $block_attributes['form'] ?? 0;
	$home_contact_cf7  = intval( $home_contact_cf7 );

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();
	?>
    <div class="wp-block-wescle-blocks-contact-us contact-us <?php echo $section_class; ?>"<?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="contact-us__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
            <div class="contact-us__grid">
                <div class="contact-us-info">
					<?php if ( $block_left_title ) { ?>
                        <h3 class="contact-us__subtitle"><?php echo $block_left_title; ?></h3>
					<?php } ?>
					<?php if ( isset( $block_left_img['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $block_left_img['id'], 'medium_large' ); ?>
					<?php } ?>
					<?php if ( $block_left_text ) { ?>
                        <div class="contact-us__text"><?php echo $block_left_text; ?></div>
					<?php } ?>
					<?php if ( $block_left_phones ) { ?>
                        <div class="contact-us__tel">
							<?php
							foreach ( $block_left_phones as $item ) {
								if ( ! $item['phone'] ) {
									continue;
								}
								$anchor = $item['link'] ? $item['link'] : $item['phone'];
								?>
                                <a href="tel:<?php echo Helper::phone_number_format( $item['phone'] ); ?>"> <?php echo Helper::phone_number_mask( $anchor ); ?></a>
							<?php } ?>
                        </div>
					<?php } ?>
					<?php if ( isset( $block_left_img2['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $block_left_img2['id'], 'medium_large' ); ?>
					<?php } ?>
					<?php if ( $block_left_text2 ) { ?>
                        <div class="contact-us-schedule"><?php echo $block_left_text2; ?></div>
					<?php } ?>
					<?php if ( $block_left_map ) { ?>
                        <div class="contact-us__map"><?php echo $block_left_map; ?></div>
					<?php } ?>
                </div>
                <div class="contact-us-form">
					<?php if ( $block_right_title ) { ?>
                        <div class="contact-us__subtitle"><?php echo $block_right_title; ?></div>
					<?php } ?>
					<?php if ( isset( $block_right_img['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $block_right_img['id'], 'medium_large' ); ?>
					<?php } ?>
					<?php if ( $block_right_text ) { ?>
                        <div class="contact-us__text"><?php echo $block_right_text; ?></div>
					<?php } ?>
					<?php
					if ( $home_contact_cf7 ) {
						echo do_shortcode( '[contact-form-7 id="' . $home_contact_cf7 . '"]' );
					}
					?>
                </div>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

function registerContactApi() {
	register_rest_route( 'wescle-blocks', '/render-cf7-form', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$form_id = $request['form_id'];

			return do_shortcode( '[contact-form-7 id="' . $form_id . '"]' );
		},
	) );
}

add_action( 'rest_api_init', 'registerContactApi', 10, 1 );

register_block_type( 'wescle-blocks/contact-us', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'attributes'      => array(
		'previewImage'                   => array(
			'type'    => 'string',
			'default' => '',
		),
		'preview'                        => array(
			'type'    => 'boolean',
			'default' => false,
		),
		'title'                          => array(
			'type'    => 'string',
			'default' => __( 'Связаться с нами', 'wescle-blocks' ),
		),
		'aboutImg'                       => array(
			'type'    => 'object',
			'default' => array(
				'url' => null,
				'alt' => null,
			),
		),
		'leftBlockAboutImg'              => array(
			'type'    => 'object',
			'default' => array(
				'url' => null,
				'alt' => null,
			),
		),
		'leftBlockAboutAPImg'            => array(
			'type'    => 'object',
			'default' => array(
				'url' => null,
				'alt' => null,
			),
		),
		'rightBlockAboutImg'             => array(
			'type'    => 'object',
			'default' => array(
				'url' => null,
				'alt' => null,
			),
		),
		'backgroundImage'                => array(
			'type'    => 'object',
			'default' => array(
				'url' => null,
				'alt' => null,
			),
		),
		'backgroundImageTablet'          => array(
			'type'    => 'object',
			'default' => array(
				'url' => null,
				'alt' => null,
			),
		),
		'backgroundImagePhone'           => array(
			'type'    => 'object',
			'default' => array(
				'url' => null,
				'alt' => null,
			),
		),
		'backgroundImageObjectFit'       => array(
			'type'    => 'string',
			'default' => 'cover',
		),
		'backgroundImageObjectFitTablet' => array(
			'type'    => 'string',
			'default' => 'cover',
		),
		'backgroundImageObjectFitPhone'  => array(
			'type'    => 'string',
			'default' => 'cover',
		),
		'form'                           => array(
			'type'    => 'string',
			'default' => '33',
		),
	),
	'render_callback' => 'renderContactUs'
) );