<?php

function renderBlocksPosts( $block_attributes ) {
	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();

	$home_blocks_posts = [];
	if ( isset( $block_attributes['items'] ) ) {
		foreach ( $block_attributes['items'] as $key_block => $item ) {
			$title_type     = isset( $item['typeOfTitle'] ) && $item['typeOfTitle'] != '0' ? 'h' . $item['typeOfTitle'] : 'div';
			$block_category = [];
			foreach ( $item['categories'] as $item_cat ) {
				$block_category[] = $item_cat['id'];
			}
			$block_posts = [];
			foreach ( $item['articles'] as $item_article ) {
				$block_posts[] = $item_article['id'];
			}

			$home_blocks_posts[] = [
				'block_on'                => $item['enable'],
				'block_advt'              => $item['html'],
				'block_title'             => $item['postTitle'],
				'block_title_type'        => $title_type,
				'block_text'              => $item['postText'] ?? '',
				'block_category'          => $block_category,
				'block_posts'             => $block_posts,
				'block_limit'             => intval( $item['countArticles'] ),
				'block_posts_orderby'     => $item['sorting'],
				'block_post_card_type'    => $item['viewCard'],
				'block_post_card_columns' => $item['countCardsInRow'] ?? '3',
				'visibility_category'     => $item['visibleCategory'],
				'visibility_excerpt'      => $item['visibleBriefDescription'],
				'visibility_author'       => $item['visibleAuthor'],
				'visibility_date'         => $item['visibleDateOfCreate'],
				'visibility_comments'     => $item['visibleComments'],
				'visibility_views'        => $item['visibleViews'],
				'block_posts_link_custom' => $item['postCustomLink'] ?? '',
				'block_posts_link_text'   => $item['postLinkText'] ?? '',
				'block_posts_link_id' => isset( $item['postLink'] ) && isset( $item['postLink']['id'] ) ? $item['postLink']['id'] : ''
			];
		}
	}

	unset( $block_attributes['initialPosts'] );
	unset( $block_attributes['initialCategories'] );
	unset( $block_attributes['items'][0]['initialPosts'] );
	unset( $block_attributes['items'][1]['initialPosts'] );
	unset( $block_attributes['items'][2]['initialPosts'] );
	unset( $block_attributes['items'][3]['initialPosts'] );
	?>
    <div class="wp-block-wescle-blocks-posts <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php if ( $home_blocks_posts ) { ?>
				<?php get_template_part( 'template-parts/home/section', '', [ 'home_blocks_posts' => $home_blocks_posts ] ); ?>
			<?php } ?>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/blocks-posts', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderBlocksPosts'
) );