<?php

function renderServicesSlider( $block_attributes ) {
	global $post;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Услуги', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text       = $block_attributes['about'] ?? __( 'Специализируемся на услугах для малого и среднего бизнеса. Работаем с физическими и юридическими лицами. 10 лет на рынке проектирования, консалтинга и крупных поставок промышленного оборудования.', 'wescle' );
	$aboutImage = $block_attributes['aboutImg'] ?? '';
	$link       = '';
	$link_id    = $block_attributes['link'] ?? '';
	if ( $link_id ) {
		$link = get_permalink( $link_id );
	}
	$link_text = $block_attributes['allServices'] ?? __( 'Все услуги', 'wescle' );

	$post_ids = [];
	if ( isset( $block_attributes['services'] ) ) {
		foreach ( $block_attributes['services'] as $item ) {
			$post_ids[] = $item['serviceId'];
		}
	}

	$posts_per_page = 10;
	$post__in       = [];
	$orderby        = [ 'menu_order' => 'ASC', 'date' => 'DESC' ];

	if ( $post_ids ) {
		$posts_per_page = count( $post_ids );
		$post__in       = $post_ids;
		$orderby        = 'post__in';
	}

	$args          = [
		'post_type'        => 'service',
		'posts_per_page'   => $posts_per_page,
		'post__in'         => $post__in,
		'orderby'          => $orderby,
		'suppress_filters' => false
	];
	$service_posts = get_posts( $args );
	if ( ! $service_posts ) {
		return;
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	$slides_count         = $block_attributes['slidesCount'] ?? 3;
	$slider_speed         = $block_attributes['sliderSpeed'] ?? 3;
	$slider_speed         = $slider_speed * 1000;
	$slider_dots          = isset( $block_attributes['dotsVisible'] ) && ! $block_attributes['dotsVisible'] ? 'false' : 'true';
	$slider_arrows        = isset( $block_attributes['arrowsVisible'] ) && ! $block_attributes['arrowsVisible'] ? 'false' : 'true';
	$slider_arrows_mobile = isset( $block_attributes['hideArrowsMobile'] ) && ! $block_attributes['hideArrowsMobile'] ? '_hide-arrows-mobile' : '';

	ob_start();

	unset( $block_attributes['pages'] );
	unset( $block_attributes['services'] );
	?>
    <div class="wp-block-wescle-blocks-additional-services additional-services <?php echo $section_class; ?>" <?php echo $style_bg; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="additional-services__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
            <div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
                <div class="additional-services__header _section-about">
					<?php if ( $text ) { ?>
                        <div class="additional-services__about">
							<?php
							if ( $aboutImage ) {
								echo wp_get_attachment_image( $aboutImage['id'], 'medium' );
							}
							?>
                            <div class="additional-services__text"><?php echo $text; ?></div>
                        </div>
					<?php } ?>
					<?php if ( $link && $link_text ) { ?>
                        <a class="additional-services__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
					<?php } ?>
                    <div class="additional-services__buttons slider-buttons">
                        <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                        <button class="slider-buttons__item slider-buttons__item_next" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="additional-services__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
					<?php
					foreach ( $service_posts as $post ) {
						setup_postdata( $post );

						get_template_part( 'template-parts/content/service_slider', 'item', [ 'block_attributes' => $block_attributes ] );
					}
					wp_reset_postdata();
					?>
                </div>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/additional-services', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderServicesSlider'
) );