<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
* Registering blocks
*/
add_action( 'init', 'loadWesclePlugin' );
function loadWesclePlugin() {
	global $pagenow;

	// Array with blocks to register
	$wescle_blocks = [
		'wescle-blocks/advantages',
		'wescle-blocks/advantages2',
		'wescle-blocks/faq',
		'wescle-blocks/how-we-working',
		'wescle-blocks/difference',
		'wescle-blocks/seo',
		'wescle-blocks/our-partners',
		'wescle-blocks/sta',
		'wescle-blocks/about',
		'wescle-blocks/contact-us',
		'wescle-blocks/requirements',
		'wescle-blocks/team',
		'wescle-blocks/services',
		'wescle-blocks/products',
		'wescle-blocks/attention',
		'wescle-blocks/time-left',
		'wescle-blocks/events',
		'wescle-blocks/work-performed',
		'wescle-blocks/our-works',
		'wescle-blocks/schedule-block',
		'wescle-blocks/packages-include',
		'wescle-blocks/reviews',
		'wescle-blocks/instruction',
		'wescle-blocks/price-list',
		'wescle-blocks/tarif-plan',
		'wescle-blocks/stories',
		'wescle-blocks/plus-minus',
		'wescle-blocks/videos-slider',
		'wescle-blocks/highlight-tabs',
		'wescle-blocks/information-banner',
		'wescle-blocks/sta-centered',
		'wescle-blocks/services2',
		'wescle-blocks/goods-banners',
		'wescle-blocks/store-products',
		'wescle-blocks/blocks-posts',
		'wescle-blocks/team2',
		'wescle-blocks/team3',
		'wescle-blocks/how-we-working2',
		'wescle-blocks/videos-section',
		'wescle-blocks/videos-max',
		'wescle-blocks/sta-minimal',
		'wescle-blocks/additional-services',
		'wescle-blocks/payment-methods',
		'wescle-blocks/performance',
		'wescle-blocks/licenses',
		'wescle-blocks/checklist',
		'wescle-blocks/about-2',
		'wescle-blocks/information',
		'wescle-blocks/reviews-2',
		'wescle-blocks/partners',

		//? new
		'wescle-blocks/wescle-catalog',
		'wescle-blocks/wescle-catalog-advantages',
		'wescle-blocks/wescle-catalog-options',
		'wescle-blocks/store-products-tabs',
		'wescle-blocks/info-tabs',
		'wescle-blocks/mosaic-tile',
		'wescle-blocks/wescle-categories',
	];

	$dev_mode = false;
	if ( is_admin() && ( 'post.php' === $pagenow || 'post-new.php' === $pagenow ) ) {
		$dev_mode = true;
	}

	if ( $dev_mode ) {
		add_action( 'admin_footer', function () {
			echo '<style>';
			$woo_fonts_assets = get_template_directory_uri() . '/assets/fonts';
			echo '@font-face {
              font-family: star;
              src: url(' . $woo_fonts_assets . '/star.eot);
              src: url(' . $woo_fonts_assets . '/star.eot?#iefix) format("embedded-opentype"), url(' . $woo_fonts_assets . '/star.woff) format("woff"), url(' . $woo_fonts_assets . '/star.ttf) format("truetype"), url(' . $woo_fonts_assets . '/star.svg#star) format("svg");
              font-weight: 400;
              font-style: normal
            }';

			$font_family = get_theme_mod( 'font_family', [] );
			if ( $font_family && $font_family['font-family'] != 'Montserrat' ) {
				$font_data = wescle_get_font_data();
				if ( isset( $font_data[ $font_family['font-family'] ] ) ) {
					$font = $font_data[ $font_family['font-family'] ][0];

					foreach ( $font_data[ $font_family['font-family'] ] as $font_weight ) {
						if ( ! is_numeric( $font_weight ) ) {
							continue;
						}
						$dir = get_template_directory_uri() . '/assets'
						?>
                        @font-face {
                        font-family: "<?php echo $font_family['font-family']; ?>";
                        font-display: swap;
                        src: url("<?php echo $dir; ?>/fonts/<?php echo $font; ?>/<?php echo $font; ?>-<?php echo $font_weight; ?>.woff2") format("woff2");
                        font-weight: <?php echo $font_weight; ?>;
                        font-style: normal;
                        }
						<?php
					}
				}

				echo '.editor-styles-wrapper{font-family: "' . $font_family['font-family'] . '", sans-serif !important;}';
			}

			$border_radius = intval( get_theme_mod( 'site_border_radius', 10 ) );
			if ( $border_radius != 10 ) {
				?>
                :root{--mainBorderRadius:<?php echo $border_radius; ?>px}
				<?php
			}
			$color = get_theme_mod( 'primary_color', '#0088cc' );
			if ( $color != '#0088cc' ) {
				?>
                :root{--color-accent:<?php echo $color; ?>}
				<?php
			}
			if ( get_theme_mod( 'module_catalog_enabled' ) ) {
				$size = get_theme_mod( 'module_catalog_info_img_size' );
				if ( 24 != $size ) {
					echo ".wescle-catalog-description-item img{width:{$size}px !important; height:{$size}px !important; flex-basis:{$size}px !important;}";
				}
			}
			echo Core::get_css_buttons();
			echo '</style>';
		} );
	}

	add_action( 'wp_head', function () {
		global $post;

		$styles = [];

		if ( Helper::isset_block_content( 'blocks-posts' ) ) {
			$parse_content = parse_blocks( $post->post_content );
			foreach ( $parse_content as $item ) {
				if ( $item['blockName'] == 'wescle-blocks/blocks-posts' ) {
					$color_title = $item['attrs']['titleColor'] ?? '';
					if ( $color_title ) {
						$styles[] = '.wp-block-wescle-blocks-posts .title{color:' . $color_title . '}';
					}
					if ( isset( $item['attrs']['items'] ) ) {
						foreach ( $item['attrs']['items'] as $key_block => $item ) {
							if ( $item['percentOverlay'] && $item['percentOverlay'] != 1 ) {
								$styles[] = '.wp-block-wescle-blocks-posts .featured-' . $key_block . ' .image-overlay_gradient:before{opacity:' . $item['percentOverlay'] . '}';
							}
						}
					}
				}
			}
		}

		if ( Helper::isset_block_content( 'reviews' ) ) {
			$parse_content = parse_blocks( $post->post_content );
			foreach ( $parse_content as $item ) {
				if ( $item['blockName'] == 'wescle-blocks/reviews' ) {
					$text_height = $item['attrs']['height'] ?? 300;
					$styles[]    = '.reviews-slider-item__body{max-height:' . $text_height . 'px}';
				}
			}
		}

		if ( Helper::isset_block_content( 'products' ) ) {
			$parse_content        = parse_blocks( $post->post_content );
			$block_products_count = 0;
			foreach ( $parse_content as $item ) {
				if ( $item['blockName'] == 'wescle-blocks/products' ) {
					$block_products_count ++;

					$block_attributes = $item['attrs'];

					if ( ! isset( $block_attributes['gColors'] ) ) {
						$block_attributes['gColors'] = [
							[
								'r' => 250,
								'g' => 26,
								'b' => 190,
								'a' => 0.5,
							],
							[
								'r' => 238,
								'g' => 189,
								'b' => 159,
								'a' => 0.5,
							],
						];
					}

					$opacity = $block_attributes['gColors'][0]['a'];

					$r1 = $block_attributes['gColors'][0]['r'];
					$g1 = $block_attributes['gColors'][0]['g'];
					$b1 = $block_attributes['gColors'][0]['b'];

					$r2 = $block_attributes['gColors'][1]['r'];
					$g2 = $block_attributes['gColors'][1]['g'];
					$b2 = $block_attributes['gColors'][1]['b'];

					$block_class = 'products-section-' . $block_products_count;

					$styles[] = ".$block_class .products-section-item__img:before{background:-o-linear-gradient(125deg,rgba($r2,$g2,$b2,$opacity) 0,rgba($r1,$g1,$b1,$opacity) 90%);
    background: linear-gradient(-35deg,rgba($r2,$g2,$b2,$opacity) 0,rgba($r1,$g1,$b1,$opacity) 90%);}";


					$blur     = $block_attributes['gBlur'] ?? 10;
					$styles[] = ".$block_class .products-section-item__img:before{-webkit-filter: blur({$blur}px);filter: blur({$blur}px);}";
				}
			}
		}

		if ( $styles ) {
			echo '<style id="wescle-blocks-css">' . implode( '', $styles ) . '</style>';
		}
	} );

	foreach ( $wescle_blocks as $block ) {
		$block_name = explode( '/', $block )[1];

		$block_path = __DIR__ . '/src/blocks/' . $block_name . '/block.php';

		if ( file_exists( $block_path ) ) {
			require_once $block_path;
			continue;
		}

		register_block_type( $block, array(
			'style'         => 'wescle-blocks-style',
			'editor_script' => 'wescle-blocks',
			'editor_style'  => 'wescle-blocks-editor-style'
		) );
	}
}

/*
* Loading scripts, styles
*/
add_action( 'enqueue_block_editor_assets', 'wescle_block_editor_scripts' );
function wescle_block_editor_scripts() {
	$version = THEME_VERSION;
	if ( defined( 'WESCLE_BLOCKS_DEVELOPER' ) && WESCLE_BLOCKS_DEVELOPER ) {
		$version = time();
	}

	wp_enqueue_script(
		'wescle-blocks-common',
		get_template_directory_uri() . '/assets/js/pages/common.min.js',
		array( 'jquery' ),
		$version
	);

	wp_enqueue_script(
		'wescle-blocks-main',
		get_template_directory_uri() . '/assets/js/main.min.js',
		array( 'jquery' ),
		$version
	);

	wp_enqueue_script(
		'wescle-blocks-main-developer',
		get_template_directory_uri() . '/assets/js/main-developer.min.js',
		array( 'jquery' ),
		$version
	);

	wp_enqueue_script(
		'wescle-blocks',
		get_template_directory_uri() . '/includes/wescle-blocks/dist/blocks.build.js',
		array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-block-editor' ),
		$version
	);
	wp_set_script_translations( 'wescle-blocks', 'wescle-blocks', get_template_directory() . '/includes/wescle-blocks/languages' );


	$server_data = apply_filters( 'wescle_blocks_server_data', array(
		'admin_url'               => admin_url( '/' ),
		'theme_uri'               => get_template_directory_uri(),
		'rtl'                     => is_rtl() ? 1 : '',
		'is_wc'                   => Helper::is_woocommerce_active() ? 1 : '',
		'catalog_gallery_enabled' => intval( get_theme_mod( 'module_catalog_gallery_enabled' ) ) ? 1 : '',
	) );
	wp_localize_script( 'wescle-blocks', 'wescle_blocks_server_data', $server_data );

	wp_enqueue_style( 'wescle-blocks-bootstrap1', get_template_directory_uri() . '/assets/libs/bootstrap/dist/css/bootstrap-reboot.min.css' );
	wp_enqueue_style( 'wescle-blocks-bootstrap2', get_template_directory_uri() . '/assets/libs/bootstrap/dist/css/bootstrap-grid.min.css' );

	wp_register_style(
		'wescle-blocks-editor-style',
		get_template_directory_uri() . '/includes/wescle-blocks/dist/blocks.editor.build.css',
		array( 'wp-edit-blocks' ),
		$version
	);

	wp_register_style(
		'wescle-blocks-style',
		get_template_directory_uri() . '/includes/wescle-blocks/dist/blocks.style.build.css',
		array( 'wp-edit-blocks' ),
		$version
	);

	//if ( ! is_customize_preview() ) {
	wp_enqueue_style( 'wescle-blocks-main', get_template_directory_uri() . '/assets/css/main.min.css', array( 'wp-edit-blocks' ) );
	if ( is_rtl() ) {
		wp_enqueue_style( 'wescle-blocks-main-rtl', get_template_directory_uri() . '/assets/css/main-rtl.min.css', array( 'wp-edit-blocks' ) );
	}
	wp_enqueue_style( 'wescle-blocks-main-developer', get_template_directory_uri() . '/assets/css/main-developer.min.css', array( 'wp-edit-blocks' ) );
	//}

	if ( Helper::is_woocommerce_active() ) {
		wp_enqueue_style( 'wescle-blocks-main-store', get_template_directory_uri() . '/assets/css/main-store.min.css', array( 'wp-edit-blocks' ) );
		if ( is_rtl() ) {
			wp_enqueue_style( 'wescle-blocks-main-store-rtl', get_template_directory_uri() . '/assets/css/main-store-rtl.min.css', array( 'wp-edit-blocks' ) );
		}
		wp_enqueue_style( 'wescle-blocks-main-store-developer', get_template_directory_uri() . '/assets/css/main-developer_woo.min.css', array( 'wp-edit-blocks' ) );
	}
}

/*
* Creating rest api endpoint to get services
*/
add_action( 'rest_api_init', 'loadWescleRestAPI', 10, 1 );
function loadWescleRestAPI() {
	// Получение услуг из бд
	register_rest_route( 'wescle-blocks', '/get-services', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'service',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				if ( $post->post_excerpt ) {
					$content = $post->post_excerpt;
				}
				else {
					$content = Helper::short_string( wp_strip_all_tags( $post->post_content ), 50 );
				}

				$icon_url = '';
				if ( $img_id = get_post_meta( $post->ID, 'service_icon', 1 ) ) {
					$icon_url = wp_get_attachment_url( $img_id );
				}

				$formed_posts[] = array(
					'id'          => $post->ID,
					'name'        => $post->post_title,
					'image'       => get_the_post_thumbnail_url( $post ),
					'icon'        => $icon_url,
					'content'     => trim( $content ),
					'price'       => get_post_meta( $post->ID, 'price', 1 ),
					'price_old'   => get_post_meta( $post->ID, 'price_old', 1 ),
					'post_url'    => get_permalink( $post->ID ),
					'button_text' => get_post_meta( $post->ID, 'button_text', 1 ),
					'button_link' => get_post_meta( $post->ID, 'button_link', 1 ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение товаров из бд
	register_rest_route( 'wescle-blocks', '/get-products', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'product_wescle',
				'orderby'     => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				if ( $post->post_excerpt ) {
					$content = $post->post_excerpt;
				}
				else {
					$content = Helper::short_string( wp_strip_all_tags( $post->post_content ), 50 );
				}

				$formed_posts[] = array(
					'id'               => $post->ID,
					'name'             => $post->post_title,
					'image'            => get_the_post_thumbnail_url( $post ),
					'content'          => trim( $content ),
					'price'            => get_post_meta( $post->ID, 'price', 1 ),
					'price_old'        => get_post_meta( $post->ID, 'price_old', 1 ),
					'button_text'      => get_post_meta( $post->ID, 'button_text', 1 ),
					'button_url'       => get_post_meta( $post->ID, 'button_url', 1 ),
					'post_url'         => get_permalink( $post->ID ),
					'gradient_disable' => get_post_meta( $post->ID, 'gradient_disable', 1 )
				);
			}

			return $formed_posts;
		},
	) );

	// Получение категорий товаров из бд
	register_rest_route( 'wescle-blocks', '/get-productcat_wescle', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$terms = get_terms( [
				'taxonomy' => 'productcat_wescle',
			] );

			$formed_terms = [];

			foreach ( $terms as $term ) {
				$post_ids = get_posts( [
					'post_type'      => '',
					'posts_per_page' => 20,
					'tax_query'      => [
						[
							'taxonomy' => $term->taxonomy,
							'terms'    => [ $term->term_id ],
						]
					],
					'fields'         => 'ids'
				] );

				$formed_terms[] = array(
					'id'    => $term->term_id,
					'name'  => $term->name,
					'items' => $post_ids
				);
			}

			return $formed_terms;
		},
	) );

	// Получение ивентов из бд
	register_rest_route( 'wescle-blocks', '/get-events', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'event_wescle',
				'orderby'     => [ 'meta_value_num' => 'ASC', 'menu_order' => 'ASC' ],
				'meta_query'  => [
					[
						'key'     => 'event_date',
						'value'   => current_time( 'Ymd' ),
						'compare' => '>=',
						'type'    => 'NUMERIC'
					]
				],
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				if ( $post->post_excerpt ) {
					$content = $post->post_excerpt;
				}
				else {
					$content = Helper::short_string( wp_strip_all_tags( $post->post_content ), 150 );
				}

				$formed_posts[] = array(
					'id'         => $post->ID,
					'name'       => $post->post_title,
					'image'      => get_the_post_thumbnail_url( $post ),
					'content'    => trim( $content ),
					'post_url'   => get_permalink( $post->ID ),
					'event_date' => get_post_meta( $post->ID, 'event_date', 1 ),
					'event_info' => get_post_meta( $post->ID, 'event_info', 1 ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение работ из бд
	register_rest_route( 'wescle-blocks', '/get-works', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'portfolio_wescle',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				if ( $post->post_excerpt ) {
					$content = $post->post_excerpt;
				}
				else {
					$content = Helper::short_string( wp_strip_all_tags( $post->post_content ), 50 );
				}

				$formed_posts[] = array(
					'id'       => $post->ID,
					'name'     => $post->post_title,
					'image'    => get_the_post_thumbnail_url( $post ),
					'content'  => trim( $content ),
					'post_url' => get_permalink( $post->ID ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение галереи из бд
	register_rest_route( 'wescle-blocks', '/get-gallery', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'gallery_wescle',
				'orderby'     => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$content = $post->post_content;

				$post_terms = wp_get_post_terms( $post->ID, 'gallerycat_wescle' );
				$terms      = [];
				foreach ( $post_terms as $term ) {
					$terms[] = $term->term_id;
				}

				$formed_posts[] = array(
					'id'         => $post->ID,
					'name'       => $post->post_title,
					'image'      => get_the_post_thumbnail_url( $post ),
					'content'    => trim( $content ),
					'categories' => $terms,
					'post_url'   => get_permalink( $post->ID ),
				);
			}

			return $formed_posts;
		}
	) );

	register_rest_route( 'wescle-blocks', '/get-gallery-categories', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$terms = get_terms( [
				'taxonomy' => 'gallerycat_wescle',
			] );

			$formed_terms = [];

			foreach ( $terms as $term ) {
				$formed_terms[] = array(
					'id'   => $term->term_id,
					'name' => $term->name,
				);
			}

			return $formed_terms;
		},
	) );

	// Получение пакетов из бд
	register_rest_route( 'wescle-blocks', '/get-packages', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts'      => 20,
				'post_type'        => 'pricepackage_wescle',
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'suppress_filters' => false
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {

				$formed_posts[] = array(
					'id'                 => $post->ID,
					'name'               => $post->post_title,
					'price'              => get_post_meta( $post->ID, 'price', 1 ),
					'price_old'          => get_post_meta( $post->ID, 'price_old', 1 ),
					'label_after_button' => get_post_meta( $post->ID, 'label_after_button', 1 ),
					'block_color'        => get_post_meta( $post->ID, 'block_color', 1 ),
					'button_url'         => get_post_meta( $post->ID, 'button_url', 1 ),
				);
			}

			return $formed_posts;
		},
	) );

	register_rest_route( 'wescle-blocks', '/get-packages-options', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts'      => 20,
				'post_type'        => 'optionpackage_wescle',
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'suppress_filters' => false
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {

				$formed_posts[] = array(
					'id'                => $post->ID,
					'name'              => $post->post_title,
					'price_package_ids' => get_post_meta( $post->ID, 'price_package_ids', 1 ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение программ
	register_rest_route( 'wescle-blocks', '/get-programs', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'program_wescle',
				'orderby'     => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$formed_posts[] = array(
					'id'         => $post->ID,
					'name'       => $post->post_title,
					'image'      => get_the_post_thumbnail_url( $post ),
					'content'    => trim( apply_filters( 'the_content', $post->post_content ) ),
					'post_url'   => get_post_permalink( $post->ID ),
					'is_bonus'   => get_post_meta( $post->ID, 'is_bonus', 1 ),
					'sub_title'  => get_post_meta( $post->ID, 'sub_title', 1 ),
					'speaker_id' => get_post_meta( $post->ID, 'speacker_id', 1 ),
				);
			}

			return $formed_posts;
		},
	) );
	// Получение спикеров
	register_rest_route( 'wescle-blocks', '/get-speakers', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'speaker_program',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$formed_posts[] = array(
					'id'       => $post->ID,
					'name'     => $post->post_title,
					'image'    => get_the_post_thumbnail_url( $post ),
					'content'  => trim( apply_filters( 'the_content', $post->post_content ) ),
					'post_url' => get_post_permalink( $post->ID ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение пакетов
	register_rest_route( 'wescle-blocks', '/get-packages', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts'      => 20,
				'post_type'        => 'pricepackage_wescle',
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'suppress_filters' => false
			) );

			$options = get_posts( array(
				'numberposts'      => 20,
				'post_type'        => 'optionpackage_wescle',
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'suppress_filters' => false
			) );

			$formed_posts            = [];
			$formed_posts['prices']  = [];
			$formed_posts['options'] = [];

			foreach ( $posts as $post ) {
				$formed_posts['prices'][] = array(
					'id'                 => $post->ID,
					'name'               => $post->post_title,
					'image'              => get_the_post_thumbnail_url( $post ),
					'price'              => get_post_meta( $post->ID, 'price', 1 ),
					'price_old'          => get_post_meta( $post->ID, 'price_old', 1 ),
					'label_after_button' => get_post_meta( $post->ID, 'label_after_button', 1 ),
					'block_color'        => get_post_meta( $post->ID, 'block_color', 1 ),
					'button_url'         => get_post_meta( $post->ID, 'button_url', 1 ),
					'post_url'           => get_post_permalink( $post->ID ),
					'options'            => $options,
				);
			}

			foreach ( $options as $post ) {
				$formed_posts['options'][] = array(
					'id'                => $post->ID,
					'name'              => $post->post_title,
					'price_package_ids' => get_post_meta( $post->ID, 'price_package_ids', 1 ),
					'post_url'          => get_post_permalink( $post->ID ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение отзывов
	register_rest_route( 'wescle-blocks', '/get-reviews/(?P<orderby>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$orderby = $request['orderby'];

			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'review',
				'orderby'     => $orderby
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$formed_posts[] = array(
					'id'                 => $post->ID,
					'name'               => $post->post_title,
					'image'              => get_the_post_thumbnail_url( $post ),
					'content'            => trim( $post->post_content ),
					'position'           => get_post_meta( $post->ID, 'sub_title', 1 ),
					'date'               => get_post_meta( $post->ID, 'date_review', 1 ),
					'rating'             => get_post_meta( $post->ID, 'rating', 1 ),
					'rating_after_title' => get_post_meta( $post->ID, 'rating_after_title', 1 ),
					'source'             => get_post_meta( $post->ID, 'source', 1 ),
					'youtube_link'       => get_post_meta( $post->ID, 'youtube_link', 1 ),
					'thumbnail_video'    => get_post_meta( $post->ID, 'thumbnail_video', 1 ),
					'post_url'           => get_post_permalink( $post->ID ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение видео-отзывов
	register_rest_route( 'wescle-blocks', '/get-videoreviews/(?P<orderby>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$orderby = $request['orderby'];

			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'videoreview',
				'orderby'     => $orderby
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$formed_posts[] = array(
					'id'           => $post->ID,
					'name'         => $post->post_title,
					'image'        => get_the_post_thumbnail_url( $post ),
					'content'      => trim( $post->post_content ),
					'youtube_link' => get_post_meta( $post->ID, 'youtube_link', 1 ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение прайсов
	register_rest_route( 'wescle-blocks', '/get-price-list', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'price_wescle',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$formed_posts[] = array(
					'id'       => $post->ID,
					'name'     => $post->post_title,
					'content'  => trim( $post->post_content ),
					'post_url' => get_post_permalink( $post->ID ),
					'is_open'  => intval( get_post_meta( $post->ID, 'is_open', 1 ) ),
				);
			}

			return $formed_posts;
		},
	) );
	// Получение видео для каруселей, для "Видео" блока, для "Видео MAX"
	register_rest_route( 'wescle-blocks', '/get-videos-carousel', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'video_wescle',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				if ( $post->post_excerpt ) {
					$text = $post->post_excerpt;
				}
				else {
					$text = wp_strip_all_tags( $post->post_content );
				}
				$text  = Helper::short_string( $text, 150 );
				$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'medium_large' );

				$formed_posts[] = array(
					'id'             => $post->ID,
					'name'           => $post->post_title,
					'content'        => '', //trim( $post->post_content ),
					'post_url'       => get_post_permalink( $post->ID ),
					'post_thumb'     => get_the_post_thumbnail( $post->ID, 'medium_large' ),
					'comment_count'  => $post->comment_count,
					'comment_status' => $post->comment_status,
					'post_excerpt'   => $post->post_excerpt,
					'time_duration'  => get_post_meta( $post->ID, 'time_duration', 1 ),
					'views'          => get_post_meta( $post->ID, 'views', 1 ),
					'custom_views'   => get_post_meta( $post->ID, 'custom_views', 1 ),
					'custom_url'     => get_post_meta( $post->ID, 'custom_url', 1 ),
					'play_tooltip'   => get_post_meta( $post->ID, 'play_tooltip', 1 ),
					'info_tooltip'   => get_post_meta( $post->ID, 'info_tooltip', 1 ),
					'youtube_link'   => Helper::get_youtube_video_id( get_post_meta( $post->ID, 'youtube_link', 1 ) ),
					'text'           => $text,
					'image'          => $image ? $image[0] : ''
				);
			}

			return $formed_posts;
		},
	) );

	// Получение Табов
	register_rest_route( 'wescle-blocks', '/get-highlight-tabs', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'tab_wescle',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$tabs_items        = get_post_meta( $post->ID, 'wescle_tab_info', 1 );
				$formed_tabs_items = [];
				foreach ( $tabs_items as $key => $item ) {
					$formed_tabs_items[ $key ]          = $item;
					$formed_tabs_items[ $key ]['image'] = wp_get_attachment_url( $item['img_id'] );
				}
				$formed_posts[] = array(
					'id'        => $post->ID,
					'name'      => $post->post_title,
					'content'   => trim( $post->post_content ),
					'tabsItems' => $formed_tabs_items,
				);
			}

			return $formed_posts;
		},
	) );

	register_rest_route( 'wescle-blocks', '/get-infotabs', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'infotab_wescle',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$data_rgb     = '';
				$data_tooltip = '';

				$color = get_post_meta( $post->ID, 'color_active', 1 );
				if ( $color ) {
					list( $r, $g, $b ) = sscanf( $color, "#%02x%02x%02x" );
					$data_rgb = $r . ',' . $g . ',' . $b;
				}

				$tooltip = get_post_meta( $post->ID, 'tooltip', 1 );
				if ( $tooltip ) {
					$data_tooltip = $tooltip;
				}

				$icon_image = wp_get_attachment_image_url( get_post_meta( $post->ID, 'icon', 1 ), 'medium' );

				$infotab_info        = get_post_meta( $post->ID, 'infotab_info', 1 );
				$formed_infotab_info = [];
				foreach ( $infotab_info as $key => $item ) {
					$formed_infotab_info[ $key ]          = $item;
					$formed_infotab_info[ $key ]['image'] = wp_get_attachment_url( $item['img_id'] );
				}

				$title      = get_post_meta( $post->ID, 'custom_title', 1 );
				$title_type = get_post_meta( $post->ID, 'title_type', 1 );
				$text       = apply_filters( 'the_content', $post->post_content );

				$data_images    = [];
				$gallery_images = get_post_meta( $post->ID, 'gallery_images', 1 );
				if ( $gallery_images ) {
					foreach ( $gallery_images as $item ) {
						$html = '<div class="info-tabs-slide">';
						$html .= '<a href="' . $item['url'] . '">' . wp_get_attachment_image( $item['img_id'], 'medium_large' ) . '</a>';
						if ( $item['title'] ) {
							$html .= '<div class="info-tabs-slide__title">' . $item['title'] . '</div>';
						}
						$html .= '</div>';

						$data_images[] = $html;
					}
				}

				$is_slider     = get_post_meta( $post->ID, 'gallery_slider', 1 );
				$slider_arrows = get_post_meta( $post->ID, 'slider_arrows', 1 );
				$slider_dots   = get_post_meta( $post->ID, 'slider_dots', 1 ) ? 'true' : '';
				$slider_count  = floatval( get_post_meta( $post->ID, 'slider_count', 1 ) );
				if ( ! $slider_count ) {
					$slider_count = 5;
				}

				$button_text  = get_post_meta( $post->ID, 'button_text', 1 );
				$button_url   = get_post_meta( $post->ID, 'button_link', 1 );
				$target_blank = get_post_meta( $post->ID, 'button_link_is_blank', 1 ) ? 'target="_blank" rel="noopener noreferrer"' : '';

				$formed_posts[] = array(
					'id'            => $post->ID,
					'name'          => $post->post_title,
					'tab_atts'      => [],
					'data_rgb'      => $data_rgb,
					'data_tooltip'  => $data_tooltip,
					'icon_image'    => $icon_image,
					'title'         => trim( $title ),
					'title_type'    => $title_type,
					'text'          => $text,
					'is_slider'     => $is_slider,
					'slider_arrows' => $slider_arrows,
					'slider_dots'   => $slider_dots,
					'slider_count'  => $slider_count,
					'data_images'   => $data_images,
					'info'          => $formed_infotab_info,
					'button_text'   => $button_text,
					'button_url'    => $button_url,
					'target_blank'  => $target_blank,
				);
			}

			return $formed_posts;
		},
	) );

	// Получение людей из команды
	register_rest_route( 'wescle-blocks', '/get-team-3', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'team_wescle',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$formed_posts[] = array(
					'id'           => $post->ID,
					'name'         => $post->post_title,
					'image'        => get_the_post_thumbnail_url( $post ),
					'content'      => trim( $post->post_content ),
					'position'     => get_post_meta( $post->ID, 'position', 1 ),
					'email'        => get_post_meta( $post->ID, 'email', 1 ),
					'phone'        => get_post_meta( $post->ID, 'phone', 1 ),
					'link_fb'      => get_post_meta( $post->ID, 'link_fb', 1 ),
					'link_twitter' => get_post_meta( $post->ID, 'link_twitter', 1 ),
					'link_inst'    => get_post_meta( $post->ID, 'link_inst', 1 ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение настроек кнопок
	register_rest_route( 'wescle-blocks', '/get-button-type', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$options = [
				'goods-banners' => get_theme_mod( 'woo_banner_button_type' ) == 'animation' ? 'btn-flare' : '',
				'catalog'       => get_theme_mod( 'catalog_button_type' ) == 'animation' ? 'btn-flare' : ''
			];

			return $options;
		},
	) );

	// Получение постов из инструкций
	register_rest_route( 'wescle-blocks', '/get-instruction-posts', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {

			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'faq_wescle',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$category = get_the_terms( $post, 'faqcat_wescle' );
				if ( is_wp_error( $category ) || ! $category ) {
					$category = [];
				}

				$formed_posts[] = array(
					'id'            => $post->ID,
					'name'          => $post->post_title,
					'image'         => get_the_post_thumbnail_url( $post ),
					'content'       => get_the_content( null, false, $post ),
					'category_name' => $category[0]->name,
					'categories'    => array_map( 'wescle_get_term_id', $category ),
					'post_url'      => '',
				);
			}

			return $formed_posts;
		},
	) );

	// Получение категорий инструкций
	register_rest_route( 'wescle-blocks', '/get-instruction-categories', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$terms = get_tags( [
				'taxonomy' => 'faqcat_wescle',
			] );

			$formed_posts = [];

			foreach ( $terms as $term ) {
				$formed_posts[] = array(
					'id'   => $term->term_id,
					'name' => $term->name,
				);
			}

			return $formed_posts;
		},
	) );

	// Получение записей из бд
	register_rest_route( 'wescle-blocks', '/get-posts', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'posts_per_page'   => 20,
				'post_type'        => 'post',
				'suppress_filters' => false
			) );

			return wescle_get_formed_posts( $posts );
		},
	) );

	// Получение записей из бд
	register_rest_route( 'wescle-blocks', '/get-posts-orderby/(?P<orderby>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$term_ids = [];
			if ( strpos( $request['orderby'], 'terms' ) !== false ) {
				$request_arr   = explode( '&', $request['orderby'] );
				$posts_orderby = $request_arr[0];
				$term_ids      = explode( ',', str_replace( 'terms=', '', $request_arr[1] ) );
			}
			else {
				$posts_orderby = $request['orderby'];
			}

			$args = array(
				'posts_per_page'   => 20,
				'post_type'        => 'post',
				'suppress_filters' => false
			);

			if ( $posts_orderby == 'views' ) {
				if ( Helper::is_plugin_active( 'post-views-counter/post-views-counter.php' ) ) {
					$args['suppress_filters'] = false;
					$args['orderby']          = 'post_views';
					$args['fields']           = '';
					$args['meta_key']         = '';
				}
				else {
					$args['orderby']  = 'meta_value_num';
					$args['order']    = 'DESC';
					$args['meta_key'] = 'views';
				}
			}
			else {
				$args['orderby'] = $posts_orderby;
			}

			if ( $term_ids ) {
				$args['tax_query'] = [
					[
						'taxonomy' => 'category',
						'terms'    => $term_ids
					]
				];
			}

			$posts = get_posts( $args );

			return wescle_get_formed_posts( $posts );
		},
	) );

	register_rest_route( 'wescle-blocks', '/get-post/(?P<id>[\d]+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'post__in'  => [ $request['id'] ],
				'post_type' => 'post',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				if ( $post->post_excerpt ) {
					$content = $post->post_excerpt;
				}
				else {
					$content = Helper::short_string( wp_strip_all_tags( $post->post_content ), 150 );
				}

				$category = get_the_terms( $post, 'category' );
				if ( is_wp_error( $category ) || ! $category ) {
					$category = [];
				}

				$formed_posts[] = array(
					'id'         => $post->ID,
					'name'       => $post->post_title,
					'image'      => get_the_post_thumbnail_url( $post ),
					'content'    => trim( $content ),
					'categories' => array_map( 'wescle_get_term_id', $category ),
					'post_url'   => get_permalink( $post->ID ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение категорий записей
	register_rest_route( 'wescle-blocks', '/get-post-categories', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$terms = get_tags( [
				'taxonomy' => 'category',
			] );

			$formed_posts = [];

			foreach ( $terms as $term ) {
				$formed_posts[] = array(
					'id'   => $term->term_id,
					'name' => $term->name,
					'url'  => get_term_link( $term ),
				);
			}

			return $formed_posts;
		},
	) );

	// Получение Woo товаров из бд
	register_rest_route( 'wescle-blocks', '/get-woo-products', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			if ( ! Helper::is_woocommerce_active() ) {
				return [];
			}

			$posts = get_posts( array(
				'posts_per_page'   => 20,
				'post_type'        => 'product',
				'suppress_filters' => false
			) );

			return wescle_get_formed_products( $posts );
		},
	) );

	register_rest_route( 'wescle-blocks', '/get-woo-products-orderby/(?P<orderby>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			if ( ! Helper::is_woocommerce_active() ) {
				return [];
			}

			$limit         = 10;
			$products_type = $request['orderby'];

			$product_args = [
				'post_type'        => 'product',
				'posts_per_page'   => $limit,
				'tax_query'        => [],
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'suppress_filters' => false
			];

			if ( 'custom' == $products_type ) {
				return [];
			}
			if ( 'new' == $products_type ) {
				$product_args['orderby'] = [ 'date' => 'DESC' ];
			}
			if ( 'sale' == $products_type ) {
				$product_args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
				$product_args['orderby']  = 'post__in';
			}
			if ( 'views' == $products_type ) {
				$product_args['meta_key'] = 'views';
				$product_args['orderby']  = [ 'meta_value_num' => 'DESC' ];

				if ( Helper::is_plugin_active( 'post-views-counter/post-views-counter.php' ) ) {
					$product_args['suppress_filters'] = false;
					$product_args['orderby']          = 'post_views';
					$product_args['fields']           = '';
					$product_args['meta_key']         = '';
				}
			}
			if ( 'popular' == $products_type ) {
				$product_args['meta_key'] = 'total_sales';
				$product_args['orderby']  = [ 'meta_value_num' => 'DESC' ];
			}

			$posts_product = get_posts( apply_filters( 'woo_block_products_args', $product_args ) );

			return wescle_get_formed_products( $posts_product );
		},
	) );

	register_rest_route( 'wescle-blocks', '/get-woo-products-by-cats/(?P<term_ids>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			if ( ! Helper::is_woocommerce_active() ) {
				return [];
			}

			$limit = 10;

			$product_args = [
				'post_type'        => 'product',
				'posts_per_page'   => $limit,
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'tax_query'        => [
					[
						'taxonomy' => 'product_cat',
						'terms'    => explode( ',', str_replace( ' ', '', urldecode( $request['term_ids'] ) ) )
					]
				],
				'suppress_filters' => false
			];

			$posts_product = get_posts( $product_args );

			return wescle_get_formed_products( $posts_product );
		},
	) );

	register_rest_route( 'wescle-blocks', '/get-woo-product/(?P<id>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			if ( ! Helper::is_woocommerce_active() ) {
				return [];
			}

			$posts = get_posts( array(
				'post__in'  => explode( ',', str_replace( ' ', '', urldecode( $request['id'] ) ) ),
				'post_type' => 'product',
			) );

			return wescle_get_formed_products( $posts );
		},
	) );

	// Получение категорий товаров
	register_rest_route( 'wescle-blocks', '/get-product-categories', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			if ( ! Helper::is_woocommerce_active() ) {
				return [];
			}

			$terms = get_tags( [
				'taxonomy' => 'product_cat',
			] );

			$formed_posts = [];

			foreach ( $terms as $term ) {
				if ( $thumbnail_id = get_term_meta( $term->term_id, 'thumbnail_id', true ) ) {
					$image = wp_get_attachment_url( $thumbnail_id );
				}
				else {
					$image = WC()->plugin_url() . '/assets/images/placeholder.png';
				}

				$formed_posts[] = array(
					'id'    => $term->term_id,
					'name'  => $term->name,
					'url'   => get_term_link( $term ),
					'image' => $image,
					'count' => $term->count,
				);
			}

			return $formed_posts;
		},
	) );

	// Получение лицензий
	register_rest_route( 'wescle-blocks', '/get-license-posts', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'license_wescle',
				'orderby'     => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$content    = $post->post_content;
				$post_terms = wp_get_post_terms( $post->ID, 'licensecat_wescle', array( 'fields' => 'ids' ) );

				$related_product_id = intval( get_post_meta( $post->ID, 'related_product', 1 ) );
				if ( $related_product_id && Helper::is_woocommerce_active() ) {
					$regular_price = $sale_price = '';

					$related_product = wc_get_product( $related_product_id );
					if ( $related_product ) {
						$regular_price = wc_price( $related_product->get_regular_price() );
						$sale_price    = $related_product->get_sale_price() ? wc_price( $related_product->get_sale_price() ) : '';
					}
				}
				else {
					$regular_price = strip_tags( get_post_meta( $post->ID, 'price', 1 ) );
					$sale_price    = get_post_meta( $post->ID, 'sale_price', 1 );
				}

				$url = trim( get_post_meta( $post->ID, 'button_url', 1 ) );
				if ( ! $url || $url == '#' ) {
					if ( $related_product_id && $related_product ) {
						$url = get_permalink( $related_product_id );
					}
					else {
						$url = '#modal-order_license';
					}
				}
				$url = apply_filters( 'wescle_license_button_url', $url, $related_product_id );

				$formed_posts[] = array(
					'id'                 => $post->ID,
					'name'               => $post->post_title,
					'content'            => trim( $content ),
					'categories'         => $post_terms,
					'is_special'         => get_post_meta( $post->ID, 'is_special', 1 ),
					'related_product_id' => $related_product_id,
					'regular_price'      => $regular_price,
					'sale_price'         => $sale_price,
					'license_info'       => get_post_meta( $post->ID, 'wescle_license_info', 1 ),
					'button_label'       => get_post_meta( $post->ID, 'label_button', 1 ),
					'button_url'         => $url,
					'color_text'         => get_post_meta( $post->ID, 'color_text', 1 ),
					'color_bg'           => get_post_meta( $post->ID, 'color_bg', 1 ),
					'color_gradient1'    => get_post_meta( $post->ID, 'color_gradient1', 1 ),
				);
			}

			return $formed_posts;
		}
	) );

	register_rest_route( 'wescle-blocks', '/get-license-categories', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$terms = get_terms( [
				'taxonomy' => 'licensecat_wescle',
			] );

			$formed_terms = [];

			foreach ( $terms as $term ) {
				$img_id = get_term_meta( $term->term_id, '_thumbnail_id', 1 );

				$formed_terms[] = array(
					'id'    => $term->term_id,
					'name'  => $term->name,
					'image' => $img_id ? wp_get_attachment_image_src( $img_id, 'thumbnail' )[0] : '',
				);
			}

			return $formed_terms;
		},
	) );

	// Получение партнеров
	register_rest_route( 'wescle-blocks', '/get-partner-posts', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {

			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'partner_wescle',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$phones     = get_post_meta( $post->ID, 'phone', 1 );
				$phones_arr = [];
				if ( $phones ) {
					$phones_arr = explode( "\n", str_replace( "\r", '', trim( $phones ) ) );
				}

				$formed_posts[] = array(
					'id'         => $post->ID,
					'name'       => $post->post_title,
					'image'      => get_the_post_thumbnail_url( $post ),
					'content'    => trim( $post->post_content ),
					'post_url'   => '',
					'site_url'   => get_post_meta( $post->ID, 'site_url', 1 ),
					'site_label' => get_post_meta( $post->ID, 'site_label', 1 ),
					'phones'     => $phones_arr
				);
			}

			return $formed_posts;
		},
	) );

	// Получение элементов каталога
	register_rest_route( 'wescle-blocks', '/get-catalog-posts', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'catalog_item',
				'orderby'     => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
			) );

			return wescle_get_formed_catalog( $posts );
		}
	) );

	register_rest_route( 'wescle-blocks', '/get-catalog-post/(?P<id>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'post__in'  => explode( ',', str_replace( ' ', '', urldecode( $request['id'] ) ) ),
				'post_type' => 'catalog_item',
			) );

			return wescle_get_formed_catalog( $posts );
		},
	) );

	register_rest_route( 'wescle-blocks', '/get-catalog-posts-by-cats/(?P<term_ids>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$limit = 10;

			$args  = [
				'post_type'        => 'catalog_item',
				'posts_per_page'   => $limit,
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'tax_query'        => [
					[
						'taxonomy' => 'catalogcat_wescle',
						'terms'    => explode( ',', str_replace( ' ', '', urldecode( $request['term_ids'] ) ) )
					]
				],
				'suppress_filters' => false
			];
			$posts = get_posts( $args );

			return wescle_get_formed_catalog( $posts );
		},
	) );

	register_rest_route( 'wescle-blocks', '/get-catalog-categories', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$terms = get_terms( [
				'taxonomy' => 'catalogcat_wescle',
			] );

			$formed_terms = [];

			foreach ( $terms as $term ) {
				$formed_terms[] = array(
					'id'   => $term->term_id,
					'name' => $term->name,
				);
			}

			return $formed_terms;
		},
	) );

	// Получение таксономий сайта
	register_rest_route( 'wescle-blocks', '/get-taxonomies', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			return Helper::get_public_taxonomies();
		}
	) );

	register_rest_route( 'wescle-blocks', '/get-taxonomy-categories/(?P<taxonomy>.+)/(?P<id>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$formed_terms      = [];
			$category_selected = explode( ',', str_replace( ' ', '', urldecode( $request['id'] ) ) );

			$terms_args = [
				'taxonomy'   => $request['taxonomy'],
				'hide_empty' => false,
				'orderby'    => 'menu_order',
				'number'     => 10,
			];
			if ( $category_selected ) {
				$terms_args['include'] = $category_selected;
				$terms_args['orderby'] = 'include';
			}
			$terms = get_terms( $terms_args );
			if ( ! $terms || is_wp_error( $terms ) ) {
				return $formed_terms;
			}

			foreach ( $terms as $term ) {
				ob_start();
				wescle_categories_item_image( $term );
				$image = ob_get_clean();

				$formed_terms[ $term->term_id ] = array(
					'id'         => $term->term_id,
					'name'       => $term->name,
					'link'       => get_term_link( $term ),
					'count'      => $term->count,
					'image_html' => $image,
				);
			}

			return $formed_terms;
		}
	) );

	// Получение элементов инфо-блока каталога
	register_rest_route( 'wescle-blocks', '/get-catalog-info_items', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'posts_per_page' => - 1,
				'post_type'      => 'info_catalog',
				'orderby'        => [ 'title' => 'ASC', 'date' => 'DESC' ],
			) );

			return wescle_get_formed_info_catalog( $posts );
		}
	) );

	register_rest_route( 'wescle-blocks', '/get-catalog-info_item/(?P<id>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'post__in'  => explode( ',', str_replace( ' ', '', urldecode( $request['id'] ) ) ),
				'post_type' => 'info_catalog',
			) );

			return wescle_get_formed_info_catalog( $posts );
		},
	) );

	// Получение постов из инструкций
	register_rest_route( 'wescle-blocks', '/get-mosaic-posts', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {

			$posts = get_posts( array(
				'numberposts' => 20,
				'post_type'   => 'mosaic_wescle',
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$category = get_the_terms( $post, 'mosaiccat_wescle' );
				if ( is_wp_error( $category ) || ! $category ) {
					$category = [];
				}

				$custom_class = get_post_meta( $post->ID, 'type', 1 );
				if ( $custom_class ) {
					$custom_class = ' _' . $custom_class;
				}
				$label = get_post_meta( $post->ID, 'label', 1 );
				$url   = get_post_meta( $post->ID, 'url', 1 );
				$title = $post->post_title;

				$formed_posts[] = array(
					'id'           => $post->ID,
					'name'         => $post->post_title,
					'image'        => wp_get_attachment_image_url( get_post_thumbnail_id( $post ), 'medium_large' ),
					'categories'   => array_map( 'wescle_get_term_id', $category ),
					'title'        => $title,
					'label'        => $label,
					'url'          => $url,
					'custom_class' => $custom_class,
				);
			}

			return $formed_posts;
		},
	) );

	// Получение категорий инструкций
	register_rest_route( 'wescle-blocks', '/get-mosaic-categories', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$terms = get_tags( [
				'taxonomy' => 'mosaiccat_wescle',
			] );

			$formed_posts = [];

			foreach ( $terms as $term ) {
				$formed_posts[] = array(
					'id'   => $term->term_id,
					'name' => $term->name,
				);
			}

			return $formed_posts;
		},
	) );

	// Получение всех страниц из бд
	register_rest_route( 'wescle-blocks', '/get-pages', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$posts = get_posts( array(
				'posts_per_page'   => 100,
				'post_type'        => 'page',
				'suppress_filters' => false
			) );

			$formed_posts = [];

			foreach ( $posts as $post ) {
				$formed_posts[] = array(
					'id'       => $post->ID,
					'name'     => $post->post_title,
					'post_url' => get_permalink( $post->ID ),
				);
			}

			return $formed_posts;
		},
	) );

	// Формирование data атрибутов для кнопки "Еще"
	register_rest_route( 'wescle-blocks', '/get-more-atts/(?P<per_page>[\d]+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$data = [
				'paged' => 1,
				'args'  => '',
			];

			return $data;
		},
	) );

	// Получение ID форм, которые в Customizer или по дефолту
	register_rest_route( 'wescle-blocks', '/get-customizer-cf7/(?P<key>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			//$installed_forms = get_option( THEME_SLUG . '_installed_forms' );
			//$default_form_id = $installed_forms[ $request['key'] ];
			$form_id = get_theme_mod( $request['key'] );

			return $form_id;
		}
	) );

	// Получение DEMO данных
	register_rest_route( 'wescle-blocks', '/demo-data/(?P<key>.+)', array(
		'methods'             => 'GET',
		'permission_callback' => '__return_true', // *always set a permission callback
		'callback'            => function ( $request ) {
			$result = [];

			$data_key = explode( ',', $request['key'] );
			if ( ! isset( $data_key[1] ) ) {
				$data_key[1] = 'default';
			}

			$file = get_template_directory() . '/includes/demo/' . $data_key[0] . '/data.php';
			if ( file_exists( $file ) ) {
				include $file;

				if ( 'all' === $data_key[1] ) {
					$result = $data;
				}
				else {
					$result = $data[ $data_key[1] ];
				}
			}

			return $result;
		}
	) );
}

function wescle_get_term_id( $item ) {
	return $item->term_id;
}

function wescle_get_formed_posts( $posts ) {
	$formed_posts = [];

	foreach ( $posts as $post ) {
		if ( $post->post_excerpt ) {
			$content = $post->post_excerpt;
		}
		else {
			$content = Helper::short_string( wp_strip_all_tags( $post->post_content ), 150 );
		}

		$category = get_the_terms( $post, 'category' );
		if ( is_wp_error( $category ) || ! $category ) {
			$category = [];
		}

		$user            = get_user_by( 'id', $post->post_author );
		$user->posts_url = get_author_posts_url( $user->ID );
		$user->url       = $user->posts_url;
		$user->avatar    = get_avatar_url( $user->ID );

		$formed_posts[] = array(
			'id'            => $post->ID,
			'name'          => $post->post_title,
			'image'         => get_the_post_thumbnail_url( $post ),
			'content'       => trim( $content ),
			'categories'    => array_map( 'wescle_get_term_id', $category ),
			'post_url'      => get_permalink( $post->ID ),
			'url'           => '',
			'user'          => $user->data,
			'comment_count' => $post->comment_count,
			'views_count'   => get_post_views( $post->ID ),
			'created_date'  => $post->post_date,
			'modified_date' => $post->post_modified,
		);
	}

	return $formed_posts;
}

function wescle_get_formed_products( $posts ) {
	$formed_posts = [];

	$label_quick_view = '';
	if ( get_theme_mod( 'product_quick_view_enabled' ) ) {
		$label_quick_view = get_theme_mod( 'quick_view', Helper::get_default_theme_data( 'quick_view' ) );
	}

	$label_view_product = get_theme_mod( 'view_product', Helper::get_default_theme_data( 'view_product' ) );

	foreach ( $posts as $post ) {
		$category = get_the_terms( $post, 'product_cat' );
		if ( is_wp_error( $category ) || ! $category ) {
			$category = [];
		}

		$product        = wc_get_product( $post );
		$rating_count   = $product->get_rating_count();
		$review_count   = $product->get_review_count();
		$average        = $product->get_average_rating();
		$label_add_cart = strip_tags( $product->add_to_cart_text() );

		$html_rating = '';
		$rating_html = wc_get_rating_html( $average, $rating_count );
		if ( $rating_html ) {
			$html_rating .= $rating_html;
			$html_rating .= '<span class="count">(' . esc_html( $review_count ) . ')</span>';
			if ( comments_open( $product->get_id() ) ) {
				$html_rating .= '<a href="' . $product->get_permalink() . '#reviews" class="woocommerce-review-link" rel="nofollow"></a>';
			}
		}

		$label = get_theme_mod( 'product_sku_label', Helper::get_default_theme_data( 'product_sku_label' ) );
		if ( $label ) {
			$label = '<span class="_vendor-code__title">' . $label . '</span>';
		}
		$sku_html = '<div class="_vendor-code">' . $label . '<span class="_vendor-code__value">' . $product->get_sku() . '</span></div>';

		$regular_price = get_post_meta( $post->ID, '_regular_price', 1 );
		$sale_price    = get_post_meta( $post->ID, '_sale_price', 1 );

		$formed_posts[] = array(
			'id'                       => $post->ID,
			'name'                     => $post->post_title,
			'image'                    => get_the_post_thumbnail_url( $post ),
			'content'                  => '',
			'categories'               => array_map( 'wescle_get_term_id', $category ),
			'post_url'                 => get_permalink( $post->ID ),
			'price_old'                => $sale_price ? $regular_price : '',
			'price'                    => $sale_price ? $sale_price : $regular_price,
			'price_html'               => $product->get_price_html(),
			'rating_html'              => $html_rating,
			'stock_html'               => wc_get_stock_html( $product ),
			'sku_html'                 => $sku_html,
			'product_category_enabled' => get_theme_mod( 'product_category_enabled', true ),
			'product_stock_enabled'    => get_theme_mod( 'product_stock_enabled', false ),
			'product_stock_position'   => get_theme_mod( 'product_stock_position', 'before_title' ),
			'product_rating_enabled'   => get_theme_mod( 'product_rating_enabled', false ),
			'product_rating_position'  => get_theme_mod( 'product_rating_position', 'before_title' ),
			'product_sku_enabled'      => get_theme_mod( 'product_sku_enabled', false ),
			'product_sku_position'     => get_theme_mod( 'product_sku_position', 'before_title' ),
			'label_view_product'       => $label_view_product,
			'label_quick_view'         => $label_quick_view,
			'label_add_cart'           => $label_add_cart
		);
	}

	return $formed_posts;
}

function wescle_get_formed_catalog( $posts ) {
	$formed_posts = [];

	foreach ( $posts as $post ) {
		$post_terms = wp_get_post_terms( $post->ID, 'catalogcat_wescle', array( 'fields' => 'ids' ) );

		$post_terms_data = get_the_terms( $post, 'catalogcat_wescle' );
		$post_term_links = [];
		if ( $post_terms_data ) {
			foreach ( $post_terms_data as $term ) {
				$post_term_links[] = '<a href="' . get_term_link( $term ) . '">' . $term->name . '</a>';
			}
		}

		$images                = [];
		$wescle_catalog_images = get_post_meta( $post->ID, 'wescle_catalog_images', 1 );
		if ( $wescle_catalog_images ) {
			$image_ids = wp_list_pluck( $wescle_catalog_images, 'img_id' );
			foreach ( $image_ids as $img_id ) {
				$images[] = [
					'id'  => $img_id,
					'src' => wp_get_attachment_image_url( $img_id, 'medium_large' )
				];
			}
		}

		$wescle_advantages = get_post_meta( $post->ID, 'wescle_advantages', 1 );
		if ( $wescle_advantages ) {
			foreach ( $wescle_advantages as $key => $item ) {
				if ( $item['img_id'] ) {
					$wescle_advantages[ $key ]['img_html'] = wp_get_attachment_image( $item['img_id'] );
				}
			}
		}

		$info_items = get_post_meta( $post->ID, 'info_items', 1 );
		if ( $info_items ) {
			foreach ( $info_items as $key => $item ) {
				$classes = [];
				if ( $item['title_strong'] ) {
					$classes[] = '_strong';
				}
				if ( $item['title_color'] ) {
					$classes[] = '_accent';
				}
				$info_items[ $key ]['classes_title'] = $classes ? implode( ' ', $classes ) : '';

				$classes = [];
				if ( $item['text_strong'] ) {
					$classes[] = '_strong';
				}
				if ( $item['text_color'] ) {
					$classes[] = '_accent';
				}
				$info_items[ $key ]['classes_text'] = $classes ? implode( ' ', $classes ) : '';

				$classes = [];
				if ( $item['text2_strong'] ) {
					$classes[] = '_strong';
				}
				if ( $item['text2_color'] ) {
					$classes[] = '_accent';
				}
				$info_items[ $key ]['classes_text2'] = $classes ? implode( ' ', $classes ) : '';
			}
		}

		$custom_link = get_post_meta( $post->ID, 'custom_url', 1 );
		if ( ! $custom_link ) {
			$custom_link = get_permalink( $post );
		}

		$formed_posts[] = array(
			'id'                 => $post->ID,
			'name'               => $post->post_title,
			'post_url'           => $custom_link,
			'content'            => '',
			'categories'         => $post_terms,
			'image'              => get_the_post_thumbnail_url( $post ),
			'button_label'       => get_post_meta( $post->ID, 'button_text', 1 ),
			'button_url'         => get_post_meta( $post->ID, 'button_link', 1 ),
			'target_blank'       => get_post_meta( $post->ID, 'button_link_is_blank', 1 ),
			'images'             => $images,
			'html_badges'        => wescle_catalog_item_badges( $post ),
			'html_stock_status'  => Catalog::html_stock_status( $post ),
			'post_term_links'    => $post_term_links,
			'advantages_title'   => get_post_meta( $post->ID, 'wescle_advantages_title', 1 ),
			'wescle_advantages'  => $wescle_advantages,
			'info_items'         => $info_items,
			'info_items_as_list' => get_post_meta( $post->ID, 'info_items_as_list', 1 ),
			'bg_category'        => get_theme_mod( 'module_catalog_item_bg_category' ),
			'color_category'     => get_theme_mod( 'module_catalog_item_color_category' ),
			'thumb_size'         => get_theme_mod( 'module_catalog_thumb_size' ),
			'img_size'           => get_theme_mod( 'module_catalog_img_size' ),
		);
	}

	return $formed_posts;
}

function wescle_get_formed_info_catalog( $posts ) {
	$formed_posts = [];

	foreach ( $posts as $post ) {
		$formed_posts[] = array(
			'id'       => $post->ID,
			'title'    => $post->post_title,
			'text'     => get_post_meta( $post->ID, 'text', 1 ),
			'image'    => wp_get_attachment_url( get_post_meta( $post->ID, 'icon_id', 1 ) ),
			'img_size' => get_theme_mod( 'module_catalog_info_img_size' ),
		);
	}

	return $formed_posts;
}

function createWescleCategory( $categories, $post ) {
	return array_merge(
		$categories,
		array(
			array(
				'slug'  => 'wescle',
				'title' => 'Wescle',
			),
		)
	);
}

if ( version_compare( $GLOBALS['wp_version'], '5.8-alpha-1', '<' ) ) {
	add_filter( 'block_categories', 'createWescleCategory', 10, 2 );
}
else {
	add_filter( 'block_categories_all', 'createWescleCategory', 10, 2 );
}

add_filter( 'the_content', function ( $content ) {
	$content = preg_replace( '~<link class="js-wb-styles".+?>~', '', $content );

	return $content;
} );