<?php
add_action( 'after_setup_theme', 'wescle_setup', 15 );
function wescle_setup() {

	// Add default posts and comments RSS feed links to head.
	if ( apply_filters( THEME_SLUG . '_allow_rss_links', false ) ) {
		add_theme_support( 'automatic-feed-links' );
	}

	// Let WordPress manage the document title.
	add_theme_support( 'title-tag' );

	// Custom logo.
	$logo_width  = 190;
	$logo_height = 100;

	add_theme_support(
		'custom-logo',
		array(
			'height'               => $logo_height,
			'width'                => $logo_width,
			'flex-height'          => true,
			'flex-width'           => true,
			'unlink-homepage-logo' => true,
		)
	);

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'script',
			'style',
			'widgets',
			'navigation-widgets'
		)
	);

	// Enable support for Post Thumbnails on posts and pages.
	add_theme_support( 'post-thumbnails' );

	$loop_thumbnail_default    = apply_filters( THEME_SLUG . '_loop_thumbnail_default', [ 450, 0, false ] );
	$loop_thumbnail_vertical   = apply_filters( THEME_SLUG . '_loop_thumbnail_vertical', [ 554, 675, true ] );
	$loop_thumbnail_horizontal = apply_filters( THEME_SLUG . '_loop_thumbnail_horizontal', [ 520, 387, true ] );
	$single_thumbnail          = apply_filters( THEME_SLUG . '_single_thumbnail', [ 1318, 0, false ] );
	$single_thumbnail_full     = apply_filters( THEME_SLUG . '_single_thumbnail_full', [ 1920, 450, true ] );
	$promo_banner              = apply_filters( THEME_SLUG . '_promo_banner', [ 1720, 0, false ] );

	if ( function_exists( 'add_image_size' ) ) {
		add_image_size( THEME_SLUG . '_loop_thumbnail_default', $loop_thumbnail_default[0], $loop_thumbnail_default[1], $loop_thumbnail_default[2] );
		add_image_size( THEME_SLUG . '_loop_thumbnail_vertical', $loop_thumbnail_vertical[0], $loop_thumbnail_vertical[1], $loop_thumbnail_vertical[2] );
		add_image_size( THEME_SLUG . '_loop_thumbnail_horizontal', $loop_thumbnail_horizontal[0], $loop_thumbnail_horizontal[1], $loop_thumbnail_horizontal[2] );
		add_image_size( THEME_SLUG . '_single_thumbnail', $single_thumbnail[0], $single_thumbnail[1], $single_thumbnail[2] );
		add_image_size( THEME_SLUG . '_single_thumbnail_full', $single_thumbnail_full[0], $single_thumbnail_full[1], $single_thumbnail_full[2] );
		add_image_size( THEME_SLUG . '_promo_banner', $promo_banner[0], $promo_banner[1], $promo_banner[2] );
	}

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'top_bar'     => esc_html__( 'Топ бар меню', 'wescle' ),
		'header_menu' => esc_html__( 'Меню в Шапке', 'wescle' ),
	) );

	// Add support for responsive embeds.
	add_theme_support( 'responsive-embeds' );

	if ( isset( $_GET['hide_admin_bar'] ) ) {
		add_filter( 'show_admin_bar', '__return_false' );
	}

	// Remove margin-top from <html>
	add_theme_support( 'admin-bar', array( 'callback' => '__return_false' ) );

	// Disable the Widgets Block Editor
	remove_theme_support( 'widgets-block-editor' );

	add_theme_support( 'customize-selective-refresh-widgets' );

	/* WooCommerce */
	add_theme_support(
		'woocommerce',
		apply_filters(
			'wescle_woocommerce_args',
			array(
				'single_image_width'    => 600,
				'thumbnail_image_width' => 300,
				'product_grid'          => array(
					'default_columns' => 4,
					'default_rows'    => 3,
					'min_rows'        => 1,
					'max_rows'        => 6,
					'min_columns'     => 2,
					'max_columns'     => 5,
				),
			)
		)
	);
	if ( Helper::is_woocommerce_active() ) {
		register_nav_menus( array(
			'header_store' => esc_html__( 'Меню с категориями магазина', 'wescle' ),
		) );

		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		if ( is_admin() ) {
			$catalog_rows = get_option( 'woocommerce_catalog_rows' );
			if ( false === $catalog_rows ) {
				update_option( 'woocommerce_catalog_rows', 3 );

				//update_option( 'woocommerce_thumbnail_cropping', 'custom' );
			}
		}
	}

	$locale = determine_locale();
	load_textdomain( 'wescle-demo', get_template_directory() . '/languages/wescle-demo-' . $locale . '.mo' );
}

/**
 * Register widget areas.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
add_action( 'widgets_init', 'wescle_sidebar_registration' );
function wescle_sidebar_registration() {

	register_sidebar( array(
		'name'          => esc_html__( 'Виджеты в боковой панели', 'wescle' ),
		'id'            => 'sidebar-area',
		'description'   => esc_html__( 'Добавьте виджеты в боковую панель', 'wescle' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="title title_aside">',
		'after_title'   => '</div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Виджеты в подвале', 'wescle' ),
		'id'            => 'sidebar-footer',
		'description'   => esc_html__( 'Добавьте виджеты в Footer', 'wescle' ),
		'before_widget' => '<div id="%1$s" class="widget col footer__col %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="footer__label"><span>',
		'after_title'   => '</span><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
		                            <g fill="none" stroke="#7c7c7d" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
		                                <path d="M30 12L16 24L2 12"></path>
		                            </g>
		                        </svg>
		                    </div>',
	) );

	if ( Helper::is_woocommerce_active() ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Виджеты в магазине', 'wescle' ),
			'id'            => 'sidebar-shop',
			'description'   => esc_html__( 'Добавьте виджеты в боковую панель магазина', 'wescle' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="title title_aside">',
			'after_title'   => '</div>',
		) );
	}

	if ( get_theme_mod( 'module_catalog_enabled' ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Виджеты на странице каталога', 'wescle' ),
			'id'            => 'sidebar-catalog',
			'description'   => esc_html__( 'Добавьте виджеты в боковую панель', 'wescle' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="title title_aside">',
			'after_title'   => '</div>',
		) );
	}

	if ( get_theme_mod( 'module_course_enabled' ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Виджеты на странице курса', 'wescle' ),
			'id'            => 'sidebar-course',
			'description'   => esc_html__( 'Добавьте виджеты в боковую панель', 'wescle' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="title title_aside">',
			'after_title'   => '</div>',
		) );
	}

}

add_action( 'wp_before_admin_bar_render', function () {
	global $wp_admin_bar;

	$wp_admin_bar->remove_menu( 'wp-logo' );
} );