<?php
/**
 * Enqueue scripts and styles.
 */
add_action( 'wp_enqueue_scripts', 'wescle_enqueue' );
function wescle_enqueue() {
	global $post;

	$style_version = apply_filters( THEME_SLUG . '_style_version', THEME_VERSION );
	$min           = '.min';
	if ( defined( 'THEME_DEVELOPER' ) && THEME_DEVELOPER ) {
		$style_version = time();
		$min           = '';
	}

	$is_active_top_banner = Helper::get_slides_top_banner();
	$sidebar_position     = Helper::get_sidebar_position();

	$slick_enabled = apply_filters( 'wescle_js_slick_active', false );

	$is_customize = is_customize_preview();
	$post_values  = Helper::get_customizer_post_values();

	// CSS
	$style_files = apply_filters( 'wescle_style_files', Helper::get_enqueue_style_files() );
	if ( $style_files ) {
		foreach ( $style_files as $item ) {
			$vers = isset( $item['vers'] ) ? $item['vers'] : $style_version;
			wp_enqueue_style( $item['name'], $item['src'], $item['deps'], $vers );
		}
	}

	wp_dequeue_style( 'wp-block-library' );
	wp_dequeue_style( 'contact-form-7' );

	// JS
	if ( get_theme_mod( 'module_pagespeed_jquery_in_footer', true ) ) {
		// Перемещаем jQuery в footer
		wp_deregister_script( 'jquery-core' );
		wp_deregister_script( 'jquery' );
		wp_deregister_script( 'flexslider' );

		wp_register_script( 'jquery-core', get_template_directory_uri() . '/assets/libs/jquery/dist/jquery.min.js', false, '3.6.0', true );
		wp_register_script( 'jquery', false, array( 'jquery-core' ), null, true );
		wp_register_script( 'flexslider', get_template_directory_uri() . '/assets/libs/flexslider/jquery.flexslider.min.js', false, '2.7.2', true );
	}

	wp_enqueue_script( 'jquery' );

	wp_enqueue_script( THEME_SLUG . '-common', get_template_directory_uri() . '/assets/js/pages/common.min.js', array( 'jquery' ), $style_version, true );

	if ( Helper::is_frontpage_assets() || is_home() || $is_active_top_banner || $is_customize || $slick_enabled ) {
		wp_enqueue_script( THEME_SLUG . '-slick', get_template_directory_uri() . '/assets/libs/slick-carousel/slick/slick.min.js', array( 'jquery' ), $style_version, true );

		if ( $is_active_top_banner ) {
			wp_enqueue_script( THEME_SLUG . '-top_banner', get_template_directory_uri() . '/assets/js/pages/top-banner.min.js', array( 'jquery' ), $style_version, true );
		}
	}

	if ( get_theme_mod( 'top_bar_enabled' ) ) {
		wp_enqueue_script( THEME_SLUG . '-top_bar', get_template_directory_uri() . '/assets/js/pages/top-bar.min.js', array( 'jquery' ), $style_version, true );
	}

	if ( Helper::is_store( 'header' ) ) {
		wp_enqueue_script( THEME_SLUG . '-header', get_template_directory_uri() . '/assets/js/pages/header-store.min.js', array( 'jquery' ), $style_version, true );
	}
	else {
		if ( Helper::is_header_oneline() ) {
			wp_enqueue_script( THEME_SLUG . '-header-oneline', get_template_directory_uri() . '/assets/js/pages/header-oneline.min.js', array( 'jquery' ), $style_version, true );
		}
        elseif ( Helper::is_header_tabs() ) {
			wp_enqueue_script( THEME_SLUG . '-header_tabs', get_template_directory_uri() . '/assets/js/pages/header-tabs.min.js', array( 'jquery' ), $style_version, true );
		}
        elseif ( Helper::is_header_store_center() ) {
			wp_enqueue_script( THEME_SLUG . '-dynamicAdapt', get_template_directory_uri() . '/assets/js/pages/dynamicAdapt.min.js', array(), $style_version, true );
			wp_enqueue_script( THEME_SLUG . '-header_store_center', get_template_directory_uri() . '/assets/js/pages/header-center-2.min.js', array( 'jquery' ), $style_version, true );
		}
		else {
			wp_enqueue_script( THEME_SLUG . '-header', get_template_directory_uri() . '/assets/js/pages/header.min.js', array( 'jquery' ), $style_version, true );
		}
	}

	wp_enqueue_script( THEME_SLUG . '-ios', get_template_directory_uri() . '/assets/js/pages/ios.min.js', array( 'jquery' ), $style_version, true );

	if ( get_theme_mod( 'module_dark_mode_enabled' ) ) {
		wp_enqueue_script( THEME_SLUG . '-darkreader', get_template_directory_uri() . '/assets/libs/darkreader.js', array(), $style_version, true );
		wp_enqueue_script( THEME_SLUG . '-darkmode', get_template_directory_uri() . '/assets/js/pages/darkmode.min.js', array(), $style_version, true );
	}

	if ( get_theme_mod( 'module_preloader_enabled' ) ) {
		if ( ! get_theme_mod( 'module_dark_mode_enabled' ) ) {
			wp_enqueue_script( THEME_SLUG . '-preloader', get_template_directory_uri() . '/assets/js/pages/preloader.min.js', array(), $style_version, true );
        }
	}

	if ( Helper::is_frontpage_assets() || $is_customize ) {
		$slider_layout = get_theme_mod( 'slider_layout', 'columns_two' );
		if ( isset( $post_values['slider_layout'] ) ) {
			$slider_layout = $post_values['slider_layout'];
		}

		if ( $slider_layout == 'columns_two' ) {
			wp_enqueue_script( THEME_SLUG . '-promo', get_template_directory_uri() . '/assets/js/pages/index/promo.min.js', array( 'jquery' ), $style_version, true );
		}
        elseif ( 'columns_one' === $slider_layout || 'banner' === $slider_layout ) {
	        $file_name = Helper::get_slider_script_file_name( $slider_layout );

	        wp_enqueue_script( THEME_SLUG . '-promo', get_template_directory_uri() . '/assets/js/pages/index/' . $file_name . '.min.js', array( 'jquery' ), $style_version, true );

	        if ( $is_customize || ( 'banner' === $slider_layout && get_theme_mod( 'module_catalog_enabled' ) && get_theme_mod( 'slider_banner_catalog_form' ) ) ) {
		        wp_enqueue_script( THEME_SLUG . '-wescle-promo-form', get_template_directory_uri() . '/assets/js/pages/index/wescle-promo-form.min.js', array( 'jquery' ), $style_version, true );
	        }
        }
        elseif ( $slider_layout == 'columns_four' ) {
			wp_enqueue_script( THEME_SLUG . '-promo', get_template_directory_uri() . '/assets/js/pages/index/promo_v3.min.js', array( 'jquery' ), $style_version, true );
		}
        elseif ( $slider_layout == 'animated' ) {
	        wp_enqueue_script( THEME_SLUG . '-animejs', get_template_directory_uri() . '/assets/libs/animejs/anime.min.js', array( 'jquery' ), $style_version, true );
	        wp_enqueue_script( THEME_SLUG . '-animated-banner', get_template_directory_uri() . '/assets/js/pages/index/animated-banner.min.js', array( 'jquery' ), $style_version, true );
        }
        elseif ( $slider_layout == 'parallax' && get_theme_mod( 'parallax_bg_image_2' ) && Helper::is_frontpage_assets() ) {
			wp_enqueue_script( THEME_SLUG . '-parallax', get_template_directory_uri() . '/assets/libs/parallax/parallax.min.js', array( 'jquery' ), '3.1.0', true );
			wp_enqueue_script( THEME_SLUG . '-promo-parallax', get_template_directory_uri() . '/assets/js/pages/index/promo-parallax.min.js', array( 'jquery' ), $style_version, true );
		}
	}

	/* Landing Wescle */
	if ( Helper::is_landing_page() ) {
		$slider_layout = get_post_meta( get_the_ID(), 'slider_layout', 1 );

		if ( $slider_layout == 'columns_two' ) {
			wp_enqueue_script( THEME_SLUG . '-promo', get_template_directory_uri() . '/assets/js/pages/index/promo.min.js', array( 'jquery' ), $style_version, true );
		}
        elseif ( 'columns_one' === $slider_layout || 'banner' === $slider_layout ) {
	        $file_name = Helper::get_slider_script_file_name( $slider_layout );

	        wp_enqueue_script( THEME_SLUG . '-promo', get_template_directory_uri() . '/assets/js/pages/index/' . $file_name . '.min.js', array( 'jquery' ), $style_version, true );

	        if ( 'banner' === $slider_layout && get_theme_mod( 'module_catalog_enabled' ) && get_theme_mod( 'slider_banner_catalog_form' ) ) {
		        wp_enqueue_script( THEME_SLUG . '-wescle-promo-form', get_template_directory_uri() . '/assets/js/pages/index/wescle-promo-form.min.js', array( 'jquery' ), $style_version, true );
	        }
        }
        elseif ( $slider_layout == 'columns_four' ) {
			wp_enqueue_script( THEME_SLUG . '-promo', get_template_directory_uri() . '/assets/js/pages/index/promo_v3.min.js', array( 'jquery' ), $style_version, true );
		}
        elseif ( $slider_layout == 'animated' ) {
			wp_enqueue_script( THEME_SLUG . '-animejs', get_template_directory_uri() . '/assets/libs/animejs/anime.min.js', array( 'jquery' ), $style_version, true );
			wp_enqueue_script( THEME_SLUG . '-animated-banner', get_template_directory_uri() . '/assets/js/pages/index/animated-banner.min.js', array( 'jquery' ), $style_version, true );
		}
        elseif ( $slider_layout == 'parallax' && get_post_meta( get_the_ID(), 'parallax_bg_image_2', 1 ) ) {
	        wp_enqueue_script( THEME_SLUG . '-parallax', get_template_directory_uri() . '/assets/libs/parallax/parallax.min.js', array( 'jquery' ), '3.1.0', true );
	        wp_enqueue_script( THEME_SLUG . '-promo-parallax', get_template_directory_uri() . '/assets/js/pages/index/promo-parallax.min.js', array( 'jquery' ), $style_version, true );
        }
	}

	if ( Helper::get_slides_main_banners() && ! is_front_page() && ! Helper::is_landing_page() ) {
		wp_enqueue_script( THEME_SLUG . '-main-banner', get_template_directory_uri() . '/assets/js/pages/main-banner.min.js', array(), $style_version, true );
	}

	/* Блоки на главной / Блоки Wescle Гутенберг */
	if ( is_singular() || Helper::is_frontpage_assets() || $is_customize ) {
		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_reviews_enabled', false );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'reviews' );
		}
		if ( isset( $post_values['home_reviews_enabled'] ) ) {
			$block_enabled = $post_values['home_reviews_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-reviews', get_template_directory_uri() . '/assets/js/pages/index/reviews.min.js', array( 'jquery' ), $style_version, true );
		}

		$file_name = 'reviews-2.min.js';
		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_videoreviews_enabled', false );
			if ( ! get_theme_mod( 'home_videoreviews_settings_slider', true ) ) {
				$file_name = 'reviews-2-noslider.min.js';
			}
		}
		else {
			$block_enabled = Helper::isset_block_content( 'reviews-2' );
			if ( $block_enabled ) {
				$parse_content = parse_blocks( $post->post_content );
				foreach ( $parse_content as $item ) {
					if ( $item['blockName'] == 'wescle-blocks/reviews-2' ) {
						if ( isset( $item['attrs']['withCarousel'] ) ) {
							$file_name = 'reviews-2-noslider.min.js';
						}
					}
				}
			}
		}
		if ( isset( $post_values['home_videoreviews_enabled'] ) ) {
			$block_enabled = $post_values['home_videoreviews_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-reviews-2', get_template_directory_uri() . '/assets/js/pages/index/' . $file_name, array( 'jquery' ), $style_version, true );
		}


		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_team_enabled' );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'team' );
		}
		if ( isset( $post_values['home_team_enabled'] ) ) {
			$block_enabled = $post_values['home_team_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-team', get_template_directory_uri() . '/assets/js/pages/index/team.min.js', array( 'jquery' ), $style_version, true );
		}


		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_partners_enabled' );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'our-partners' );
		}
		if ( isset( $post_values['home_partners_enabled'] ) ) {
			$block_enabled = $post_values['home_partners_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-partners', get_template_directory_uri() . '/assets/js/pages/index/our-partners.min.js', array( 'jquery' ), $style_version, true );
		}


		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_difference_enabled' );

			$image_before = get_theme_mod( 'home_difference_before' );
			$image_after  = get_theme_mod( 'home_difference_after' );
			if ( ! $image_before || ! $image_after ) {
				$block_enabled = false;
			}
		}
		else {
			$block_enabled = Helper::isset_block_content( 'difference' );
		}
		if ( isset( $post_values['home_difference_enabled'] ) ) {
			$block_enabled = $post_values['home_difference_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-difference', get_template_directory_uri() . '/assets/js/pages/index/difference.min.js', array( 'jquery' ), $style_version, true );
		}


		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_prices_enabled' );
			if ( ! $block_enabled ) {
				$block_enabled = get_theme_mod( 'home_prices2_enabled' );
			}
		}
		else {
			$block_enabled = Helper::isset_block_content( 'tarif-plan' );
		}
		if ( isset( $post_values['home_prices_enabled'] ) ) {
			$block_enabled = $post_values['home_prices_enabled'];
		}
		if ( ! $block_enabled ) {
			if ( isset( $post_values['home_prices2_enabled'] ) ) {
				$block_enabled = $post_values['home_prices2_enabled'];
			}
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-tarrif-plan', get_template_directory_uri() . '/assets/js/pages/index/tarrif-plan.min.js', array( 'jquery' ), $style_version, true );
		}


		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_special_enabled' );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'time-left' );
		}
		if ( isset( $post_values['home_special_enabled'] ) ) {
			$block_enabled = $post_values['home_special_enabled'];
		}
		if ( $block_enabled ) {
			if ( Helper::is_frontpage_assets() ) {
				if ( get_theme_mod( 'home_special_action_type', 'date' ) == 'hours' ) {
					wp_enqueue_script( THEME_SLUG . '-special', get_template_directory_uri() . '/assets/js/pages/index/time-left-by.min.js', array( 'jquery' ), $style_version, true );
				}
				else {
					if ( get_theme_mod( 'home_special_action_date' ) ) {
						wp_enqueue_script( THEME_SLUG . '-special', get_template_directory_uri() . '/assets/js/pages/index/time-left.min.js', array( 'jquery' ), $style_version, true );
					}
				}
			}
			else {
				if ( strpos( get_post()->post_content, '"endType":"byTime"' ) !== false ) {
					wp_enqueue_script( THEME_SLUG . '-special', get_template_directory_uri() . '/assets/js/pages/index/time-left-by.min.js', array( 'jquery' ), $style_version, true );
				}
				else {
					wp_enqueue_script( THEME_SLUG . '-special', get_template_directory_uri() . '/assets/js/pages/index/time-left.min.js', array( 'jquery' ), $style_version, true );
				}
			}
		}


		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_faq2_enabled', false );
			if ( $block_enabled ) {
				$block_enabled = get_theme_mod( 'home_faq2_enabled_home', true );
			}
		}
		else {
			$block_enabled = Helper::isset_block_content( 'instruction' );
		}
		if ( isset( $post_values['home_faq2_enabled'] ) ) {
			$block_enabled = $post_values['home_faq2_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-instruction', get_template_directory_uri() . '/assets/js/pages/index/instruction.min.js', array( 'jquery' ), $style_version, true );
		}

		$slider_enabled = false;
		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_gallery_enabled', false );
			if ( $block_enabled ) {
				$block_enabled  = get_theme_mod( 'home_gallery_enabled_home', true );
				$slider_enabled = get_theme_mod( 'home_gallery_slider_enabled' );
			}
		}
		else {
			$block_enabled = Helper::isset_block_content( 'our-works' );
		}
		if ( isset( $post_values['home_gallery_enabled'] ) ) {
			$block_enabled = $post_values['home_gallery_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-fslightbox', get_template_directory_uri() . '/assets/libs/fslightbox.js', array( 'jquery' ), $style_version, true );
			wp_enqueue_script( THEME_SLUG . '-our-works', get_template_directory_uri() . '/assets/js/pages/index/our-works.min.js', array( 'jquery' ), $style_version, true );
			if ( $slider_enabled ) {
				wp_enqueue_script( THEME_SLUG . '-our-works-slider', get_template_directory_uri() . '/assets/js/pages/index/our-works-slider.min.js', array( 'jquery' ), $style_version, true );
			}
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_videos_enabled', false );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'videos-slider' );
		}
		if ( isset( $post_values['home_videos_enabled'] ) ) {
			$block_enabled = $post_values['home_videos_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-videos-slider', get_template_directory_uri() . '/assets/js/pages/index/videos-slider.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_videos2_enabled', false );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'videos-section' );
		}
		if ( isset( $post_values['home_videos2_enabled'] ) ) {
			$block_enabled = $post_values['home_videos2_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-videos-section', get_template_directory_uri() . '/assets/js/pages/index/video-section.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_videos_max_enabled', false );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'videos-max' );
			if ( is_singular( 'course_wescle' ) ) {
				$block_enabled = true;
			}
		}
		if ( isset( $post_values['home_videos_max_enabled'] ) ) {
			$block_enabled = $post_values['home_videos_max_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-videos-max', get_template_directory_uri() . '/assets/js/pages/index/video-max.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_stories_enabled', false );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'stories' );
		}
		if ( $block_enabled ) {
			$stories_ver = Helper::version_stories();
			wp_enqueue_script( THEME_SLUG . '-zuck', get_template_directory_uri() . '/assets/libs/zuck.js/dist/zuck.min.js', array( 'jquery' ), $style_version, true );
			wp_enqueue_script( THEME_SLUG . '-stories', get_template_directory_uri() . '/assets/js/pages/index/stories' . $stories_ver . '.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_services_slider_enabled', false );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'additional-services' );
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-additional-services', get_template_directory_uri() . '/assets/js/pages/index/additional-services.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_payments_enabled', false );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'payment-methods' );
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-swiper', get_template_directory_uri() . '/assets/libs/swiper/swiper-bundle.min.js', [], $style_version, true );
			wp_enqueue_script( THEME_SLUG . '-payments-methods', get_template_directory_uri() . '/assets/js/pages/index/payment-methods.min.js', [], $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_licenses_enabled', false );
			if ( $block_enabled ) {
				$block_enabled = get_theme_mod( 'home_licenses_enabled_home', true );
			}
		}
		else {
			$block_enabled = Helper::isset_block_content( 'licenses' );
		}
		if ( isset( $post_values['home_licenses_enabled'] ) ) {
			$block_enabled = $post_values['home_licenses_enabled'];
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-tarrif-plan', get_template_directory_uri() . '/assets/js/pages/index/tarrif-plan.min.js', array( 'jquery' ), $style_version, true );
			wp_enqueue_script( THEME_SLUG . '-licenses', get_template_directory_uri() . '/assets/js/pages/index/licenses.min.js', [], $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_checklist_enabled', false );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'checklist' );
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-checklist', get_template_directory_uri() . '/assets/js/pages/index/checklist.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_information_enabled', false );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'information' );
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-information', get_template_directory_uri() . '/assets/js/pages/index/information.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_what_site_enabled' );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'what-site' );
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-what_site', get_template_directory_uri() . '/assets/js/pages/index/what-site.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_why_enabled' );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'why' );
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-why', get_template_directory_uri() . '/assets/js/pages/index/why.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'module_catalog_enabled' );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'wescle-catalog' );
		}
		if ( $block_enabled ) {
			if ( get_theme_mod( 'module_catalog_gallery_enabled' ) ) {
				wp_enqueue_script( THEME_SLUG . '-swiper', get_template_directory_uri() . '/assets/libs/swiper/swiper-bundle.min.js', array( 'jquery' ), $style_version, true );
			}
			wp_enqueue_script( THEME_SLUG . '-transport', get_template_directory_uri() . '/assets/js/pages/index/wescle-transport.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_infotabs_enabled' );
			if ( $block_enabled ) {
				$info_tabs_data = Helper::get_info_tabs_data();
			}
		}
		else {
			$block_enabled = Helper::isset_block_content( 'info-tabs' );
			if ( $block_enabled ) {
				$info_tabs_data = Helper::get_info_tabs_data( 'wescle-block' );
			}
		}
		if ( $block_enabled ) {
			if ( $info_tabs_data['is_slider'] ) {
				wp_enqueue_script( THEME_SLUG . '-swiper', get_template_directory_uri() . '/assets/libs/swiper/swiper-bundle.min.js', array( 'jquery' ), $style_version, true );
			}
			if ( $info_tabs_data['is_tooltip'] ) {
				wp_enqueue_script( THEME_SLUG . '-tippy_popper', get_template_directory_uri() . '/assets/libs/tippy/popper.min.js', array( 'jquery' ), $style_version, true );
				wp_enqueue_script( THEME_SLUG . '-tippy_tippy', get_template_directory_uri() . '/assets/libs/tippy/tippy.min.js', array( 'jquery' ), $style_version, true );
			}
			wp_enqueue_script( THEME_SLUG . '-infotabs', get_template_directory_uri() . '/assets/js/pages/index/info-tabs.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_faq_columns_two' );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'faq' );
			if ( $block_enabled ) {
				$block_enabled = false;
				$parse_content = parse_blocks( $post->post_content );
				foreach ( $parse_content as $item ) {
					if ( $item['blockName'] === 'wescle-blocks/faq' ) {
						if ( isset( $item['attrs']['questBy2Col'] ) && $item['attrs']['questBy2Col'] ) {
							$block_enabled = true;
						}
					}
				}
			}
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-faq', get_template_directory_uri() . '/assets/js/pages/index/faq.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() && get_theme_mod( 'home_map_items', [] ) ) {
			$block_enabled = get_theme_mod( 'home_map_enabled' );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'wescle-map' );
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-map', get_template_directory_uri() . '/assets/js/pages/map.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() ) {
			$block_enabled = get_theme_mod( 'home_catalogcats_enabled' );
		}
		else {
			$block_enabled = Helper::isset_block_content( 'wescle-categories' );
		}
		if ( $block_enabled ) {
			wp_enqueue_script( THEME_SLUG . '-wescle_categories', get_template_directory_uri() . '/assets/js/pages/index/wescle-categories.min.js', array( 'jquery' ), $style_version, true );
		}
	}
	/* END Блоки на главной / Блоки Wescle Гутенберг */

	if ( $sidebar_position != 'sidebar-none' ) {
		wp_enqueue_script( THEME_SLUG . '-sticky', get_template_directory_uri() . '/assets/libs/sticky-kit/dist/sticky-kit.min.js', array( 'jquery' ), $style_version, true );
	}

	if ( is_page_template( 'templates/template-reviews.php' ) ) {
		wp_enqueue_script( THEME_SLUG . '-reviews', get_template_directory_uri() . '/assets/js/pages/index/reviews.min.js', array( 'jquery' ), $style_version, true );
	}

	if ( is_page_template( 'templates/template-videoreviews.php' ) ) {
		wp_enqueue_script( THEME_SLUG . '-reviews-2', get_template_directory_uri() . '/assets/js/pages/index/reviews-2-noslider.min.js', array( 'jquery' ), $style_version, true );
	}

	if ( is_page_template( 'templates/template-gallery.php' ) ) {
		wp_enqueue_script( THEME_SLUG . '-fslightbox', get_template_directory_uri() . '/assets/libs/fslightbox.js', array( 'jquery' ), $style_version, true );
		wp_enqueue_script( THEME_SLUG . '-our-works', get_template_directory_uri() . '/assets/js/pages/index/our-works.min.js', array( 'jquery' ), $style_version, true );
	}

	if ( is_tax( 'videocat_wescle' ) ) {
		if ( 'section' === get_theme_mod( 'video_card_type' ) ) {
			wp_enqueue_script( THEME_SLUG . '-videos-section', get_template_directory_uri() . '/assets/js/pages/index/video-section.min.js', array( 'jquery' ), $style_version, true );
		}
	}

	if ( is_tax( Helper::get_catalog_taxs() ) || is_page_template( 'templates/template-catalog_wescle.php' ) || ( is_search() && $_REQUEST['post_type'] == 'catalog' ) ) {
		if ( get_theme_mod( 'module_catalog_gallery_enabled' ) ) {
			wp_enqueue_script( THEME_SLUG . '-swiper', get_template_directory_uri() . '/assets/libs/swiper/swiper-bundle.min.js', [], $style_version, true );
		}
		wp_enqueue_script( THEME_SLUG . '-transport', get_template_directory_uri() . '/assets/js/pages/index/wescle-transport.min.js', array( 'jquery' ), $style_version, true );
	}

	if ( is_singular( 'catalog_item' ) ) {
		if ( count( Helper::get_catalog_images( $post ) ) ) {
			wp_enqueue_script( THEME_SLUG . '-fslightbox', get_template_directory_uri() . '/assets/libs/fslightbox.js', array( 'jquery' ), $style_version, true );
		}
		wp_enqueue_script( THEME_SLUG . '-catalog_item', get_template_directory_uri() . '/assets/js/pages/post/catalog-post.min.js', array( 'jquery' ), $style_version, true );

		if ( get_theme_mod( 'catalog_item_block_related', 2 ) ) {
			if ( get_theme_mod( 'module_catalog_gallery_enabled' ) ) {
				wp_enqueue_script( THEME_SLUG . '-swiper', get_template_directory_uri() . '/assets/libs/swiper/swiper-bundle.min.js', [], $style_version, true );
			}
			wp_enqueue_script( THEME_SLUG . '-transport', get_template_directory_uri() . '/assets/js/pages/index/wescle-transport.min.js', array( 'jquery' ), $style_version, true );
		}
	}

	$phone_mask = get_theme_mod( 'phone_mask', 'none' );
	if ( isset( $post_values['phone_mask'] ) ) {
		$phone_mask = $post_values['phone_mask'];
	}
	if ( $phone_mask != 'none' ) {
		wp_enqueue_script( THEME_SLUG . '-maskedinput', get_template_directory_uri() . '/assets/js/jquery.maskedinput.min.js', array( 'jquery' ), '1.4.1', true );
	}

	if ( get_theme_mod( 'module_mess_enabled' ) ) {
		wp_enqueue_script( THEME_SLUG . '-mess-widget', get_template_directory_uri() . '/assets/js/pages/mess-widget.min.js', array(), $style_version, true );
	}

	if ( get_theme_mod( 'module_banner_shares_enabled' ) && Helper::get_data_banner_shares() ) {
		wp_enqueue_script( THEME_SLUG . '-tarrif-plan', get_template_directory_uri() . '/assets/js/pages/index/tarrif-plan.min.js', array( 'jquery' ), $style_version, true );
		wp_enqueue_script( THEME_SLUG . '-banner-shares', get_template_directory_uri() . '/assets/js/pages/banner-shares.min.js', array(), $style_version, true );
	}

	//wp_enqueue_script( THEME_SLUG . '-modernizr', get_template_directory_uri() . '/assets/libs/modernizr-custom.js', array( 'jquery' ), '3.6.0', true );
	wp_enqueue_script( THEME_SLUG . '-hammer', get_template_directory_uri() . '/assets/libs/hammerjs/hammer.min.js', array( 'jquery' ), '2.0.7', true );
	wp_enqueue_script( THEME_SLUG . '-main', get_template_directory_uri() . '/assets/js/main.min.js', array( 'jquery' ), $style_version, true );
	wp_enqueue_script( THEME_SLUG . '-main-developer', get_template_directory_uri() . '/assets/js/main-developer' . $min . '.js', array( 'jquery' ), $style_version, true );
	if ( Helper::is_woocommerce_active() ) {
		if ( Helper::is_woocommerce() && ! is_single() ) {
			if ( Helper::is_shop_filter_active() ) {
				wp_enqueue_script( THEME_SLUG . '-dynamicAdapt', get_template_directory_uri() . '/assets/js/pages/dynamicAdapt.min.js', array(), $style_version, true );
			}

			wp_enqueue_script( THEME_SLUG . '-goods', get_template_directory_uri() . '/assets/js/pages/goods/goods.min.js', array(), $style_version, true );

			wp_enqueue_script( THEME_SLUG . '-goods-slider', get_template_directory_uri() . '/assets/js/pages/goods/goods-slider.min.js', array(), $style_version, true );

			if ( Helper::is_active_section_tags() ) {
				wp_enqueue_script( THEME_SLUG . '-section-tags', get_template_directory_uri() . '/assets/js/pages/section-tags.min.js', array(), $style_version, true );
			}

			if ( Helper::is_active_section_brands() ) {
				if ( get_theme_mod( 'woo_archive_brands_slider' ) ) {
					wp_enqueue_script( THEME_SLUG . '-section-brands', get_template_directory_uri() . '/assets/js/pages/index/store/brands-slider.min.js', array(), $style_version, true );
				}
			}

			if ( Helper::is_shop_filter_active() ) {
				wp_enqueue_script( THEME_SLUG . '-goods-filters', get_template_directory_uri() . '/assets/js/pages/index/store/goods-filter.min.js', array(), $style_version, true );
			}
		}

		if ( is_singular( 'product' ) ) {
			if ( Helper::is_active_goods_slider() ) {
				wp_enqueue_script( THEME_SLUG . '-goods-slider', get_template_directory_uri() . '/assets/js/pages/goods/goods-slider.min.js', array(), $style_version, true );
			}
			wp_enqueue_script( THEME_SLUG . '-goods-sku', get_template_directory_uri() . '/assets/js/pages/goods/sku.min.js', array(), $style_version, true );
			if ( get_theme_mod( 'product_sticky_button_cart' ) || get_theme_mod( 'product_gallery_left' ) ) {
				wp_enqueue_script( THEME_SLUG . '-product', get_template_directory_uri() . '/assets/js/pages/goods/product.min.js', array(), $style_version, true );
			}
		}

		if ( ( Helper::is_frontpage_assets() && 'store' === get_theme_mod( 'slider_layout' ) ) || ( ! Helper::is_frontpage_assets() && 'store' === get_post_meta( get_the_ID(), 'slider_layout', 1 ) ) ) {
			wp_enqueue_script( THEME_SLUG . '-index-store', get_template_directory_uri() . '/assets/js/pages/index/store/index-store.min.js', array( 'jquery' ), $style_version, true );
		}

		if ( Helper::is_frontpage_assets() && ! is_home() ) {
			$woo_blocks_style = Helper::get_woo_blocks_style();

			if ( in_array( 'products', $woo_blocks_style ) || in_array( 'category', $woo_blocks_style ) ) {
				wp_enqueue_script( THEME_SLUG . '-goods-slider', get_template_directory_uri() . '/assets/js/pages/goods/goods-slider.min.js', array(), $style_version, true );
			}
		}

		if ( Helper::isset_block_content( [ 'store-products', 'store-products-tabs' ] ) ) {
			wp_enqueue_script( THEME_SLUG . '-goods-slider', get_template_directory_uri() . '/assets/js/pages/goods/goods-slider.min.js', array(), $style_version, true );
		}

		if ( 'store' == get_theme_mod( 'header_block_type' ) || Helper::is_header_store_center() ) {
			wp_enqueue_script( THEME_SLUG . '-cart', get_template_directory_uri() . '/assets/js/pages/goods/cart.min.js', array(), $style_version, true );
		}

		if ( get_theme_mod( 'product_quick_view_enabled' ) ) {
			wp_enqueue_script( 'wc-add-to-cart-variation' );
		}

		if ( Helper::is_active_compare() ) {
			wp_enqueue_script( THEME_SLUG . '-compare', get_template_directory_uri() . '/assets/js/pages/compare.min.js', array(), $style_version, true );
		}

		if ( Helper::is_active_quantity_togglers() ) {
			wp_enqueue_script( THEME_SLUG . '-quantity-togglers', get_template_directory_uri() . '/assets/js/pages/quantity-togglers.min.js', array(), $style_version, true );
		}

		wp_enqueue_script( THEME_SLUG . '-main-developer_woo', get_template_directory_uri() . '/assets/js/main-developer_woo' . $min . '.js', array( 'jquery' ), $style_version, true );
	}

	if ( 'menu' === Helper::get_header_search_type() ) {
		wp_enqueue_script( THEME_SLUG . '-search-v2', get_template_directory_uri() . '/assets/js/pages/search-v2.min.js', array( 'jquery' ), $style_version, true );
	}
	if ( 'menu_visible' === Helper::get_header_search_type() ) {
		wp_enqueue_script( THEME_SLUG . '-search-v3', get_template_directory_uri() . '/assets/js/pages/search-v3.min.js', array( 'jquery' ), $style_version, true );
	}

	if ( get_theme_mod( 'header_search', true ) && get_theme_mod( 'header_search_ajax', false ) ) {
		wp_enqueue_script( THEME_SLUG . '-livesearch', get_template_directory_uri() . '/assets/js/wescle-livesearch' . $min . '.js', array( 'jquery' ), $style_version, true );
	}

	if ( get_theme_mod( 'header_search', true ) && get_theme_mod( 'header_search_voice', true ) ) {
		wp_enqueue_script( THEME_SLUG . '-voice_search', get_template_directory_uri() . '/assets/js/wescle-voice_search' . $min . '.js', array( 'jquery' ), $style_version, true );
	}

	if ( get_theme_mod( 'phones_hide_enabled' ) ) {
		wp_enqueue_script( THEME_SLUG . '-phones_hide', get_template_directory_uri() . '/assets/js/pages/hidePhoneNumbers.min.js', array( 'jquery' ), $style_version, true );
	}

	if ( get_theme_mod( 'module_hidden_element_enabled' ) ) {
		wp_enqueue_script( THEME_SLUG . '-hidden_element', get_template_directory_uri() . '/assets/js/pages/find-hidden-element.min.js', [], $style_version, true );
	}

	if ( is_singular( 'course_wescle' ) ) {
		wp_enqueue_script( THEME_SLUG . '-post_sticky', get_template_directory_uri() . '/assets/js/pages/post/post-sticky-nav.min.js', [], $style_version, true );
	}

	if ( get_theme_mod( 'highlight_code' ) && Helper::isset_code_content() ) {
		wp_enqueue_script( THEME_SLUG . '-highlight_code-lib', get_template_directory_uri() . '/assets/libs/prism/prism.min.js', [], $style_version, true );
	}

	if ( get_theme_mod( 'cursor_text_enabled' ) || get_theme_mod( 'cursor_ball_enabled' ) ) {
		wp_enqueue_script( THEME_SLUG . '-cursor', get_template_directory_uri() . '/assets/js/pages/wescle-cursor.min.js', [], $style_version, true );
	}

	$lightbox_enabled = get_theme_mod( 'lightbox_enabled', true );
	if ( isset( $post_values['lightbox_enabled'] ) ) {
		$lightbox_enabled = $post_values['lightbox_enabled'];
	}

	$installed_forms = get_option( THEME_SLUG . '_installed_forms' );
	$catalog_cf7_id  = get_theme_mod( 'module_catalog_stock_enabled', true ) && isset( $installed_forms['home_catalog_item'] ) ? intval( $installed_forms['home_catalog_item'] ) : '';

	$server_data = apply_filters( 'wescle_server_data', array(
		'url'                       => admin_url( 'admin-ajax.php' ),
		'nonce'                     => wp_create_nonce( 'wescle-nonce' ),
		'labels'                    => [
			'close'             => __( 'Закрыть', 'wescle' ),
			'delete_from_cart'  => __( 'Удалить из корзины', 'wescle' ),
			'title_cart'        => Helper::get_default_theme_data( 'cart_title' ),
			'sku'               => [
				'link'        => __( 'Ссылка на товар', 'wescle' ),
				'title'       => __( 'Название товара', 'wescle' ),
				'vendor_code' => __( 'Артикул', 'wescle' ),
			],
			'video_unsupported' => __( 'Тег video не поддерживается вашим браузером', 'wescle' ),
			'photo_report'      => [
				'name'           => __( 'Аноним', 'wescle' ),
				'upload_warning' => __( 'Разрешено добавлять только изображения.', 'wescle' ),
				'upload_error'   => __( 'Ошибка сервера', 'wescle' ),
			],
		],
		'phone_mask'                => $phone_mask,
		'wesclelightbox'            => intval( $lightbox_enabled ),
		'topbanner_cookie'          => intval( get_theme_mod( 'top_banner_cookie_live', 7 ) ),
		'banner_cookie_live'        => intval( get_theme_mod( 'cookie_banner_cookie_live', 30 ) ),
		'banner_shares_cookie_live' => intval( get_theme_mod( 'module_banner_shares_cookie_live', 1 ) ),
		'toc_open'                  => intval( get_theme_mod( 'toc_open', 1 ) ),
		'cart_auto_open'            => intval( get_theme_mod( 'header_store_cart_big' ) ) && intval( get_theme_mod( 'header_store_cart_big_open' ) ) ? 1 : 0,
		'stories'                   => Helper::get_stories_data(),
		'livesearch'                => ( get_theme_mod( 'header_search', true ) && get_theme_mod( 'header_search_ajax', false ) ) ? 1 : '',
		'telCountHide'              => get_theme_mod( 'phones_hide_enabled' ) ? intval( get_theme_mod( 'phones_hide_count', 5 ) ) : 0,
		'search_voice_lang'         => get_theme_mod( 'header_search_voice_lang', 'ru' ),
		'product_quick_view'        => intval( get_theme_mod( 'product_quick_view_enabled' ) ) ? 1 : '',
		'rtl'                       => is_rtl() ? 1 : '',
		'wp_cache'                  => defined( 'WP_CACHE' ) && WP_CACHE ? 1 : '',
		'catalog_gallery_enabled'   => intval( get_theme_mod( 'module_catalog_gallery_enabled' ) ) ? 1 : '',
		'catalog_cf7_id'            => $catalog_cf7_id,
	) );
	wp_localize_script( 'jquery', 'server_data', $server_data );

	// comment reply script
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

remove_action( 'wp_enqueue_scripts', 'wpcf7_do_enqueue_scripts', 10, 0 );

add_action( 'wp_footer', 'wescle_style_in_footer', 1 );
function wescle_style_in_footer() {
	if ( is_singular() && ! Helper::is_frontpage_assets() ) {
		wp_enqueue_style( 'wp-block-library' );
	}

	if ( function_exists( 'wpcf7_do_enqueue_scripts' ) ) {
		wpcf7_do_enqueue_scripts();
	}
	else {
		wp_enqueue_style( 'contact-form-7' );
	}
}

/**
 * Enqueue admin scripts and styles.
 */
add_action( 'admin_enqueue_scripts', 'wescle_enqueue_admin', 99 );
function wescle_enqueue_admin() {
	global $post, $wp_customize;

	$style_version = apply_filters( THEME_SLUG . '_style_version', THEME_VERSION );
	if ( defined( 'WP_DEBUG' ) && true === WP_DEBUG ) {
		$style_version = time();
	}

	if ( $wp_customize ) {
		$script_lang = 'en';
		if ( get_locale() == 'ru_RU' ) {
			$script_lang = 'ru';
		}
        elseif ( get_locale() == 'uk' ) {
			$script_lang = 'uk';
		}
		wp_enqueue_script( 'selectWoo-ru', get_template_directory_uri() . '/libs/wscl/assets/vendor/selectWoo/js/i18n/' . $script_lang . '.js', array( 'jquery' ), '1.0.1', true );
		// Fix Kirki Editor
		wp_enqueue_editor();
	}

	if ( isset( $_GET['page'] ) && 'wescle_settings_customizer' == $_GET['page'] ) {
		wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/assets/admin/js/fancybox/jquery.fancybox.min.css' );
		wp_enqueue_script( 'fancybox', get_template_directory_uri() . '/assets/admin/js/fancybox/jquery.fancybox.min.js', array( 'jquery' ), 3, true );
	}

	wp_enqueue_style( THEME_SLUG . '-admin-style', get_template_directory_uri() . '/assets/admin/css/admin.css', array(), $style_version );
	wp_enqueue_script( THEME_SLUG . '-admin-scripts', get_template_directory_uri() . '/assets/admin/js/admin.js', array( 'jquery' ), $style_version, true );
	$server_data = apply_filters( 'wescle_admin_server_data', array(
		'admin_url'                => admin_url( '/' ),
		'theme_uri'                => get_template_directory_uri(),
		'template'                 => $post ? get_page_template_slug( $post ) : '',
		'labels'                   => [
			'import_demo'   => __( 'Введенные данные в текущем блоке будут удалены и заменены на демо данные, подтвердить действие?', 'wescle' ),
			'reset_options' => __( 'Подтвердите ваше действие, все данные в блоках, которые Вы вводили ранее, будут удалены и заменены на стартовые от темы!', 'wescle' ),
		],
		'frame_media_title'        => __( 'Изображение', 'wescle' ),
		'frame_media_button'       => __( 'Выбрать изображение', 'wescle' ),
		'frame_media_video_title'  => __( 'Видео', 'wescle' ),
		'frame_media_video_button' => __( 'Выбрать видео', 'wescle' ),
		'is_wc'                    => Helper::is_woocommerce_active() ? 1 : '',
	) );
	wp_localize_script( THEME_SLUG . '-admin-scripts', 'server_data', $server_data );
}

/**
 * Enqueue supplemental block editor styles.
 */
add_action( 'enqueue_block_editor_assets', 'wescle_block_editor_styles', 1, 1 );
function wescle_block_editor_styles() {
	// Enqueue the editor styles.
	wp_enqueue_style( THEME_SLUG . '-block-editor-fonts', get_theme_file_uri( '/assets/css/fonts.min.css' ), array(), wp_get_theme()->get( 'Version' ), 'all' );
	wp_enqueue_style( THEME_SLUG . '-block-editor-styles', get_theme_file_uri( '/assets/admin/css/editor-style-block.css' ), array(), wp_get_theme()->get( 'Version' ), 'all' );
	wp_style_add_data( THEME_SLUG . '-block-editor-styles', 'rtl', 'replace' );
}

/**
 * Enqueue classic editor styles.
 */
add_action( 'init', 'wescle_classic_editor_styles' );
function wescle_classic_editor_styles() {
	$classic_editor_styles = array(
		'assets/admin/css/editor-style-classic.css',
	);

	add_editor_style( $classic_editor_styles );
}


add_action( 'wp_head', 'wescle_preload_font', 5 );
if ( ! function_exists( 'wescle_preload_font' ) ) {
	function wescle_preload_font() {
		if ( ! get_theme_mod( 'module_pagespeed_font_preload', true ) ) {
			return;
		}

		$enable_font_light = true;
		if ( is_front_page() || is_home() || is_archive() ) {
			$enable_font_light = false;
		}

		if ( get_theme_mod( 'font_custom' ) && get_theme_mod( 'font_custom_name' ) && get_theme_mod( 'font_custom_regular' ) ) {
			$fonts_data = [
				'light'    => 300,
				'regular'  => 400,
				'bold'     => 700,
				'medium'   => 500,
				'semibold' => 600
			];
			foreach ( $fonts_data as $type => $font_weight ) {
				$file_url = get_theme_mod( 'font_custom_' . $type );
				if ( ! $file_url ) {
					continue;
				}
				if ( $font_weight == 300 && ! $enable_font_light ) {
					continue;
				}

				echo '<link rel="preload" href="' . $file_url . '" as="font" crossorigin="anonymous">';
			}
		}
		else {
			$font_family = get_theme_mod( 'font_family', [] );
			if ( $font_family && $font_family['font-family'] != 'Montserrat' ) {
				$font_data = wescle_get_font_data();
				if ( isset( $font_data[ $font_family['font-family'] ] ) ) {
					$font = $font_data[ $font_family['font-family'] ][0];

					foreach ( $font_data[ $font_family['font-family'] ] as $font_weight ) {
						if ( ! is_numeric( $font_weight ) ) {
							continue;
						}
						if ( $font_weight == 300 && ! $enable_font_light ) {
							continue;
						}
						$dir = get_template_directory_uri() . '/assets';

						echo '<link rel="preload" href="' . $dir . '/fonts/' . $font . '/' . $font . '-' . $font_weight . '.woff2" as="font" crossorigin="anonymous">';
					}
				}
				else {
					$font = str_replace( ' ', '+', $font_family['font-family'] );
					?>
                    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
                    <link rel='preload' as='style' href='https://fonts.googleapis.com/css2?family=<?php echo $font; ?>:wght@400;500;600;700&subset=cyrillic&display=swap'>
                    <link rel='stylesheet' href='https://fonts.googleapis.com/css2?family=<?php echo $font; ?>:wght@400;500;600;700&subset=cyrillic&display=swap'>
					<?php
				}
			}
			else {
				?>
                <link rel="preload" href="<?php echo get_template_directory_uri(); ?>/assets/fonts/montserrat/montserrat-bold.woff2" as="font" crossorigin="anonymous">
                <link rel="preload" href="<?php echo get_template_directory_uri(); ?>/assets/fonts/montserrat/montserrat-regular.woff2" as="font" crossorigin="anonymous">
                <link rel="preload" href="<?php echo get_template_directory_uri(); ?>/assets/fonts/montserrat/montserrat-medium.woff2" as="font" crossorigin="anonymous">
                <link rel="preload" href="<?php echo get_template_directory_uri(); ?>/assets/fonts/montserrat/montserrat-semibold.woff2" as="font" crossorigin="anonymous">
				<?php if ( $enable_font_light ) { ?>
                    <link rel="preload" href="<?php echo get_template_directory_uri(); ?>/assets/fonts/montserrat/montserrat-light.woff2" as="font" crossorigin="anonymous">
				<?php } ?>
				<?php
			}
		}
	}
}

function wescle_get_font_data() {
	$font_data = [
		'Open Sans' => [
			'open-sans',
			400,
			300,
			600,
			700
		],
		'Roboto'    => [
			'roboto',
			400,
			300,
			500,
			700
		]
	];

	$font_data = apply_filters( 'wescle_font_data', $font_data );

	return $font_data;
}

add_action( 'wp_head', 'wescle_custom_css', 20 );
function wescle_custom_css() {
	ob_start();
	include get_template_directory() . '/includes/customizer/custom-css.php';
	$css = trim( ob_get_clean() );

	if ( $css ) {
		echo '<style id="customizer-wescle-css">' . str_replace( [ "\r\n", "\r", "\n", "\t", "  " ], '', $css ) . '</style>';
	}
}


add_action( 'customize_preview_init', 'wescle_customize_preview_js' );
function wescle_customize_preview_js() {
	$vers = apply_filters( THEME_SLUG . '_style_version', THEME_VERSION );
	if ( defined( 'THEME_DEVELOPER' ) && THEME_DEVELOPER ) {
		$vers = time();
	}

	wp_enqueue_script( 'wescle_customizer_preview', get_template_directory_uri() . '/assets/admin/js/customizer-preview.js', array( 'customize-preview' ), $vers, true );
}


add_action( 'customize_controls_enqueue_scripts', 'wescle_customize_control_js' );
function wescle_customize_control_js() {
	$vers = apply_filters( THEME_SLUG . '_style_version', THEME_VERSION );
	if ( defined( 'THEME_DEVELOPER' ) && THEME_DEVELOPER ) {
		$vers = time();
	}

	wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/assets/admin/js/fancybox/jquery.fancybox.min.css' );
	wp_enqueue_script( 'fancybox', get_template_directory_uri() . '/assets/admin/js/fancybox/jquery.fancybox.min.js', array( 'jquery' ), $vers, true );

	wp_enqueue_script( 'wescle_customizer_control', get_template_directory_uri() . '/assets/admin/js/customizer-control.js', array( 'customize-controls', 'jquery' ), $vers, true );
}

add_filter( 'wescle_js_slick_active', function ( $is_active ) {
	if ( ! $is_active ) {
		if ( get_theme_mod( 'module_mess_enabled', false ) ) {
			$is_active = true;
		}
	}

	if ( ! $is_active ) {
		if ( get_theme_mod( 'module_banner_shares_enabled' ) && Helper::get_data_banner_shares() ) {
			$is_active = true;
		}
	}

	if ( ! $is_active ) {
		if ( get_theme_mod( 'home_videos_enabled', false ) && Helper::is_frontpage_assets() ) {
			$is_active = true;
		}
	}

	if ( ! $is_active ) {
		if ( get_theme_mod( 'home_catalogcats_enabled', false ) && Helper::is_frontpage_assets() ) {
			$is_active = true;
		}
	}

	if ( ! $is_active ) {
		if ( is_singular() && ! is_singular( 'product' ) ) {
			if ( Helper::isset_block_content( [ 'reviews', 'reviews-2', 'team', 'our-partners', 'videos-slider', 'store-products', 'store-products-tabs', 'additional-services', 'information', 'what-site', 'why', 'wescle-categories' ] ) ) {
				$is_active = true;
			}

			if ( ! $is_active ) {
				$block_enabled = Helper::isset_block_content( 'info-tabs' );
				if ( $block_enabled ) {
					$info_tabs_data = Helper::get_info_tabs_data( 'wescle-block' );
					if ( $info_tabs_data['is_slider'] ) {
						$is_active = true;
					}
				}
			}
		}
	}

	if ( ! $is_active ) {
		if ( ! is_front_page() && ! Helper::is_landing_page() ) {
			if ( Helper::get_slides_main_banners() ) {
				$is_active = true;
			}
		}
	}

	if ( ! $is_active ) {
		if ( Helper::is_landing_page() ) {
			$slider_layout = get_post_meta( get_the_ID(), 'slider_layout', 1 );
			if ( $slider_layout && ! in_array( $slider_layout, [ 'none', 'columns_one_two', 'columns_one_four', 'animated', 'parallax' ] ) ) {
				$is_active = true;
			}
		}
	}

	return $is_active;
}, 5 );