<?php
$theme_uri = get_template_directory_uri();

$text_plus = __( 'Все доступные настройки', 'wescle-demo' ) . "\r\n" .
             __( 'Все будущие обновления', 'wescle-demo' ) . "\r\n" .
             __( 'Поддержка словом и делом', 'wescle-demo' ) . "\r\n" .
             __( 'Оптимизатор PageSpeed', 'wescle-demo' );

$data = [
	'default' => [
		'title'    => __( 'Прайс услуг', 'wescle-demo' ),
		'text'     => __( 'Список наших основных услуг, но всегда вы можете нажать посмотреть все, чтобы увидеть полный перечень наших возможностей.', 'wescle-demo' ),
		'items'    => [
			[
				'recommended'  => '',
				'image'        => [
					'url' => $theme_uri . '/includes/demo/tarif-plan/icon-png-1.jpg',
					'alt' => '',
					'id'  => '',
				],
				'title'        => __( 'GOLD', 'wescle-demo' ),
				'text_plus'    => $text_plus,
				'text_minus'   => __( "Недостаток 1", 'wescle-demo' ),
				'price'        => __( 'FREE', 'wescle-demo' ),
				'price_old'    => '49',
				'button_label' => __( 'Забрать', 'wescle-demo' ),
				'button_url'   => 'https://wescle.com/#licenses'
			],
			[
				'recommended'  => '',
				'image'        => [
					'url' => $theme_uri . '/includes/demo/tarif-plan/icon-png-1.jpg',
					'alt' => '',
					'id'  => '',
				],
				'title'        => __( 'SILVER', 'wescle-demo' ),
				'text_plus'    => $text_plus,
				'text_minus'   => __( "Недостаток 2", 'wescle-demo' ),
				'price'        => __( 'Бесплатно', 'wescle-demo' ),
				'price_old'    => '49',
				'button_label' => __( 'Выбрать', 'wescle-demo' ),
				'button_url'   => 'https://wescle.com/#licenses'
			],
			[
				'recommended'  => 1,
				'image'        => [
					'url' => $theme_uri . '/includes/demo/tarif-plan/icon-png-1.jpg',
					'alt' => '',
					'id'  => '',
				],
				'title'        => __( 'BRONZE', 'wescle-demo' ),
				'text_plus'    => $text_plus,
				'text_minus'   => __( "Недостаток 1", 'wescle-demo' ),
				'price'        => __( 'FREE', 'wescle-demo' ),
				'price_old'    => '49',
				'button_label' => __( 'Купить', 'wescle-demo' ),
				'button_url'   => 'https://wescle.com/#licenses'
			]
		],
		'settings' => [
			'home_prices_image_height' => 100,
			'home_prices_image_size'   => 'medium',
		]
	]
];