<?php
$theme_uri = get_template_directory_uri();

$page_link_id = '';
$page_posts   = get_posts( [
	'post_type'      => 'page',
	'posts_per_page' => 2,
	'order' => 'ASC'
] );
if ( $page_posts ) {
	foreach ( $page_posts as $post ) {
		if ( $post->ID != get_option( 'page_on_front' ) ) {
			$page_link_id = $post->ID;
			break;
		}
	}
}

$data = [
	'default' => [
		'title'    => __( 'Wescle - делаем сложные вещи простыми', 'wescle-demo' ),
		'text'     => __( "<p>Мы работаем с 2007 года и сотрудничали с клиентами из разных стран мира, чтобы запускать их ИТ-проекты.</p><p>Мы – те разработчики веб-сайтов, которые разделяют ваши страсть и видение, понимают ограничения и боли, те, кто хочет сделать ИТ-продукт таким красивым, что вам захочется его лизнуть.</p><p>Обращаясь к нам, вы получаете команду, говорящую на вашем языке, стремящейся к росту ваших бизнес-показателей, и на то, чтобы ваш бизнес был простимулирован результатами нашей работы.</p>", 'wescle-demo' ),
		'settings' => [
			'home_about_link_id'     => (string) $page_link_id,
			'home_about_button_text' => __( 'Подробнее', 'wescle-demo' ),
			'home_about_color_bg'    => '',
			'home_about_image'       => [
				'url' => $theme_uri . '/includes/demo/about/about-wescle.jpg',
				'alt' => '',
				'id'  => '',
			],
		]
	]
];