<?php

// Загрузка kirki на frontend-отключена
if ( ! is_customize_preview() && ! wp_doing_ajax() ) {
	if ( ! isset( $_POST['kirki_fonts_standard_all_get'] ) || ! isset( $_POST['kirki_fonts_google_all_get'] ) ) {
		return;
	}
}

include_once get_template_directory() . '/libs/wscl/kirki.php';

Kirki::add_config( THEME_CONFIG_ID, array(
	'capability'  => 'edit_theme_options',
	'option_type' => 'theme_mod',
) );

add_filter( 'kirki_config', function ( $config ) {
	$config['disable_loader'] = true;

	return $config;
} );

// Расширяем стандартные настройки WP
$extend_sections = [
	'title_tagline' => [
		'controls' => [
			'logo_description'                 => [
				'type'              => 'textarea',
				'label'             => esc_html__( 'Описание возле логотипа', 'wescle' ),
				'priority'          => 8,
				'default'           => Helper::get_default_theme_data( 'logo_description' ),
				'selector'          => '.header-top__about',
				'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
			],
			'login_logo'                       => [
				'type'     => 'image',
				'label'    => esc_html__( 'Логотип на странице логина', 'wescle' ) . ' (wp-login.php)',
				'priority' => 10,
				'choices'  => array(
					'save_as' => 'id'
				),
				//'selector' => '.header-top__col_left'
			],
			'template_as_front'                => [
				'type'     => 'switch',
				'label'    => esc_html__( 'Выводить главную страницу с кастомайзера?', 'wescle' ),
				'priority' => 105,
				'default'  => true,
				'choices'  => choices_on_off(),
			],
			'header_search'                    => [
				'type'     => 'switch',
				'label'    => esc_html__( 'Поиск', 'wescle' ),
				'priority' => 105,
				'default'  => true,
				'choices'  => choices_on_off(),
			],
			'header_search_move_burger'        => [
				'type'            => 'switch',
				'label'           => esc_html__( 'Переместить поиск в бургер на разрешении ниже 768px?', 'wescle' ),
				'priority'        => 105,
				'default'         => false,
				'choices'         => choices_on_off(),
				'active_callback' => [
					[
						'setting'  => 'header_search',
						'operator' => '==',
						'value'    => true,
					],
				]
			],
			'header_search_voice'              => [
				'type'            => 'switch',
				'label'           => esc_html__( 'Голосовой поиск?', 'wescle' ),
				'priority'        => 105,
				'default'         => true,
				'choices'         => choices_on_off(),
				'active_callback' => [
					[
						'setting'  => 'header_search',
						'operator' => '==',
						'value'    => true,
					],
				]
			],
			'header_search_voice_lang'         => [
				'type'            => 'radio',
				'label'           => esc_html__( 'Язык голосового поиска', 'wescle' ),
				'priority'        => 105,
				'default'         => 'ru-RU',
				'choices'         => [
					'ru-RU' => 'RU',
					'uk-UA' => 'UA',
					'en-US' => 'EN',
				],
				'active_callback' => [
					[
						'setting'  => 'header_search',
						'operator' => '==',
						'value'    => true,
					],
					[
						'setting'  => 'header_search_voice',
						'operator' => '==',
						'value'    => true,
					],
				]
			],
			'header_search_ajax'               => [
				'type'            => 'switch',
				'label'           => esc_html__( 'Поиск AJAX?', 'wescle' ),
				'priority'        => 105,
				'default'         => false,
				'choices'         => choices_on_off(),
				'active_callback' => [
					[
						'setting'  => 'header_search',
						'operator' => '==',
						'value'    => true,
					],
				]
			],
			'header_search_ajax_short_excerpt' => [
				'type'            => 'switch',
				'label'           => esc_html__( 'Показывать краткое описание в результатах поиска?', 'wescle' ),
				'priority'        => 105,
				'default'         => true,
				'choices'         => choices_on_off(),
				'active_callback' => [
					[
						'setting'  => 'header_search',
						'operator' => '==',
						'value'    => true,
					],
					[
						'setting'  => 'header_search_ajax',
						'operator' => '==',
						'value'    => true,
					],
				]
			],
			'header_search_type'               => [
				'type'            => 'radio',
				'label'           => esc_html__( 'Формат поиска', 'wescle' ),
				'priority'        => 105,
				'default'         => 'default',
				'choices'         => array(
					'default'      => esc_html__( 'Вверху с затемнением экрана', 'wescle' ),
					'menu'         => esc_html__( 'На уровне меню', 'wescle' ),
					'menu_visible' => esc_html__( 'На уровне меню - постоянно видимое', 'wescle' ),
				),
				'selector'        => '.navigation__search',
				'active_callback' => [
					[
						'setting'  => 'header_search',
						'operator' => '==',
						'value'    => true,
					],
				]
			],
			'header_search_options'            => [
				'type'            => Helper::is_woocommerce_active() || get_theme_mod( 'module_catalog_enabled' ) ? 'sortable' : '',
				'label'           => esc_html__( 'Поиск по', 'wescle' ),
				'priority'        => 105,
				'default'         => [
					'all',
					'blog',
					'product',
				],
				'choices'         => [
					'all'     => __( 'По всему сайту', 'wescle' ),
					'blog'    => __( 'По блогу и страницам', 'wescle' ),
					'product' => __( 'По магазину', 'wescle' ),
					'catalog' => __( 'По каталогу', 'wescle' ),
				],
				'active_callback' => [
					[
						'setting'  => 'header_search',
						'operator' => '==',
						'value'    => true,
					],
				]
			],
			'font_size_p_after'                => [
				'type'     => 'custom',
				'default'  => '<hr>',
				'priority' => 131,
			],
			'reklama_code_header'              => [
				'type'     => 'code',
				'label'    => __( 'Код в header сайта перед </head> тегом', 'wescle' ),
				'priority' => 141,
				'default'  => '',
			],
			'reklama_code_footer'              => [
				'type'     => 'code',
				'label'    => __( 'Код в footer сайта перед </body> тегом', 'wescle' ),
				'priority' => 142,
				'default'  => '',
			],
			'reset_theme_options_info'         => [
				'type'     => 'custom',
				'default'  => '<h3 class="section-subtitle">' . __( 'Базовые настройки', 'wescle' ) . '</h3>',
				'priority' => 200,
			],
			'reset_theme_options_button'       => [
				'type'     => 'custom',
				'default'  => '<button type="button" data-href="' . admin_url( '?delete_theme_options=wescle' ) . '" class="button btn" id="reset_theme_options">' . __( 'Сбросить', 'wescle' ) . '</button>',
				'priority' => 200,
			],
		]
	]
];

foreach ( $extend_sections as $section_id => $section_data ) {
	foreach ( $section_data['controls'] as $setting_key => $setting_data ) {
		$args = [
			'section'  => $section_id,
			'settings' => $setting_key,
		];
		foreach ( $setting_data as $key => $val ) {
			if ( $key == 'section' ) {
				continue;
			}

			$args[ $key ] = $val;
		}

		if ( $args['type'] === '' ) {
			continue;
		}

		if ( in_array( $setting_key, [
			'header_search_type',
			'login_logo',
			'logo_description',
		] )
		) {
			$selector = '';
			if ( isset( $setting_data['selector'] ) ) {
				$selector = $setting_data['selector'];
			}

			if ( $selector ) {
				//$args['transport'] = 'postMessage';
				$args['partial_refresh'] = array(
					$setting_key . '_shortcut' => array(
						'selector'        => $selector,
						'render_callback' => function ( $setting_key ) {
							return false;
						}
					)
				);
			}
		}

		Kirki::add_field( THEME_CONFIG_ID, $args );
	}
}

add_action( 'init', function () {
	$label_select    = __( 'Выбрать ...', 'wescle' );
	$installed_forms = get_option( THEME_SLUG . '_installed_forms' );
	if ( ! $installed_forms ) {
		$installed_forms = [];
	}

	$page_template_portfolio  = false;
	$page_template_event      = false;
	$page_template_products   = false;
	$page_template_gallery    = false;
	$page_template_faq2       = false;
	$page_template_price_list = false;
	$page_template_programs   = false;
	$page_template_services   = false;
	$page_template_reviews    = false;
	$page_template_partners   = false;
	$page_template_teams      = false;
	$page_template_wishlist   = false;
	$page_template_compare    = false;
	$page_template_catalog    = false;

	$pages_template = get_posts( [
		'post_type'      => 'page',
		'posts_per_page' => - 1,
		'meta_key'       => '_wp_page_template',
		'cache_results'  => false,
	] );
	foreach ( $pages_template as $page ) {
		$template = get_post_meta( $page->ID, '_wp_page_template', 1 );
		switch ( $template ) {
			case 'templates/template-portfolios.php':
				$page_template_portfolio = true;
				break;
			case 'templates/template-events.php':
				$page_template_event = true;
				break;
			case 'templates/template-products_wescle.php':
				$page_template_products = true;
				break;
			case 'templates/template-gallery.php':
				$page_template_gallery = true;
				break;
			case 'templates/template-knowledge_base.php':
				$page_template_faq2 = true;
				break;
			case 'templates/template-price_list.php':
				$page_template_price_list = true;
				break;
			case 'templates/template-programs.php':
				$page_template_programs = true;
				break;
			case 'templates/template-services.php':
				$page_template_services = true;
				break;
			case 'templates/template-reviews.php':
				$page_template_reviews = true;
				break;
			case 'templates/template-partners.php':
				$page_template_partners = true;
				break;
			case 'templates/template-teams.php':
				$page_template_teams = true;
				break;
			case 'templates/woo-wishlist.php':
				$page_template_wishlist = true;
				break;
			case 'templates/woo-compare.php':
				$page_template_compare = true;
				break;
			case 'templates/catalog_wescle.php':
				$page_template_catalog = true;
				break;
		}
	}

	$menu_header_store = 'header_store';
	if ( Helper::is_woocommerce_active() && get_theme_mod( 'header_store_menu', true ) ) {
		$locations = get_nav_menu_locations();
		if ( $locations && isset( $locations[ $menu_header_store ] ) && $locations[ $menu_header_store ] > 0 ) {
		}
		else {
			$menu_header_store = '';
		}
	}


// Добавляем кастомные панели и настройки
	$notice_cf7 = sprintf( __( 'Установите плагин Contact Form 7. <a href="%s">Установить</a>', 'wescle' ), admin_url( '/themes.php?page=tgmpa-install-plugins' ) );

	$panel_and_sections = [
		'visual_style_tab' => [
			'title'    => __( 'Визуальное оформление', 'wescle' ),
			'priority' => 25,

			'sections' => [
				'layout_site' => [
					'title'    => __( 'Шаблон сайта', 'wescle' ),
					'controls' => [
						'content_box'            => [
							'type'     => 'radio',
							'label'    => esc_html__( 'Ширина сайта', 'wescle' ),
							'priority' => 110,
							'default'  => 'box',
							'choices'  => array(
								'default' => esc_html__( 'На всю ширину', 'wescle' ),
								'box'     => esc_html__( 'Ограниченная ширина', 'wescle' ),
							),
						],
						'content_box_width_home' => field_content_box_width( 110, esc_html__( 'Максимальная ширина Главной', 'wescle' ) . ', px' ),
						'site_border_radius'     => [
							'type'        => 'slider',
							'label'       => esc_html__( 'Border-Radius', 'wescle' ) . ', px',
							'description' => esc_html__( 'Скругление углов', 'wescle' ),
							'priority'    => 110,
							'default'     => 10,
							'choices'     => [
								'min'  => 0,
								'max'  => 50,
								'step' => 1,
							],
						],
					]
				],
				'logotip'     => [
					'title'    => __( 'Логотип', 'wescle' ),
					'controls' => [
						'logo_color'            => [
							'type'        => 'color',
							'label'       => esc_html__( 'Цвет логотипа', 'wescle' ),
							'description' => esc_html__( 'если логотип выводится текстом', 'wescle' ),
							'priority'    => 8,
							'choices'     => [
								'alpha' => true,
							],
							'transport'   => 'auto',
							'output'      => array(
								array(
									'element'  => '.header__logo-text',
									'property' => 'color',
								)
							),
						],
						'logo_maxwidth_label'   => [
							'type'     => 'custom',
							'default'  => '<h3 class="section-subtitle">' . __( 'Максимальная ширина логотипа, px', 'wescle' ) . '</h3>',
							'priority' => 8,
						],
						'logo_maxwidth_desktop' => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на ПК (1280-1920), px', 'wescle' ),
							'priority' => 8,
							'default'  => 95,
							'choices'  => [
								'min'  => 60,
								'max'  => 300,
								'step' => 5,
							],
						],
						'logo_maxwidth_tablet'  => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на планшете (768-1280), px', 'wescle' ),
							'priority' => 8,
							'default'  => 85,
							'choices'  => [
								'min'  => 60,
								'max'  => 300,
								'step' => 5,
							],
						],
						'logo_maxwidth_mobile'  => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на телефоне (320-768), px', 'wescle' ),
							'priority' => 8,
							'default'  => 65,
							'choices'  => [
								'min'  => 60,
								'max'  => 150,
								'step' => 5,
							],
						],
					]
				],
				'color_site'  => [
					'title'    => __( 'Цвета элементов', 'wescle' ),
					'controls' => [
						'primary_color'       => [
							'type'     => 'color',
							'label'    => esc_html__( 'Базовый цвет', 'wescle' ) . ' #1',
							'priority' => 130,
							'default'  => '#0088cc',
							'choices'  => [
								'alpha' => true,
							],
						],
						'second_color'        => [
							'type'     => 'color',
							'label'    => esc_html__( 'Базовый цвет', 'wescle' ) . ' #2',
							'priority' => 131,
							'default'  => '#484848',
							'choices'  => [
								'alpha' => true,
							],
						],
						'primary_color_hover' => [
							'type'     => 'color',
							'label'    => esc_html__( 'Цвет ссылки', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'priority' => 131,
							'default'  => '#0056b3',
							'choices'  => [
								'alpha' => true,
							],
						],
						'color_red'        => [
							'type'     => 'color',
							'label'    => esc_html__( 'Красный цвет', 'wescle' ),
							'priority' => 131,
							'default'  => '#ef383f',
							'choices'  => [
								'alpha' => true,
							],
						],
						'color_green'        => [
							'type'     => 'color',
							'label'    => esc_html__( 'Зеленый цвет', 'wescle' ),
							'priority' => 131,
							'default'  => '#2f9c0a',
							'choices'  => [
								'alpha' => true,
							],
						],
						'color_site_hr'       => [
							'type'     => 'custom',
							'label'    => '<hr>',
							'priority' => 131,
						],
						'color_icon_menu'     => [
							'type'     => 'color',
							'label'    => esc_html__( 'Цвет иконки гамбургер-меню', 'wescle' ),
							'priority' => 131,
							'default'  => '#484848',
							'choices'  => [
								'alpha' => true,
							],
						],
						'color_icon_search'   => [
							'type'     => 'color',
							'label'    => esc_html__( 'Цвет иконки поиска', 'wescle' ),
							'priority' => 131,
							'default'  => '#626262',
							'choices'  => [
								'alpha' => true,
							],
						],
						'color_icon_account'  => [
							'type'     => Helper::is_woocommerce_active() ? 'color' : '',
							'label'    => esc_html__( 'Цвет иконки аккаунта', 'wescle' ),
							'priority' => 131,
							'default'  => '#626262',
							'choices'  => [
								'alpha' => true,
							],
						],
						'color_icon_compare'  => [
							'type'     => Helper::is_woocommerce_active() ? 'color' : '',
							'label'    => esc_html__( 'Цвет иконки сравнения', 'wescle' ),
							'priority' => 131,
							'default'  => '#626262',
							'choices'  => [
								'alpha' => true,
							],
						],
						'color_icon_wishlist' => [
							'type'     => Helper::is_woocommerce_active() ? 'color' : '',
							'label'    => esc_html__( 'Цвет иконки сердца', 'wescle' ),
							'priority' => 131,
							'default'  => '#626262',
							'choices'  => [
								'alpha' => true,
							],
						],
						'color_icon_cart'     => [
							'type'     => Helper::is_woocommerce_active() ? 'color' : '',
							'label'    => esc_html__( 'Цвет иконки корзины', 'wescle' ),
							'priority' => 131,
							'default'  => '#626262',
							'choices'  => [
								'alpha' => true,
							],
						],
						'color_icon_numbers'  => [
							'type'     => Helper::is_woocommerce_active() ? 'color' : '',
							'label'    => esc_html__( 'Цвет чисел на иконках', 'wescle' ),
							'priority' => 131,
							'default'  => '',
							'choices'  => [
								'alpha' => true,
							],
						],
						'color_icons_hover'   => [
							'type'     => Helper::is_woocommerce_active() ? 'color' : '',
							'label'    => esc_html__( 'Цвет иконок при наведении', 'wescle' ),
							'priority' => 131,
							'default'  => '',
							'choices'  => [
								'alpha' => true,
							],
						],
					],
				],
				'bg_site'     => [
					'title'    => __( 'Фон сайта', 'wescle' ),
					'controls' => [
						'content_body_bg'                   => [
							'type'     => 'radio',
							'label'    => esc_html__( 'Фон сайта', 'wescle' ),
							'priority' => 120,
							'default'  => 'default',
							'choices'  => array(
								'default' => esc_html__( 'Белый', 'wescle' ),
								'air'     => esc_html__( 'Серый', 'wescle' ),
							),
						],
						'content_color_body_bg'             => [
							'type'     => 'color',
							'label'    => esc_html__( 'Кастомный цвет фона сайта', 'wescle' ),
							'priority' => 125,
							'default'  => '',
							'choices'  => [
								'alpha' => true,
							],
						],
						'content_body_bg_image'             => [
							'type'     => 'image',
							'label'    => esc_html__( 'Фоновое изображение сайта', 'wescle' ),
							'priority' => 125,
						],
						'content_body_bg_image_size'        => [
							'type'     => 'select',
							'label'    => esc_html__( 'Режим отображения изображения', 'wescle' ),
							'priority' => 125,
							'choices'  => [
								'repeat'   => esc_html__( 'повторение в обе стороны', 'wescle' ),
								'repeat_x' => esc_html__( 'повторение вправо', 'wescle' ),
								'repeat_y' => esc_html__( 'повторение вниз', 'wescle' ),
								'norepeat' => esc_html__( 'без повторения', 'wescle' ),
							],
						],
						'content_body_bg_image_size2'       => [
							'type'     => 'checkbox',
							'label'    => esc_html__( 'Изображение на всю ширину?', 'wescle' ),
							'priority' => 125,
						],
						'content_color_body_info'           => [
							'type'     => 'custom',
							'default'  => '<h3 class="section-subtitle">' . __( 'Анимация фона сайта', 'wescle' ) . '</h3>',
							'priority' => 126,
						],
						'content_color_body_animation'      => [
							'type'     => 'switch',
							'label'    => esc_html__( 'Включить анимационный фон?', 'wescle' ),
							'priority' => 126,
							'choices'  => choices_on_off(),
						],
						'content_color_body_animation_home' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Отображать только на главной?', 'wescle' ),
							'priority'        => 126,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'content_color_body_animation',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'content_color1_body_animation'     => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет для анимации #1', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'priority'        => 126,
							'active_callback' => [
								[
									'setting'  => 'content_color_body_animation',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'content_color2_body_animation'     => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет для анимации #2', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'priority'        => 126,
							'active_callback' => [
								[
									'setting'  => 'content_color_body_animation',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'content_color3_body_animation'     => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет для анимации #3', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'priority'        => 126,
							'active_callback' => [
								[
									'setting'  => 'content_color_body_animation',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'content_color4_body_animation'     => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет для анимации #4', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'priority'        => 126,
							'active_callback' => [
								[
									'setting'  => 'content_color_body_animation',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'content_color_body_animation_time' => [
							'type'            => 'number',
							'label'           => esc_html__( 'Время анимации, секунд', 'wescle' ),
							'description'     => esc_html__( '* анимация циклическая', 'wescle' ),
							'priority'        => 126,
							'default'         => 30,
							'active_callback' => [
								[
									'setting'  => 'content_color_body_animation',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
					]
				],
				'header_site' => [
					'title'    => __( 'Шапка сайта', 'wescle' ),
					'controls' => [
						'header_box_width'                  => field_content_box_width(),
						'color_header_bg1'                  => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона шапки', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'color_header_border_enabled'       => [
							'type'    => 'checkbox',
							'default' => true,
							'label'   => esc_html__( 'Показывать разделитель?', 'wescle' ),
						],
						'color_header_border_top'           => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет полосы разделителя', 'wescle' ),
							'default'         => '#ececee',
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'color_header_border_enabled',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'color_header_bg2'                  => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона блока с меню', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'color_header_text'                 => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'header_top_bar_bg_color'           => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона топ-бара', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => 'top_bar_tabs',
								]
							],
						],
						'header_top_bar_bg_tab_active'      => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона активного таба', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => 'top_bar_tabs',
								]
							],
						],
						'header_top_bar_color_tab_active'   => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста активного таба', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => 'top_bar_tabs',
								]
							],
						],
						'header_top_bar_bg_tab_inactive'    => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона неактивного таба', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => 'top_bar_tabs',
								]
							],
						],
						'header_top_bar_color_tab_inactive' => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста неактивного таба', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => 'top_bar_tabs',
								]
							],
						],
						'header_custom'                     => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Фоновое изображение для шапки', 'wescle' ) . '</h3>',
						],
						'header_image_bg'                   => home_block_image_bg(),
						'header_image_bg_fit'               => home_block_image_bg_fit(),
						'header_image_bg_tablet'            => home_block_image_bg( 'tablet' ),
						'header_image_bg_fit_tablet'        => home_block_image_bg_fit( 'tablet' ),
						'header_image_bg_mobile'            => home_block_image_bg( 'mobile' ),
						'header_image_bg_fit_mobile'        => home_block_image_bg_fit( 'mobile' ),
						'header_menu_custom'                => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Фоновое изображение для блока с меню', 'wescle' ) . '</h3>',
						],
						'header_menu_image_bg'              => home_block_image_bg(),
						'header_menu_image_bg_fit'          => home_block_image_bg_fit(),
						'header_menu_image_bg_tablet'       => home_block_image_bg( 'tablet' ),
						'header_menu_image_bg_fit_tablet'   => home_block_image_bg_fit( 'tablet' ),
						'header_menu_image_bg_mobile'       => home_block_image_bg( 'mobile' ),
						'header_menu_image_bg_fit_mobile'   => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'footer_site' => [
					'title'    => __( 'Футер сайта', 'wescle' ),
					'controls' => [
						'footer_box_width'            => field_content_box_width(),
						'color_footer_style_phones'   => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Стиль выпадалки с телефонами', 'wescle' ),
							'default' => 'black',
							'choices' => [
								'black' => esc_html__( 'Темный', 'wescle' ),
								'white' => esc_html__( 'Светлый', 'wescle' ),
							],
						],
						'color_footer_style_location' => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Стиль выпадалки с адресами', 'wescle' ),
							'default' => 'black',
							'choices' => [
								'black' => esc_html__( 'Темный', 'wescle' ),
								'white' => esc_html__( 'Светлый', 'wescle' ),
							],
						],
						'color_footer_bg'             => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона подвала', 'wescle' ),
							'default' => '#282828',
							'choices' => [
								'alpha' => true,
							],
						],
						'color_footer_title'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет заголовков в подвале', 'wescle' ),
							'default' => '#7c7c7d',
							'choices' => [
								'alpha' => true,
							],
						],
						'color_footer_line'           => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет линий в подвале', 'wescle' ),
							'default' => '#484848',
							'choices' => [
								'alpha' => true,
							],
						],
						'color_footer_text'           => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ),
							'default' => '#ffffff',
							'choices' => [
								'alpha' => true,
							],
						],
						'color_footer_link'           => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет ссылок', 'wescle' ),
							'default' => '#ffffff',
							'choices' => [
								'alpha' => true,
							],
						],
						'color_footer_link_hover'     => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет ссылок', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'default' => '#7c7c7d',
							'choices' => [
								'alpha' => true,
							],
						],
						'footer_custom'               => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Фоновое изображение', 'wescle' ) . '</h3>',
						],
						'footer_image_bg'             => home_block_image_bg(),
						'footer_image_bg_fit'         => home_block_image_bg_fit(),
						'footer_image_bg_tablet'      => home_block_image_bg( 'tablet' ),
						'footer_image_bg_fit_tablet'  => home_block_image_bg_fit( 'tablet' ),
						'footer_image_bg_mobile'      => home_block_image_bg( 'mobile' ),
						'footer_image_bg_fit_mobile'  => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'scroll_site' => [
					'title'    => __( 'Стиль скролла', 'wescle' ),
					'controls' => [
						'color_scroll'       => [
							'type'        => 'color',
							'label'       => esc_html__( 'Цвет скролла, базовый цвет', 'wescle' ),
							'description' => __( 'Работает в браузерах, основанных на Chromium', 'wescle' ),
							'default'     => '#888888',
							'choices'     => [
								'alpha' => true,
							],
						],
						'color_scroll_hover' => [
							'type'        => 'color',
							'label'       => esc_html__( 'Цвет скролла, при наведении', 'wescle' ),
							'description' => __( 'Работает в браузерах, основанных на Chromium', 'wescle' ),
							'default'     => '#555555',
							'choices'     => [
								'alpha' => true,
							],
						],
						'bg_scroll'          => [
							'type'        => 'color',
							'label'       => esc_html__( 'Фон скролла', 'wescle' ),
							'description' => __( 'Работает в браузерах, основанных на Chromium', 'wescle' ),
							'choices'     => [
								'alpha' => true,
							],
						],
						'width_scroll'       => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Ширина скролла страницы', 'wescle' ),
							'default' => 7,
							'choices' => [
								'min'  => 2,
								'max'  => 20,
								'step' => 1,
							],
						],
						'width_scroll_block' => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Ширина скролла в блоках с контентом', 'wescle' ),
							'default' => 5,
							'choices' => [
								'min'  => 2,
								'max'  => 20,
								'step' => 1,
							],
						],
					]
				],

				'font_site'      => [
					'title'    => __( 'Настройка шрифтов', 'wescle' ),
					'controls' => [
						'font_custom'          => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Загрузить кастомный шрифт?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'font_custom_name'     => [
							'type'            => 'text',
							'label'           => esc_html__( 'Имя шрифта', 'wescle' ),
							'active_callback' => active_field_for_custom( 'font_custom' )
						],
						'font_custom_regular'  => [
							'type'            => 'upload',
							'label'           => esc_html__( 'Regular', 'wescle' ),
							'mime_type'       => 'application/x-font-woff2',
							'active_callback' => active_field_for_custom( 'font_custom' )
						],
						'font_custom_light'    => [
							'type'            => 'upload',
							'label'           => esc_html__( 'Light', 'wescle' ),
							'mime_type'       => 'application/x-font-woff2',
							'active_callback' => active_field_for_custom( 'font_custom' )
						],
						'font_custom_bold'     => [
							'type'            => 'upload',
							'label'           => esc_html__( 'Bold', 'wescle' ),
							'mime_type'       => 'application/x-font-woff2',
							'active_callback' => active_field_for_custom( 'font_custom' )
						],
						'font_custom_medium'   => [
							'type'            => 'upload',
							'label'           => esc_html__( 'Medium', 'wescle' ),
							'mime_type'       => 'application/x-font-woff2',
							'active_callback' => active_field_for_custom( 'font_custom' )
						],
						'font_custom_semibild' => [
							'type'            => 'upload',
							'label'           => esc_html__( 'Semibold', 'wescle' ),
							'mime_type'       => 'application/x-font-woff2',
							'active_callback' => active_field_for_custom( 'font_custom' )
						],
						'font_custom_sep'      => [
							'type'    => 'custom',
							'default' => '<hr>',
						],

						'font_family'                  => [
							'type'            => 'typography',
							'label'           => '',
							'priority'        => 131,
							'default'         => array(
								//'font-style'     => array( 'bold', 'italic' ),
								'font-family' => 'Montserrat',
							),
							'choices'         => array(
								//'font-style'     => true,
								'font-family' => true,
								'fonts'       => [
									'google' => [ 'popularity', 30 ],
								],
							),
							'active_callback' => active_field_for_custom( 'font_custom', '!=' )
						],
						'font_size_home_title_label'   => [
							'type'     => 'custom',
							'default'  => '<h3 class="section-subtitle">' . __( 'Размер заголовков в блоках на главной странице, px', 'wescle' ) . '</h3>',
							'priority' => 131,
						],
						'font_size_home_title_desktop' => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на ПК (1280-1920)', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_home_title_tablet'  => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на планшете (768-1280)', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_home_title_mobile'  => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на телефоне (320-768)', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h1_label'           => [
							'type'     => 'custom',
							'default'  => '<h3 class="section-subtitle">' . __( 'Размер H1, px', 'wescle' ) . '</h3>',
							'priority' => 131,
						],
						'font_size_h1_desktop'         => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на ПК (1280-1920)', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h1_tablet'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на планшете (768-1280)', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h1_mobile'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на телефоне (320-768)', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h2_label'           => [
							'type'     => 'custom',
							'default'  => '<h3 class="section-subtitle">' . __( 'Размер H2, px', 'wescle' ) . '</h3>',
							'priority' => 131,
						],
						'font_size_h2_desktop'         => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на ПК (1280-1920), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h2_tablet'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на планшете (768-1280), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h2_mobile'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на телефоне (320-768), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h3_label'           => [
							'type'     => 'custom',
							'default'  => '<h3 class="section-subtitle">' . __( 'Размер H3, px', 'wescle' ) . '</h3>',
							'priority' => 131,
						],
						'font_size_h3_desktop'         => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на ПК (1280-1920), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h3_tablet'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на планшете (768-1280), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h3_mobile'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на телефоне (320-768), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h4_label'           => [
							'type'     => 'custom',
							'default'  => '<h3 class="section-subtitle">' . __( 'Размер H4, px', 'wescle' ) . '</h3>',
							'priority' => 131,
						],
						'font_size_h4_desktop'         => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на ПК (1280-1920), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h4_tablet'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на планшете (768-1280), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h4_mobile'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на телефоне (320-768), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h5_label'           => [
							'type'     => 'custom',
							'default'  => '<h3 class="section-subtitle">' . __( 'Размер H5, px', 'wescle' ) . '</h3>',
							'priority' => 131,
						],
						'font_size_h5_desktop'         => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на ПК (1280-1920), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h5_tablet'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на планшете (768-1280), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h5_mobile'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на телефоне (320-768), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h6_label'           => [
							'type'     => 'custom',
							'default'  => '<h3 class="section-subtitle">' . __( 'Размер H6, px', 'wescle' ) . '</h3>',
							'priority' => 131,
						],
						'font_size_h6_desktop'         => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на ПК (1280-1920), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h6_tablet'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на планшете (768-1280), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_h6_mobile'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на телефоне (320-768), px', 'wescle' ),
							'default'  => 10,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 100,
								'step' => 1,
							],
						],
						'font_size_p_label'            => [
							'type'     => 'custom',
							'default'  => '<h3 class="section-subtitle">' . __( 'Размер текста параграфа, px', 'wescle' ) . '</h3>',
							'priority' => 131,
						],
						'font_size_p_desktop'          => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на ПК (1280-1920), px', 'wescle' ),
							'default'  => 16,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 50,
								'step' => 1,
							],
						],
						'font_size_p_tablet'           => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на планшете (768-1280), px', 'wescle' ),
							'default'  => 16,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 50,
								'step' => 1,
							],
						],
						'font_size_p_mobile'           => [
							'type'     => 'slider',
							'label'    => esc_html__( 'на телефоне (320-768), px', 'wescle' ),
							'default'  => 16,
							'priority' => 131,
							'choices'  => [
								'min'  => 10,
								'max'  => 50,
								'step' => 1,
							],
						],
					]
				],
				'buttons_site'   => [
					'title'    => __( 'Кнопки', 'wescle' ),
					'controls' => [

					]
				],
				'label_tag_site' => [
					'title'    => __( 'Стиль меток и категорий', 'wescle' ),
					'controls' => [
						'label_tag_info'             => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Стиль тегов', 'wescle' ) . '</h3>',
						],
						'label_tag_color'            => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ),
							'default' => '#ffffff',
							'choices' => [
								'alpha' => true,
							],
						],
						'label_tag_bg'               => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'label_tag_color_hover'      => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'default' => '#ececee',
							'choices' => [
								'alpha' => true,
							],
						],
						'label_tag_bg_hover'         => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'label_category_info'        => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Стиль категорий', 'wescle' ) . '</h3>',
							'choices' => [
								'alpha' => true,
							],
						],
						'label_category_color'       => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ),
							'default' => '#ffffff',
							'choices' => [
								'alpha' => true,
							],
						],
						'label_category_bg'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'label_category_color_hover' => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'default' => '#ececee',
							'choices' => [
								'alpha' => true,
							],
						],
						'label_category_bg_hover'    => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
					]
				],
				'primary_menu'   => [
					'title'    => __( 'Цвет ссылок в главном меню', 'wescle' ),
					'controls' => [
						'primary_menu_info'             => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Цвет ссылок первого уровня', 'wescle' ) . '</h3>',
						],
						'primary_menu_link_color'       => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет', 'wescle' ),
							'default' => '#484848',
							'choices' => [
								'alpha' => true,
							],
						],
						'primary_menu_link_color_hover' => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'default' => '#484848',
							'choices' => [
								'alpha' => true,
							],
						],

						'primary_menu_info2'             => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Цвет ссылок второго уровня', 'wescle' ) . '</h3>',
						],
						'primary_menu_link2_color'       => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет', 'wescle' ),
							'default' => '#484848',
							'choices' => [
								'alpha' => true,
							],
						],
						'primary_menu_link2_color_hover' => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'default' => '#484848',
							'choices' => [
								'alpha' => true,
							],
						],
						'primary_menu_link2_bg'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона при наведении на объект', 'wescle' ),
							'default' => '#ececee',
							'choices' => [
								'alpha' => true,
							],
						],
					]
				],

				'burger_menu' => [
					'title'    => __( 'Бургер меню', 'wescle' ),
					'controls' => [
						'burger_menu_light'       => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет ссылок и текста', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'header_menu_burger_dark',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'burger_menu_light_hover' => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет наведения фона', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'header_menu_burger_dark',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'burger_menu_dark'        => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона "вне телефона"', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'header_menu_burger_dark',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'burger_menu_dark_hover'  => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона "под телефоном"', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'header_menu_burger_dark',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'burger_menu_dark_text'   => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона для "Рабочие дни"', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'header_menu_burger_dark',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
					]
				],

				'fixed_buttons_site' => [
					'title'    => __( 'Стиль плавающих кнопок', 'wescle' ),
					'controls' => [
						'fixed_buttons_color'       => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет иконки', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'fixed_buttons_bg'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'fixed_buttons_color_hover' => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет иконки', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'fixed_buttons_bg_hover'    => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
					]
				],
				'working_days_site'  => [
					'title'    => __( 'Стиль для "Рабочие дни"', 'wescle' ),
					'controls' => [
						'working_days_header'         => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Настройки для дней в шапке', 'wescle' ) . '</h3>',
						],
						'working_days_header_color'   => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста рабочего дня', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'working_days_header_bg'      => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон рабочего дня', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'working_days_header_color_2' => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста нерабочего дня', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'working_days_header_bg_2'    => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон нерабочего дня', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'working_days_footer'         => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Настройки для дней в footer', 'wescle' ) . '</h3>',
						],
						'working_days_footer_color'   => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста рабочего дня', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'working_days_footer_bg'      => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон рабочего дня', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'working_days_footer_color_2' => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста нерабочего дня', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'working_days_footer_bg_2'    => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон нерабочего дня', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
					]
				],
			]
		],

		'header_tab' => [
			'title'    => __( 'Настройка шапки', 'wescle' ),
			'priority' => 30,
			'sections' => [
				'top_banner' => [
					'title'    => __( 'Топ баннер', 'wescle' ),
					'controls' => [
						'top_banner_cookie_live'  => [
							'type'    => 'number',
							'label'   => esc_html__( 'Время жизни куки, дней', 'wescle' ),
							'default' => '7',
						],
						'top_banner_bg'           => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона', 'wescle' ),
							'default' => '#0088cc',
							'choices' => [
								'alpha' => true,
							],
						],
						'top_banner_color'        => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ),
							'default' => '#ffffff',
							'choices' => [
								'alpha' => true,
							],
						],
						'top_banner_slides_logic' => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Слайды', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Слайд', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить слайд', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'text'         => [
									'type'    => 'textarea',
									'label'   => esc_html__( 'Текст', 'wescle' ),
									'default' => '',
								],
								'button_link'  => [
									'type'    => 'text',
									'label'   => esc_html__( 'Ссылка', 'wescle' ),
									'default' => '',
								],
								'target_blank' => [
									'type'    => 'checkbox',
									'default' => true,
									'label'   => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
								],
								'button_text'  => [
									'type'    => 'text',
									'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
									'default' => __( 'Подробнее', 'wescle' ),
								],
								'logic_items'  => [
									'type'        => 'select',
									'label'       => esc_html__( 'На каких страницах отображать слайд?', 'wescle' ),
									'default'     => [],
									'multiple'    => 999,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts_and_category(),
								]
							],
							'selector'     => '.top-banner .container'
						]
					]
				],

				'top_bar' => [
					'title'    => __( 'Топ бар', 'wescle' ),
					'controls' => [
						'top_bar_enabled'         => [
							'type'     => 'switch',
							'label'    => esc_html__( 'Включить блок', 'wescle' ),
							'default'  => false,
							'choices'  => choices_on_off(),
							'selector' => '.top-bar .container'
						],
						'top_bar_menu_info'       => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . __( 'Выбрать меню можно в разделе', 'wescle' ) . ' <a href="#" data-section="' . esc_js( json_encode( [ "name" => "menu_locations" ] ) ) . '" class="customizer-edit">' . __( 'Меню', 'wescle' ) . '</a></div>',
						],
						'top_bar_socials_enabled' => [
							'type'     => 'switch',
							'label'    => esc_html__( 'Отображать соц. сети?', 'wescle' ),
							'default'  => true,
							'choices'  => choices_on_off(),
							'selector' => '.socials-top-bar'
						],
						'top_bar_socials_count'   => [
							'type'            => 'number',
							'label'           => esc_html__( 'Количество видимых соц. сетей ', 'wescle' ),
							'default'         => 4,
							'choices'         => [
								'min'  => 1,
								'max'  => 4,
								'step' => 1,
							],
							'active_callback' => [
								[
									'setting'  => 'top_bar_socials_enabled',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'top_bar_store_enabled'   => [
							'type'    => Helper::is_woocommerce_active() ? 'switch' : '',
							'label'   => esc_html__( 'Отображать иконки магазина?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'top_bar_bg_color'        => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона топ-бара', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
					]
				],

				'address'                        => [
					'title'    => __( 'Адрес', 'wescle' ),
					'controls' => [
						'address_image'  => [
							'type'    => 'image',
							'label'   => esc_html__( 'Изображение', 'wescle' ),
							'choices' => array(
								'save_as' => 'id'
							),
						],
						'address_text'   => [
							'type'     => 'textarea',
							'label'    => esc_html__( 'Адрес', 'wescle' ),
							'default'  => Helper::get_default_theme_data( 'address_text' ),
							'selector' => '.header-top__location'
						],
						'address_link'   => [
							'type'    => 'link',
							'label'   => esc_html__( 'Ссылка', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'address_link' )
						],
						'address_others' => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Дополнительные адреса', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Адрес', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить адрес', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'text'  => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
								'url'   => [
									'type'  => 'text',
									'label' => esc_html__( 'Ссылка', 'wescle' ),
								],
								'image' => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение', 'wescle' ),
								],
							]
						]
					]
				],
				'phone'                          => [
					'title'    => __( 'Телефон', 'wescle' ),
					'controls' => [
						'phones_hide_enabled' => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Прятать номера телефонов от поисковиков, spam-ботов', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'phones_hide_count'   => [
							'type'            => 'number',
							'label'           => esc_html__( 'Количество символов, которое нужно спрятать', 'wescle' ),
							'description'     => esc_html__( 'учитывая пробелы, скобки, дефисы', 'wescle' ),
							'default'         => 5,
							'choices'         => [
								'min'  => 1,
								'max'  => 8,
								'step' => 1,
							],
							'active_callback' => [
								[
									'setting'  => 'phones_hide_enabled',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'phone_primary'       => [
							'type'     => 'text',
							'label'    => esc_html__( 'Телефон основной', 'wescle' ),
							'default'  => Helper::get_default_theme_data( 'phone_primary' ),
							'selector' => '.telephone__content',
						],
						'phone_type'          => phone_type_block(),
						'phone_icon'          => phone_icon_operator(),
						'phone_username'      => [
							'type'        => 'text',
							'label'       => esc_html__( 'Укажите <username>', 'wescle' ),
							'description' => __( 'если выбрали "Тип телефона" как:<br/><code>telegram</code> или <code>skype</code>, или <code>wechat</code>', 'wescle' ),
						],
						'work_time'           => [
							'type'              => 'text',
							'label'             => esc_html__( 'Рабочее время', 'wescle' ),
							'default'           => Helper::get_default_theme_data( 'work_time' ),
							'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
						],
						'phone_others'        => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Дополнительные телефоны', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Телефон', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить телефон', 'wescle' ),
							'default'      => Helper::get_default_theme_data( 'phones' ),
							'fields'       => [
								'phone_type'          => phone_type_block(),
								'phone_icon'          => phone_icon_operator(),
								'phone_operator'      => phone_operator_block( $label_select ),
								'phone'               => [
									'type'  => 'text',
									'label' => esc_html__( 'Номер телефона', 'wescle' ),
								],
								'phone_label'         => [
									'type'  => 'text',
									'label' => esc_html__( 'Надпись возле иконки, вместо номера телефона', 'wescle' ),
								],
								'phone_label_is_link' => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Сделать надпись ссылкой?', 'wescle' ),
								],
								'phone_username'      => [
									'type'        => 'text',
									'label'       => esc_html__( 'Укажите <username>', 'wescle' ),
									'description' => __( 'если выбрали "Тип телефона" как:<br/><code>telegram</code> или <code>skype</code>, или <code>wechat</code>', 'wescle' ),
								],
							]
						],
						'phone_email'         => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать email?', 'wescle' ),
							'default' => 0,
							'choices' => choices_on_off(),
						],
						'phone_email_info'    => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . __( 'Указать email можно в разделе', 'wescle' ) . ' <a href="#" data-section="' . esc_js( json_encode( [ "name" => "email" ] ) ) . '" class="customizer-edit">' . __( 'Настройка подвала -> E-mail', 'wescle' ) . '</a></div>',
						],
					],
				],
				'working_days'                   => [
					'title'    => __( 'Рабочие дни', 'wescle' ),
					'controls' => [
						'working_days_list' => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Отметьте рабочие дни', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'working_days_list' ),
							'choices' => Helper::choices_working_days()
						],
					]
				],
				'button_callback'                => [
					'title'    => __( 'Кнопка', 'wescle' ),
					'controls' => [
						'button_title'        => [
							'type'     => 'text',
							'label'    => esc_html__( 'Название кнопки', 'wescle' ),
							'default'  => esc_html__( 'Заказать звонок', 'wescle' ),
							'priority' => 10,
							'selector' => '.header-top__btn'
						],
						'button_is_default'   => [
							'type'     => 'switch',
							'label'    => esc_html__( 'Обычная кнопка', 'wescle' ),
							'default'  => 0,
							'priority' => 20,
							'choices'  => choices_on_off(),
						],
						'button_page_link'    => [
							'type'            => 'select',
							'label'           => esc_html__( 'Укажите страницу/запись', 'wescle' ),
							'default'         => 0,
							'priority'        => 30,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'choices'         => Helper::get_posts( array(
								'post_type' => [ 'post', 'page' ]
							) ),
							'active_callback' => [
								[
									'setting'  => 'button_is_default',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'button_custom_link'  => [
							'type'            => 'url',
							'label'           => esc_html__( 'Или укажите свой УРЛ', 'wescle' ),
							'default'         => '',
							'priority'        => 40,
							'active_callback' => [
								[
									'setting'  => 'button_is_default',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
						'callback_сf7'        => [
							'type'            => class_exists( 'WPCF7_Mail' ) ? 'select' : '',
							'label'           => esc_html__( 'Выберите форму CF7', 'wescle' ),
							'default'         => isset( $installed_forms['callback'] ) ? $installed_forms['callback'] : 0,
							'priority'        => 15,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'choices'         => Helper::get_posts( array(
								'post_type' => 'wpcf7_contact_form'
							) ),
							'active_callback' => [
								[
									'setting'  => 'button_is_default',
									'operator' => '==',
									'value'    => false,
								],
							],
						],
						'callback_сf7_notice' => [
							'type'            => class_exists( 'WPCF7_Mail' ) ? '' : 'custom',
							'label'           => esc_html__( 'Выберите форму CF7', 'wescle' ),
							'default'         => '<div class="notice notice-warning section-description">' . $notice_cf7 . '</div>',
							'priority'        => 15,
							'active_callback' => [
								[
									'setting'  => 'button_is_default',
									'operator' => '==',
									'value'    => false,
								],
							],
						],
						'phone_mask'          => [
							'type'     => 'radio',
							'label'    => esc_html__( 'Маска телефона', 'wescle' ),
							'default'  => 'none',
							'priority' => 60,
							'choices'  => [
								'none' => esc_html__( 'без маски', 'wescle' ),
								'ru'   => 'RU',
								'ua'   => 'UA',
								'de1'  => 'DE +(49 XXX)',
								'de2'  => 'DE +(49 XX)',
								'by'   => 'BY +375',
								'usa'  => 'USA +1 (XXX-XXX-XXXX)',
								'lva'  => 'LVA +371',
								'lt'   => 'LT +370',
							]
						],
						'phone_mask_help'     => [
							'type'     => 'custom',
							'default'  => '<div class="notice notice-warning section-description">' . sprintf(
									__( 'Нужны маски телефона под другие виды стран? Напишите нам в поддержку, поможем вам. Авторизируйтесь в свой аккаунт на нашем сайте <a href="%s" target="_blank" rel="noopener">wescle.com</a>, в разделе "Служба поддержки" создайте тикет с темой "Добавление маски для телефона".', 'wescle' ),
									'https://wescle.com/dashboard/'
								) . '</div>',
							'priority' => 70,
						],
					]
				],
				'section_header_block_sortable'  => [
					'title'    => esc_html__( 'Порядок блоков', 'wescle' ),
					'controls' => [
						'header_logo_position'    => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Где показывать лого?', 'wescle' ),
							'default' => 'left',
							'choices' => [
								'left'  => is_rtl() ? esc_html__( 'Показывать Лого и описание справа', 'wescle' ) : esc_html__( 'Показывать Лого и описание слева', 'wescle' ),
								'right' => is_rtl() ? esc_html__( 'Показывать Лого и описание слева', 'wescle' ) : esc_html__( 'Показывать Лого и описание справа', 'wescle' ),
							],
						],
						'header_logo_block_width' => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Ширина блока с лого и описанием', 'wescle' ) . ',%',
							'default' => 35,
							'choices' => [
								'min'  => 25,
								'max'  => 70,
								'step' => 1,
							],
						],
						'header_block_sortable'   => [
							'type'    => 'sortable',
							'label'   => esc_html__( 'Порядок блоков', 'wescle' ),
							'default' => [
								'address',
								'phone',
								'button',
							],
							'choices' => [
								'address' => esc_html__( 'Адрес', 'wescle' ),
								'phone'   => esc_html__( 'Телефон', 'wescle' ),
								'button'  => esc_html__( 'Кнопка', 'wescle' ),
							],
						],
						'header_icons_sortable'   => [
							'type'     => Helper::is_woocommerce_active() ? 'sortable' : '',
							'label'    => esc_html__( 'Порядок иконок', 'wescle' ),
							'default'  => Helper::get_default_theme_data( 'header_icons_sortable' ),
							'choices'  => [
								'currency_switcher' => esc_html__( 'Переключатель валюты', 'wescle' ),
								'account'           => esc_html__( 'Аккаунт', 'wescle' ),
								'compare'           => esc_html__( 'Сравнение', 'wescle' ),
								'wishlist'          => esc_html__( 'Избранные', 'wescle' ),
								'cart'              => esc_html__( 'Корзина', 'wescle' ),
							],
							'selector' => '.navigation-store'
						],
					]
				],
				'section_header_block_show_hide' => [
					'title'    => esc_html__( 'Положение шапки', 'wescle' ),
					'controls' => [
						'header_block_hide_scroll' => [
							'type'    => 'switch',
							'label'   => esc_html__( 'При скроле вниз шапка исчезает', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'header_block_static'      => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Шапка статическая', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'header_block_hide_scroll',
									'operator' => '==',
									'value'    => false,
								]
							]
						],
					]
				],
				'header_type'                    => [
					'title'    => esc_html__( 'Вид шапки', 'wescle' ),
					'controls' => [
						'header_block_logo'       => [
							'type'            => 'radio',
							'label'           => esc_html__( 'Вид логотипа с блоками', 'wescle' ),
							'default'         => '',
							'choices'         => [
								''                   => __( 'базовый', 'wescle' ),
								'center'             => __( 'только логотип с описанием по центру', 'wescle' ),
								'right'              => __( 'только логотип с описанием по центру, описание первым', 'wescle' ),
								'logo_social'        => __( 'логотип и соц. сети', 'wescle' ),
								'logo_social_revert' => is_rtl() ? __( 'логотип слева, соц. сети справа', 'wescle' ) : __( 'логотип справа, соц. сети слева', 'wescle' ),
							],
							'active_callback' => [
								[
									'setting'  => 'header_oneline',
									'operator' => '==',
									'value'    => false,
								],
								[
									'setting'  => 'header_block_type',
									'operator' => '!=',
									'value'    => 'top_bar_tabs',
								],
								[
									'setting'  => 'header_block_type',
									'operator' => '!=',
									'value'    => 'store_logo_center',
								]
							],
							'selector'        => '.header__navigation .vertical-menu'
						],
						'header_block_type'       => header_block_type_field(),
						'header_oneline'          => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Логотип и меню на одном уровне?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => '',
								]
							]
						],
						'header_store_menu'       => [
							'type'            => Helper::is_woocommerce_active() ? 'switch' : '',
							'label'           => esc_html__( 'Показывать меню категорий?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => 'store',
								]
							]
						],
						'header_store_menu_info'  => [
							'type'            => ( Helper::is_woocommerce_active() && ! $menu_header_store ) ? 'custom' : '',
							'default'         => '<div class="notice notice-warning section-description">' . sprintf( __( 'Создайте <a href="%s" target="_blank">новое меню</a> и отметьте область отображения "Меню с категориями магазина"', 'wescle' ), admin_url( '/nav-menus.php?action=edit&menu=0' ) ) . '</div>',
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => 'store',
								],
								[
									'setting'  => 'header_store_menu',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'header_store_menu_title' => [
							'type'            => Helper::is_woocommerce_active() ? 'text' : '',
							'label'           => esc_html__( 'Заголовок меню с категориями', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'header_store_menu_label' ),
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => 'store',
								]
							]
						],

						'store_logo_center_icons_sortable' => [
							'type'            => Helper::is_woocommerce_active() ? 'sortable' : '',
							'label'           => esc_html__( 'Порядок иконок', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'store_logo_center_icons_sortable' ),
							'choices'         => [
								'currency_switcher' => esc_html__( 'Переключатель валюты', 'wescle' ),
								'search'            => esc_html__( 'Поиск', 'wescle' ),
								'compare'           => esc_html__( 'Сравнение', 'wescle' ),
								'wishlist'          => esc_html__( 'Избранные', 'wescle' ),
								'cart'              => esc_html__( 'Корзина', 'wescle' ),
								'lang_switcher'     => esc_html__( 'Переключатель языка', 'wescle' ),
								'account'           => esc_html__( 'Аккаунт', 'wescle' ),
							],
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => 'store_logo_center',
								]
							]
						],

						'header_store_cart_big'      => [
							'type'            => Helper::is_woocommerce_active() ? 'switch' : '',
							'label'           => esc_html__( 'Боковая корзина?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'header_block_type',
										'operator' => '==',
										'value'    => 'store',
									],
									[
										'setting'  => 'header_block_type',
										'operator' => '==',
										'value'    => 'store_logo_center',
									]
								]
							]
						],
						'header_store_cart_big_open' => [
							'type'            => Helper::is_woocommerce_active() ? 'switch' : '',
							'label'           => esc_html__( 'Открывать корзину после добавления товара?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'header_block_type',
										'operator' => '==',
										'value'    => 'store',
									],
									[
										'setting'  => 'header_block_type',
										'operator' => '==',
										'value'    => 'store_logo_center',
									]
								],
								[
									'setting'  => 'header_store_cart_big',
									'operator' => '==',
									'value'    => true,
								],
							]
						],
						'header_store_cart_bg_color' => [
							'type'            => Helper::is_woocommerce_active() ? 'color' : '',
							'label'           => esc_html__( 'Затемнение фона', 'wescle' ),
							'default'         => 'rgba(0,0,0,0.5)',
							'choices'         => [
								'alpha' => true,
							],
							'output'          => array(
								array(
									'element'  => 'body._cart-big .navigation-store__cart .widget_shopping_cart',
									'property' => 'background',
								),
							),
							'active_callback' => [
								[
									[
										'setting'  => 'header_block_type',
										'operator' => '==',
										'value'    => 'store',
									],
									[
										'setting'  => 'header_block_type',
										'operator' => '==',
										'value'    => 'store_logo_center',
									]
								],
								[
									'setting'  => 'header_store_cart_big',
									'operator' => '==',
									'value'    => true,
								]
							]
						],

						'header_bar_tabs_menu'       => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Табы и меню', 'wescle' ),
							'row_label'       => [
								'type'  => 'text',
								'value' => esc_html__( 'Таб с меню', 'wescle' ),
							],
							'button_label'    => esc_html__( 'Добавить таб', 'wescle' ),
							'default'         => [],
							'fields'          => [
								'title'   => [
									'type'  => 'text',
									'label' => esc_html__( 'Название таба', 'wescle' ),
								],
								'menu_id' => [
									'type'    => 'select',
									'label'   => esc_html__( 'Меню', 'wescle' ),
									'choices' => [ $label_select ] + wp_get_nav_menus( [ 'fields' => 'id=>name' ] )
								]
							],
							'active_callback' => active_field_for_top_tabs(),
						],
						'header_bar_address_info'    => [
							'type'            => 'custom',
							'default'         => '<div class="notice notice-warning section-description">' . __( 'Добавить адрес можно в разделе', 'wescle' ) . ' <a href="#" data-section="' . esc_js( json_encode( [ "name" => "address" ] ) ) . '" class="customizer-edit">' . __( 'Адрес', 'wescle' ) . '</a></div>',
							'active_callback' => active_field_for_top_tabs(),
						],
						'header_bar_email'           => [
							'type'            => 'text',
							'label'           => esc_html__( 'Email', 'wescle' ),
							'active_callback' => active_field_for_top_tabs(),
						],
						'header_bar_socials_enabled' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Отображать соц. сети?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => active_field_for_top_tabs(),
						],
						'header_bar_socials_count'   => [
							'type'            => 'number',
							'label'           => esc_html__( 'Количество видимых соц. сетей ', 'wescle' ),
							'default'         => 4,
							'choices'         => [
								'min'  => 1,
								'max'  => 4,
								'step' => 1,
							],
							'active_callback' => [
								[
									'setting'  => 'header_block_type',
									'operator' => '==',
									'value'    => 'top_bar_tabs',
								],
								[
									'setting'  => 'header_bar_socials_enabled',
									'operator' => '==',
									'value'    => true,
								],
							],
						],
					]
				],

				'menu_type' => [
					'title'    => esc_html__( 'Настройки меню', 'wescle' ),
					'controls' => [
						'header_menu_mobile_label' => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись "Меню"', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'header_menu_mobile_label' )
						],
						'header_menu_fullwidth'    => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Выпадающее меню на всю ширину?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off()
						],
						'header_menu_burger_dark'  => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Темный стиль бургер-меню?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off()
						],
					]
				],
			]
		],

		'footer_tab' => [
			'title'    => __( 'Настройка подвала', 'wescle' ),
			'priority' => 30,

			'sections' => [
				'subscribe'                     => [
					'title'    => __( 'Форма подписки', 'wescle' ),
					'controls' => [
						'footer_subscribe_text'       => [
							'type'            => 'text',
							'label'           => esc_html__( 'Текст возле формы', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'footer_subscribe_text' ),
							'partial_refresh' => array(
								'footer_subscribe_text_shortcut' => array(
									'selector'        => '.form-subscribe__label span',
									'render_callback' => function () {
										return get_theme_mod( 'footer_subscribe_text' );
									}
								)
							)
						],
						'footer_subscribe_cf7'        => cf7_type_block( $label_select, '', 'subscribe-footer' ),
						'footer_subscribe_cf7_notice' => [
							'type'    => class_exists( 'WPCF7_Mail' ) ? '' : 'custom',
							'label'   => esc_html__( 'Выберите форму CF7', 'wescle' ),
							'default' => '<div class="notice notice-warning section-description">' . $notice_cf7 . '</div>',
						]
					]
				],
				'email'                         => [
					'title'    => __( 'E-mail', 'wescle' ),
					'controls' => [
						'email_primary_info' => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . __( 'Для отображения контактов в подвале нужно добавить виджет <strong>"Wescle: Контакты"</strong> в разделе', 'wescle' ) . ' <a href="#" data-section="' . esc_js( json_encode( [ "name" => "sidebar-widgets-sidebar-footer" ] ) ) . '" class="customizer-edit">' . __( 'Виджеты - Виджеты в подвале', 'wescle' ) . '</a></div>',
						],
						'email_primary'      => [
							'type'    => 'email',
							'label'   => esc_html__( 'E-mail основной', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'email_primary' )
						],
						'email_others'       => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Дополнительные e-mail', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'E-mail', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить E-mail', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'email' => [
									'type'  => 'text',
									'label' => esc_html__( 'Дополнительный E-mail', 'wescle' ),
								]
							]
						]
					]
				],
				'copyright_section'             => [
					'title'    => __( 'Копирайт', 'wescle' ),
					'controls' => [
						'copyright' => [
							'type'        => 'text',
							'label'       => esc_html__( 'Копирайт', 'wescle' ),
							'description' => __( 'Используйте <code>#year#</code>, чтобы добавить текущий год', 'wescle' ),
							'default'     => '© #year# ' . get_bloginfo( 'name' ),
							'selector'    => '.footer__copyright'
						],
					]
				],
				'footer_text_images'            => [
					'title'    => __( 'Текст / Изображения', 'wescle' ),
					'controls' => [
						'footer_text'   => [
							'type'     => 'textarea',
							'label'    => esc_html__( 'Текст', 'wescle' ),
							'default'  => '',
							'selector' => '.footer__text'
						],
						'footer_images' => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Изображения', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Изображение', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить изображение', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image'       => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'default' => '',
								],
								'button_link' => [
									'type'    => 'text',
									'label'   => esc_html__( 'Ссылка', 'wescle' ),
									'default' => '',
								],
							],
							'selector'     => '._payments-list'
						],
					]
				],
				'social_links'                  => [
					'title'    => __( 'Социальные ссылки', 'wescle' ),
					'controls' => [
						'social_links_as_span' => [
							'type'        => 'switch',
							'label'       => esc_html__( 'Прятать ссылки от поисковиков', 'wescle' ),
							'description' => esc_html__( 'ссылки будут выведены через тег <span>', 'wescle' ),
							'default'     => true,
							'choices'     => choices_on_off(),
							'selector'    => '.footer__socials'
						],

						'social_fb'             => [
							'type'     => 'url',
							'label'    => esc_html__( 'Facebook', 'wescle' ),
							'default'  => '#',
							'selector' => '.socials-bar'
						],
						'social_fb_color'       => social_item_color(),
						'social_fb_color_hover' => social_item_color_hover(),

						'social_tw'             => [
							'type'    => 'url',
							'label'   => esc_html__( 'Twitter', 'wescle' ),
							'default' => '#',
						],
						'social_tw_color'       => social_item_color(),
						'social_tw_color_hover' => social_item_color_hover(),

						'social_inst'             => [
							'type'    => 'url',
							'label'   => esc_html__( 'Instagram', 'wescle' ),
							'default' => '#',
						],
						'social_inst_color'       => social_item_color(),
						'social_inst_color_hover' => social_item_color_hover(),

						'social_telegram'             => [
							'type'    => 'url',
							'label'   => esc_html__( 'Telegram', 'wescle' ),
							'default' => '#',
						],
						'social_telegram_color'       => social_item_color(),
						'social_telegram_color_hover' => social_item_color_hover(),

						'social_linked'             => [
							'type'    => 'url',
							'label'   => esc_html__( 'Linkedin', 'wescle' ),
							'default' => '#',
						],
						'social_linked_color'       => social_item_color(),
						'social_linked_color_hover' => social_item_color_hover(),

						'social_pi'             => [
							'type'    => 'url',
							'label'   => esc_html__( 'Pinterest', 'wescle' ),
							'default' => '#',
						],
						'social_pi_color'       => social_item_color(),
						'social_pi_color_hover' => social_item_color_hover(),

						'social_yt'             => [
							'type'    => 'url',
							'label'   => esc_html__( 'Youtube', 'wescle' ),
							'default' => '#',
						],
						'social_yt_color'       => social_item_color(),
						'social_yt_color_hover' => social_item_color_hover(),

						'social_vk'             => [
							'type'    => 'url',
							'label'   => esc_html__( 'ВКонтакте', 'wescle' ),
							'default' => '#',
						],
						'social_vk_color'       => social_item_color(),
						'social_vk_color_hover' => social_item_color_hover(),

						'social_ok'             => [
							'type'    => 'url',
							'label'   => esc_html__( 'Одноклассники', 'wescle' ),
							'default' => '#',
						],
						'social_ok_color'       => social_item_color(),
						'social_ok_color_hover' => social_item_color_hover(),

						'social_yd'             => [
							'type'  => 'url',
							'label' => esc_html__( 'Яндекс.Дзен', 'wescle' ),
						],
						'social_yd_color'       => social_item_color(),
						'social_yd_color_hover' => social_item_color_hover(),

						'social_pulse_mail'             => [
							'type'  => 'url',
							'label' => esc_html__( 'Пульс Mail.ru', 'wescle' ),
						],
						'social_pulse_mail_color'       => social_item_color(),
						'social_pulse_mail_color_hover' => social_item_color_hover(),

						'social_tinkoff'             => [
							'type'  => 'url',
							'label' => esc_html__( 'Тинькофф-журнал', 'wescle' ),
						],
						'social_tinkoff_color'       => social_item_color(),
						'social_tinkoff_color_hover' => social_item_color_hover(),

						'social_custom_info'  => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Другие социальные сети', 'wescle' ) . '</h3>',
						],
						'social_custom_items' => [
							'type'         => 'repeater',
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Социальная сеть', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'url'              => [
									'type'  => 'text',
									'label' => esc_html__( 'URL', 'wescle' ),
								],
								'image'            => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'default' => '',
								],
								'text'             => [
									'type'              => 'textarea',
									'label'             => esc_html__( 'ИЛИ', 'wescle' ) . ' ' . esc_html__( 'SVG code', 'wescle' ),
									'default'           => '',
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'item_color'       => social_item_color( __( 'Цвет иконки SVG', 'wescle' ) ),
								'item_color_hover' => social_item_color_hover( __( 'Цвет иконки SVG', 'wescle' ) ),
							],
						],
					]
				],
				'section_footer_block_sortable' => [
					'title'    => esc_html__( 'Порядок блоков', 'wescle' ),
					'controls' => [
						'footer_block_sortable'          => [
							'type'    => 'sortable',
							'label'   => esc_html__( 'Порядок блоков', 'wescle' ),
							'default' => [
								'copyright',
								'text',
								'payments',
								'socials',
							],
							'choices' => [
								'copyright' => esc_html__( 'Копирайт', 'wescle' ),
								'text'      => esc_html__( 'Текст', 'wescle' ),
								'payments'  => esc_html__( 'Изображения', 'wescle' ),
								'socials'   => esc_html__( 'Социальные ссылки', 'wescle' ),
							],
						],
						'footer_block_classes_title'     => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Дополнительные CSS классы', 'wescle' ) . '</h3>',
						],
						'footer_block_classes_copyright' => [
							'type'    => 'select',
							'label'   => esc_html__( 'CSS класс для блока', 'wescle' ) . ' ' . esc_html__( 'Копирайт', 'wescle' ),
							'choices' => choices_addit_classes()
						],
						'footer_block_classes_text'      => [
							'type'    => 'select',
							'label'   => esc_html__( 'CSS класс для блока', 'wescle' ) . ' ' . esc_html__( 'Текст', 'wescle' ),
							'choices' => choices_addit_classes()
						],
						'footer_block_classes_payments'  => [
							'type'    => 'select',
							'label'   => esc_html__( 'CSS класс для блока', 'wescle' ) . ' ' . esc_html__( 'Изображения', 'wescle' ),
							'choices' => choices_addit_classes( false )
						],
						'footer_block_classes_socials'   => [
							'type'    => 'select',
							'label'   => esc_html__( 'CSS класс для блока', 'wescle' ) . ' ' . esc_html__( 'Социальные ссылки', 'wescle' ),
							'choices' => choices_addit_classes( false )
						],
					]
				],
			]
		],

		'homepage_layout' => [
			'title'    => __( 'Конструктор главной страницы', 'wescle' ),
			'priority' => 55,

			'sections' => [
				'home_tab_1'               => [
					'title'    => __( 'Первое впечатление', 'wescle' ),
					'controls' => [
						'home_tab_1_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_before_slider'       => [
					'title'    => __( 'Текст перед "Первым экраном"', 'wescle' ),
					'controls' => [
						'home_text_before_slider_enabled'        => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'home_text_before_slider'                => [
							'type'     => 'editor',
							'label'    => esc_html__( 'Текст', 'wescle' ),
							'selector' => '.text_before_promo .container'
						],
						'home_before_slider_color_bg_info'       => home_block_color_bg_info(),
						'home_before_slider_color_bg'            => home_block_color_bg(),
						'home_before_slider_image_bg'            => home_block_image_bg(),
						'home_before_slider_image_bg_fit'        => home_block_image_bg_fit(),
						'home_before_slider_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_before_slider_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_before_slider_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_before_slider_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'slider_carousel'          => [
					'title'    => __( 'Шаблон "Первого экрана"', 'wescle' ),
					'controls' => [
						'slider_layout'                 => [
							'type'        => 'radio-image',
							'label'       => esc_html__( 'Выбрать шаблон', 'wescle' ),
							'description' => esc_html__( 'После выбора шаблона, необходимо вернуться назад и перейти в Настройка "Первого экрана". Каждый раз при смене шаблона активируются новые настройки.', 'wescle' ),
							'default'     => 'columns_two',
							'choices'     => get_title_slider_layout(),
						],
						'slider_autoplay_speed'         => [
							'type'            => 'slider',
							'label'           => esc_html__( 'Скорость смены слайдов, сек', 'wescle' ),
							'default'         => 8,
							'choices'         => [
								'min'  => 1,
								'max'  => 20,
								'step' => 1,
							],
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'none',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'columns_one_two',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'columns_one_four',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'animated',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'parallax',
								],
							]
						],
						'slider_dots'                   => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать точки переключения слайдов?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'none',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'columns_one_two',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'columns_one_four',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'animated',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'parallax',
								],
							]
						],
						'slider_arrows'                 => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать стрелки переключения слайдов?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'none',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'columns_one_two',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'columns_one_four',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'animated',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'parallax',
								],
							]
						],
						'slider_image_without_gradient' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Отключить затемнение на слайдах?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'none',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'banner',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'animated',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'parallax',
								],
							]
						],
						'slider_image_opacity'          => [
							'type'            => 'slider',
							'label'           => esc_html__( 'Прозрачность затемнение', 'wescle' ),
							'default'         => 100,
							'choices'         => [
								'min'  => 10,
								'max'  => 100,
								'step' => 10,
							],
							'active_callback' => [
								[
									'setting'  => 'slider_image_without_gradient',
									'operator' => '==',
									'value'    => false,
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'none',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'animated',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'parallax',
								],
							]
						],
						'home_slider_carousel_color_bg' => [
							'type'            => 'color',
							'label'           => esc_html__( 'Фон блока', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'none',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'animated',
								],
								[
									'setting'  => 'slider_layout',
									'operator' => '!=',
									'value'    => 'parallax',
								],
							]
						],
					]
				],
				'slider_carousel_settings' => [
					'title'    => __( 'Настройка "Первого экрана"', 'wescle' ),
					'controls' => [
						'slider_columns_two_title' => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( 'Настройки', 'wescle' ) . '</h3>',
							'priority'        => 10,
							'active_callback' => active_field_for_slider(),
							'selector'        => '.promo > .container, .goods-main .container'
						],

						'slider_columns_fullwidth'  => [
							'type'            => 'switch',
							'label'           => esc_html__( 'На всю ширину страницы?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'columns_one',
								],
							]
						],
						'slider_columns_fullheight' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'На всю высоту страницы?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'columns_one',
								],
								[
									'setting'  => 'slider_columns_fullwidth',
									'operator' => '==',
									'value'    => true,
								],
							]
						],
						'slider_columns_aside_top'  => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Поднять сайдбар на слайдер?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'columns_one',
								],
								[
									'setting'  => 'slider_columns_fullwidth',
									'operator' => '==',
									'value'    => true,
								],
							],
						],

						'slider_columns_two_category' => [
							'type'            => 'select',
							'label'           => esc_html__( 'Категория статей', 'wescle' ),
							'default'         => [],
							'multiple'        => 999,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'choices'         => Helper::get_terms( array( 'taxonomy' => 'category' ) ),
							'active_callback' => active_field_for_slider()
						],
						'slider_columns_two_limit'    => [
							'type'            => 'number',
							'label'           => esc_html__( 'Количество статей', 'wescle' ),
							'default'         => 8,
							'choices'         => choices_number(),
							'active_callback' => active_field_for_slider()
						],
						'slider_columns_two_posts'    => [
							'type'            => 'select',
							'label'           => esc_html__( 'или Статьи', 'wescle' ),
							'default'         => 0,
							'multiple'        => 999,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'choices'         => Helper::get_posts( array(
								'post_type' => 'post',
							) ),
							'active_callback' => active_field_for_slider()
						],
						'slider_columns_two_meta'     => sortable_card_blocks( 'columns_two', 90 ),

						'slider_block_title1' => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( '1 колонка (1 пост)', 'wescle' ) . '</h3>',
							'priority'        => 100,
							'active_callback' => active_field_for_slider_block()
						],

						'slider_left_block_category'       => [
							'type'            => 'select',
							'label'           => esc_html__( 'Категория статей', 'wescle' ),
							'default'         => [],
							'priority'        => 101,
							'multiple'        => 4,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'choices'         => Helper::get_terms( array( 'taxonomy' => 'category' ) ),
							'active_callback' => active_field_for_slider_block()
						],
						'slider_left_block_category_posts' => [
							'type'            => 'select',
							'label'           => esc_html__( 'или Статьи', 'wescle' ),
							'default'         => [],
							'priority'        => 102,
							'multiple'        => 4,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'choices'         => Helper::get_posts( array(
								'post_type' => 'post',
							) ),
							'active_callback' => active_field_for_slider_block()
						],
						'slider_left_block_meta'           => sortable_card_blocks( 'left_block', 103 ),

						'slider_block_title2_1' => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( '2 колонка (2 поста)', 'wescle' ) . '</h3>',
							'active_callback' => active_field_for_slider_block( 0 ),
							'priority'        => 205,
						],

						'slider_block_title2_2'             => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( '2 колонка (4 поста)', 'wescle' ) . '</h3>',
							'active_callback' => active_field_for_slider_block( 1 ),
							'priority'        => 205,
						],
						'slider_right_block_offset'         => [
							'type'            => 'number',
							'label'           => esc_html__( 'Отступ от первого поста', 'wescle' ),
							'default'         => 0,
							'active_callback' => active_field_for_slider_block(),
							'priority'        => 206,
						],
						'slider_right_block_category'       => [
							'type'            => 'select',
							'label'           => esc_html__( 'Категория статей', 'wescle' ),
							'default'         => [],
							'multiple'        => 4,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'choices'         => Helper::get_terms( array( 'taxonomy' => 'category' ) ),
							'active_callback' => active_field_for_slider_block(),
							'priority'        => 206,
						],
						'slider_right_block_category_posts' => [
							'type'            => 'select',
							'label'           => esc_html__( 'или Статьи', 'wescle' ),
							'default'         => [],
							'priority'        => 207,
							'multiple'        => 4,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'choices'         => Helper::get_posts( array(
								'post_type' => 'post',
							) ),
							'active_callback' => active_field_for_slider_block()
						],
						'slider_right_block_meta'           => sortable_card_blocks( 'right_block', 208 ),
						'slider_banner_fullwidth'           => [
							'type'            => 'switch',
							'label'           => esc_html__( 'На всю ширину страницы?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => active_field_for_banner(),
						],
						'slider_banner_fullheight'          => [
							'type'            => 'switch',
							'label'           => esc_html__( 'На всю высоту страницы?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => array_merge( active_field_for_banner(), [
								[
									'setting'  => 'slider_banner_fullwidth',
									'operator' => '==',
									'value'    => true,
								],
							] )
						],
						'slider_banner_aside_top'           => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Поднять сайдбар на слайдер?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => array_merge( active_field_for_banner(), [
								[
									'setting'  => 'slider_banner_fullwidth',
									'operator' => '==',
									'value'    => true,
								],
							] )
						],
						'slider_banner_title_is_h1'         => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Включить H1 у заголовка первого баннера?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'slider_layout',
										'operator' => '==',
										'value'    => 'banner',
									],
									[
										'setting'  => 'slider_layout',
										'operator' => '==',
										'value'    => 'store',
									],
								]
							]
						],
						'slider_banner_slider_effect'       => [
							'type'            => 'radio',
							'label'           => esc_html__( 'Эффект смены слайда', 'wescle' ),
							'default'         => 'slide',
							'choices'         => [
								'slide' => 'Slide',
								'fade'  => 'Fade',
							],
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'banner',
								]
							]
						],

						'slider_banner'                      => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Баннеры', 'wescle' ),
							'row_label'       => [
								'type'  => 'text',
								'value' => esc_html__( 'Баннер', 'wescle' ),
							],
							'button_label'    => esc_html__( 'Добавить баннер', 'wescle' ),
							'default'         => [],
							'fields'          => [
								'image'          => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'default' => '',
								],
								'overlay_off'    => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Отключить оверлай?', 'wescle' ),
									'default' => '',
								],
								'video'          => [
									'type'  => 'upload',
									'label' => esc_html__( 'Файл *.mp4', 'wescle' ),
								],
								'video_autoplay' => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Автовоспроизведение', 'wescle' ),
									'default' => false,
								],
								'video_loop'     => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Зациклить видео', 'wescle' ),
									'default' => false,
								],
								'video_control'  => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Кнопки управления видео', 'wescle' ),
									'default' => false,
								],
								'video_yt'       => [
									'type'    => 'text',
									'label'   => esc_html__( 'или ссылка на Youtube', 'wescle' ),
									'default' => '',
								],
								'title'          => [
									'type'              => 'textarea',
									'label'             => esc_html__( 'Заголовок', 'wescle' ),
									'default'           => '',
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'text'           => [
									'type'              => 'textarea',
									'label'             => esc_html__( 'Текст', 'wescle' ),
									'default'           => '',
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'text_width'     => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Ширина текста', 'wescle' ),
									'default' => '100',
									'choices' => [
										'50'  => '50%',
										'75'  => '75%',
										'100' => '100%',
									]
								],
								'text_h_align'   => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Горизонтальное выравнивание текста', 'wescle' ),
									'default' => 'left',
									'choices' => [
										'left'   => __( 'по левому краю', 'wescle' ),
										'center' => __( 'по центру', 'wescle' ),
										'end'    => __( 'по правому краю', 'wescle' ),
									]
								],
								'text_v_align'   => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Вертикальное выравнивание текста', 'wescle' ),
									'default' => 'bottom',
									'choices' => [
										'bottom' => __( 'снизу', 'wescle' ),
										'center' => __( 'по центру', 'wescle' ),
										'top'    => __( 'сверху', 'wescle' ),
									]
								],
								'text_color'     => [
									'type'    => 'color',
									'label'   => esc_html__( 'Цвет текста', 'wescle' ),
									'default' => '#ffffff',
									'choices' => [
										'alpha' => true,
									],
								],
								'button_link'    => [
									'type'        => 'text',
									'label'       => esc_html__( 'Ссылка', 'wescle' ),
									'default'     => '',
									'description' => __( '* чтобы кнопку сделать вызовом попапа звонка, пропишите <code>#modal-call</code>', 'wescle' ),
								],
								'button_text'    => [
									'type'    => 'text',
									'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
									'default' => '',
								],
								'button_link2'   => [
									'type'    => 'text',
									'label'   => esc_html__( 'Ссылка', 'wescle' ) . ' 2',
									'default' => '',
								],
								'button_text2'   => [
									'type'    => 'text',
									'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ) . ' 2',
									'default' => '',
								],
							],
							'active_callback' => active_field_for_banner(),
						],
						'slider_banner_height_label'         => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( 'Высота баннера', 'wescle' ) . ', px</h3>',
							'active_callback' => active_field_for_banner(),
						],
						'slider_banner_height_desktop'       => [
							'type'            => 'number',
							'label'           => esc_html__( 'на ПК (1280-1920)', 'wescle' ),
							'active_callback' => active_field_for_banner(),
						],
						'slider_banner_height_tablet'        => [
							'type'            => 'number',
							'label'           => esc_html__( 'на планшете (768-1280)', 'wescle' ),
							'active_callback' => active_field_for_banner(),
						],
						'slider_banner_height_mobile'        => [
							'type'            => 'number',
							'label'           => esc_html__( 'на телефоне (320-768)', 'wescle' ),
							'active_callback' => active_field_for_banner(),
						],
						'slider_banner_catalog_form'         => [
							'type'            => get_theme_mod( 'module_catalog_enabled' ) ? 'switch' : '',
							'label'           => esc_html__( 'Показывать форму поиска по каталогу?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => active_field_for_banner(),
						],
						'slider_banner_catalog_form_filters' => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Фильтры', 'wescle' ),
							'row_label'       => [
								'type'  => 'text',
								'value' => esc_html__( 'Фильтр', 'wescle' ),
							],
							'button_label'    => esc_html__( 'Добавить фильтр', 'wescle' ),
							'default'         => [],
							'fields'          => [
								'filter_taxonomy' => [
									'type'    => 'select',
									'choices' => Helper::get_catalog_filter_choices( $label_select )
								],
							],
							'choices'         => [
								'limit' => 2
							],
							'active_callback' => [
								[
									'setting'  => 'slider_banner_catalog_form',
									'operator' => '==',
									'value'    => true,
								]
							]
						],

						'slider_store_title1'       => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( '1 колонка (меню)', 'wescle' ) . '</h3>',
							'active_callback' => active_field_for_store()
						],
						'slider_store_menu_enabled' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Меню с категориями', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => active_field_for_store(),
						],

						'slider_store_title2'           => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( '2 колонка (горизонтальный слайдер)', 'wescle' ) . '</h3>',
							'active_callback' => active_field_for_store()
						],
						'slider_store_one_fullwidth'    => [
							'type'            => 'switch',
							'label'           => esc_html__( 'На всю ширину страницы?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => array_merge( active_field_for_store(), [
								[
									'setting'  => 'slider_store_menu_enabled',
									'operator' => '==',
									'value'    => false,
								],
								[
									'setting'  => 'slider_store_two_enabled',
									'operator' => '==',
									'value'    => false,
								],
							] )
						],
						'slider_store_one_fullheight'   => [
							'type'            => 'switch',
							'label'           => esc_html__( 'На всю высоту страницы?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => array_merge( active_field_for_store(), [
								[
									'setting'  => 'slider_store_menu_enabled',
									'operator' => '==',
									'value'    => false,
								],
								[
									'setting'  => 'slider_store_two_enabled',
									'operator' => '==',
									'value'    => false,
								],
								[
									'setting'  => 'slider_store_one_fullwidth',
									'operator' => '==',
									'value'    => true,
								],
							] )
						],
						'slider_store_one_type'         => [
							'type'            => 'radio',
							'label'           => esc_html__( 'Тип слайдов', 'wescle' ),
							'default'         => 'custom',
							'choices'         => [
								'product' => __( 'Товары', 'wescle' ),
								'custom'  => __( 'Custom', 'wescle' ),
							],
							'active_callback' => active_field_for_store(),
						],
						'slider_store_one_slides'       => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Слайды', 'wescle' ),
							'row_label'       => [
								'type'  => 'text',
								'value' => esc_html__( 'Слайд', 'wescle' ),
							],
							'button_label'    => esc_html__( 'Добавить слайд', 'wescle' ),
							'default'         => [],
							'fields'          => [
								'image'            => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => array(
										'save_as' => 'id'
									),
								],
								'video'            => [
									'type'  => 'upload',
									'label' => esc_html__( 'Файл *.mp4', 'wescle' ),
								],
								'video_autoplay'   => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Автовоспроизведение', 'wescle' ),
									'default' => false,
								],
								'video_loop'       => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Зациклить видео', 'wescle' ),
									'default' => false,
								],
								'video_control'    => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Кнопки управления видео', 'wescle' ),
									'default' => false,
								],
								'video_yt'         => [
									'type'    => 'text',
									'label'   => esc_html__( 'или ссылка на Youtube', 'wescle' ),
									'default' => '',
								],
								'title'            => [
									'type'              => 'text',
									'label'             => esc_html__( 'Заголовок', 'wescle' ),
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'text'             => [
									'type'              => 'textarea',
									'label'             => esc_html__( 'Текст', 'wescle' ),
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'woo_text_h_align' => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Горизонтальное выравнивание текста', 'wescle' ),
									'default' => 'left',
									'choices' => [
										'left'   => __( 'по левому краю', 'wescle' ),
										'center' => __( 'по центру', 'wescle' ),
										'end'    => __( 'по правому краю', 'wescle' ),
									]
								],
								'woo_text_v_align' => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Вертикальное выравнивание текста', 'wescle' ),
									'default' => 'bottom',
									'choices' => [
										'bottom' => __( 'снизу', 'wescle' ),
										'center' => __( 'по центру', 'wescle' ),
										'top'    => __( 'сверху', 'wescle' ),
									]
								],
								'price'            => [
									'type'  => 'text',
									'label' => esc_html__( 'Цена', 'wescle' ),
								],
								'price_old'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Старая цена', 'wescle' ),
								],
								'button_label'     => [
									'type'  => 'text',
									'label' => esc_html__( 'Надпись на кнопке', 'wescle' ),
								],
								'button_url'       => [
									'type'        => 'text',
									'label'       => esc_html__( 'Ссылка', 'wescle' ),
									'description' => __( '* чтобы кнопку сделать вызовом попапа звонка, пропишите <code>#modal-call</code>', 'wescle' ),
								],
								'button_label_new' => [
									'type'  => 'text',
									'label' => esc_html__( 'Надпись на кнопке', 'wescle' ) . ' 2',
								],
								'button_url_new'   => [
									'type'  => 'text',
									'label' => esc_html__( 'Ссылка', 'wescle' ) . ' 2',
								],
							],
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'store',
								],
								[
									'setting'  => 'slider_store_one_type',
									'operator' => '==',
									'value'    => 'custom',
								],
							],
						],
						'slider_store_one_category'     => [
							'type'            => 'select',
							'label'           => esc_html__( 'Категория товаров', 'wescle' ),
							'default'         => [],
							'multiple'        => 999,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'choices'         => Helper::get_terms( array( 'taxonomy' => 'product_cat' ) ),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'store',
								],
								[
									'setting'  => 'slider_store_one_type',
									'operator' => '!=',
									'value'    => 'custom',
								],
							],
						],
						'slider_store_one_limit'        => [
							'type'            => 'number',
							'label'           => esc_html__( 'Количество товаров', 'wescle' ),
							'default'         => 6,
							'choices'         => choices_number( 12 ),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'store',
								],
								[
									'setting'  => 'slider_store_one_type',
									'operator' => '!=',
									'value'    => 'custom',
								],
							],
						],
						'slider_store_one_products'     => [
							'type'            => 'select',
							'label'           => esc_html__( 'или выберите отдельные товары', 'wescle' ),
							'default'         => [],
							'multiple'        => 999,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'input_attrs'     => [
								'data-ajax'      => 'true',
								'data-post_type' => 'product',
							],
							'choices'         => Helper::get_posts( array(
								'post_type' => 'product',
							), false, 'slider_store_one_products' ),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'store',
								],
								[
									'setting'  => 'slider_store_one_type',
									'operator' => '!=',
									'value'    => 'custom',
								],
							],
						],
						'slider_store_one_button_label' => [
							'type'            => 'text',
							'label'           => esc_html__( 'Надпись на кнопке', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'slider_store_one_button_label' ),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'store',
								],
								[
									'setting'  => 'slider_store_one_type',
									'operator' => '!=',
									'value'    => 'custom',
								],
							],
						],
						'slider_store_one_color_title'  => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет заголовка', 'wescle' ),
							'default'         => '#ffffff',
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_store(),
						],
						'slider_store_one_color_price'  => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста с ценой', 'wescle' ),
							'default'         => '#ffffff',
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_store(),
						],

						'slider_store_title3'          => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( '3 колонка (вертикальный слайдер)', 'wescle' ) . '</h3>',
							'active_callback' => active_field_for_store()
						],
						'slider_store_two_enabled'     => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Включить блок', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => active_field_for_store(),
						],
						'slider_store_two_type'        => [
							'type'            => 'radio',
							'label'           => esc_html__( 'Тип слайдов', 'wescle' ),
							'default'         => 'custom',
							'choices'         => [
								'product' => __( 'Товары', 'wescle' ),
								'custom'  => __( 'Custom', 'wescle' ),
							],
							'active_callback' => active_field_for_store(),
						],
						'slider_store_two_slides'      => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Слайды', 'wescle' ),
							'row_label'       => [
								'type'  => 'text',
								'value' => esc_html__( 'Слайд', 'wescle' ),
							],
							'button_label'    => esc_html__( 'Добавить слайд', 'wescle' ),
							'default'         => [],
							'fields'          => [
								'image'             => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => array(
										'save_as' => 'id'
									),
								],
								'title'             => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'woo2_text_h_align' => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Горизонтальное выравнивание текста', 'wescle' ),
									'default' => 'left',
									'choices' => [
										'left'   => __( 'по левому краю', 'wescle' ),
										'center' => __( 'по центру', 'wescle' ),
										'end'    => __( 'по правому краю', 'wescle' ),
									]
								],
								'woo2_text_v_align' => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Вертикальное выравнивание текста', 'wescle' ),
									'default' => 'bottom',
									'choices' => [
										'bottom' => __( 'снизу', 'wescle' ),
										'center' => __( 'по центру', 'wescle' ),
										'top'    => __( 'сверху', 'wescle' ),
									]
								],
								'price'             => [
									'type'  => 'text',
									'label' => esc_html__( 'Цена', 'wescle' ),
								],
								'price_old'         => [
									'type'  => 'text',
									'label' => esc_html__( 'Старая цена', 'wescle' ),
								],
								'button_url'        => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка', 'wescle' ),
								],
							],
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'store',
								],
								[
									'setting'  => 'slider_store_two_type',
									'operator' => '==',
									'value'    => 'custom',
								],
							],
						],
						'slider_store_two_category'    => [
							'type'            => 'select',
							'label'           => esc_html__( 'Категория товаров', 'wescle' ),
							'default'         => [],
							'multiple'        => 999,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'choices'         => Helper::get_terms( array( 'taxonomy' => 'product_cat' ) ),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'store',
								],
								[
									'setting'  => 'slider_store_two_type',
									'operator' => '!=',
									'value'    => 'custom',
								],
							],
						],
						'slider_store_two_limit'       => [
							'type'            => 'number',
							'label'           => esc_html__( 'Количество товаров', 'wescle' ),
							'default'         => 6,
							'choices'         => choices_number( 12 ),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'store',
								],
								[
									'setting'  => 'slider_store_two_type',
									'operator' => '!=',
									'value'    => 'custom',
								],
							],
						],
						'slider_store_two_products'    => [
							'type'            => 'select',
							'label'           => esc_html__( 'или выберите отдельные товары', 'wescle' ),
							'default'         => [],
							'multiple'        => 999,
							'isClearable'     => true,
							'placeholder'     => $label_select,
							'input_attrs'     => [
								'data-ajax'      => 'true',
								'data-post_type' => 'product',
							],
							'choices'         => Helper::get_posts( array(
								'post_type' => 'product',
							), false, 'slider_store_two_products' ),
							'active_callback' => [
								[
									'setting'  => 'slider_layout',
									'operator' => '==',
									'value'    => 'store',
								],
								[
									'setting'  => 'slider_store_two_type',
									'operator' => '!=',
									'value'    => 'custom',
								],
							],
						],
						'slider_store_two_color_title' => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет заголовка', 'wescle' ),
							'default'         => '#ffffff',
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_store(),
						],
						'slider_store_two_color_price' => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста с ценой', 'wescle' ),
							'default'         => '#ffffff',
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_store(),
						],

						'animated_label_text'           => [
							'type'            => 'text',
							'label'           => esc_html__( 'Текст перед заголовком', 'wescle' ),
							'active_callback' => active_field_for_animated(),
						],
						'animated_label_href'           => [
							'type'            => 'text',
							'label'           => esc_html__( 'URL текста перед заголовком', 'wescle' ),
							'active_callback' => active_field_for_animated(),
						],
						'animated_label_text_color'     => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста перед заголовком', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_label_bg_color'       => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона перед заголовком', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_title_1'              => [
							'type'            => 'text',
							'label'           => esc_html__( 'Текст первой строки', 'wescle' ),
							'active_callback' => active_field_for_animated(),
							'selector'        => '.animated-banner .container'
						],
						'animated_title_type'           => array_merge( header_title_type_block(), [ 'active_callback' => active_field_for_animated() ] ),
						'animated_title_text_items'     => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Анимационные строки', 'wescle' ),
							'row_label'       => [
								'type'  => 'text',
								'value' => esc_html__( 'Строка', 'wescle' ),
							],
							'button_label'    => esc_html__( 'Добавить строку', 'wescle' ),
							'default'         => [],
							'fields'          => [
								'item_text'  => [
									'type' => 'text',
									//'label' => esc_html__( 'Строка', 'wescle' ),
								],
								'item_color' => [
									'type'    => 'color',
									'choices' => [
										'alpha' => true,
									],
								],
							],
							'choices'         => [
								'limit' => 3
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_title_2'              => [
							'type'            => 'editor',
							'label'           => esc_html__( 'Текст второй строки', 'wescle' ),
							'active_callback' => active_field_for_animated(),
						],
						'animated_title_2_color'        => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет выделенного текста второй строки', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_title_3'              => [
							'type'            => 'editor',
							'label'           => esc_html__( 'Текст третьей строки', 'wescle' ),
							'active_callback' => active_field_for_animated(),
						],
						'animated_buttons'              => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Кнопки', 'wescle' ),
							'row_label'       => [
								'type'  => 'text',
								'value' => esc_html__( 'Кнопка', 'wescle' ),
							],
							'button_label'    => esc_html__( 'Добавить кнопку', 'wescle' ),
							'default'         => [],
							'fields'          => [
								'button_text' => [
									'type'  => 'text',
									'label' => esc_html__( 'Надпись на кнопке', 'wescle' ),
								],
								'button_url'  => [
									'type'  => 'text',
									'label' => esc_html__( 'URL', 'wescle' ),
								],
								'is_blank'    => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Открывать ссылку в новом окне?', 'wescle' ),
								]
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_advantages'           => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Преимущества', 'wescle' ),
							'row_label'       => [
								'type'  => 'text',
								'value' => esc_html__( 'Преимущество', 'wescle' ),
							],
							'button_label'    => esc_html__( 'Добавить', 'wescle' ),
							'default'         => [],
							'fields'          => [
								'item_text' => [
									'type'  => 'text',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_advantages_img_color' => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет иконки преимуществ', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_bg_image_1'           => [
							'type'            => 'image',
							'label'           => esc_html__( 'Изображение', 'wescle' ),
							'choices'         => [
								'save_as' => 'id',
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_play_bg_color'        => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона иконки play', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_play_color'           => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет иконки play', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_play_border_color'    => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет границы круга иконки play', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_play_color_text'      => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста иконки play', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_play_label'           => [
							'type'            => 'text',
							'label'           => esc_html__( 'Надпись на play кнопке', 'wescle' ),
							'active_callback' => active_field_for_animated(),
						],
						'animated_video_href'           => [
							'type'            => 'text',
							'label'           => esc_html__( 'Ссылка на видео с Youtube', 'wescle' ),
							'active_callback' => active_field_for_animated(),
						],
						'animated_position_info'        => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( 'Позиционирование', 'wescle' ) . '</h3>',
							'active_callback' => active_field_for_animated(),
						],
						'animated_position_content'     => [
							'type'            => 'select',
							'default'         => 'default',
							'choices'         => [
								'default' => __( 'По умолчанию', 'wescle' ),
								'left'    => is_rtl() ? __( 'Справа', 'wescle' ) : __( 'Слева', 'wescle' ),
								'center'  => __( 'Центр', 'wescle' ),
								'right'   => is_rtl() ? __( 'Слева', 'wescle' ) : __( 'Справа', 'wescle' ),
							],
							'active_callback' => active_field_for_animated(),
						],
						'animated_color_bg_info'        => array_merge( home_block_color_bg_info(), [ 'active_callback' => active_field_for_animated() ] ),
						'animated_color_bg'             => array_merge( home_block_color_bg(), [ 'active_callback' => active_field_for_animated() ] ),
						'animated_image_bg'             => array_merge( home_block_image_bg(), [ 'active_callback' => active_field_for_animated() ] ),
						'animated_image_bg_fit'         => array_merge( home_block_image_bg_fit(), [ 'active_callback' => active_field_for_animated() ] ),
						'animated_image_bg_tablet'      => array_merge( home_block_image_bg( 'tablet' ), [ 'active_callback' => active_field_for_animated() ] ),
						'animated_image_bg_fit_tablet'  => array_merge( home_block_image_bg_fit( 'tablet' ), [ 'active_callback' => active_field_for_animated() ] ),
						'animated_image_bg_mobile'      => array_merge( home_block_image_bg( 'mobile' ), [ 'active_callback' => active_field_for_animated() ] ),
						'animated_image_bg_fit_mobile'  => array_merge( home_block_image_bg_fit( 'mobile' ), [ 'active_callback' => active_field_for_animated() ] ),

						'parallax_label_text'          => [
							'type'            => 'text',
							'label'           => esc_html__( 'Текст перед заголовком', 'wescle' ),
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_label_text_color'    => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста перед заголовком', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_label_bg_color'      => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона перед заголовком', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_title_1'             => [
							'type'            => 'text',
							'label'           => esc_html__( 'Заголовок', 'wescle' ),
							'active_callback' => active_field_for_parallax(),
							'selector'        => '.promo-parallax .container'
						],
						'parallax_title_type'          => array_merge( header_title_type_block(), [ 'active_callback' => active_field_for_parallax() ] ),
						'parallax_text_items'          => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Строки с картинками', 'wescle' ),
							'row_label'       => [
								'type'  => 'text',
								'value' => esc_html__( 'Строка', 'wescle' ),
							],
							'button_label'    => esc_html__( 'Добавить строку', 'wescle' ),
							'default'         => [],
							'fields'          => [
								'image' => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение', 'wescle' )
								],
								'text'  => [
									'type' => 'text',
								],
							],
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_button_label'        => [
							'type'            => 'text',
							'label'           => esc_html__( 'Надпись на кнопке', 'wescle' ),
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_button_url'          => [
							'type'            => 'url',
							'label'           => esc_html__( 'URL для кнопки', 'wescle' ),
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_text_button'         => [
							'type'            => 'text',
							'label'           => esc_html__( 'Анимационный текст на кнопке', 'wescle' ),
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_text_button_bg'      => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона анимационного текста', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_text_after_button'   => [
							'type'              => 'editor',
							'label'             => esc_html__( 'Текст под кнопкой', 'wescle' ),
							'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' ),
							'active_callback'   => active_field_for_parallax()
						],
						'parallax_bg_image_1'          => [
							'type'            => 'image',
							'label'           => esc_html__( 'Изображение', 'wescle' ),
							'choices'         => [
								'save_as' => 'id',
							],
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_bg_image_2'          => [
							'type'            => 'image',
							'label'           => esc_html__( 'Параллакс-изображение', 'wescle' ),
							'choices'         => [
								'save_as' => 'id',
							],
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_position_info'       => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( 'Позиционирование', 'wescle' ) . '</h3>',
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_position_content'    => [
							'type'            => 'select',
							'default'         => 'default',
							'choices'         => [
								'default' => __( 'По умолчанию', 'wescle' ),
								'left'    => is_rtl() ? __( 'Справа', 'wescle' ) : __( 'Слева', 'wescle' ),
								'center'  => __( 'Центр', 'wescle' ),
								'right'   => is_rtl() ? __( 'Слева', 'wescle' ) : __( 'Справа', 'wescle' ),
							],
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_color_bg_info'       => array_merge( home_block_color_bg_info(), [ 'active_callback' => active_field_for_parallax() ] ),
						'parallax_color_text'          => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста', 'wescle' ),
							'active_callback' => active_field_for_parallax(),
						],
						'parallax_color_bg'            => array_merge( home_block_color_bg(), [ 'active_callback' => active_field_for_parallax() ] ),
						'parallax_image_bg'            => array_merge( home_block_image_bg(), [ 'active_callback' => active_field_for_parallax() ] ),
						'parallax_image_bg_fit'        => array_merge( home_block_image_bg_fit(), [ 'active_callback' => active_field_for_parallax() ] ),
						'parallax_image_bg_tablet'     => array_merge( home_block_image_bg( 'tablet' ), [ 'active_callback' => active_field_for_parallax() ] ),
						'parallax_image_bg_fit_tablet' => array_merge( home_block_image_bg_fit( 'tablet' ), [ 'active_callback' => active_field_for_parallax() ] ),
						'parallax_image_bg_mobile'     => array_merge( home_block_image_bg( 'mobile' ), [ 'active_callback' => active_field_for_parallax() ] ),
						'parallax_image_bg_fit_mobile' => array_merge( home_block_image_bg_fit( 'mobile' ), [ 'active_callback' => active_field_for_parallax() ] ),
					]
				],

				'home_tab_02' => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_02' ),
					'controls' => [
						'home_tab_02_info' => [
							'type' => 'custom'
						]
					]
				],

				'woo_blocks' => [
					'title'    => Helper::is_woocommerce_active() ? Helper::get_default_theme_data( 'home_block_titles', 'woo_blocks' ) : '',
					'controls' => [
						'woo_blocks_preview' => home_block_preview_img( 'block-with-woo-products-categories' ),
						'woo_blocks_items'   => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блоки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить блок', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'woo_block_on'                     => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Включить блок', 'wescle' ),
									'default' => true,
								],
								'woo_block_before_promo'           => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Вынести за главный экран?', 'wescle' ),
									'default' => false,
								],
								'woo_block_advt_before'            => [
									'type'              => 'textarea',
									'label'             => esc_html__( 'Код перед блоком', 'wescle' ),
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'woo_block_id_block'               => [
									'type'  => 'text',
									'label' => esc_html__( 'ID блока', 'wescle' ),
								],
								'woo_block_title'                  => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'woo_block_title_type'             => header_title_type_block(),
								'woo_block_text'                   => [
									'type'              => 'textarea',
									'label'             => esc_html__( 'Описание', 'wescle' ),
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'woo_block_link_id'                => [
									'type'        => 'select',
									'label'       => esc_html__( 'Ссылка на все товары', 'wescle' ),
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type' => [ 'page' ]
									), true ),
								],
								'woo_block_link_url'               => [
									'type'  => 'text',
									'label' => esc_html__( 'или пропишите URL здесь', 'wescle' ),
								],
								'woo_block_link_text'              => [
									'type'  => 'text',
									'label' => esc_html__( 'Текст для ссылки', 'wescle' ),
								],
								'woo_block_type'                   => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Тип блока', 'wescle' ),
									'choices' => [
										'category' => esc_html__( 'Категории', 'wescle' ),
										'product'  => esc_html__( 'Товары', 'wescle' ),
									]
								],
								'woo_block_category_limit'         => [
									'type'    => 'number',
									'label'   => esc_html__( 'Количество категорий', 'wescle' ),
									'default' => 10,
									'choices' => choices_number(),
								],
								'woo_block_category_select'        => [
									'type'        => 'select',
									'label'       => esc_html__( 'или выберите категории', 'wescle' ),
									'default'     => [],
									'multiple'    => 999,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_terms( array( 'taxonomy' => 'product_cat' ) ),
								],
								'woo_block_product_type'           => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Тип товаров', 'wescle' ),
									'default' => 'custom',
									'choices' => [
										'sale'    => esc_html__( 'Акционные', 'wescle' ),
										'new'     => esc_html__( 'Новые', 'wescle' ),
										'popular' => esc_html__( 'Популярные', 'wescle' ),
										'views'   => esc_html__( 'Самые просматриваемые', 'wescle' ),
										'custom'  => esc_html__( 'Выбор вручную', 'wescle' ),
									]
								],
								'woo_block_product_stock_enabled'  => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Показывать наличие товара?', 'wescle' ),
									'default' => false,
									'choices' => choices_on_off(),
								],
								'woo_block_product_rating_enabled' => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Показывать рейтинг товара?', 'wescle' ),
									'default' => false,
									'choices' => choices_on_off(),
								],
								'woo_block_product_sku_enabled'    => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Показывать артикул товара?', 'wescle' ),
									'default' => false,
									'choices' => choices_on_off(),
								],
								'woo_block_category'               => [
									'type'        => 'select',
									'label'       => esc_html__( 'Категория товаров', 'wescle' ),
									'default'     => [],
									'multiple'    => 999,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_terms( array( 'taxonomy' => 'product_cat' ) ),
								],
								'woo_block_limit'                  => [
									'type'    => 'number',
									'label'   => esc_html__( 'Количество товаров', 'wescle' ),
									'default' => 10,
									'choices' => choices_number(),
								],
								'woo_block_products'               => [
									'type'        => 'text',
									'label'       => esc_html__( 'или укажите отдельные товары', 'wescle' ),
									'default'     => '',
									'description' => __( 'Пропишите ID товаров через запятую', 'wescle' )
								],
								'woo_block_category_shadow'        => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Вид категорий с тенью?', 'wescle' ),
									'default' => true,
								],
								'woo_block_category_count_at_img'  => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Вид категорий с обводкой на картинке и количество вверху?', 'wescle' ),
									'default' => false,
								],
								'woo_block_category_show_count'    => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Показывать количество категорий?', 'wescle' ),
									'default' => true,
								],
								'woo_block_slider_enabled'         => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Показывать слайдер?', 'wescle' ),
									'default' => true,
								],
								'woo_block_category_grid_count'    => [
									'type'    => 'select',
									'label'   => esc_html__( 'Категорий/Товаров в строке', 'wescle' ),
									'default' => '5',
									'choices' => [
										'3' => 3,
										'4' => 4,
										'5' => 5,
										'6' => 6,
										'7' => 7,
									],
								],
								'woo_block_count_slides'           => [
									'type'    => 'number',
									'label'   => esc_html__( 'Количество слайдов', 'wescle' ),
									'default' => 5,
								],
								'woo_block_slider_arrow'           => home_slider_settings_arrow( true, 'checkbox' ),
								'woo_block_slider_arrow_mobile'    => home_slider_settings_arrow_mobile( true, 'checkbox' ),
								'woo_block_slider_dots'            => home_slider_settings_dots( false, 'checkbox' ),
								'woo_block_slider_speed'           => home_slider_settings_speed( 'number' ),
								'woo_block_advt_after'             => [
									'type'              => 'textarea',
									'label'             => esc_html__( 'Код после блока', 'wescle' ),
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'woo_block_color_bg_info'          => home_block_color_bg_info(),
								'woo_block_position_content'       => [
									'type'    => 'select',
									'label'   => esc_html__( 'Позиционирование', 'wescle' ),
									'default' => 'default',
									'choices' => [
										'default' => __( 'По умолчанию', 'wescle' ),
										'left'    => is_rtl() ? __( 'Справа', 'wescle' ) : __( 'Слева', 'wescle' ),
										'center'  => __( 'Центр', 'wescle' ),
										'right'   => is_rtl() ? __( 'Слева', 'wescle' ) : __( 'Справа', 'wescle' ),
									],
								],
								'woo_block_color_bg'               => home_block_color_bg(),
								'woo_block_color_title'            => home_block_color_title(),
								'woo_block_image_bg'               => home_block_image_bg(),
								'woo_block_image_bg_fit'           => home_block_image_bg_fit(),
								'woo_block_image_bg_tablet'        => home_block_image_bg( 'tablet' ),
								'woo_block_image_bg_fit_tablet'    => home_block_image_bg_fit( 'tablet' ),
								'woo_block_image_bg_mobile'        => home_block_image_bg( 'mobile' ),
								'woo_block_image_bg_fit_mobile'    => home_block_image_bg_fit( 'mobile' ),
							],
							'selector'     => '.home .goods-slider-section:not(._tabs) .container, .home .goods-categories-noslider .container'
						],
					]
				],

				'home_blocks' => [
					'title'    => Helper::get_default_theme_data( 'home_block_titles', 'home_blocks' ),
					'controls' => [
						'home_blocks_preview'       => home_block_preview_img( 'block-with-posts' ),
						'home_blocks_id_block'      => [
							'type'     => 'text',
							'label'    => esc_html__( 'ID блока', 'wescle' ),
							'selector' => '.home .content .container'
						],
						'home_blocks_posts'         => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блоки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить блок', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'block_on'                => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Включить блок', 'wescle' ),
									'default' => true,
								],
								'block_advt'              => [
									'type'              => 'textarea',
									'label'             => esc_html__( 'HTML код', 'wescle' ),
									'description'       => esc_html__( 'этот код будет показан перед статьями', 'wescle' ),
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'block_title'             => [
									'type'              => 'text',
									'label'             => esc_html__( 'Заголовок', 'wescle' ),
									'default'           => '',
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'block_title_type'        => header_title_type_block(),
								'block_text'              => [
									'type'              => 'textarea',
									'label'             => esc_html__( 'Текст', 'wescle' ),
									'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
								],
								'block_posts_link_text'   => [
									'type'    => 'text',
									'label'   => esc_html__( 'Анкор ссылки', 'wescle' ),
									'default' => '',
								],
								'block_posts_link_id'     => [
									'type'        => 'select',
									'label'       => esc_html__( 'Ссылка', 'wescle' ),
									'placeholder' => $label_select,
									'choices'     => Helper::get_terms( 'category', false, true ),
								],
								'block_posts_link_custom' => [
									'type'  => 'text',
									'label' => esc_html__( 'или пропишите кастомный URL', 'wescle' ),
								],
								'block_category'          => [
									'type'        => 'select',
									'label'       => esc_html__( 'Категория статей', 'wescle' ),
									'default'     => [],
									'multiple'    => 999,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_terms( array( 'taxonomy' => 'category' ) ),
								],
								'block_limit'             => [
									'type'        => 'number',
									'label'       => esc_html__( 'Количество статей', 'wescle' ),
									'description' => __( '0 - по умолчанию', 'wescle' ),
									'default'     => 0,
									'choices'     => choices_number(),
								],
								'block_posts'             => [
									'type'        => 'select',
									'label'       => esc_html__( 'или выберите отдельные записи', 'wescle' ),
									'default'     => [],
									'multiple'    => 999,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type' => 'post',
									) ),
								],
								'block_posts_orderby'     => [
									'type'    => 'select',
									'label'   => esc_html__( 'Сортировка постов', 'wescle' ),
									'default' => 'date',
									'choices' => choices_posts_orderby(),
								],
								'block_post_card_type'    => [
									'type'    => 'select',
									'label'   => esc_html__( 'Вид карточек постов', 'wescle' ),
									'default' => 'default',
									'choices' => choices_post_card_type(),
								],
								'block_post_card_columns' => [
									'type'    => 'select',
									'label'   => esc_html__( 'Сколько карточек в ряду?', 'wescle' ),
									'default' => '3',
									'choices' => [
										'2' => 2,
										'3' => 3
									]
								],
								'block_post_card_opacity' => [
									'type'    => 'select',
									'label'   => esc_html__( 'Прозрачность затемнение', 'wescle' ) . ', %',
									'default' => '100',
									'choices' => [
										'10'  => 10,
										'20'  => 20,
										'30'  => 30,
										'40'  => 40,
										'50'  => 50,
										'60'  => 60,
										'70'  => 70,
										'80'  => 80,
										'90'  => 90,
										'100' => 100
									]
								],
							]
						],
						'home_blocks_color_bg_info' => home_block_color_bg_info(),
						'home_blocks_color_bg'      => home_block_color_bg(),
						'home_blocks_color_title'   => home_block_color_title(),
					]
				],

				'product_tabs' => [
					'title'    => Helper::is_woocommerce_active() ? Helper::get_default_theme_data( 'home_block_titles', 'product_tabs' ) : '',
					'controls' => [
						'product_tabs_preview'             => home_block_preview_img( 'block-woo-tabs-products' ),
						'product_tabs_enabled'             => [
							'type'     => 'switch',
							'label'    => esc_html__( 'Включить блок', 'wescle' ),
							'default'  => false,
							'choices'  => choices_on_off(),
							'selector' => '.home #goods-tabs .container',
						],
						'product_tabs_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'product_tabs_title'               => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок', 'wescle' ),
						],
						'product_tabs_title_type'          => header_title_type_block(),
						'product_tabs_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'product_tabs_link_id'             => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка на все товары', 'wescle' ),
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							), true ),
						],
						'product_tabs_link_url'            => [
							'type'  => 'text',
							'label' => esc_html__( 'или пропишите URL здесь', 'wescle' ),
						],
						'product_tabs_link_text'           => [
							'type'  => 'text',
							'label' => esc_html__( 'Текст для ссылки', 'wescle' ),
						],
						'product_tabs_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Табы', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Таб', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить таб', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'tab_block_title'                  => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'tab_block_product_type'           => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Тип товаров', 'wescle' ),
									'default' => 'custom',
									'choices' => [
										'sale'    => esc_html__( 'Акционные', 'wescle' ),
										'new'     => esc_html__( 'Новые', 'wescle' ),
										'popular' => esc_html__( 'Популярные', 'wescle' ),
										'views'   => esc_html__( 'Самые просматриваемые', 'wescle' ),
										'custom'  => esc_html__( 'Выбор вручную', 'wescle' ),
									]
								],
								'tab_block_product_stock_enabled'  => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Показывать наличие товара?', 'wescle' ),
									'default' => false,
									'choices' => choices_on_off(),
								],
								'tab_block_product_rating_enabled' => [
									'type'    => 'checkbox',
									'label'   => esc_html__( 'Показывать рейтинг товара?', 'wescle' ),
									'default' => false,
									'choices' => choices_on_off(),
								],
								'tab_block_category'               => [
									'type'        => 'select',
									'label'       => esc_html__( 'Категория товаров', 'wescle' ),
									'default'     => [],
									'multiple'    => 999,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_terms( array( 'taxonomy' => 'product_cat' ) ),
								],
								'tab_block_limit'                  => [
									'type'    => 'number',
									'label'   => esc_html__( 'Количество товаров', 'wescle' ),
									'default' => 10,
									'choices' => choices_number(),
								],
								'tab_block_products'               => [
									'type'        => 'text',
									'label'       => esc_html__( 'или укажите отдельные товары', 'wescle' ),
									'default'     => '',
									'description' => __( 'Пропишите ID товаров через запятую', 'wescle' )
								],
								'tab_block_grid_count'             => [
									'type'    => 'select',
									'label'   => esc_html__( 'Товаров в строке', 'wescle' ),
									'default' => '5',
									'choices' => [
										'3' => 3,
										'4' => 4,
										'5' => 5,
										'6' => 6,
										'7' => 7,
									],
								],
							],
						],
						'product_tabs_color_bg_info'       => home_block_color_bg_info(),
						'product_tabs_color_bg'            => home_block_color_bg(),
						'product_tabs_color_title'         => home_block_color_title(),
						'product_tabs_image_bg'            => home_block_image_bg(),
						'product_tabs_image_bg_fit'        => home_block_image_bg_fit(),
						'product_tabs_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'product_tabs_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'product_tabs_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'product_tabs_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_2'           => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_2' ),
					'controls' => [
						'home_tab_2_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_advantages'      => [
					'title'    => __( 'Блок "Преимущества"', 'wescle' ),
					'controls' => [
						'home_advantages_preview'             => home_block_preview_img( 'block-with-benefits' ),
						'home_advantages_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_advantages_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_advantages_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .advantages-first .container'
						],
						'home_advantages_title_type'          => header_title_type_block(),
						'home_advantages_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_advantages_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Преимущества', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Преимущество', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id' => [
									'type'        => 'image',
									'label'       => esc_html__( 'Изображение', 'wescle' ),
									'description' => esc_html__( 'рекомендуемые размеры', 'wescle' ) . ', px: 50х50',
									'choices'     => [
										'save_as' => 'id',
									],
								],
								'bg_color' => [
									'type'    => 'color',
									'label'   => esc_html__( 'Цвет фона под изображением', 'wescle' ),
									'choices' => [
										'alpha' => true,
									],
								],
								'title'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'     => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
								'link'     => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка', 'wescle' ),
								]
							]
						],
						'home_advantages_maxwidth'            => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Max-width для блока с изображением', 'wescle' ),
							'default' => 50,
							'choices' => [
								'min'  => 40,
								'max'  => 80,
								'step' => 5,
							],
						],
						'home_advantages_color_bg_info'       => home_block_color_bg_info(),
						'home_advantages_color_bg'            => home_block_color_bg(),
						'home_advantages_color_title'         => home_block_color_title(),
						'home_advantages_image_bg'            => home_block_image_bg(),
						'home_advantages_image_bg_fit'        => home_block_image_bg_fit(),
						'home_advantages_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_advantages_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_advantages_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_advantages_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_advantages_demo_info'           => home_block_demo_info( 'advantages' ),
					]
				],
				'home_advantages2'     => [
					'title'    => __( 'Блок "Дополнительные преимущества"', 'wescle' ),
					'controls' => [
						'home_advantages2_preview'             => home_block_preview_img( 'block-with-benefits' ),
						'home_advantages2_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_advantages2_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_advantages2_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .advantages-double .container'
						],
						'home_advantages2_title_type'          => header_title_type_block(),
						'home_advantages2_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_advantages2_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Преимущества', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Преимущество', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id' => [
									'type'        => 'image',
									'label'       => esc_html__( 'Изображение', 'wescle' ),
									'description' => esc_html__( 'рекомендуемые размеры', 'wescle' ) . ', px: 50х50',
									'choices'     => [
										'save_as' => 'id',
									],
								],
								'bg_color' => [
									'type'    => 'color',
									'label'   => esc_html__( 'Цвет фона под изображением', 'wescle' ),
									'choices' => [
										'alpha' => true,
									],
								],
								'title'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'     => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
								'link'     => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка', 'wescle' ),
								]
							]
						],
						'home_advantages2_maxwidth'            => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Max-width для изображений', 'wescle' ),
							'default' => 50,
							'choices' => [
								'min'  => 40,
								'max'  => 80,
								'step' => 5,
							],
						],
						'home_advantages2_color_bg_info'       => home_block_color_bg_info(),
						'home_advantages2_color_bg'            => home_block_color_bg(),
						'home_advantages2_color_title'         => home_block_color_title(),
						'home_advantages2_image_bg'            => home_block_image_bg(),
						'home_advantages2_image_bg_fit'        => home_block_image_bg_fit(),
						'home_advantages2_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_advantages2_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_advantages2_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_advantages2_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_advantages2_demo_info'           => home_block_demo_info( 'advantages', [], 'advantages_duplicate' ),
					]
				],
				'home_characteristics' => [
					'title'    => __( 'Блок "Характеристики"', 'wescle' ),
					'controls' => [
						'home_characteristics_preview'             => home_block_preview_img( 'block-charact' ),
						'home_characteristics_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_characteristics_id_block'            => [
							'type'     => 'text',
							'label'    => esc_html__( 'ID блока', 'wescle' ),
							'selector' => '.home .characteristics .container'
						],
						'home_characteristics_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Характеристики', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Характеристика', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить Характеристику', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'title'               => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'title_type'          => header_title_type_block(),
								'text_about'          => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
								'block_align'         => [
									'type'    => 'select',
									'default' => 'left',
									'choices' => [
										'left'  => is_rtl() ? esc_html__( 'Показать список справа', 'wescle' ) : esc_html__( 'Показать список слева', 'wescle' ),
										'right' => is_rtl() ? esc_html__( 'Показать список слева', 'wescle' ) : esc_html__( 'Показать список справа', 'wescle' ),
									],
								],
								'text'                => [
									'type'        => 'textarea',
									'label'       => esc_html__( 'Список', 'wescle' ),
									'description' => esc_html__( 'каждый пункт с новой строки', 'wescle' ),
								],
								'list_type'           => [
									'type'    => 'select',
									'label'   => esc_html__( 'Вид списка', 'wescle' ),
									'choices' => [
										'check' => 'чекбокс',
										'radio' => 'буллеты',
									],
								],
								'image_id'            => [
									'type'        => 'image',
									'label'       => esc_html__( 'Изображение', 'wescle' ),
									'description' => esc_html__( 'может использоваться как фон для видео', 'wescle' ),
									'choices'     => [
										'save_as' => 'id',
									],
								],
								'file_url'            => [
									'type'  => 'upload',
									'label' => esc_html__( 'Файл *.mp4', 'wescle' ),
								],
								'youtube_url'         => [
									'type'  => 'url',
									'label' => esc_html__( 'или ссылка на Youtube', 'wescle' ),
								],
								'button_label'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Кнопка', 'wescle' ),
								],
								'button_link'         => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка', 'wescle' ),
								],
								'button_target_blank' => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
								]
							]
						],
						'home_characteristics_color_bg_info'       => home_block_color_bg_info(),
						'home_characteristics_color_bg'            => home_block_color_bg(),
						'home_characteristics_color_title'         => home_block_color_title(),
						'home_characteristics_image_bg'            => home_block_image_bg(),
						'home_characteristics_image_bg_fit'        => home_block_image_bg_fit(),
						'home_characteristics_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_characteristics_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_characteristics_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_characteristics_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_characteristics_demo_info'           => home_block_demo_info( 'requirements' ),
					]
				],
				'home_advantages_v2'   => [
					'title'    => __( 'Блок "Преимущества 4 х 1"', 'wescle' ),
					'controls' => [
						'home_advantages_v2_preview'             => home_block_preview_img( 'block-benefits-4-1' ),
						'home_advantages_v2_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_advantages_v2_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_advantages_v2_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .advantages-v2 .container'
						],
						'home_advantages_v2_title_type'          => header_title_type_block(),
						'home_advantages_v2_subtitle'            => [
							'type'  => 'text',
							'label' => esc_html__( 'Подзаголовок', 'wescle' ),
						],
						'home_advantages_v2_image'               => [
							'type'        => 'image',
							'label'       => esc_html__( 'Центральное изображение', 'wescle' ),
							'description' => esc_html__( 'рекомендованные размеры', 'wescle' ) . ': 400x600px',
							'choices'     => [
								'save_as' => 'id',
							],
						],
						'home_advantages_v2_gradient_1'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Первый цвет для градиента', 'wescle' ),
							'default' => '#fa1abe',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_advantages_v2_gradient_2'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Второй цвет для градиента', 'wescle' ),
							'default' => '#0088cc',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_advantages_v2_opacity'             => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Прозрачность', 'wescle' ),
							'default' => 20,
							'choices' => [
								'min'  => 0,
								'max'  => 100,
								'step' => 10,
							],
						],
						'home_advantages_v2_blur'                => [
							'type'    => 'number',
							'label'   => esc_html__( 'Размытие', 'wescle' ) . ', px',
							'default' => 10,
						],
						'home_advantages_v2_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Преимущества', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Преимущество', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить преимущество', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id' => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => [
										'save_as' => 'id',
									],
								],
								'title'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'     => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
								'link'     => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка', 'wescle' ),
								],
							],
							'choices'      => [
								'limit' => 4
							],
						],
						'home_advantages_v2_items_gradient'      => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет колец вокруг изображений', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'home_advantages_v2_items_opacity'       => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Прозрачность колец вокруг изображений', 'wescle' ),
							'default' => 10,
							'choices' => [
								'min'  => 0,
								'max'  => 100,
								'step' => 10,
							],
						],
						'home_advantages_v2_items_border_width'  => [
							'type'    => 'number',
							'label'   => esc_html__( 'Толщина колец вокруг изображений', 'wescle' ),
							'default' => 10
						],
						'home_advantages_v2_color_bg_info'       => home_block_color_bg_info(),
						'home_advantages_v2_color_bg'            => home_block_color_bg(),
						'home_advantages_v2_color_title'         => home_block_color_title(),
						'home_advantages_v2_image_bg'            => home_block_image_bg(),
						'home_advantages_v2_image_bg_fit'        => home_block_image_bg_fit(),
						'home_advantages_v2_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_advantages_v2_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_advantages_v2_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_advantages_v2_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_advantages_v2_demo_info'           => home_block_demo_info( 'advantages2' ),
					]
				],
				'home_pros_cons'       => [
					'title'    => __( 'Блок "За и Против"', 'wescle' ),
					'controls' => [
						'home_pros_cons_preview'             => home_block_preview_img( 'block-comparison' ),
						'home_pros_cons_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_pros_cons_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_pros_cons_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .plus-minus .container'
						],
						'home_pros_cons_title_type'          => header_title_type_block(),
						'home_pros_cons_plus'                => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'За', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'За', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить "За"', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'text' => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							],
						],
						'home_pros_cons_minus'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Против', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Против', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить "Против"', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'text' => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							],
						],
						'home_pros_cons_inner_bg'            => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон внутреннего блока', 'wescle' ),
							'default' => '',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_pros_cons_color_bg_info'       => home_block_color_bg_info(),
						'home_pros_cons_color_bg'            => home_block_color_bg(),
						'home_pros_cons_color_title'         => home_block_color_title(),
						'home_pros_cons_image_bg'            => home_block_image_bg(),
						'home_pros_cons_image_bg_fit'        => home_block_image_bg_fit(),
						'home_pros_cons_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_pros_cons_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_pros_cons_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_pros_cons_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_pros_cons_demo_info'           => home_block_demo_info( 'plus-minus' ),
					]
				],

				'home_checklist'     => [
					'title'    => __( 'Блок "Чеклист"', 'wescle' ),
					'controls' => [
						'home_checklist_preview'             => home_block_preview_img( 'block-checklist' ),
						'home_checklist_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_checklist_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_checklist_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .checklist .container'
						],
						'home_checklist_title_type'          => header_title_type_block(),
						'home_checklist_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_checklist_plus'                => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'За', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'За', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить "За"', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'text' => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							],
						],
						'home_checklist_title_plus'          => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок блока "За"', 'wescle' ),
						],
						'home_checklist_bg_plus'             => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон внутреннего блока "За"', 'wescle' ),
							'default' => '',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_checklist_border_plus'         => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет обводки блока "За"', 'wescle' ),
							'default' => '',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_checklist_minus'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Против', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Против', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить "Против"', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'text' => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							],
						],
						'home_checklist_title_minus'         => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок блока "Против"', 'wescle' ),
						],
						'home_checklist_bg_minus'            => [
							'type'    => 'color',
							'label'   => esc_html__( 'Фон внутреннего блока "Против"', 'wescle' ),
							'default' => '',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_checklist_border_minus'        => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет обводки блока "Против"', 'wescle' ),
							'default' => '#ef383f',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_checklist_open'                => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись для разворачивания блока', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_checklist_open' )
						],
						'home_checklist_close'               => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись для сворачивания блока', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_checklist_close' )
						],
						'home_checklist_color_bg_info'       => home_block_color_bg_info(),
						'home_checklist_color_bg'            => home_block_color_bg(),
						'home_checklist_color_title'         => home_block_color_title(),
						'home_checklist_image_bg'            => home_block_image_bg(),
						'home_checklist_image_bg_fit'        => home_block_image_bg_fit(),
						'home_checklist_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_checklist_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_checklist_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_checklist_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_checklist_demo_info'           => home_block_demo_info( 'checklist' ),
					]
				],
				'home_advantages_v3' => [
					'title'    => __( 'Блок "История"', 'wescle' ),
					'controls' => [
						'home_advantages_v3_preview'             => home_block_preview_img( 'block-timeline' ),
						'home_advantages_v3_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_advantages_v3_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_advantages_v3_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .advantages-v3 .container'
						],
						'home_advantages_v3_title_type'          => header_title_type_block(),
						'home_advantages_v3_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_advantages_v3_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Этапы', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Этап', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'number' => [
									'type'  => 'text',
									'label' => esc_html__( 'Номер / Год', 'wescle' ),
								],
								'title'  => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'   => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							]
						],
						'home_advantages_v3_color_bg_info'       => home_block_color_bg_info(),
						'home_advantages_v3_color_bg'            => home_block_color_bg(),
						'home_advantages_v3_color_title'         => home_block_color_title(),
						'home_advantages_v3_image_bg'            => home_block_image_bg(),
						'home_advantages_v3_image_bg_fit'        => home_block_image_bg_fit(),
						'home_advantages_v3_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_advantages_v3_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_advantages_v3_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_advantages_v3_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_3'           => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_3' ),
					'controls' => [
						'home_tab_3_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_services'        => [
					'title'    => __( 'Блок "Услуги"', 'wescle' ),
					'controls' => [
						'home_services_preview'             => home_block_preview_img( 'block-services' ),
						'home_services_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_services_enabled_home'        => home_block_enabled(),
						'home_services_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'service', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Услуги" успешно добавлена. Чтобы появился список услуг для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Услуги"</a>', 'wescle' ), admin_url( '/edit.php?post_type=service' ) ) . '</div>',
						],
						'home_services_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Услуги созданы, как Custom Post Type. Чтобы добавить услугу необходимо перейти в <a href="%s" target="_blank">раздел "Услуги"</a> и добавить новую, затем можно будет выбрать ее здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=service' ) ) . '</div>',
						],
						'home_services_info3'               => [
							'type'    => $page_template_services ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу c услугами, для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Services".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_services_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_services_title'               => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_services_title' )
						],
						'home_services_title_type'          => header_title_type_block(),
						'home_services_text'                => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => '',
						],
						'home_services_link_id'             => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка на все услуги', 'wescle' ),
							'default'     => get_theme_mod( 'home_services_link_id', 0 ),
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							), true ),
						],
						'home_services_button_text'         => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_services_button_text' )
						],
						'home_services_link_text'           => [
							'type'    => 'text',
							'label'   => esc_html__( 'Текст для надписи "Все услуги"', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_services_link_text' )
						],
						'home_services_as_horizontal'       => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить горизонтальный вид с описанием под фото?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_services_opacity'             => [
							'type'            => 'slider',
							'label'           => esc_html__( 'Прозрачность overlay', 'wescle' ),
							'default'         => 100,
							'choices'         => [
								'min'  => 0,
								'max'  => 100,
								'step' => 10,
							],
							'active_callback' => [
								[
									'setting'  => 'home_services_as_horizontal',
									'operator' => '==',
									'value'    => false,
								]
							]
						],
						'home_services_opacity_hover'       => [
							'type'            => 'slider',
							'label'           => esc_html__( 'Прозрачность overlay', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'default'         => 100,
							'choices'         => [
								'min'  => 0,
								'max'  => 100,
								'step' => 10,
							],
							'active_callback' => [
								[
									'setting'  => 'home_services_as_horizontal',
									'operator' => '==',
									'value'    => false,
								]
							]
						],
						'home_services_posts'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Услуги', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Услуга', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить услугу', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'post_id'   => [
									'type'        => 'select',
									'label'       => esc_html__( 'Выберите услугу', 'wescle' ),
									'default'     => 0,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type' => [ 'service' ]
									), true ),
								],
								'price'     => [
									'type'  => 'text',
									'label' => esc_html__( 'Цена', 'wescle' ),
								],
								'price_old' => [
									'type'  => 'text',
									'label' => esc_html__( 'Старая цена', 'wescle' ),
								],
								'size'      => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Размер карточки с услугой?', 'wescle' ),
									'default' => 'default',
									'choices' => array(
										'default' => esc_html__( 'Стандарт', 'wescle' ),
										'big'     => esc_html__( 'Большой', 'wescle' ),
									),
								],
							]
						],
						'home_services_color_bg_info'       => home_block_color_bg_info(),
						'home_services_color_bg'            => home_block_color_bg(),
						'home_services_color_title'         => home_block_color_title(),
						'home_services_image_bg'            => home_block_image_bg(),
						'home_services_image_bg_fit'        => home_block_image_bg_fit(),
						'home_services_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_services_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_services_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_services_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'home_services2'       => [
					'title'    => __( 'Блок "Услуги 2"', 'wescle' ),
					'controls' => [
						'home_services2_preview'             => home_block_preview_img( 'block-services-two' ),
						'home_services2_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_services2_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_services2_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'default'  => Helper::get_default_theme_data( 'home_services2_title' ),
							'selector' => '.home .services-v2 .container'
						],
						'home_services2_title_type'          => header_title_type_block(),
						'home_services2_text'                => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => '',
						],
						'home_services2_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Услуги', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Услуга', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить услугу', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image'    => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => array(
										'save_as' => 'id'
									),
								],
								'maxwidth' => [
									'type'    => 'number',
									'label'   => esc_html__( 'Размер для блока с изображением', 'wescle' ),
									'default' => 50,
									'choices' => [
										'min'  => 40,
										'max'  => 140,
										'step' => 10,
									],
								],
								'title'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'     => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							]
						],
						'home_services2_color_bg_info'       => home_block_color_bg_info(),
						'home_services2_color_bg'            => home_block_color_bg(),
						'home_services2_color_title'         => home_block_color_title(),
						'home_services2_image_bg'            => home_block_image_bg(),
						'home_services2_image_bg_fit'        => home_block_image_bg_fit(),
						'home_services2_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_services2_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_services2_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_services2_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'home_services_slider' => [
					'title'    => __( 'Блок "Услуги: слайдер"', 'wescle' ),
					'controls' => [
						'home_services_slider_preview'               => home_block_preview_img( 'block-services-slider' ),
						'home_services_slider_enabled'               => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_services_slider_id_block'              => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_services_slider_title'                 => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .additional-services .container'
						],
						'home_services_slider_title_type'            => header_title_type_block(),
						'home_services_slider_text'                  => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => '',
						],
						'home_services_slider_link_id'               => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка на все услуги', 'wescle' ),
							'default'     => '',
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							) ),
						],
						'home_services_slider_link_text'             => [
							'type'  => 'text',
							'label' => esc_html__( 'Текст для надписи "Все услуги"', 'wescle' ),
						],
						'home_services_slider_posts'                 => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Услуги', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Услуга', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить услугу', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'post_id' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Выберите услугу', 'wescle' ),
									'default'     => 0,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type' => [ 'service' ]
									), true ),
								]
							]
						],
						'home_services_slider_maxwidth'              => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Max-width для блока с изображением', 'wescle' ),
							'default' => 70,
							'choices' => [
								'min'  => 40,
								'max'  => 150,
								'step' => 10,
							],
						],
						'home_services_slider_settings_info'         => home_slider_settings_info(),
						'home_services_slider_settings_count'        => home_slider_settings_count( 3, 6 ),
						'home_services_slider_settings_speed'        => home_slider_settings_speed( 'slider', 5 ),
						'home_services_slider_settings_arrow'        => home_slider_settings_arrow(),
						'home_services_slider_settings_arrow_mobile' => home_slider_settings_arrow_mobile(),
						'home_services_slider_settings_dots'         => home_slider_settings_dots( true ),
						'home_services_slider_color_bg_info'         => home_block_color_bg_info(),
						'home_services_slider_color_bg'              => home_block_color_bg(),
						'home_services_slider_color_title'           => home_block_color_title(),
						'home_services_slider_image_bg'              => home_block_image_bg(),
						'home_services_slider_image_bg_fit'          => home_block_image_bg_fit(),
						'home_services_slider_image_bg_tablet'       => home_block_image_bg( 'tablet' ),
						'home_services_slider_image_bg_fit_tablet'   => home_block_image_bg_fit( 'tablet' ),
						'home_services_slider_image_bg_mobile'       => home_block_image_bg( 'mobile' ),
						'home_services_slider_image_bg_fit_mobile'   => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_16' => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_16' ),
					'controls' => [
						'home_tab_16_info' => [
							'type' => 'custom'
						]
					]
				],

				'home_prodwescle' => [
					'title'    => __( 'Блок "Товары / Услуги"', 'wescle' ),
					'controls' => [
						'home_prodwescle_preview'             => home_block_preview_img( 'block-services-products' ),
						'home_prodwescle_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_prodwescle_enabled_home'        => home_block_enabled(),
						'home_prodwescle_info0'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . __( 'Товары данной секции построены как Custom Post Type, которые имеют свои страницы и категории. В них нету возможности купить через платежную систему, это плитка товаров по категории, которая дает возможность создавать объекты с формой запроса, подойдет для инфо-продуктов или отображения услуг.', 'wescle' ) . '</div>',
						],
						'home_prodwescle_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'product_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Товары" успешно добавлена. Чтобы появился список товаров для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Товары"</a>', 'wescle' ), admin_url( '/edit.php?post_type=product_wescle' ) ) . '</div>',
						],
						'home_prodwescle_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Чтобы добавить товар необходимо перейти в <a href="%s" target="_blank">раздел "Товары / Услуги"</a> и добавить новый, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=product_wescle' ) ) . '</div>',
						],
						'home_prodwescle_info3'               => [
							'type'    => $page_template_products ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу "Товары", для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Products Wescle".', 'wescle' ), admin_url( '/post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_prodwescle_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_prodwescle_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .products-section .container'
						],
						'home_prodwescle_title_type'          => header_title_type_block(),
						'home_prodwescle_text'                => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => '',
						],
						'home_prodwescle_link_id'             => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка на все товары', 'wescle' ),
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							), true ),
						],
						'home_prodwescle_link_text'           => [
							'type'    => 'text',
							'label'   => esc_html__( 'Текст для надписи "Все товары"', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_prodwescle_link_text' )
						],
						'home_prodwescle_category'            => [
							'type'        => 'select',
							'label'       => esc_html__( 'Категория товаров', 'wescle' ),
							'default'     => [],
							'multiple'    => 999,
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_terms( array( 'taxonomy' => 'productcat_wescle' ) ),
						],
						'home_prodwescle_limit'               => [
							'type'    => 'number',
							'label'   => esc_html__( 'Количество товаров', 'wescle' ),
							'default' => 8,
							'choices' => choices_number(),
						],
						'home_prodwescle_posts'               => [
							'type'        => 'select',
							'label'       => esc_html__( 'или выберите Товары', 'wescle' ),
							'default'     => 0,
							'multiple'    => 999,
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => 'product_wescle',
							) ),
						],
						'home_prodwescle_gradient_1'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Первый цвет для градиента', 'wescle' ),
							'default' => '#0088cc',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_prodwescle_gradient_2'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Второй цвет для градиента', 'wescle' ),
							'default' => '#fa1abe',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_prodwescle_opacity'             => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Прозрачность', 'wescle' ),
							'default' => 50,
							'choices' => [
								'min'  => 0,
								'max'  => 100,
								'step' => 10,
							],
						],
						'home_prodwescle_blur'                => [
							'type'    => 'number',
							'label'   => esc_html__( 'Размытие', 'wescle' ) . ', px',
							'default' => 5,
						],
						'home_prodwescle_more_text'           => [
							'type'        => 'text',
							'label'       => esc_html__( 'Текст для кнопки "Еще"', 'wescle' ),
							'description' => esc_html__( 'оставьте поле пустым, если не нужно выводить кнопку', 'wescle' ),
							'default'     => Helper::get_default_theme_data( 'home_prodwescle_more_text' ),
						],
						'home_prodwescle_color_bg_info'       => home_block_color_bg_info(),
						'home_prodwescle_color_bg'            => home_block_color_bg(),
						'home_prodwescle_color_title'         => home_block_color_title(),
						'home_prodwescle_image_bg'            => home_block_image_bg(),
						'home_prodwescle_image_bg_fit'        => home_block_image_bg_fit(),
						'home_prodwescle_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_prodwescle_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_prodwescle_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_prodwescle_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'woo_banners'        => [
					'title'    => Helper::is_woocommerce_active() ? esc_html__( 'Баннера товаров Woo', 'wescle' ) : '',
					'controls' => [
						'woo_banners_preview'             => home_block_preview_img( 'block-woo-banners2' ),
						'woo_banners_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'woo_banners_id_block'            => [
							'type'     => 'text',
							'label'    => esc_html__( 'ID блока', 'wescle' ),
							'selector' => '.home .goods-banners .container'
						],
						'woo_banners_title'               => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок', 'wescle' ),
						],
						'woo_banners_title_type'          => header_title_type_block(),
						'woo_banners_text'                => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => '',
						],
						'woo_banners_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Баннеры', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Баннер', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить баннер', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image'        => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => array(
										'save_as' => 'id'
									),
								],
								'title'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'price'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Цена', 'wescle' ),
								],
								'price_old'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Старая цена', 'wescle' ),
								],
								'button_label' => [
									'type'    => 'text',
									'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
									'default' => esc_html__( 'Купить сейчас', 'wescle' ),
								],
								'button_url'   => [
									'type'        => 'url',
									'label'       => esc_html__( 'URL для кнопки', 'wescle' ),
									'description' => __( '* чтобы кнопку сделать вызовом попапа звонка, пропишите <code>#modal-call</code>', 'wescle' ),
								],
								'link_label'   => [
									'type'  => 'text',
									'label' => esc_html__( 'Текстовая ссылка', 'wescle' ),
								],
								'link_url'     => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка', 'wescle' ),
								],
								'banner_big'   => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Сделать баннер большим?', 'wescle' ),
								],
							]
						],
						'woo_banners_without_gradient'    => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Отключить затемнение на баннерах?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'woo_banners_opacity'             => [
							'type'            => 'slider',
							'label'           => esc_html__( 'Прозрачность затемнение', 'wescle' ),
							'default'         => 100,
							'choices'         => [
								'min'  => 10,
								'max'  => 100,
								'step' => 10,
							],
							'active_callback' => [
								[
									'setting'  => 'woo_banners_without_gradient',
									'operator' => '==',
									'value'    => false,
								]
							]
						],
						'woo_banners_item_color_title'    => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет заголовка', 'wescle' ),
							'default' => '#ffffff',
							'choices' => [
								'alpha' => true,
							],
						],
						'woo_banners_item_color_price'    => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста с ценой', 'wescle' ),
							'default' => '#ffffff',
							'choices' => [
								'alpha' => true,
							],
						],
						'woo_banners_color_bg_info'       => home_block_color_bg_info(),
						'woo_banners_color_bg'            => home_block_color_bg(),
						'woo_banners_color_title'         => home_block_color_title(),
						'woo_banners_image_bg'            => home_block_image_bg(),
						'woo_banners_image_bg_fit'        => home_block_image_bg_fit(),
						'woo_banners_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'woo_banners_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'woo_banners_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'woo_banners_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'home_licensewescle' => [
					'title'    => __( 'Блок "Лицензии"', 'wescle' ),
					'controls' => [
						'home_licenses_preview'             => home_block_preview_img( 'block-licenses' ),
						'home_licenses_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_licenses_enabled_home'        => home_block_enabled(),
						'home_licenses_info'                => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Чтобы добавить лицензию необходимо перейти в <a href="%s" target="_blank">раздел "Лицензии"</a> и добавить новую', 'wescle' ), admin_url( '/edit.php?post_type=license_wescle' ) ) . '</div>',
						],
						'home_licenses_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_licenses_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .licenses .container'
						],
						'home_licenses_title_type'          => header_title_type_block(),
						'home_licenses_text'                => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => '',
						],
						'home_licenses_action_label'        => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок блока с таймером', 'wescle' ),
						],
						'home_licenses_action_type'         => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Тип таймера', 'wescle' ),
							'default' => 'date',
							'choices' => [
								'date'  => esc_html__( 'По дате окончания', 'wescle' ),
								'hours' => esc_html__( 'Окончание через X часов с момента посещения', 'wescle' ),
							]
						],
						'home_licenses_action_date'         => [
							'type'            => 'date',
							'label'           => esc_html__( 'Дата окончания акции', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'home_licenses_action_type',
									'operator' => '==',
									'value'    => 'date',
								]
							],
						],
						'home_licenses_action_hours'        => [
							'type'            => 'number',
							'label'           => esc_html__( 'Через сколько часов окончания акции?', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'home_licenses_action_type',
									'operator' => '==',
									'value'    => 'hours',
								]
							],
						],
						'home_licenses_cf7'                 => cf7_type_block( $label_select, esc_html__( 'Выберите форму CF7', 'wescle' ), 'home_price_table' ),
						'home_licenses_color_bg_info'       => home_block_color_bg_info(),
						'home_licenses_color_bg'            => home_block_color_bg(),
						'home_licenses_color_title'         => home_block_color_title(),
						'home_licenses_image_bg'            => home_block_image_bg(),
						'home_licenses_image_bg_fit'        => home_block_image_bg_fit(),
						'home_licenses_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_licenses_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_licenses_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_licenses_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_catalog' => [
					'title'    => get_theme_mod( 'module_catalog_enabled' ) ? esc_html__( 'Блок "Каталог"', 'wescle' ) : '',
					'controls' => [
						'module_catalog_preview'             => home_block_preview_img( 'block-catalog' ),
						'module_catalog_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Элементы каталога созданы, как Custom Post Type. Чтобы добавить элемент каталога необходимо перейти в <a href="%s" target="_blank">раздел "Каталог"</a> и добавить новую запись.', 'wescle' ), admin_url( '/edit.php?post_type=catalog_item' ) ) . '</div>',
						],
						'module_catalog_info3'               => [
							'type'    => $page_template_catalog ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу c элементами каталога, для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Catalog Wescle".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'module_catalog_enabled_home'        => home_block_enabled(),
						'home_catalog_id_block'              => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'module_catalog_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .wescle-transport .container'
						],
						'module_catalog_title_type'          => header_title_type_block(),
						'module_catalog_text'                => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => '',
						],
						'module_catalog_link_id'             => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка на все элементы каталога', 'wescle' ),
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							), true ),
						],
						'module_catalog_link_text'           => [
							'type'    => 'text',
							'label'   => esc_html__( 'Текст для надписи "Все товары"', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'module_catalog_link_text' )
						],
						'module_catalog_tabs'                => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Табы', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Таб', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить таб', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'catalog_tab_title'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Название таба', 'wescle' ),
								],
								'catalog_tab_category' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Категория элементов', 'wescle' ),
									'default'     => [],
									'multiple'    => 999,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_terms( array( 'taxonomy' => 'catalogcat_wescle' ) ),
								],
								'catalog_tab_limit'    => [
									'type'    => 'number',
									'label'   => esc_html__( 'Количество элементов', 'wescle' ),
									'default' => 6,
									'choices' => choices_number(),
								],
								'catalog_tab_item_ids' => [
									'type'        => 'text',
									'label'       => esc_html__( 'или укажите отдельные элементы', 'wescle' ),
									'default'     => '',
									'description' => __( 'Пропишите ID элементов через запятую', 'wescle' )
								],
							]
						],
						'module_catalog_more_text'           => [
							'type'        => 'text',
							'label'       => esc_html__( 'Текст для кнопки "Еще"', 'wescle' ),
							'description' => esc_html__( 'оставьте поле пустым, если не нужно выводить кнопку', 'wescle' ),
							'default'     => Helper::get_default_theme_data( 'module_catalog_more_text' ),
						],
						'module_catalog_color_bg_info'       => home_block_color_bg_info(),
						'module_catalog_color_bg'            => home_block_color_bg(),
						'module_catalog_color_title'         => home_block_color_title(),
						'module_catalog_image_bg'            => home_block_image_bg(),
						'module_catalog_image_bg_fit'        => home_block_image_bg_fit(),
						'module_catalog_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'module_catalog_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'module_catalog_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'module_catalog_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_catalogcats' => [
					'title'    => esc_html__( 'Блок "Категории"', 'wescle' ),
					'controls' => [
						//'home_catalogcats_preview'             => home_block_preview_img( 'block-catalog' ),
						'home_catalogcats_enabled'        => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_catalogcats_id_block'       => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_catalogcats_title'          => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .wescle-categories .container'
						],
						'home_catalogcats_title_type'     => header_title_type_block(),
						'home_catalogcats_text'           => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => '',
						],
						'home_catalogcats_link_text'      => [
							'type'  => 'text',
							'label' => esc_html__( 'Текст ссылки', 'wescle' ),
						],
						'home_catalogcats_link_url'       => [
							'type'  => 'text',
							'label' => esc_html__( 'URL ссылки', 'wescle' ),
						],
						'home_catalogcats_taxonomy'       => [
							'type'    => 'select',
							'label'   => esc_html__( 'Таксономия', 'wescle' ),
							'default' => 0,
							'choices' => [ $label_select ] + Helper::get_public_taxonomies(),
						],
						'home_catalogcats_limit'          => [
							'type'    => 'number',
							'label'   => esc_html__( 'Количество категорий', 'wescle' ),
							'default' => 10,
							'choices' => choices_number(),
						],
						'home_catalogcats_ids'            => [
							'type'        => 'text',
							'label'       => esc_html__( 'или укажите отдельные категории', 'wescle' ),
							'default'     => '',
							'description' => __( 'Пропишите ID категорий через запятую', 'wescle' )
						],
						'home_catalogcats_shadow'         => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Вид категорий с тенью?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'home_catalogcats_count_at_img'   => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Вид категорий с обводкой на картинке и количество вверху?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_catalogcats_show_count'     => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать количество категорий?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'home_catalogcats_count_slides'   => [
							'type'    => 'select',
							'label'   => esc_html__( 'Категорий в строке', 'wescle' ),
							'default' => '5',
							'choices' => [
								'2' => 2,
								'3' => 3,
								'4' => 4,
								'5' => 5,
								'6' => 6,
								'7' => 7,
							],
						],
						'home_catalogcats_slider_enabled' => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать слайдер?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],

						'home_catalogcats_slider_arrow'        => home_slider_settings_arrow( true, 'switch', [ [ 'setting' => 'home_catalogcats_slider_enabled', 'operator' => '==', 'value' => true ] ] ),
						'home_catalogcats_slider_arrow_mobile' => home_slider_settings_arrow_mobile( true, 'switch', [ [ 'setting' => 'home_catalogcats_slider_enabled', 'operator' => '==', 'value' => true ] ] ),
						'home_catalogcats_slider_dots'         => home_slider_settings_dots( false, 'switch', [ [ 'setting' => 'home_catalogcats_slider_enabled', 'operator' => '==', 'value' => true ] ] ),
						'home_catalogcats_slider_speed'        => home_slider_settings_speed( 'slider', 5, [ [ 'setting' => 'home_catalogcats_slider_enabled', 'operator' => '==', 'value' => true ] ] ),

						'home_catalogcats_color_bg_info'       => home_block_color_bg_info(),
						'home_catalogcats_color_bg'            => home_block_color_bg(),
						'home_catalogcats_color_title'         => home_block_color_title(),
						'home_catalogcats_image_bg'            => home_block_image_bg(),
						'home_catalogcats_image_bg_fit'        => home_block_image_bg_fit(),
						'home_catalogcats_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_catalogcats_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_catalogcats_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_catalogcats_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_4'     => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_4' ),
					'controls' => [
						'home_tab_4_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_portfolio' => [
					'title'    => __( 'Блок "Портфолио работ"', 'wescle' ),
					'controls' => [
						'home_portfolio_preview'             => home_block_preview_img( 'block-portfolio' ),
						'home_portfolio_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_portfolio_enabled_home'        => home_block_enabled(),
						'home_portfolio_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'portfolio_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Портфолио работ" успешно добавлена. Чтобы появился список портфолио для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Портфолио работ"</a>', 'wescle' ), admin_url( '/edit.php?post_type=portfolio_wescle' ) ) . '</div>',
						],
						'home_portfolio_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Портфолио работ созданы, как Custom Post Type. Чтобы добавить портфолио необходимо перейти в <a href="%s" target="_blank">раздел "Портфолио работ"</a> и добавить новое, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=portfolio_wescle' ) ) . '</div>',
						],
						'home_portfolio_info3'               => [
							'type'    => $page_template_portfolio ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу "Портфолио работ", для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Portfolios".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_portfolio_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_portfolio_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .work-performed .container'
						],
						'home_portfolio_title_type'          => header_title_type_block(),
						'home_portfolio_text'                => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => '',
						],
						'home_portfolio_link_id'             => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка на все работы', 'wescle' ),
							'default'     => get_theme_mod( 'home_portfolio_link_id', 0 ),
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							), true ),
						],
						'home_portfolio_link_text'           => [
							'type'    => 'text',
							'label'   => esc_html__( 'Текст для надписи "Все работы"', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_portfolio_link_text' ),
						],
						'home_portfolio_count'               => [
							'type'    => 'number',
							'label'   => esc_html__( 'Количество работ', 'wescle' ),
							'default' => 4,
						],
						'home_portfolio_posts'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Портфолио', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Работа', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить работу', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'post_id'        => [
									'type'        => 'select',
									'label'       => esc_html__( 'Выберите работу', 'wescle' ),
									'default'     => 0,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type' => [ 'portfolio_wescle' ]
									), true ),
								],
								'size_portfolio' => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Размер карточки с работой?', 'wescle' ),
									'default' => 'default',
									'choices' => array(
										'default' => esc_html__( 'Стандарт', 'wescle' ),
										'big'     => esc_html__( 'Большой', 'wescle' ),
									),
								],
							]
						],
						'home_portfolio_more_text'           => [
							'type'        => 'text',
							'label'       => esc_html__( 'Текст для кнопки "Еще"', 'wescle' ),
							'description' => esc_html__( 'оставьте поле пустым, если не нужно выводить кнопку', 'wescle' ),
							'default'     => Helper::get_default_theme_data( 'home_portfolio_more_text' ),
						],
						'home_portfolio_color_bg_info'       => home_block_color_bg_info(),
						'home_portfolio_color_bg'            => home_block_color_bg(),
						'home_portfolio_color_title'         => home_block_color_title(),
						'home_portfolio_image_bg'            => home_block_image_bg(),
						'home_portfolio_image_bg_fit'        => home_block_image_bg_fit(),
						'home_portfolio_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_portfolio_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_portfolio_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_portfolio_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'home_gallery'   => [
					'title'    => __( 'Блок "Галерея"', 'wescle' ),
					'controls' => [
						'home_gallery_preview'         => home_block_preview_img( 'block-gallery' ),
						'home_gallery_enabled'         => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_gallery_enabled_home'    => home_block_enabled(),
						'home_gallery_info'            => [
							'type'    => Helper::get_posts( array( 'post_type' => 'gallery_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Галерея" успешно добавлена. Чтобы появились изображения, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Галерея"</a>', 'wescle' ), admin_url( '/edit.php?post_type=gallery_wescle' ) ) . '</div>',
						],
						'home_gallery_info2'           => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Чтобы добавить категорию галереи, необходимо перейти в <a href="%s" target="_blank">раздел "Категории галереи"</a> и добавить новую, затем можно будет выбрать ее здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit-tags.php?taxonomy=gallerycat_wescle&post_type=gallery_wescle' ) ) . '</div>',
						],
						'home_gallery_info3'           => [
							'type'    => $page_template_gallery ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу "Галерея", для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Gallery".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_gallery_id_block'        => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_gallery_title'           => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .our-works .container'
						],
						'home_gallery_title_type'      => header_title_type_block(),
						'home_gallery_text'            => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_gallery_hide_filter_all' => [
							'type'    => 'checkbox',
							'label'   => esc_html__( 'Скрыть кнопку "Все"?', 'wescle' ),
							'default' => false,
						],
						'home_gallery_items'           => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Категории галереи', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Категория', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить категорию', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'faq_cat' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Категория галереи', 'wescle' ),
									'multiple'    => false,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_terms( array( 'taxonomy' => 'gallerycat_wescle' ), false, true ),
								],
							]
						],

						'home_gallery_slider_enabled'      => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать слайдер?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_gallery_count_slides'        => [
							'type'            => 'number',
							'label'           => esc_html__( 'Количество слайдов', 'wescle' ),
							'default'         => 3,
							'active_callback' => [
								[
									'setting'  => 'home_gallery_slider_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'home_gallery_slider_arrow'        => home_slider_settings_arrow( true, 'switch', [ [ 'setting' => 'home_gallery_slider_enabled', 'operator' => '==', 'value' => true ] ] ),
						'home_gallery_slider_arrow_mobile' => home_slider_settings_arrow_mobile( true, 'switch', [ [ 'setting' => 'home_gallery_slider_enabled', 'operator' => '==', 'value' => true ] ] ),
						'home_gallery_slider_dots'         => home_slider_settings_dots( false, 'switch', [ [ 'setting' => 'home_gallery_slider_enabled', 'operator' => '==', 'value' => true ] ] ),
						'home_gallery_slider_speed'        => home_slider_settings_speed( 'slider', 5, [ [ 'setting' => 'home_gallery_slider_enabled', 'operator' => '==', 'value' => true ] ] ),

						'home_gallery_color_bg_info'       => home_block_color_bg_info(),
						'home_gallery_color_bg'            => home_block_color_bg(),
						'home_gallery_color_title'         => home_block_color_title(),
						'home_gallery_image_bg'            => home_block_image_bg(),
						'home_gallery_image_bg_fit'        => home_block_image_bg_fit(),
						'home_gallery_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_gallery_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_gallery_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_gallery_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_5' => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_5' ),
					'controls' => [
						'home_tab_5_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_about' => [
					'title'    => __( 'Блок "О нас"', 'wescle' ),
					'controls' => [
						'home_about_preview'             => home_block_preview_img( 'block-about-us' ),
						'home_about_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'home_about_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_about_title'               => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_about_title' ),
						],
						'home_about_title_type'          => header_title_type_block(),
						'home_about_text'                => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_about_text' ),
						],
						'home_about_link_id'             => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка для кнопки "Подробнее"', 'wescle' ),
							'description' => esc_html__( '^не обязательно', 'wescle' ),
							'default'     => '',
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							), true ),
						],
						'home_about_button_text'         => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
							'default' => esc_html__( 'Подробнее', 'wescle' ),
						],
						'home_about_image'               => [
							'type'    => 'image',
							'label'   => esc_html__( 'Изображение', 'wescle' ),
							'choices' => [
								'save_as' => 'id',
							],
						],
						'home_about_color_bg_info'       => home_block_color_bg_info(),
						'home_about_color_bg'            => home_block_color_bg(),
						'home_about_color_title'         => home_block_color_title(),
						'home_about_image_bg'            => home_block_image_bg(),
						'home_about_image_bg_fit'        => home_block_image_bg_fit(),
						'home_about_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_about_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_about_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_about_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_about_demo_info'           => home_block_demo_info( 'about' ),
					]
				],

				'home_about2' => [
					'title'    => __( 'Блок "О нас 2"', 'wescle' ),
					'controls' => [
						'home_about2_preview'             => home_block_preview_img( 'block-about-us-two' ),
						'home_about2_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_about2_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_about2_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .about-2 .container'
						],
						'home_about2_title_type'          => header_title_type_block(),
						'home_about2_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Список', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Элемент', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить элемент', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image' => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение', 'wescle' ),
								],
								'title' => [
									'type'  => 'text',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							]
						],
						'home_about2_image'               => [
							'type'    => 'image',
							'label'   => esc_html__( 'Изображение', 'wescle' ),
							'choices' => [
								'save_as' => 'id',
							],
						],
						'home_about2_image_object_fit'    => [
							'type'  => 'checkbox',
							'label' => esc_html__( 'Включить режим заполнения', 'wescle' ) . ' (object-fit) "cover"?'
						],
						'home_about2_color_bg_info'       => home_block_color_bg_info(),
						'home_about2_color_bg'            => home_block_color_bg(),
						'home_about2_color_title'         => home_block_color_title(),
						'home_about2_image_bg'            => home_block_image_bg(),
						'home_about2_image_bg_fit'        => home_block_image_bg_fit(),
						'home_about2_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_about2_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_about2_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_about2_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_about2_demo_info'           => home_block_demo_info( 'about' ),
					]
				],

				'home_information' => [
					'title'    => __( 'Блок "Информация"', 'wescle' ),
					'controls' => [
						'home_information_preview'               => home_block_preview_img( 'block-information' ),
						'home_information_enabled'               => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_information_id_block'              => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_information_title'                 => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок', 'wescle' ),
						],
						'home_information_title_type'            => header_title_type_block(),
						'home_information_text'                  => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_information_button_label'          => [
							'type'  => 'text',
							'label' => esc_html__( 'Текст ссылки', 'wescle' ),
						],
						'home_information_button_url'            => [
							'type'  => 'text',
							'label' => esc_html__( 'URL ссылки', 'wescle' ),
						],
						'home_information_items'                 => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Слайдер', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Слайд', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить слайд', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image'            => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение', 'wescle' ),
								],
								'image_object_fit' => [
									'type'    => 'select',
									'label'   => esc_html__( 'Режим заполнения', 'wescle' ) . ' (object-fit)',
									'default' => 'cover',
									'choices' => [
										'cover'   => 'cover',
										'contain' => 'contain',
									],
								],
								'title'            => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'             => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							]
						],
						'home_information_title2'                => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок', 'wescle' ) . ' 2',
						],
						'home_information_text2'                 => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ) . ' 2',
						],
						'home_information_button2_label'         => [
							'type'  => 'text',
							'label' => esc_html__( 'Надпись на кнопке', 'wescle' ),
						],
						'home_information_button2_url'           => [
							'type'  => 'text',
							'label' => esc_html__( 'URL', 'wescle' ),
						],
						'home_information_button2_target_blank'  => [
							'type'    => 'checkbox',
							'default' => false,
							'label'   => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
						],
						'home_information_settings_info'         => home_slider_settings_info(),
						'home_information_settings_speed'        => home_slider_settings_speed( 'slider', 5 ),
						'home_information_settings_arrow'        => home_slider_settings_arrow(),
						'home_information_settings_arrow_mobile' => home_slider_settings_arrow_mobile(),
						'home_information_settings_dots'         => home_slider_settings_dots(),
						'home_information_color_bg_info'         => home_block_color_bg_info(),
						'home_information_color_bg'              => home_block_color_bg(),
						'home_information_color_title'           => home_block_color_title(),
						'home_information_image_bg'              => home_block_image_bg(),
						'home_information_image_bg_fit'          => home_block_image_bg_fit(),
						'home_information_image_bg_tablet'       => home_block_image_bg( 'tablet' ),
						'home_information_image_bg_fit_tablet'   => home_block_image_bg_fit( 'tablet' ),
						'home_information_image_bg_mobile'       => home_block_image_bg( 'mobile' ),
						'home_information_image_bg_fit_mobile'   => home_block_image_bg_fit( 'mobile' ),
						'home_information_demo_info'             => home_block_demo_info( 'about' ),
					]
				],

				'home_team'        => [
					'title'    => __( 'Блок "Команда"', 'wescle' ),
					'controls' => [
						'home_team_preview'               => home_block_preview_img( 'block-team' ),
						'home_team_enabled'               => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_team_id_block'              => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_team_title'                 => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .team .container'
						],
						'home_team_title_type'            => header_title_type_block(),
						'home_team_text'                  => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_team_items'                 => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Люди в команде', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Человек', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image'        => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение', 'wescle' ),
								],
								'title'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Имя', 'wescle' ),
								],
								'position'     => [
									'type'  => 'text',
									'label' => esc_html__( 'Должность', 'wescle' ),
								],
								'text'         => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Описание', 'wescle' ),
								],
								'email'        => [
									'type'  => 'email',
									'label' => esc_html__( 'Email', 'wescle' ),
								],
								'tel'          => [
									'type'  => 'tel',
									'label' => esc_html__( 'Телефон', 'wescle' ),
								],
								'link_vk'      => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка на профиль Vkontakte', 'wescle' ),
								],
								'link_fb'      => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка на профиль Facebook', 'wescle' ),
								],
								'link_inst'    => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка на профиль Instagram', 'wescle' ),
								],
								'link_twitter' => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка на профиль Twitter', 'wescle' ),
								],
							]
						],
						'home_team_settings_info'         => home_slider_settings_info(),
						'home_team_settings_count'        => home_slider_settings_count( 4, 6 ),
						'home_team_settings_speed'        => home_slider_settings_speed(),
						'home_team_settings_arrow'        => home_slider_settings_arrow(),
						'home_team_settings_arrow_mobile' => home_slider_settings_arrow_mobile(),
						'home_team_settings_dots'         => home_slider_settings_dots(),
						'home_team_color_bg_info'         => home_block_color_bg_info(),
						'home_team_color_bg'              => home_block_color_bg(),
						'home_team_color_title'           => home_block_color_title(),
						'home_team_image_bg'              => home_block_image_bg(),
						'home_team_image_bg_fit'          => home_block_image_bg_fit(),
						'home_team_image_bg_tablet'       => home_block_image_bg( 'tablet' ),
						'home_team_image_bg_fit_tablet'   => home_block_image_bg_fit( 'tablet' ),
						'home_team_image_bg_mobile'       => home_block_image_bg( 'mobile' ),
						'home_team_image_bg_fit_mobile'   => home_block_image_bg_fit( 'mobile' ),
						'home_team_demo_info'             => home_block_demo_info( 'team' ),
					]
				],
				'info_plus_banner' => [
					'title'    => __( 'Блок "Информация с баннером"', 'wescle' ),
					'controls' => [
						'info_plus_banner_preview'             => home_block_preview_img( 'block-information-banner' ),
						'info_plus_banner_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'info_plus_banner_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'info_plus_banner_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .about-us .container'
						],
						'info_plus_banner_title_type'          => header_title_type_block(),
						'info_plus_banner_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'info_plus_banner_image'               => [
							'type'    => 'image',
							'label'   => esc_html__( 'Изображение', 'wescle' ),
							'choices' => array(
								'save_as' => 'id'
							),
						],
						'info_plus_banner_color_bg_info'       => home_block_color_bg_info(),
						'info_plus_banner_color_bg'            => home_block_color_bg(),
						'info_plus_banner_color_title'         => home_block_color_title(),
						'info_plus_banner_image_bg'            => home_block_image_bg(),
						'info_plus_banner_image_bg_fit'        => home_block_image_bg_fit(),
						'info_plus_banner_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'info_plus_banner_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'info_plus_banner_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'info_plus_banner_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'info_plus_banner_demo_info'           => home_block_demo_info( 'information-banner' ),
					]
				],
				'home_team_static' => [
					'title'    => __( 'Блок "Команда 2"', 'wescle' ),
					'controls' => [
						'home_team_static_preview'             => home_block_preview_img( 'block-team2' ),
						'home_team_static_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_team_static_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_team_static_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .the-team .container'
						],
						'home_team_static_title_type'          => header_title_type_block(),
						'home_team_static_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_team_static_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Люди в команде', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Человек', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image'    => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение', 'wescle' ),
								],
								'title'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Имя', 'wescle' ),
								],
								'position' => [
									'type'  => 'text',
									'label' => esc_html__( 'Должность', 'wescle' ),
								],
								'text'     => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Описание', 'wescle' ),
								],
							]
						],
						'home_team_static_color_bg_info'       => home_block_color_bg_info(),
						'home_team_static_color_bg'            => home_block_color_bg(),
						'home_team_static_color_title'         => home_block_color_title(),
						'home_team_static_image_bg'            => home_block_image_bg(),
						'home_team_static_image_bg_fit'        => home_block_image_bg_fit(),
						'home_team_static_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_team_static_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_team_static_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_team_static_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_team_static_demo_info'           => home_block_demo_info( 'team2' ),
					]
				],
				'home_team_cpt'    => [
					'title'    => __( 'Блок "Команда 3"', 'wescle' ),
					'controls' => [
						'home_team_cpt_preview'      => home_block_preview_img( 'block-team3' ),
						'home_team_cpt_enabled'      => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_team_cpt_enabled_home' => home_block_enabled(),
						'home_team_cpt_info'         => [
							'type'    => Helper::get_posts( array( 'post_type' => 'team_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Команда" успешно добавлена. Чтобы появился список людей для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Команда"</a>', 'wescle' ), admin_url( '/edit.php?post_type=team_wescle' ) ) . '</div>',
						],
						'home_team_cpt_info2'        => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Члены команды созданы, как Custom Post Type. Чтобы добавить человека необходимо перейти в <a href="%s" target="_blank">раздел "Команда"</a> и добавить нового, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=team_wescle' ) ) . '</div>',
						],
						'home_team_cpt_info3'        => [
							'type'    => $page_template_teams ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу c командами, для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Teams".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_team_cpt_id_block'     => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_team_cpt_title'        => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .about-team .container'
						],
						'home_team_cpt_title_type'   => header_title_type_block(),
						'home_team_cpt_text'         => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_team_cpt_posts'        => [
							'type'        => 'select',
							'label'       => esc_html__( 'Выберите людей', 'wescle' ),
							'default'     => 0,
							'multiple'    => 999,
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => 'team_wescle',
							) ),
						],
						'home_team_cpt_button_label' => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись на кнопке "Написать"', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_team_cpt_button_label' )
						],
						'home_team_cpt_cf7'          => cf7_type_block( $label_select, esc_html__( 'Выберите форму CF7', 'wescle' ), 'home_team_cpt' ),

						'home_team_cpt_color_bg_info'       => home_block_color_bg_info(),
						'home_team_cpt_color_bg'            => home_block_color_bg(),
						'home_team_cpt_color_title'         => home_block_color_title(),
						'home_team_cpt_image_bg'            => home_block_image_bg(),
						'home_team_cpt_image_bg_fit'        => home_block_image_bg_fit(),
						'home_team_cpt_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_team_cpt_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_team_cpt_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_team_cpt_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_payments'    => [
					'title'    => __( 'Блок "Способы оплаты"', 'wescle' ),
					'controls' => [
						'home_payments_preview'             => home_block_preview_img( 'block-payments-method' ),
						'home_payments_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_payments_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_payments_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .payment-methods .container'
						],
						'home_payments_title_type'          => header_title_type_block(),
						'home_payments_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_payments_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Методы оплаты', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Метод оплаты', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_bg'    => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение на фоне', 'wescle' ),
								],
								'image'       => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение', 'wescle' ),
								],
								'title'       => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'        => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Описание', 'wescle' ),
								],
								'url'         => [
									'type'  => 'text',
									'label' => esc_html__( 'URL', 'wescle' ),
								],
								'color_title' => [
									'type'    => 'color',
									'label'   => esc_html__( 'Цвет заголовка', 'wescle' ),
									'choices' => [
										'alpha' => true,
									],
								],
								'color_text'  => [
									'type'    => 'color',
									'label'   => esc_html__( 'Цвет текста', 'wescle' ),
									'choices' => [
										'alpha' => true,
									],
								],
								'color_bg'    => [
									'type'    => 'color',
									'label'   => esc_html__( 'Цвет фона', 'wescle' ),
									'choices' => [
										'alpha' => true,
									],
								],
							]
						],
						'home_payments_count_slide'         => [
							'type'    => 'select',
							'label'   => esc_html__( 'Количество слайдов', 'wescle' ),
							'default' => '3',
							'choices' => [
								'2' => 2,
								'3' => 3,
								'4' => 4,
								'5' => 5,
							],
						],
						'home_payments_autoplay'            => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить автоматическое переключение слайдов?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_payments_speed'               => [
							'type'            => 'slider',
							'label'           => esc_html__( 'Скорость переключения слайдов, сек', 'wescle' ),
							'default'         => 6,
							'choices'         => [
								'min'  => 1,
								'max'  => 20,
								'step' => 1,
							],
							'active_callback' => [
								[
									'setting'  => 'home_payments_autoplay',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'home_payments_color_bg_info'       => home_block_color_bg_info(),
						'home_payments_color_bg'            => home_block_color_bg(),
						'home_payments_color_title'         => home_block_color_title(),
						'home_payments_image_bg'            => home_block_image_bg(),
						'home_payments_image_bg_fit'        => home_block_image_bg_fit(),
						'home_payments_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_payments_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_payments_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_payments_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'home_performance' => [
					'title'    => __( 'Блок "Показатели"', 'wescle' ),
					'controls' => [
						'home_performance_preview'             => home_block_preview_img( 'block-indicators' ),
						'home_performance_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_performance_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_performance_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .performance .container'
						],
						'home_performance_title_type'          => header_title_type_block(),
						'home_performance_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_performance_button_label'        => [
							'type'  => 'text',
							'label' => esc_html__( 'Надпись на кнопке', 'wescle' ),
						],
						'home_performance_button_url'          => [
							'type'  => 'text',
							'label' => esc_html__( 'URL', 'wescle' ),
						],
						'home_performance_button_text'         => [
							'type'  => 'text',
							'label' => esc_html__( 'Текст возле кнопки', 'wescle' ),
						],
						'home_performance_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блоки с текстом', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image' => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение', 'wescle' ),
								],
								'title' => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'  => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Описание', 'wescle' ),
								],
							]
						],
						'home_performance_items2'              => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блоки с показателями', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image' => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение', 'wescle' ),
								],
								'title' => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'  => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Описание', 'wescle' ),
								],
							]
						],
						'home_performance_image_maxheight'     => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Max-height для блока с изображением', 'wescle' ),
							'default' => 40,
							'choices' => [
								'min'  => 30,
								'max'  => 150,
								'step' => 10,
							],
						],
						'home_performance_color_bg_info'       => home_block_color_bg_info(),
						'home_performance_color_bg'            => home_block_color_bg(),
						'home_performance_color_title'         => home_block_color_title(),
						'home_performance_image_bg'            => home_block_image_bg(),
						'home_performance_image_bg_fit'        => home_block_image_bg_fit(),
						'home_performance_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_performance_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_performance_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_performance_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_what_site' => [
					'title'    => __( 'Блок "Какой сайт"', 'wescle' ),
					'controls' => [
						'home_what_site_preview'               => home_block_preview_img( 'block-which-website' ),
						'home_what_site_enabled'               => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_what_site_id_block'              => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_what_site_title'                 => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .what-site .container'
						],
						'home_what_site_title_type'            => header_title_type_block(),
						'home_what_site_text'                  => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_what_site_items'                 => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блоки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить блок', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id'    => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => [
										'save_as' => 'id',
									],
								],
								'title'       => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'        => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
								'button_text' => [
									'type'  => 'text',
									'label' => esc_html__( 'Текст кнопки', 'wescle' ),
								],
								'button_url'  => [
									'type'  => 'url',
									'label' => esc_html__( 'URL кнопки', 'wescle' ),
								],
								'link_text'   => [
									'type'  => 'text',
									'label' => esc_html__( 'Текст ссылки', 'wescle' ),
								],
								'link_url'    => [
									'type'  => 'url',
									'label' => esc_html__( 'URL ссылки', 'wescle' ),
								]
							]
						],
						'home_what_site_settings_info'         => home_slider_settings_info(),
						'home_what_site_settings_count'        => home_slider_settings_count( 4, 6 ),
						'home_what_site_settings_speed'        => home_slider_settings_speed(),
						'home_what_site_settings_arrow'        => home_slider_settings_arrow(),
						'home_what_site_settings_arrow_mobile' => home_slider_settings_arrow_mobile(),
						'home_what_site_settings_dots'         => home_slider_settings_dots(),
						'home_what_site_color_info'            => home_block_color_bg_info(),
						'home_what_site_color_bg'              => home_block_color_bg(),
						'home_what_site_color_title'           => home_block_color_title(),
						'home_what_site_image_bg'              => home_block_image_bg(),
						'home_what_site_image_bg_fit'          => home_block_image_bg_fit(),
						'home_what_site_image_bg_tablet'       => home_block_image_bg( 'tablet' ),
						'home_what_site_image_bg_fit_tablet'   => home_block_image_bg_fit( 'tablet' ),
						'home_what_site_image_bg_mobile'       => home_block_image_bg( 'mobile' ),
						'home_what_site_image_bg_fit_mobile'   => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_why_site' => [
					'title'    => __( 'Блок "Почему WordPress"', 'wescle' ),
					'controls' => [
						'home_why_preview'               => home_block_preview_img( 'block-why-wordpress' ),
						'home_why_enabled'               => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_why_id_block'              => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_why_title'                 => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .why .container'
						],
						'home_why_title_type'            => header_title_type_block(),
						'home_why_text'                  => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_why_items_images'          => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блок c изображениями', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить блок', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id' => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => [
										'save_as' => 'id',
									],
								]
							],
							'choices'      => [
								'limit'       => 3,
								'limit_label' => esc_html__( 'изображения', 'wescle' )
							],
						],
						'home_why_title2'                => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок для блоков', 'wescle' ),
						],
						'home_why_items'                 => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блоки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить блок', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id' => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => [
										'save_as' => 'id',
									],
								],
								'title'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
							]
						],
						'home_why_title_slider'          => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок для слайдера', 'wescle' ),
						],
						'home_why_slider_images'         => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Изображения слайдера', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Изображение', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id' => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => [
										'save_as' => 'id',
									],
								]
							]
						],
						'home_why_settings_info'         => home_slider_settings_info(),
						'home_why_settings_count'        => home_slider_settings_count( 8, 8 ),
						'home_why_settings_speed'        => home_slider_settings_speed(),
						'home_why_settings_arrow'        => home_slider_settings_arrow(),
						'home_why_settings_arrow_mobile' => home_slider_settings_arrow_mobile(),
						'home_why_settings_dots'         => home_slider_settings_dots(),
						'home_why_color_info'            => home_block_color_bg_info(),
						'home_why_color_bg'              => home_block_color_bg(),
						'home_why_color_title'           => home_block_color_title(),
						'home_why_image_bg'              => home_block_image_bg(),
						'home_why_image_bg_fit'          => home_block_image_bg_fit(),
						'home_why_image_bg_tablet'       => home_block_image_bg( 'tablet' ),
						'home_why_image_bg_fit_tablet'   => home_block_image_bg_fit( 'tablet' ),
						'home_why_image_bg_mobile'       => home_block_image_bg( 'mobile' ),
						'home_why_image_bg_fit_mobile'   => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_benefit' => [
					'title'    => __( 'Блок "Экономия"', 'wescle' ),
					'controls' => [
						'home_benefit_preview'             => home_block_preview_img( 'block-economy' ),
						'home_benefit_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_benefit_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_benefit_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .benefit .container'
						],
						'home_benefit_title_type'          => header_title_type_block(),
						'home_benefit_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_benefit_title2'              => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок для цены с экономией', 'wescle' ),
						],
						'home_benefit_price1'              => [
							'type'  => 'text',
							'label' => esc_html__( 'Цена экономии', 'wescle' ),
						],
						'home_benefit_price2'              => [
							'type'  => 'text',
							'label' => esc_html__( 'Старая цена', 'wescle' ),
						],
						'home_benefit_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блоки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить блок', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id' => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => [
										'save_as' => 'id',
									],
								],
								'title'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'     => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
								'price'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Цена', 'wescle' ),
								],
							]
						],
						'home_benefit_color_info'          => home_block_color_bg_info(),
						'home_benefit_color_bg'            => home_block_color_bg(),
						'home_benefit_color_title'         => home_block_color_title(),
						'home_benefit_image_bg'            => home_block_image_bg(),
						'home_benefit_image_bg_fit'        => home_block_image_bg_fit(),
						'home_benefit_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_benefit_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_benefit_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_benefit_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_10'     => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_10' ),
					'controls' => [
						'home_tab_10_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_events'     => [
					'title'    => __( 'Блок "Мероприятия"', 'wescle' ),
					'controls' => [
						'home_events_preview'      => home_block_preview_img( 'block-events' ),
						'home_events_enabled'      => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_events_enabled_home' => home_block_enabled(),
						'home_events_info'         => [
							'type'    => Helper::get_posts( array( 'post_type' => 'event_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Мероприятия" успешно добавлена. Чтобы появился список мероприятий для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Мероприятия"</a>', 'wescle' ), admin_url( '/edit.php?post_type=event_wescle' ) ) . '</div>',
						],
						'home_events_info2'        => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Мероприятия созданы, как Custom Post Type. Чтобы добавить мероприятие необходимо перейти в <a href="%s" target="_blank">раздел "Мероприятия"</a> и добавить новое, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=event_wescle' ) ) . '</div>',
						],
						'home_events_info3'        => [
							'type'    => $page_template_event ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу "Мероприятия", для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Events".', 'wescle' ), admin_url( '/post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_events_info4'        => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . __( 'В секции на сайте будут отображены будущие мероприятия по дате и времени. Прошедшие мероприятия будут отключаться с выдачи на главной, но при этом удаляться они не будут и ссылка будет доступна.', 'wescle' ) . '</div>',
						],

						'home_events_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_events_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .events-block .container'
						],
						'home_events_title_type'          => header_title_type_block(),
						'home_events_text'                => [
							'type'    => 'editor',
							'label'   => esc_html__( 'Текст', 'wescle' ),
							'default' => '',
						],
						'home_events_link_id'             => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка на все мероприятия', 'wescle' ),
							'default'     => get_theme_mod( 'home_events_link_id', 0 ),
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							), true ),
						],
						'home_events_link_text'           => [
							'type'    => 'text',
							'label'   => esc_html__( 'Текст для надписи "Все мероприятия"', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_events_link_text' ),
						],
						'home_events_posts'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Мероприятия', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Мероприятие', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить мероприятие', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'post_id' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Выберите мероприятие', 'wescle' ),
									'default'     => 0,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type'  => [ 'event_wescle' ],
										'meta_query' => [
											[
												'key'     => 'event_date',
												'value'   => current_time( 'Ymd' ),
												'compare' => '>=',
												'type'    => 'NUMERIC'
											]
										]
									), true ),
								]
							]
						],
						'home_events_more_text'           => [
							'type'        => 'text',
							'label'       => esc_html__( 'Текст для кнопки "Еще"', 'wescle' ),
							'description' => esc_html__( 'оставьте поле пустым, если не нужно выводить кнопку', 'wescle' ),
							'default'     => Helper::get_default_theme_data( 'home_events_more_text' ),
						],
						'home_events_color_bg_info'       => home_block_color_bg_info(),
						'home_events_color_bg'            => home_block_color_bg(),
						'home_events_color_title'         => home_block_color_title(),
						'home_events_image_bg'            => home_block_image_bg(),
						'home_events_image_bg_fit'        => home_block_image_bg_fit(),
						'home_events_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_events_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_events_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_events_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'home_programs'   => [
					'title'    => __( 'Блок "Программа / Расписание"', 'wescle' ),
					'controls' => [
						'home_programs_preview'        => home_block_preview_img( 'block-program' ),
						'home_programs_enabled'        => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_programs_enabled_home'   => home_block_enabled(),
						'home_programs_info'           => [
							'type'    => Helper::get_posts( array( 'post_type' => 'program_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Программа/Расписание" успешно добавлена. Чтобы появился список программ для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Программы"</a>', 'wescle' ), admin_url( '/edit.php?post_type=program_wescle' ) ) . '</div>',
						],
						'home_programs_info2'          => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Программы созданы, как Custom Post Type. Чтобы добавить программу необходимо перейти в <a href="%s" target="_blank">раздел "Программы и модули"</a> и добавить новую, затем можно будет выбрать ее здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=program_wescle' ) ) . '</div>',
						],
						'home_programs_info3'          => [
							'type'    => $page_template_programs ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу "Программы и модули", для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Programs and Modules".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_programs_id_block'       => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_programs_title'          => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .schedule-block .container'
						],
						'home_programs_title_type'     => header_title_type_block(),
						'home_programs_text'           => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_programs_icon1_title'    => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок иконки 1', 'wescle' ),
						],
						'home_programs_icon1_subtitle' => [
							'type'  => 'text',
							'label' => esc_html__( 'Подзаголовок иконки 1', 'wescle' ),
						],
						'home_programs_icon2_title'    => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок иконки 2', 'wescle' ),
						],
						'home_programs_icon2_subtitle' => [
							'type'  => 'editor',
							'label' => esc_html__( 'Подзаголовок иконки 2', 'wescle' ),
						],
						'home_programs_icon3_title'    => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок иконки 3', 'wescle' ),
						],
						'home_programs_icon3_subtitle' => [
							'type'  => 'text',
							'label' => esc_html__( 'Подзаголовок иконки 3', 'wescle' ),
						],
						'home_programs_icon4_title'    => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок иконки 4', 'wescle' ),
						],
						'home_programs_icon4_subtitle' => [
							'type'  => 'text',
							'label' => esc_html__( 'Подзаголовок иконки 4', 'wescle' ),
						],
						'home_programs_posts'          => [
							'type'        => 'select',
							'label'       => esc_html__( 'Выберите программы', 'wescle' ),
							'default'     => [],
							'multiple'    => 999,
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'program_wescle' ]
							) ),
						],
						'home_programs_label_open'     => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись для разворачивания блока', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_programs_label_open' )
						],
						'home_programs_label_close'    => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись для сворачивания блока', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_programs_label_close' )
						],
						'home_programs_height'         => [
							'type'    => 'number',
							'label'   => esc_html__( 'Высота видимой части', 'wescle' ),
							'default' => 550,
						],
						'home_programs_color_bg_info'  => home_block_color_bg_info(),
						'home_programs_color_bg'       => home_block_color_bg(),
						'home_programs_color_title'    => home_block_color_title(),
					]
				],
				'home_videos'     => [
					'title'    => __( 'Блок "Видео карусель"', 'wescle' ),
					'controls' => [
						'home_videos_preview'               => home_block_preview_img( 'block-video-carousel' ),
						'home_videos_enabled'               => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_videos_info'                  => [
							'type'    => Helper::get_posts( array( 'post_type' => 'video_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Видео" успешно добавлена. Чтобы появился список видео для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Видео"</a>', 'wescle' ), admin_url( '/edit.php?post_type=video_wescle' ) ) . '</div>',
						],
						'home_videos_info2'                 => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Видео созданы, как Custom Post Type. Чтобы добавить видео необходимо перейти в <a href="%s" target="_blank">раздел "Видео"</a> и добавить новое, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=video_wescle' ) ) . '</div>',
						],
						'home_videos_id_block'              => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_videos_title'                 => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .videos-slider .container'
						],
						'home_videos_title_type'            => header_title_type_block(),
						'home_videos_text'                  => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_videos_posts'                 => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Видео', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Видео', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить видео', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'post_id' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Выберите видео', 'wescle' ),
									'default'     => 0,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type' => [ 'video_wescle' ],
									), true ),
								]
							]
						],
						'home_videos_settings_info'         => home_slider_settings_info(),
						'home_videos_settings_count'        => home_slider_settings_count(),
						'home_videos_settings_speed'        => home_slider_settings_speed(),
						'home_videos_settings_arrow'        => home_slider_settings_arrow(),
						'home_videos_settings_arrow_mobile' => home_slider_settings_arrow_mobile(),
						'home_videos_settings_dots'         => home_slider_settings_dots(),
						'home_videos_color_bg_info'         => home_block_color_bg_info(),
						'home_videos_color_bg'              => home_block_color_bg(),
						'home_videos_color_title'           => home_block_color_title(),
						'home_videos_image_bg'              => home_block_image_bg(),
						'home_videos_image_bg_fit'          => home_block_image_bg_fit(),
						'home_videos_image_bg_tablet'       => home_block_image_bg( 'tablet' ),
						'home_videos_image_bg_fit_tablet'   => home_block_image_bg_fit( 'tablet' ),
						'home_videos_image_bg_mobile'       => home_block_image_bg( 'mobile' ),
						'home_videos_image_bg_fit_mobile'   => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'home_videos2'    => [
					'title'    => __( 'Блок "Видео"', 'wescle' ),
					'controls' => [
						'home_videos2_preview'             => home_block_preview_img( 'block-video' ),
						'home_videos2_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_videos2_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'video_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Видео" успешно добавлена. Чтобы появился список видео для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Видео"</a>', 'wescle' ), admin_url( '/edit.php?post_type=video_wescle' ) ) . '</div>',
						],
						'home_videos2_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Видео созданы, как Custom Post Type. Чтобы добавить видео необходимо перейти в <a href="%s" target="_blank">раздел "Видео"</a> и добавить новое, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=video_wescle' ) ) . '</div>',
						],
						'home_videos2_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_videos2_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .video-section .container'
						],
						'home_videos2_title_type'          => header_title_type_block(),
						'home_videos2_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_videos2_posts'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Видео', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Видео', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить видео', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'post_id' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Выберите видео', 'wescle' ),
									'default'     => 0,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type' => [ 'video_wescle' ],
									), true ),
								]
							]
						],
						'home_videos2_color_bg_info'       => home_block_color_bg_info(),
						'home_videos2_color_bg'            => home_block_color_bg(),
						'home_videos2_color_title'         => home_block_color_title(),
						'home_videos2_image_bg'            => home_block_image_bg(),
						'home_videos2_image_bg_fit'        => home_block_image_bg_fit(),
						'home_videos2_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_videos2_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_videos2_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_videos2_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'home_videos_max' => [
					'title'    => __( 'Блок "Видео MAX"', 'wescle' ),
					'controls' => [
						'home_videos_max_preview'             => home_block_preview_img( 'block-video-max' ),
						'home_videos_max_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_videos_max_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'video_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Видео" успешно добавлена. Чтобы появился список видео для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Видео"</a>', 'wescle' ), admin_url( '/edit.php?post_type=video_wescle' ) ) . '</div>',
						],
						'home_videos_max_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Видео созданы, как Custom Post Type. Чтобы добавить видео необходимо перейти в <a href="%s" target="_blank">раздел "Видео"</a> и добавить новое, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=video_wescle' ) ) . '</div>',
						],
						'home_videos_max_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_videos_max_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .video-max .container'
						],
						'home_videos_max_title_type'          => header_title_type_block(),
						'home_videos_max_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_videos_max_image'               => [
							'type'    => 'image',
							'label'   => esc_html__( 'Превью фото', 'wescle' ),
							'choices' => array(
								'save_as' => 'id'
							),
						],
						'home_videos_max_button_title'        => [
							'type'  => 'text',
							'label' => esc_html__( 'Надпись на кнопке', 'wescle' ),
						],
						'home_videos_max_link_id'             => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка', 'wescle' ),
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							), true ),
						],
						'home_videos_max_button_url'          => [
							'type'  => 'text',
							'label' => esc_html__( 'или пропишите кастомный URL', 'wescle' ),
						],
						'home_videos_max_target_blank'        => [
							'type'  => 'checkbox',
							'label' => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
						],
						'home_videos_max_posts'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Видео', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Видео', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить видео', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'post_id' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Выберите видео', 'wescle' ),
									'default'     => 0,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type' => [ 'video_wescle' ],
									), true ),
								]
							]
						],
						'home_videos_max_color_bg_info'       => home_block_color_bg_info(),
						'home_videos_max_color_bg'            => home_block_color_bg(),
						'home_videos_max_color_title'         => home_block_color_title(),
						'home_videos_max_image_bg'            => home_block_image_bg(),
						'home_videos_max_image_bg_fit'        => home_block_image_bg_fit(),
						'home_videos_max_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_videos_max_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_videos_max_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_videos_max_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_stories' => [
					'title'    => __( 'Блок "Сторисы"', 'wescle' ),
					'controls' => [
						'home_stories_preview'             => home_block_preview_img( 'block-stories' ),
						'home_stories_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_stories_enabled_home'        => home_block_enabled(),
						'home_stories_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'stories_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Сторисы" успешно добавлена. Чтобы появился список сторис, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Сторисы"</a>', 'wescle' ), admin_url( '/edit.php?post_type=stories_wescle' ) ) . '</div>',
						],
						'home_stories_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Сторисы созданы, как Custom Post Type. Чтобы добавить сторис необходимо перейти в <a href="%s" target="_blank">раздел "Сторисы"</a> и добавить новый.', 'wescle' ), admin_url( '/edit.php?post_type=stories_wescle' ) ) . '</div>',
						],
						'home_stories_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_stories_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .stories-section .container',
							//'selector_key' => '',
						],
						'home_stories_title_type'          => header_title_type_block(),
						'home_stories_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_stories_image'               => [
							'type'    => 'image',
							'label'   => esc_html__( 'Изображение баннера', 'wescle' ),
							'choices' => array(
								'save_as' => 'id'
							),
						],
						'home_stories_type'                => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Вид миниатюр', 'wescle' ),
							'default' => '1',
							'choices' => array(
								'1' => __( 'Круглые', 'wescle' ),
								'2' => __( 'Вертикальные', 'wescle' ),
							),
						],
						'home_stories_color_info'          => home_block_color_bg_info(),
						'home_stories_color_bg'            => home_block_color_bg(),
						'home_stories_color_title'         => home_block_color_title(),
						'home_stories_image_bg'            => home_block_image_bg(),
						'home_stories_image_bg_fit'        => home_block_image_bg_fit(),
						'home_stories_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_stories_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_stories_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_stories_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],


				'home_tab_6'       => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_6' ),
					'controls' => [
						'home_tab_6_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_sta'         => [
					'title'    => __( 'Блок "СТА"', 'wescle' ),
					'controls' => [
						'home_sta_preview'             => home_block_preview_img( 'block-cta' ),
						'home_sta_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_sta_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_sta_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .sta-1 .container'
						],
						'home_sta_title_type'          => header_title_type_block(),
						'home_sta_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Описание', 'wescle' ),
						],
						'home_sta_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Кнопки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Кнопка', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить кнопку', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'title'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Название', 'wescle' ),
								],
								'url'          => [
									'type'        => 'url',
									'label'       => esc_html__( 'URL', 'wescle' ),
									'default'     => '#modal-call',
									'description' => __( '* чтобы кнопку сделать вызовом попапа звонка, пропишите <code>#modal-call</code>', 'wescle' ),
								],
								'target_blank' => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
								]
							],
							'choices'      => [
								'limit'       => 2,
								'limit_label' => esc_html__( 'кнопки', 'wescle' )
							],
						],
						'home_sta_title_color'         => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет заголовка', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta_text_color'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta_bg_color'            => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона', 'wescle' ),
							'default' => '#0088cc',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta_bg_image'            => [
							'type'    => 'image',
							'label'   => esc_html__( 'Изображение фона', 'wescle' ),
							'choices' => array(
								'save_as' => 'id'
							),
						],
						'home_sta_color_bg_info'       => home_block_color_bg_info(),
						'home_sta_color_bg'            => home_block_color_bg(),
						'home_sta_image_bg'            => home_block_image_bg(),
						'home_sta_image_bg_fit'        => home_block_image_bg_fit(),
						'home_sta_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_sta_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_sta_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_sta_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_sta_demo_info'           => home_block_demo_info( 'sta' ),
					]
				],
				'home_sta2'        => [
					'title'    => __( 'Блок "Дополнительный СТА"', 'wescle' ),
					'controls' => [
						'home_sta2_preview'             => home_block_preview_img( 'block-cta' ),
						'home_sta2_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_sta2_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_sta2_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .sta-2 .container'
						],
						'home_sta2_title_type'          => header_title_type_block(),
						'home_sta2_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Описание', 'wescle' ),
						],
						'home_sta2_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Кнопки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Кнопка', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить кнопку', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'title'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Название', 'wescle' ),
								],
								'url'          => [
									'type'        => 'url',
									'label'       => esc_html__( 'URL', 'wescle' ),
									'default'     => '#modal-call',
									'description' => __( '* чтобы кнопку сделать вызовом попапа звонка, пропишите <code>#modal-call</code>', 'wescle' ),
								],
								'target_blank' => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
								]
							],
							'choices'      => [
								'limit'       => 2,
								'limit_label' => esc_html__( 'кнопки', 'wescle' )
							],
						],
						'home_sta2_title_color'         => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет заголовка', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta2_text_color'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta2_bg_color'            => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона', 'wescle' ),
							'default' => '#0088cc',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta2_bg_image'            => [
							'type'    => 'image',
							'label'   => esc_html__( 'Изображение фона', 'wescle' ),
							'choices' => array(
								'save_as' => 'id'
							),
						],
						'home_sta2_color_bg_info'       => home_block_color_bg_info(),
						'home_sta2_color_bg'            => home_block_color_bg(),
						'home_sta2_image_bg'            => home_block_image_bg(),
						'home_sta2_image_bg_fit'        => home_block_image_bg_fit(),
						'home_sta2_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_sta2_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_sta2_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_sta2_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_sta2_demo_info'           => home_block_demo_info( 'sta', [], 'sta_duplicate' ),
					]
				],
				'home_sta_center'  => [
					'title'    => __( 'Блок "СТА по центру"', 'wescle' ),
					'controls' => [
						'home_sta_center_preview'             => home_block_preview_img( 'block-cta-center' ),
						'home_sta_center_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_sta_center_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_sta_center_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .sta-centered .container'
						],
						'home_sta_center_title_type'          => header_title_type_block(),
						'home_sta_center_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Описание', 'wescle' ),
						],
						'home_sta_center_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Кнопки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Кнопка', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить кнопку', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'title'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Название', 'wescle' ),
								],
								'url'          => [
									'type'        => 'url',
									'label'       => esc_html__( 'URL', 'wescle' ),
									'default'     => '#modal-call',
									'description' => __( '* чтобы кнопку сделать вызовом попапа звонка, пропишите <code>#modal-call</code>', 'wescle' ),
								],
								'target_blank' => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
								]
							],
							'choices'      => [
								//'limit'       => 2,
								'limit_label' => esc_html__( 'кнопки', 'wescle' )
							],
						],
						'home_sta_center_title_color'         => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет заголовка', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta_center_text_color'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta_center_bg_color'            => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона', 'wescle' ),
							'default' => '',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta_center_bg_image'            => [
							'type'    => 'image',
							'label'   => esc_html__( 'Изображение фона', 'wescle' ),
							'choices' => array(
								'save_as' => 'id'
							),
						],
						'home_sta_center_color_bg_info'       => home_block_color_bg_info(),
						'home_sta_center_color_bg'            => home_block_color_bg(),
						'home_sta_center_image_bg'            => home_block_image_bg(),
						'home_sta_center_image_bg_fit'        => home_block_image_bg_fit(),
						'home_sta_center_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_sta_center_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_sta_center_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_sta_center_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_sta_center_demo_info'           => home_block_demo_info( 'sta', [], 'sta_center' ),
					]
				],
				'home_sta_minimal' => [
					'title'    => __( 'Блок "СТА минимал"', 'wescle' ),
					'controls' => [
						'home_sta_minimal_preview'             => home_block_preview_img( 'block-cta-minimal' ),
						'home_sta_minimal_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_sta_minimal_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_sta_minimal_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .sta-minimal .container'
						],
						'home_sta_minimal_title_type'          => header_title_type_block(),
						'home_sta_minimal_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Описание', 'wescle' ),
						],
						'home_sta_minimal_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Кнопки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Кнопка', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить кнопку', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'title'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Название', 'wescle' ),
								],
								'url'          => [
									'type'        => 'url',
									'label'       => esc_html__( 'URL', 'wescle' ),
									'default'     => '#modal-call',
									'description' => __( '* чтобы кнопку сделать вызовом попапа звонка, пропишите <code>#modal-call</code>', 'wescle' ),
								],
								'target_blank' => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
								],
								'button_view'  => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Вид кнопки', 'wescle' ),
									'default' => '',
									'choices' => [
										''          => esc_html__( 'без фона', 'wescle' ),
										'bg'        => esc_html__( 'с фоном', 'wescle' ),
										'animation' => esc_html__( 'c анимацией', 'wescle' ),
									]
								]
							],
							'choices'      => [
								'limit'       => 3,
								'limit_label' => esc_html__( 'кнопки', 'wescle' )
							],
						],
						'home_sta_minimal_title_color'         => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет заголовка', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta_minimal_text_color'          => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет текста', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						/*'home_sta_minimal_bg_color'            => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона', 'wescle' ),
							'default' => '',
							'choices' => [
								'alpha' => true,
							],
						],*/
						'home_sta_minimal_bg_image'            => [
							'type'        => 'image',
							'label'       => esc_html__( 'Изображение фона', 'wescle' ),
							'description' => esc_html__( 'по умолчанию используется анимированное изображение SVG', 'wescle' ),
							'choices'     => array(
								'save_as' => 'id'
							),
						],
						'home_sta_minimal_color_1'             => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет иконок 1', 'wescle' ),
							'default' => '',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta_minimal_color_2'             => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет иконок 2', 'wescle' ),
							'default' => '',
							'choices' => [
								'alpha' => true,
							],
						],
						'home_sta_minimal_color_bg_info'       => home_block_color_bg_info(),
						'home_sta_minimal_color_bg'            => home_block_color_bg(),
						'home_sta_minimal_image_bg'            => home_block_image_bg(),
						'home_sta_minimal_image_bg_fit'        => home_block_image_bg_fit(),
						'home_sta_minimal_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_sta_minimal_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_sta_minimal_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_sta_minimal_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_sta_minimal_demo_info'           => home_block_demo_info( 'sta', [], 'sta_minimal' ),
					]
				],

				'home_difference' => [
					'title'    => __( 'Блок "Было - Стало"', 'wescle' ),
					'controls' => [
						'home_difference_preview'             => home_block_preview_img( 'block-before-after' ),
						'home_difference_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_difference_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_difference_title'               => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок', 'wescle' ),
						],
						'home_difference_title_type'          => header_title_type_block(),
						'home_difference_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_difference_before'              => [
							'type'    => 'image',
							'label'   => esc_html__( 'Изображение "До"', 'wescle' ),
							'choices' => [
								'save_as' => 'id',
							],
						],
						'home_difference_after'               => [
							'type'    => 'image',
							'label'   => esc_html__( 'Изображение "После"', 'wescle' ),
							'choices' => [
								'save_as' => 'id',
							],
						],
						'home_difference_position'            => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Позиция разделительной линии, %', 'wescle' ),
							'default' => 50,
							'choices' => [
								'min'  => 0,
								'max'  => 100,
								'step' => 5,
							],
						],
						'home_difference_color_bg_info'       => home_block_color_bg_info(),
						'home_difference_color_bg'            => home_block_color_bg(),
						'home_difference_color_title'         => home_block_color_title(),
						'home_difference_image_bg'            => home_block_image_bg(),
						'home_difference_image_bg_fit'        => home_block_image_bg_fit(),
						'home_difference_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_difference_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_difference_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_difference_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_difference_demo_info'           => home_block_demo_info( 'difference' )
					]
				],
				'home_special'    => [
					'title'    => __( 'Блок "Специальное предложение"', 'wescle' ),
					'controls' => [
						'home_special_preview'             => home_block_preview_img( 'block-special-offer' ),
						'home_special_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_special_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_special_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'default'  => Helper::get_default_theme_data( 'home_special_title' ),
							'selector' => '.home .time-left .container',
						],
						'home_special_title_type'          => header_title_type_block(),
						'home_special_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_special_action_label'        => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок блока с таймером', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_special_action_label' ),
						],
						'home_special_action_type'         => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Тип таймера', 'wescle' ),
							'default' => 'date',
							'choices' => [
								'date'  => esc_html__( 'По дате окончания', 'wescle' ),
								'hours' => esc_html__( 'Окончание через X часов с момента посещения', 'wescle' ),
							]
						],
						'home_special_action_date'         => [
							'type'            => 'date',
							'label'           => esc_html__( 'Дата окончания акции', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'home_special_action_type',
									'operator' => '==',
									'value'    => 'date',
								]
							],
						],
						'home_special_action_hours'        => [
							'type'            => 'number',
							'label'           => esc_html__( 'Через сколько часов окончания акции?', 'wescle' ),
							'default'         => 10,
							'active_callback' => [
								[
									'setting'  => 'home_special_action_type',
									'operator' => '==',
									'value'    => 'hours',
								]
							],
						],
						'home_special_progress_percent'    => [
							'type'    => 'number',
							'label'   => esc_html__( 'Прогресс-бар, сколько процентов?', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_special_progress_percent' ),
						],
						'home_special_progress_label'      => [
							'type'    => 'text',
							'label'   => esc_html__( 'Подпись под прогресс-баром', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_special_progress_label' ),
						],
						'home_special_cf7_info'            => [
							'type'    => class_exists( 'WPCF7_Mail' ) ? '' : 'custom',
							'label'   => esc_html__( 'Выберите форму CF7', 'wescle' ),
							'default' => '<div class="notice notice-warning section-description">' . $notice_cf7 . '</div>',
						],
						'home_special_cf7'                 => cf7_type_block( $label_select, esc_html__( 'Выберите форму CF7', 'wescle' ), 'home_contact' ),
						'home_special_cf7_position'        => [
							'type'    => 'radio',
							'default' => 'left',
							'choices' => [
								'left'  => is_rtl() ? esc_html__( 'Отображать форму справа', 'wescle' ) : esc_html__( 'Отображать форму слева', 'wescle' ),
								'right' => is_rtl() ? esc_html__( 'Отображать форму слева', 'wescle' ) : esc_html__( 'Отображать форму справа', 'wescle' ),
							],
						],
						'home_special_color_bg_info'       => home_block_color_bg_info(),
						'home_special_color_bg'            => home_block_color_bg(),
						'home_special_color_title'         => home_block_color_title(),
						'home_special_image_bg'            => home_block_image_bg(),
						'home_special_image_bg_fit'        => home_block_image_bg_fit(),
						'home_special_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_special_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_special_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_special_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_7'   => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_7' ),
					'controls' => [
						'home_tab_7_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_reviews' => [
					'title'    => __( 'Блок "Отзывы"', 'wescle' ),
					'controls' => [
						'home_reviews_preview'               => home_block_preview_img( 'block-reviews' ),
						'home_reviews_enabled'               => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_reviews_info'                  => [
							'type'    => Helper::get_posts( array( 'post_type' => 'review', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Отзывы" успешно добавлена. Чтобы появились отзывы, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Отзывы"</a>', 'wescle' ), admin_url( '/edit.php?post_type=review' ) ) . '</div>',
						],
						'home_reviews_info3'                 => [
							'type'    => $page_template_reviews ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу c отзывами, для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Reviews".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_reviews_id_block'              => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_reviews_title'                 => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок', 'wescle' ),
							'default' => __( 'Отзывы клиентов', 'wescle' ),
						],
						'home_reviews_title_type'            => header_title_type_block(),
						'home_reviews_link_id'               => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка на все отзывы', 'wescle' ),
							'default'     => '',
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							) ),
						],
						'home_reviews_link_text'             => [
							'type'    => 'text',
							'label'   => esc_html__( 'Текст для надписи "Все отзывы"', 'wescle' ),
							'default' => esc_html__( 'Все отзывы', 'wescle' ),
						],
						'home_reviews_button_text'           => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
							'default' => esc_html__( 'Подробнее', 'wescle' ),
						],
						'home_reviews_posts'                 => [
							'type'        => 'select',
							'label'       => esc_html__( 'Выберите отзывы', 'wescle' ),
							'default'     => [],
							'multiple'    => 999,
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'review' ]
							) ),
						],
						'home_reviews_orderby'               => [
							'type'    => 'select',
							'label'   => esc_html__( 'Сортировка отзывов', 'wescle' ),
							'default' => 'date',
							'choices' => choices_posts_orderby( 'views' ),
						],
						'home_reviews_height'                => [
							'type'    => 'number',
							'label'   => esc_html__( 'Высота содержания отзыва, px', 'wescle' ),
							'default' => 210,
						],
						'home_reviews_settings_info'         => home_slider_settings_info(),
						'home_reviews_settings_speed'        => home_slider_settings_speed(),
						'home_reviews_settings_arrow'        => home_slider_settings_arrow(),
						'home_reviews_settings_arrow_mobile' => home_slider_settings_arrow_mobile(),
						'home_reviews_settings_dots'         => home_slider_settings_dots(),
						'home_reviews_color_bg_info'         => home_block_color_bg_info(),
						'home_reviews_color_bg'              => home_block_color_bg(),
						'home_reviews_color_title'           => home_block_color_title(),
						'home_reviews_image_bg'              => home_block_image_bg(),
						'home_reviews_image_bg_fit'          => home_block_image_bg_fit(),
						'home_reviews_image_bg_tablet'       => home_block_image_bg( 'tablet' ),
						'home_reviews_image_bg_fit_tablet'   => home_block_image_bg_fit( 'tablet' ),
						'home_reviews_image_bg_mobile'       => home_block_image_bg( 'mobile' ),
						'home_reviews_image_bg_fit_mobile'   => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_videoreviews' => [
					'title'    => __( 'Блок "Видео-отзывы"', 'wescle' ),
					'controls' => [
						'home_videoreviews_preview'               => home_block_preview_img( 'block-video-reviews' ),
						'home_videoreviews_enabled'               => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_videoreviews_enabled_home'          => home_block_enabled(),
						'home_videoreviews_info'                  => [
							'type'    => Helper::get_posts( array( 'post_type' => 'videoreview', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Видео-отзывы" успешно добавлена. Чтобы появились отзывы, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Видео-отзывы"</a>', 'wescle' ), admin_url( '/edit.php?post_type=videoreview' ) ) . '</div>',
						],
						'home_videoreviews_info3'                 => [
							'type'    => $page_template_reviews ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу c видео-отзывами, для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Video Reviews".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_videoreviews_id_block'              => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_videoreviews_title'                 => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'default'  => __( 'Отзывы клиентов', 'wescle' ),
							'selector' => '.home .reviews-2 .container'
						],
						'home_videoreviews_title_type'            => header_title_type_block(),
						'home_videoreviews_text'                  => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_videoreviews_link_id'               => [
							'type'        => 'select',
							'label'       => esc_html__( 'Ссылка на все отзывы', 'wescle' ),
							'default'     => '',
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'page' ]
							) ),
						],
						'home_videoreviews_link_text'             => [
							'type'    => 'text',
							'label'   => esc_html__( 'Текст для надписи "Все отзывы"', 'wescle' ),
							'default' => esc_html__( 'Все отзывы', 'wescle' ),
						],
						'home_videoreviews_posts'                 => [
							'type'        => 'select',
							'label'       => esc_html__( 'Выберите отзывы', 'wescle' ),
							'default'     => [],
							'multiple'    => 999,
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'videoreview' ]
							) ),
						],
						'home_videoreviews_orderby'               => [
							'type'    => 'select',
							'label'   => esc_html__( 'Сортировка отзывов', 'wescle' ),
							'default' => 'date',
							'choices' => choices_posts_orderby( 'views' ),
						],
						'home_videoreviews_settings_info'         => home_slider_settings_info(),
						'home_videoreviews_settings_slider'       => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать слайдер?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off()
						],
						'home_videoreviews_settings_speed'        => home_slider_settings_speed( 'slider', '8', active_field_for_custom( 'home_videoreviews_settings_slider' ) ),
						'home_videoreviews_settings_arrow'        => home_slider_settings_arrow( true, 'switch', active_field_for_custom( 'home_videoreviews_settings_slider' ) ),
						'home_videoreviews_settings_arrow_mobile' => home_slider_settings_arrow_mobile( true, 'switch', active_field_for_custom( 'home_videoreviews_settings_slider' ) ),
						'home_videoreviews_settings_dots'         => home_slider_settings_dots( false, 'switch', active_field_for_custom( 'home_videoreviews_settings_slider' ) ),
						'home_videoreviews_color_bg_info'         => home_block_color_bg_info(),
						'home_videoreviews_color_bg'              => home_block_color_bg(),
						'home_videoreviews_color_title'           => home_block_color_title(),
						'home_videoreviews_image_bg'              => home_block_image_bg(),
						'home_videoreviews_image_bg_fit'          => home_block_image_bg_fit(),
						'home_videoreviews_image_bg_tablet'       => home_block_image_bg( 'tablet' ),
						'home_videoreviews_image_bg_fit_tablet'   => home_block_image_bg_fit( 'tablet' ),
						'home_videoreviews_image_bg_mobile'       => home_block_image_bg( 'mobile' ),
						'home_videoreviews_image_bg_fit_mobile'   => home_block_image_bg_fit( 'mobile' ),
					]
				],


				'home_tab_8' => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_8' ),
					'controls' => [
						'home_tab_8_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_faq'   => [
					'title'    => __( 'Блок "FAQ"', 'wescle' ),
					'controls' => [
						'home_faq_preview'             => home_block_preview_img( 'block-faq' ),
						'home_faq_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_faq_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_faq_title'               => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок', 'wescle' ),
						],
						'home_faq_title_type'          => header_title_type_block(),
						'home_faq_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_faq_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'FAQs', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'FAQ', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'title' => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'  => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								]
							]
						],
						'home_faq_after_title'         => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Отображение вопросов-ответов под заголовком', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_faq_columns_two'         => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Отображение вопросов-ответов в 2 колонки', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off()
						],
						'home_faq_columns_width'       => [
							'type'            => 'number',
							'label'           => esc_html__( 'Максимальная ширина экрана при которой колонки станут друг под другом', 'wescle' ) . ', px',
							'default'         => 575,
							'active_callback' => [
								[
									'setting'  => 'home_faq_columns_two',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'home_faq_color_bg_info'       => home_block_color_bg_info(),
						'home_faq_color_bg'            => home_block_color_bg(),
						'home_faq_color_title'         => home_block_color_title(),
						'home_faq_image_bg'            => home_block_image_bg(),
						'home_faq_image_bg_fit'        => home_block_image_bg_fit(),
						'home_faq_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_faq_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_faq_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_faq_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_faq_demo_info'           => home_block_demo_info( 'faq' ),
					]
				],
				'home_faq2'  => [
					'title'    => __( 'Блок "Инструкция\База знаний"', 'wescle' ),
					'controls' => [
						'home_faq2_preview'             => home_block_preview_img( 'block-instruction' ),
						'home_faq2_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_faq2_enabled_home'        => home_block_enabled(),
						'home_faq2_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'faq_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Инструкция\База знаний" успешно добавлена. Чтобы появился список инструкций, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Инструкции"</a>', 'wescle' ), admin_url( '/edit.php?post_type=faq_wescle' ) ) . '</div>',
						],
						'home_faq2_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Чтобы добавить категорию инструкций, необходимо перейти в <a href="%s" target="_blank">раздел "Категории инструкций"</a> и добавить новую, затем можно будет выбрать ее здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit-tags.php?taxonomy=faqcat_wescle&post_type=faq_wescle' ) ) . '</div>',
						],
						'home_faq2_info3'               => [
							'type'    => $page_template_faq2 ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу "Инструкции", для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Knowledge Base".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_faq2_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_faq2_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .instruction .container'
						],
						'home_faq2_title_type'          => header_title_type_block(),
						'home_faq2_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_faq2_mobile_minify'       => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать категории с навигацией в мобильной версии?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off()
						],
						'home_faq2_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Категории инструкций', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Категория', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить категорию', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'faq_cat' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Категория инструкций', 'wescle' ),
									'multiple'    => false,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_terms( array( 'taxonomy' => 'faqcat_wescle' ), false, true ),
								],
							]
						],
						'home_faq2_color_bg_info'       => home_block_color_bg_info(),
						'home_faq2_color_bg'            => home_block_color_bg(),
						'home_faq2_color_title'         => home_block_color_title(),
						'home_faq2_image_bg'            => home_block_image_bg(),
						'home_faq2_image_bg_fit'        => home_block_image_bg_fit(),
						'home_faq2_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_faq2_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_faq2_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_faq2_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_9'       => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_9' ),
					'controls' => [
						'home_tab_9_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_prices'      => [
					'title'    => __( 'Блок "Прайсы"', 'wescle' ),
					'controls' => [
						'home_prices_preview'             => home_block_preview_img( 'block-prices' ),
						'home_prices_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_prices_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_prices_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .tarrif-plan1 .container'
						],
						'home_prices_title_type'          => header_title_type_block(),
						'home_prices_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_prices_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Прайсы', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Прайс', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'recommended'   => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Рекомендуемый?', 'wescle' ),
								],
								'image'         => [
									'type'    => 'image',
									'label'   => esc_html__( 'Иконка', 'wescle' ),
									'choices' => array(
										'save_as' => 'id'
									),
								],
								'image_center'  => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Отображать иконку по центру?', 'wescle' ),
								],
								'title'         => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text_plus'     => [
									'type'        => 'textarea',
									'label'       => esc_html__( 'Что входит', 'wescle' ),
									'description' => esc_html__( 'каждый пункт с новой строки', 'wescle' ),
								],
								'text_minus'    => [
									'type'        => 'textarea',
									'label'       => esc_html__( 'Что не входит', 'wescle' ),
									'description' => esc_html__( 'каждый пункт с новой строки', 'wescle' ),
								],
								'price'         => [
									'type'  => 'text',
									'label' => esc_html__( 'Цена', 'wescle' ),
								],
								'price_old'     => [
									'type'  => 'text',
									'label' => esc_html__( 'Старая цена', 'wescle' ),
								],
								'button_label'  => [
									'type'    => 'text',
									'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
									'default' => esc_html__( 'Выбрать', 'wescle' ),
								],
								'button_url'    => [
									'type'        => 'url',
									'label'       => esc_html__( 'Ссылка', 'wescle' ),
									'description' => __( '* чтобы кнопку сделать вызовом попапа звонка, пропишите <code>#modal-call</code> или <br><code>#modal-order_price</code>', 'wescle' ),
								],
								'button2_label' => [
									'type'    => 'text',
									'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ) . ' 2',
									'default' => esc_html__( 'Выбрать', 'wescle' ),
								],
								'button2_url'   => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка', 'wescle' ) . ' 2',
								],
								'action_label'  => [
									'type'    => 'text',
									'label'   => esc_html__( 'Заголовок блока с таймером', 'wescle' ),
									'default' => Helper::get_default_theme_data( 'action_label' ),
								],
								'action_date'   => [
									'type'            => 'date',
									'label'           => esc_html__( 'Дата окончания акции', 'wescle' ),
									'active_callback' => [
										[
											'setting'  => 'action_type',
											'operator' => '==',
											'value'    => 'date',
										]
									],
								],
								'action_hours'  => [
									'type'            => 'number',
									'label'           => __( 'ИЛИ', 'wescle' ) . ' ' . esc_html__( 'Через сколько часов окончания акции?', 'wescle' ),
									'default'         => '',
									'active_callback' => [
										[
											'setting'  => 'action_type',
											'operator' => '==',
											'value'    => 'hours',
										]
									],
								],
							]
						],
						'home_prices_image_fullwidth'     => [
							'type'  => 'checkbox',
							'label' => esc_html__( 'Сделать изображения на всю ширину?', 'wescle' ),
						],
						'home_prices_image_height'        => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Высота изображения?', 'wescle' ) . ' px',
							'default' => 100,
							'choices' => [
								'min'  => 50,
								'max'  => 200,
								'step' => 10,
							],
						],
						'home_prices_image_size'          => [
							'type'    => 'select',
							'label'   => esc_html__( 'Размер изображения', 'wescle' ),
							'default' => 'medium',
							'choices' => [
								'medium'       => 'medium',
								'medium_large' => 'medium_large'
							]
						],
						'home_prices_color_bg_info'       => home_block_color_bg_info(),
						'home_prices_color_bg'            => home_block_color_bg(),
						'home_prices_color_title'         => home_block_color_title(),
						'home_prices_image_bg'            => home_block_image_bg(),
						'home_prices_image_bg_fit'        => home_block_image_bg_fit(),
						'home_prices_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_prices_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_prices_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_prices_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_prices_demo_info'           => home_block_demo_info( 'tarif-plan', [], 'prices' ),
					]
				],
				'home_prices2'     => [
					'title'    => __( 'Блок "Прайсы - дополнительно"', 'wescle' ),
					'controls' => [
						'home_prices2_preview'             => home_block_preview_img( 'block-prices' ),
						'home_prices2_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_prices2_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_prices2_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .tarrif-plan2 .container'
						],
						'home_prices2_title_type'          => header_title_type_block(),
						'home_prices2_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_prices2_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Прайсы', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Прайс', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'recommended'   => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Рекомендуемый?', 'wescle' ),
								],
								'image'         => [
									'type'    => 'image',
									'label'   => esc_html__( 'Иконка', 'wescle' ),
									'choices' => array(
										'save_as' => 'id'
									),
								],
								'image_center'  => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Отображать иконку по центру?', 'wescle' ),
								],
								'title'         => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text_plus'     => [
									'type'        => 'textarea',
									'label'       => esc_html__( 'Что входит', 'wescle' ),
									'description' => esc_html__( 'каждый пункт с новой строки', 'wescle' ),
								],
								'text_minus'    => [
									'type'        => 'textarea',
									'label'       => esc_html__( 'Что не входит', 'wescle' ),
									'description' => esc_html__( 'каждый пункт с новой строки', 'wescle' ),
								],
								'price'         => [
									'type'  => 'text',
									'label' => esc_html__( 'Цена', 'wescle' ),
								],
								'price_old'     => [
									'type'  => 'text',
									'label' => esc_html__( 'Старая цена', 'wescle' ),
								],
								'button_label'  => [
									'type'    => 'text',
									'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
									'default' => esc_html__( 'Выбрать', 'wescle' ),
								],
								'button_url'    => [
									'type'        => 'url',
									'label'       => esc_html__( 'Ссылка', 'wescle' ),
									'description' => __( '* чтобы кнопку сделать вызовом попапа звонка, пропишите <code>#modal-call</code> или <br><code>#modal-order_price</code>', 'wescle' ),
								],
								'button2_label' => [
									'type'    => 'text',
									'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ) . ' 2',
									'default' => esc_html__( 'Выбрать', 'wescle' ),
								],
								'button2_url'   => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка', 'wescle' ) . ' 2',
								],
								'action_label'  => [
									'type'    => 'text',
									'label'   => esc_html__( 'Заголовок блока с таймером', 'wescle' ),
									'default' => Helper::get_default_theme_data( 'action_label' ),
								],
								'action_date'   => [
									'type'            => 'date',
									'label'           => esc_html__( 'Дата окончания акции', 'wescle' ),
									'active_callback' => [
										[
											'setting'  => 'action_type',
											'operator' => '==',
											'value'    => 'date',
										]
									],
								],
								'action_hours'  => [
									'type'            => 'number',
									'label'           => __( 'ИЛИ', 'wescle' ) . ' ' . esc_html__( 'Через сколько часов окончания акции?', 'wescle' ),
									'default'         => '',
									'active_callback' => [
										[
											'setting'  => 'action_type',
											'operator' => '==',
											'value'    => 'hours',
										]
									],
								],
							]
						],
						'home_prices2_image_fullwidth'     => [
							'type'  => 'checkbox',
							'label' => esc_html__( 'Сделать изображения на всю ширину?', 'wescle' ),
						],
						'home_prices2_image_height'        => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Высота изображения в', 'wescle' ) . ' px',
							'default' => 100,
							'choices' => [
								'min'  => 50,
								'max'  => 200,
								'step' => 10,
							],
						],
						'home_prices2_image_size'          => [
							'type'    => 'select',
							'label'   => esc_html__( 'Размер изображения', 'wescle' ),
							'default' => 'medium',
							'choices' => [
								'medium'       => 'medium',
								'medium_large' => 'medium_large'
							]
						],
						'home_prices2_color_bg_info'       => home_block_color_bg_info(),
						'home_prices2_color_bg'            => home_block_color_bg(),
						'home_prices2_color_title'         => home_block_color_title(),
						'home_prices2_image_bg'            => home_block_image_bg(),
						'home_prices2_image_bg_fit'        => home_block_image_bg_fit(),
						'home_prices2_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_prices2_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_prices2_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_prices2_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
						'home_prices2_demo_info'           => home_block_demo_info( 'tarif-plan', [], 'prices_duplicate' ),
					]
				],
				'home_price_list'  => [
					'title'    => __( 'Блок "Прайс-лист"', 'wescle' ),
					'controls' => [
						'home_price_list_preview'             => home_block_preview_img( 'block-price-list' ),
						'home_price_list_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_price_list_enabled_home'        => home_block_enabled(),
						'home_price_list_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Прайсы созданы, как Custom Post Type. Чтобы добавить прайс, необходимо перейти в <a href="%s" target="_blank">раздел "Прайсы"</a> и добавить новый, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=price_wescle' ) ) . '</div>',
						],
						'home_price_list_info3'               => [
							'type'    => $page_template_price_list ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу "Прайс-листы", для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Prices".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_price_list_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_price_list_title'               => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок', 'wescle' ),
						],
						'home_price_list_title_type'          => header_title_type_block(),
						'home_price_list_text'                => [
							'type'     => 'editor',
							'label'    => esc_html__( 'Текст', 'wescle' ),
							'selector' => '.home .price-list .container'
						],
						'home_price_list_posts'               => [
							'type'        => 'select',
							'label'       => esc_html__( 'Выберите прайсы', 'wescle' ),
							'default'     => [],
							'multiple'    => 999,
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'price_wescle' ]
							) ),
						],
						'home_price_list_color_bg_info'       => home_block_color_bg_info(),
						'home_price_list_color_bg'            => home_block_color_bg(),
						'home_price_list_color_title'         => home_block_color_title(),
						'home_price_list_image_bg'            => home_block_image_bg(),
						'home_price_list_image_bg_fit'        => home_block_image_bg_fit(),
						'home_price_list_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_price_list_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_price_list_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_price_list_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'home_price_table' => [
					'title'    => __( 'Блок "Что входит"', 'wescle' ),
					'controls' => [
						'home_price_table_preview'             => home_block_preview_img( 'block-whats-include' ),
						'home_price_table_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'pricepackage_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Что входит" успешно добавлена. Чтобы появился список пакетов для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Пакеты"</a>', 'wescle' ), admin_url( '/edit.php?post_type=pricepackage_wescle' ) ) . '</div>',
						],
						'home_price_table_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Пакеты созданы, как Custom Post Type. Чтобы добавить пакет необходимо перейти в <a href="%s" target="_blank">раздел "Пакеты"</a> и добавить новый, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=pricepackage_wescle' ) ) . '</div>',
						],
						'home_price_table_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_price_table_enabled_home'        => home_block_enabled(),
						'home_price_table_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_price_table_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .packages-include .container'
						],
						'home_price_table_title_type'          => header_title_type_block(),
						'home_price_table_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_price_table_title_list'          => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок списка с опциями', 'wescle' ),
						],
						'home_price_table_posts'               => [
							'type'        => 'select',
							'label'       => esc_html__( 'Выберите пакеты', 'wescle' ),
							'default'     => [],
							'multiple'    => 4,
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => [ 'pricepackage_wescle' ]
							) ),
						],
						'home_price_table_button'              => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_price_table_button' )
						],
						'home_price_table_cf7'                 => cf7_type_block( $label_select, esc_html__( 'Выберите форму CF7', 'wescle' ), 'home_price_table' ),
						'home_price_table_color_bg_info'       => home_block_color_bg_info(),
						'home_price_table_color_bg'            => home_block_color_bg(),
						'home_price_table_color_title'         => home_block_color_title(),
						'home_price_table_image_bg'            => home_block_image_bg(),
						'home_price_table_image_bg_fit'        => home_block_image_bg_fit(),
						'home_price_table_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_price_table_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_price_table_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_price_table_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_11'   => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_11' ),
					'controls' => [
						'home_tab_11_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_how_work' => [
					'title'    => __( 'Блок "Как мы работаем"', 'wescle' ),
					'controls' => [
						'home_how_work_preview'             => home_block_preview_img( 'block-how-we-works' ),
						'home_how_work_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_how_work_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_how_work_suptitle'            => [
							'type'  => 'text',
							'label' => esc_html__( 'Текст над заголовком', 'wescle' ),
						],
						'home_how_work_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .how-we-working .container',
						],
						'home_how_work_title_type'          => header_title_type_block(),
						'home_how_work_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_how_work_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блоки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id' => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => [
										'save_as' => 'id',
									],
								],
								'bg_color' => [
									'type'    => 'color',
									'label'   => esc_html__( 'Цвет фона под изображением', 'wescle' ),
									'choices' => [
										'alpha' => true,
									],
								],
								'title'    => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'     => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							]
						],
						'home_how_work_maxwidth'            => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Max-width для блока с изображением', 'wescle' ),
							'default' => 40,
							'choices' => [
								'min'  => 40,
								'max'  => 150,
								'step' => 10,
							],
						],
						'home_how_work_image_center'        => [
							'type'  => 'checkbox',
							'label' => esc_html__( 'Отображать изображения по центру?', 'wescle' ),
						],
						'home_how_work_color_bg_info'       => home_block_color_bg_info(),
						'home_how_work_color_bg'            => home_block_color_bg(),
						'home_how_work_color_title'         => home_block_color_title(),
						'home_how_work_image_bg'            => home_block_image_bg(),
						'home_how_work_image_bg_fit'        => home_block_image_bg_fit(),
						'home_how_work_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_how_work_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_how_work_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_how_work_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_how_work2' => [
					'title'    => __( 'Блок "Как мы работаем 2"', 'wescle' ),
					'controls' => [
						'home_how_work2_preview'             => home_block_preview_img( 'block-how-we-work-two' ),
						'home_how_work2_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_how_work2_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_how_work2_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .how-we-working-v2 .container',
						],
						'home_how_work2_title_type'          => header_title_type_block(),
						'home_how_work2_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_how_work2_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блоки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id'     => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => [
										'save_as' => 'id',
									],
								],
								'title'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'         => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
								'button_label' => [
									'type'  => 'text',
									'label' => esc_html__( 'Надпись на кнопке', 'wescle' ),
								],
								'button_url'   => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка', 'wescle' ),
								],
								'button_blank' => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
								],
							]
						],
						'home_how_work2_maxwidth'            => [
							'type'    => 'slider',
							'label'   => esc_html__( 'Max-width для блока с изображением', 'wescle' ),
							'default' => 100,
							'choices' => [
								'min'  => 40,
								'max'  => 200,
								'step' => 10,
							],
						],
						'home_how_work2_color_bg_info'       => home_block_color_bg_info(),
						'home_how_work2_color_bg'            => home_block_color_bg(),
						'home_how_work2_color_title'         => home_block_color_title(),
						'home_how_work2_image_bg'            => home_block_image_bg(),
						'home_how_work2_image_bg_fit'        => home_block_image_bg_fit(),
						'home_how_work2_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_how_work2_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_how_work2_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_how_work2_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tabs_object' => [
					'title'    => __( 'Блок "Табы с объектами"', 'wescle' ),
					'controls' => [
						'home_tabs_object_preview'             => home_block_preview_img( 'block-tabs-with-objects' ),
						'home_tabs_object_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_tabs_object_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'tab_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Табы с объектами" успешно добавлена. Чтобы появился список табов для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Табы с объектами"</a>', 'wescle' ), admin_url( '/edit.php?post_type=tab_wescle' ) ) . '</div>',
						],
						'home_tabs_object_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Табы созданы, как Custom Post Type. Чтобы добавить таб необходимо перейти в <a href="%s" target="_blank">раздел "Табы с объектами"</a> и добавить новый, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=tab_wescle' ) ) . '</div>',
						],
						'home_tabs_object_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_tabs_object_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .highlight .container'
						],
						'home_tabs_object_title_type'          => header_title_type_block(),
						'home_tabs_object_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_tabs_object_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Табы', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Таб', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'post_id' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Выберите табы', 'wescle' ),
									'default'     => '',
									'multiple'    => false,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type' => 'tab_wescle',
									), true ),
								],
							]
						],
						'home_tabs_object_color_bg_info'       => home_block_color_bg_info(),
						'home_tabs_object_color_bg'            => home_block_color_bg(),
						'home_tabs_object_color_title'         => home_block_color_title(),
						'home_tabs_object_image_bg'            => home_block_image_bg(),
						'home_tabs_object_image_bg_fit'        => home_block_image_bg_fit(),
						'home_tabs_object_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_tabs_object_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_tabs_object_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_tabs_object_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_infotabs' => [
					'title'    => __( 'Блок "Инфо-табы"', 'wescle' ),
					'controls' => [
						'home_infotabs_preview'             => home_block_preview_img( 'block-info-tabs' ),
						'home_infotabs_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_infotabs_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'infotab_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Инфо-табы" успешно добавлена. Чтобы появился список табов для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Инфо-табы"</a>', 'wescle' ), admin_url( '/edit.php?post_type=infotab_wescle' ) ) . '</div>',
						],
						'home_infotabs_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Табы созданы, как Custom Post Type. Чтобы добавить таб необходимо перейти в <a href="%s" target="_blank">раздел "Инфо-табы"</a> и добавить новый, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=infotab_wescle' ) ) . '</div>',
						],
						'home_infotabs_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_infotabs_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .info-tabs .container'
						],
						'home_infotabs_title_type'          => header_title_type_block(),
						'home_infotabs_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_infotabs_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Табы', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Таб', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'post_id' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Выберите табы', 'wescle' ),
									'default'     => '',
									'multiple'    => false,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts( array(
										'post_type' => 'infotab_wescle',
									), true ),
								],
							]
						],
						'home_infotabs_color_bg_info'       => home_block_color_bg_info(),
						'home_infotabs_color_bg'            => home_block_color_bg(),
						'home_infotabs_color_title'         => home_block_color_title(),
						'home_infotabs_image_bg'            => home_block_image_bg(),
						'home_infotabs_image_bg_fit'        => home_block_image_bg_fit(),
						'home_infotabs_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_infotabs_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_infotabs_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_infotabs_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_mosaic' => [
					'title'    => __( 'Блок "Плитки-мозаика"', 'wescle' ),
					'controls' => [
						'home_mosaic_preview'             => home_block_preview_img( 'block-mosaic-tile' ),
						'home_mosaic_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_mosaic_enabled_home'        => home_block_enabled(),
						'home_mosaic_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'mosaic_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Плитки-мозаика" успешно добавлена. Чтобы появился список плиток, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Плитки-мозаика"</a>', 'wescle' ), admin_url( '/edit.php?post_type=mosaic_wescle' ) ) . '</div>',
						],
						'home_mosaic_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Чтобы добавить категорию, необходимо перейти в <a href="%s" target="_blank">раздел "Категории плиток"</a> и добавить новую, затем можно будет выбрать ее здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit-tags.php?taxonomy=mosaiccat_wescle&post_type=mosaic_wescle' ) ) . '</div>',
						],
						'home_mosaic_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_mosaic_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .wescle-places .container'
						],
						'home_mosaic_title_type'          => header_title_type_block(),
						'home_mosaic_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_mosaic_button_title'        => [
							'type'  => 'text',
							'label' => esc_html__( 'Текст для ссылки', 'wescle' ),
						],
						'home_mosaic_button_url'          => [
							'type'  => 'text',
							'label' => esc_html__( 'URL', 'wescle' ),
						],
						'home_mosaic_target_blank'        => [
							'type'  => 'checkbox',
							'label' => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
						],
						'home_mosaic_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Табы плиток', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Таб-категория', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить таб', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'faq_cat' => [
									'type'        => 'select',
									'label'       => esc_html__( 'Категория плиток', 'wescle' ),
									'multiple'    => false,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_terms( array( 'taxonomy' => 'mosaiccat_wescle' ), false, true ),
								],
							]
						],
						'home_mosaic_count'               => [
							'type'    => 'number',
							'label'   => esc_html__( 'Количество плиток', 'wescle' ),
							'default' => 12,
						],
						'home_mosaic_more_text'           => [
							'type'        => 'text',
							'label'       => esc_html__( 'Текст для кнопки "Еще"', 'wescle' ),
							'description' => esc_html__( 'оставьте поле пустым, если не нужно выводить кнопку', 'wescle' ),
						],
						'home_mosaic_color_bg_info'       => home_block_color_bg_info(),
						'home_mosaic_color_bg'            => home_block_color_bg(),
						'home_mosaic_color_title'         => home_block_color_title(),
						'home_mosaic_image_bg'            => home_block_image_bg(),
						'home_mosaic_image_bg_fit'        => home_block_image_bg_fit(),
						'home_mosaic_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_mosaic_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_mosaic_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_mosaic_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_12'  => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_12' ),
					'controls' => [
						'home_tab_12_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_contact' => [
					'title'    => __( 'Блок "Контакты"', 'wescle' ),
					'controls' => [
						'home_contact_preview'             => home_block_preview_img( 'block-contacts' ),
						'home_contact_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_contact_enabled_home'        => home_block_enabled(),
						'home_contact_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_contact_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .contact-us .container',
						],
						'home_contact_title_type'          => header_title_type_block(),
						'home_contact_block_left_info'     => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Информация в колонке слева', 'wescle' ) . '</h3>',
						],
						'home_contact_block_left_title'    => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок', 'wescle' ),
						],
						'home_contact_block_left_text'     => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_contact_block_left_phones'   => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Телефоны', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Телефон', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить телефон', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'number' => [
									'type'  => 'text',
									'label' => esc_html__( 'Номер телефона', 'wescle' ),
								],
								'anchor' => [
									'type'  => 'text',
									'label' => esc_html__( 'Анкор ссылки', 'wescle' ),
								]
							]
						],
						'home_contact_block_left_text2'    => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст после телефонов', 'wescle' ),
						],
						'home_contact_block_left_map'      => [
							'type'              => 'textarea',
							'label'             => esc_html__( 'Карта - iframe', 'wescle' ),
							'sanitize_callback' => 'output_html_code',
						],
						'home_contact_block_right_info'    => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Информация в колонке справа', 'wescle' ) . '</h3>',
						],
						'home_contact_block_right_title'   => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок', 'wescle' ),
						],
						'home_contact_block_right_text'    => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_contact_cf7_info'            => [
							'type'    => class_exists( 'WPCF7_Mail' ) ? '' : 'custom',
							'label'   => esc_html__( 'Выберите форму CF7', 'wescle' ),
							'default' => '<div class="notice notice-warning section-description">' . $notice_cf7 . '</div>',
						],
						'home_contact_cf7'                 => cf7_type_block( $label_select, esc_html__( 'Выберите форму CF7', 'wescle' ), 'home_contact' ),
						'home_contact_color_bg_info'       => home_block_color_bg_info(),
						'home_contact_color_bg'            => home_block_color_bg(),
						'home_contact_color_title'         => home_block_color_title(),
						'home_contact_image_bg'            => home_block_image_bg(),
						'home_contact_image_bg_fit'        => home_block_image_bg_fit(),
						'home_contact_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_contact_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_contact_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_contact_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_map' => [
					'title'    => __( 'Блок "Карта"', 'wescle' ),
					'controls' => [
						'home_map_preview'             => home_block_preview_img( 'block-wescle-map' ),
						'home_map_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_map_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_map_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .wescle-map .wescle-map__description .container'
						],
						'home_map_title_type'          => header_title_type_block(),
						'home_map_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_map_items'               => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Табы', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Таб-карта', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить таб', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'map_title'                => [
									'type'  => 'text',
									'label' => __( 'Заголовок', 'wescle' ),
								],
								'map_image'                => [
									'type'        => 'image',
									'label'       => __( 'Превью карты', 'wescle' ),
									'description' => __( 'Изображение которое будет показано до подгрузки карты', 'wescle' ),
									'choices'     => [
										'save_as' => 'id',
									],
								],
								'map_url'                  => [
									'type'        => 'text',
									'label'       => __( 'URL карты', 'wescle' ),
									'description' => '<a data-fancybox href="' . get_template_directory_uri() . '/assets/admin/img/wescle-map-info.jpg"><img src="' . get_template_directory_uri() . '/assets/admin/img/wescle-map-info.jpg" alt=""></a>' . esc_html__( 'Для того чтобы вставить URL карты, нужно перейти в google maps, затем в меню выбрать пункт "Ссылка/код", в выпадающем окне выбрать пункт "Встраивание карт" и скопировать из src путь.', 'wescle' ),
								],
								'map_dark'                 => [
									'type'  => 'checkbox',
									'label' => __( 'Темный стиль карты?', 'wescle' ),
								],
								'map_contact'              => [
									'type'  => 'checkbox',
									'label' => __( 'Включить блок с контактами?', 'wescle' ),
								],
								'map_contact_title'        => [
									'type'  => 'text',
									'label' => __( 'Заголовок', 'wescle' ),
								],
								'map_contact_text'         => [
									'type'  => 'textarea',
									'label' => __( 'Текст', 'wescle' ),
								],
								'map_contact_phone'        => [
									'type'  => 'text',
									'label' => __( 'Телефон', 'wescle' ),
								],
								'map_contact_email'        => [
									'type'  => 'text',
									'label' => __( 'Email', 'wescle' ),
								],
								'map_contact_button1_text' => [
									'type'  => 'text',
									'label' => __( 'Кнопка', 'wescle' ) . ' 1',
								],
								'map_contact_button1_url'  => [
									'type'  => 'text',
									'label' => __( 'URL кнопки', 'wescle' ) . ' 1',
								],
								'map_contact_button2_text' => [
									'type'  => 'text',
									'label' => __( 'Кнопка', 'wescle' ) . ' 2',
								],
								'map_contact_button2_url'  => [
									'type'  => 'text',
									'label' => __( 'URL кнопки', 'wescle' ) . ' 2',
								],
							]
						],
						'home_map_fullwidth'           => [
							'type'    => 'switch',
							'label'   => __( 'На всю ширину страницы?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_map_nopadding'           => [
							'type'    => 'switch',
							'label'   => __( 'Убрать внешние отступы сверху и снизу?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_map_color_bg_info'       => home_block_color_bg_info(),
						'home_map_color_bg'            => home_block_color_bg(),
						'home_map_color_title'         => home_block_color_title(),
						'home_map_image_bg'            => home_block_image_bg(),
						'home_map_image_bg_fit'        => home_block_image_bg_fit(),
						'home_map_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_map_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_map_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_map_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_13'    => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_13' ),
					'controls' => [
						'home_tab_13_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_partners'  => [
					'title'    => __( 'Блок "Наши партнеры"', 'wescle' ),
					'controls' => [
						'home_partners_preview'               => home_block_preview_img( 'block-partners' ),
						'home_partners_enabled'               => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_partners_id_block'              => [
							'type'     => 'text',
							'label'    => esc_html__( 'ID блока', 'wescle' ),
							'selector' => '.home .our-partners .container'
						],
						'home_partners_title'                 => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .our-partners .container'
						],
						'home_partners_title_type'            => header_title_type_block(),
						'home_partners_text'                  => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_partners_images'                => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Логотипы', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Логотип', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить логотип', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image_id' => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => [
										'save_as' => 'id',
									],
								],
								'link'     => [
									'type'  => 'url',
									'label' => esc_html__( 'Ссылка', 'wescle' ),
								]
							]
						],
						'home_partners_settings_info'         => home_slider_settings_info(),
						'home_partners_settings_count'        => home_slider_settings_count( 8, 9 ),
						'home_partners_settings_speed'        => home_slider_settings_speed(),
						'home_partners_settings_arrow'        => home_slider_settings_arrow(),
						'home_partners_settings_arrow_mobile' => home_slider_settings_arrow_mobile(),
						'home_partners_settings_dots'         => home_slider_settings_dots(),
						'home_partners_color_info'            => home_block_color_bg_info(),
						'home_partners_color_bg'              => home_block_color_bg(),
						'home_partners_color_title'           => home_block_color_title(),
						'home_partners_image_bg'              => home_block_image_bg(),
						'home_partners_image_bg_fit'          => home_block_image_bg_fit(),
						'home_partners_image_bg_tablet'       => home_block_image_bg( 'tablet' ),
						'home_partners_image_bg_fit_tablet'   => home_block_image_bg_fit( 'tablet' ),
						'home_partners_image_bg_mobile'       => home_block_image_bg( 'mobile' ),
						'home_partners_image_bg_fit_mobile'   => home_block_image_bg_fit( 'mobile' ),
					]
				],
				'home_partners2' => [
					'title'    => __( 'Блок "Партнеры 2"', 'wescle' ),
					'controls' => [
						'home_partners2_preview'             => home_block_preview_img( 'block-partners-pages' ),
						'home_partners2_enabled'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_partners2_enabled_home'        => home_block_enabled(),
						'home_partners2_info'                => [
							'type'    => Helper::get_posts( array( 'post_type' => 'partner_wescle', 'posts_per_page' => 1 ) ) ? '' : 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Секция "Партнеры" успешно добавлена. Чтобы появился список партнеров для прикрепления на главной странице, необходимо сначала добавить их в админ панели в <a href="%s" target="_blank">разделе "Партнеры"</a>', 'wescle' ), admin_url( '/edit.php?post_type=partner_wescle' ) ) . '</div>',
						],
						'home_partners2_info2'               => [
							'type'    => 'custom',
							'default' => '<div class="notice notice-warning section-description">' . sprintf( __( 'Партнеры созданы, как Custom Post Type. Чтобы добавить партнера необходимо перейти в <a href="%s" target="_blank">раздел "Партнеры"</a> и добавить нового, затем можно будет выбрать его здесь в кастомайзере, и прикрепить на главной.', 'wescle' ), admin_url( '/edit.php?post_type=partner_wescle' ) ) . '</div>',
						],
						'home_partners2_info3'               => [
							'type'    => $page_template_partners ? '' : 'custom',
							'default' => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу c партнерами, для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Partners".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
						],
						'home_partners2_id_block'            => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_partners2_title'               => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .partners .container'
						],
						'home_partners2_title_type'          => header_title_type_block(),
						'home_partners2_text'                => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_partners2_posts'               => [
							'type'        => 'select',
							'label'       => esc_html__( 'Выберите партнеров', 'wescle' ),
							'default'     => 0,
							'multiple'    => 999,
							'isClearable' => true,
							'placeholder' => $label_select,
							'choices'     => Helper::get_posts( array(
								'post_type' => 'partner_wescle',
							) ),
						],
						'home_partners2_color_info'          => home_block_color_bg_info(),
						'home_partners2_color_bg'            => home_block_color_bg(),
						'home_partners2_color_title'         => home_block_color_title(),
						'home_partners2_image_bg'            => home_block_image_bg(),
						'home_partners2_image_bg_fit'        => home_block_image_bg_fit(),
						'home_partners2_image_bg_tablet'     => home_block_image_bg( 'tablet' ),
						'home_partners2_image_bg_fit_tablet' => home_block_image_bg_fit( 'tablet' ),
						'home_partners2_image_bg_mobile'     => home_block_image_bg( 'mobile' ),
						'home_partners2_image_bg_fit_mobile' => home_block_image_bg_fit( 'mobile' ),
					]
				],

				'home_tab_14' => [
					'title'    => Helper::get_default_theme_data( 'home_tab_titles', 'home_tab_14' ),
					'controls' => [
						'home_tab_14_info' => [
							'type' => 'custom'
						]
					]
				],
				'home_seo'    => [
					'title'    => __( 'Блок "SEO"', 'wescle' ),
					'controls' => [
						'home_seo_preview'       => home_block_preview_img( 'block-seo' ),
						'home_seo_enabled'       => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить блок', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'home_seo_id_block'      => [
							'type'  => 'text',
							'label' => esc_html__( 'ID блока', 'wescle' ),
						],
						'home_seo_title'         => [
							'type'     => 'text',
							'label'    => esc_html__( 'Заголовок', 'wescle' ),
							'selector' => '.home .seo .container'
						],
						'home_seo_title_type'    => header_title_type_block(),
						'home_seo_text'          => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'home_seo_height'        => [
							'type'    => 'number',
							'label'   => esc_html__( 'Высота видимой части', 'wescle' ),
							'default' => 200,
						],
						'home_seo_text_open'     => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись для разворачивания блока', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_seo_text_open' )
						],
						'home_seo_text_close'    => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись для сворачивания блока', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_seo_text_close' )
						],
						'home_seo_color_bg_info' => home_block_color_bg_info(),
						'home_seo_color_bg'      => home_block_color_bg(),
						'home_seo_color_title'   => home_block_color_title(),
					]
				],

				'home_tab_15' => [
					'title'    => __( 'Управление блоками', 'wescle' ),
					'controls' => [
						'home_tab_15_info' => [
							'type' => 'custom'
						]
					]
				],

				'home_block_sort'       => [
					'title'    => __( 'Сортировка блоков', 'wescle' ),
					'controls' => [
						'home_block_sortable' => [
							'type'    => 'sortable',
							'label'   => esc_html__( 'Порядок блоков', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'home_block_sortable' ),
							'choices' => [
								'woo_blocks'       => Helper::get_default_theme_data( 'home_block_titles', 'woo_blocks' ),
								'block_posts'      => Helper::get_default_theme_data( 'home_block_titles', 'home_blocks' ),
								'product_tabs'     => Helper::get_default_theme_data( 'home_block_titles', 'product_tabs' ),
								'advantages'       => Helper::get_default_theme_data( 'home_block_titles', 'home_advantages' ),
								'advantages2'      => Helper::get_default_theme_data( 'home_block_titles', 'home_advantages2' ),
								'characteristics'  => Helper::get_default_theme_data( 'home_block_titles', 'home_characteristics' ),
								'advantages_v2'    => Helper::get_default_theme_data( 'home_block_titles', 'home_advantages_v2' ),
								'pros_cons'        => Helper::get_default_theme_data( 'home_block_titles', 'home_pros_cons' ),
								'checklist'        => Helper::get_default_theme_data( 'home_block_titles', 'home_checklist' ),
								'advantages_v3'    => Helper::get_default_theme_data( 'home_block_titles', 'home_advantages_v3' ),
								'services'         => Helper::get_default_theme_data( 'home_block_titles', 'home_services' ),
								'services2'        => Helper::get_default_theme_data( 'home_block_titles', 'home_services2' ),
								'services_slider'  => Helper::get_default_theme_data( 'home_block_titles', 'home_services_slider' ),
								'prodwescle'       => Helper::get_default_theme_data( 'home_block_titles', 'home_prodwescle' ),
								'woo_banners'      => Helper::get_default_theme_data( 'home_block_titles', 'woo_banners' ),
								'licenses'         => Helper::get_default_theme_data( 'home_block_titles', 'home_licensewescle' ),
								'catalog'          => Helper::get_default_theme_data( 'home_block_titles', 'home_catalog' ),
								'catalogcats'      => Helper::get_default_theme_data( 'home_block_titles', 'home_catalogcats' ),
								'portfolio'        => Helper::get_default_theme_data( 'home_block_titles', 'home_portfolio' ),
								'gallery'          => Helper::get_default_theme_data( 'home_block_titles', 'home_gallery' ),
								'about'            => Helper::get_default_theme_data( 'home_block_titles', 'home_about' ),
								'about2'           => Helper::get_default_theme_data( 'home_block_titles', 'home_about2' ),
								'information'      => Helper::get_default_theme_data( 'home_block_titles', 'home_information' ),
								'team'             => Helper::get_default_theme_data( 'home_block_titles', 'home_team' ),
								'info_plus_banner' => Helper::get_default_theme_data( 'home_block_titles', 'info_plus_banner' ),
								'team_static'      => Helper::get_default_theme_data( 'home_block_titles', 'home_team_static' ),
								'team_cpt'         => Helper::get_default_theme_data( 'home_block_titles', 'home_team_cpt' ),
								'payments'         => Helper::get_default_theme_data( 'home_block_titles', 'home_payments' ),
								'performance'      => Helper::get_default_theme_data( 'home_block_titles', 'home_performance' ),
								'what_site'        => Helper::get_default_theme_data( 'home_block_titles', 'home_what_site' ),
								'why'              => Helper::get_default_theme_data( 'home_block_titles', 'home_why_site' ),
								'benefit'          => Helper::get_default_theme_data( 'home_block_titles', 'home_benefit' ),
								'events'           => Helper::get_default_theme_data( 'home_block_titles', 'home_events' ),
								'programs'         => Helper::get_default_theme_data( 'home_block_titles', 'home_programs' ),
								'videos_carousel'  => Helper::get_default_theme_data( 'home_block_titles', 'home_videos' ),
								'videos2'          => Helper::get_default_theme_data( 'home_block_titles', 'home_videos2' ),
								'videos_max'       => Helper::get_default_theme_data( 'home_block_titles', 'home_videos_max' ),
								'sta'              => Helper::get_default_theme_data( 'home_block_titles', 'home_sta' ),
								'sta2'             => Helper::get_default_theme_data( 'home_block_titles', 'home_sta2' ),
								'sta_center'       => Helper::get_default_theme_data( 'home_block_titles', 'home_sta_center' ),
								'sta_minimal'      => Helper::get_default_theme_data( 'home_block_titles', 'home_sta_minimal' ),
								'difference'       => Helper::get_default_theme_data( 'home_block_titles', 'home_difference' ),
								'special'          => Helper::get_default_theme_data( 'home_block_titles', 'home_special' ),
								'reviews'          => Helper::get_default_theme_data( 'home_block_titles', 'home_reviews' ),
								'videoreviews'     => Helper::get_default_theme_data( 'home_block_titles', 'home_videoreviews' ),
								'faq'              => Helper::get_default_theme_data( 'home_block_titles', 'home_faq' ),
								'faq2'             => Helper::get_default_theme_data( 'home_block_titles', 'home_faq2' ),
								'prices'           => Helper::get_default_theme_data( 'home_block_titles', 'home_prices' ),
								'prices2'          => Helper::get_default_theme_data( 'home_block_titles', 'home_prices2' ),
								'price_list'       => Helper::get_default_theme_data( 'home_block_titles', 'home_price_list' ),
								'price_table'      => Helper::get_default_theme_data( 'home_block_titles', 'home_price_table' ),
								'how_work'         => Helper::get_default_theme_data( 'home_block_titles', 'home_how_work' ),
								'how_work2'        => Helper::get_default_theme_data( 'home_block_titles', 'home_how_work2' ),
								'tabs_object'      => Helper::get_default_theme_data( 'home_block_titles', 'home_tabs_object' ),
								'infotabs'         => Helper::get_default_theme_data( 'home_block_titles', 'home_infotabs' ),
								'mosaic'           => Helper::get_default_theme_data( 'home_block_titles', 'home_mosaic' ),
								'map_tabs'         => Helper::get_default_theme_data( 'home_block_titles', 'home_map' ),
								'contact'          => Helper::get_default_theme_data( 'home_block_titles', 'home_contact' ),
								'partners'         => Helper::get_default_theme_data( 'home_block_titles', 'home_partners' ),
								'partners2'        => Helper::get_default_theme_data( 'home_block_titles', 'home_partners2' ),
								'stories'          => Helper::get_default_theme_data( 'home_block_titles', 'home_stories' ),
								'seo'              => Helper::get_default_theme_data( 'home_block_titles', 'home_seo' ),
							],
						],
					]
				],
				'home_sidebar_position' => [
					'title'    => __( 'Настройки сайдбара', 'wescle' ),
					'controls' => [
						'home_sidebar_position' => field_sidebar_aside_position(),
						'home_sidebar_width'    => field_sidebar_box_width( 'home_sidebar_position' ),
					]
				],

			]
		],

		'post_page_tab' => [
			'title'    => __( 'Настройка внутренних страниц', 'wescle' ),
			'priority' => 60,

			'sections' => [
				'post_section'       => [
					'title'    => __( 'Настройка записи', 'wescle' ),
					'controls' => [
						'post_about_version'               => field_post_header_version(),
						'post_about_full_height'           => field_post_header_full_height( 'post' ),
						'post_about_version_image'         => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать миниатюру в начале поста?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'post_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'post_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								]
							],
						],
						'post_about_image_height_variable' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Гибкая высота главного фото?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'post_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'post_about_version',
										'operator' => '==',
										'value'    => 'v2',
									]
								],
								[
									'setting'  => 'post_about_version_image',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'post_sidebar_position'            => field_sidebar_aside_position(),
						'post_content_box_width'           => field_content_box_width( '' ),
						'post_sidebar_box_width'           => field_sidebar_box_width( 'post_sidebar_position' ),
						'post_blocks_hide'                 => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [ 'date', 'date_mod', 'comments' ],
							'choices' => Helper::choices_post_blocks_hide()
						],
						'post_block_related'               => [
							'type'        => 'number',
							'label'       => esc_html__( 'Количество похожих записей', 'wescle' ),
							'description' => esc_html__( '0 - чтобы отключить, максимум 20', 'wescle' ),
							'default'     => 3,
						],
						'post_block_related_title'         => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок для блока "Похожие записи"', 'wescle' ),
							'default' => esc_html__( 'Похожие записи', 'wescle' ),
						],
						'post_cf7_after_content'           => cf7_type_block( $label_select, esc_html__( 'Укажите форму для показа после контента', 'wescle' ) ),
					]
				],
				'page_section'       => [
					'title'    => __( 'Настройка страницы', 'wescle' ),
					'controls' => [
						'page_sidebar_position'  => field_sidebar_aside_position(),
						'page_content_box_width' => field_content_box_width( '' ),
						'page_sidebar_box_width' => field_sidebar_box_width( 'page_sidebar_position' ),
						'page_blocks_hide'       => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [ 'date', 'date_mod', 'comments' ],
							'choices' => Helper::choices_post_blocks_hide( [ 'category', 'media_icon', 'excerpt', 'author_info' ] )
						],
						'page_cf7_after_content' => cf7_type_block( $label_select, esc_html__( 'Укажите форму для показа после контента', 'wescle' ) ),
					]
				],
				'service_section'    => [
					'title'    => __( 'Настройка услуги', 'wescle' ),
					'controls' => [
						'service_about_version'               => field_post_header_version(),
						'service_about_full_height'           => field_post_header_full_height( 'service' ),
						'service_about_version_image'         => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать миниатюру в начале поста?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'service_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'service_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								]
							],
						],
						'service_about_image_height_variable' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Гибкая высота главного фото?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'service_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'service_about_version',
										'operator' => '==',
										'value'    => 'v2',
									]
								],
								[
									'setting'  => 'service_about_version_image',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'service_sidebar_position'            => field_sidebar_aside_position(),
						'service_content_box_width'           => field_content_box_width( '' ),
						'service_sidebar_box_width'           => field_sidebar_box_width( 'service_sidebar_position' ),
						'service_blocks_hide'                 => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [ 'date', 'date_mod', 'comments' ],
							'choices' => Helper::choices_post_blocks_hide( [ 'category', 'media_icon' ] )
						],
						'service_block_related'               => [
							'type'        => 'number',
							'label'       => esc_html__( 'Количество похожих записей', 'wescle' ),
							'description' => esc_html__( '0 - чтобы отключить, максимум 20', 'wescle' ),
							'default'     => 3,
						],
						'service_block_related_title'         => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок для блока "Похожие услуги"', 'wescle' ),
							'default' => esc_html__( 'Похожие услуги', 'wescle' ),
						],
						'service_cf7_after_content'           => cf7_type_block( $label_select, esc_html__( 'Укажите форму для показа после контента', 'wescle' ) ),
					]
				],
				'portfolio_section'  => [
					'title'    => __( 'Настройка портфолио работ', 'wescle' ),
					'controls' => [
						'portfolio_wescle_about_version'               => field_post_header_version(),
						'portfolio_wescle_about_full_height'           => field_post_header_full_height( 'portfolio_wescle' ),
						'portfolio_wescle_about_version_image'         => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать миниатюру в начале поста?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'portfolio_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'portfolio_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								]
							],
						],
						'portfolio_wescle_about_image_height_variable' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Гибкая высота главного фото?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'portfolio_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'portfolio_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									]
								],
								[
									'setting'  => 'portfolio_wescle_version_image',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'portfolio_wescle_sidebar_position'            => field_sidebar_aside_position(),
						'portfolio_wescle_content_box_width'           => field_content_box_width( '' ),
						'portfolio_sidebar_box_width'                  => field_sidebar_box_width( 'portfolio_wescle_sidebar_position' ),
						'portfolio_wescle_blocks_hide'                 => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [ 'date', 'date_mod', 'comments' ],
							'choices' => Helper::choices_post_blocks_hide( [ 'category', 'media_icon' ] )
						],
						'portfolio_wescle_block_related'               => [
							'type'        => 'number',
							'label'       => esc_html__( 'Количество похожих записей', 'wescle' ),
							'description' => esc_html__( '0 - чтобы отключить, максимум 20', 'wescle' ),
							'default'     => 3,
						],
						'portfolio_wescle_block_related_title'         => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок для блока "Похожие работы"', 'wescle' ),
							'default' => esc_html__( 'Похожие работы', 'wescle' ),
						],
						'portfolio_wescle_cf7_after_content'           => cf7_type_block( $label_select, esc_html__( 'Укажите форму для показа после контента', 'wescle' ) ),
					]
				],
				'event_section'      => [
					'title'    => __( 'Настройка мероприятия', 'wescle' ),
					'controls' => [
						'event_wescle_about_version'               => field_post_header_version(),
						'event_wescle_about_full_height'           => field_post_header_full_height( 'event_wescle' ),
						'event_wescle_about_version_image'         => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать миниатюру в начале поста?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'event_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'event_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								]
							],
						],
						'event_wescle_about_image_height_variable' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Гибкая высота главного фото?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'event_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'event_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								],
								[
									'setting'  => 'event_wescle_version_image',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'event_wescle_sidebar_position'            => field_sidebar_aside_position(),
						'event_wescle_content_box_width'           => field_content_box_width( '' ),
						'event_wescle_sidebar_box_width'           => field_sidebar_box_width( 'event_wescle_sidebar_position' ),
						'event_wescle_blocks_hide'                 => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [ 'date', 'date_mod', 'comments' ],
							'choices' => Helper::choices_post_blocks_hide( [ 'category', 'media_icon' ], [
								'event_date' => __( 'Дата мероприятия', 'wescle' )
							] )
						],
						'event_wescle_block_related'               => [
							'type'        => 'number',
							'label'       => esc_html__( 'Количество похожих записей', 'wescle' ),
							'description' => esc_html__( '0 - чтобы отключить, максимум 20', 'wescle' ),
							'default'     => 3,
						],
						'event_wescle_block_related_title'         => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок для блока "Похожие мероприятия"', 'wescle' ),
							'default' => esc_html__( 'Похожие мероприятия', 'wescle' ),
						],
						'event_wescle_cf7_after_content'           => cf7_type_block( $label_select, esc_html__( 'Укажите форму для показа после контента', 'wescle' ) ),
					]
				],
				'prodwescle_section' => [
					'title'    => __( 'Настройка товара', 'wescle' ),
					'controls' => [
						'product_wescle_about_version'               => field_post_header_version(),
						'product_wescle_about_full_height'           => field_post_header_full_height( 'product_wescle' ),
						'product_wescle_about_version_image'         => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать миниатюру в начале поста?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'product_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'product_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								]
							],
						],
						'product_wescle_about_image_height_variable' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Гибкая высота главного фото?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'product_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'product_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								],
								[
									'setting'  => 'product_wescle_version_image',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'product_wescle_sidebar_position'            => field_sidebar_aside_position(),
						'product_wescle_content_box_width'           => field_content_box_width( '' ),
						'product_wescle_sidebar_box_width'           => field_sidebar_box_width( 'product_wescle_sidebar_position' ),
						'product_wescle_blocks_hide'                 => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [ 'date', 'date_mod', 'comments' ],
							'choices' => Helper::choices_post_blocks_hide( [ 'category', 'media_icon' ] )
						],
						'product_wescle_block_related'               => [
							'type'        => 'number',
							'label'       => esc_html__( 'Количество похожих товаров', 'wescle' ),
							'description' => esc_html__( '0 - чтобы отключить, максимум 20', 'wescle' ),
							'default'     => 3,
						],
						'product_wescle_block_related_title'         => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок для блока "Похожие товары"', 'wescle' ),
							'default' => esc_html__( 'Похожие товары', 'wescle' ),
						],
						'product_wescle_cf7_after_content'           => cf7_type_block( $label_select, esc_html__( 'Укажите форму для показа после контента', 'wescle' ) ),
					]
				],
				'video_section'      => [
					'title'    => __( 'Настройка видео', 'wescle' ),
					'controls' => [
						'video_wescle_about_version'               => field_post_header_version(),
						'video_wescle_about_full_height'           => field_post_header_full_height( 'video_wescle' ),
						'video_wescle_about_version_image'         => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать миниатюру в начале поста?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'video_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'video_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								]
							],
						],
						'video_wescle_about_image_height_variable' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Гибкая высота главного фото?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'video_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'video_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								],
								[
									'setting'  => 'video_wescle_version_image',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'video_wescle_sidebar_position'            => field_sidebar_aside_position(),
						'video_wescle_content_box_width'           => field_content_box_width( '' ),
						'video_wescle_sidebar_box_width'           => field_sidebar_box_width( 'video_wescle_sidebar_position' ),
						'video_wescle_blocks_hide'                 => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [ 'date', 'date_mod', 'comments' ],
							'choices' => Helper::choices_post_blocks_hide( [ 'category', 'media_icon' ] )
						],
						'video_wescle_block_related'               => [
							'type'        => 'number',
							'label'       => esc_html__( 'Количество похожих видео', 'wescle' ),
							'description' => esc_html__( '0 - чтобы отключить, максимум 20', 'wescle' ),
							'default'     => 3,
						],
						'video_wescle_block_related_title'         => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок для блока "Похожие видео"', 'wescle' ),
							'default' => esc_html__( 'Похожие видео', 'wescle' ),
						],
						'video_wescle_cf7_after_content'           => cf7_type_block( $label_select, esc_html__( 'Укажите форму для показа после контента', 'wescle' ) ),
					]
				],

				'team_section' => [
					'title'    => __( 'Настройка команды', 'wescle' ),
					'controls' => [
						'team_wescle_about_version'               => field_post_header_version(),
						'team_wescle_about_full_height'           => field_post_header_full_height( 'team_wescle' ),
						'team_wescle_about_version_image'         => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать миниатюру в начале поста?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'team_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'team_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								]
							],
						],
						'team_wescle_about_image_height_variable' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Гибкая высота главного фото?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'team_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'team_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								],
								[
									'setting'  => 'team_wescle_version_image',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'team_wescle_sidebar_position'            => field_sidebar_aside_position(),
						'team_wescle_content_box_width'           => field_content_box_width( '' ),
						'team_wescle_sidebar_box_width'           => field_sidebar_box_width( 'team_wescle_sidebar_position' ),
						'team_wescle_blocks_hide'                 => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [ 'date', 'date_mod', 'comments' ],
							'choices' => Helper::choices_post_blocks_hide( [ 'category', 'media_icon' ] )
						],
						'team_wescle_block_related'               => [
							'type'        => 'number',
							'label'       => esc_html__( 'Количество похожих людей', 'wescle' ),
							'description' => esc_html__( '0 - чтобы отключить, максимум 20', 'wescle' ),
							'default'     => 3,
						],
						'team_wescle_block_related_title'         => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок для блока "Похожие"', 'wescle' ),
						],
						'team_wescle_cf7_after_content'           => cf7_type_block( $label_select, esc_html__( 'Укажите форму для показа после контента', 'wescle' ) ),
					]
				],

				'product_section' => [
					'title'    => Helper::is_woocommerce_active() ? __( 'Настройка товара WooCommerce', 'wescle' ) : '',
					'controls' => [
						'product_sidebar_position'       => field_sidebar_aside_position( 'none' ),
						'product_content_box_width'      => field_content_box_width( '' ),
						'product_sidebar_box_width'      => field_sidebar_box_width( 'product_sidebar_position' ),
						'product_gallery_left'           => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать галерею товара сбоку?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'product_sticky_button_cart'     => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать плавающую кнопку "В корзину"?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'product_quick_view_enabled'     => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Быстрый просмотр товара?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'product_ajax_add_cart'          => [
							'type'    => 'switch',
							'label'   => esc_html__( 'AJAX добавление товара в корзину?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'product_variation_swatches'     => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Изменить стиль вариаций выпадающего списка на кнопки?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'product_quantity_togglers'      => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Отобразить плюс и минус кнопками?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'product_quantity_togglers_type' => [
							'type'            => 'radio',
							'label'           => esc_html__( 'Вид', 'wescle' ),
							'default'         => '1',
							'choices'         => [
								'1' => __( 'горизонтально', 'wescle' ),
								'2' => __( 'вертикально', 'wescle' ),
							],
							'active_callback' => [
								[
									'setting'  => 'product_quantity_togglers',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'short_description_height'       => [
							'type'    => 'number',
							'label'   => esc_html__( 'Высота видимой части блока с кратким описанием', 'wescle' ) . ', px',
							'default' => 150,
						],
						'short_description_text_open'    => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись на кнопке "Развернуть"', 'wescle' ),
							'default' => Helper::get_text_label( 'open' ),
						],
						'short_description_text_close'   => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись на кнопке "Свернуть"', 'wescle' ),
							'default' => Helper::get_text_label( 'close' ),
						],
						'product_meta_category'          => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать категории?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'product_meta_tag'               => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать метки?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'product_share_enabled'          => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать cоциальные кнопки?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'product_related_enabled'        => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать похожие товары?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'product_related_slider'         => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Включить слайдер?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'product_related_enabled',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'product_related_title'          => [
							'type'            => 'text',
							'label'           => esc_html__( 'Заголовок', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'product_related_title' ),
							'active_callback' => [
								[
									'setting'  => 'product_related_enabled',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'product_related_title_type'     => array_merge(
							header_title_type_block(),
							array(
								'active_callback' => [
									[
										'setting'  => 'product_related_enabled',
										'operator' => '==',
										'value'    => true,
									]
								],
							)
						),

						'product_related_count'       => [
							'type'            => 'number',
							'label'           => esc_html__( 'Количество похожих товаров', 'wescle' ),
							'default'         => 8,
							'active_callback' => [
								[
									'setting'  => 'product_related_enabled',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'product_viewed_enabled'      => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать просмотренные товары?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'product_viewed_slider'       => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Включить слайдер?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'product_viewed_enabled',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'product_viewed_title'        => [
							'type'            => 'text',
							'label'           => esc_html__( 'Заголовок', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'product_viewed_title' ),
							'active_callback' => [
								[
									'setting'  => 'product_viewed_enabled',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'product_related_viewed_type' => array_merge(
							header_title_type_block(),
							array(
								'active_callback' => [
									[
										'setting'  => 'product_viewed_enabled',
										'operator' => '==',
										'value'    => true,
									]
								],
							)
						),
						'product_viewed_count'        => [
							'type'            => 'number',
							'label'           => esc_html__( 'Количество просмотренных товаров', 'wescle' ),
							'default'         => 8,
							'active_callback' => [
								[
									'setting'  => 'product_viewed_enabled',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'product_additionally_items'  => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Блоки с информацией', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Блок', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить блок', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image'      => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ),
									'choices' => array(
										'save_as' => 'id'
									),
								],
								'title'      => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'text'       => [
									'type'    => 'textarea',
									'label'   => esc_html__( 'Текст', 'wescle' ),
									'default' => '',
								],
								'product_id' => [
									'type'        => 'text',
									'label'       => esc_html__( 'На каких товарах отображать?', 'wescle' ),
									'default'     => 0,
									'description' => 0 . ' - ' . __( 'Показывать во всех товарах', 'wescle' ) . '. ' . __( 'Пропишите ID товаров через запятую', 'wescle' )
								]
							],
							'selector'     => '.product-additionally'
						],
					]
				],

				'course_section' => [
					'title'    => get_theme_mod( 'module_course_enabled' ) ? __( 'Настройка курса', 'wescle' ) : '',
					'controls' => [
						'course_wescle_about_version'               => field_post_header_version(),
						'course_wescle_about_full_height'           => field_post_header_full_height( 'course_wescle' ),
						'course_wescle_about_version_image'         => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать миниатюру в начале поста?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'course_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'course_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								]
							],
						],
						'course_wescle_about_image_height_variable' => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Гибкая высота главного фото?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									[
										'setting'  => 'course_wescle_about_version',
										'operator' => '==',
										'value'    => 'v1',
									],
									[
										'setting'  => 'course_wescle_about_version',
										'operator' => '==',
										'value'    => 'v2',
									],
								],
								[
									'setting'  => 'course_wescle_about_version_image',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'course_wescle_sidebar_position'            => field_sidebar_aside_position(),
						'course_wescle_content_box_width'           => field_content_box_width( '' ),
						'course_wescle_sidebar_box_width'           => field_sidebar_box_width( 'course_wescle_sidebar_position' ),
						'course_wescle_blocks_hide'                 => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [ 'date', 'date_mod', 'comments' ],
							'choices' => Helper::choices_post_blocks_hide( [ 'media_icon' ], [
								'course_duration' => __( 'Продолжительность курса', 'wescle' ),
								'count_lessons'   => __( 'Количество уроков', 'wescle' ),
								'course_lang'     => __( 'Язык', 'wescle' ),
							] )
						],
						'course_navigation_enabled'                 => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать навигацию по курсу?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off()
						],
						'course_navigation_items'                   => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Пункты навигации', 'wescle' ),
							'fields'          => [
								'id'   => [
									'type'  => 'text',
									'label' => esc_html__( 'ID блока', 'wescle' ),
								],
								'text' => [
									'type'  => 'text',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							],
							'default'         => Helper::get_default_theme_data( 'course_navigation_items' ),
							'active_callback' => [
								[
									'setting'  => 'course_navigation_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'course_text_height'                        => [
							'type'    => 'number',
							'label'   => esc_html__( 'Высота видимой части блока с описанием', 'wescle' ) . ', px',
							'default' => 200,
						],
						'course_text_open'                          => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись на кнопке "Развернуть"', 'wescle' ),
							'default' => Helper::get_text_label( 'open' ),
						],
						'course_text_close'                         => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись на кнопке "Свернуть"', 'wescle' ),
							'default' => Helper::get_text_label( 'close' ),
						],
						'course_advantages_title'                   => [
							'type'    => 'text',
							'label'   => __( 'Заголовок для блока с преимуществами', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'course_advantages_title' ),
						],
						'course_tags_title'                         => [
							'type'    => 'text',
							'label'   => __( 'Заголовок для блока с навыками', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'course_tags_title' ),
						],
						'course_rating_enabled'                     => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить рейтинг для курса в комментариях?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off()
						],
						'course_wescle_block_related'               => [
							'type'        => 'number',
							'label'       => esc_html__( 'Количество похожих товаров', 'wescle' ),
							'description' => esc_html__( '0 - чтобы отключить, максимум 20', 'wescle' ),
							'default'     => 3,
						],
						'course_wescle_block_related_title'         => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок для блока "Похожие курсы"', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'course_block_related_title' ),
						]
					]
				],

				'catalog_section' => [
					'title'    => get_theme_mod( 'module_catalog_enabled' ) ? __( 'Настройка элемента каталога', 'wescle' ) : '',
					'controls' => [
						'catalog_item_about_version'       => field_post_header_version( [ 'v1', 'v2' ] ),
						'catalog_item_about_full_height'   => field_post_header_full_height( 'catalog_item' ),
						'catalog_item_sidebar_position'    => field_sidebar_aside_position(),
						'catalog_item_content_box_width'   => field_content_box_width( '' ),
						'catalog_item_sidebar_box_width'   => field_sidebar_box_width( 'catalog_item_sidebar_position' ),
						'catalog_item_blocks_hide'         => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [ 'date', 'date_mod', 'comments', 'author', 'read_in_min', 'views', 'author_info' ],
							'choices' => Helper::choices_post_blocks_hide( [ 'excerpt', 'category', 'media_icon' ] )
						],
						'catalog_navigation_enabled'       => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать липкую навигацию по странице?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off()
						],
						'catalog_navigation_items'         => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Пункты навигации', 'wescle' ),
							'fields'          => [
								'id'   => [
									'type'  => 'text',
									'label' => esc_html__( 'ID блока', 'wescle' ),
								],
								'text' => [
									'type'  => 'text',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							],
							'default'         => [],
							'active_callback' => [
								[
									'setting'  => 'catalog_navigation_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'catalog_item_block_related'       => [
							'type'        => 'number',
							'label'       => esc_html__( 'Количество похожих элементов', 'wescle' ),
							'description' => esc_html__( '0 - чтобы отключить, максимум 20', 'wescle' ),
							'default'     => 2,
						],
						'catalog_item_block_related_title' => [
							'type'  => 'text',
							'label' => esc_html__( 'Заголовок для блока "Похожие"', 'wescle' ),
						],
						'catalog_item_cf7_after_content'   => cf7_type_block( $label_select, esc_html__( 'Укажите форму для показа после контента', 'wescle' ) ),
					]
				],

				'main_banner' => [
					'title'    => __( 'Баннеры-слайды', 'wescle' ),
					'controls' => [
						'main_banner_slides_preview' => home_block_preview_img( 'block-woo-banners' ),
						'main_banner_slides_logic'   => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Слайды', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Слайд', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить слайд', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image'              => [
									'type'    => 'image',
									'label'   => __( 'Изображение', 'wescle' ),
									'choices' => array(
										'save_as' => 'id'
									),
								],
								'title'              => [
									'type'    => 'text',
									'label'   => esc_html__( 'Заголовок', 'wescle' ),
									'default' => '',
								],
								'text'               => [
									'type'    => 'textarea',
									'label'   => esc_html__( 'Текст', 'wescle' ),
									'default' => '',
								],
								'button_link'        => [
									'type'    => 'text',
									'label'   => esc_html__( 'Ссылка', 'wescle' ),
									'default' => '',
								],
								'target_blank'       => [
									'type'    => 'checkbox',
									'default' => true,
									'label'   => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
								],
								'button_text'        => [
									'type'    => 'text',
									'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
									'default' => __( 'Подробнее', 'wescle' ),
								],
								'price'              => [
									'type'    => 'text',
									'label'   => esc_html__( 'Цена', 'wescle' ),
									'default' => '',
								],
								'discount'           => [
									'type'    => 'text',
									'label'   => esc_html__( 'Скидка', 'wescle' ),
									'default' => '',
								],
								'bg_color'           => [
									'type'    => 'color',
									'label'   => esc_html__( 'Цвет фона', 'wescle' ),
									'choices' => [
										'alpha' => true,
									],
								],
								'banner_logic_items' => [
									'type'        => 'select',
									'label'       => esc_html__( 'На каких страницах отображать слайд?', 'wescle' ),
									'default'     => [],
									'multiple'    => 999,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts_banner_logic_items(),
								]
							],
							'selector'     => '.main-banner .container'
						]
					]
				]
			]
		],

		'archive_terms_tab' => [
			'title'    => __( 'Настройка категорий', 'wescle' ),
			'priority' => 61,

			'sections' => [
				'wp_cats'      => [
					'title'    => __( 'Настройка WP категорий', 'wescle' ),
					'controls' => [
						'sidebar_aside_position'    => field_sidebar_aside_position(),
						'archive_content_box_width' => field_content_box_width( '' ),
						'archive_sidebar_box_width' => field_sidebar_box_width( 'sidebar_aside_position' ),
						'archive_post_card_type'    => [
							'type'    => 'select',
							'label'   => esc_html__( 'Вид карточек постов', 'wescle' ),
							'default' => 'default',
							'choices' => choices_post_card_type(),
						],
						'archive_post_card_opacity' => [
							'type'            => 'slider',
							'label'           => esc_html__( 'Прозрачность затемнение', 'wescle' ),
							'default'         => 100,
							'choices'         => [
								'min'  => 10,
								'max'  => 100,
								'step' => 10,
							],
							'active_callback' => [
								[
									'setting'  => 'archive_post_card_type',
									'operator' => '==',
									'value'    => 'vertical',
								]
							]
						],
						'archive_blocks_hide'       => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите элементы, которые нужно спрятать', 'wescle' ),
							'default' => [],
							'choices' => Helper::choices_post_blocks_hide( [ 'media_icon', 'read_in_min', 'share', 'author_info' ] )
						],
					]
				],
				'video_cats'   => [
					'title'    => __( 'Настройка Видео категорий', 'wescle' ),
					'controls' => [
						'video_card_type' => [
							'type'    => 'select',
							'label'   => esc_html__( 'Вид карточек', 'wescle' ),
							'default' => 'default',
							'choices' => [
								'default' => 'Карточки с блока "Видео карусель"',
								'section' => 'Карточки с блока "Видео"',
							]
						]
					]
				],
				'catalog_cats' => [
					'title'    => get_theme_mod( 'module_catalog_enabled' ) ? __( 'Настройка категорий каталога', 'wescle' ) : '',
					'controls' => [
						'catalog_archive_sidebar_position'  => field_sidebar_aside_position( 'left' ),
						'catalog_archive_content_box_width' => field_content_box_width(),
						'catalog_archive_sidebar_box_width' => field_sidebar_box_width( 'catalog_archive_sidebar_position' ),
						'catalog_archive_three_in_row'      => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать 3 карточки в ряд?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'catalog_archive_show_map'          => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать карту с элементами каталога?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'catalog_archive_top_show_map'      => [
							'type'            => 'switch',
							'label'           => esc_html__( 'Показывать карту сверху?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'catalog_archive_show_map',
									'operator' => '==',
									'value'    => true,
								]
							],
						],

						'catalog_archive_show_button_map'  => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать кнопку с функционалом карты?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'catalog_archive_button_map_label' => [
							'type'            => 'text',
							'label'           => esc_html__( 'Надпись на кнопке', 'wescle' ),
							'default'         => __( 'Кнопка', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'catalog_archive_show_button_map',
									'operator' => '==',
									'value'    => true,
								]
							]
						],

						'catalog_archive_form_filters' => [
							'type'            => 'repeater',
							'label'           => esc_html__( 'Фильтры на странице с картой', 'wescle' ),
							'row_label'       => [
								'type'  => 'text',
								'value' => esc_html__( 'Фильтр', 'wescle' ),
							],
							'button_label'    => esc_html__( 'Добавить фильтр', 'wescle' ),
							'default'         => [],
							'fields'          => [
								'filter_taxonomy' => [
									'type'    => 'select',
									'choices' => Helper::get_catalog_filter_choices( $label_select )
								],
							],
							'active_callback' => [
								[
									'setting'  => 'catalog_archive_show_button_map',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
					]
				],
				'woo_cats'     => [
					'title'    => Helper::is_woocommerce_active() ? __( 'Настройка WooCommerce категорий', 'wescle' ) : '',
					'controls' => [
						'woo_archive_sidebar_position'  => field_sidebar_aside_position( 'left' ),
						'woo_archive_content_box_width' => field_content_box_width(),
						'woo_archive_sidebar_box_width' => field_sidebar_box_width( 'woo_archive_sidebar_position' ),
						'woo_archive_tags_enabled'      => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать карусель с метками?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'woo_archive_tags_count'        => [
							'type'            => 'number',
							'label'           => esc_html__( 'Количество меток на главной странице магазина', 'wescle' ),
							'default'         => 10,
							'active_callback' => [
								[
									'setting'  => 'woo_archive_tags_enabled',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'product_category_enabled'      => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать категории товара?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'product_name_short_remove'     => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Убрать ограничение названия товара в категориях?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'product_price_before_title'    => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать цену перед заголовком?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'product_stock_enabled'         => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать наличие товара?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'product_stock_position'        => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Где отображать?', 'wescle' ),
							'default' => 'before_title',
							'choices' => [
								'before_title' => __( 'Перед заголовком', 'wescle' ),
								'after_title'  => __( 'После заголовка', 'wescle' ),
								//'after_price'  => __( 'После цены', 'wescle' ),
							]
						],
						'product_rating_enabled'        => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать рейтинг товара?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'product_rating_position'       => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Где отображать?', 'wescle' ),
							'default' => 'before_title',
							'choices' => [
								'before_title' => __( 'Перед заголовком', 'wescle' ),
								'after_title'  => __( 'После заголовка', 'wescle' ),
								//'after_price'  => __( 'После цены', 'wescle' ),
							]
						],
						'product_sku_enabled'           => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать артикул товара?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'product_sku_label'             => [
							'type'            => 'text',
							'label'           => esc_html__( 'Надпись для артикула', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'product_sku_label' ),
							'active_callback' => [
								[
									'setting'  => 'product_sku_enabled',
									'operator' => '==',
									'value'    => true,
								]
							],
						],
						'product_sku_position'          => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Где отображать?', 'wescle' ),
							'default' => 'before_title',
							'choices' => [
								'before_title' => __( 'Перед заголовком', 'wescle' ),
								'after_title'  => __( 'После заголовка', 'wescle' ),
								'after_price'  => __( 'После цены', 'wescle' ),
							]
						],
					]
				]
			]
		],

		'settings_add_tab' => [
			'title'    => __( 'Дополнительные настройки', 'wescle' ),
			'priority' => 70,

			'sections' => [
				'addit_settings'       => [
					'title'    => __( 'Дополнительные настройки', 'wescle' ),
					'controls' => [
						'link_as_bg'             => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Выделять ссылки в контенте фоном?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'link_as_bg_text'        => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста ссылки', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'link_as_bg',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'link_as_bg_color'       => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона ссылки', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'link_as_bg',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'link_as_bg_text_hover'  => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста ссылки', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'link_as_bg',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'link_as_bg_color_hover' => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона ссылки', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'link_as_bg',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
					]
				],
				'button_section'       => [
					'title'    => __( 'Плавающие кнопки', 'wescle' ),
					'controls' => [
						'fixed_button_langs_enabled'    => [
							'type'    => ( function_exists( 'pll_the_languages' ) || function_exists( 'icl_object_id' ) ) ? 'switch' : '',
							'label'   => esc_html__( 'Показывать флаги?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'fixed_button_hide_link'        => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Спрятать ссылки от поисковиков, spam-ботов', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'fixed_button_tel_enabled'      => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать кнопку телефона', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'fixed_button_tel'              => [
							'type'        => 'tel',
							'label'       => esc_html__( 'Укажите телефон', 'wescle' ),
							'description' => esc_html__( 'по умолчанию используется "Основной телефон"', 'wescle' ),
							'selector'    => '.call-modals-buttons__wrap'
						],
						'fixed_button_email_enabled'    => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать кнопку email', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'fixed_button_email'            => [
							'type'        => 'email',
							'label'       => esc_html__( 'Укажите Е-mail', 'wescle' ),
							'description' => esc_html__( 'по умолчанию используется "Основной Е-mail"', 'wescle' ),
						],
						'fixed_button_others'           => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Дополнительные кнопки', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Кнопка', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить кнопку', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image'    => [
									'type'  => 'image',
									'label' => esc_html__( 'Изображение', 'wescle' ),
								],
								'url'      => [
									'type'  => 'text',
									'label' => esc_html__( 'Ссылка', 'wescle' ),
								],
								'is_blank' => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Открывать ссылку в новом окне?', 'wescle' ),
								]
							]
						],
						'fixed_button_sortable'         => [
							'type'    => 'sortable',
							'label'   => esc_html__( 'Порядок кнопок', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'fixed_button_sortable' ),
							'choices' => [
								'darkmode'      => esc_html__( 'Светлый \ Тёмный режим', 'wescle' ),
								'langs'         => esc_html__( 'Кнопки языка', 'wescle' ),
								'phone'         => esc_html__( 'Телефон', 'wescle' ),
								'email'         => esc_html__( 'Е-mail', 'wescle' ),
								'button_others' => esc_html__( 'Дополнительные кнопки', 'wescle' ),
							],
						],
						'fixed_button_position_label'   => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . __( 'Позиция блока с кнопками в %?', 'wescle' ) . '</h3>',
						],
						'fixed_button_scroll_up'        => [
							'type'    => 'radio',
							'label'   => '',
							'default' => 'center',
							'choices' => [
								'center' => __( 'По центру', 'wescle' ),
								'bottom' => __( 'Внизу', 'wescle' )
							],
						],
						'fixed_button_position_desktop' => [
							'type'    => 'slider',
							'label'   => esc_html__( 'на ПК (1280-1920)', 'wescle' ),
							'default' => 50,
							'choices' => [
								'min'  => 30,
								'max'  => 95,
								'step' => 5,
							],
						],
						'fixed_button_position_tablet'  => [
							'type'    => 'slider',
							'label'   => esc_html__( 'на планшете (768-1280)', 'wescle' ),
							'default' => 50,
							'choices' => [
								'min'  => 30,
								'max'  => 95,
								'step' => 5,
							],
						],
						'fixed_button_position_mobile'  => [
							'type'    => 'slider',
							'label'   => esc_html__( 'на телефоне (320-768)', 'wescle' ),
							'default' => 50,
							'choices' => [
								'min'  => 20,
								'max'  => 95,
								'step' => 5,
							],
						],
					]
				],
				'editor_classic'       => [
					'title'    => __( 'Классический редактор', 'wescle' ),
					'controls' => [
						'style_editor_classic' => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить стили для классического редактора?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
					]
				],
				'module_breadcrumb'    => [
					'title'    => __( 'Модуль "Хлебные крошки"', 'wescle' ),
					'controls' => [
						'module_breadcrumb_info'             => [
							'type'    => 'custom',
							'default' => esc_html__( 'Если установлен плагин "WP SEO by Yoast" и в нем активирован модуль "Хлебные крошки" - то идет настройка и вывод от плагина, иначе работают хлебные крошки от темы', 'wescle' ),
						],
						'module_breadcrumb_enabled'          => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить "Хлебные крошки"?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'module_breadcrumb_home_text'        => [
							'type'    => 'text',
							'label'   => esc_html__( 'Название для "Главной"', 'wescle' ),
							'default' => __( 'Главная', 'wescle' ),
						],
						'module_breadcrumb_show_single_link' => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Показывать последний элемент?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
					]
				],
				'module_counter_post'  => [
					'title'    => __( 'Модуль "Cчетчик просмотров"', 'wescle' ),
					'controls' => [
						'module_counter_post_enabled' => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Включить "Cчетчик просмотров"?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						]
					]
				],
				'module_share'         => [
					'title'    => __( 'Модуль "Поделиться"', 'wescle' ),
					'controls' => [
						'share_social_title'  => [
							'type'    => 'text',
							'label'   => esc_html__( 'Заголовок', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'share_social_title' )
						],
						'share_social_hide'   => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Выберите соц. сети, которые нужно спрятать', 'wescle' ),
							'default' => [],
							'choices' => Helper::choices_share_social()
						],
						'share_social_custom' => [
							'type'    => 'code',
							'label'   => esc_html__( 'Шорткод или кастомный код соц. сетей', 'wescle' ),
							'default' => ''
						],
					]
				],
				'module_toc'           => [
					'title'    => __( 'Модуль "Cодержание поста"', 'wescle' ),
					'controls' => [
						'toc_shortcode'        => [
							'type'  => 'custom',
							'label' => __( 'Для ручного добавление содержания используйте шорткод', 'wescle' ) . ': <code>[contents]</code>',
						],
						'toc_display'          => [
							'type'    => 'switch',
							'label'   => __( 'Автоматически показывать в записях', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'toc_display_pages'    => [
							'type'    => 'switch',
							'label'   => __( 'Атоматически показывать на страницах', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'toc_display_products' => [
							'type'    => 'switch',
							'label'   => __( 'Атоматически показывать в товарах', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'toc_open'             => [
							'type'    => 'switch',
							'label'   => __( 'По умолчанию блок открытый', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'toc_noindex'          => [
							'type'    => 'switch',
							'label'   => __( 'Обернуть содержание в noindex', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
						'toc_title'            => [
							'type'    => 'text',
							'label'   => __( 'Заголовок для блока с содержанием', 'wescle' ),
							'default' => __( 'Содержание', 'wescle' ),
						],
						'toc_headers'          => [
							'type'    => 'multicheck',
							'label'   => esc_html__( 'Уровни заголовков, по которым строится содержание', 'wescle' ),
							'default' => [ 'h2', 'h3' ],
							'choices' => [
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
							],
						],
						'toc_height_enabled'   => [
							'type'    => 'switch',
							'label'   => __( 'Ограничить высоту блока с содержанием?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'toc_height'           => [
							'type'            => 'number',
							'label'           => esc_html__( 'Высота видимой части', 'wescle' ),
							'default'         => 250,
							'active_callback' => [
								[
									'setting'  => 'toc_height_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'toc_label_open'       => [
							'type'            => 'text',
							'label'           => esc_html__( 'Надпись для разворачивания блока', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'home_seo_text_open' ),
							'active_callback' => [
								[
									'setting'  => 'toc_height_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'toc_label_close'      => [
							'type'            => 'text',
							'label'           => esc_html__( 'Надпись для сворачивания блока', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'home_seo_text_close' ),
							'active_callback' => [
								[
									'setting'  => 'toc_height_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
					]
				],
				'module_lightbox'      => [
					'title'    => __( 'Модуль "Лайтбокс"', 'wescle' ),
					'controls' => [
						'lightbox_enabled' => [
							'type'    => 'switch',
							'label'   => __( 'Использовать лайтбокс для картинок в контенте', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						]
					]
				],
				'module_schema'        => [
					'title'    => __( 'Модуль "Schema Organization"', 'wescle' ),
					'controls' => [
						'module_schema_enabled'        => [
							'type'    => 'switch',
							'label'   => __( 'Включить "Schema Organization"?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'module_schema_type'           => [
							'type'    => 'radio',
							'label'   => __( 'Тип web-сайта', 'wescle' ),
							'default' => 'Organization',
							'choices' => [
								'Organization' => __( 'Организация', 'wescle' ),
								'Person'       => __( 'Человек', 'wescle' ),
							],
						],
						'module_schema_name'           => [
							'type'  => 'text',
							'label' => __( 'Название', 'wescle' ),
						],
						'module_schema_url'            => [
							'type'    => 'text',
							'label'   => 'URL',
							'default' => home_url(),
						],
						'module_schema_logo'           => [
							'type'    => 'image',
							'label'   => __( 'Логотип', 'wescle' ),
							'choices' => array(
								'save_as' => 'array'
							),
						],
						'module_schema_social'         => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Социальные сети', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'URL соц. профиля', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить соц. профиль', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'button_link' => [
									'type'    => 'text',
									'label'   => esc_html__( 'Ссылка', 'wescle' ),
									'default' => '',
								]
							]
						],
						'module_schema_contact_custom' => [
							'type'  => 'custom',
							'label' => '<h3 class="section-subtitle" style="margin-top: 15px;">' . __( 'Служба поддержки', 'wescle' ) . '</h3>',
						],
						'module_schema_contact_type'   => [
							'type'    => 'select',
							'label'   => __( 'Тип контакта', 'wescle' ),
							'default' => 'customer_support',
							'choices' => [
								'customer_support'  => __( 'Служба поддержки', 'wescle' ),
								'technical_support' => __( 'Техподдержка', 'wescle' ),
								'billing_support'   => __( 'Поддержка биллинга', 'wescle' ),
								'bill_payment'      => __( 'Оплата счетов', 'wescle' ),
								'sales'             => __( 'Продажи', 'wescle' ),
								'reservations'      => __( 'Бронирование', 'wescle' ),
								'package_tracking'  => __( 'Отслеживание посылок', 'wescle' ),
							],
						],
						'module_schema_contact_tel'    => [
							'type'  => 'text',
							'label' => __( 'Телефон', 'wescle' ),
						],
						'module_schema_contact_url'    => [
							'type'        => 'text',
							'label'       => __( 'URL', 'wescle' ),
							'description' => __( 'URL-адрес страницы контактов', 'wescle' ),
						],
					]
				],
				'module_cookie_banner' => [
					'title'    => __( 'Модуль "Баннер куки"', 'wescle' ),
					'controls' => [
						'cookie_banner_enabled'      => [
							'type'     => 'switch',
							'label'    => __( 'Включить баннер куки?', 'wescle' ),
							'default'  => false,
							'choices'  => choices_on_off(),
							'selector' => '.coockies'
						],
						'cookie_banner_cookie_live'  => [
							'type'    => 'number',
							'label'   => esc_html__( 'Время жизни куки, дней', 'wescle' ),
							'default' => '30',
						],
						'cookie_banner_bg'           => [
							'type'    => 'color',
							'label'   => esc_html__( 'Цвет фона', 'wescle' ),
							'default' => '#0088cc',
							'choices' => [
								'alpha' => true,
							],
						],
						'cookie_banner_text'         => [
							'type'  => 'editor',
							'label' => esc_html__( 'Текст', 'wescle' ),
						],
						'cookie_banner_button_label' => [
							'type'    => 'text',
							'label'   => esc_html__( 'Надпись на кнопке', 'wescle' ),
							'default' => __( 'Закрыть', 'wescle' )
						],
					]
				],
				'module_multi_lang'    => [
					'title'    => 'WPML/Polylang',
					'controls' => [
						'module_multilang_enabled' => [
							'type'    => 'switch',
							'label'   => __( 'Показывать переключатель языка?', 'wescle' ),
							'default' => true,
							'choices' => choices_on_off(),
						],
					]
				],
				'module_last_modified' => [
					'title'       => __( 'Модуль "Last-Modified"', 'wescle' ),
					'description' => '<p>' . __( 'Если наблюдаются проблемы с загрузкой страницы или при обновление страницы F5 выдает белый экран-<strong>выключите</strong> модуль', 'wescle' ) . '</p>',
					'controls'    => [
						'module_last_modified_enabled' => [
							'type'    => 'switch',
							'label'   => __( 'Отдавать заголовок "304 Not Modified"?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
					]
				],
				'module_pagespeed'     => [
					'title'       => __( 'Модуль-настройка для "PageSpeed"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_pagespeed_jpeg_quality'           => [
							'type'        => 'slider',
							'label'       => __( 'Качество миниатюр', 'wescle' ),
							'description' => __( 'Чем выше число - тем качественнее изображение, больше вес, дольше грузится страница. Для пересоздания миниатюр используйте плагин: <a target="_blank" href="https://wordpress.org/plugins/regenerate-thumbnails/">Regenerate Thumbnails</a>', 'wescle' ),
							'default'     => 80,
							'choices'     => [
								'min'  => 60,
								'max'  => 95,
								'step' => 5,
							],
						],
						'module_pagespeed_jquery_in_footer'       => [
							'type'        => 'switch',
							'label'       => __( 'Переместить jQuery в footer?', 'wescle' ),
							'description' => __( 'Если на сайте ломается работа JS-скриптов - отключите эту настройку', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_font_preload'           => [
							'type'    => 'switch',
							'label'   => __( 'Использовать preload для шрифтов?', 'wescle' ),
							'default' => true,
							'choices' => choices_yes_no(),
						],
						'module_pagespeed_html_compression'       => [
							'type'    => 'switch',
							'label'   => __( 'Включить HTML минификацию?', 'wescle' ),
							'default' => true,
							'choices' => choices_yes_no(),
						],
						'module_pagespeed_combined_js'            => [
							'type'    => 'switch',
							'label'   => __( 'Объединить JS-скрипты в один файл?', 'wescle' ),
							'default' => true,
							'choices' => choices_yes_no(),
						],
						'module_pagespeed_defer_js'               => [
							'type'    => 'switch',
							'label'   => __( 'Добавить атрибут DEFER JS-скриптам?', 'wescle' ),
							'default' => false,
							'choices' => choices_yes_no(),
						],
						'module_pagespeed_combined_css'           => [
							'type'    => 'switch',
							'label'   => __( 'Объединить CSS в один файл?', 'wescle' ),
							'default' => true,
							'choices' => choices_yes_no(),
						],
						'module_pagespeed_disable_emojis'         => [
							'type'        => 'switch',
							'label'       => __( 'Отключить Emojis (эмоции)', 'wescle' ),
							'description' => esc_html__( 'Удаляет код Emojis из исходного кода страницы.', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_disable_rsd'            => [
							'type'        => 'switch',
							'label'       => esc_html__( 'Удалить RSD ссылку?', 'wescle' ),
							'description' => esc_html__( 'Удаляет тег ссылки RSD.', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_disable_wlwmanifest'    => [
							'type'        => 'switch',
							'label'       => esc_html__( 'Удалить wlwmanifest ссылку?', 'wescle' ),
							'description' => esc_html__( 'Удаляет тег link wlwmanifest (Windows Live Writer).', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_disable_xfn'            => [
							'type'        => 'switch',
							'label'       => esc_html__( 'Удалить профиль XFN?', 'wescle' ),
							'description' => __( 'Удаляет тег ссылки<br><code>link rel="profile" href="http://gmpg.org/xfn/11"</code>', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_disable_feed'           => [
							'type'        => 'switch',
							'label'       => esc_html__( 'Отключить RSS каналы?', 'wescle' ),
							'description' => esc_html__( 'Удаляет ссылку на RSS-канал из раздела <head>, закрывает и ставит перенаправления от всех RSS-каналов.', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_disable_rest_api'       => [
							'type'        => 'switch',
							'label'       => esc_html__( 'Отключить REST API?', 'wescle' ),
							'description' => esc_html__( 'Отключает REST API и удаляет все ссылки из раздела <head>.', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_disable_embeds'         => [
							'type'        => 'switch',
							'label'       => esc_html__( 'Отключить Embeds?', 'wescle' ),
							'description' => esc_html__( 'Удаляет JavaScript код отвечающий за встраиваемые объекты (wp-embed.min.js)', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_disable_shortlink'      => [
							'type'        => 'switch',
							'label'       => esc_html__( 'Удалить короткие ссылки?', 'wescle' ),
							'description' => __( 'Удаляет тег link shortlink.', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_disable_adjacent_links' => [
							'type'        => 'switch',
							'label'       => esc_html__( 'Удалить ссылки следующая, предыдущая запись?', 'wescle' ),
							'description' => __( 'Удаляет ссылки предыдущая и следующая запись в head вашей темы wordpress.', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_disable_meta_generator' => [
							'type'    => 'switch',
							'label'   => esc_html__( 'Убрать <meta name="generator"...>?', 'wescle' ),
							'default' => true,
							'choices' => choices_yes_no(),
						],
						'module_pagespeed_browser_caching'        => [
							'type'        => 'switch',
							'label'       => __( 'Использовать кеширование браузера (файл .htaccess)?', 'wescle' ),
							'description' => __( 'На сервере должен быть активирован модуль <strong>mod_expires</strong>', 'wescle' ),
							'default'     => true,
							'choices'     => choices_yes_no(),
						],
						'module_pagespeed_lazy_frame'             => [
							'type'        => 'switch',
							'label'       => __( 'Добавить к iframe атрибут <code>loading="lazy"</code>', 'wescle' ),
							'description' => __( 'Включать, если на сайте ранее были опубликованы посты с iframe.<br/>Если наблюдаются проблемы с выводом контента, "крякозябрики" - отключите эту настройку', 'wescle' ),
							'default'     => false,
							'choices'     => choices_yes_no(),
						],
					]
				],
				'module_seo'           => [
					'title'       => __( 'Модуль "SEO"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_seo_meta' => [
							'type'        => 'switch',
							'label'       => __( 'Выводить SEO метатеги от темы?', 'wescle' ),
							'description' => __( 'Если используете SEO плагин - отключите настройку', 'wescle' ),
							'default'     => true,
							'choices'     => choices_on_off(),
						],
					]
				],
				'module_robots'        => [
					'title'       => __( 'Модуль "Robots.txt"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_robots_text' => [
							'type'              => 'textarea',
							'label'             => __( 'Содержимое файла', 'wescle' ) . ' robots.txt',
							'default'           => get_content_robots_file(),
							'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
						],
					]
				],
				'module_popup'         => [
					'title'       => __( 'Модуль "Wescle Popup"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_popup_enabled' => [
							'type'    => 'switch',
							'label'   => __( 'Включить модальные окна от темы?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
					]
				],
				'module_widget_mess'   => [
					'title'       => __( 'Модуль "Виджет связи"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_mess_enabled'         => [
							'type'     => 'switch',
							'label'    => __( 'Включить виджет связи?', 'wescle' ),
							'default'  => false,
							'choices'  => choices_on_off(),
							'selector' => '.mess-widget__btn'
						],
						'module_mess_bottom'          => [
							'type'    => 'number',
							'label'   => esc_html__( 'Отступ виджета снизу в %', 'wescle' ),
							'default' => 5,
						],
						'module_mess_color'           => [
							'type'    => 'color',
							'label'   => esc_html__( 'Базовый цвет виджета', 'wescle' ),
							'choices' => [
								'alpha' => true,
							],
						],
						'module_mess_button_image'    => [
							'type'    => 'image',
							'label'   => __( 'Изображение на кнопке', 'wescle' ),
							'choices' => array(
								'save_as' => 'id'
							),
						],
						'module_mess_label'           => [
							'type'    => 'text',
							'label'   => __( 'Надпись на иконке', 'wescle' ),
							'default' => Helper::get_default_theme_data( 'module_mess_label' ),
						],
						'module_mess_manager_icon'    => [
							'type'    => 'image',
							'label'   => __( 'Иконка менеджера', 'wescle' ),
							'choices' => array(
								'save_as' => 'id'
							),
						],
						'module_mess_manager_name'    => [
							'type'  => 'text',
							'label' => __( 'Имя менеджера', 'wescle' ),
						],
						'module_mess_manager_subname' => [
							'type'  => 'text',
							'label' => __( 'Подзаголовок', 'wescle' ),
						],
						'module_mess_text'            => [
							'type'  => 'text',
							'label' => __( 'Вопрос призыв', 'wescle' ),
						],
						'module_mess_social'          => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Соц сети', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Соц сеть', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить соц сеть', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'mess_social_type'        => mess_social_type_block(),
								'mess_social_type_custom' => [
									'type'    => 'image',
									'label'   => __( 'Загрузить кастомную иконку', 'wescle' ),
									'choices' => array(
										'save_as' => 'id'
									),
								],
								'mess_social_url'         => [
									'type'  => 'text',
									'label' => esc_html__( 'URL', 'wescle' ),
								],
								'mess_social_is_blank'    => [
									'type'  => 'checkbox',
									'label' => esc_html__( 'Открывать ссылку в новом окне?', 'wescle' ),
								],
								'mess_social_title'       => [
									'type'  => 'text',
									'label' => esc_html__( 'Заголовок', 'wescle' ),
								],
								'mess_social_text'        => [
									'type'  => 'text',
									'label' => esc_html__( 'Подзаголовок', 'wescle' ),
								],
							]
						],
						'module_mess_messages'        => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Сообщения', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Сообщение', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить сообщение', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image' => [
									'type'    => 'image',
									'label'   => esc_html__( 'Изображение', 'wescle' ) . ', 30x30 px',
									'choices' => array(
										'save_as' => 'id'
									),
								],
								'text'  => [
									'type'  => 'textarea',
									'label' => esc_html__( 'Текст', 'wescle' ),
								],
							]
						],
						'module_mess_messages_speed'  => [
							'type'    => 'number',
							'label'   => __( 'Скорость анимации', 'wescle' ) . ', ms',
							'default' => Helper::get_default_theme_data( 'module_mess_messages_speed' ),
							'choices' => [
								'min'  => 100,
								'max'  => 10000,
								'step' => 100,
							],
						]
					]
				],

				'module_banner_shares' => [
					'title'       => __( 'Модуль "Баннер-таймер"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_banner_shares_enabled'     => [
							'type'     => 'switch',
							'label'    => __( 'Включить баннер-таймер?', 'wescle' ),
							'default'  => false,
							'choices'  => choices_on_off(),
							'selector' => '.banner-shares .container'
						],
						'module_banner_shares_timeout'     => [
							'type'    => 'number',
							'label'   => __( 'Через сколько секунд показывать баннер после загрузки страницы?', 'wescle' ),
							'default' => 0,
						],
						'module_banner_shares_cookie_live' => [
							'type'    => 'number',
							'label'   => esc_html__( 'Время жизни куки, дней', 'wescle' ),
							'default' => '1',
						],
						'banner_shares_color_bg1'          => [
							'type'  => 'color',
							'label' => esc_html__( 'Цвет фона', 'wescle' ) . ' #1',
						],
						'banner_shares_color_bg2'          => [
							'type'  => 'color',
							'label' => esc_html__( 'Цвет фона', 'wescle' ) . ' #2',
						],
						'banner_shares_color_bg3'          => [
							'type'  => 'color',
							'label' => esc_html__( 'Цвет фона', 'wescle' ) . ' #3',
						],
						'banner_shares_color_bg4'          => [
							'type'  => 'color',
							'label' => esc_html__( 'Цвет фона', 'wescle' ) . ' #4',
						],
						'banner_shares_color_text'         => [
							'type'  => 'color',
							'label' => esc_html__( 'Цвет текста', 'wescle' ),
						],
						'banner_shares_color_icon'         => [
							'type'  => 'color',
							'label' => esc_html__( 'Цвет иконки "Закрыть"', 'wescle' ),
						],
						'banner_shares_text_align'         => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Горизонтальное выравнивание текста', 'wescle' ),
							'default' => 'center',
							'choices' => [
								'left'   => __( 'по левому краю', 'wescle' ),
								'center' => __( 'по центру', 'wescle' ),
								'right'  => __( 'по правому краю', 'wescle' ),
							]
						],
						'banner_shares_slides_logic'       => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Баннера', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Баннер', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить баннер', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'title'       => [
									'type'  => 'text',
									'label' => __( 'Заголовок блока с таймером', 'wescle' ),
								],
								'type'        => [
									'type'    => 'radio',
									'label'   => esc_html__( 'Тип таймера', 'wescle' ),
									'default' => 'date',
									'choices' => [
										'date'  => esc_html__( 'По дате окончания', 'wescle' ),
										'hours' => esc_html__( 'Окончание через X часов с момента посещения', 'wescle' ),
									]
								],
								'date'        => [
									'type'            => 'date',
									'label'           => esc_html__( 'Дата окончания акции', 'wescle' ),
									'active_callback' => [
										[
											'setting'  => 'module_banner_shares_type',
											'operator' => '==',
											'value'    => 'date',
										]
									],
								],
								'hours'       => [
									'type'            => 'number',
									'label'           => esc_html__( 'Через сколько часов окончания акции?', 'wescle' ),
									'default'         => 10,
									'active_callback' => [
										[
											'setting'  => 'module_banner_shares_type',
											'operator' => '==',
											'value'    => 'hours',
										]
									],
								],
								'btn_text'    => [
									'type'  => 'text',
									'label' => __( 'Текст кнопки', 'wescle' ),
								],
								'btn_url'     => [
									'type'  => 'url',
									'label' => __( 'URL кнопки', 'wescle' ),
								],
								'text'        => [
									'type'  => 'textarea',
									'label' => __( 'Текст на втором слайде', 'wescle' ),
								],
								'logic_items' => [
									'type'        => 'select',
									'label'       => esc_html__( 'На каких страницах отображать баннер?', 'wescle' ),
									'default'     => [],
									'multiple'    => 999,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts_and_category(),
								],
							],
							'selector'     => '.top-banner .container'
						],
					]
				],

				'module_dark_mode' => [
					'title'       => __( 'Модуль "Светлый \ Тёмный режим"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_dark_mode_enabled' => [
							'type'     => 'switch',
							'label'    => __( 'Отображать переключатель?', 'wescle' ),
							'default'  => false,
							'choices'  => choices_on_off(),
							'selector' => '.color-scheme-toggle'
						],
						'module_dark_mode_scheme'  => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Цветовая схема по умолчанию', 'wescle' ),
							'default' => 'light',
							'choices' => [
								'light' => esc_html__( 'Светлая', 'wescle' ),
								'dark'  => esc_html__( 'Темная', 'wescle' ),
							]
						],
						'module_dark_mode_auto'    => [
							'type'    => 'switch',
							'label'   => __( 'Автоматическое переключение от стиля системы?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
					]
				],

				'module_annotation' => [
					'title'       => __( 'Модуль "Аннотации"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_annotation_enabled' => [
							'type'     => 'switch',
							'label'    => __( 'Включить аннотации?', 'wescle' ),
							'default'  => false,
							'choices'  => choices_on_off(),
							'selector' => '.btn-annotation'
						]
					]
				],

				'module_hidden_element' => [
					'title'       => __( 'Модуль "Найди спрятанный элемент"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_hidden_element_enabled' => [
							'type'    => 'switch',
							'label'   => __( 'Включить модуль?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'hidden_element_items'          => [
							'type'         => 'repeater',
							'label'        => esc_html__( 'Элементы', 'wescle' ),
							'row_label'    => [
								'type'  => 'text',
								'value' => esc_html__( 'Элемент', 'wescle' ),
							],
							'button_label' => esc_html__( 'Добавить элемент', 'wescle' ),
							'default'      => [],
							'fields'       => [
								'image'                   => [
									'type'    => 'image',
									'label'   => esc_html__( 'Иконка элемента', 'wescle' ),
									'choices' => [
										'save_as' => 'id',
									],
								],
								'opacity'                 => [
									'type'    => 'number',
									'label'   => esc_html__( 'Прозрачность', 'wescle' ) . ', %',
									'default' => 50,
									'choices' => [
										'min'  => 0,
										'max'  => 100,
										'step' => 5,
									],
								],
								'width'                   => [
									'type'    => 'number',
									'label'   => esc_html__( 'Ширина иконки', 'wescle' ) . ', px',
									'default' => 30,
								],
								'height'                  => [
									'type'    => 'number',
									'label'   => esc_html__( 'Высота иконки', 'wescle' ) . ', px',
									'default' => 30,
								],
								'button_link'             => [
									'type'    => 'text',
									'label'   => esc_html__( 'Ссылка', 'wescle' ),
									'default' => '',
								],
								'target_blank'            => [
									'type'    => 'checkbox',
									'default' => true,
									'label'   => esc_html__( 'Открыть в новой вкладке?', 'wescle' ),
								],
								'position_label'          => [
									'type'  => 'custom',
									'label' => esc_html__( 'Позиция элемента на странице', 'wescle' ) . ', %',
								],
								'position_left'           => [
									'type'  => 'number',
									'label' => esc_html__( 'Слева', 'wescle' ),
								],
								'position_top'            => [
									'type'  => 'number',
									'label' => esc_html__( 'Сверху', 'wescle' ),
								],
								'block_selector'          => [
									'type'        => 'text',
									'label'       => esc_html__( 'ИЛИ укажите класс или ID блока на странице', 'wescle' ),
									'description' => __( '* например: <code>#footer</code> или <code>.about</code>', 'wescle' ),
								],
								'selector_position_label' => [
									'type'  => 'custom',
									'label' => esc_html__( 'Позиция элемента относительно блока', 'wescle' ),
								],
								'selector_position_left'  => [
									'type'        => 'text',
									'label'       => esc_html__( 'Слева', 'wescle' ),
									'description' => __( '* например: <code>5%</code> или <code>10px</code>', 'wescle' ),
								],
								'selector_position_top'   => [
									'type'        => 'text',
									'label'       => esc_html__( 'Сверху', 'wescle' ),
									'description' => __( '* например: <code>5%</code> или <code>10px</code>', 'wescle' ),
								],
								'logic_items'             => [
									'type'        => 'select',
									'label'       => esc_html__( 'На каких страницах отображать элемент?', 'wescle' ),
									'default'     => [],
									'multiple'    => 999,
									'isClearable' => true,
									'placeholder' => $label_select,
									'choices'     => Helper::get_posts_and_category(),
								]
							],
						]
					]
				],

				'module_highlight_code' => [
					'title'       => __( 'Модуль "Подсветка кода"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'highlight_code'         => [
							'type'    => 'switch',
							'label'   => __( 'Включить модуль?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'module_course_info'     => [
							'type'  => 'custom',
							'label' => '<div class="notice notice-info section-description">' .
							           __( 'Для отображения блока с кодом нужно добавить в редакторе html-блок c тегом', 'wescle' ) . '<br><code>&lt;code&gt;&lt;!-- /* ' . __( 'здесь ваш код', 'wescle' ) . ' */ --&gt;&lt;/code&gt;</code>' .
							           '<br>' .
							           __( 'Также можно указать язык блока', 'wescle' ) . '<br><code>&lt;code lang="js"&gt;&lt;!-- /* js code */ --&gt;&lt;/code&gt;</code>' .
							           '</div>',
						],
						'highlight_code_default' => [
							'type'    => 'select',
							'label'   => esc_html__( 'Язык блока по умолчанию', 'wescle' ),
							'default' => 'html',
							'choices' => Helper::get_highlight_language()
						],
						'highlight_code_theme'   => [
							'type'    => 'radio',
							'label'   => esc_html__( 'Стиль блока с кодом', 'wescle' ),
							'default' => 'white',
							'choices' => [
								'white' => esc_html__( 'Светлый', 'wescle' ),
								'black' => esc_html__( 'Темный', 'wescle' ),
							],
						]
					]
				],

				/*'module_course' => [
					'title'       => __( 'Модуль "Курсы"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_course_enabled' => [
							'type'    => 'switch',
							'label'   => __( 'Включить раздел с курсами?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'module_course_info'    => [
							'type'  => 'custom',
							'label' => __( 'После включения - сохраните настройки и перезагрузите страницу', 'wescle' ),
						],
						'module_course_info3'   => [
							'type'            => 'custom',
							'default'         => '<div class="notice notice-info section-description">' . sprintf( __( 'Вы можете вывести общую страницу с категориями, метками и курсами, для этого создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Courses".', 'wescle' ), admin_url( '/post-new.php?post_type=page' ) ) . '</div>',
							'active_callback' => [
								[
									'setting'  => 'module_course_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'course_all_tags_title' => [
							'type'            => 'text',
							'label'           => __( 'Заголовок для блока с метками', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'course_all_tags_title' ),
							'active_callback' => [
								[
									'setting'  => 'module_course_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						]
					]
				],
				*/

				'module_catalog' => [
					'title'       => __( 'Модуль "Каталог"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_catalog_enabled'             => [
							'type'    => 'switch',
							'label'   => __( 'Включить раздел с кастомным каталогом?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'module_catalog_item_public'         => [
							'type'            => 'switch',
							'label'           => __( 'Включить ссылки на элементы каталога?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_info'                => [
							'type'  => 'custom',
							'label' => __( 'После включения - сохраните настройки и перезагрузите страницу', 'wescle' ),
						],
						'google_map_api_key'                 => [
							'type'            => 'text',
							'label'           => esc_html__( 'Google Map API key', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_gallery_enabled'     => [
							'type'            => 'switch',
							'label'           => __( 'Включить галерею изображений в карточках каталога?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_gallery_count'       => [
							'type'            => 'number',
							'label'           => __( 'Количество изображений в слайдере в карточках каталога?', 'wescle' ),
							'default'         => 3,
							'active_callback' => [
								[
									'setting'  => 'module_catalog_gallery_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_labels'              => [
							'type'            => 'custom',
							'default'         => '<h3 class="section-subtitle">' . __( 'Надписи в админке', 'wescle' ) . '</h3>',
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_post_name'           => [
							'type'            => 'text',
							'label'           => esc_html__( 'Название раздела', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'module_catalog_post_name' ),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_singular_name'       => [
							'type'            => 'text',
							'label'           => esc_html__( 'Название элемента каталога', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'module_catalog_singular_name' ),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_tax_name'            => [
							'type'            => 'text',
							'label'           => esc_html__( 'Название категорий каталога', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'module_catalog_tax_name' ),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_tax_singular_name'   => [
							'type'            => 'text',
							'label'           => esc_html__( 'Название одной категории каталога', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'module_catalog_tax_singular_name' ),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_item_bg_category'    => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет фона категории', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_item_color_category' => [
							'type'            => 'color',
							'label'           => esc_html__( 'Цвет текста категории', 'wescle' ),
							'choices'         => [
								'alpha' => true,
							],
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_thumb_size'          => [
							'type'            => 'number',
							'label'           => esc_html__( 'Размер миниатюры', 'wescle' ) . ', %',
							'default'         => 100,
							'choices'         => [
								'max' => 100
							],
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_img_size'            => [
							'type'            => 'number',
							'label'           => esc_html__( 'Размер иконки в блоке "Характеристики"', 'wescle' ) . ', px',
							'default'         => 20,
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_info_img_size'       => [
							'type'            => 'number',
							'label'           => esc_html__( 'Размер иконок с раздела "Инфо-блоки"', 'wescle' ) . ', px',
							'default'         => 24,
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_stock'               => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . esc_html__( 'Управление запасами, статусы', 'wescle' ) . '</h3>',
						],
						'module_catalog_stock_enabled'       => [
							'type'            => 'switch',
							'label'           => __( 'Включить статусы?', 'wescle' ),
							'default'         => true,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_min_stock'           => [
							'type'            => 'number',
							'label'           => esc_html__( 'Граница малых запасов', 'wescle' ),
							'default'         => 2,
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_label_instock'       => [
							'type'            => 'text',
							'label'           => esc_html__( 'Надпись для статуса "В наличии"', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'module_catalog_label_instock' ),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_label_outofstock'    => [
							'type'            => 'text',
							'label'           => esc_html__( 'Надпись для статуса "Нет в наличии"', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'module_catalog_label_outofstock' ),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_catalog_label_minstock'      => [
							'type'            => 'text',
							'label'           => esc_html__( 'Надпись для статуса "Заканчивается"', 'wescle' ),
							'default'         => Helper::get_default_theme_data( 'module_catalog_label_minstock' ),
							'active_callback' => [
								[
									'setting'  => 'module_catalog_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],

						'module_catalog_currency_info'         => [
							'type'    => 'custom',
							'default' => '<h3 class="section-subtitle">' . esc_html__( 'Настройки валюты', 'wescle' ) . '</h3>',
						],
						'module_catalog_currency'              => [
							'type'              => 'text',
							'label'             => esc_html__( 'Валюта', 'wescle' ),
							'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
						],
						'module_catalog_currency_pos'          => [
							'type'    => 'select',
							'label'   => esc_html__( 'Позиция символа', 'wescle' ),
							'default' => 'right',
							'choices' => [
								'left'  => __( 'Слева', 'wescle' ),
								'right' => __( 'Справа', 'wescle' ),
							],
						],
						'module_catalog_currency_thousand_sep' => [
							'type'  => 'text',
							'label' => esc_html__( 'Разделитель тысяч', 'wescle' ),
						],
						'module_catalog_currency_decimal_sep'  => [
							'type'    => 'text',
							'label'   => esc_html__( 'Десятичный разделитель', 'wescle' ),
							'default' => '.',
						],
						'module_catalog_currency_decimals'     => [
							'type'    => 'number',
							'label'   => esc_html__( 'Число дробных знаков', 'wescle' ),
							'default' => 0,
						],

					]
				],

				'module_cursor' => [
					'title'       => __( 'Модуль "Курсор"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'cursor_image'        => [
							'type'            => 'image',
							'label'           => __( 'Изображение курсора', 'wescle' ),
							'description'     => esc_html__( 'рекомендуемые размеры', 'wescle' ) . ', px: 32х32',
							'choices'         => [
								'save_as' => 'id',
							],
							'active_callback' => [
								[
									'setting'  => 'cursor_ball_enabled',
									'operator' => '==',
									'value'    => false,
								],
								[
									'setting'  => 'cursor_text_enabled',
									'operator' => '==',
									'value'    => false,
								]
							]
						],
						'cursor_image_x'      => [
							'type'            => 'number',
							'label'           => __( 'Смещение по оси', 'wescle' ) . ' Х',
							'default'         => 0,
							'choices'         => [
								'min'  => 0,
								'max'  => 32,
								'step' => 1,
							],
							'active_callback' => [
								[
									'setting'  => 'cursor_ball_enabled',
									'operator' => '==',
									'value'    => false,
								],
								[
									'setting'  => 'cursor_text_enabled',
									'operator' => '==',
									'value'    => false,
								]
							]
						],
						'cursor_image_y'      => [
							'type'            => 'number',
							'label'           => __( 'Смещение по оси', 'wescle' ) . ' Y',
							'default'         => 0,
							'choices'         => [
								'min'  => 0,
								'max'  => 32,
								'step' => 1,
							],
							'active_callback' => [
								[
									'setting'  => 'cursor_ball_enabled',
									'operator' => '==',
									'value'    => false,
								],
								[
									'setting'  => 'cursor_text_enabled',
									'operator' => '==',
									'value'    => false,
								]
							]
						],
						'cursor_ball_enabled' => [
							'type'            => 'switch',
							'label'           => __( 'Включить курсор-шар?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'cursor_text_enabled',
									'operator' => '==',
									'value'    => false,
								]
							]
						],
						'cursor_ball_x'       => [
							'type'            => 'number',
							'label'           => __( 'Смещение по оси', 'wescle' ) . ' Х, %',
							'default'         => - 50,
							'active_callback' => [
								[
									'setting'  => 'cursor_ball_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'cursor_ball_y'       => [
							'type'            => 'number',
							'label'           => __( 'Смещение по оси', 'wescle' ) . ' Y, %',
							'default'         => - 50,
							'active_callback' => [
								[
									'setting'  => 'cursor_ball_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'cursor_ball_bg'      => [
							'type'            => 'color',
							'label'           => __( 'Цвет фона', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'cursor_ball_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'cursor_ball_image'   => [
							'type'            => 'image',
							'label'           => __( 'Изображение в шаре', 'wescle' ),
							'description'     => esc_html__( 'рекомендуемые размеры', 'wescle' ) . ', px: 32х32',
							'choices'         => [
								'save_as' => 'id',
							],
							'active_callback' => [
								[
									'setting'  => 'cursor_ball_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'cursor_ball_puls'    => [
							'type'            => 'switch',
							'label'           => __( 'Включить пульсацию шара?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'cursor_ball_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'cursor_text_enabled' => [
							'type'            => 'switch',
							'label'           => __( 'Включить курсор-текст?', 'wescle' ),
							'default'         => false,
							'choices'         => choices_on_off(),
							'active_callback' => [
								[
									'setting'  => 'cursor_ball_enabled',
									'operator' => '==',
									'value'    => false,
								]
							]
						],
						'cursor_text_value'   => [
							'type'            => 'text',
							'label'           => __( 'Текст возле курсора', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'cursor_text_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'cursor_text_bg'      => [
							'type'            => 'color',
							'label'           => __( 'Цвет фона', 'wescle' ),
							'active_callback' => [
								[
									'setting'  => 'cursor_text_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
					]
				],

				'module_qr' => [
					'title'       => __( 'Модуль "QR"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_qr_enabled' => [
							'type'    => 'switch',
							'label'   => __( 'Включить модуль?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'module_qr_info'    => [
							'type'  => 'custom',
							'label' => '<div class="notice notice-info section-description">' .
							           __( 'Для отображения qr-кода используйте шорткод', 'wescle' ) . ': <code>[wescle_qr]</code>' .
							           '</div>',
						],
						'module_qr_color'   => [
							'type'  => 'color',
							'label' => __( 'Цвет QR кода', 'wescle' ),
						],
						'module_qr_bg'      => [
							'type'  => 'color',
							'label' => __( 'Цвет фона', 'wescle' ),
						],
						'module_qr_width'   => [
							'type'  => 'number',
							'label' => __( 'Размеры QR кода', 'wescle' ) . ', px',
							'default' => 160,
							'choices' => [
								'min'  => 60,
								'step' => 2,
							],
						],
						'module_qr_info2'    => [
							'type'  => 'custom',
							'label' => '<div class="notice notice-warning section-description">' .
							           __( 'Если желаете добавить шорткод в любую область на странице и кастомизировать, используйте такую вариацию', 'wescle' ) . ': <code>[wescle_qr color="#000000" bg="#ffffff" width="150"]</code>' .
							           '</div>',
						]
					]
				],
				
				'module_preloader' => [
					'title'       => __( 'Модуль "Preloader"', 'wescle' ),
					'description' => '',
					'controls'    => [
						'module_preloader_enabled' => [
							'type'    => 'switch',
							'label'   => __( 'Включить модуль?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'module_preloader_color_light'   => [
							'type'  => 'color',
							'label' => __( 'Светлый цвет фона', 'wescle' ),
						],
						'module_preloader_color_dark'   => [
							'type'  => 'color',
							'label' => __( 'Темный цвет фона', 'wescle' ),
						],
						'module_preloader_bg_light'   => [
							'type'    => 'image',
							'label'   => __( 'Фоновое изображение для светлой темы', 'wescle' ),
							'default' => false,
							'choices'  => [
								'save_as' => 'id',
							],
						],
						'module_preloader_bg_dark'   => [
							'type'    => 'image',
							'label'   => __( 'Фоновое изображение для тёмной темы', 'wescle' ),
							'default' => false,
							'choices'  => [
								'save_as' => 'id',
							],
						],
						'module_preloader_logo_enabled'   => [
							'type'    => 'switch',
							'label'   => __( 'Показывать лого?', 'wescle' ),
							'default' => false,
							'choices' => choices_on_off(),
						],
						'module_preloader_logo'   => [
							'type'    => 'image',
							'label'   => __( 'Логотип', 'wescle' ),
							'default' => false,
							'choices'  => [
								'save_as' => 'id',
							],
							'active_callback' => [
								[
									'setting'  => 'module_preloader_logo_enabled',
									'operator' => '==',
									'value'    => true,
								]
							]
						],
						'module_preloader_animation'   => [
							'type'    => 'select',
							'label'   => __( 'Вид анимации', 'wescle' ),
							'default' => 1,
							'choices'  => [
								1 => '1',
								2 => '2',
								3 => '3',
								4 => '4',
								5 => '5',
								6 => '6',
								7 => '7',
								8 => '8',
								9 => '9',
								10 => '10',
							],
						],
						'module_preloader_custom_image'   => [
							'type'    => 'image',
							'label'   => __( 'Кастомное изображение', 'wescle' ),
							'default' => false,
							'choices'  => [
								'save_as' => 'id',
							],
						],
					]
				]

			]
		],

		'reklama_tab' => [
			'title'    => __( 'Рекламные блоки', 'wescle' ),
			'priority' => 9990,

			'sections' => [
				'reklama_sidebar_section' => [
					'title'    => __( 'Сайдбар', 'wescle' ),
					'controls' => [
						'reklama_sidebar_top'    => [
							'type'    => 'code',
							'label'   => __( 'Код над виджетами', 'wescle' ),
							'default' => '',
						],
						'reklama_sidebar_bottom' => [
							'type'    => 'code',
							'label'   => __( 'Код под виджетами', 'wescle' ),
							'default' => '',
						],
					]
				],
				'reklama_home_section'    => [
					'title'    => __( 'На главной странице', 'wescle' ),
					'controls' => [
						'reklama_home_after_promo' => [
							'type'    => 'code',
							'label'   => __( 'После промо блока', 'wescle' ),
							'default' => '',
						],
					]
				],
				'reklama_archive_section' => [
					'title'    => __( 'На страницах рубрик/автора/поиска', 'wescle' ),
					'controls' => [
						'reklama_archive_before_content' => [
							'type'    => 'code',
							'label'   => __( 'Перед контентом', 'wescle' ),
							'default' => '',
						],
						'reklama_archive_after_content'  => [
							'type'    => 'code',
							'label'   => __( 'После контента', 'wescle' ),
							'default' => '',
						],
					]
				],
				'reklama_post'            => [
					'title'    => __( 'Для всех записей', 'wescle' ),
					'controls' => [
						'module_adsense_post_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_post_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_post_after_content'    => [
							'type'  => 'code',
							'label' => __( 'Код после контента', 'wescle' ),
						],
						'module_adsense_post_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
						'module_adsense_post_after_author'     => [
							'type'  => 'code',
							'label' => __( 'Код после "Блок автора"', 'wescle' ),
						],
						'module_adsense_post_before_related'   => [
							'type'  => 'code',
							'label' => __( 'Код перед блоком "Похожие записи"', 'wescle' ),
						],
					]
				],
				'reklama_service'         => [
					'title'    => __( 'Для всех услуг', 'wescle' ),
					'controls' => [
						'module_adsense_service_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_service_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_service_after_content'    => [
							'type'  => 'code',
							'label' => __( 'Код после контента', 'wescle' ),
						],
						'module_adsense_service_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
						'module_adsense_service_before_related'   => [
							'type'  => 'code',
							'label' => __( 'Код перед блоком "Похожие услуги"', 'wescle' ),
						],
					]
				],
				'reklama_portfolio'       => [
					'title'    => __( 'Для всех портфолио-работ', 'wescle' ),
					'controls' => [
						'module_adsense_portfolio_wescle_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_portfolio_wescle_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_portfolio_wescle_after_content'    => [
							'type'  => 'code',
							'label' => __( 'Код после контента', 'wescle' ),
						],
						'module_adsense_portfolio_wescle_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
						'module_adsense_portfolio_wescle_before_related'   => [
							'type'  => 'code',
							'label' => __( 'Код перед блоком "Похожие портфолио"', 'wescle' ),
						],
					]
				],
				'reklama_event'           => [
					'title'    => __( 'Для всех мероприятий', 'wescle' ),
					'controls' => [
						'module_adsense_event_wescle_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_event_wescle_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_event_wescle_after_content'    => [
							'type'  => 'code',
							'label' => __( 'Код после контента', 'wescle' ),
						],
						'module_adsense_event_wescle_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
						'module_adsense_event_wescle_before_related'   => [
							'type'  => 'code',
							'label' => __( 'Код перед блоком "Похожие мероприятия"', 'wescle' ),
						],
					]
				],
				'reklama_videowescle'     => [
					'title'    => __( 'Для всех видео', 'wescle' ) . '-wescle',
					'controls' => [
						'module_adsense_video_wescle_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_video_wescle_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_video_wescle_after_content'    => [
							'type'  => 'code',
							'label' => __( 'Код после контента', 'wescle' ),
						],
						'module_adsense_video_wescle_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
						'module_adsense_video_wescle_before_related'   => [
							'type'  => 'code',
							'label' => __( 'Код перед блоком "Похожие видео"', 'wescle' ),
						],
					]
				],
				'reklama_teamwescle'      => [
					'title'    => __( 'Для всех team', 'wescle' ) . '-wescle',
					'controls' => [
						'module_adsense_team_wescle_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_team_wescle_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_team_wescle_after_content'    => [
							'type'  => 'code',
							'label' => __( 'Код после контента', 'wescle' ),
						],
						'module_adsense_team_wescle_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
						'module_adsense_team_wescle_before_related'   => [
							'type'  => 'code',
							'label' => __( 'Код перед блоком "Похожие"', 'wescle' ),
						],
					]
				],
				'reklama_prodwescle'      => [
					'title'    => __( 'Для всех товаров', 'wescle' ) . '-wescle',
					'controls' => [
						'module_adsense_product_wescle_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_product_wescle_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_product_wescle_after_content'    => [
							'type'  => 'code',
							'label' => __( 'Код после контента', 'wescle' ),
						],
						'module_adsense_product_wescle_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
						'module_adsense_product_wescle_before_related'   => [
							'type'  => 'code',
							'label' => __( 'Код перед блоком "Похожие товары"', 'wescle' ),
						],
					]
				],
				'reklama_prodwoo'         => [
					'title'    => Helper::is_woocommerce_active() ? __( 'Для всех товаров', 'wescle' ) . '-woocommerce' : '',
					'controls' => [
						'module_adsense_product_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_product_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_product_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
						'module_adsense_product_before_related'   => [
							'type'  => 'code',
							'label' => __( 'Код перед блоком "Похожие товары"', 'wescle' ),
						],
					]
				],
				'reklama_coursewescle'    => [
					'title'    => get_theme_mod( 'module_course_enabled' ) ? __( 'Для всех курсов', 'wescle' ) : '',
					'controls' => [
						'module_adsense_course_wescle_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_course_wescle_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_course_wescle_after_content'    => [
							'type'  => 'code',
							'label' => __( 'Код после контента', 'wescle' ),
						],
						'module_adsense_course_wescle_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
						'module_adsense_course_wescle_before_related'   => [
							'type'  => 'code',
							'label' => __( 'Код перед блоком "Похожие курсы"', 'wescle' ),
						],
					]
				],
				'reklama_coursewescle'    => [
					'title'    => get_theme_mod( 'module_catalog_enabled' ) ? __( 'Для всех элементов каталога', 'wescle' ) : '',
					'controls' => [
						'module_adsense_catalog_item_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_catalog_item_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_catalog_item_after_content'    => [
							'type'  => 'code',
							'label' => __( 'Код после контента', 'wescle' ),
						],
						'module_adsense_catalog_item_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
						'module_adsense_catalog_item_before_related'   => [
							'type'  => 'code',
							'label' => __( 'Код перед блоком "Похожие курсы"', 'wescle' ),
						],
					]
				],
				'reklama_page'            => [
					'title'    => __( 'Для всех страниц', 'wescle' ),
					'controls' => [
						'module_adsense_page_after_breadcrumb' => [
							'type'  => 'code',
							'label' => __( 'Код после хлебных крошек', 'wescle' ),
						],
						'module_adsense_page_before_content'   => [
							'type'  => 'code',
							'label' => __( 'Код перед контентом', 'wescle' ),
						],
						'module_adsense_page_after_content'    => [
							'type'  => 'code',
							'label' => __( 'Код после контента', 'wescle' ),
						],
						'module_adsense_page_after_share'      => [
							'type'  => 'code',
							'label' => __( 'Код после блока "Поделиться"', 'wescle' ),
						],
					]
				],
			]
		],

		'partner' => [
			'title'       => __( 'Партнерская программа', 'wescle' ),
			'description' =>
				'<p>' . sprintf( __( 'Зарабатывайте деньги с <a href="%s" target="_blank" rel="noopener">партнерской программой</a> Wescle.', 'wescle' ), 'https://wescle.com/account/partner-area/' ) . '</p>' .
				'<p>' . __( 'Включите партнерскую программу в 1 клик. Получайте % с каждой продажи темы и дополнительных услуг от приведенных вами клиентов.', 'wescle' ) . '</p>' .
				'<p>' . sprintf( __( 'Ваш ID партнера уже встроен в системе, и при переходе по ссылке в футере, передаются данные о посещении в ваш аккаунт партнера на <a href="%s" target="_blank" rel="noopener">нашем сайте</a>.', 'wescle' ), 'https://wescle.com/account/' ) . '</p>',
			'priority'    => 9991,
			'controls'    => [
				'partner_enable'    => [
					'type'    => 'switch',
					'label'   => __( 'Начать зарабатывать деньги', 'wescle' ),
					'default' => true,
					'choices' => choices_on_off(),
				],
				'partner_prefix'    => [
					'type'    => 'text',
					'label'   => __( 'Текст перед ссылкой', 'wescle' ),
					'default' => __( 'Работает на теме', 'wescle' ),
				],
				'partner_postfix'   => [
					'type'  => 'text',
					'label' => __( 'Текст после ссылки', 'wescle' ),
				],
				'partner_id'        => [
					'type'  => 'custom',
					'label' => '<hr>' . __( 'Ваш уникальный ID партнера:', 'wescle' ) . ' <code>' . WsclPartnerShip::get_partner_id() . '</code>',
				],
				'partner_copy_link' => [
					'type'  => 'custom',
					'label' => __( 'Партнерская ссылка:', 'wescle' ) . ' <div class="partner_copy_link"><input type="text" value="' . WsclPartnerShip::prepare_link() . '" id="PartnerLinkInput" class="input"><button type="button" id="PartnerLinkButton" class="button">' . __( 'Копировать', 'wescle' ) . '</button></div> ',
				],
			],
		],
		/*
		'support' => [
			'title'       => __( 'Служба поддержки', 'wescle' ),
			'description' =>
				'<p>' . __( 'Нужна помощь в настройке темы или вам необходимо сделать доработку на сайте? Напишите нам в поддержку, поможем вам', 'wescle' ) . '</p>' .
				'<p>' . sprintf( __( 'Войдите в свой аккаунт на сайте <a href="%s" target="_blank" rel="noopener"> wescle.com</a>, в разделе "Служба поддержки" создайте тикет с темой "Доработка функционала"', 'wescle' ), 'https://wescle.com/dashboard/' ) . '</p>' .
				'<p><strong>' . __( 'Рабочее время', 'wescle' ) . ' *</strong></p>' .
				'<p style="margin-top: -10px;">' . __( 'с 10.00 до 18.00 (с пн.- пт.)', 'wescle' ) . '</p>' .
				'<p>*' . __( 'в случае возникновения срочных вопросов вне рабочего времени, Вы можете создать тикет с пометкой "срочно", и наши доступные специалисты ответят и помогут решить вопрос как можно скорее.', 'wescle' ) . '</p>',
			'priority'    => 9992,
			'controls'    => [
				'support_text' => [
					'type'    => 'custom',
					'default' => ''
				],
			],
		],
		*/

	];

// Удалим вкладку с языками, если плагины WPML/Polylang не активны
	$html_langs = Helper::html_active_languages();
	if ( ! $html_langs ) {
		unset( $panel_and_sections['settings_add_tab']['sections']['module_multi_lang'] );
	}

	// Добавляем в Шаблон "Первого экрана" выбор показа мета-информации
	foreach ( get_title_slider_layout() as $key_layout => $label_layout ) {
		if ( $key_layout == 'columns_one_two' || $key_layout == 'columns_one_four' ) {
			$active_callback = active_field_for_slider_block();
		}
		else {
			$active_callback = active_field_for_slider();
		}

		$priority = 150;
		if ( $key_layout == 'columns_two' || $key_layout == 'columns_one_two' || $key_layout == 'columns_one_four' ) {
			if ( $key_layout == 'columns_one_four' ) {
				$priority += 200;
			}

			$priority_title = $priority;
			if ( $key_layout == 'columns_one_two' ) {
				$priority_title = $priority - 1;
			}

			if ( $key_layout == 'columns_one_two' ) {
				$key_layout = 'left_block';
			}
			elseif ( $key_layout == 'columns_one_four' ) {
				$key_layout = 'right_block';
			}

			$panel_and_sections['homepage_layout']['sections']['slider_carousel_settings']['controls'][ 'slider_' . $key_layout . '_visibility_title' ] = [
				'type'            => 'custom',
				'default'         => ' <div class="customize-control-title"> ' . esc_html__( 'Внешний вид', 'wescle' ) . ' </div> ',
				'priority'        => $priority_title,
				'active_callback' => $active_callback,
			];

			foreach ( choices_visibility_meta() as $key => $label ) {
				$panel_and_sections['homepage_layout']['sections']['slider_carousel_settings']['controls'][ 'slider_' . $key_layout . '_visibility_' . $key ] = [
					'type'            => 'switch',
					'label'           => $label,
					'default'         => true,
					'priority'        => $priority,
					'choices'         => choices_on_off(),
					'active_callback' => $active_callback
				];
			}
		}
	}

// Добавляем в "Блоки с постами" выбор показа мета-информации
	$loop    = 0;
	$choices = [
		'category' => esc_html__( 'Категория', 'wescle' ),
		'excerpt'  => esc_html__( 'Краткое описание', 'wescle' ),
	];
	$choices = $choices + choices_visibility_meta();
	unset( $choices['date_mod'] );
	foreach ( $choices as $key => $label ) {
		$loop ++;
		if ( $loop == 1 ) {
			$panel_and_sections['homepage_layout']['sections']['home_blocks']['controls']['home_blocks_posts']['fields']['info'] = [
				'type'            => 'custom',
				'default'         => '<div class="customize-control-title">' . esc_html__( 'Отображение информации в карточке поста:', 'wescle' ) . '</div>',
				'priority'        => $priority_title,
				'active_callback' => $active_callback,
			];
		}

		$panel_and_sections['homepage_layout']['sections']['home_blocks']['controls']['home_blocks_posts']['fields'][ 'visibility_' . $key ] = [
			'type'    => 'checkbox',
			'label'   => $label,
			'default' => true,
			'choices' => choices_on_off()
		];
	}

	// Заполним раздел "Визуальное оформление" -> "Кнопки"
	$data_buttons = Helper::get_customizer_data_visual_buttons();
	foreach ( $data_buttons as $key => $val ) {
		$controls = [
			$key . '_button_hr'                => [
				'type'    => 'custom',
				'default' => '<h3 class="section-subtitle">' . $val[1] . '</h3>',
			],
			$key . '_button_type'              => [
				'type'    => 'radio',
				'label'   => esc_html__( 'Тип кнопки', 'wescle' ),
				'default' => 'default',
				'choices' => [
					'default'   => esc_html__( 'От настроек базового цвета', 'wescle' ),
					'custom'    => esc_html__( 'Обычная кнопка', 'wescle' ),
					'animation' => esc_html__( 'Кнопка анимационная', 'wescle' ),
				]
			],
			$key . '_button_color'             => [
				'type'            => 'color',
				'label'           => esc_html__( 'Цвет текста', 'wescle' ),
				'choices'         => [
					'alpha' => true,
				],
				'active_callback' => [
					[
						'setting'  => $key . '_button_type',
						'operator' => '!=',
						'value'    => 'default',
					]
				]
			],
			$key . '_button_bg'                => [
				'type'            => 'color',
				'label'           => esc_html__( 'Фон', 'wescle' ),
				'choices'         => [
					'alpha' => true,
				],
				'active_callback' => [
					[
						'setting'  => $key . '_button_type',
						'operator' => '!=',
						'value'    => 'default',
					]
				]
			],
			$key . '_button_border'            => [
				'type'            => 'color',
				'label'           => esc_html__( 'Обводка', 'wescle' ),
				'choices'         => [
					'alpha' => true,
				],
				'active_callback' => [
					[
						'setting'  => $key . '_button_type',
						'operator' => '!=',
						'value'    => 'default',
					]
				]
			],
			$key . '_button_blick_color'       => [
				'type'            => 'color',
				'label'           => esc_html__( 'Цвет блика анимационного', 'wescle' ),
				'choices'         => [
					'alpha' => true,
				],
				'active_callback' => [
					[
						'setting'  => $key . '_button_type',
						'operator' => '==',
						'value'    => 'animation',
					]
				]
			],
			$key . '_button_color_hover'       => [
				'type'            => 'color',
				'label'           => esc_html__( 'Цвет текста', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
				'choices'         => [
					'alpha' => true,
				],
				'active_callback' => [
					[
						'setting'  => $key . '_button_type',
						'operator' => '!=',
						'value'    => 'default',
					]
				]
			],
			$key . '_button_bg_hover'          => [
				'type'            => 'color',
				'label'           => esc_html__( 'Фон', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
				'choices'         => [
					'alpha' => true,
				],
				'active_callback' => [
					[
						'setting'  => $key . '_button_type',
						'operator' => '!=',
						'value'    => 'default',
					]
				]
			],
			$key . '_button_border_hover'      => [
				'type'            => 'color',
				'label'           => esc_html__( 'Обводка', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
				'choices'         => [
					'alpha' => true,
				],
				'active_callback' => [
					[
						'setting'  => $key . '_button_type',
						'operator' => '!=',
						'value'    => 'default',
					]
				]
			],
			$key . '_button_blick_color_hover' => [
				'type'            => 'color',
				'label'           => esc_html__( 'Цвет блика анимационного', 'wescle' ) . ' ' . esc_html__( 'при наведении', 'wescle' ),
				'choices'         => [
					'alpha' => true,
				],
				'active_callback' => [
					[
						'setting'  => $key . '_button_type',
						'operator' => '==',
						'value'    => 'animation',
					]
				]
			],
			$key . '_button_blick_speed'       => [
				'type'            => 'number',
				'label'           => esc_html__( 'Скорость анимации на кнопке', 'wescle' ),
				'description'     => '*animation-duration',
				'default'         => 4,
				'active_callback' => [
					[
						'setting'  => $key . '_button_type',
						'operator' => '==',
						'value'    => 'animation',
					]
				]
			],
		];

		$panel_and_sections['visual_style_tab']['sections']['buttons_site']['controls'] += $controls;
	}

	$panel_and_sections = apply_filters( 'wescle_customizer_sections', $panel_and_sections );

	// Добавляем панели, секции и поля
	foreach ( $panel_and_sections as $panel_id => $panel_data ) {
		// Если НЕТ панели-то сразу добавим секцию
		if ( isset( $panel_data['controls'] ) && $panel_data['title'] ) {
			Kirki::add_section( $panel_id, array(
				'title'       => $panel_data['title'],
				'description' => isset( $panel_data['description'] ) ? $panel_data['description'] : '',
				'priority'    => isset( $panel_data['priority'] ) ? $panel_data['priority'] : '',
			) );

			foreach ( $panel_data['controls'] as $setting_key => $setting_data ) {
				$args = [
					'section'  => $panel_id,
					'settings' => $setting_key,
				];
				foreach ( $setting_data as $key => $val ) {
					if ( $key == 'type' && ! $val ) {
						continue;
					}

					$args[ $key ] = $val;
				}

				Kirki::add_field( THEME_CONFIG_ID, $args );
			}
		}
		// Если есть панель и секция
		elseif ( $panel_data['title'] ) {
			Kirki::add_panel( $panel_id, array(
				'priority' => $panel_data['priority'],
				'title'    => $panel_data['title'],
			) );

			foreach ( $panel_data['sections'] as $section_id => $section_data ) {
				if ( ! $section_data['title'] ) {
					continue;
				}

				Kirki::add_section( $section_id, array(
					'title'       => $section_data['title'],
					'description' => isset( $section_data['description'] ) ? $section_data['description'] : '',
					'priority'    => isset( $section_data['priority'] ) ? $section_data['priority'] : '',
					'panel'       => $panel_id,
				) );

				foreach ( $section_data['controls'] as $setting_key => $setting_data ) {
					$args = [
						'section'  => $section_id,
						'settings' => $setting_key,
					];
					if ( $setting_data ) {
						foreach ( $setting_data as $key => $val ) {
							if ( $key == 'section' ) {
								continue;
							}

							if ( $key == 'type' && ! $val ) {
								continue;
							}

							$args[ $key ] = $val;
						}
					}

					if ( substr( $setting_key, - 6 ) === '_title' && strpos( $setting_key, 'home_' ) !== false ) {
						if ( isset( $setting_data['selector'] ) ) {
							$selector = $setting_data['selector'];
						}
						else {
							$selector = '.home .' . str_replace( [ 'home_', '_title', '_' ], [ '', '', '-' ], $setting_key ) . ' .container';
						}

						$key_shortcut = $setting_key;
						if ( isset( $setting_data['selector_key'] ) ) {
							$key_shortcut = $setting_data['selector_key'];
						}

						//$args['transport'] = 'postMessage';
						$args['partial_refresh'] = array(
							$key_shortcut . '_shortcut' => array(
								'selector'        => $selector,
								'render_callback' => function ( $setting_key ) {
									return false;

									$title = get_theme_mod( $setting_key, '' );
									if ( ! is_string( $title ) ) {
										return false;
									}

									return $title;
								}
							)
						);
					}
					else {
						$selector = '';
						if ( isset( $setting_data['selector'] ) ) {
							$selector = $setting_data['selector'];
						}

						if ( $selector ) {
							//$args['transport'] = 'postMessage';
							$args['partial_refresh'] = array(
								$setting_key . '_shortcut' => array(
									'selector'        => $selector,
									'render_callback' => function ( $setting_key ) {
										return false;
									}
								)
							);
						}
					}

					if ( substr( $setting_key, - 6 ) === '_title' || isset( $args['type'] ) && $args['type'] === 'editor' ) {
						$args['sanitize_callback'] = array( 'Kirki_Sanitize_Values', 'unfiltered' );
					}

					if ( substr( $setting_key, - 11 ) === '_color_info' || substr( $setting_key, - 13 ) === 'color_bg_info' ) {
						if ( 'slider_carousel_settings' !== $args['section'] ) {
							$args_block_position_info = [
								'section'  => $args['section'],
								'settings' => $args['section'] . '_position_info',
								'type'     => 'custom',
								'default'  => '<h3 class="section-subtitle">' . __( 'Позиционирование', 'wescle' ) . '</h3>',
							];

							Kirki::add_field( THEME_CONFIG_ID, $args_block_position_info );

							$args_block_position = [
								'section'  => $args['section'],
								'settings' => $args['section'] . '_position_content',
								'type'     => 'select',
								'default'  => 'default',
								'choices'  => [
									'default' => __( 'По умолчанию', 'wescle' ),
									'left'    => is_rtl() ? __( 'Справа', 'wescle' ) : __( 'Слева', 'wescle' ),
									'center'  => __( 'Центр', 'wescle' ),
									'right'   => is_rtl() ? __( 'Слева', 'wescle' ) : __( 'Справа', 'wescle' ),
								],
							];

							Kirki::add_field( THEME_CONFIG_ID, $args_block_position );
						}
					}

					Kirki::add_field( THEME_CONFIG_ID, $args );
				}
			}
		}
	}

	if ( Helper::is_woocommerce_active() ) {
		Kirki::add_section( 'wescle_label_woocommerce', array(
			'title'    => esc_html__( 'Надписи', 'wescle' ),
			'panel'    => 'woocommerce',
			'priority' => 100,
		) );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'text',
			'settings' => 'btn_cart_link_text',
			'label'    => esc_html__( 'Для простых товаров', 'wescle' ),
			'default'  => Helper::get_default_theme_data( 'btn_cart_link_text' ),
			'section'  => 'wescle_label_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'text',
			'settings' => 'btn_variable_link_text',
			'label'    => esc_html__( 'Для вариативных товаров', 'wescle' ),
			'default'  => Helper::get_default_theme_data( 'btn_variable_link_text' ),
			'section'  => 'wescle_label_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'text',
			'settings' => 'btn_read_link_text',
			'label'    => esc_html__( 'Для товаров, которых нет в наличие', 'wescle' ),
			'default'  => Helper::get_default_theme_data( 'btn_read_link_text' ),
			'section'  => 'wescle_label_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'text',
			'settings' => 'wishlist_link_text',
			'label'    => esc_html__( 'В список желаний', 'wescle' ),
			'default'  => Helper::get_default_theme_data( 'wishlist_link_text' ),
			'section'  => 'wescle_label_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'text',
			'settings' => 'view_product',
			'label'    => esc_html__( 'Надпись для просмотра товара', 'wescle' ),
			'default'  => Helper::get_default_theme_data( 'view_product' ),
			'section'  => 'wescle_label_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'text',
			'settings' => 'quick_view',
			'label'    => esc_html__( 'Надпись для быстрого просмотра', 'wescle' ),
			'default'  => Helper::get_default_theme_data( 'quick_view' ),
			'section'  => 'wescle_label_woocommerce',
		] );

		Kirki::add_section( 'wescle_brands_woocommerce', array(
			'title'    => esc_html__( 'Бренды', 'wescle' ),
			'panel'    => 'woocommerce',
			'priority' => 101,
		) );

		$args       = array(
			'public'      => true,
			'object_type' => [ 'product' ]
		);
		$taxonomies = get_taxonomies( $args );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'select',
			'settings' => 'woo_brands_taxonomy',
			'label'    => esc_html__( 'Выберите таксономию для брендов', 'wescle' ),
			'default'  => '',
			'section'  => 'wescle_brands_woocommerce',
			'choices'  => array_merge( [ '' => $label_select ], $taxonomies ),
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'switch',
			'settings' => 'woo_brands_enabled',
			'label'    => esc_html__( 'Включить бренды от темы?', 'wescle' ),
			'default'  => false,
			'section'  => 'wescle_brands_woocommerce',
			'choices'  => choices_on_off(),
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'switch',
			'settings' => 'woo_archive_brands_enabled',
			'label'    => esc_html__( 'Отображать бренды в категориях магазина?', 'wescle' ),
			'default'  => false,
			'section'  => 'wescle_brands_woocommerce',
			'choices'  => choices_on_off(),
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'switch',
			'settings' => 'woo_archive_brands_slider',
			'label'    => esc_html__( 'Отображать бренды слайдером-каруселью?', 'wescle' ),
			'default'  => false,
			'section'  => 'wescle_brands_woocommerce',
			'choices'  => choices_on_off(),
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'            => 'number',
			'settings'        => 'woo_archive_brands_count',
			'label'           => esc_html__( 'Количество брендов на главной странице магазина', 'wescle' ),
			'default'         => 10,
			'section'         => 'wescle_brands_woocommerce',
			'active_callback' => [
				[
					'setting'  => 'woo_archive_brands_slider',
					'operator' => '==',
					'value'    => true,
				]
			],
		] );

		Kirki::add_field( THEME_CONFIG_ID,
			array_merge( home_slider_settings_count( 6 ),
				[
					'settings'        => 'woo_archive_brands_slider_count',
					'section'         => 'wescle_brands_woocommerce',
					'active_callback' => [
						[
							'setting'  => 'woo_archive_brands_slider',
							'operator' => '==',
							'value'    => true,
						]
					],
				]
			)
		);

		Kirki::add_section( 'wescle_cart_woocommerce', array(
			'title'    => esc_html__( 'Корзина', 'wescle' ),
			'panel'    => 'woocommerce',
			'priority' => 102,
		) );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'custom',
			'settings' => 'wescle_cart_woocommerce_info',
			'label'    => '<div class="notice notice-warning section-description">' . __( 'Изменения будут видны после обновления содержимого корзины: нужно удалить или добавить товар в корзину', 'wescle' ) . '</div>',
			'section'  => 'wescle_cart_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'            => 'text',
			'settings'        => 'cart_title',
			'label'           => esc_html__( 'Надпись для корзины', 'wescle' ),
			'default'         => Helper::get_default_theme_data( 'cart_title' ),
			'section'         => 'wescle_cart_woocommerce',
			'partial_refresh' => array(
				'cart_title' => array(
					'selector'        => '.navigation-store__cart',
					'render_callback' => '__return_false'
				)
			)
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'            => 'switch',
			'settings'        => 'cart_title_visible',
			'label'           => esc_html__( 'Отображать надпись возле иконки корзины?', 'wescle' ),
			'default'         => true,
			'section'         => 'wescle_cart_woocommerce',
			'active_callback' => [
				[
					'setting'  => 'header_block_type',
					'operator' => '==',
					'value'    => 'store_logo_center',
				]
			]
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'radio',
			'settings' => 'cart_icon_type',
			'label'    => esc_html__( 'Вид иконки корзины', 'wescle' ),
			'default'  => '1',
			'choices'  => [
				'1' => '1',
				'2' => '2',
			],
			'section'  => 'wescle_cart_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'              => 'textarea',
			'settings'          => 'cart_icon_svg',
			'label'             => esc_html__( 'SVG-код кастомной иконки', 'wescle' ),
			'default'           => '',
			'section'           => 'wescle_cart_woocommerce',
			'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' )
		] );

		Kirki::add_section( 'wescle_wishlist_woocommerce', array(
			'title'    => esc_html__( 'Список желаний', 'wescle' ),
			'panel'    => 'woocommerce',
			'priority' => 103,
		) );
		if ( ! $page_template_wishlist ) {
			Kirki::add_field( THEME_CONFIG_ID, [
				'type'     => 'custom',
				'settings' => 'module_wishlist_info',
				'default'  => '<div class="notice notice-error section-description">' . sprintf( __( 'Для отображения списка желаний создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Wishlist".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
				'section'  => 'wescle_wishlist_woocommerce',
			] );
		}

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'            => 'text',
			'settings'        => 'wishlist_title',
			'label'           => esc_html__( 'Надпись возле иконки списка желаний', 'wescle' ),
			'default'         => Helper::get_default_theme_data( 'wishlist_title' ),
			'section'         => 'wescle_wishlist_woocommerce',
			'partial_refresh' => array(
				'wishlist_title' => array(
					'selector'        => '.navigation-store__wishlist',
					'render_callback' => function () {
						$type = '';
						if ( Helper::is_header_store_center() ) {
							$type = 'store-center';
						}
						ob_start();
						wescle_wishlist_link( $type );

						return ob_get_clean();
					}
				)
			)
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'radio',
			'settings' => 'wishlist_icon_type',
			'label'    => esc_html__( 'Вид иконки списка желаний', 'wescle' ),
			'default'  => '1',
			'choices'  => [
				'1' => '1',
				'2' => '2',
			],
			'section'  => 'wescle_wishlist_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'              => 'textarea',
			'settings'          => 'wishlist_icon_svg',
			'label'             => esc_html__( 'SVG-код кастомной иконки', 'wescle' ),
			'default'           => '',
			'section'           => 'wescle_wishlist_woocommerce',
			'sanitize_callback' => array( 'Kirki_Sanitize_Values', 'unfiltered' ),
		] );

		Kirki::add_section( 'wescle_compare_woocommerce', array(
			'title'    => esc_html__( 'Сравнение', 'wescle' ),
			'panel'    => 'woocommerce',
			'priority' => 104,
		) );

		if ( ! $page_template_compare ) {
			Kirki::add_field( THEME_CONFIG_ID, [
				'type'     => 'custom',
				'settings' => 'module_compare_info',
				'default'  => '<div class="notice notice-error section-description">' . sprintf( __( 'Для отображения таблицы сравнения создайте <a href="%s" target="_blank">здесь</a> новую страницу и в атрибутах выберите шаблон "Compare".', 'wescle' ), admin_url( 'post-new.php?post_type=page' ) ) . '</div>',
				'section'  => 'wescle_compare_woocommerce',
			] );
		}

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'switch',
			'settings' => 'module_compare_enabled',
			'label'    => esc_html__( 'Включить сравнение товаров?', 'wescle' ),
			'default'  => false,
			'section'  => 'wescle_compare_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'text',
			'settings' => 'compare_title',
			'label'    => esc_html__( 'Заголовок модального окна', 'wescle' ),
			'default'  => Helper::get_default_theme_data( 'compare_title' ),
			'section'  => 'wescle_compare_woocommerce',
		] );

		$column_fields = Helper::get_compare_column_fields();
		unset( $column_fields['image'] );
		Kirki::add_field( THEME_CONFIG_ID, [
			'type'         => 'repeater',
			'settings'     => 'compare_columns',
			'label'        => esc_html__( 'Колонки в таблице сравнения', 'wescle' ),
			'row_label'    => [
				'type'  => 'text',
				'value' => esc_html__( 'Колонка', 'wescle' ),
			],
			'button_label' => esc_html__( 'Добавить колонку', 'wescle' ),
			'default'      => Helper::get_default_theme_data( 'compare_columns' ),
			'fields'       => [
				'column_field' => [
					'type'        => 'select',
					'label'       => esc_html__( 'Колонка', 'wescle' ),
					'default'     => '',
					'placeholder' => $label_select,
					'choices'     => $column_fields,
				]
			],
			'section'      => 'wescle_compare_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'custom',
			'settings' => 'compare_empty_info',
			'default'  => '<div class="customize-control-title">' . esc_html__( 'Информация в пустом модальном окне', 'wescle' ) . '</div>',
			'section'  => 'wescle_compare_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'image',
			'settings' => 'compare_empty_image',
			'label'    => esc_html__( 'Изображение', 'wescle' ),
			'default'  => false,
			'choices'  => [
				'save_as' => 'id',
			],
			'section'  => 'wescle_compare_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'text',
			'settings' => 'compare_empty_title',
			'label'    => esc_html__( 'Заголовок', 'wescle' ),
			'default'  => Helper::get_default_theme_data( 'compare_empty_title' ),
			'section'  => 'wescle_compare_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'text',
			'settings' => 'compare_empty_text',
			'label'    => esc_html__( 'Текст', 'wescle' ),
			'default'  => Helper::get_default_theme_data( 'compare_empty_text' ),
			'section'  => 'wescle_compare_woocommerce',
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'checkbox',
			'settings' => 'product_images_vertical',
			'label'    => esc_html__( 'Изображения товаров вертикальные?', 'wescle' ),
			'default'  => false,
			'section'  => 'woocommerce_product_images',
			'priority' => 5,
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'            => 'radio',
			'settings'        => 'product_images_object_fit',
			'label'           => esc_html__( 'Какое значение для object-fit?', 'wescle' ),
			'default'         => 'cover',
			'section'         => 'woocommerce_product_images',
			'priority'        => 5,
			'choices'         => [
				'cover'   => 'cover',
				'contain' => 'contain',
			],
			'active_callback' => [
				[
					'setting'  => 'product_images_vertical',
					'operator' => '==',
					'value'    => true,
				]
			]
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'checkbox',
			'settings' => 'product_images_horizontal',
			'label'    => esc_html__( 'Изображения товаров горизонтальные?', 'wescle' ),
			'default'  => false,
			'section'  => 'woocommerce_product_images',
			'priority' => 5,
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'custom',
			'settings' => 'category_custom_hr',
			'label'    => '<hr style="margin-bottom: -6px;">',
			'section'  => 'woocommerce_product_catalog',
			'priority' => 14,
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'switch',
			'settings' => 'orderby_stock_status',
			'label'    => esc_html__( 'Товары, которых нет в наличие, показывать в конце списка?', 'wescle' ),
			'default'  => true,
			'section'  => 'woocommerce_product_catalog',
			'priority' => 15,
			'choices'  => choices_on_off(),
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'switch',
			'settings' => 'category_images_vertical',
			'label'    => esc_html__( 'Изображения категорий вертикальные?', 'wescle' ),
			'default'  => false,
			'section'  => 'woocommerce_product_catalog',
			'priority' => 15,
			'choices'  => choices_on_off(),
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'     => 'switch',
			'settings' => 'category_slider_enable',
			'label'    => esc_html__( 'Показывать слайдер категорий?', 'wescle' ),
			'default'  => true,
			'section'  => 'woocommerce_product_catalog',
			'priority' => 15,
			'choices'  => choices_on_off(),
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'            => 'number',
			'settings'        => 'category_count_slides',
			'label'           => esc_html__( 'Количество слайдов категорий', 'wescle' ),
			'default'         => 5,
			'section'         => 'woocommerce_product_catalog',
			'priority'        => 15,
			'active_callback' => [
				[
					'setting'  => 'category_slider_enable',
					'operator' => '==',
					'value'    => true,
				]
			]
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'            => 'switch',
			'settings'        => 'category_slider_arrows',
			'label'           => esc_html__( 'Показывать кнопки "стрелки" слайдера?', 'wescle' ),
			'default'         => true,
			'section'         => 'woocommerce_product_catalog',
			'priority'        => 16,
			'choices'         => choices_on_off(),
			'active_callback' => [
				[
					'setting'  => 'category_slider_enable',
					'operator' => '==',
					'value'    => true,
				]
			]
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'            => 'switch',
			'settings'        => 'category_slider_dots',
			'label'           => esc_html__( 'Добавить кнопки "точки" слайдера?', 'wescle' ),
			'default'         => false,
			'section'         => 'woocommerce_product_catalog',
			'priority'        => 16,
			'choices'         => choices_on_off(),
			'active_callback' => [
				[
					'setting'  => 'category_slider_enable',
					'operator' => '==',
					'value'    => true,
				]
			]
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'            => 'slider',
			'settings'        => 'category_slider_speed',
			'label'           => esc_html__( 'Скорость смены слайдов, сек', 'wescle' ),
			'default'         => 8,
			'section'         => 'woocommerce_product_catalog',
			'priority'        => 16,
			'choices'         => [
				'min'  => 1,
				'max'  => 20,
				'step' => 1,
			],
			'active_callback' => [
				[
					'setting'  => 'category_slider_enable',
					'operator' => '==',
					'value'    => true,
				]
			]
		] );

		Kirki::add_field( THEME_CONFIG_ID, [
			'type'            => 'select',
			'settings'        => 'category_grid_count',
			'label'           => esc_html__( 'Категорий в строке', 'wescle' ),
			'default'         => '5',
			'section'         => 'woocommerce_product_catalog',
			'priority'        => 16,
			'choices'         => [
				'3' => 3,
				'4' => 4,
				'5' => 5,
				'6' => 6,
				'7' => 7,
			],
			'active_callback' => [
				[
					'setting'  => 'category_slider_enable',
					'operator' => '==',
					'value'    => false,
				]
			]
		] );
	}

}, 99 );

function get_title_slider_layout() {
	$layouts = array(
		'none'             => get_template_directory_uri() . '/assets/admin/img/sidebar-none.png',
		'columns_two'      => get_template_directory_uri() . '/assets/admin/img/columns_two.png',
		'columns_one'      => get_template_directory_uri() . '/assets/admin/img/columns_one.png',
		'columns_four'     => get_template_directory_uri() . '/assets/admin/img/columns_four.png',
		'columns_one_two'  => get_template_directory_uri() . '/assets/admin/img/columns_one_two.png',
		'columns_one_four' => get_template_directory_uri() . '/assets/admin/img/columns_one_four.png',
		'banner'           => get_template_directory_uri() . '/assets/admin/img/banner.png',
	);

	if ( Helper::is_woocommerce_active() ) {
		$layouts['store'] = get_template_directory_uri() . '/assets/admin/img/store.png';
	}

	$layouts['animated'] = get_template_directory_uri() . '/assets/admin/img/banner50.png';
	$layouts['parallax'] = get_template_directory_uri() . '/assets/admin/img/parallax.png';

	return $layouts;
}

function active_field_for_slider() {
	$data = [
		[
			[
				'setting'  => 'slider_layout',
				'operator' => '==',
				'value'    => 'columns_two',
			],
			[
				'setting'  => 'slider_layout',
				'operator' => '==',
				'value'    => 'columns_one',
			],
			[
				'setting'  => 'slider_layout',
				'operator' => '==',
				'value'    => 'columns_four',
			],
		]
	];

	return $data;
}

function active_field_for_slider_block( $index = false ) {
	$data = [
		[
			[
				'setting'  => 'slider_layout',
				'operator' => '==',
				'value'    => 'columns_one_two',
			],
			[
				'setting'  => 'slider_layout',
				'operator' => '==',
				'value'    => 'columns_one_four',
			],
		]
	];

	if ( $index !== false ) {
		$data = [
			$data[0][ $index ]
		];
	}

	return $data;
}

function active_field_for_banner() {
	$data = [
		[
			'setting'  => 'slider_layout',
			'operator' => '==',
			'value'    => 'banner',
		],
	];

	return $data;
}

function active_field_for_store() {
	$data = [
		[
			'setting'  => 'slider_layout',
			'operator' => '==',
			'value'    => 'store',
		],
	];

	return $data;
}

function active_field_for_animated() {
	$data = [
		[
			[
				'setting'  => 'slider_layout',
				'operator' => '==',
				'value'    => 'animated',
			],
		]
	];

	return $data;
}

function active_field_for_parallax() {
	$data = [
		[
			[
				'setting'  => 'slider_layout',
				'operator' => '==',
				'value'    => 'parallax',
			],
		]
	];

	return $data;
}

function active_field_for_top_tabs() {
	$data = [
		[
			'setting'  => 'header_block_type',
			'operator' => '==',
			'value'    => 'top_bar_tabs',
		]
	];

	return $data;
}

function active_field_for_custom( $setting = '', $operator = '==', $value = true ) {
	$data = [];
	if ( $setting ) {
		$data = [
			[
				'setting'  => $setting,
				'operator' => $operator,
				'value'    => $value,
			],
		];
	}

	return $data;
}

function choices_on_off() {
	return [
		'on'  => esc_html__( 'Вкл', 'wescle' ),
		'off' => esc_html__( 'Выкл', 'wescle' ),
	];
}

function choices_yes_no() {
	return [
		'on'  => esc_html__( 'Да', 'wescle' ),
		'off' => esc_html__( 'Нет', 'wescle' ),
	];
}

function choices_visibility_meta( $add_category = false ) {
	$data = [
		'author'   => esc_html__( 'Автор', 'wescle' ),
		'date'     => esc_html__( 'Дата публикации', 'wescle' ),
		//'date_mod' => esc_html__( 'Дата обновления', 'wescle' ),
		'comments' => esc_html__( 'Комментарии', 'wescle' ),
		'views'    => esc_html__( 'Просмотры', 'wescle' ),
	];
	if ( $add_category ) {
		$data['category'] = esc_html__( 'Категория', 'wescle' );
	}

	return $data;
}

function choices_number( $max = 40 ) {
	return [
		'min'  => 0,
		'max'  => $max,
		'step' => 1,
	];
}

function choices_post_card_type() {
	return [
		'default'     => esc_html__( 'Плитка', 'wescle' ),
		'vertical'    => esc_html__( 'Вертикальный', 'wescle' ),
		'horizontal'  => esc_html__( 'Горизонтальный', 'wescle' ),
		'horizontal2' => esc_html__( 'Горизонтальный', 'wescle' ) . ' 2',
	];
}

function choices_posts_orderby( $exclude = [] ) {
	$data = [
		'date'       => esc_html__( 'По дате публикации', 'wescle' ),
		'views'      => esc_html__( 'По просмотрам', 'wescle' ),
		'rand'       => esc_html__( 'Рандомно', 'wescle' ),
		'menu_order' => esc_html__( 'Кастомный порядок', 'wescle' ),
	];

	if ( $exclude ) {
		if ( is_string( $exclude ) ) {
			$exclude = [ $exclude ];
		}
		foreach ( $exclude as $key ) {
			if ( isset( $data[ $key ] ) ) {
				unset( $data[ $key ] );
			}
		}
	}

	return $data;
}

function phone_type_block() {
	return [
		'type'    => 'select',
		'label'   => esc_html__( 'Тип телефона', 'wescle' ),
		'default' => 'tel',
		'choices' => [
			'tel'      => __( 'Телефон', 'wescle' ),
			'telegram' => __( 'Telegram', 'wescle' ),
			'viber'    => __( 'Viber', 'wescle' ),
			'whatsapp' => __( 'WhatsApp', 'wescle' ),
			'skype'    => __( 'Skype', 'wescle' ),
			'wechat'   => __( 'WeChat', 'wescle' ),
		]
	];
}

function phone_icon_operator() {
	return [
		'type'    => 'image',
		'label'   => esc_html__( 'Иконка оператора', 'wescle' ),
		'choices' => [
			'save_as' => 'id',
		],
	];
}

function phone_operator_block( $label_select = '' ) {
	return [
		'type'    => 'select',
		'label'   => esc_html__( 'Оператор', 'wescle' ),
		'default' => 'tel',
		'choices' => [
			''         => $label_select,
			'kievstar' => __( 'Киевстар', 'wescle' ),
			'vodafone' => __( 'Vodafone', 'wescle' ),
			'lifecell' => __( 'lifecell', 'wescle' ),
		],
	];
}

function header_title_type_block() {
	return [
		'type'    => 'select',
		'label'   => esc_html__( 'Тип заголовка', 'wescle' ),
		'default' => 'div',
		'choices' => [
			'div' => 'DIV',
			'h1'  => 'H1',
			'h2'  => 'H2',
			'h3'  => 'H3',
			'h4'  => 'H4',
			'h5'  => 'H5',
			'h6'  => 'H6',
		]
	];
}

function sortable_card_blocks( $key_layout, $priority = '' ) {
	if ( $key_layout == 'columns_two' ) {
		$active_callback = active_field_for_slider();
	}
	else {
		$active_callback = active_field_for_slider_block();
	}

	return [
		'type'            => 'sortable',
		'label'           => esc_html__( 'Порядок блоков', 'wescle' ),
		'default'         => [
			'category',
			'title',
			'meta',
		],
		'choices'         => [
			'category' => esc_html__( 'Категория', 'wescle' ),
			'title'    => esc_html__( 'Заголовок', 'wescle' ),
			'meta'     => esc_html__( 'Мета', 'wescle' ),
		],
		'priority'        => $priority,
		'active_callback' => $active_callback
	];
}


function field_sidebar_aside_position( $default = 'right' ) {
	return [
		'type'    => 'radio-image',
		'label'   => esc_html__( 'Позиция сайдбара', 'wescle' ),
		'default' => $default,
		'choices' => array(
			'none'  => get_template_directory_uri() . '/assets/admin/img/sidebar-none.png',
			'left'  => is_rtl() ? get_template_directory_uri() . '/assets/admin/img/sidebar-right.png' : get_template_directory_uri() . '/assets/admin/img/sidebar-left.png',
			'right' => is_rtl() ? get_template_directory_uri() . '/assets/admin/img/sidebar-left.png' : get_template_directory_uri() . '/assets/admin/img/sidebar-right.png'
		),
	];
}

function field_post_header_version( $choices = [] ) {
	$data = [
		'type'    => 'radio-image',
		'label'   => esc_html__( 'Версия шапки', 'wescle' ),
		'default' => 'v1',
		'choices' => array(
			'v1' => get_template_directory_uri() . '/assets/admin/img/post_v1.png',
			'v2' => get_template_directory_uri() . '/assets/admin/img/post_v2.png',
			'v3' => get_template_directory_uri() . '/assets/admin/img/post_v3.png',
			'v4' => get_template_directory_uri() . '/assets/admin/img/post_v4.png'
		)
	];

	if ( $choices ) {
		foreach ( $data['choices'] as $key => $val ) {
			if ( ! in_array( $key, $choices ) ) {
				unset( $data['choices'][ $key ] );
			}
		}
	}

	return $data;
}

function field_post_header_full_height( $name ) {
	return [
		'type'            => 'switch',
		'label'           => esc_html__( 'Изображение на всю высоту страницы? ( 100vh )', 'wescle' ),
		'default'         => false,
		'choices'         => choices_on_off(),
		'active_callback' => [
			[
				'setting'  => $name . '_about_version',
				'operator' => '==',
				'value'    => 'v4',
			],
		]
	];
}

function output_html_code( $text ) {
	return trim( $text );
}

function cf7_type_block( $label_select, $title = '', $default_key = '' ) {
	$installed_forms = get_option( THEME_SLUG . '_installed_forms' );
	if ( ! $installed_forms ) {
		$installed_forms = [];
	}

	if ( ! $title ) {
		$title = esc_html__( 'Выберите форму CF7', 'wescle' );
	}

	$data = [
		'type'        => class_exists( 'WPCF7_Mail' ) ? 'select' : '',
		'label'       => $title,
		'default'     => isset( $installed_forms[ $default_key ] ) ? $installed_forms[ $default_key ] : '',
		'isClearable' => true,
		'placeholder' => $label_select,
		'choices'     => Helper::get_posts( array(
			'post_type' => 'wpcf7_contact_form'
		) ),
	];

	return $data;
}

function home_block_preview_img( $image_name, $lang = 'ru_RU' ) {
	static $template_directory_uri, $site_locale;

	if ( null == $template_directory_uri ) {
		$template_directory_uri = get_template_directory_uri();
		$site_locale            = get_locale();
	}

	$home_image_preview_title = __( 'Как будет выглядеть блок', 'wescle' );
	$home_image_preview_info  = __( '* нажмите на фото, чтобы увеличить', 'wescle' );

	/*$key_lang   = $lang == 'ru_RU' ? '' : '-' . $lang;
	$image_name .= $key_lang;*/

	return [
		//'type'    => $site_locale == $lang ? 'custom' : '',
		'type'    => 'custom',
		'label'   => $home_image_preview_title,
		'default' => '<div class="notice-image"><a href="https://wescle.com/previews-wescle-block/' . $image_name . '.jpg" data-fancybox><img src="' . $template_directory_uri . '/assets/admin/img/preview/' . $image_name . '.jpg" alt=""></a>' . $home_image_preview_info . '</div>',
	];
}

function home_block_color_bg_info() {
	return [
		'type'    => 'custom',
		'default' => '<h3 class="section-subtitle">' . __( 'Кастомизация стиля блока', 'wescle' ) . '</h3>',
	];
}

function home_block_color_bg() {
	return [
		'type'    => 'color',
		'label'   => esc_html__( 'Фон блока', 'wescle' ),
		'default' => '',
		'choices' => [
			'alpha' => true,
		],
	];
}

function home_block_color_title() {
	return [
		'type'    => 'color',
		'label'   => esc_html__( 'Цвет заголовка', 'wescle' ),
		'default' => '',
		'choices' => [
			'alpha' => true,
		],
	];
}

function social_item_color( $label = '' ) {
	if ( ! $label ) {
		$label = esc_html__( 'Цвет иконки', 'wescle' );
	}

	return [
		'type'    => 'color',
		'label'   => $label,
		'default' => '',
		'choices' => [
			'alpha' => true,
		],
	];
}

function social_item_color_hover( $label = '' ) {
	if ( ! $label ) {
		$label = esc_html__( 'Цвет иконки', 'wescle' );
	}

	return [
		'type'    => 'color',
		'label'   => $label . ' ' . __( 'при наведении', 'wescle' ),
		'default' => '',
		'choices' => [
			'alpha' => true,
		],
	];
}

function home_block_image_bg( $key = 'pc' ) {
	$label = [
		'pc'     => esc_html__( 'на ПК (1280-1920)', 'wescle' ),
		'tablet' => esc_html__( 'на планшете (768-1280)', 'wescle' ),
		'mobile' => esc_html__( 'на телефоне (320-768)', 'wescle' )
	];

	$hr = '<hr>';
	if ( $key == 'pc' ) {
		$hr = '';
	}

	return [
		'type'    => 'image',
		'label'   => $hr . esc_html__( 'Фоновое изображение', 'wescle' ) . '<br>' . $label[ $key ],
		'choices' => [
			'save_as' => 'id',
		],
	];
}

function home_block_image_bg_fit( $key = 'pc' ) {
	$label = [
		'pc'     => esc_html__( 'на ПК (1280-1920)', 'wescle' ),
		'tablet' => esc_html__( 'на планшете (768-1280)', 'wescle' ),
		'mobile' => esc_html__( 'на телефоне (320-768)', 'wescle' )
	];

	return [
		'type'    => 'select',
		'label'   => esc_html__( 'Режим заполнения', 'wescle' ) . ' (object-fit), <br>' . $label[ $key ],
		'default' => 'cover',
		'choices' => [
			'cover'   => 'cover',
			'contain' => 'contain',
			'fill'    => 'fill',
			'none'    => 'none',
		],
	];
}

function home_slider_settings_info() {
	return [
		'type'    => 'custom',
		'default' => '<h3 class="section-subtitle">' . __( 'Настройки слайдера', 'wescle' ) . '</h3>',
	];
}

function home_slider_settings_count( $default = 5, $max = 8 ) {
	return [
		'type'    => 'number',
		'label'   => esc_html__( 'Количество слайдов', 'wescle' ),
		'default' => $default,
		'choices' => [
			'min'  => 1,
			'max'  => $max,
			'step' => 1,
		],
	];
}

function home_slider_settings_speed( $type = 'slider', $default = 8, $active_callback = [] ) {
	return [
		'type'            => $type,
		'label'           => esc_html__( 'Скорость смены слайдов, сек', 'wescle' ),
		'default'         => $default,
		'choices'         => [
			'min'  => 1,
			'max'  => 20,
			'step' => 1,
		],
		'active_callback' => $active_callback
	];
}

function home_slider_settings_arrow( $default = true, $type = 'switch', $active_callback = [] ) {
	return [
		'type'            => $type,
		'label'           => esc_html__( 'Показывать кнопки "стрелки" слайдера?', 'wescle' ),
		'default'         => $default,
		'choices'         => choices_on_off(),
		'active_callback' => $active_callback
	];
}

function home_slider_settings_arrow_mobile( $default = true, $type = 'switch', $active_callback = [] ) {
	return [
		'type'            => $type,
		'label'           => esc_html__( 'Показывать кнопки "стрелки" слайдера на мобильных устройствах?', 'wescle' ),
		'default'         => $default,
		'choices'         => choices_on_off(),
		'active_callback' => $active_callback
	];
}

function home_slider_settings_dots( $default = false, $type = 'switch', $active_callback = [] ) {
	return [
		'type'            => $type,
		'label'           => esc_html__( 'Добавить кнопки "точки" слайдера?', 'wescle' ),
		'default'         => $default,
		'choices'         => choices_on_off(),
		'active_callback' => $active_callback
	];
}

function get_content_robots_file() {
	$content = '';

	$file = ABSPATH . 'robots.txt';
	if ( file_exists( $file ) ) {
		$content = file_get_contents( $file );
	}

	return $content;
}

function field_content_box_width( $priority = '', $label = '' ) {
	if ( ! $label ) {
		$label = esc_html__( 'Максимальная ширина контейнера', 'wescle' ) . ', px';
	}

	$data = [
		'type'            => 'slider',
		'label'           => $label,
		'default'         => 1280,
		'choices'         => [
			'min'  => 1000,
			'max'  => 1920,
			'step' => 10,
		],
		'active_callback' => [
			[
				'setting'  => 'content_box',
				'operator' => '==',
				'value'    => 'box',
			],
		]
	];

	if ( $priority !== '' ) {
		$data['priority'] = $priority;
	}

	return $data;
}

function field_sidebar_box_width( $active_callback_name = 'sidebar_position', $priority = '', $label = '' ) {
	if ( ! $label ) {
		$label = esc_html__( 'Ширина сайдбара', 'wescle' ) . ', %';
	}

	$data = [
		'type'            => 'slider',
		'label'           => $label,
		'default'         => 30,
		'choices'         => [
			'min'  => 10,
			'max'  => 50,
			'step' => 1,
		],
		'active_callback' => [
			[
				'setting'  => $active_callback_name,
				'operator' => '!=',
				'value'    => 'none',
			],
		]
	];

	if ( $priority !== '' ) {
		$data['priority'] = $priority;
	}

	return $data;
}

function mess_social_type_block() {
	return [
		'type'    => 'select',
		'label'   => esc_html__( 'Тип иконки', 'wescle' ),
		'default' => 'tel',
		'choices' => [
			'call'      => __( 'Телефон', 'wescle' ),
			'callback'  => __( 'Телефон - Обратный звонок', 'wescle' ),
			'telegram'  => __( 'Telegram', 'wescle' ),
			'viber'     => __( 'Viber', 'wescle' ),
			'whatsapp'  => __( 'WhatsApp', 'wescle' ),
			'skype'     => __( 'Skype', 'wescle' ),
			'wechat'    => __( 'WeChat', 'wescle' ),
			'email'     => __( 'Email', 'wescle' ),
			'messenger' => __( 'Facebook Messenger', 'wescle' ),
			'chat'      => __( 'Чат', 'wescle' ),
			'support'   => __( 'Поддержка', 'wescle' ),
		]
	];
}

function home_block_enabled() {
	return [
		'type'    => 'checkbox',
		'label'   => esc_html__( 'Показывать блок на главной?', 'wescle' ),
		'default' => true,
	];
}

function choices_addit_classes( $only_text = true ) {
	$data = [ '-' ];

	if ( $only_text ) {
		$data['_align-right'] = 'align-right';
		$data['_align-left']  = 'align-left';
	}
	else {
		$data['_j-start'] = 'align-start';
		$data['_j-end']   = 'align-end';
	}

	return $data;
}

function home_block_demo_info( $block_key = '', $radio = [], $block_key_alt = '' ) {
	$radio_data = [
		'store' => __( 'Магазин', 'wescle' )
	];

	$radio_html = '';
	foreach ( $radio as $radio_key ) {
		$radio_val  = $radio_data[ $radio_key ];
		$radio_html .= '<p><label><input type="radio" name="democontent" value="' . $radio_key . '">' . $radio_val . '</label></p>';
	}

	$type = '';
	if ( current_user_can( 'administrator' ) ) {
		$type = 'custom';
	}

	return [
		'type'        => $type,
		'label'       => '<h3 class="section-subtitle">' . __( 'Демо контент блока', 'wescle' ) . '</h3>',
		'description' =>
			'<div class="wrap-democontent" data-block_key="' . $block_key . '" data-block_key_alt="' . $block_key_alt . '">' .
			'<p>' . __( '* Внимание! При клике будут импортированы демо данные, введенные текущие данные будут перезаписаны демо контентом', 'wescle' ) . '</p>' .
			'<p><label><input type="radio" name="democontent" value="default"> ' . __( 'Базовые', 'wescle' ) . '</label></p>' .
			$radio_html .
			'<p><button type="button" class="button button-primary button_import_demo">' . __( 'Импортировать', 'wescle' ) . '</button></p>' .
			'</div>'
	];
}

function header_block_type_field() {
	$choices = [
		''                  => __( 'базовый', 'wescle' ),
		'store'             => __( 'магазин', 'wescle' ),
		'top_bar_tabs'      => __( 'топ бар + меню с табами', 'wescle' ),
		'store_logo_center' => __( 'магазин, лого по центру', 'wescle' ),
	];
	if ( ! Helper::is_woocommerce_active() ) {
		unset( $choices['store'] );
		unset( $choices['store_logo_center'] );
	}

	$data = [
		'type'     => 'radio',
		'label'    => esc_html__( 'Вид шапки', 'wescle' ),
		'default'  => '',
		'choices'  => $choices,
		'selector' => '.header__top .container'
	];

	return $data;
}