<?php
global $post;

$border_radius = intval( get_theme_mod( 'site_border_radius', 10 ) );
if ( $border_radius != 10 ) {
	?>
    :root{--mainBorderRadius:<?php echo $border_radius; ?>px}
	<?php
}

if ( get_theme_mod( 'font_custom' ) && get_theme_mod( 'font_custom_name' ) && get_theme_mod( 'font_custom_regular' ) ) {
	$font_name  = str_replace( [ '"', "'" ], '', get_theme_mod( 'font_custom_name', '' ) );
	$fonts_data = [
		'light'    => 300,
		'regular'  => 400,
		'bold'     => 700,
		'medium'   => 500,
		'semibold' => 600
	];
	foreach ( $fonts_data as $type => $font_weight ) {
		$file_url = get_theme_mod( 'font_custom_' . $type );
		if ( ! $file_url ) {
			continue;
		}
		?>
        @font-face {
        font-family: "<?php echo $font_name; ?>";
        font-display: swap;
        src: url(<?php echo $file_url; ?>) format("woff2");
        font-weight: <?php echo $font_weight; ?>;
        font-style: normal;
        }
		<?php
	}
	echo 'body{font-family: "' . $font_name . '", sans-serif}';
}
else {
	$font_family = get_theme_mod( 'font_family', [] );
	if ( $font_family && $font_family['font-family'] != 'Montserrat' ) {
		$font_data = wescle_get_font_data();
		if ( isset( $font_data[ $font_family['font-family'] ] ) ) {
			$font = $font_data[ $font_family['font-family'] ][0];

			foreach ( $font_data[ $font_family['font-family'] ] as $font_weight ) {
				if ( ! is_numeric( $font_weight ) ) {
					continue;
				}
				$dir = get_template_directory_uri() . '/assets'
				?>
                @font-face {
                font-family: "<?php echo $font_family['font-family']; ?>";
                font-display: swap;
                src: url("<?php echo $dir; ?>/fonts/<?php echo $font; ?>/<?php echo $font; ?>-<?php echo $font_weight; ?>.woff2") format("woff2");
                font-weight: <?php echo $font_weight; ?>;
                font-style: normal;
                }
				<?php
			}
			echo 'body{font-family: "' . $font_family['font-family'] . '", sans-serif}';
		}
		else {
			echo 'body{font-family: "' . $font_family['font-family'] . '", sans-serif}';
		}
	}
}

$color = get_theme_mod( 'primary_color', '#0088cc' );
if ( $color != '#0088cc' ) {
	?>
    :root{--color-accent:<?php echo $color; ?>}
    .btn-main,
    a.btn-main,
    .coockies button,
    .btn-close,
    .services__link,
    .services__link:hover,
    .pagination__link,
    .aside .widget_nav_menu ul a:hover,
    .reviews__link,
    .reviews__link:hover,
    .author-social span:hover,
    .block-authors-info .author-info__name:hover,
    .block-authors-info .author-social__list span:hover,
    .section-post .posts-navigation__button:hover .posts-navigation__title,
    .section-post .posts-navigation__button:hover .posts-navigation__name,
    .author-info__name .name,
    .leave-comment .logged-in-as a,
    .comment-list .comment-author,
    .comment-list .comment-author a,
    .comment-list .comment-actions .comment-reply-link,
    .comment-reply-title a,
    .section-post__editor .wp-block-pullquote:before,
    .section-post__editor .wp-block-buttons .wp-block-button__link,
    .section-post .post-edit-link,
    .comment-text a,
    .breadcrumb a,
    .breadcrumb span,
    .wpcf7 a,
    .text_before_promo a,
    .entry-content .wpcf7-form input[type="submit"],
    .contact-us-form .wpcf7-form input[type=submit],
    .time-left .wpcf7-form input[type=submit],
    .header-top__account .account-options a,
    #buddypress .activity-type-navs ul li a, #buddypress .main-navs ul li a, #buddypress .bp-navs ul li a, #buddypress .button-tabs li a, #buddypress .avatar-nav-items li a,
    #buddypress input[type="submit"], #buddypress .activity-read-more a,
    #buddypress .feed a:hover,
    #buddypress .count,
    #buddypress .activity-type-navs ul li a:hover .count, #buddypress .main-navs ul li a:hover .count, #buddypress .bp-navs ul li a:hover .count, #buddypress .button-tabs li a:hover .count, #buddypress .avatar-nav-items li a:hover .count,
    #buddypress #activity-stream .activity-header p a:first-of-type,
    .dashicons-search:before,
    #bbpress-forums input[type="submit"], #bbpress-forums button[type="submit"], .bbpress input[type="submit"], .bbpress button[type="submit"],
    .nav-links a,
    main .content__col_big #bbpress-forums input[type="submit"], main .content__col_big #bbpress-forums button[type="submit"], .bbpress main .content__col_big input[type="submit"], .bbpress main .content__col_big button[type="submit"], aside .bbp-search-form input[type="submit"], aside .bbp-login-form button[type="submit"], aside .bbp-login-form input[type="submit"],
    aside .widget_display_replies a, aside .widget_display_topics a, aside .widget_display_views a, aside .widget_display_forums a, aside .bbp-logged-in a,
    aside .widget.buddypress a, aside .widget_yarpp_widget a, aside .widget_yarpp_widget ol li::marker,
    body .coockies button:hover,
    .popup_wescle input[type="submit"],
    .table-of-contents ol li:before,
    .aside .widget:not(.widget_nav_menu) ul a,
    .aside .widget_calendar a,
    .aside .widget_search button[type=submit], .aside .widget_search input[type=submit],
    .header__logo-text:hover,
    .section-post .post-info__icon circle, .section-post .post-info__icon rect, .section-post .post-info__icon line, .post-info__icon polyline,
    .page-restrict-output input[type="submit"], .post-password-form input[type="submit"],
    .page-restrict-output a,
    .contact-us__tel a,
    .btn_expand,
    .entry-content .js-link:not(.btn),
    .how-we-working__subtitle,
    .events-block__link, .events-block__link:hover,
    .schedule-block-item__description-title strong,
    .packages-include__table-price-current,
    .advantages-v2__title strong,
    .products-section__link, .products-section__link:hover,
    .products-section-item__price-current,
    .aside-store-checkboxes__count,
    .aside-order__tel,
    .aside-order a.aside-order__tel:not(:hover), .aside-order span.aside-order__tel:not(:hover),
    .wp-block-latest-comments a,
    .aside .widget ul a,
    .view-more,
    .services-v2 .title strong,
    html.page404 .error-no {
    color: <?php echo $color; ?>;
    }

    ol li::marker, ul li::marker {
    color: <?php echo $color; ?> !important;
    }

    .btn-main:hover,
    .item-bonus-one:hover .btn-main,
    .item-bonus .btn-main:hover,
    .coockies button:hover,
    .btn-main_blue,
    .slider-buttons__item,
    .title_divider:after,
    .services__link:after,
    .pagination__link:hover,
    .pagination__link_prev,
    .pagination__link_current,
    .pagination__link_next,
    .aside .widget_nav_menu ul a:before,
    .aside .widget ul a::after,
    .reviews__link:after,
    .leave-comment .logged-in-as a:after,
    .comment-list .comment-author a:after,
    .comment-list .comment-actions .comment-reply-link:after,
    .comment-reply-title a:after,
    .section-post__editor .wp-block-buttons .wp-block-button__link:hover,
    .entry-content .wpcf7-form .wpcf7-radio label span:after,
    .entry-content .wpcf7-form .wpcf7-checkbox label span:after,
    .entry-content .wpcf7-form input[type="submit"]:hover,
    .contact-us-form .wpcf7-form input[type=submit]:hover,
    .entry-content .wpcf7-form span.wpcf7-form-control-wrap[class*="acceptance"] label span:after,
    .time-left .wpcf7-form span.wpcf7-form-control-wrap[class*=acceptance] label span:after,
    #buddypress .activity-type-navs ul li.selected a, #buddypress .main-navs ul li.selected a, #buddypress .bp-navs ul li.selected a, #buddypress .button-tabs li.current a, #buddypress .avatar-nav-items li.current a,
    #buddypress .activity-type-navs ul li a:hover, #buddypress .main-navs ul li a:hover, #buddypress .bp-navs ul li a:hover, #buddypress .button-tabs li a:hover, #buddypress .avatar-nav-items li a:hover,
    #buddypress .bp-icon,
    #buddypress input[type="submit"]:hover, #buddypress .activity-read-more a:hover,
    #bbpress-forums input[type="submit"]:hover, #bbpress-forums button[type="submit"]:hover, .bbpress input[type="submit"]:hover, .bbpress button[type="submit"]:hover,
    main .content__col_big #bbpress-forums input[type="submit"]:hover, main .content__col_big #bbpress-forums button[type="submit"]:hover, .bbpress main .content__col_big input[type="submit"]:hover, .bbpress main .content__col_big button[type="submit"]:hover, aside .bbp-search-form input[type="submit"]:hover, aside .bbp-login-form button[type="submit"]:hover, aside .bbp-login-form input[type="submit"]:hover,
    aside .widget_display_replies a:after, aside .widget_display_topics a:after, aside .widget_display_views a:after, aside .widget_display_forums a:after, aside .bbp-logged-in a:after,
    .faq-item__title:before,
    .entry-content .wpcf7-form span.wpcf7-form-control-wrap[class*="acceptance"] label span:after, .popup_wescle .wpcf7-form span.wpcf7-form-control-wrap[class*="acceptance"] label span:after,
    .entry-content .wpcf7-form input[type="submit"]:hover, .popup_wescle .wpcf7-form input[type="submit"]:hover,
    .time-left .wpcf7-form input[type=submit]:hover,
    .post-nav-links .post-page-numbers.current,
    .price:not(.product-cart__price):not(._price),
    .aside .widget_search button[type=submit]:hover, .aside .widget_search input[type=submit]:hover,
    .page-restrict-output input[type="submit"]:hover, .post-password-form input[type="submit"]:hover,
    .how-we-working-item:after, .how-we-working-item:before,
    .timer-block__progress-line,
    .events-block__link:after,
    .price-list-item__title:before,
    .schedule-block-item__about:before,
    .instruction-item__title:before,
    .our-works__filters-item .btn.active,
    .products-section__link:after,
    .aside .widget ul a:before,
    .section-post .post-edit-link:after,
    .mess-widget-chat .btn-close, .mess-widget__btn:not(:hover):before, .mess-widget__btn, .mess-widget-block__header, .mess-widget-block .btn-close,
    .section-tags-wrapper button,
    .mess-widget-block__item-icon,
    .schedule-block-top__item-title:after {
    background-color: <?php echo $color; ?>;
    }

    .post-nav-links .post-page-numbers.current {
    background: <?php echo $color; ?>;
    }

    .top-banner__link:hover,
    a.btn-main:hover,
    .btn.btn-main_blue,
    .item-bonus-one:hover .btn-main,
    .page-restrict-output input[type="submit"]:hover, .post-password-form input[type="submit"]:hover,
    .aside .widget_search button[type=submit]:hover, .aside .widget_search input[type=submit]:hover {
    color: #fff;
    }

    .top-banner__link:hover span {
    text-decoration: none;
    }

    #buddypress .count, body .coockies button:hover {
    background-color: #fff;
    }

    .btn-main,
    .item-bonus-one:hover .btn-main,
    .item-bonus .btn-main:hover,
    .form-checkbox:checked + label:before,
    .pagination__link,
    .block-authors-info .author-info__photo:hover,
    .section-post__quote,
    .section-post__editor .wp-block-quote,
    .section-post__editor .wp-block-buttons .wp-block-button__link,
    .wpcf7-acceptance input:checked + .wpcf7-list-item-label:before,
    .section-post__editor blockquote,
    .text blockquote,
    .entry-content .wpcf7-form .wpcf7-checkbox label input:checked + span:before,
    .entry-content .wpcf7-form .wpcf7-radio label input:checked + span:before,
    .time-left .wpcf7-form span.wpcf7-form-control-wrap[class*=acceptance] input:checked+span:before,
    .entry-content .wpcf7-form input[type="submit"],
    .contact-us-form .wpcf7-form input[type=submit],
    .entry-content .wpcf7-form span.wpcf7-form-control-wrap[class*="acceptance"] input:checked + span:before,
    .header-top__account .account,
    #buddypress .activity-type-navs ul li a, #buddypress .main-navs ul li a, #buddypress .bp-navs ul li a, #buddypress .button-tabs li a, #buddypress .avatar-nav-items li a,
    #buddypress input[type="submit"], #buddypress .activity-read-more a,
    #buddypress .dir-search form button:hover,
    #bbpress-forums input[type="submit"], #bbpress-forums button[type="submit"], .bbpress input[type="submit"], .bbpress button[type="submit"],
    main .content__col_big #bbpress-forums input[type="submit"], main .content__col_big #bbpress-forums button[type="submit"], .bbpress main .content__col_big input[type="submit"], .bbpress main .content__col_big button[type="submit"], aside .bbp-search-form input[type="submit"], aside .bbp-login-form button[type="submit"], aside .bbp-login-form input[type="submit"],
    .navigation-langs li span:after,
    .entry-content .wpcf7-form span.wpcf7-form-control-wrap[class*="acceptance"] input:checked + span:before, .popup_wescle .wpcf7-form span.wpcf7-form-control-wrap[class*="acceptance"] input:checked + span:before,
    .entry-content .wpcf7-form input[type="submit"], .popup_wescle .wpcf7-form input[type="submit"],
    .time-left .wpcf7-form input[type=submit],
    .section-post__editor ul li:before,
    .post-nav-links .post-page-numbers.current,
    .aside .widget_search button[type=submit], .aside .widget_search input[type=submit],
    .page-restrict-output input[type="submit"], .post-password-form input[type="submit"],
    .tarrif-plan-item_recommended,
    .aside-store-checkboxes li a:hover .aside-store-checkboxes__check,
    .aside-store-checkboxes li.chosen a .aside-store-checkboxes__check,
    .aside-order .aside-order-socials__item:hover,
    .mess-widget-block .author-mess__availability,
    html.page404 .moon {
    border-color: <?php echo $color; ?>;
    }

    .tooltip_top.tooltip:after {
    border-top-color: <?php echo $color; ?>;
    }

    .icon-telephone path,
    .socials__link svg path,
    .scroll-up:hover svg path,
    .call-button:hover svg path,
    .mail-button:hover svg path,
    .author-social span:hover svg path,
    .block-authors-info .author-social__list span:hover svg path,
    .share__list li:hover path,
    .author-info .author-social__list li span:hover svg path,
    .reviews-slider-item__body .icon-quote svg path,
    .wpcf7-acceptance .icon-check svg path,
    .navigation-langs__toggle:hover svg path,
    .team-item__contacts a svg path, .team-item__contacts span svg path,
    .section-post .post-info__item_comments .post-info__icon path,
    .characteristics__list-img svg path,
    .icon-location path,
    .btn-search:hover .icon-search path,
    .scroll-up svg path,
    .email__link svg path, .footer .location__link svg path,
    .location__link:not(:hover) svg path, .email__link:not(:hover) svg path,
    .email__link:hover svg path, .footer .location__link:hover svg path,
    .aside-store-checkboxes li a:hover .aside-store-checkboxes__check svg path,
    .aside-store-checkboxes li.chosen a .aside-store-checkboxes__check svg path,
    .checkbox-label .icon-check svg path,
    .mess-widget__btn ._dynamic .mess-widget__icons svg path,
    .videos-slider-item__actions-item:hover svg path,
    .about-team-item__socials-item:hover path {
    fill: <?php echo $color; ?>;
    }

    .footer .location__link:hover svg path,
    .footer .dropdown-toggle.telephone_dark .social-telephone .icon-telephone path {
    fill: <?php echo $color; ?> !important;
    }

    .section-post .posts-navigation__button:hover svg path,
    .btn_expand svg path,
    .section-post .post-info__icon path {
    stroke: <?php echo $color; ?>;
    }
	<?php list( $r, $g, $b ) = sscanf( $color, "#%02x%02x%02x" ); ?>
    .advantages-v2-item__img:before{
    border-color:rgba(<?php echo $r; ?>,<?php echo $g; ?>,<?php echo $b; ?>,.1);
    }

    .recommended-post .actions-post__views svg path,
    .recommended-post .btn-info-post svg path,
    .latest-post .actions-post__views svg path,
    .latest-post .btn-info-post svg path,
    .popular-post .actions-post__views svg path,
    .popular-post .btn-info-post svg path,
    .section-post .actions-post__comments-btn svg path,
    .section-post .actions-post__views svg path {
    fill: <?php echo $color; ?>;
    }
	<?php
	if ( Helper::is_woocommerce_active() ) {
		?>
        .woocommerce div.product form.cart.grouped_form a,
        body.small-layout .product-cart__price,
        body .product-cart__price,
        .product-cart__add-cart a:not(:hover),
        body.products-by-list .product-cart__add-cart a:not(:hover),
        body.products-by-list .product-cart__quick-view a:hover,
        .product-cart .product-cart__quick-view a:hover,
        .woocommerce-account .woocommerce-MyAccount-navigation a:not(:hover),
        .woocommerce-account .woocommerce-MyAccount-content a:not(:hover),
        .woocommerce-info::before,
        .woocommerce table.shop_table td a,
        .woocommerce-form-login p a,
        .woocommerce div.product .woocommerce-grouped-product-list-item__price, .woocommerce div.product p.price, .woocommerce div.product span.price,
        .woocommerce div.product .product_meta>* a,
        .woocommerce div.product form.cart .reset_variations,
        .woocommerce div.product .woocommerce-Reviews .stars a,
        .woocommerce-info a:focus, .woocommerce-info a:hover,
        .woocommerce-form-coupon-toggle .woocommerce-info:before,
        .goods-slider-section__link:not(:hover),
        body .product-cart a.added_to_cart:hover,
        body .product-cart a.wescle_added_to_wishlist:hover,
        .woocommerce-checkout-payment .wc_payment_methods li:before,
        .wp-block-product-best-sellers .wc-block-grid__products .wc-block-grid__product-price, .wp-block-product-category .wc-block-grid__products .wc-block-grid__product-price, .wp-block-product-on-sale .wc-block-grid__products .wc-block-grid__product-price, .wp-block-product-tag .wc-block-grid__products .wc-block-grid__product-price, .wp-block-product-top-rated .wc-block-grid__products .wc-block-grid__product-price, .wp-block-products-by-attribute .wc-block-grid__products .wc-block-grid__product-price, .wp-block-woocommerce-all-products .wc-block-grid__products .wc-block-grid__product-price,
        .wp-block-product-best-sellers .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-product-category .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-product-on-sale .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-product-tag .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-product-top-rated .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-products-by-attribute .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-woocommerce-all-products .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button,
        .wp-block-product-best-sellers .wc-block-grid__products .wc-block-grid__product-add-to-cart .added_to_cart:hover, .wp-block-product-category .wc-block-grid__products .wc-block-grid__product-add-to-cart .added_to_cart:hover, .wp-block-product-on-sale .wc-block-grid__products .wc-block-grid__product-add-to-cart .added_to_cart:hover, .wp-block-product-tag .wc-block-grid__products .wc-block-grid__product-add-to-cart .added_to_cart:hover, .wp-block-product-top-rated .wc-block-grid__products .wc-block-grid__product-add-to-cart .added_to_cart:hover, .wp-block-products-by-attribute .wc-block-grid__products .wc-block-grid__product-add-to-cart .added_to_cart:hover, .wp-block-woocommerce-all-products .wc-block-grid__products .wc-block-grid__product-add-to-cart .added_to_cart:hover,
        .wc-block-pagination button {
        color: <?php echo $color; ?>;
        }

        .woocommerce div.product .woocommerce-tabs ul.wc-tabs li a {
        color: <?php echo $color; ?> !important;
        }

        .product-cart__add-cart a,
        .product-cart__wishlist a,
        body.products-by-list .product-cart__add-cart a,
        body.products-by-list .product-cart__wishlist a,
        .woocommerce-account .woocommerce-MyAccount-navigation a,
        .woocommerce-info,
        .woocommerce div.product form.cart .reset_variations,
        .woocommerce-form-coupon-toggle .woocommerce-info,
        .woocommerce-checkout-payment .wc_payment_methods li,
        .woocommerce div.product .woocommerce-Reviews .comment-form-cookies-consent input:checked+label:before,
        .payment_methods li input:checked+label:before,
        .wp-block-product-best-sellers .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-product-category .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-product-on-sale .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-product-tag .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-product-top-rated .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-products-by-attribute .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button, .wp-block-woocommerce-all-products .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button,
        .wc-block-pagination button,
        .wc-block-featured-category .wp-block-button__link {
        border-color: <?php echo $color; ?>;
        }

        .product-cart__sale,
        body .widget_price_filter .ui-slider .ui-slider-handle, body .widget_price_filter .ui-slider .ui-slider-range,
        body.products-by-list .product-cart__wishlist a:hover,
        body.products-by-list .product-cart__add-cart a:hover,
        body.products-by-list .product-cart__sale,
        .product-cart__wishlist a:hover, .product-cart__wishlist a.active,
        .product-cart__add-cart a:hover,
        .header .vertical-menu button,
        .woocommerce-account .woocommerce-MyAccount-navigation li.is-active a,
        .woocommerce-account .woocommerce-MyAccount-navigation a:focus, .woocommerce-account .woocommerce-MyAccount-navigation a:hover,
        .woocommerce-info a:after,
        .payment_methods li label:after,
        .goods-main-item.item-bonus-one:hover .btn-main,
        .goods-slider-section__link:after,
        .woocommerce div.product .woocommerce-Reviews .comment-form-cookies-consent label:after,
        .product-cart__added .tooltip, .tooltip,
        .woocommerce-store-notice, p.demo_store,
        .wp-block-product-best-sellers .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button:hover, .wp-block-product-category .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button:hover, .wp-block-product-on-sale .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button:hover, .wp-block-product-tag .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button:hover, .wp-block-product-top-rated .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button:hover, .wp-block-products-by-attribute .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button:hover, .wp-block-woocommerce-all-products .wc-block-grid__products .wc-block-grid__product-add-to-cart .add_to_cart_button:hover,
        .wc-block-pagination button.wc-block-pagination-page--active,
        .wc-block-featured-category .wp-block-button__link {
        background-color: <?php echo $color; ?>;
        }

        .wc-block-pagination button:hover {
        background-color: <?php echo $color; ?> !important;
        }

        .woocommerce .single_add_to_cart_button.clickBuyButton,
        .awooc-custom-order-button {
        background-color: <?php echo $color; ?> !important;
        border-color: <?php echo $color; ?> !important;
        }

        .goods-main-item.item-bonus-one:hover .btn-main,
        .woocommerce div.product form.cart button.awooc-custom-order-button:hover {
        color: #fff;
        }

        .woocommerce div.product .woocommerce-tabs ul.wc-tabs li {
        border-color: <?php echo $color; ?> !important;
        }

        .product-cart__sale:before,
        body.products-by-list .product-cart__sale:before {
        border-color: <?php echo $color; ?> transparent transparent <?php echo $color; ?>;
        }

        .product-cart__added .tooltip:after {
        border-right-color: <?php echo $color; ?>;
        }

        .tooltip_bottom.tooltip:after {
        border-bottom-color: <?php echo $color; ?>;
        }

        .product-cart__wishlist a:not(:hover) svg path,
        body.products-by-list .product-cart__wishlist a:not(:hover) svg path,
        .display-mode a:hover svg path,
        .display-mode a.active svg path,
        .navigation-store__cart:hover path, .navigation-store__wishlist:hover path, .navigation-store__acc:hover path,
        .product-cart__quick-view a:hover svg circle, .product-cart__quick-view a:hover svg path,
        .navigation-store__cart .cart-contents._active svg path,
        .header-filters.js-active>button path,
        .wp-block-woocommerce-product-search .wc-block-product-search__fields .wc-block-product-search__button path {
        fill: <?php echo $color; ?>;
        }
        .product-cart__wishlist a.active svg path,
        body.products-by-list .product-cart__wishlist a.active svg path {
        fill: #fff;
        }
        @media (max-width: 414px) and (min-width: 375px) {
        .product-cart__add-cart a svg circle, .product-cart__add-cart a svg path {
        fill: <?php echo $color; ?>;
        }
        }
		<?php
		if ( Helper::is_plugin_active( 'woocommerce-ajax-filters/woocommerce-filters.php' ) ) {
			?>
            .berocket_single_filter_widget .bapf_hideckbox ul li input[type=checkbox]:checked+label,
            .berocket_single_filter_widget .bapf_ckbox ul li label {
            color: <?php echo $color; ?>;
            }
            .berocket_single_filter_widget .bapf_ckbox_square ul li input[type=checkbox]:checked,
            .berocket_single_filter_widget .bapf_asradio2 ul li input[type=checkbox]:checked,
            .berocket_single_filter_widget .bapf_sfilter .bapf_button,
            .berocket_single_filter_widget .bapf_sfilter .bapf_button:hover {
            background-color: <?php echo $color; ?>;
            }
            .berocket_single_filter_widget .bapf_ckbox_square ul li input[type=checkbox]:checked,
            .berocket_single_filter_widget .bapf_ckbox ul li input[type=checkbox]:checked,
            .berocket_single_filter_widget .bapf_sfilter .bapf_button {
            border-color: <?php echo $color; ?>;
            }
            .berocket_single_filter_widget .bapf_ckbox ul li input[type=checkbox]:checked:after {
            border-bottom-color: <?php echo $color; ?>;
            border-right-color: <?php echo $color; ?>;
            }
			<?php
		}
	}
}

$color_hover = get_theme_mod( 'primary_color_hover', '#0056b3' );
if ( $color_hover != '#0056b3' ) {
	?>
    :root{--color-accent-hover:<?php echo $color_hover; ?>}
    .author-info__name a.name:hover,
    .comment-list .comment-author a:hover,
    .comment-list .comment-actions .comment-reply-link:hover,
    .comment-reply-title a:hover,
    .entry-content .js-link:not(.btn):hover,
    .contact-us__tel a:hover,
    body .widget ul a:hover,
    .table-of-contents a:hover,
    .woocommerce-account .woocommerce-MyAccount-content a:hover,
    .aside-order a.aside-order__tel:hover, .aside-order span.aside-order__tel:hover,
    .aside-order .aside-order-socials__item:hover span,
    .aside .aside-store-categories li a:hover, .aside .aside-store-categories li>span:hover,
    .partners-item__contacts-item a:hover, .partners-item__name:hover,
    .about-team-item__contacts-item_inner a:hover,
    .popular-post .post__title .title:hover,
    .latest-post .post__title .title:hover,
    .price-list-item a:hover,
    .recommended-post .post__title .title:hover {
    color: <?php echo $color_hover; ?>;
    }

    .comment-list .comment-actions .comment-reply-link:hover:after,
    .contact-us__tel a:after,
    body .widget ul a:after,
    .comment-list .comment-author a:hover:after,
    .mess-widget__btn:hover, .mess-widget__btn:hover:before, .mess-widget-block .btn-close:hover, .mess-widget-chat .btn-close:hover,
    .mess-widget__btn:hover:before {
    background-color: <?php echo $color_hover; ?>;
    }

    .socials__link:hover svg path {
    fill: <?php echo $color_hover; ?>;
    }
	<?php
	if ( Helper::is_woocommerce_active() ) {
		?>
        .header .vertical-menu .vertical-menu__body a:hover,
        .vertical-menu .vertical-menu__body li a:hover, .vertical-menu .vertical-menu__body li>span:hover,
        body .woocommerce table.shop_table td a:focus, body .woocommerce table.shop_table td a:hover,
        .goods-slider-section__link:hover,
        .goods-categories-item:hover,
        .product-cart .product-cart__name a:hover,
        .aside-store .widget a:hover,
        .product-cart .product-cart__categories a:hover,
        body.products-by-list .product-cart .product-cart__categories a:hover,
        .woocommerce-form-login p a:hover,
        .woocommerce div.product .product_meta>* a:hover,
        .wp-block-product-best-sellers .wc-block-grid__products .wc-block-components-product-name:hover, .wp-block-product-best-sellers .wc-block-grid__products .wc-block-grid__product-title:hover, .wp-block-product-category .wc-block-grid__products .wc-block-components-product-name:hover, .wp-block-product-category .wc-block-grid__products .wc-block-grid__product-title:hover, .wp-block-product-on-sale .wc-block-grid__products .wc-block-components-product-name:hover, .wp-block-product-on-sale .wc-block-grid__products .wc-block-grid__product-title:hover, .wp-block-product-tag .wc-block-grid__products .wc-block-components-product-name:hover, .wp-block-product-tag .wc-block-grid__products .wc-block-grid__product-title:hover, .wp-block-product-top-rated .wc-block-grid__products .wc-block-components-product-name:hover, .wp-block-product-top-rated .wc-block-grid__products .wc-block-grid__product-title:hover, .wp-block-products-by-attribute .wc-block-grid__products .wc-block-components-product-name:hover, .wp-block-products-by-attribute .wc-block-grid__products .wc-block-grid__product-title:hover, .wp-block-woocommerce-all-products .wc-block-grid__products .wc-block-components-product-name:hover, .wp-block-woocommerce-all-products .wc-block-grid__products .wc-block-grid__product-title:hover {
        color: <?php echo $color_hover; ?>;
        }

        .woocommerce-account .woocommerce-MyAccount-content a:not(.button):after,
        .woocommerce table.shop_table td a:after,
        .goods-slider-section__link:after,
        .woocommerce-form-login p a:after {
        background: <?php echo $color_hover; ?>;
        }

        .aside .aside-store-categories li:hover [class^=icon-arrow] path,
        .header .vertical-menu .vertical-menu__body li:hover [class^=icon-arrow] path,
        .vertical-menu .vertical-menu__body li:hover [class^=icon-arrow] path,
        body.sidebar-right .aside-store-categories li:hover [class^=icon-arrow] path {
        stroke: <?php echo $color_hover; ?>;
        }
		<?php
	}
}

$color = get_theme_mod( 'second_color', '#484848' );
if ( $color != '#484848' ) {
	?>
    :root{--color-secondary:<?php echo $color; ?>}
    .form-search__input::-webkit-input-placeholder {
    color: <?php echo $color; ?>;
    }

    .location__link,
    .location__link:hover,
    .telephone:hover .telephone__link,
    .telephone__link,
    .telephones__link,
    .telephones__link:hover,
    .form-search__input,
    .form-search__input::-webkit-input-placeholder,
    .form-search__input::-moz-placeholder,
    .form-search__input::-ms-input-placeholder,
    .form-search__input::placeholder,
    .form-search__btn,
    .form-input,
    .header__search-form .btn-close,
    .header-top__link,
    .header-top__link:hover,
    .navigation__item:hover > a,
    .navigation__link,
    .navigation__link:after,
    .navigation__subitem:hover > a,
    .navigation__sublink,
    .navigation__sublink:hover,
    .navigation-sublist-yet .navigation__link,
    .navigation-sublist-yet .navigation__link:hover,
    .services__text,
    .recommended-post .post__title .title,
    .recommended-post .author:hover .author__name,
    .recommended-post .author:hover .author__post-date,
    .recommended-post .author__name,
    .recommended-post .author__post-date,
    .latest-post .post__title .title,
    .latest-post .author:hover .author__name,
    .latest-post .author:hover .author__post-date,
    .latest-post .author__name,
    .latest-post .author__post-date,
    .aside .widget_nav_menu ul a,
    .popular-post .post__title .title,
    .popular-post .author:hover .author__name,
    .popular-post .author:hover .author__post-date,
    .popular-post .author__name,
    .popular-post .author__post-date,
    .authors-section .author:hover .author__name,
    .authors-section .author:hover .author__posts,
    .authors-section .author__name,
    .authors-section .author__posts,
    .advertising__item:hover .advertising__title,
    .advertising__item:hover .advertising__text,
    .advertising__title,
    .advertising__text,
    .reviews-slider-item .author:hover .author__name,
    .reviews-slider-item .author__name,
    .reviews-slider-item .author__position,
    .section-post .author,
    .section-post .author__name,
    .section-post .author__post-date,
    .section-post .author:hover,
    .section-post .author:hover .author__name,
    .section-post .author:hover .author__post-date,
    .post-nav-links .label,
    .comment-list .comment-text,
    .comment-reply-title,
    .section-post__editor .wp-block-media-text.alignwide.is-stacked-on-mobile p {
    color: <?php echo $color; ?>;
    }
    ::-moz-selection {
    background: <?php echo $color; ?>;
    }

    ::-moz-selection,
    ::selection,
    .navigation-list-yet .navigation__link span,
    .icon-menu span,
    .footer__top:after,
    .footer__body:after,
    .footer .dropdown-toggle:hover .telephone__actions,
    .footer .dropdown-toggle:hover .telephones,
    .recommended-post .author:hover .author__name:after,
    .recommended-post .author__name:after,
    .latest-post .author:hover .author__name:after,
    .popular-post .author:hover .author__name:after,
    .popular-post .author__name:after,
    .section-post .author__name:after,
    .section-post .author:hover .author__name:after {
    background: <?php echo $color; ?>;
    }
    .checkbox-label:before {
    border-color: <?php echo $color; ?>;
    }
    .telephone:hover .icon-arrow-bottom g,
    .navigation__item:hover .icon-arrow-bottom g {
    stroke: <?php echo $color; ?>;
    }
	<?php
	if ( Helper::is_woocommerce_active() ) {
		?>

		<?php
	}
}

$color = get_theme_mod( 'color_red', '#ef383f' );
if ( $color != '#ef383f' ) {
	?>
    :root{--color-red:<?php echo $color; ?>}
	<?php
}
$color = get_theme_mod( 'color_green', '#2f9c0a' );
if ( $color != '#2f9c0a' ) {
	?>
    :root{--color-green:<?php echo $color; ?>}
	<?php
}

$woo_fonts_assets = get_template_directory_uri() . '/assets/fonts';
echo '@font-face {
  font-family: star;
  src: url(' . $woo_fonts_assets . '/star.eot);
  src: url(' . $woo_fonts_assets . '/star.eot?#iefix) format("embedded-opentype"), url(' . $woo_fonts_assets . '/star.woff) format("woff"), url(' . $woo_fonts_assets . '/star.ttf) format("truetype"), url(' . $woo_fonts_assets . '/star.svg#star) format("svg");
  font-weight: 400;
  font-style: normal
}';

if ( Helper::is_woocommerce_active() ) {
	$bg_cart = get_theme_mod( 'header_store_cart_bg_color', 'rgba(0,0,0,0.5)' );
	if ( $bg_cart != 'rgba(0,0,0,0.5)' ) {
		echo 'body._cart-big .navigation-store__cart .widget_shopping_cart{background:' . $bg_cart . '}';
	}
}

$color_scroll = get_theme_mod( 'color_scroll', '#888888' );
if ( $color_scroll != '#888888' ) {
	?>
    ::-webkit-scrollbar-thumb,
    .header .vertical-menu .vertical-menu__body .vertical-submenu::-webkit-scrollbar-thumb,
    .header .vertical-menu .vertical-menu__body::-webkit-scrollbar-thumb,
    .vertical-menu .vertical-menu__body .vertical-submenu::-webkit-scrollbar-thumb,
    .vertical-menu .vertical-menu__body::-webkit-scrollbar-thumb {background:<?php echo $color_scroll; ?>}
	<?php
}

$color_scroll_hover = get_theme_mod( 'color_scroll_hover', '#555555' );
if ( $color_scroll_hover != '#555555' ) {
	?>
    ::-webkit-scrollbar-thumb:hover,
    .header .vertical-menu .vertical-menu__body .vertical-submenu::-webkit-scrollbar-thumb:hover,
    .header .vertical-menu .vertical-menu__body::-webkit-scrollbar-thumb:hover,
    .vertical-menu .vertical-menu__body .vertical-submenu::-webkit-scrollbar-thumb:hover,
    .vertical-menu .vertical-menu__body::-webkit-scrollbar-thumb:hover {background:<?php echo $color_scroll_hover; ?>}
	<?php
}

$color = get_theme_mod( 'bg_scroll' );
if ( $color ) {
	?>
    ::-webkit-scrollbar-track{background:<?php echo $color; ?>}
	<?php
}

$width_scroll = get_theme_mod( 'width_scroll' );
if ( $width_scroll && $width_scroll != 7 ) {
	?>
    :root{--scrollbarWidth:<?php echo $width_scroll; ?>px}
	<?php
}

$width_scroll = get_theme_mod( 'width_scroll_block' );
if ( $width_scroll && $width_scroll != 5 ) {
	?>
    :root{--scrollbarBlockWidth:<?php echo $width_scroll; ?>px}
	<?php
}

if ( Helper::is_frontpage_assets() ) {
	if ( get_theme_mod( 'home_advantages_enabled' ) ) {
		$advantages_maxwidth = get_theme_mod( 'home_advantages_maxwidth', 50 );
		if ( $advantages_maxwidth != 50 ) {
			?>
            .advantages-item__img, body.small-layout .advantages .advantages-item__img {
            flex: 0 0 <?php echo $advantages_maxwidth; ?>px;
            width: <?php echo $advantages_maxwidth; ?>px;
            height: <?php echo $advantages_maxwidth; ?>px;
            }
			<?php
		}
	}

	if ( get_theme_mod( 'home_advantages2_enabled' ) ) {
		$advantages_maxwidth = get_theme_mod( 'home_advantages2_maxwidth', 50 );
		if ( $advantages_maxwidth != 50 ) {
			?>
            .advantages-double .advantages-item__img, body.small-layout .advantages-double .advantages-item__img {
            flex: 0 0 <?php echo $advantages_maxwidth; ?>px;
            width: <?php echo $advantages_maxwidth; ?>px;
            height: <?php echo $advantages_maxwidth; ?>px;
            }
			<?php
		}
	}

	$home_services_items = get_theme_mod( 'home_services2_items', [] );
	foreach ( $home_services_items as $key => $item ) {
		$maxwidth = isset( $item['maxwidth'] ) ? intval( $item['maxwidth'] ) : 50;
		if ( $maxwidth && $maxwidth != 50 ) {
			if ( $maxwidth > 200 ) {
				$maxwidth = 200;
			}
			?>
            body.home .services-v2-item__<?php echo $key; ?> {
            flex: 0 0 <?php echo $maxwidth; ?>px;
            width: <?php echo $maxwidth; ?>px;
            height: <?php echo $maxwidth; ?>px;
            }
			<?php
		}
	}
}

if ( Helper::is_frontpage_assets() && get_theme_mod( 'home_how_work_enabled' ) ) {
	$home_how_work_maxwidth = get_theme_mod( 'home_how_work_maxwidth', 40 );
	if ( $home_how_work_maxwidth != 40 ) {
		?>
        .how-we-working-item .how-we-working-item__img {
        width: <?php echo $home_how_work_maxwidth; ?>px;
        height: <?php echo $home_how_work_maxwidth; ?>px;
        }
		<?php
	}

	if ( get_theme_mod( 'home_how_work_image_center' ) ) {
		?>
        .how-we-working-item__img {
        margin-left: auto;
        margin-right: auto;
        }
        .how-we-working-item__img img {
        display: block;
        margin-left: auto;
        margin-right: auto;
        }
		<?php
	}
}

if ( Helper::is_frontpage_assets() && get_theme_mod( 'home_how_work2_enabled' ) ) {
	$home_how_work_maxwidth = get_theme_mod( 'home_how_work2_maxwidth', 40 );
	if ( $home_how_work_maxwidth != 40 ) {
		?>
        .how-we-working-v2-item .how-we-working-v2-item__img {
        flex: 0 0 <?php echo $home_how_work_maxwidth; ?>px;
        width: <?php echo $home_how_work_maxwidth; ?>px;
        height: <?php echo $home_how_work_maxwidth; ?>px;
        }
		<?php
	}
}

if ( Helper::is_frontpage_assets() && get_theme_mod( 'home_services_slider_enabled' ) ) {
	$maxwidth = get_theme_mod( 'home_services_slider_maxwidth', 70 );
	if ( $maxwidth != 70 ) {
		?>
        .additional-services-item__img {
        flex: 0 0 <?php echo $maxwidth; ?>px;
        width: <?php echo $maxwidth; ?>px;
        height: <?php echo $maxwidth; ?>px;
        }
		<?php
	}
}

if ( Helper::isset_block_content( 'additional-services' ) ) {
	$parse_content = parse_blocks( $post->post_content );
	foreach ( $parse_content as $item ) {
		if ( $item['blockName'] == 'wescle-blocks/additional-services' ) {
			$maxwidth = $item['attrs']['imgSize'] ?? '';
			if ( $maxwidth != 70 ) {
				?>
                .additional-services-item__img {
                flex: 0 0 <?php echo $maxwidth; ?>px;
                width: <?php echo $maxwidth; ?>px;
                height: <?php echo $maxwidth; ?>px;
                }
				<?php
			}
		}
	}
}

if ( Helper::is_frontpage_assets() && get_theme_mod( 'home_performance_enabled' ) ) {
	$max_height = get_theme_mod( 'home_performance_image_maxheight', 40 );
	if ( $max_height != 40 ) {
		?>
        .performance-item__img img, .performance-item__img svg {
        height: auto;
        max-height: <?php echo $max_height; ?>px;
        }
		<?php
	}
}

$bg_color = get_theme_mod( 'content_color_body_bg', '' );
if ( $bg_color ) {
	?>
    body,.changed-bg .content-title{background-color: <?php echo $bg_color; ?> !important;}
	<?php
	if ( strpos( $bg_color, 'rgba' ) !== false ) {
		$bg_color_arr = explode( ',', trim( str_replace( 'rgba(', '', $bg_color ), ')' ) );
		$r            = $bg_color_arr[0];
		$g            = $bg_color_arr[1];
		$b            = $bg_color_arr[2];
	}
	else {
		list( $r, $g, $b ) = sscanf( $bg_color, "#%02x%02x%02x" );
	}
	echo "body.home.air-style .schedule-block:not(._with-bg) .btn_expand:before, body.air-style .schedule-block:not(._with-bg) .btn_expand:before, 
	body.home.air-style .seo:not(._with-bg) .btn_expand:before, 
	body.home.changed-bg .schedule-block:not(._with-bg) .btn_expand:before, body.changed-bg .schedule-block:not(._with-bg) .btn_expand:before,
	body.home.changed-bg .seo:not(._with-bg) .btn_expand:before {background: -webkit-gradient(linear,left top,left bottom,from(rgba($r,$g,$b,.5)),color-stop(40%,rgba($r,$g,$b,.8)),color-stop(70%,$bg_color),to($bg_color)) !important;
        background: linear-gradient(rgba($r,$g,$b,.5) 0,rgba($r,$g,$b,.8) 40%,$bg_color 70%,$bg_color 100%) !important}";

	echo "body .section-tags-wrapper:after, body .section-tags-wrapper:before, body.air-style .section-tags-wrapper:after, body.air-style .section-tags-wrapper:before{
	    background: -webkit-gradient(linear,left top,right top,from($bg_color),color-stop(35%,rgba($r,$g,$b,.5)),to(rgba($r,$g,$b,0))); 
	    background: -o-linear-gradient(left,$bg_color 0,rgba($r,$g,$b,.5) 35%,rgba($r,$g,$b,0) 100%); 
	    background: linear-gradient(90deg,$bg_color 0,rgba($r,$g,$b,.5) 35%,rgba($r,$g,$b,0) 100%);}";
}

$bg_color = get_theme_mod( 'color_footer_bg', '#282828' );
if ( $bg_color != '#282828' ) {
	?>
    footer.footer {
    background-color: <?php echo $bg_color; ?> !important;
    }
	<?php
}

$color_title = get_theme_mod( 'color_footer_title', '#7c7c7d' );
if ( $color_title != '#7c7c7d' ) {
	?>
    .footer__label {
    color: <?php echo $color_title; ?> !important;
    }
	<?php
}

$color_line = get_theme_mod( 'color_footer_line', '#484848' );
if ( $color_line != '#484848' ) {
	?>
    .footer__top:after, .footer__body:after, .footer__label:after {
    background-color: <?php echo $color_line; ?> !important;
    }
    .footer__label svg path {
    stroke: <?php echo $color_line; ?>;
    }
	<?php
}

$color = get_theme_mod( 'color_footer_link', '#ffffff' );
if ( $color != '#ffffff' ) {
	?>
    .footer-nav a, .footer-nav__link, body .footer .widget ul a {
    color: <?php echo $color; ?> !important;
    }
	<?php
}

$color = get_theme_mod( 'color_footer_link_hover', '#7c7c7d' );
if ( $color != '#7c7c7d' ) {
	?>
    .footer-nav a:hover, .footer-nav__link:hover, body .footer .widget ul a:hover {
    color: <?php echo $color; ?> !important;
    }
    body .footer .widget ul a:after {
    background: <?php echo $color; ?> !important;
    }
	<?php
}

$color = get_theme_mod( 'color_footer_text', '#ffffff' );
if ( $color != '#ffffff' ) {
	?>
    footer.footer, .footer__copyright, .form-subscribe__label, .footer__text,
    .footer__body .footer__contacts a:not(:hover), .footer .telephone__schedule, .footer .location__link {
    color: <?php echo $color; ?>;
    }
    .footer .fcls-1 {
    fill: <?php echo $color; ?>;
    }
	<?php
}

$h1_pc     = get_theme_mod( 'font_size_h1_desktop', 10 );
$h1_tablet = get_theme_mod( 'font_size_h1_tablet', 10 );
$h1_mobile = get_theme_mod( 'font_size_h1_mobile', 10 );

if ( $h1_pc != 10 ) {
	?>
    @media (min-width: 1280px) {
    body .promo.promo_v6 .item-promo__title .title, body.small-layout .promo.promo_v6 .item-promo__title .title, body .post__title h1.title, body.small-layout .post__title h1.title, body .promo.promo_v6 .item-promo__title .title, body.small-layout .promo.promo_v6 .item-promo__title .title, body .content-title .title, body.small-layout .content-title .title, body .block-authors-info .title, body.small-layout .block-authors-info .title {
    font-size: <?php echo $h1_pc; ?>px;
    }
    }
	<?php
}

if ( $h1_tablet != 10 ) {
	?>
    @media (min-width: 768px) and (max-width: 1279px) {
    body .post__title h1.title, body.small-layout .post__title h1.title, body .promo.promo_v6 .item-promo__title .title, body.small-layout .promo.promo_v6 .item-promo__title .title, .promo.promo_v6 .item-promo__title .title body .content-title .title, body.small-layout .content-title .title, body .block-authors-info .title, body.small-layout .block-authors-info .title {
    font-size: <?php echo $h1_tablet; ?>px;
    }
    }
	<?php
}

if ( $h1_mobile != 10 ) {
	?>
    @media (min-width: 320px) and (max-width: 767px) {
    body .post__title h1.title, body.small-layout .post__title h1.title, body .promo.promo_v6 .item-promo__title .title, body.small-layout .promo.promo_v6 .item-promo__title .title, body .content-title .title, body.small-layout .content-title .title, body .block-authors-info .title, body.small-layout .block-authors-info .title {
    font-size: <?php echo $h1_mobile; ?>px;
    }
    }
	<?php
}

foreach ( [ 'desktop', 'tablet', 'mobile' ] as $type ) {
	$style_h = '';
	foreach ( [ 'home_title', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'p' ] as $tag ) {
		if ( $tag == 'p' ) {
			$font_size = get_theme_mod( 'font_size_' . $tag . '_' . $type, 16 );
			if ( $font_size != 16 ) {
				$style_h .= 'body .section-post__editor, body .entry-content, ';
				$style_h .= 'body.small-layout .section-post__editor p, body .section-post__editor p, ';
				$style_h .= 'body.small-layout .section-post__editor ul li, body .section-post__editor ul li, ';
				$style_h .= 'body.small-layout .section-post__editor ol li, body .section-post__editor ol li ';
				$style_h .= '{font-size:' . $font_size . 'px;}';
			}
		}
        elseif ( $tag !== 'home_title' ) {
			$font_size = get_theme_mod( 'font_size_' . $tag . '_' . $type, 10 );
			if ( $font_size != 10 ) {
				$style_h .= 'body.small-layout ' . $tag . '.title, ' . $tag . '.title, body.small-layout ' . $tag . '.goods-main-item__title, ' . $tag . '.goods-main-item__title, .promo.promo_banner .item-promo__title ' . $tag . '.title, body.small-layout .promo.promo_banner .item-promo__title ' . $tag . '.title, body.small-layout .section-post__editor ' . $tag . ', .section-post__editor ' . $tag . ' {font-size:' . $font_size . 'px;}';
			}
		}
		else {
			$font_size = get_theme_mod( 'font_size_' . $tag . '_' . $type, 10 );
			if ( $font_size != 10 ) {
				$style_h .= 'body.small-layout.home .title_divider, body.home .title_divider{font-size:' . $font_size . 'px;}';
			}
		}
	}

	if ( $style_h ) {
		if ( $type == 'desktop' ) {
			echo '@media (min-width: 1280px) {' . $style_h . '}';
		}
        elseif ( $type == 'tablet' ) {
			echo '@media (min-width: 768px) and (max-width: 1279px) {' . $style_h . '}';
		}
        elseif ( $type == 'mobile' ) {
			echo '@media (min-width: 320px) and (max-width: 767px) {' . $style_h . '}';
		}
	}
}

$sort_blocks = get_theme_mod( 'header_block_sortable', [
	'address',
	'phone',
	'button',
] );
if ( ( isset( $sort_blocks[0] ) && $sort_blocks[0] != 'address' ) || ( isset( $sort_blocks[2] ) && $sort_blocks[2] != 'button' ) ) {
	echo '@media (min-width: 1024px) {';
	foreach ( $sort_blocks as $order_key => $block ) {
		if ( $block == 'address' ) {
			echo '.header-top__location{order:' . $order_key . '}';
		}
		if ( $block == 'phone' ) {
			echo '.header-top__telephone{order:' . $order_key . '}';
		}
		if ( $block == 'button' ) {
			echo '.header-top__btn{order:' . $order_key . '}';
		}
	}
	echo '}';
}

foreach ( [ 'desktop', 'tablet', 'mobile' ] as $type ) {
	$style_h = '';

	$position = get_theme_mod( 'fixed_button_position_' . $type, 50 );
	if ( $position != 50 ) {
		$style_h = '.call-modals-buttons {bottom: auto; top:' . $position . '%; -webkit-transform: translateY(-50%); -ms-transform: translateY(-50%); transform: translateY(-50%);}';
	}

	if ( $style_h ) {
		if ( $type == 'desktop' ) {
			echo '@media (min-width: 1280px) {' . $style_h . '}';
		}
        elseif ( $type == 'tablet' ) {
			echo '@media (min-width: 768px) and (max-width: 1279px) {' . $style_h . '}';
		}
        elseif ( $type == 'mobile' ) {
			echo '@media (min-width: 320px) and (max-width: 767px) {' . $style_h . '}';
		}
	}
}

if ( $color = get_theme_mod( 'logo_color' ) ) {
	echo '.header__logo-text{color:' . $color . '}';
}

foreach ( [ 'desktop', 'tablet', 'mobile' ] as $type ) {
	$style_h = '';

	$maxwidth = get_theme_mod( 'logo_maxwidth_' . $type, 50 );
	if ( $maxwidth != 95 && $maxwidth != 85 && $maxwidth != 65 ) {
		$style_h = '.header__logo{height:auto; flex: 0 0 ' . $maxwidth . 'px; max-width: ' . $maxwidth . 'px;}';
	}

	if ( $style_h ) {
		if ( $type == 'desktop' ) {
			echo '@media (min-width: 1280px) {' . $style_h . '}';
		}
        elseif ( $type == 'tablet' ) {
			echo '@media (min-width: 768px) and (max-width: 1279px) {' . $style_h . '}';
		}
        elseif ( $type == 'mobile' ) {
			echo '@media (min-width: 320px) and (max-width: 767px) {' . $style_h . '}';
		}
	}
}

if ( get_theme_mod( 'home_seo_enabled' ) ) {
	if ( $color_bg = get_theme_mod( 'home_seo_color_bg' ) ) {
		if ( strpos( $color_bg, 'rgba' ) !== false ) {
			$bg_color_arr = explode( ',', trim( str_replace( 'rgba(', '', $color_bg ), ')' ) );
			$r            = $bg_color_arr[0];
			$g            = $bg_color_arr[1];
			$b            = $bg_color_arr[2];
		}
		else {
			list( $r, $g, $b ) = sscanf( $color_bg, "#%02x%02x%02x" );
		}
		echo "body.home.changed-bg .seo.section-paddings .btn_expand:before, body.home.air-style .seo.section-paddings .btn_expand:before {background: -webkit-gradient(linear,left top,left bottom,from(rgba($r,$g,$b,.5)),color-stop(40%,rgba($r,$g,$b,.8)),color-stop(70%,$color_bg),to($color_bg)) !important;
        background: linear-gradient(rgba($r,$g,$b,.5) 0,rgba($r,$g,$b,.8) 40%,$color_bg 70%,$color_bg 100%) !important}";
	}
}

if ( get_theme_mod( 'home_programs_enabled' ) ) {
	if ( $color_bg = get_theme_mod( 'home_programs_color_bg' ) ) {
		if ( strpos( $color_bg, 'rgba' ) !== false ) {
			$bg_color_arr = explode( ',', trim( str_replace( 'rgba(', '', $color_bg ), ')' ) );
			$r            = $bg_color_arr[0];
			$g            = $bg_color_arr[1];
			$b            = $bg_color_arr[2];
		}
		else {
			list( $r, $g, $b ) = sscanf( $color_bg, "#%02x%02x%02x" );
		}
		echo "body.home .schedule-block:not(._with-bg) .btn_expand:before, body.changed-bg .schedule-block:not(._with-bg) .btn_expand:before {background: -webkit-gradient(linear,left top,left bottom,from(rgba($r,$g,$b,.5)),color-stop(40%,rgba($r,$g,$b,.8)),color-stop(70%,$color_bg),to($color_bg)) !important;
        background: linear-gradient(rgba($r,$g,$b,.5) 0,rgba($r,$g,$b,.8) 40%,$color_bg 70%,$color_bg 100%) !important}";
	}
}

if ( get_theme_mod( 'home_blocks_posts' ) ) {
	if ( $color = get_theme_mod( 'home_blocks_color_title' ) ) {
		echo '.home .content__col_big .title{color:' . $color . '}';
	}
}

if ( get_theme_mod( 'home_reviews_enabled' ) ) {
	if ( $height = get_theme_mod( 'home_reviews_height' ) ) {
		if ( $height != 210 ) {
			echo '.reviews-slider-item__body{max-height:' . $height . 'px}';
		}
	}
}

if ( get_theme_mod( 'home_advantages_v2_enabled', false ) ) {
	$color_grad1 = get_theme_mod( 'home_advantages_v2_gradient_1', '#fa1abe' );
	$color_grad2 = get_theme_mod( 'home_advantages_v2_gradient_2', '#0088cc' );
	if ( $color_grad1 && $color_grad2 ) {
		$opacity = intval( get_theme_mod( 'home_advantages_v2_opacity', 20 ) ) / 100;
		list( $r1, $g1, $b1 ) = sscanf( $color_grad1, "#%02x%02x%02x" );
		list( $r2, $g2, $b2 ) = sscanf( $color_grad2, "#%02x%02x%02x" );
		echo ".advantages-v2-item_big .advantages-v2-item__bg:before{background:-o-linear-gradient(125deg,rgba($r2,$g2,$b2,$opacity) 0,rgba($r1,$g1,$b1,$opacity) 65%);
    background: linear-gradient(-35deg,rgba($r2,$g2,$b2,$opacity) 0,rgba($r1,$g1,$b1,$opacity) 65%);}";
	}
	else {
		echo '.advantages-v2-item_big .advantages-v2-item__bg:before{display:none}';
	}

	$blur = get_theme_mod( 'home_advantages_v2_blur', 10 );
	if ( $blur != 10 ) {
		echo ".advantages-v2-item_big .advantages-v2-item__bg:before{-webkit-filter: blur({$blur}px);filter: blur({$blur}px);}";
	}

	$color = get_theme_mod( 'home_advantages_v2_items_gradient' );
	if ( $color ) {
		$opacity = intval( get_theme_mod( 'home_advantages_v2_items_opacity', 10 ) ) / 100;
		list( $r1, $g1, $b1 ) = sscanf( $color, "#%02x%02x%02x" );
		echo ".advantages-v2-item__img:before {border-color: rgba($r1, $g1, $b1, $opacity);}";
	}

	$border_width = get_theme_mod( 'home_advantages_v2_items_border_width', 10 );
	if ( $border_width != 10 ) {
		$border_width_x2 = $border_width * 2;
		echo ".advantages-v2-item__img:before{border-width:" . $border_width . "px;width: calc(100% + " . $border_width_x2 . "px);height: calc(100% + " . $border_width_x2 . "px);top: -" . $border_width . "px;left: -" . $border_width . "px;}";
	}
}

if ( get_theme_mod( 'home_prodwescle_enabled', false ) || is_page_template( 'templates/template-products_wescle.php' ) || is_tax( 'productcat_wescle' ) ) {
	$color_grad1 = get_theme_mod( 'home_prodwescle_gradient_1', '#fa1abe' );
	$color_grad2 = get_theme_mod( 'home_prodwescle_gradient_2', '#0088cc' );
	if ( $color_grad1 && $color_grad2 ) {
		$opacity = intval( get_theme_mod( 'home_prodwescle_opacity', 50 ) ) / 100;
		list( $r1, $g1, $b1 ) = sscanf( $color_grad1, "#%02x%02x%02x" );
		list( $r2, $g2, $b2 ) = sscanf( $color_grad2, "#%02x%02x%02x" );
		echo ".products-section-item__img:before{background:-o-linear-gradient(125deg,rgba($r2,$g2,$b2,$opacity) 0,rgba($r1,$g1,$b1,$opacity) 90%);
    background: linear-gradient(-35deg,rgba($r2,$g2,$b2,$opacity) 0,rgba($r1,$g1,$b1,$opacity) 90%);}";
	}
	else {
		echo '.products-section-item__img:before{display:none}';
	}

	$blur = get_theme_mod( 'home_prodwescle_blur', 5 );
	if ( $blur != 5 ) {
		echo ".products-section-item__img:before{-webkit-filter: blur({$blur}px);filter: blur({$blur}px);}";
	}
}

if ( get_theme_mod( 'content_color_body_animation', false ) ) {
	$colors = [];
	for ( $i = 1; $i <= 4; $i ++ ) {
		$color = get_theme_mod( 'content_color' . $i . '_body_animation' );
		if ( $color ) {
			$colors[] = $color;
		}
	}

	if ( $colors ) {
		$time = intval( get_theme_mod( 'content_color_body_animation_time', 30 ) );
		if ( $time < 5 ) {
			$time = 5;
		}
		$colors_str = implode( ', ', $colors );
		echo "body.animation-style {background: -o-linear-gradient(right, $colors_str);background: linear-gradient(270deg, $colors_str);";
		echo "background-size: 800% 800%;-webkit-animation: wescle_bg " . $time . "s ease infinite;animation: wescle_bg " . $time . "s ease infinite}";
		echo "@-webkit-keyframes wescle_bg{0%{background-position:0 50%}50%{background-position:100% 50%}100%{background-position:0 50%}}@keyframes wescle_bg{0%{background-position:0 50%}50%{background-position:100% 50%}100%{background-position:0 50%}}";
	}
}

if ( $img_url = get_theme_mod( 'content_body_bg_image', false ) ) {
	$bg_image_size = get_theme_mod( 'content_body_bg_image_size', 'full_repeater' );
	$bg_size       = 'background-repeat: repeat;';
	if ( $bg_image_size == 'repeat_y' ) {
		$bg_size = 'background-repeat: repeat-y;';
	}
	if ( $bg_image_size == 'repeat_x' ) {
		$bg_size = 'background-repeat: repeat-x;';
	}
	if ( $bg_image_size == 'norepeat' ) {
		$bg_size = 'background-repeat: no-repeat;';
	}
	$bg_image_size2 = get_theme_mod( 'content_body_bg_image_size2' );
	if ( $bg_image_size2 ) {
		$bg_size .= 'background-size: 100%;';
	}

	echo "body, body.air-style {background-image: url($img_url);background-position:50% 50%;$bg_size}";
}

$max_width   = '';
$content_box = get_theme_mod( 'content_box', 'box' );
if ( 'box' == $content_box ) {
	if ( is_archive() ) {
		if ( Helper::is_woocommerce() ) {
			$max_width = intval( get_theme_mod( 'woo_archive_content_box_width', 1280 ) );
		}
        elseif ( is_tax( Helper::get_catalog_taxs() ) ) {
			$max_width = intval( get_theme_mod( 'catalog_archive_content_box_width', 1280 ) );
		}
		else {
			$max_width = intval( get_theme_mod( 'archive_content_box_width', 1280 ) );
		}
	}
    elseif ( is_front_page() || is_home() ) {
		$max_width = intval( get_theme_mod( 'content_box_width_home', 1280 ) );
	}
    elseif ( is_page() ) {
		$max_width = intval( get_theme_mod( 'page_content_box_width', 1280 ) );
	}
    elseif ( is_singular() ) {
		$max_width = intval( get_theme_mod( $post->post_type . '_content_box_width', 1280 ) );
	}
}
if ( is_singular() ) {
	if ( get_post_meta( $post->ID, 'post_blocks_show_enabled', 1 ) ) {
		if ( get_post_meta( $post->ID, 'custom_content_box_width', 1 ) ) {
			$max_width = intval( get_post_meta( $post->ID, 'content_box_width_val', 1 ) );
		}
	}
}

if ( Helper::is_landing_page() ) {
	$content_box = get_post_meta( $post->ID, 'content_box', 1 );
	if ( 'box' == $content_box ) {
		$max_width = intval( get_post_meta( $post->ID, 'content_box_width', 1 ) );
	}
    elseif ( 'box_inner' == $content_box ) {
		$max_width = intval( get_post_meta( $post->ID, 'content_box_inner_width', 1 ) );
	}
}

if ( 'box' == $content_box && 1280 == $max_width ) {
	$max_width = 0;
}
if ( 'box_inner' == $content_box && 1280 == $max_width ) {
	$max_width = 0;
}

if ( $max_width && 'box' == $content_box ) {
	echo 'body.small-layout .main .container, body .main .container{max-width:' . $max_width . 'px}';
}
if ( $max_width && 'box_inner' == $content_box ) {
	echo 'body.small-layout .main .container, body .main .container{max-width:' . $max_width . 'px}';
}

if ( 'box' == $content_box ) {
	$max_width = intval( get_theme_mod( 'header_box_width', 1280 ) );
	if ( $max_width != 1280 ) {
		echo 'body.small-layout .header .container, body .header .container{max-width:' . $max_width . 'px}';
	}

	$max_width = intval( get_theme_mod( 'footer_box_width', 1280 ) );
	if ( $max_width != 1280 ) {
		echo 'body.small-layout .footer .container, body .footer .container{max-width:' . $max_width . 'px}';
	}
}

if ( Helper::is_frontpage_assets() ) {
	if ( 'banner' == get_theme_mod( 'slider_layout' ) ) {
		foreach ( [ 'desktop', 'tablet', 'mobile' ] as $type ) {
			$height = intval( get_theme_mod( 'slider_banner_height_' . $type, '' ) );
			if ( $height && $height > 0 ) {
				$style_h = '.promo__item.item-bonus{min-height:' . $height . 'px;max-height:' . $height . 'px}';
				if ( $type == 'desktop' ) {
					echo '@media (min-width: 1280px) {' . $style_h . '}';
				}
                elseif ( $type == 'tablet' ) {
					echo '@media (min-width: 768px) and (max-width: 1279px) {' . $style_h . '}';
				}
                elseif ( $type == 'mobile' ) {
					echo '@media (min-width: 320px) and (max-width: 767px) {' . $style_h . '}';
				}
			}
		}
	}
	if ( 'store' == get_theme_mod( 'slider_layout' ) ) {
		foreach ( [ 'one' => '.goods-main__col_big', 'two' => '.goods-main__col_small' ] as $key => $val ) {
			$color = get_theme_mod( 'slider_store_' . $key . '_color_title' );
			if ( $color && '#ffffff' != $color ) {
				echo $val . ' .title{color:' . $color . '}';
			}

			$color = get_theme_mod( 'slider_store_' . $key . '_color_price' );
			if ( $color && '#ffffff' != $color ) {
				echo $val . ' .prices{color:' . $color . '}';
			}
		}
	}
}

if ( Helper::is_landing_page() ) {
	if ( 'banner' == get_post_meta( $post->ID, 'slider_layout', 1 ) ) {
		foreach ( [ 'desktop', 'tablet', 'mobile' ] as $type ) {
			$height = intval( get_post_meta( $post->ID, 'slider_banner_height_' . $type, 1 ) );
			if ( $height && $height > 0 ) {
				$style_h = '.promo__item.item-bonus{min-height:' . $height . 'px;max-height:' . $height . 'px}';
				if ( $type == 'desktop' ) {
					echo '@media (min-width: 1280px) {' . $style_h . '}';
				}
                elseif ( $type == 'tablet' ) {
					echo '@media (min-width: 768px) and (max-width: 1279px) {' . $style_h . '}';
				}
                elseif ( $type == 'mobile' ) {
					echo '@media (min-width: 320px) and (max-width: 767px) {' . $style_h . '}';
				}
			}
		}
	}
	if ( 'store' == get_post_meta( $post->ID, 'slider_layout', 1 ) ) {
		foreach ( [ 'one' => '.goods-main__col_big', 'two' => '.goods-main__col_small' ] as $key => $val ) {
			$color = get_post_meta( $post->ID, 'slider_store_' . $key . '_color_title', 1 );
			if ( $color && '#ffffff' != $color ) {
				echo $val . ' .title{color:' . $color . '}';
			}

			$color = get_post_meta( $post->ID, 'slider_store_' . $key . '_color_price', 1 );
			if ( $color && '#ffffff' != $color ) {
				echo $val . ' .prices{color:' . $color . '}';
			}
		}
	}
}

if ( get_theme_mod( 'home_prices_enabled' ) ) {
	$max_height = get_theme_mod( 'home_prices_image_height', 100 );
	if ( $max_height != 100 ) {
		echo '.tarrif-plan1 .tarrif-plan-item__img{width:' . $max_height . 'px;height:' . $max_height . 'px}';
	}
}

if ( get_theme_mod( 'home_prices2_enabled' ) ) {
	$max_height = get_theme_mod( 'home_prices2_image_height', 100 );
	if ( $max_height != 100 ) {
		echo '.tarrif-plan2 .tarrif-plan-item__img{width:' . $max_height . 'px;height:' . $max_height . 'px}';
	}
}

if ( Helper::is_frontpage_assets() && ! is_home() ) {
	if ( get_theme_mod( 'slider_image_without_gradient', false ) == false ) {
		$opacity = get_theme_mod( 'slider_image_opacity', 100 );
		if ( $opacity != 100 ) {
			$opacity = intval( $opacity ) / 100;
			if ( 'store' == get_theme_mod( 'slider_layout', 'columns_two' ) ) {
				echo '.goods-main .image-overlay_gradient:before{opacity:' . $opacity . '}';
			}
			else {
				echo '.promo .image-overlay_gradient:before{opacity:' . $opacity . '}';
			}
		}
	}

	if ( get_theme_mod( 'woo_banners_without_gradient', false ) == false ) {
		$opacity = get_theme_mod( 'woo_banners_opacity', 100 );
		if ( $opacity != 100 ) {
			$opacity = intval( $opacity ) / 100;
			echo '.goods-banners-item .image-overlay_gradient:before{opacity:' . $opacity . '}';
		}
	}

	$banner_item_color = get_theme_mod( 'woo_banners_item_color_title', '#ffffff' );
	if ( '#ffffff' != $banner_item_color ) {
		echo '.goods-banners-item__title{color:' . $banner_item_color . '}';
	}

	$banner_item_color = get_theme_mod( 'woo_banners_item_color_price', '#ffffff' );
	if ( '#ffffff' != $banner_item_color ) {
		echo '.goods-banners-item__body .prices{color:' . $banner_item_color . '}';
	}

	$home_blocks_posts = get_theme_mod( 'home_blocks_posts', [] );
	if ( $home_blocks_posts ) {
		foreach ( $home_blocks_posts as $key_block => $block ) {
			$post_card_opacity = $block['block_post_card_opacity'] ?? 100;
			$post_card_type    = $block['block_post_card_type'] ?? '';
			if ( 'vertical' === $post_card_type ) {
				if ( 100 != $post_card_opacity ) {
					$opacity = intval( $post_card_opacity ) / 100;
					echo '.featured-' . $key_block . ' .featured__post .image-overlay_gradient:before{opacity:' . $opacity . '}';
				}
			}
		}
	}
}

if ( Helper::is_landing_page() ) {
	if ( ! get_post_meta( $post->ID, 'slider_image_without_gradient', 1 ) ) {
		$opacity = get_post_meta( $post->ID, 'slider_image_opacity', 1 );
		if ( $opacity != 100 ) {
			$opacity = intval( $opacity ) / 100;
			if ( 'store' == get_post_meta( $post->ID, 'slider_layout', 1 ) ) {
				echo '.goods-main .image-overlay_gradient:before{opacity:' . $opacity . '}';
			}
			else {
				echo '.promo .image-overlay_gradient:before{opacity:' . $opacity . '}';
			}
		}
	}
}

echo Core::get_css_buttons();

if ( get_theme_mod( 'home_price_table_enabled', false ) || Helper::isset_block_content( 'packages-include' ) ) {
	$package_posts = get_posts( [
		'post_type'      => 'pricepackage_wescle',
		'posts_per_page' => - 1,
	] );
	if ( $package_posts ) {
		foreach ( $package_posts as $item_post ) {
			$color = get_post_meta( $item_post->ID, 'block_color', 1 );
			if ( ! $color ) {
				continue;
			}

			echo 'th.packages-' . $item_post->ID . '{color:' . $color . '}';
			echo '.packages-' . $item_post->ID . ' .packages-include__table-price-current,.packages-' . $item_post->ID . ' .btn{color:' . $color . '}';
			echo '.packages-' . $item_post->ID . ' .packages-include__icon path{fill:' . $color . '}';
			echo '.packages-' . $item_post->ID . ' .packages-include__icon,.packages-' . $item_post->ID . ' .btn{border-color:' . $color . '}';
			echo '.packages-' . $item_post->ID . ' .btn:hover{background-color:' . $color . ';color:#fff;}';
		}
	}
}


$data_label_color = [
	'tag'      => [
		'.tags__item .category, body .widget_tag_cloud a',
		'.tags__item .category:hover, body .widget_tag_cloud a:hover',
	],
	'category' => [
		'.post__category a, .post__category span, .category-section__item.category, body .widget_categories li a, body .widget_categories li.cat-item',
		'.post__category a:hover, .category-section__item.category:hover, body .widget_categories li a:hover, body .widget_categories li.cat-item:hover',
	],
];
foreach ( $data_label_color as $key => $class_name ) {
	$color    = get_theme_mod( 'label_' . $key . '_color', '#ffffff' );
	$color_bg = get_theme_mod( 'label_' . $key . '_bg' );

	$styles = [];
	if ( $color && $color != '#ffffff' ) {
		$styles[] = 'color:' . $color . ' !important';
		echo $class_name[0] . '{' . implode( ';', $styles ) . '}';
	}
	$styles = [];
	if ( $color_bg ) {
		$styles[] = 'background:' . $color_bg;
	}
	if ( $styles ) {
		echo $class_name[0] . '{' . implode( ';', $styles ) . '}';
	}

	$color    = get_theme_mod( 'label_' . $key . '_color_hover', '#ececee' );
	$color_bg = get_theme_mod( 'label_' . $key . '_bg_hover' );

	$styles = [];
	if ( $color && $color != '#ececee' ) {
		$styles[] = 'color:' . $color . ' !important';
		echo $class_name[1] . '{' . implode( ';', $styles ) . '}';
	}

	$styles = [];
	if ( $color_bg ) {
		$styles[] = 'background:' . $color_bg;
	}
	if ( $styles ) {
		echo $class_name[1] . '{' . implode( ';', $styles ) . '}';

	}
}

$primary_menu_link_color       = get_theme_mod( 'primary_menu_link_color', '#484848' );
$primary_menu_link_color_hover = get_theme_mod( 'primary_menu_link_color_hover', '#484848' );
if ( $primary_menu_link_color && $primary_menu_link_color != '#484848' ) {
	echo ".navigation__link{color:$primary_menu_link_color;}";
	echo ".navigation__item ._arrow-down g{stroke:$primary_menu_link_color;}";
}
if ( $primary_menu_link_color_hover && $primary_menu_link_color_hover != '#484848' ) {
	echo ".navigation__item:hover>a,.navigation__item:hover>span,.navigation__item.current-menu-item>a, .navigation__item.current-menu-item>span{color:$primary_menu_link_color_hover;}";
	echo ".navigation__item:hover ._arrow-up g{stroke:$primary_menu_link_color_hover;}";
}

$primary_menu_link2_color       = get_theme_mod( 'primary_menu_link2_color', '#484848' );
$primary_menu_link2_color_hover = get_theme_mod( 'primary_menu_link2_color_hover', '#484848' );
$primary_menu_link2_bg          = get_theme_mod( 'primary_menu_link2_bg', '#ececee' );
if ( $primary_menu_link2_color && $primary_menu_link2_color != '#484848' ) {
	echo ".navigation__sublink,.navigation-sublist-yet .navigation__link{color:$primary_menu_link2_color;}";
}
if ( $primary_menu_link2_color_hover && $primary_menu_link2_color_hover != '#484848' ) {
	echo ".navigation__subitem:hover>a,.navigation__subitem>span,.navigation__subitem:hover>span,.navigation-sublist-yet .navigation__link:hover,.navigation__sublist .current-menu-item>.navigation__link,.navigation__subitem.current-menu-item>span{color:$primary_menu_link2_color_hover;}";
}
if ( $primary_menu_link2_bg && $primary_menu_link2_bg != '#ececee' ) {
	echo ".navigation__subitem:hover>a,.navigation__subitem.current-menu-item>span{background:$primary_menu_link2_bg;}";
}

$fixed_buttons_color       = get_theme_mod( 'fixed_buttons_color' );
$fixed_buttons_bg          = get_theme_mod( 'fixed_buttons_bg' );
$fixed_buttons_color_hover = get_theme_mod( 'fixed_buttons_color_hover' );
$fixed_buttons_bg_hover    = get_theme_mod( 'fixed_buttons_bg_hover' );
if ( $fixed_buttons_color ) {
	echo ".call-button svg path,.mail-button svg path,.color-scheme-toggle svg path{fill:$fixed_buttons_color}";
}
if ( $fixed_buttons_bg ) {
	echo ".call-button,.mail-button,.color-scheme-toggle{background:$fixed_buttons_bg}";
}
if ( $fixed_buttons_color_hover ) {
	echo ".call-button:hover svg path,.mail-button:hover svg path,.color-scheme-toggle:hover svg path{fill:$fixed_buttons_color_hover}";
}
if ( $fixed_buttons_bg_hover ) {
	echo ".call-button:hover,.mail-button:hover,.color-scheme-toggle:hover{background:$fixed_buttons_bg_hover}";
}

$color_icon = get_theme_mod( 'color_icon_menu', '#484848' );
if ( '#484848' != $color_icon ) {
	echo 'body header.header .header-top__actions .icon-menu span{background-color: ' . $color_icon . ';}';
}

$color_icon = get_theme_mod( 'color_icon_search', '#626262' );
if ( '#626262' != $color_icon ) {
	echo '.btn-search:not(:hover) .icon-search path{fill: ' . $color_icon . ';}';
}

$color_icon = get_theme_mod( 'color_icon_account', '#626262' );
if ( '#626262' != $color_icon ) {
	echo '.navigation-store__acc:not(:hover) path,.header-center-2 ._account-logged path,.header.header-tabs .navigation-store__acc path{fill: ' . $color_icon . ';}';
}

$color_icon = get_theme_mod( 'color_icon_wishlist', '#626262' );
if ( '#626262' != $color_icon ) {
	echo '.navigation-store__wishlist:not(:hover) path,.header.header-tabs .navigation-store__wishlist path{fill: ' . $color_icon . ';}';
}

$color_icon = get_theme_mod( 'color_icon_compare', '#626262' );
if ( '#626262' != $color_icon ) {
	echo '.header-center-2__col>._compare ._compare-toggle path,._compare ._compare-toggle path{fill: ' . $color_icon . ';}';
}

$color_icon = get_theme_mod( 'color_icon_cart', '#626262' );
if ( '#626262' != $color_icon ) {
	echo '.navigation-store__cart:not(:hover) path,.header-center-2 .navigation-store__cart .cart-contents path,.header.header-tabs .navigation-store__cart path{fill: ' . $color_icon . ';}';
}

$color_icon = get_theme_mod( 'color_icon_numbers', '' );
if ( $color_icon ) {
	echo '.navigation-store li a span,.header-center-2__col .navigation-store__wishlist span,.header-center-2 .navigation-store__cart .cart-contents span,.header-center-2__col>._compare ._compare-toggle span,._compare ._compare-toggle span{background: ' . $color_icon . ';}';
}

$color_icon_hover = get_theme_mod( 'color_icons_hover', '' );
if ( $color_icon_hover ) {
	echo '.btn-search:hover .icon-search path, .navigation-store__acc:hover path, .navigation-store__wishlist:hover path, .navigation-store__cart:hover path, .header-center-2 .navigation-store__cart:hover .cart-contents path, .header-center-2 ._account-logged:hover path, .header-center-2__col>._compare ._compare-toggle:hover path,._compare ._compare-toggle:hover path{fill: ' . $color_icon_hover . ' !important;}';
}


$working_days = get_theme_mod( 'working_days_list', Helper::get_default_theme_data( 'working_days_list' ) );
if ( $working_days ) {
	$data = [
		'header' => [
			'header .telephone__days span',
			'header .telephone__days span._restday',

		],
		'footer' => [
			'.widget .telephone__days span',
			'.widget .telephone__days span._restday',
		],
	];
	foreach ( $data as $key => $item ) {
		$color   = get_theme_mod( 'working_days_' . $key . '_color' );
		$bg      = get_theme_mod( 'working_days_' . $key . '_bg' );
		$color_2 = get_theme_mod( 'working_days_' . $key . '_color_2' );
		$bg_2    = get_theme_mod( 'working_days_' . $key . '_bg_2' );

		$styles = [];
		if ( $color ) {
			$styles[] = 'color:' . $color;
		}
		if ( $bg ) {
			$styles[] = 'background:' . $bg;
		}

		if ( $styles ) {
			echo $item[0] . '{' . implode( ';', $styles ) . '}';
		}

		$styles = [];
		if ( $color_2 ) {
			$styles[] = 'color:' . $color_2;
		}
		if ( $bg_2 ) {
			$styles[] = 'background:' . $bg_2;
		}

		if ( $styles ) {
			echo $item[1] . '{' . implode( ';', $styles ) . '}';
		}
	}
}

$module_mess_color = get_theme_mod( 'module_mess_color' );
if ( $module_mess_color ) {
	?>
    .mess-widget-chat .btn-close, .mess-widget__btn:not(:hover):before, .mess-widget__btn, .mess-widget-block__header, .mess-widget-block .btn-close,
    .mess-widget-block__item-icon {
    background-color: <?php echo $module_mess_color; ?>;
    }
    .mess-widget-block .author-mess__availability {
    border-color: <?php echo $module_mess_color; ?>;
    }
    .mess-widget__btn ._dynamic .mess-widget__icons svg path {
    fill: <?php echo $module_mess_color; ?>;
    }
	<?php
}

if ( get_theme_mod( 'home_services_enabled', false ) ) {
	if ( ! get_theme_mod( 'home_services_as_horizontal', false ) ) {
		$opacity       = intval( get_theme_mod( 'home_services_opacity', 100 ) ) / 100;
		$opacity_hover = intval( get_theme_mod( 'home_services_opacity_hover', 100 ) ) / 100;
		if ( $opacity != 1 ) {
			echo '.services-item__overlay_gradient:after,.services-item__image:before{opacity:' . $opacity . ';}';
		}
		if ( $opacity_hover != 1 ) {
			echo '.services-item:hover .services-item__image:before{opacity:' . $opacity_hover . ';}';
		}
	}
}

$bg_color = get_theme_mod( 'color_header_bg2' );
if ( $bg_color ) {
	echo 'body.air-style .header__bottom, .header__bottom, body.search-v2 .header__search-form, body.search-v3 .header__search-form{background-color:' . $bg_color . '}';
}
$bg_color = get_theme_mod( 'color_header_bg1' );
if ( $bg_color ) {
	echo '.header__top{background-color:' . $bg_color . '}';
	if ( Helper::is_header_tabs() ) {
		echo 'body.air-style .header__bottom, .header__bottom, body.search-v2 .header__search-form, body.search-v3 .header__search-form{background-color:' . $bg_color . '}';
	}
    elseif ( Helper::is_header_store_center() ) {
		echo 'body.search-v2 .header__search-form, body.search-v3 .header__search-form{background-color:' . $bg_color . '}';
	}
	else {
		echo '@media (max-width: 1024px) {body.air-style .header__bottom, .header__bottom, body.search-v2 .header__search-form, body.search-v3 .header__search-form{background-color:' . $bg_color . '}}';
	}
}

if ( get_theme_mod( 'color_header_border_enabled', true ) ) {
	$border_color = get_theme_mod( 'color_header_border_top' );
	if ( $border_color && '#ececee' !== $border_color ) {
		echo '.header__navigation{border-top-color:' . $border_color . '}';
	}
}
else {
	echo '.header__navigation{border-top:0}';
}

$color_text = get_theme_mod( 'color_header_text' );
if ( $color_text ) {
	echo '.header-top__about,.location__link,.telephone__link,.telephone__schedule,.telephone__mail a:not(:hover){color:' . $color_text . '}';
}

if ( get_theme_mod( 'top_bar_enabled' ) ) {
	$bg_color = get_theme_mod( 'top_bar_bg_color' );
	if ( $bg_color ) {
		echo '@media (min-width: 1025px){.top-bar{background-color:' . $bg_color . '}}';
	}
}

if ( get_theme_mod( 'header_block_type' ) == 'top_bar_tabs' ) {
	$bg_color = get_theme_mod( 'header_top_bar_bg_color' );
	if ( $bg_color ) {
		echo '.header.header-tabs .header__head{background-color:' . $bg_color . '}';
	}

	$bg_color = get_theme_mod( 'header_top_bar_bg_tab_active' );
	if ( $bg_color ) {
		echo '.header.header-tabs .header-tabs-nav ._tabs-item._active{background-color:' . $bg_color . '}';
	}
	$color = get_theme_mod( 'header_top_bar_color_tab_active' );
	if ( $color ) {
		echo '.header.header-tabs .header-tabs-nav ._tabs-item._active{color:' . $color . '}';
	}

	$bg_color = get_theme_mod( 'header_top_bar_bg_tab_inactive' );
	if ( $bg_color ) {
		echo '.header.header-tabs .header-tabs-nav ._tabs-item{background-color:' . $bg_color . '}';
	}
	$color = get_theme_mod( 'header_top_bar_color_tab_inactive' );
	if ( $color ) {
		echo '.header.header-tabs .header-tabs-nav ._tabs-item{color:' . $color . '}';
	}
}

if ( 'vertical' == get_theme_mod( 'archive_post_card_type' ) ) {
	$opacity = get_theme_mod( 'archive_post_card_opacity', 100 );
	if ( $opacity != 100 ) {
		$opacity = intval( $opacity ) / 100;
		echo '.archive .featured__post .image-overlay_gradient:before, .search .featured__post .image-overlay_gradient:before{opacity:' . $opacity . '}';
	}
}

$top_bar_enabled = get_theme_mod( 'top_bar_enabled' ) || Helper::is_header_tabs();
$top_bar_class   = 'top-bar';
if ( Helper::is_header_tabs() ) {
	$top_bar_class = 'bar';
}
$styles       = [];
$social_items = [
	'vk',
	'ok',
	'fb',
	'tw',
	'inst',
	'telegram',
	'linked',
	'pi',
	'yt',
	'yd',
	'pulse_mail',
	'tinkoff',
];
foreach ( $social_items as $item ) {
	$color       = get_theme_mod( 'social_' . $item . '_color' );
	$color_hover = get_theme_mod( 'social_' . $item . '_color_hover' );
	if ( $color ) {
		$styles[] = '.socials__item-' . $item . ' .socials__link:not(:hover) svg path{fill:' . $color . ';}';
		if ( $top_bar_enabled ) {
			$styles[] = '.socials__item-' . $item . ' .socials-' . $top_bar_class . '__link:not(:hover) svg path{fill:' . $color . ';}';
		}
	}
	if ( $color_hover ) {
		$styles[] = '.socials__item-' . $item . ' .socials__link:hover svg path{fill:' . $color_hover . ';}';
		if ( $top_bar_enabled ) {
			$styles[] = '.socials__item-' . $item . ' .socials-' . $top_bar_class . '__link:hover svg path{fill:' . $color_hover . ';}';
		}
	}
}
$social_custom_items = get_theme_mod( 'social_custom_items', [] );
foreach ( $social_custom_items as $key => $item ) {
	$color       = $item['item_color'];
	$color_hover = $item['item_color_hover'];
	if ( $color ) {
		$styles[] = '.socials__item-' . $key . ' .socials__link:not(:hover) svg path{fill:' . $color . ';}';
	}
	if ( $color_hover ) {
		$styles[] = '.socials__item-' . $key . ' .socials__link:hover svg path{fill:' . $color_hover . ';}';
	}
}
if ( $styles ) {
	echo implode( '', $styles );
}

$module_mess_bottom = get_theme_mod( 'module_mess_bottom', 5 );
if ( $module_mess_bottom != 5 ) {
	echo '.mess-widget__btn{bottom:' . $module_mess_bottom . '%}';
	echo '.mess-widget-chat, .mess-widget-block{bottom:calc(' . $module_mess_bottom . '% + 70px)}';
}

if ( is_singular() ) {
	$data_buttons = [
		'events'              => [
			'.events-block-item .btn',
		],
		'packages-include'    => [
			'.packages-include__table-info:not(.packages-custom_color) .btn',
		],
		'products'            => [
			'.products-section-item .btn',
		],
		'reviews'             => [
			'body:not(.is-lock) .reviews-slider__item .btn',
		],
		'our-works'           => [
			'.our-works__filters-item .btn',
		],
		'time-left'           => [
			'.time-left-form .button-submit .btn',
		],
		'contact-us'          => [
			'.contact-us-form .button-submit .btn',
		],
		'additional-services' => [
			'.additional-services-item .btn'
		],
		'licenses'            => [
			'.licenses-tab-item .btn',
		]
	];
	foreach ( $data_buttons as $key => $class_name ) {
		if ( Helper::isset_block_content( $key ) ) {
			$parse_content = parse_blocks( $post->post_content );
			foreach ( $parse_content as $item ) {
				if ( $item['blockName'] == 'wescle-blocks/' . $key ) {

					$button_type = $item['attrs']['buttonsView'] ?? '';
					if ( $button_type == 'default' ) {
						$button_type = 'custom';
					}

					if ( 'animate' != $button_type ) {
						if ( in_array( $key, [ 'special', 'contact', 'modal_call', 'modal_call_message' ] ) ) {
							echo $class_name[0] . ':after{display:none;}';
						}
					}

					if ( 'custom' == $button_type || 'animate' == $button_type ) {
						$color    = $item['attrs']['buttonsColor'] ?? '';
						$color_bg = $item['attrs']['buttonsBackground'] ?? '';
						$border   = $item['attrs']['buttonsBorderColor'] ?? '';

						$styles = [
							'overflow: hidden'
						];
						if ( $color ) {
							$styles[] = 'color:' . $color;
						}
						if ( $color_bg ) {
							$styles[] = 'background-color:' . $color_bg;
						}
						if ( $border ) {
							$styles[] = 'border-color:' . $border;
						}
						if ( $styles ) {
							echo $class_name[0] . '{' . implode( ';', $styles ) . '}';
						}

						$color    = $item['attrs']['buttonsColorOnHover'] ?? '';
						$color_bg = $item['attrs']['buttonsBackgroundOnHover'] ?? '';
						$border   = $item['attrs']['buttonsBorderColorOnHover'] ?? '';

						$styles = [];
						if ( $color ) {
							$styles[] = 'color:' . $color;
						}
						if ( $color_bg ) {
							$styles[] = 'background-color:' . $color_bg;
						}
						if ( $border ) {
							$styles[] = 'border-color:' . $border;
						}
						if ( $styles ) {
							if ( $key == 'banner' ) {
								echo '.item-bonus-one:hover .btn-main,.item-bonus .btn-main:hover,.goods-main-item.item-bonus-one:hover .btn-main{' . implode( ';', $styles ) . '}';
							}
                            elseif ( $key == 'our-works' ) {
								echo $class_name[0] . ':hover, ' . $class_name[0] . '.active{' . implode( ';', $styles ) . '}';
							}
							else {
								echo $class_name[0] . ':hover{' . implode( ';', $styles ) . '}';
							}
						}

						if ( 'animate' == $button_type ) {
							$styles         = [];
							$color_bg       = $item['attrs']['buttonsGlareColor'] ?? '';
							$color_bg_hover = $item['attrs']['buttonsGlareColorOnHover'] ?? '';
							$speed          = $item['attrs']['buttonsAnimationDuration'] ?? 4;
							if ( $speed != 4 ) {
								$styles[] = '-webkit-animation-duration:' . $speed . 's';
								$styles[] = 'animation-duration:' . $speed . 's';
							}
							if ( $color_bg ) {
								$styles[] = 'background:' . $color_bg;
							}
							if ( $styles ) {
								if ( $key == 'banner' ) {
									echo '.item-bonus .btn-main.btn-flare:after,.goods-main-item .btn-main.btn-flare:after{' . implode( ';', $styles ) . '}';
								}
								else {
									echo $class_name[0] . '.btn-flare:after{' . implode( ';', $styles ) . '}';
								}
							}

							if ( $color_bg_hover ) {
								if ( $key == 'banner' ) {
									echo '.item-bonus-one:hover .btn-main.btn-flare:after,.item-bonus .btn-main.btn-flare:hover:after,.goods-main-item.item-bonus-one:hover .btn-main.btn-flare:after{background:' . $color_bg_hover . '}';
								}
								else {
									echo $class_name[0] . '.btn-flare:hover:after{background:' . $color_bg_hover . '}';
								}
							}
						}
					}
				}
			}
		}
	}

	if ( is_page_template( 'templates/template-landing.php' ) ) {
		$data_buttons = [
			'banner' => [
				'.item-bonus .btn-main, .goods-main-item .btn-main, .animated-banner__actions-col .btn-main, .promo-parallax .btn-main'
			],
		];

		foreach ( $data_buttons as $key => $class_name ) {
			$button_type = get_post_meta( $post->ID, 'slider_button_type', 1 );

			if ( 'custom' == $button_type || 'animation' == $button_type ) {
				$color    = get_post_meta( $post->ID, 'slider_button_color', 1 );
				$color_bg = get_post_meta( $post->ID, 'slider_button_bg', 1 );
				$border   = get_post_meta( $post->ID, 'slider_button_border', 1 );

				$styles = [];
				if ( $color ) {
					$styles[] = 'color:' . $color;
				}
				if ( $color_bg ) {
					$styles[] = 'background-color:' . $color_bg;
				}
				if ( $border ) {
					$styles[] = 'border-color:' . $border;
				}
				if ( $styles ) {
					echo $class_name[0] . '{' . implode( ';', $styles ) . '}';
				}

				$color    = get_post_meta( $post->ID, 'slider_button_color_hover', 1 );
				$color_bg = get_post_meta( $post->ID, 'slider_button_bg_hover', 1 );
				$border   = get_post_meta( $post->ID, 'slider_button_border_hover', 1 );

				$styles = [];
				if ( $color ) {
					$styles[] = 'color:' . $color;
				}
				if ( $color_bg ) {
					$styles[] = 'background-color:' . $color_bg;
				}
				if ( $border ) {
					$styles[] = 'border-color:' . $border;
				}
				if ( $styles ) {
					if ( $key == 'banner' ) {
						echo '.item-bonus-one:hover .btn-main,.item-bonus .btn-main:hover,.goods-main-item.item-bonus-one:hover .btn-main, .animated-banner__actions-col .btn-main:hover, .promo-parallax .btn-main:hover{' . implode( ';', $styles ) . '}';
					}
					else {
						echo $class_name[0] . ':hover{' . implode( ';', $styles ) . '}';
					}
				}

				if ( 'animation' == $button_type ) {
					$styles         = [];
					$color_bg       = get_post_meta( $post->ID, 'slider_button_blick_color', 1 );
					$color_bg_hover = get_post_meta( $post->ID, 'slider_button_blick_color_hover', 1 );
					$speed          = get_post_meta( $post->ID, 'slider_button_blick_speed', 1 );
					if ( $speed != 4 ) {
						$styles[] = '-webkit-animation-duration:' . $speed . 's';
						$styles[] = 'animation-duration:' . $speed . 's';
					}
					if ( $color_bg ) {
						$styles[] = 'background:' . $color_bg;
					}
					if ( $styles ) {
						if ( $key == 'banner' ) {
							echo '.item-bonus .btn-main.btn-flare:after,.goods-main-item .btn-main.btn-flare:after, .animated-banner__actions-col .btn-main.btn-flare:after{' . implode( ';', $styles ) . '}';
						}
						else {
							echo $class_name[0] . '.btn-flare:after{' . implode( ';', $styles ) . '}';
						}
					}

					if ( $color_bg_hover ) {
						if ( $key == 'banner' ) {
							echo '.item-bonus-one:hover .btn-main.btn-flare:after,.item-bonus .btn-main.btn-flare:hover:after,.goods-main-item.item-bonus-one:hover .btn-main.btn-flare:after, .animated-banner__actions-col .btn-main.btn-flare:hover:after{background:' . $color_bg_hover . '}';
						}
						else {
							echo $class_name[0] . '.btn-flare:hover:after{background:' . $color_bg_hover . '}';
						}
					}
				}
			}
		}
	}

}

$data = [
	'animated_label_text_color'     => [
		'color',
		'.animated-banner__label:not(:hover)'
	],
	'animated_label_bg_color'       => [
		'background',
		'.animated-banner__label'
	],
	'animated_title_2_color'        => [
		'color',
		'.animated-banner__title .colored-text'
	],
	'animated_advantages_img_color' => [
		'fill',
		'.animated-banner .advantages li svg path'
	],
	'animated_play_bg_color'        => [
		'background',
		'.animated-banner__video .btn-play'
	],
	'animated_play_border_color'    => [
		'border-color',
		'.animated-banner__video .btn-play:not(:hover)'
	],
	'animated_play_color'           => [
		'fill',
		'.animated-banner__video .btn-play path'
	],
	'animated_play_color_text'      => [
		'color',
		'.animated-banner__video .btn-play:not(:hover) span'
	],
];

if ( Helper::is_frontpage_assets() && 'animated' === get_theme_mod( 'slider_layout' ) ) {
	foreach ( $data as $key => $date_item ) {
		$color = get_theme_mod( $key );
		if ( $color ) {
			echo '.home ' . $date_item[1] . '{' . $date_item[0] . ':' . $color . '}';
		}
	}
}

if ( is_page_template( 'templates/template-landing.php' ) ) {
	if ( 'animated' == get_post_meta( $post->ID, 'slider_layout', 1 ) ) {
		foreach ( $data as $key => $date_item ) {
			$color = get_post_meta( $post->ID, $key, 1 );
			if ( $color ) {
				echo $date_item[1] . '{' . $date_item[0] . ':' . $color . '}';
			}
		}
	}
}

$data = [
	'parallax_label_text_color' => [
		'color',
		'.promo-parallax .promo-parallax__label'
	],
	'animated_label_text_color' => [
		'color',
		'.promo-parallax .promo-parallax__label'
	],
	'parallax_label_bg_color'   => [
		'background',
		'.promo-parallax .promo-parallax__label'
	],
	'animated_label_bg_color'   => [
		'background',
		'.promo-parallax .promo-parallax__label'
	],
	'parallax_text_button_bg'   => [
		'background',
		'.promo-parallax__btn ._when'
	],
	'parallax_color_text'       => [
		'color',
		'.promo-parallax'
	],
];

if ( Helper::is_frontpage_assets() && 'parallax' === get_theme_mod( 'slider_layout' ) ) {
	foreach ( $data as $key => $date_item ) {
		$color = get_theme_mod( $key );
		if ( $color ) {
			echo '.home ' . $date_item[1] . '{' . $date_item[0] . ':' . $color . '}';
		}
	}
}

if ( is_page_template( 'templates/template-landing.php' ) ) {
	if ( 'parallax' == get_post_meta( $post->ID, 'slider_layout', 1 ) ) {
		foreach ( $data as $key => $date_item ) {
			$color = get_post_meta( $post->ID, $key, 1 );
			if ( $color ) {
				echo $date_item[1] . '{' . $date_item[0] . ':' . $color . '}';
			}
		}
	}
}

if ( 'contain' == get_theme_mod( 'product_images_object_fit' ) ) {
	echo 'body.products-by-list .product-cart__image img{-o-object-fit:contain;object-fit:contain;}';
}

if ( get_theme_mod( 'home_licenses_enabled' ) ) {
	$posts_license = get_posts( [
		'post_type'      => 'license_wescle',
		'posts_per_page' => - 1,
		'orderby'        => [ 'menu_order' => 'ASC', 'date' => 'DESC' ]
	] );
	foreach ( $posts_license as $item ) {
		$color1 = get_post_meta( $item->ID, 'color_gradient1', 1 );
		if ( $color1 ) {
			echo '.licenses .licenses-tab-item-' . $item->ID . ':before{background: transparent -o-linear-gradient(328deg,' . $color1 . ' 0,' . $color1 . ' 100%); background: transparent linear-gradient(122deg,' . $color1 . ' 0,' . $color1 . ' 100%);}';
		}
	}
}

if ( Helper::get_sidebar_position() !== 'sidebar-none' ) {
	$sidebar_width = '';
	if ( is_archive() ) {
		if ( Helper::is_woocommerce() ) {
			$sidebar_width = get_theme_mod( 'woo_archive_sidebar_box_width' );
		}
        elseif ( is_tax( Helper::get_catalog_taxs() ) ) {
			$sidebar_width = get_theme_mod( 'catalog_archive_sidebar_box_width' );
		}
		else {
			$sidebar_width = get_theme_mod( 'archive_sidebar_box_width' );
			if ( is_tax( [ 'coursecat_wescle', 'coursetag_wescle' ] ) ) {
				$sidebar_width = 0;
			}
		}
	}
    elseif ( is_front_page() || is_home() ) {
		$sidebar_width = get_theme_mod( 'home_sidebar_width' );
	}
    elseif ( is_page() ) {
		$sidebar_width = get_theme_mod( 'page_sidebar_box_width' );
	}
    elseif ( is_singular() ) {
		$sidebar_width = get_theme_mod( $post->post_type . '_sidebar_box_width' );
	}

	if ( is_singular() ) {
		if ( get_post_meta( $post->ID, 'post_blocks_show_enabled', 1 ) ) {
			$sidebar_position = get_post_meta( $post->ID, 'sidebar_position', 1 );
			if ( $sidebar_position && $sidebar_position != 'none' ) {
				$sidebar_width = get_post_meta( $post->ID, 'sidebar_box_width_val', 1 );
			}
		}
	}

	if ( $sidebar_width && 30 != $sidebar_width ) {
		$cont_width = 100 - intval( $sidebar_width );
		echo '@media (min-width: 1279px){.content__col{flex: 1 !important;max-width: none !important;}.content__col_big{flex: 0 0 ' . $cont_width . '% !important;max-width: ' . $cont_width . '% !important;}}';
	}
}

if ( get_theme_mod( 'header_menu_burger_dark' ) ) {
	$styles = [];
	if ( $color = get_theme_mod( 'burger_menu_light' ) ) {
		$styles[] = "--color-light: $color;";
	}
	if ( $color = get_theme_mod( 'burger_menu_light_hover' ) ) {
		$styles[] = "--color-light-hover: $color;";
	}
	if ( $color = get_theme_mod( 'burger_menu_dark' ) ) {
		$styles[] = "--color-dark: $color;";
	}
	if ( $color = get_theme_mod( 'burger_menu_dark_text' ) ) {
		$styles[] = "--color-dark-text: $color;";
	}
	if ( $color = get_theme_mod( 'burger_menu_dark_hover' ) ) {
		$styles[] = "--color-dark-hover: $color;";
	}
	if ( $styles ) {
		echo 'body._burger-menu-dark {' . implode( '', $styles ) . '}';
	}
}

$logo_block_width = get_theme_mod( 'header_logo_block_width', 35 );
if ( $logo_block_width != 35 ) {
	echo '@media (min-width: 1200px){.header-top__col_left{flex: 1 1 ' . $logo_block_width . '% !important; max-width: ' . $logo_block_width . '% !important;}}';
}

if ( get_theme_mod( 'link_as_bg' ) && is_singular() ) {
	$styles   = [];
	$color    = get_theme_mod( 'link_as_bg_text' );
	$color_bg = get_theme_mod( 'link_as_bg_color' );
	if ( $color ) {
		$styles[] = 'color:' . $color;
	}
	if ( $color_bg ) {
		$styles[] = 'background:' . $color_bg;
	}
	if ( $styles ) {
		echo 'body._post-link-bg .section-post__editor p>a{' . implode( ';', $styles ) . '}';
	}

	$styles   = [];
	$color    = get_theme_mod( 'link_as_bg_text_hover' );
	$color_bg = get_theme_mod( 'link_as_bg_color_hover' );
	if ( $color ) {
		$styles[] = 'color:' . $color;
	}
	if ( $color_bg ) {
		$styles[] = 'background:' . $color_bg;
	}
	if ( $styles ) {
		echo 'body._post-link-bg .section-post__editor p>a:hover{' . implode( ';', $styles ) . '}';
	}
}

if ( get_theme_mod( 'module_catalog_enabled' ) ) {
	$styles   = [];
	$bg_color = get_theme_mod( 'module_catalog_item_bg_category' );
	$color    = get_theme_mod( 'module_catalog_item_color_category' );

	if ( $color ) {
		$styles[] = 'color:' . $color;
	}
	if ( $bg_color ) {
		$styles[] = 'background-color:' . $bg_color;
	}
	if ( $styles ) {
		echo '.wescle-transport-item__category a,.wescle-transport-item__category span{' . implode( ';', $styles ) . '}';
	}

	$size = get_theme_mod( 'module_catalog_thumb_size' );
	if ( 100 != $size ) {
		echo '.wescle-transport-item__img{padding-bottom:' . $size . '%}';
	}

	$size = get_theme_mod( 'module_catalog_img_size' );
	if ( 20 != $size ) {
		echo ".wescle-transport-item__specifications li img{flex: 0 0 {$size}px;width:{$size}px;height:{$size}px;}";
	}

	$size = get_theme_mod( 'module_catalog_info_img_size' );
	if ( 24 != $size ) {
		echo ".wescle-catalog-options-item img, .wescle-catalog-description-item img{flex: 0 0 {$size}px;height:{$size}px;}";
		echo ".wescle-catalog-description-item img{width:{$size}px !important; height:{$size}px !important; flex-basis:{$size}px !important;}";
		echo ".wescle-catalog-advantages-item img{height:{$size}px;}";
	}
}

if ( ! get_theme_mod( 'cursor_text_enabled' ) && ! get_theme_mod( 'cursor_ball_enabled' ) ) {
	$img_id = get_theme_mod( 'cursor_image' );
	if ( $img_id ) {
		$x = intval( get_theme_mod( 'cursor_image_x' ) );
		$y = intval( get_theme_mod( 'cursor_image_y' ) );
		echo 'body{cursor: url(' . wp_get_attachment_url( $img_id ) . ') ' . $x . ' ' . $y . ', auto}';
	}
}
if ( get_theme_mod( 'cursor_text_enabled' ) ) {
	$color = get_theme_mod( 'cursor_text_bg' );
	if ( $color ) {
		echo "#wescle-cursor ._object{background-color:$color}";
	}
}
if ( get_theme_mod( 'cursor_ball_enabled' ) ) {
	$styles = [];

	$color = get_theme_mod( 'cursor_ball_bg' );
	if ( $color ) {
		$styles[] = "background-color:$color";
	}
	$img_id = get_theme_mod( 'cursor_ball_image' );
	if ( $img_id ) {
		$styles[] = "background-image:url(" . wp_get_attachment_url( $img_id ) . ")";
	}

	$x = intval( get_theme_mod( 'cursor_ball_x' ) );
	$y = intval( get_theme_mod( 'cursor_ball_y' ) );
	if ( $x != - 50 && $y != - 50 ) {
		$styles[] = "transform: translate($x%,$y%);";
	}

	if ( $styles ) {
		echo '#wescle-cursor ._ball{' . implode( ';', $styles ) . '}';
	}
}

if ( get_theme_mod( 'module_preloader_enabled' ) ) {
	$light = get_theme_mod( 'module_preloader_color_light', '#ffffff' );
	$dark  = get_theme_mod( 'module_preloader_color_dark', '#000000' );
	echo '._preloader{--bg-light:' . $light . ';--bg-dark:' . $dark . ';}';
}