<?php
add_filter( 'load_textdomain_mofile', function ( $mofile, $domain ) {
	if ( 'wescle' === $domain ) {
		if ( strpos( $mofile, '/themes/wescle/languages/' ) !== false ) {
			$locale_ru = [ 'ru_RU', 'az', 'azb', 'ar', 'ary', 'bel', 'bg_BG', 'mk_MK', 'mn', 'sah', 'sr_RS', 'tt_RU', 'uz_UZ' ];
			$locale    = get_locale();
			if ( in_array( $locale, $locale_ru ) ) {
				$mofile = '';
			}
			elseif ( $locale == 'uk' ) {
			}
			else {
				$mofile = get_template_directory() . '/languages/en_US.mo';
			}
		}
	}

	return $mofile;
}, 10, 2 );

load_theme_textdomain( 'wescle', get_template_directory() . '/languages' );

$min = defined( 'THEME_DEVELOPER' ) && THEME_DEVELOPER ? '' : 'min/';

require get_template_directory() . '/includes/app/' . $min . 'Core.php';
require get_template_directory() . '/includes/app/' . $min . 'TemplateFilters.php';
require get_template_directory() . '/includes/app/' . $min . 'WsclBreadcrumbs.php';
require get_template_directory() . '/includes/app/' . $min . 'Helper.php';
require get_template_directory() . '/includes/app/' . $min . 'WsclCounterPost.php';
require get_template_directory() . '/includes/app/' . $min . 'WsclPartnerShip.php';
require get_template_directory() . '/includes/app/' . $min . 'WsclShortcodes.php';
require get_template_directory() . '/includes/app/' . $min . 'WsclDemoContent.php';
require get_template_directory() . '/includes/app/' . $min . 'WsclAdminAnnotation.php';

if ( Helper::is_gutenberg_active() || apply_filters( 'wescle_blocks_enabled', false ) ) {
	require get_template_directory() . '/includes/wescle-blocks/plugin.php';
}

new Core();
TemplateFilters::getInstance();

if ( Helper::is_woocommerce_active() ) {
	$post_values = Helper::get_customizer_post_values();

	require get_template_directory() . '/includes/app/CustomPostType/BadgeProduct.php';
	require get_template_directory() . '/includes/app/MetaBox/MetaBoxBadgeProduct.php';

	require get_template_directory() . '/includes/app/CustomPostType/TabProduct.php';
	require get_template_directory() . '/includes/app/MetaBox/MetaBoxTabProduct.php';

	require get_template_directory() . '/includes/app/MetaBox/MetaBoxProductTerms.php';
	require get_template_directory() . '/includes/app/MetaBox/MetaBoxWooProduct.php';
	require get_template_directory() . '/includes/app/' . $min . 'WsclWoocommerce.php';

	if ( get_theme_mod( 'product_ajax_add_cart' ) ) {
		require get_template_directory() . '/includes/app/' . $min . 'WsclWooAjaxAddCart.php';
	}
	if ( get_theme_mod( 'product_variation_swatches' ) || ( isset( $post_values['product_variation_swatches'] ) && $post_values['product_variation_swatches'] ) ) {
		require get_template_directory() . '/includes/app/' . $min . 'WsclVariationSwatches.php';
	}

	require get_template_directory() . '/includes/woo-template-tags-filters.php';
}

$app_views_counter = null;
// Считаем просмотры страниц/записей
if ( get_theme_mod( 'module_counter_post_enabled', true ) ) {
	$app_views_counter = new WsclCounterPost();
}

Core::minimum_php_version( '7.3' );

// Обязательные плагины
require get_template_directory() . '/includes/tgmpa/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'wescle_register_required_plugins' );
function wescle_register_required_plugins() {
	$plugins = array(
		array(
			'name'     => 'Contact Form 7',
			'slug'     => 'contact-form-7',
			'required' => true,
		),
		array(
			'name'        => 'WordPress SEO by Yoast',
			'slug'        => 'wordpress-seo',
			'required'    => false,
			'is_callable' => 'wpseo_init',
		),
		array(
			'name'     => 'WooCommerce',
			'slug'     => 'woocommerce',
			'required' => false,
		),
	);

	$config = array(
		'id'           => 'wescle',                // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
	);

	tgmpa( $plugins, $config );
}
