<?php class WsclExportImport{private $menu_slug=THEME_SLUG.'_export_import';private $file_json_data=[];public function __construct(){add_action('admin_menu',array($this,'add_admin_menu'));add_action('admin_init',array($this,'download_file'));add_action('wp_ajax_wescle_import',array($this,'wescle_import'));add_action('wp_ajax_wescle_import_upload_image',array($this,'upload_image'));add_action('wp_ajax_wescle_import_custom_taxs',array($this,'import_custom_taxs'));add_action('wp_ajax_wescle_import_custom_posts',array($this,'import_custom_posts'));add_action('wp_ajax_wescle_import_add_page',array($this,'import_page'));add_action('upload_mimes',array($this,'upload_mimes_json'));add_filter('wp_check_filetype_and_ext',array($this,'allow_upload_extension'),10,4);}public function add_admin_menu(){add_submenu_page(null,__('Wescle Экспорт / Импорт','wescle'),__('Wescle Экспорт / Импорт','wescle'),'manage_options',$this->menu_slug,array($this,'page_template'));}public function page_template(){if(!current_user_can('manage_options')){wp_die(__('У вас недостаточно прав для доступа к этой странице.','wescle'));}$pages=get_pages(); ?>
        <div class="wrap">
			<?php include get_template_directory().'/template-parts/admin/settings-header.php' ?>
            <div class="_site-settings">
				<?php include get_template_directory().'/template-parts/admin/settings-navigation.php' ?>
                <div class="_site-settings__grid">
                    <div class="_site-settings__content">
                        <div class="wescle-notice">
                            <p><?php printf(__('Если заметили ошибки или не все блоки импортируются - пишите нам на email обратной связи: <a href="%s">%s</a>','wescle'),'mailto:info@wescle.com','info@wescle.com'); ?></p>
                        </div>
                        <h3><?php _e('Экспорт','wescle'); ?></h3>
                        <form action="?page=wescle_export_import" method="post" id="wescle_form_export">
                            <fieldset>
                                <label><span class="label-responsive"><?php _e('Выбрать страницу','wescle'); ?>:</span>
                                    <select name="page_export">
                                        <option value=""></option>
										<?php foreach($pages as $page){ ?>
											<?php if(strpos($page->post_content,'wp:wescle-blocks/')===false){continue;} ?>
                                            <option value="<?php echo $page->ID; ?>"><?php echo $page->post_title; ?></option>
										<?php } ?>
                                    </select>
                                </label>
                            </fieldset>
							<?php submit_button(__('Скачать файл экспорта','wescle')); ?>
                        </form>
                        <hr>
                        <h3><?php _e('Импорт','wescle'); ?></h3>
                        <form action="?page=wescle_export_import" method="post" id="wescle_form_import" enctype="multipart/form-data" style="max-width: 600px;">
                            <p>
                                <label><?php _e('Выберите файл на своём компьютере','wescle'); ?>:</label>
                                <input type="file" id="wescle_import" name="wescle_import" accept=".json"/>
                                <input type="hidden" name="action" value="wescle_import">
                            </p>
							<?php submit_button(__('Загрузить и импортировать файл','wescle')); ?>
                            <div class="block-spinner">
                                <span class="spinner" style="float: none"></span>
                            </div>
                        </form>
                        <textarea id="log" class="log" style="width: 100%;background: none;border: 0px;height: 220px;"></textarea>
                    </div>

                </div>
            </div>
            <script src="<?php echo get_template_directory_uri(); ?>/assets/admin/js/wescle-export-import.js"></script>
			<?php include get_template_directory().'/template-parts/admin/settings-footer.php' ?>
        </div>
		<?php }public function download_file(){global $wpdb;if(!isset($_POST['page_export'])||!$_POST['page_export']){return;}$post_id=$_POST['page_export']==='customizer'?'customizer':intval($_POST['page_export']);$post_content=$wpdb->get_var("SELECT post_content FROM {$wpdb->prefix}posts WHERE ID={$post_id}");$post_content=str_replace(['\u003cp\u003e','\u003c/p\u003e'],'',$post_content);$custom_posts=[];$custom_taxs=[];$page_meta_fields=[];$cf7_forms=get_option(THEME_SLUG.'_installed_forms',[]);$blocks=parse_blocks($post_content);foreach($blocks as $index=>$block){$posts=[];$posts_other=[];if($block['blockName']=='wescle-blocks/products'){$post_type='product_wescle';if(isset($block['attrs']['selectedProductsList'])){$post__in=[];foreach($block['attrs']['selectedProductsList']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}elseif(isset($block['attrs']['selectedCategories'])){$term_ids=[];foreach($block['attrs']['selectedCategories']as $item){if(!isset($custom_taxs[$item['id']])){$custom_taxs[$item['id']]=$this->get_term_data($item['id']);}$term_ids[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'tax_query'=>[['taxonomy'=>'productcat_wescle','terms'=>$term_ids,]]]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);}}if(in_array($block['blockName'],['wescle-blocks/services','wescle-blocks/additional-services'])){if(isset($block['attrs']['services'])){$post__in=[];foreach($block['attrs']['services']as $item){$post__in[]=$item['serviceId'];}$posts=get_posts(['post_type'=>'service','posts_per_page'=>-1,'post__in'=>$post__in,]);}}if($block['blockName']=='wescle-blocks/work-performed'){if(isset($block['attrs']['services'])){$posts=get_posts(['post_type'=>'portfolio_wescle','posts_per_page'=>-1,]);}}if($block['blockName']=='wescle-blocks/events'){$post_type='event_wescle';if(isset($block['attrs']['selectedEventsList'])){$post__in=[];foreach($block['attrs']['selectedEventsList']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>'event_wescle','posts_per_page'=>20,'orderby'=>['meta_value_num'=>'ASC'],'meta_query'=>[['key'=>'event_date','value'=>current_time('Ymd'),'compare'=>'>=','type'=>'NUMERIC']],]);}}if($block['blockName']=='wescle-blocks/our-works'){if(isset($block['attrs']['posts'])){$post__in=[];foreach($block['attrs']['posts']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>'gallery_wescle','posts_per_page'=>-1,'post__in'=>$post__in,]);}if(isset($block['attrs']['services'])){foreach($block['attrs']['services']as $item){if(!isset($custom_taxs[$item['serviceId']])){$custom_taxs[$item['serviceId']]=$this->get_term_data($item['serviceId']);}}}}if($block['blockName']=='wescle-blocks/packages-include'){$post_type='pricepackage_wescle';if(isset($block['attrs']['selectedPackagesLists'])){$post__in=[];foreach($block['attrs']['selectedPackagesLists']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);}$posts_optionpackage=get_posts(['post_type'=>'optionpackage_wescle','posts_per_page'=>100,]);foreach($posts_optionpackage as $post){if(!isset($custom_posts[$post->ID])){$custom_posts[$post->ID]=$this->get_post_data($post);}}}if($block['blockName']=='wescle-blocks/schedule-block'){$post_type='program_wescle';$post_type_speaker='speaker_program';if(isset($block['attrs']['selectedProgramsLists'])){$post__in=[];foreach($block['attrs']['selectedProgramsLists']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);}$posts_other=get_posts(['post_type'=>$post_type_speaker,'posts_per_page'=>100,]);}if($block['blockName']=='wescle-blocks/reviews'){$post_type='review';if(isset($block['attrs']['selectedReviewsList'])){$post__in=[];foreach($block['attrs']['selectedReviewsList']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);}}if($block['blockName']=='wescle-blocks/price-list'){$post_type='price_wescle';if(isset($block['attrs']['selectedPrices'])){$post__in=[];foreach($block['attrs']['selectedPrices']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);}}if($block['blockName']=='wescle-blocks/instruction'){$post_type='faq_wescle';$taxonomy='faqcat_wescle';if(isset($block['attrs']['services'])){$term_ids=[];foreach($block['attrs']['services']as $item){if(!isset($custom_taxs[$item['serviceId']])){$custom_taxs[$item['serviceId']]=$this->get_term_data($item['serviceId']);}$term_ids[]=$item['serviceId'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'tax_query'=>[['taxonomy'=>$taxonomy,'terms'=>$term_ids,]]]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);if(isset($block['attrs']['categories'])){foreach($block['attrs']['categories']as $item){if(!isset($custom_taxs[$item['id']])){$custom_taxs[$item['id']]=$this->get_term_data($item['id']);}}}}}if($block['blockName']=='wescle-blocks/stories'){$posts=get_posts(['post_type'=>'stories_wescle','posts_per_page'=>20,]);}if(in_array($block['blockName'],['wescle-blocks/videos-slider','wescle-blocks/videos-section','wescle-blocks/videos-max'])){$post_type='video_wescle';if(isset($block['attrs']['items'])){$post__in=[];foreach($block['attrs']['items']as $item){$post__in[]=$item['video']['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);}}if($block['blockName']=='wescle-blocks/highlight-tabs'){$post_type='tab_wescle';if(isset($block['attrs']['items'])){$post__in=[];foreach($block['attrs']['items']as $item){$post__in[]=$item['tab']['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}}if($block['blockName']=='wescle-blocks/team3'){$post_type='team_wescle';if(isset($block['attrs']['selectedPeoples'])){$post__in=[];foreach($block['attrs']['selectedPeoples']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);}}if($block['blockName']=='wescle-blocks/reviews-2'){$post_type='videoreview';if(isset($block['attrs']['selectedReviewsList'])){$post__in=[];foreach($block['attrs']['selectedReviewsList']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);}}if($block['blockName']=='wescle-blocks/licenses'){$post_type='license_wescle';$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);if(isset($block['attrs']['categories'])){foreach($block['attrs']['categories']as $item){if(!isset($custom_taxs[$item['id']])){$custom_taxs[$item['id']]=$this->get_term_data($item['id']);}}}}if($block['blockName']=='wescle-blocks/partners'){$post_type='partner_wescle';if(isset($block['attrs']['selectedPartnersList'])){$post__in=[];foreach($block['attrs']['selectedPartnersList']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);}}if($block['blockName']=='wescle-blocks/blocks-posts'){$post_type='post';$taxonomy='category';if(!isset($block['attrs']['items'])){continue;}if(isset($block['attrs']['initialCategories'])){foreach($block['attrs']['initialCategories']as $item){if(!isset($custom_taxs[$item['id']])){$custom_taxs[$item['id']]=$this->get_term_data($item['id']);}}}foreach($block['attrs']['items']as $item_block){if($item_block['categories']){$term_ids=[];foreach($item_block['categories']as $item){if(!isset($custom_taxs[$item['id']])){$custom_taxs[$item['id']]=$this->get_term_data($item['id']);}$term_ids[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,'tax_query'=>[['taxonomy'=>$taxonomy,'terms'=>$term_ids,]]]);}elseif($item_block['articles']){$post__in=[];foreach($item_block['articles']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);}foreach($posts as $post){if(!isset($custom_posts[$post->ID])){$custom_posts[$post->ID]=$this->get_post_data($post);}}$posts=[];}}if(in_array($block['blockName'],['wescle-blocks/wescle-catalog-advantages','wescle-blocks/wescle-catalog-options'])){$post_type='info_catalog';if(isset($block['attrs']['selectedBlocks'])){$post__in=[];foreach($block['attrs']['selectedBlocks']as $item){$post__in[]=$item['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,]);}}if($block['blockName']=='wescle-blocks/wescle-catalog'){$post_type='catalog_item';if(isset($block['attrs']['services'])){$post_ids=[];foreach($block['attrs']['services']as $item){if($item['arrayProductsByID']){foreach($item['arrayProductsByID']as $post_item){$post_ids[]=$post_item['id'];}}elseif($item['arrayProductsByCategories']){foreach($item['arrayProductsByCategories']as $post_item){$post_ids[]=$post_item['id'];}}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>$item['goodsOnPage'],'fields'=>'ids','orderby'=>['menu_order'=>'ASC','date'=>'DESC'],]);foreach($posts as $id){$post_ids[]=$id;}}}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post_ids,]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,'orderby'=>['menu_order'=>'ASC','date'=>'DESC'],]);}if(isset($block['attrs']['categories'])){foreach($block['attrs']['categories']as $item){if(!isset($custom_taxs[$item['id']])){$custom_taxs[$item['id']]=$this->get_term_data($item['id']);}}}$posts_other=get_posts(['post_type'=>'badge_catalog','posts_per_page'=>100,]);}if($block['blockName']=='wescle-blocks/mosaic-tile'){$post_type='mosaic_wescle';$taxonomy='mosaiccat_wescle';if(isset($block['attrs']['services'])){$term_ids=[];foreach($block['attrs']['services']as $item){if(!isset($custom_taxs[$item['tabId']])){$custom_taxs[$item['tabId']]=$this->get_term_data($item['tabId']);}$term_ids[]=$item['tabId'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'tax_query'=>[['taxonomy'=>$taxonomy,'terms'=>$term_ids,]]]);}else{$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>20,]);if(isset($block['attrs']['categories'])){foreach($block['attrs']['categories']as $item){if(!isset($custom_taxs[$item['id']])){$custom_taxs[$item['id']]=$this->get_term_data($item['id']);}}}}}if($block['blockName']=='wescle-blocks/info-tabs'){$post_type='infotab_wescle';if(isset($block['attrs']['items'])){$post__in=[];foreach($block['attrs']['items']as $item){$post__in[]=$item['tab']['id'];}$posts=get_posts(['post_type'=>$post_type,'posts_per_page'=>-1,'post__in'=>$post__in,]);}}if($block['blockName']=='wescle-blocks/wescle-categories'){if(isset($block['attrs']['selectedTaxonomy'])&&$block['attrs']['selectedTaxonomy']){$taxonomy=$block['attrs']['selectedTaxonomy'];if(isset($block['attrs']['arrCategoriesByID'])&&$block['attrs']['arrCategoriesByID']){foreach($block['attrs']['arrCategoriesByID']as $item){if(!isset($custom_taxs[$item['id']])){$custom_taxs[$item['id']]=$this->get_term_data($item['id']);}}}else{$limit=isset($block['attrs']['categoriesOnPage'])?$block['attrs']['categoriesOnPage']:10;$terms=get_terms(['taxonomy'=>$taxonomy,'number'=>$limit,'hide_empty'=>false,]);if($terms&&!is_wp_error($terms)){foreach($terms as $term){if(!isset($custom_taxs[$term->term_id])){$custom_taxs[$term->term_id]=$this->get_term_data($term->term_id);}}}}}}foreach($posts as $post){if(!isset($custom_posts[$post->ID])){$custom_posts[$post->ID]=$this->get_post_data($post);}}foreach($posts_other as $post){if(!isset($custom_posts[$post->ID])){$custom_posts[$post->ID]=$this->get_post_data($post);}}}$page_meta_keys=$wpdb->get_results("SELECT meta_key FROM $wpdb->postmeta WHERE post_id=$post_id");if($page_meta_keys){foreach($page_meta_keys as $item){$meta_key=$item->meta_key;if(in_array($meta_key,['_edit_lock','_edit_last'])){continue;}$meta_value=get_post_meta($post_id,$meta_key,1);$image_keys=['backgroundImage','backgroundImageTablet','backgroundImagePhone','animated_bg_image_1','parallax_bg_image_1','parallax_bg_image_2',];if(in_array($meta_key,$image_keys)){if($meta_value){$meta_value=wp_get_attachment_url($meta_value);}}if('wescle_slider_banners'==$meta_key||'slider_store_one_slides'==$meta_key){foreach($meta_value as $meta_value_key=>$meta_value_item){if($meta_value_item['image']){$meta_value[$meta_value_key]['image']=wp_get_attachment_url($meta_value_item['image']);}if($meta_value_item['video']){$meta_value[$meta_value_key]['video']=wp_get_attachment_url($meta_value_item['video']);}}}if('parallax_text_items'==$meta_key||'slider_store_two_slides'==$meta_key){foreach($meta_value as $meta_value_key=>$meta_value_item){if($meta_value_item['image']){$meta_value[$meta_value_key]['image']=wp_get_attachment_url($meta_value_item['image']);}}}$page_meta_fields[$meta_key]=$meta_value;}}$data=['settings'=>$post_id,'post_title'=>get_the_title(intval($post_id)),'home_url'=>trim(home_url(),'/'),'post_content'=>$post_content,'custom_posts'=>array_values(array_reverse($custom_posts)),'custom_taxs'=>array_values($custom_taxs),'cf7_forms'=>$cf7_forms,'meta_fields'=>$page_meta_fields];$data_json=json_encode($data,JSON_UNESCAPED_SLASHES);$file_name="wescle-blocks-{$post_id}.json";header("Content-Disposition: attachment; filename={$file_name}");header("Content-Type: application/json; charset=utf-8");header("Expires: 0");header('Pragma: no-cache');echo $data_json;exit;}public function get_term_data($term){$data=[];if(!is_object($term)){$term=get_term_by('term_taxonomy_id',intval($term));}if($term){$meta_fields=[];if($img_id=get_term_meta($term->term_id,'_thumbnail_id',1)){$meta_fields['_thumbnail_id']=wp_get_attachment_url($img_id);}if($img_id=get_term_meta($term->term_id,'thumbnail_id',1)){$meta_fields['thumbnail_id']=wp_get_attachment_url($img_id);}$data=['import_id'=>$term->term_id,'taxonomy'=>$term->taxonomy,'name'=>$term->name,'description'=>$term->description,'parent'=>$term->parent,'meta_fields'=>$meta_fields,];}return $data;}public function get_post_data($post){$meta_fields=[];$post_terms_data=[];switch($post->post_type){case 'product_wescle':$meta_fields=['price'=>get_post_meta($post->ID,'price',1),'price_old'=>get_post_meta($post->ID,'price_old',1),'gradient_disable'=>get_post_meta($post->ID,'gradient_disable',1),'button_text'=>get_post_meta($post->ID,'button_text',1),'button_url'=>get_post_meta($post->ID,'button_url',1),];$taxonomy='productcat_wescle';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'service':$img_id=get_post_meta($post->ID,'service_icon',1);$meta_fields=['price'=>get_post_meta($post->ID,'price',1),'price_old'=>get_post_meta($post->ID,'price_old',1),'button_text'=>get_post_meta($post->ID,'button_text',1),'button_link'=>get_post_meta($post->ID,'button_link',1),'service_icon'=>$img_id?wp_get_attachment_url($img_id):''];$taxonomy='service_cat';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'portfolio_wescle':$taxonomy='portfolio_tag';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'event_wescle':$meta_fields=['event_date'=>get_post_meta($post->ID,'event_date',1),'event_info'=>get_post_meta($post->ID,'event_info',1),];break;case 'gallery_wescle':$taxonomy='gallerycat_wescle';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'pricepackage_wescle':$meta_fields=['price'=>get_post_meta($post->ID,'price',1),'price_old'=>get_post_meta($post->ID,'price_old',1),'label_after_button'=>get_post_meta($post->ID,'label_after_button',1),'block_color'=>get_post_meta($post->ID,'block_color',1),'button_url'=>get_post_meta($post->ID,'button_url',1),];break;case 'optionpackage_wescle':$meta_fields=['price_package_ids'=>get_post_meta($post->ID,'price_package_ids',1),];break;case 'program_wescle':$meta_fields=['is_bonus'=>get_post_meta($post->ID,'is_bonus',1),'sub_title'=>get_post_meta($post->ID,'sub_title',1),'speacker_id'=>get_post_meta($post->ID,'speacker_id',1)];break;case 'review':$img_id=get_post_meta($post->ID,'thumbnail_video',1);$meta_fields=['sub_title'=>get_post_meta($post->ID,'sub_title',1),'date_review'=>get_post_meta($post->ID,'date_review',1),'rating'=>get_post_meta($post->ID,'rating',1),'rating_after_title'=>get_post_meta($post->ID,'rating_after_title',1),'source'=>get_post_meta($post->ID,'source',1),'youtube_link'=>get_post_meta($post->ID,'youtube_link',1),'thumbnail_video'=>$img_id?wp_get_attachment_url($img_id):'',];break;case 'price_wescle':$meta_fields=['is_open'=>get_post_meta($post->ID,'is_open',1),];break;case 'faq_wescle':if($post_terms=get_the_terms($post,'faqcat_wescle')){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'stories_wescle':$stories_info=get_post_meta($post->ID,'wescle_stories_info',1);foreach($stories_info as $key=>$item){if($item['img_id']){$stories_info[$key]['img_id']=wp_get_attachment_url($item['img_id']);}if($item['file_id']){$stories_info[$key]['file_id']=wp_get_attachment_url($item['file_id']);}}$meta_fields=['time_length'=>get_post_meta($post->ID,'time_length',1),'wescle_stories_info'=>$stories_info,];break;case 'video_wescle':$meta_fields=['time_duration'=>get_post_meta($post->ID,'time_duration',1),'custom_views'=>get_post_meta($post->ID,'custom_views',1),'hide_views'=>get_post_meta($post->ID,'hide_views',1),'custom_url'=>get_post_meta($post->ID,'custom_url',1),'play_tooltip'=>get_post_meta($post->ID,'play_tooltip',1),'info_tooltip'=>get_post_meta($post->ID,'info_tooltip',1),'youtube_link'=>get_post_meta($post->ID,'youtube_link',1),];$taxonomy='videocat_wescle';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'tab_wescle':$info=get_post_meta($post->ID,'wescle_tab_info',1);foreach($info as $key=>$item){if($item['img_id']){$info[$key]['img_id']=wp_get_attachment_url($item['img_id']);}}$meta_fields=['wescle_tab_info'=>$info,];break;case 'team_wescle':$meta_fields=['position'=>get_post_meta($post->ID,'position',1),'email'=>get_post_meta($post->ID,'email',1),'phone'=>get_post_meta($post->ID,'phone',1),'link_fb'=>get_post_meta($post->ID,'link_fb',1),'link_twitter'=>get_post_meta($post->ID,'link_twitter',1),'link_inst'=>get_post_meta($post->ID,'link_inst',1),];$taxonomy='teamcat_wescle';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'videoreview':$meta_fields=['youtube_link'=>get_post_meta($post->ID,'youtube_link',1)];break;case 'license_wescle':$meta_fields=['is_special'=>get_post_meta($post->ID,'is_special',1),'color_gradient1'=>get_post_meta($post->ID,'color_gradient1',1),'color_text'=>get_post_meta($post->ID,'color_text',1),'color_bg'=>get_post_meta($post->ID,'color_bg',1),'price'=>get_post_meta($post->ID,'price',1),'sale_price'=>get_post_meta($post->ID,'sale_price',1),'label_button'=>get_post_meta($post->ID,'label_button',1),'button_url'=>get_post_meta($post->ID,'button_url',1),'wescle_license_info'=>get_post_meta($post->ID,'wescle_license_info',1),];$taxonomy='licensecat_wescle';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'partner_wescle':$meta_fields=['featured'=>get_post_meta($post->ID,'featured',1),'site_url'=>get_post_meta($post->ID,'site_url',1),'site_label'=>get_post_meta($post->ID,'site_label',1),'phone'=>get_post_meta($post->ID,'phone',1),];$taxonomy='partnercat_wescle';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'post':$img_id=get_post_meta($post->ID,'thumbnail_archive',1);$meta_fields=['show_image_news_widget'=>get_post_meta($post->ID,'show_image_news_widget',1),'thumbnail_archive'=>$img_id?wp_get_attachment_url($img_id):''];if($post_terms=get_the_terms($post,'category')){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}if($post_terms=get_the_terms($post,'post_tag')){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'info_catalog':$img_id=get_post_meta($post->ID,'icon_id',1);$meta_fields=['text'=>get_post_meta($post->ID,'text',1),'icon_id'=>$img_id?wp_get_attachment_url($img_id):''];$taxonomy='partnercat_wescle';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'badge_catalog':$meta_fields=['bg_color'=>get_post_meta($post->ID,'bg_color',1),];break;case 'catalog_item':$meta_fields=['is_top'=>get_post_meta($post->ID,'is_top',1),'object_fit_contain'=>get_post_meta($post->ID,'object_fit_contain',1),'youtube_link'=>get_post_meta($post->ID,'youtube_link',1),'video_file'=>get_post_meta($post->ID,'video_file',1)?wp_get_attachment_url(get_post_meta($post->ID,'video_file',1)):'','order_checkbox_disabled'=>get_post_meta($post->ID,'order_checkbox_disabled',1),'custom_url'=>get_post_meta($post->ID,'custom_url',1),'button_text'=>get_post_meta($post->ID,'button_text',1),'button_link'=>get_post_meta($post->ID,'button_link',1),'button_link_is_blank'=>get_post_meta($post->ID,'button_link_is_blank',1),'button2_text'=>get_post_meta($post->ID,'button2_text',1),'button2_link'=>get_post_meta($post->ID,'button2_link',1),'button2_link_is_blank'=>get_post_meta($post->ID,'button2_link_is_blank',1),'manage_stock'=>get_post_meta($post->ID,'manage_stock',1),'stock'=>get_post_meta($post->ID,'stock',1),'stock_status'=>get_post_meta($post->ID,'stock_status',1),'wescle_advantages_title'=>get_post_meta($post->ID,'wescle_advantages_title',1),'info_items_as_list'=>get_post_meta($post->ID,'info_items_as_list',1),'info_items'=>get_post_meta($post->ID,'info_items',1),'catalog_item_badges'=>get_post_meta($post->ID,'catalog_item_badges',1),'lat'=>get_post_meta($post->ID,'lat',1),'lng'=>get_post_meta($post->ID,'lng',1),'zoom'=>get_post_meta($post->ID,'zoom',1),'map_image'=>get_post_meta($post->ID,'map_image',1)?wp_get_attachment_url(get_post_meta($post->ID,'map_image',1)):'','count_order'=>0,];foreach(['wescle_advantages','wescle_catalog_images']as $post_meta_key){$meta_value=get_post_meta($post->ID,$post_meta_key,1);if($meta_value){foreach($meta_value as $meta_value_key=>$meta_value_item){if(isset($meta_value_item['img_id'])&&$meta_value_item['img_id']){$meta_value[$meta_value_key]['img_id']=wp_get_attachment_url($meta_value_item['img_id']);}if(isset($meta_value_item['file_id'])&&$meta_value_item['file_id']){$meta_value[$meta_value_key]['file_id']=wp_get_attachment_url($meta_value_item['file_id']);}}$meta_fields[$post_meta_key]=$meta_value;}}$taxonomy='catalogcat_wescle';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'mosaic_wescle':$meta_fields=['label'=>get_post_meta($post->ID,'label',1),'url'=>get_post_meta($post->ID,'url',1),'type'=>get_post_meta($post->ID,'type',1),];$taxonomy='mosaiccat_wescle';if($post_terms=get_the_terms($post,$taxonomy)){foreach($post_terms as $term){$post_terms_data[]=$this->get_term_data($term);}}break;case 'infotab_wescle':$img_id=get_post_meta($post->ID,'icon',1);$meta_fields=['icon'=>$img_id?wp_get_attachment_url($img_id):'','color_active'=>get_post_meta($post->ID,'color_active',1),'tooltip'=>get_post_meta($post->ID,'tooltip',1),'custom_title'=>get_post_meta($post->ID,'custom_title',1),'title_type'=>get_post_meta($post->ID,'title_type',1),'button_text'=>get_post_meta($post->ID,'button_text',1),'button_link'=>get_post_meta($post->ID,'button_link',1),'button_link_is_blank'=>get_post_meta($post->ID,'button_link_is_blank',1),'gallery_slider'=>get_post_meta($post->ID,'gallery_slider',1),'slider_arrows'=>get_post_meta($post->ID,'slider_arrows',1),'slider_dots'=>get_post_meta($post->ID,'slider_dots',1),'slider_autoplay'=>get_post_meta($post->ID,'slider_autoplay',1),'slider_autoplay_speed'=>get_post_meta($post->ID,'slider_autoplay_speed',1),'slider_count'=>get_post_meta($post->ID,'slider_count',1),'count_in_row'=>get_post_meta($post->ID,'count_in_row',1),];foreach(['gallery_images','infotab_info']as $post_meta_key){$meta_value=get_post_meta($post->ID,$post_meta_key,1);if($meta_value){foreach($meta_value as $meta_value_key=>$meta_value_item){if($meta_value_item['img_id']){$meta_value[$meta_value_key]['img_id']=wp_get_attachment_url($meta_value_item['img_id']);}}$meta_fields[$post_meta_key]=$meta_value;}}break;}$data=['import_id'=>$post->ID,'post_type'=>$post->post_type,'post_title'=>$post->post_title,'post_content'=>$post->post_content,'menu_order'=>$post->menu_order,'thumbnail_url'=>get_post_thumbnail_id($post)?wp_get_attachment_url(get_post_thumbnail_id($post)):'','meta_fields'=>$meta_fields,'post_terms_data'=>$post_terms_data,];return $data;}public function wescle_import(){if(!current_user_can('manage_options')){wp_die(esc_html__('У вас недостаточно прав для доступа к этой странице.','wescle'));}if($_FILES['wescle_import']&&!$_FILES['wescle_import']['error']){if($_FILES['wescle_import']['type']=='application/json'){$wescle_import_file=file_get_contents($_FILES['wescle_import']['tmp_name']);if(strpos($wescle_import_file,'{"settings":"wescle-layout-')===0){$json_data=json_decode($wescle_import_file,true);$layout_id=str_replace('wescle-layout-','',$json_data['settings']);$license=get_option('wescle_license');$host=parse_url(home_url())['host'];$api_url='https://wescle.com/wp-content/theme_license/license_info.php?license_key='.$license.'&host='.$host.'&layout='.$layout_id;$response=wp_remote_get($api_url,array('timeout'=>60,'sslverify'=>false,));if(wp_remote_retrieve_response_code($response)===200){$body=wp_remote_retrieve_body($response);$body_decode=json_decode($body,true);if($body_decode['license_valid']&&$body_decode['download_url']){$tmp=download_url($body_decode['download_url']);$file_name=basename($body_decode['download_url']);$file=array('name'=>$file_name,'tmp_name'=>$tmp);if(is_wp_error($file['tmp_name'])){$upload['error']=__('Не удалось скачать файл шаблон','wescle');}else{$overrides=array('test_form'=>false,);$upload=wp_handle_sideload($file,$overrides);}}else{$upload['error']=__('Нет прав для скачивания файла','wescle');}}else{$upload['error']=__('Нет прав для импорта файла','wescle').' '.$_FILES['wescle_import']['name'];}}else{$overrides=array('test_form'=>false,);$import=$_FILES['wescle_import'];$upload=wp_handle_upload($import,$overrides);}if(isset($upload['error'])){wp_send_json_error($upload['error']);}else{$images_url=[];$json_string=file_get_contents($upload['file']);$json_data=json_decode($json_string,true);if(is_array($json_data)&&isset($json_data['post_content'])){update_option('wescle_import_file',$upload['file']);preg_match_all("~https?://[a-z0-9\-._\~\!$&\'()*+,;=:/]+~",$json_data['post_content'],$matches);$images_url=$matches[0];$images_url=array_unique($images_url);foreach($images_url as $key=>$url){if(!$this->is_url_image($url)){unset($images_url[$key]);}}$images_url=array_values($images_url);}else{@unlink($upload['file']);delete_option('wescle_import_file');wp_send_json_error($upload['error']);}wp_send_json_success(['images_url'=>$images_url,'custom_posts'=>$json_data['custom_posts'],'custom_taxs'=>$json_data['custom_taxs']]);}}}exit;}public function get_import_file_data(){if(empty($this->file_json_data)){$import_file=get_option('wescle_import_file');if($import_file&&file_exists($import_file)){$json_string=file_get_contents($import_file);$this->file_json_data=json_decode($json_string,true);}}return $this->file_json_data;}public function upload_mimes_json($mimes){$mimes['json']='application/json';return $mimes;}public function allow_upload_extension($data,$file,$filename,$mimes){if(!empty($data)){$filetype=wp_check_filetype($filename);$data['ext']=$filetype['ext'];$data['type']=$filetype['type'];}return $data;}public function upload_image($url='',$post_id=0,$is_return=false){if(!$url&&isset($_POST['img_url'])&&$_POST['img_url']){$url=$_POST['img_url'];}$attachment_id=0;if($url!=""){$file_name=basename($url);$args=array('post_type'=>'attachment','post_status'=>'any','posts_per_page'=>1,'fields'=>'ids','meta_query'=>array(array('key'=>'wescle_import_name','value'=>$file_name,),),);$ids=get_posts($args);if($ids){$attachment_id=current($ids);if(!$is_return){echo 'Info: file exists '.$url;}}else{$tmp=download_url($url);$file=array('name'=>$file_name,'tmp_name'=>$tmp);if(is_wp_error($file['tmp_name'])){if(!$is_return){echo 'Error: '.$file['tmp_name']->get_error_message().' | '.$url;}error_log('wescle_import_file tmp_name: '.print_r($file['tmp_name']->get_error_messages(),1));}else{$attachment_id=media_handle_sideload($file,$post_id);if(is_wp_error($attachment_id)){@unlink($file['tmp_name']);if(!$is_return){echo 'Error: '.$attachment_id->get_error_message().' | '.$url;}error_log('wescle_import_file $attachment_id: '.print_r($attachment_id->get_error_messages(),1));$attachment_id=0;}else{if(!$is_return){echo 'Info: image upload success '.$url;}update_post_meta($attachment_id,'wescle_import_name',$file_name);}}}if(!$is_return){$images_url=get_option('wescle_import_images_url',[]);$images_url[$url]=$attachment_id?wp_get_attachment_url($attachment_id):$url;update_option('wescle_import_images_url',$images_url);}}if($is_return){return $attachment_id;}else{exit;}}public function import_custom_taxs(){$term_data=$_POST['term_data'];if($term_data){$this->insert_custom_terms([$term_data],true);}exit;}public function insert_custom_terms($data_taxs=[],$is_custom_taxs=false){$custom_terms=[];foreach($data_taxs as $item){$terms=get_terms(['taxonomy'=>$item['taxonomy'],'meta_query'=>[['key'=>'import_id','value'=>$item['import_id'],]],]);if($terms){if($is_custom_taxs){$custom_terms[$item['import_id']]=current($terms);}else{$custom_terms[]=intval(current($terms)->term_id);}echo 'Info: term exists | '.$item['name'].' | '.$item['taxonomy'];if(!$is_custom_taxs){echo "\r\n";}}else{$term_id=term_exists($item['name'],$item['taxonomy']);if($term_id){$term_id=intval($term_id['term_id']);update_term_meta($term_id,'import_id',$item['import_id']);if($is_custom_taxs){$custom_terms[$item['import_id']]=get_term_by('id',$term_id,$item['taxonomy']);}else{$custom_terms[]=$term_id;}echo 'Info: term exists NAME | '.$item['name'].' | '.$item['taxonomy'];if(!$is_custom_taxs){echo "\r\n";}}else{$args=['description'=>$item['description'],];$insert_term=wp_insert_term($item['name'],$item['taxonomy'],$args);if($insert_term&&!is_wp_error($insert_term)){$term_id=intval($insert_term['term_id']);update_term_meta($term_id,'import_id',$item['import_id']);if(isset($item['meta_fields'])&&$item['meta_fields']){foreach($item['meta_fields']as $meta_key=>$meta_value){if($this->is_url_image($meta_value)){$img_id=$this->upload_image($meta_value,0,true);if($img_id){$meta_value=$img_id;}}update_term_meta($term_id,$meta_key,$meta_value);}}if($is_custom_taxs){$custom_terms[$item['import_id']]=get_term_by('id',$term_id,$item['taxonomy']);}else{$custom_terms[]=$term_id;}echo 'Info: term insert | '.$item['name'].' | '.$item['taxonomy'];}else{echo 'Error: wp_insert_term '.$item['name'].' - '.$item['taxonomy'].' | '.$insert_term->get_error_message();}}}}return $custom_terms;}public function import_custom_posts(){$item=$_POST['post_data'];if($item){$posts=get_posts(['post_type'=>$item['post_type'],'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['import_id'],]],]);if($posts){echo 'Info: post exists | '.$item['post_title'].' | '.$item['post_type'];}else{$post_content=$item['post_content'];$images_url=get_option('wescle_import_images_url',[]);foreach($images_url as $old_url=>$new_url){$post_content=str_replace($old_url,$new_url,$post_content);}$post_data=array('post_type'=>$item['post_type'],'post_title'=>$item['post_title'],'post_content'=>$post_content,'menu_order'=>$item['menu_order'],'post_status'=>'publish',);$post_id=wp_insert_post($post_data);if($post_id&&!is_wp_error($post_id)){update_post_meta($post_id,'import_id',$item['import_id']);if($item['thumbnail_url']){$attachment_id=$this->upload_image($item['thumbnail_url'],$post_id,true);if($attachment_id){update_post_meta($post_id,'_thumbnail_id',$attachment_id);}}if(isset($item['meta_fields'])&&$item['meta_fields']){foreach($item['meta_fields']as $meta_key=>$meta_value){if($this->is_url_image($meta_value)){$img_id=$this->upload_image($meta_value,$post_id,true);if($img_id){$meta_value=$img_id;}}if('price_package_ids'==$meta_key&&is_array($meta_value)){$new_meta_value=[];foreach($meta_value as $id){$posts=get_posts(['post_type'=>'pricepackage_wescle','post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$id,]]]);if($posts){$new_meta_value[]=(string) current($posts)->ID;}}$meta_value=$new_meta_value;}if('speacker_id'==$meta_key&&$meta_value){$posts=get_posts(['post_type'=>'speaker_program','post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$meta_value,]]]);if($posts){$meta_value=(string) current($posts)->ID;}}if('wescle_stories_info'==$meta_key&&$meta_value){foreach($meta_value as $stories_info_key=>$stories_info_item){$img_id=$stories_info_item['img_id'];$file_id=$stories_info_item['file_id'];if($img_id&&$this->is_url_image($img_id)){$meta_value[$stories_info_key]['img_id']=$this->upload_image($img_id,$post_id,true);}if($file_id&&strpos($file_id,'.mp4')!==false){$meta_value[$stories_info_key]['file_id']=$this->upload_image($file_id,$post_id,true);}}}if('wescle_tab_info'==$meta_key&&$meta_value){foreach($meta_value as $info_key=>$info_item){$img_id=$info_item['img_id'];if($img_id&&$this->is_url_image($img_id)){$meta_value[$info_key]['img_id']=$this->upload_image($img_id,$post_id,true);}}}if('wescle_advantages'==$meta_key&&$meta_value){foreach($meta_value as $info_key=>$info_item){$img_id=$info_item['img_id'];if($img_id&&$this->is_url_image($img_id)){$meta_value[$info_key]['img_id']=$this->upload_image($img_id,$post_id,true);}}}if('wescle_catalog_images'==$meta_key&&$meta_value){foreach($meta_value as $info_key=>$info_item){$img_id=$info_item['img_id'];$file_id=$info_item['file_id'];if($file_id&&strpos($file_id,'.mp4')!==false){$meta_value[$info_key]['file_id']=$this->upload_image($file_id,$post_id,true);}if($img_id&&$this->is_url_image($img_id)){$meta_value[$info_key]['img_id']=$this->upload_image($img_id,$post_id,true);}}}if('video_file'==$meta_key&&$meta_value){$file_id=$meta_value;if($file_id&&strpos($file_id,'.mp4')!==false){$meta_value=$this->upload_image($file_id,$post_id,true);}}if('catalog_item_badges'==$meta_key&&$meta_value){$meta_value_new=[];foreach($meta_value as $id){$posts=get_posts(['post_type'=>'badge_catalog','post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$id,]]]);if($posts){$meta_value_new[]=(string) current($posts)->ID;}}$meta_value=$meta_value_new;}if(('gallery_images'==$meta_key||'infotab_info'==$meta_key)&&$meta_value){foreach($meta_value as $info_key=>$info_item){$img_id=$info_item['img_id'];if($img_id&&$this->is_url_image($img_id)){$meta_value[$info_key]['img_id']=$this->upload_image($img_id,$post_id,true);}}}update_post_meta($post_id,$meta_key,$meta_value);}}if(isset($item['post_terms_data'])&&$item['post_terms_data']){$post_terms_data=[];foreach($item['post_terms_data']as $post_terms_data_item){$post_terms_data[$post_terms_data_item['taxonomy']][]=$post_terms_data_item;}foreach($post_terms_data as $taxonomy=>$post_terms_data_items){$custom_terms=$this->insert_custom_terms($post_terms_data_items);if($custom_terms){wp_set_post_terms($post_id,$custom_terms,$taxonomy,false);}}}echo 'Info: post insert | '.$item['post_title'].' | '.$item['post_type'];}else{echo 'Error: wp_insert_post '.$item['post_type'].' | '.$post_id->get_error_message();}}}exit;}public function is_url_image($string){$is_image=false;if(is_string($string)){$string_arr=explode('.',$string);$type=$string_arr[count($string_arr)-1];if(in_array($type,['jpg','jpeg','png','svg'])){$is_image=true;}}return $is_image;}public function import_page(){$import_file=get_option('wescle_import_file');if($import_file&&file_exists($import_file)){$json_data=$this->get_import_file_data();if(is_array($json_data)&&isset($json_data['post_content'])){if($json_data['settings']!=='customizer'){$post_title=isset($json_data['post_title'])&&$json_data['post_title']?$json_data['post_title']:'Wescle page';$post_content=$json_data['post_content'];$post_content=$this->replace_custom_posts_in_content($post_content);$images_url=get_option('wescle_import_images_url',[]);foreach($images_url as $old_url=>$new_url){$post_content=str_replace($old_url,$new_url,$post_content);}$new_page=array('post_title'=>$post_title,'post_content'=>$post_content,'post_type'=>'page',);$new_page_id=wp_insert_post($new_page);if($new_page_id){echo 'New page ID: '.$new_page_id.' -> '.$post_title;foreach($json_data['meta_fields']as $meta_key=>$meta_value){if(is_array($meta_value)){foreach($meta_value as $meta_value_key=>$meta_value_item){if(is_array($meta_value_item)){foreach($meta_value_item as $meta_value_item_key=>$meta_value_item_val){if($this->is_url_image($meta_value_item_val)||'video'==$meta_value_item_key){$file_id=$this->upload_image($meta_value_item_val,$new_page_id,true);if($file_id){$meta_value[$meta_value_key][$meta_value_item_key]=$file_id;}}}}}}else{if($this->is_url_image($meta_value)){$img_id=$this->upload_image($meta_value,$new_page_id,true);if($img_id){$meta_value=$img_id;}}}update_post_meta($new_page_id,$meta_key,$meta_value);}}else{echo 'Error: wescle_import_page';}}}@unlink($import_file);delete_option('wescle_import_file');delete_option('wescle_import_images_url');delete_option('wescle_import_custom_terms');delete_option('wescle_import_custom_posts');}else{echo 'Error: $import_file not exists';}exit;}public function replace_custom_posts_in_content($post_content){$blocks=parse_blocks($post_content);foreach($blocks as $index=>$block){foreach(['aboutImg','aboutImage','previewImage']as $key){if(isset($blocks[$index]['attrs'][$key])&&intval($blocks[$index]['attrs'][$key]['id'])){$img_id=$this->upload_image($blocks[$index]['attrs'][$key]['url'],0,true);if($img_id){$blocks[$index]['attrs'][$key]['id']=$img_id;$blocks[$index]['attrs'][$key]['url']=wp_get_attachment_url($img_id);}}}if(isset($blocks[$index]['attrs']['about'])){$blocks[$index]['attrs']['about']=self::serialize_block_attributes_html($blocks[$index]['attrs']['about']);}if($block['blockName']=='wescle-blocks/services'||$block['blockName']=='wescle-blocks/additional-services'){if($block['blockName']=='wescle-blocks/services'){set_theme_mod('home_services_enabled',true);}if($block['blockName']=='wescle-blocks/additional-services'){set_theme_mod('home_services_slider',true);}if(!isset($blocks[$index]['attrs']['services'])){continue;}foreach($blocks[$index]['attrs']['services']as $key=>$item){$posts=get_posts(['post_type'=>'service','post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['serviceId'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs']['services'][$key]['serviceId']=$post->ID;$blocks[$index]['attrs']['services'][$key]['service']['id']=$post->ID;$blocks[$index]['attrs']['services'][$key]['service']['image']=wp_get_attachment_url(get_post_thumbnail_id($post));$blocks[$index]['attrs']['services'][$key]['service']['icon']=wp_get_attachment_url(get_post_meta($post->ID,'service_icon',1));$blocks[$index]['attrs']['services'][$key]['service']['post_url']=get_permalink($post->ID);}}}if($block['blockName']=='wescle-blocks/products'){$post_type='product_wescle';$taxonomy='productcat_wescle';set_theme_mod('home_prodwescle_enabled',true);foreach(['products','selectedProductsList']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs'][$attrs_key][$key]['id']=$post->ID;$blocks[$index]['attrs'][$attrs_key][$key]['image']=wp_get_attachment_url(get_post_thumbnail_id($post));$blocks[$index]['attrs'][$attrs_key][$key]['post_url']=get_permalink($post->ID);}}}if(isset($blocks[$index]['attrs']['selectedCategories'])){foreach($blocks[$index]['attrs']['selectedCategories']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['selectedCategories'][$key]['id']=$term->term_id;$post_ids=get_posts(['post_type'=>$post_type,'post_status'=>'publish','posts_per_page'=>20,'term_query'=>[['taxonomy'=>$taxonomy,'value'=>[$term->term_id],]],'fields'=>'ids']);$blocks[$index]['attrs']['selectedCategories'][$key]['items']=$post_ids;}}}}if(in_array($block['blockName'],['wescle-blocks/contact-us','wescle-blocks/time-left','wescle-blocks/team3','wescle-blocks/licenses'])){$attrs_key_form='form';if($block['blockName']==='wescle-blocks/licenses'){$attrs_key_form='selectedForm';}if(isset($blocks[$index]['attrs'][$attrs_key_form])){$blocks[$index]['attrs']['formHtml']='';$cf_id=$blocks[$index]['attrs'][$attrs_key_form];$cf_id_key='';$installed_forms=get_option(THEME_SLUG.'_installed_forms',[]);$json_data=$this->get_import_file_data();if(is_array($json_data)&&isset($json_data['cf7_forms'])){foreach($json_data['cf7_forms']as $key_form=>$id_form){if($id_form==$cf_id){$cf_id_key=$key_form;break;}}}if(isset($installed_forms[$cf_id_key])){$blocks[$index]['attrs'][$attrs_key_form]=(string) $installed_forms[$cf_id_key];if($block['blockName']!=='wescle-blocks/team3'){$blocks[$index]['attrs']['formHtml']=self::serialize_block_attributes_html(do_shortcode('[contact-form-7 id="'.$installed_forms[$cf_id_key].'"]'));}}else{unset($blocks[$index]['attrs'][$attrs_key_form]);unset($blocks[$index]['attrs']['formHtml']);}}}if($block['blockName']=='wescle-blocks/work-performed'){set_theme_mod('home_portfolio_enabled',true);if(!isset($blocks[$index]['attrs']['services'])){continue;}foreach($blocks[$index]['attrs']['services']as $key=>$item){$posts=get_posts(['post_type'=>'portfolio_wescle','post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['serviceId'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs']['services'][$key]['serviceId']=$post->ID;$blocks[$index]['attrs']['services'][$key]['service']['id']=$post->ID;$blocks[$index]['attrs']['services'][$key]['service']['image']=wp_get_attachment_url(get_post_thumbnail_id($post));$blocks[$index]['attrs']['services'][$key]['service']['post_url']=get_permalink($post->ID);}}}if($block['blockName']=='wescle-blocks/events'){$post_type='event_wescle';set_theme_mod('home_events_enabled',true);if(isset($blocks[$index]['attrs']['events'])){foreach(['events','selectedEventsList']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs'][$attrs_key][$key]['id']=$post->ID;$blocks[$index]['attrs'][$attrs_key][$key]['image']=wp_get_attachment_url(get_post_thumbnail_id($post));$blocks[$index]['attrs'][$attrs_key][$key]['post_url']=get_permalink($post->ID);}}}}}if($block['blockName']=='wescle-blocks/our-works'){$post_type='gallery_wescle';$taxonomy='gallerycat_wescle';set_theme_mod('home_gallery_enabled',true);if(isset($blocks[$index]['attrs']['posts'])){if(isset($blocks[$index]['attrs']['services'])){foreach($blocks[$index]['attrs']['services']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item['serviceId'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['services'][$key]['serviceId']=$term->term_id;$blocks[$index]['attrs']['services'][$key]['service']['id']=$term->term_id;}}}foreach($blocks[$index]['attrs']['posts']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$categories=[];if($cats=get_the_terms($post,$taxonomy)){$categories=wp_list_pluck($cats,'term_id');}$blocks[$index]['attrs']['posts'][$key]['id']=$post->ID;$blocks[$index]['attrs']['posts'][$key]['image']=wp_get_attachment_url(get_post_thumbnail_id($post));$blocks[$index]['attrs']['posts'][$key]['post_url']=get_permalink($post->ID);$blocks[$index]['attrs']['posts'][$key]['categories']=$categories;}}}}if($block['blockName']=='wescle-blocks/packages-include'){$post_type='pricepackage_wescle';$post_type_option='optionpackage_wescle';set_theme_mod('home_price_table_enabled',true);if(isset($blocks[$index]['attrs']['packages'])){if(isset($blocks[$index]['attrs']['options'])){foreach($blocks[$index]['attrs']['options']as $key=>$item){$posts=get_posts(['post_type'=>$post_type_option,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs']['options'][$key]['id']=$post->ID;$blocks[$index]['attrs']['options'][$key]['price_package_ids']=get_post_meta($post->ID,'price_package_ids',1);}}}foreach(['packages','selectedPackagesLists']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs'][$attrs_key][$key]['id']=$post->ID;}}}}}if($block['blockName']=='wescle-blocks/schedule-block'){$post_type='program_wescle';$post_type_speaker='speaker_program';$speaker_data=[];set_theme_mod('home_programs_enabled',true);if(isset($blocks[$index]['attrs']['programs'])){if(isset($blocks[$index]['attrs']['speakers'])){foreach($blocks[$index]['attrs']['speakers']as $key=>$item){$posts=get_posts(['post_type'=>$post_type_speaker,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$speaker_data[$item['id']]=(string) $post->ID;$blocks[$index]['attrs']['speakers'][$key]['id']=$post->ID;$blocks[$index]['attrs']['speakers'][$key]['image']=wp_get_attachment_url(get_post_thumbnail_id($post));$blocks[$index]['attrs']['speakers'][$key]['post_url']=get_permalink($post->ID);}}}foreach(['programs','selectedProgramsLists']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs'][$attrs_key][$key]['id']=$post->ID;$blocks[$index]['attrs'][$attrs_key][$key]['speaker_id']=$speaker_data[$item['speaker_id']];}}}}}if($block['blockName']=='wescle-blocks/reviews'){$post_type='review';set_theme_mod('home_reviews_enabled',true);if(isset($blocks[$index]['attrs']['reviews'])){foreach(['reviews','selectedReviewsList']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs'][$attrs_key][$key]['id']=$post->ID;$blocks[$index]['attrs'][$attrs_key][$key]['post_url']=get_permalink($post);$blocks[$index]['attrs'][$attrs_key][$key]['thumbnail_video']=(string) get_post_meta($post->ID,'thumbnail_video',1);}}}}}if($block['blockName']=='wescle-blocks/price-list'){$post_type='price_wescle';set_theme_mod('home_price_list_enabled',true);foreach(['prices','selectedPrices']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs'][$attrs_key][$key]['id']=$post->ID;$blocks[$index]['attrs'][$attrs_key][$key]['post_url']=get_permalink($post);}}}}if($block['blockName']=='wescle-blocks/instruction'){$post_type='faq_wescle';$taxonomy='faqcat_wescle';set_theme_mod('home_faq2_enabled',true);if(isset($blocks[$index]['attrs']['posts'])){if(isset($blocks[$index]['attrs']['services'])){foreach($blocks[$index]['attrs']['services']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item['serviceId'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['services'][$key]['serviceId']=$term->term_id;$blocks[$index]['attrs']['services'][$key]['service']['id']=$term->term_id;}}}if(isset($blocks[$index]['attrs']['categories'])){foreach($blocks[$index]['attrs']['categories']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item['serviceId'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['categories'][$key]['id']=$term->term_id;}else{}}}foreach($blocks[$index]['attrs']['posts']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$categories=[];if($cats=get_the_terms($post,$taxonomy)){$categories=wp_list_pluck($cats,'term_id');}$blocks[$index]['attrs']['posts'][$key]['id']=$post->ID;$blocks[$index]['attrs']['posts'][$key]['post_url']=get_permalink($post->ID);$blocks[$index]['attrs']['posts'][$key]['categories']=$categories;}}}}if($block['blockName']=='wescle-blocks/stories'){set_theme_mod('home_stories_enabled',true);}if($block['blockName']=='wescle-blocks/faq'){set_theme_mod('home_faq_enabled',true);}if(in_array($block['blockName'],['wescle-blocks/videos-slider','wescle-blocks/videos-section','wescle-blocks/videos-max'])){$post_type='video_wescle';if($block['blockName']=='wescle-blocks/videos-slider'){set_theme_mod('home_videos_enabled',true);}if($block['blockName']=='wescle-blocks/videos-section'){set_theme_mod('home_videos2_enabled',true);}if($block['blockName']=='wescle-blocks/videos-max'){set_theme_mod('home_videos_max_enabled',true);}if(isset($blocks[$index]['attrs']['options'])){foreach($blocks[$index]['attrs']['options']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);if($post->post_excerpt){$text=$post->post_excerpt;}else{$text=wp_strip_all_tags($post->post_content);}$text=Helper::short_string($text,150);$blocks[$index]['attrs']['options'][$key]['id']=$post->ID;$blocks[$index]['attrs']['options'][$key]['value']=$post->ID;$blocks[$index]['attrs']['options'][$key]['post_url']=get_permalink($post);$blocks[$index]['attrs']['options'][$key]['post_thumb']=self::serialize_block_attributes_html(get_the_post_thumbnail($post->ID,'medium_large'));$blocks[$index]['attrs']['options'][$key]['text']=self::serialize_block_attributes_html($text);}}}if(isset($blocks[$index]['attrs']['items'])){foreach($blocks[$index]['attrs']['items']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['video']['id'],]],]);if($posts){$post=current($posts);if($post->post_excerpt){$text=$post->post_excerpt;}else{$text=wp_strip_all_tags($post->post_content);}$text=Helper::short_string($text,150);$blocks[$index]['attrs']['items'][$key]['video']['id']=$post->ID;$blocks[$index]['attrs']['items'][$key]['video']['value']=$post->ID;$blocks[$index]['attrs']['items'][$key]['video']['post_url']=get_permalink($post);$blocks[$index]['attrs']['items'][$key]['video']['post_thumb']=self::serialize_block_attributes_html(get_the_post_thumbnail($post->ID,'medium_large'));$blocks[$index]['attrs']['items'][$key]['video']['text']=self::serialize_block_attributes_html($text);}}}}if($block['blockName']=='wescle-blocks/highlight-tabs'){$post_type='tab_wescle';set_theme_mod('home_tabs_object_enabled',true);if(isset($blocks[$index]['attrs']['options'])){foreach($blocks[$index]['attrs']['options']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs']['options'][$key]['id']=$post->ID;$blocks[$index]['attrs']['options'][$key]['value']=$post->ID;}}}if(isset($blocks[$index]['attrs']['items'])){foreach($blocks[$index]['attrs']['items']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['tab']['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs']['items'][$key]['tab']['id']=$post->ID;$blocks[$index]['attrs']['items'][$key]['tab']['value']=$post->ID;}}}}if(in_array($block['blockName'],['wescle-blocks/services2','wescle-blocks/goods-banners','wescle-blocks/team2','wescle-blocks/how-we-working2','wescle-blocks/payment-methods'])){foreach(['services','items']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){if(isset($item['image'])&&intval($item['image']['id'])){$img_id=$this->upload_image($item['image']['url'],0,true);if($img_id){$blocks[$index]['attrs'][$attrs_key][$key]['image']['id']=$img_id;}}if(isset($item['bgImage'])&&intval($item['bgImage']['id'])){$img_id=$this->upload_image($item['bgImage']['url'],0,true);if($img_id){$blocks[$index]['attrs'][$attrs_key][$key]['bgImage']['id']=$img_id;}}}}}if($block['blockName']=='wescle-blocks/team3'){$post_type='team_wescle';set_theme_mod('home_team_cpt_enabled',true);if(isset($blocks[$index]['attrs']['selectedPeoples'])){foreach($blocks[$index]['attrs']['selectedPeoples']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs']['selectedPeoples'][$key]['id']=$post->ID;}}}}if($block['blockName']=='wescle-blocks/reviews-2'){$post_type='videoreview';set_theme_mod('home_videoreviews_enabled',true);foreach(['reviews','selectedReviewsList']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs'][$attrs_key][$key]['id']=$post->ID;}}}}if($block['blockName']=='wescle-blocks/licenses'){$post_type='license_wescle';$taxonomy='licensecat_wescle';set_theme_mod('home_licenses_enabled',true);foreach(['reviews','selectedReviewsList']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$categories=[];if($cats=get_the_terms($post,$taxonomy)){$categories=wp_list_pluck($cats,'term_id');}$blocks[$index]['attrs'][$attrs_key][$key]['id']=$post->ID;$blocks[$index]['attrs'][$attrs_key][$key]['categories']=$categories;$blocks[$index]['attrs'][$attrs_key][$key]['related_product_id']=0;}}}if(isset($blocks[$index]['attrs']['categories'])){foreach($blocks[$index]['attrs']['categories']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['categories'][$key]['id']=$term->term_id;}else{}}}}if($block['blockName']=='wescle-blocks/partners'){$post_type='partner_wescle';set_theme_mod('home_partners2_enabled',true);foreach(['partners','selectedPartnersList']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs'][$attrs_key][$key]['id']=$post->ID;}}}}if($block['blockName']=='wescle-blocks/blocks-posts'){$post_type='post';$taxonomy='category';$user_data_arr=[];if(isset($blocks[$index]['attrs']['items'])){if(isset($blocks[$index]['attrs']['initialCategories'])){foreach($blocks[$index]['attrs']['initialCategories']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['initialCategories'][$key]['id']=$term->term_id;$blocks[$index]['attrs']['initialCategories'][$key]['url']='';}else{}}}foreach($blocks[$index]['attrs']['initialPosts']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$categories=[];if($cats=get_the_terms($post,$taxonomy)){$categories=wp_list_pluck($cats,'term_id');}if(!isset($user_data_arr[$post->post_author])){$user=get_user_by('id',$post->post_author);$user->posts_url=get_author_posts_url($user->ID);$user->url=$user->posts_url;$user->avatar=get_avatar_url($user->ID);$user_data_arr[$post->post_author]=$user->data;$user_data=$user->data;}else{$user_data=$user_data_arr[$post->post_author];}$blocks[$index]['attrs']['initialPosts'][$key]['id']=$post->ID;$blocks[$index]['attrs']['initialPosts'][$key]['post_url']=get_permalink($post->ID);$blocks[$index]['attrs']['initialPosts'][$key]['categories']=$categories;$blocks[$index]['attrs']['initialPosts'][$key]['user']=$user_data;$blocks[$index]['attrs']['initialPosts'][$key]['comment_count']=0;$blocks[$index]['attrs']['initialPosts'][$key]['views_count']=0;}else{}}foreach($block['attrs']['items']as $item_block_key=>$item_block){if(isset($item_block['postLink']['id'])&&$item_block['postLink']['id']){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item_block['postLink']['id'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['items'][$item_block_key]['postLink']['id']=$term->term_id;$blocks[$index]['attrs']['items'][$item_block_key]['postLink']['value']=$term->term_id;$blocks[$index]['attrs']['items'][$item_block_key]['postLink']['url']='';}else{unset($blocks[$index]['attrs']['items'][$item_block_key]['postLink']['id']);unset($blocks[$index]['attrs']['items'][$item_block_key]['postLink']['value']);}}foreach(['articles','initialPosts']as $attrs_key){foreach($item_block[$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$categories=[];if($cats=get_the_terms($post,$taxonomy)){$categories=wp_list_pluck($cats,'term_id');}if(!$user_data_arr[$post->post_author]){$user=get_user_by('id',$post->post_author);$user->posts_url=get_author_posts_url($user->ID);$user->url=$user->posts_url;$user->avatar=get_avatar_url($user->ID);$user_data_arr[$post->post_author]=$user->data;$user_data=$user->data;}else{$user_data=$user_data_arr[$post->post_author];}$blocks[$index]['attrs']['items'][$item_block_key][$attrs_key][$key]['value']=$post->ID;$blocks[$index]['attrs']['items'][$item_block_key][$attrs_key][$key]['id']=$post->ID;$blocks[$index]['attrs']['items'][$item_block_key][$attrs_key][$key]['post_url']=get_permalink($post->ID);$blocks[$index]['attrs']['items'][$item_block_key][$attrs_key][$key]['categories']=$categories;$blocks[$index]['attrs']['items'][$item_block_key][$attrs_key][$key]['user']=$user_data;$blocks[$index]['attrs']['items'][$item_block_key][$attrs_key][$key]['comment_count']=0;$blocks[$index]['attrs']['items'][$item_block_key][$attrs_key][$key]['views_count']=0;}else{}}}foreach($item_block['categories']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['items'][$item_block_key]['categories'][$key]['id']=$term->term_id;$blocks[$index]['attrs']['items'][$item_block_key]['categories'][$key]['value']=$term->term_id;$blocks[$index]['attrs']['items'][$item_block_key]['categories'][$key]['url']='';}else{unset($blocks[$index]['attrs']['items'][$item_block_key]['categories'][$key]);}}}}}if(in_array($block['blockName'],['wescle-blocks/wescle-catalog-advantages','wescle-blocks/wescle-catalog-options'])){$post_type='info_catalog';set_theme_mod('module_catalog_enabled',true);foreach(['blocks','selectedBlocks']as $attrs_key){if(!isset($blocks[$index]['attrs'][$attrs_key])){continue;}foreach($blocks[$index]['attrs'][$attrs_key]as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs'][$attrs_key][$key]['id']=$post->ID;$blocks[$index]['attrs'][$attrs_key][$key]['value']=$post->ID;$blocks[$index]['attrs'][$attrs_key][$key]['image']=wp_get_attachment_url(get_post_meta($post->ID,'icon_id',1));}}}}if($block['blockName']=='wescle-blocks/wescle-catalog'){$post_type='catalog_item';$taxonomy='catalogcat_wescle';set_theme_mod('module_catalog_enabled',true);unset($blocks[$index]['attrs']['pages']);foreach($blocks[$index]['attrs']['services']as $key=>$item){if($item['arrayProductsByID']){$ids=[];foreach($item['arrayProductsByID']as $key_item_product=>$item_product){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item_product['id'],]],]);if($posts){$post=current($posts);$categories=[];if($cats=get_the_terms($post,$taxonomy)){$categories=wp_list_pluck($cats,'term_id');}$ids[]=$post->ID;$blocks[$index]['attrs']['services'][$key]['arrayProductsByID'][$key_item_product]['id']=$post->ID;$blocks[$index]['attrs']['services'][$key]['arrayProductsByID'][$key_item_product]['post_url']=get_permalink($post->ID);$blocks[$index]['attrs']['services'][$key]['arrayProductsByID'][$key_item_product]['categories']=$categories;}}$blocks[$index]['attrs']['services'][$key]['productsByID']=implode(',',$ids);}elseif($item['arrayProductsByCategories']){foreach($item['productsByCategories']as $key_item_product=>$item_product){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item_product['id'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['services'][$key]['productsByCategories'][$key_item_product]['id']=$term->term_id;}}foreach($item['arrayProductsByCategories']as $key_item_product=>$item_product){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item_product['id'],]],]);if($posts){$post=current($posts);$categories=[];if($cats=get_the_terms($post,$taxonomy)){$categories=wp_list_pluck($cats,'term_id');}$ids[]=$post->ID;$blocks[$index]['attrs']['services'][$key]['arrayProductsByCategories'][$key_item_product]['id']=$post->ID;$blocks[$index]['attrs']['services'][$key]['arrayProductsByCategories'][$key_item_product]['post_url']=get_permalink($post->ID);$blocks[$index]['attrs']['services'][$key]['arrayProductsByCategories'][$key_item_product]['categories']=$categories;}}}}if(isset($blocks[$index]['attrs']['categories'])){foreach($blocks[$index]['attrs']['categories']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['categories'][$key]['id']=$term->term_id;}}}foreach($blocks[$index]['attrs']['products']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$categories=[];if($cats=get_the_terms($post,$taxonomy)){$categories=wp_list_pluck($cats,'term_id');}$blocks[$index]['attrs']['posts'][$key]['id']=$post->ID;$blocks[$index]['attrs']['posts'][$key]['post_url']=get_permalink($post->ID);$blocks[$index]['attrs']['posts'][$key]['categories']=$categories;}}}if($block['blockName']=='wescle-blocks/mosaic-tile'){$post_type='mosaic_wescle';$taxonomy='mosaiccat_wescle';set_theme_mod('home_mosaic_enabled',true);if(isset($blocks[$index]['attrs']['blocks'])){if(isset($blocks[$index]['attrs']['services'])){foreach($blocks[$index]['attrs']['services']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item['tabId'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['services'][$key]['tabId']=$term->term_id;$blocks[$index]['attrs']['services'][$key]['category']['id']=$term->term_id;}}}foreach($blocks[$index]['attrs']['blocks']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$categories=[];if($cats=get_the_terms($post,$taxonomy)){$categories=wp_list_pluck($cats,'term_id');}$blocks[$index]['attrs']['posts'][$key]['id']=$post->ID;$blocks[$index]['attrs']['posts'][$key]['image']=wp_get_attachment_url(get_post_thumbnail_id($post));$blocks[$index]['attrs']['posts'][$key]['categories']=$categories;}}}}if($block['blockName']=='wescle-blocks/info-tabs'){$post_type='infotab_wescle';set_theme_mod('home_infotabs_enabled',true);if(isset($blocks[$index]['attrs']['options'])){foreach($blocks[$index]['attrs']['options']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs']['options'][$key]['id']=$post->ID;$blocks[$index]['attrs']['options'][$key]['value']=$post->ID;}}}if(isset($blocks[$index]['attrs']['items'])){foreach($blocks[$index]['attrs']['items']as $key=>$item){$posts=get_posts(['post_type'=>$post_type,'post_status'=>['publish','draft','pending','private'],'posts_per_page'=>1,'meta_query'=>[['key'=>'import_id','value'=>$item['tab']['id'],]],]);if($posts){$post=current($posts);$blocks[$index]['attrs']['items'][$key]['tab']['id']=$post->ID;$blocks[$index]['attrs']['items'][$key]['tab']['value']=$post->ID;}}}}if($block['blockName']=='wescle-blocks/wescle-categories'){$taxonomy=$blocks[$index]['attrs']['selectedTaxonomy']?? '';if($taxonomy==='catalogcat_wescle'){set_theme_mod('module_catalog_enabled',true);}if(isset($blocks[$index]['attrs']['arrCategoriesByID'])&&$blocks[$index]['attrs']['arrCategoriesByID']){$ids=[];foreach($blocks[$index]['attrs']['arrCategoriesByID']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'hide_empty'=>false,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['arrCategoriesByID'][$key]['id']=$term->term_id;$blocks[$index]['attrs']['arrCategoriesByID'][$key]['item']['id']=$term->term_id;$ids[]=$term->term_id;}}$blocks[$index]['attrs']['categoriesByID']=implode(',',$ids);}if(isset($blocks[$index]['attrs']['categories'])){foreach($blocks[$index]['attrs']['categories']as $key=>$item){$terms=get_terms(['taxonomy'=>$taxonomy,'meta_query'=>[['key'=>'import_id','value'=>$item['id'],]],]);if($terms){$term=current($terms);$blocks[$index]['attrs']['categories'][$key]['id']=$term->term_id;$blocks[$index]['attrs']['categories'][$key]['item']['id']=$term->term_id;}}}}}$post_content=serialize_blocks($blocks);return $post_content;}static function serialize_block_attributes_html($html){$html=str_replace("\t",' ',$html);$html=str_replace("\n",'\\n',$html);$html=str_replace("\r",'',$html);while(stristr($html,'  ')){$html=str_replace('  ',' ',$html);}$encoded_attributes=$html;$encoded_attributes=preg_replace('/--/','\\u002d\\u002d',$encoded_attributes);$encoded_attributes=preg_replace('/</','\\u003c',$encoded_attributes);$encoded_attributes=preg_replace('/>/','\\u003e',$encoded_attributes);$encoded_attributes=preg_replace('/&/','\\u0026',$encoded_attributes);$encoded_attributes=preg_replace('/\\\\"/','\\u0022',$encoded_attributes);$encoded_attributes=str_replace('"','\\u0022',$encoded_attributes);return $encoded_attributes;}}new WsclExportImport();