<?php class WsclAdminFilters{protected $post_type='catalog_item';private static $edited_id;private static $chosen_filters;private static $filter_query;private $result=false;private $action='';public function __construct(){add_action('admin_init',array($this,'add_table_db'),1);add_action('init',array($this,'save_filter'),2);add_action('init',array($this,'register_filter_taxonomies'),5);add_action('pre_get_posts',array($this,'pre_get_posts'),5);add_action('admin_menu',array($this,'add_admin_menu'));add_filter('taxonomies_with_metabox',array($this,'filter_with_metabox'));add_filter('wescle_taxes_order',array($this,'filter_with_sorting'));}public function add_admin_menu(){add_submenu_page('edit.php?post_type='.$this->post_type,__('Фильтры','wescle'),__('Фильтры','wescle'),'manage_options','wescle_filters',array($this,'page_template'));}public function add_table_db(){global $pagenow;if($pagenow&&'edit.php'==$pagenow&&isset($_GET['page'])&&'wescle_filters'==$_GET['page']){self::create_tables();}}public function save_filter(){if(!empty($_POST['add_new_filter'])){$this->action='add';}elseif(!empty($_POST['save_filter'])&&!empty($_GET['edit'])){$this->action='edit';}elseif(!empty($_GET['delete'])){$this->action='delete';}switch($this->action){case 'add':$this->result=$this->process_add_filter();break;case 'edit':$this->result=$this->process_edit_filter();break;case 'delete':$this->result=$this->process_delete_filter();break;}}public function page_template(){if($this->action){flush_rewrite_rules(false);}if(is_wp_error($this->result)){echo '<div id="wescle_errors" class="error"><p>'.wp_kses_post($this->result->get_error_message()).'</p></div>';}if(!empty($_GET['edit'])){$this->edit_filter();}else{$this->add_filter();}}private static function get_posted_filter(){$filter=array('filter_label'=>isset($_POST['filter_label'])?sanitize_text_field(wp_unslash($_POST['filter_label'])):'','filter_name'=>isset($_POST['filter_name'])?urldecode(sanitize_title(urldecode(wp_unslash($_POST['filter_name'])))):'','filter_orderby'=>isset($_POST['filter_orderby'])?sanitize_text_field(wp_unslash($_POST['filter_orderby'])):'','filter_public'=>isset($_POST['filter_public'])?1:0,);if(empty($filter['filter_label'])){$filter['filter_label']=ucfirst($filter['filter_name']);}if(empty($filter['filter_name'])){$filter['filter_name']=urldecode(sanitize_title(urldecode($filter['filter_label'])));}return $filter;}private function process_add_filter(){check_admin_referer('wescle-add-new_filter');$filter=self::get_posted_filter();$args=array('name'=>$filter['filter_label'],'slug'=>$filter['filter_name'],'order_by'=>$filter['filter_orderby'],'has_archives'=>$filter['filter_public'],'post_type'=>$this->post_type,);$id=self::create_filter($args);if(is_wp_error($id)){return $id;}return true;}private function process_edit_filter(){$id=isset($_GET['edit'])?absint($_GET['edit']):0;check_admin_referer('wescle-save-filter_'.$id);$filter=self::get_posted_filter();$args=array('name'=>$filter['filter_label'],'slug'=>$filter['filter_name'],'order_by'=>$filter['filter_orderby'],'has_archives'=>$filter['filter_public'],'post_type'=>$this->post_type,);$id=self::update_filter($id,$args);if(is_wp_error($id)){return $id;}self::$edited_id=$id;return true;}private static function update_filter($id,$args){global $wpdb;$filter=self::get_filter_data($id);$args['id']=$filter?$filter->id:0;if($args['id']&&empty($args['name'])){$args['name']=$filter->name;}$args['old_slug']=$wpdb->get_var($wpdb->prepare("
				SELECT filter_name
				FROM {$wpdb->prefix}wescle_filter_taxonomies
				WHERE id = %d
			",$args['id']));return self::create_filter($args);}private static function get_filter_data($id){$filters=self::get_filter_taxonomies();if(!isset($filters['id:'.$id])){return null;}$data=$filters['id:'.$id];$filter=new stdClass();$filter->id=(int) $data->id;$filter->name=$data->filter_label;$filter->slug=self::filter_taxonomy_name($data->filter_name);$filter->order_by=$data->filter_orderby;$filter->has_archives=(bool) $data->filter_public;return $filter;}private function process_delete_filter(){$id=isset($_GET['delete'])?absint($_GET['delete']):0;check_admin_referer('wescle-delete-filter_'.$id);return self::delete_filter($id);}private static function delete_filter($id){global $wpdb;$name=$wpdb->get_var($wpdb->prepare("
			SELECT filter_name
			FROM {$wpdb->prefix}wescle_filter_taxonomies
			WHERE id = %d
			",$id));$taxonomy=self::filter_taxonomy_name($name);do_action('wescle_before_filter_delete',$id,$name,$taxonomy);if($name&&$wpdb->query($wpdb->prepare("DELETE FROM {$wpdb->prefix}wescle_filter_taxonomies WHERE id = %d",$id))){if(taxonomy_exists($taxonomy)){$terms=get_terms(['taxonomy'=>$taxonomy,'hide_empty'=>false]);foreach($terms as $term){wp_delete_term($term->term_id,$taxonomy);}delete_transient('wescle_filter_nav_counts_'.$taxonomy);}delete_transient('wescle_filter_taxonomies');wp_cache_delete('wescle_filters');return true;}return false;}public function edit_filter(){global $wpdb;$edit=isset($_GET['edit'])?absint($_GET['edit']):0;$filter_to_edit=$wpdb->get_row($wpdb->prepare("
				SELECT filter_label, filter_name, filter_orderby, filter_public, filter_post_type
				FROM {$wpdb->prefix}wescle_filter_taxonomies WHERE id = %d
				",$edit)); ?>
        <div class="wrap wescle">
            <h1><?php esc_html_e('Изменить фильтр','wescle'); ?></h1>

			<?php if(!$filter_to_edit){echo '<div id="wescle_errors" class="error"><p>'.esc_html__('Ошибка: фильтр не найден','wescle').'</p></div>';}else{$att_label=format_to_edit($filter_to_edit->filter_label);$att_name=$filter_to_edit->filter_name;$att_orderby=$filter_to_edit->filter_orderby;$att_public=$filter_to_edit->filter_public;$post_type=$filter_to_edit->filter_post_type;if(self::$edited_id>0){echo '<div id="message" class="updated"><p>'.esc_html__('Фильтр успешно обновлен','wescle').'</p><p><a href="'.esc_url(admin_url('edit.php?post_type='.$post_type.'&amp;page=wescle_filters')).'">'.esc_html__('Вернуться назад','wescle').'</a></p></div>';self::$edited_id=null;} ?>
                <form action="edit.php?post_type=<?php echo $post_type; ?>&amp;page=wescle_filters&amp;edit=<?php echo absint($edit); ?>" method="post">
                    <table class="form-table">
                        <tbody>
						<?php do_action('wescle_before_edit_filter_fields'); ?>
                        <tr class="form-field form-required">
                            <th scope="row" valign="top">
                                <label for="filter_label"><?php esc_html_e('Имя','wescle'); ?></label>
                            </th>
                            <td>
                                <input name="filter_label" id="filter_label" type="text" value="<?php echo esc_attr($att_label); ?>"/>
                                <p class="description"><?php esc_html_e('Название фильтра (отображается во фронтенде)','wescle'); ?></p>
                            </td>
                        </tr>
                        <tr class="form-field form-required">
                            <th scope="row" valign="top">
                                <label for="filter_name"><?php esc_html_e('Ярлык','wescle'); ?></label>
                            </th>
                            <td>
                                <input name="filter_name" id="filter_name" type="text" value="<?php echo esc_attr($att_name); ?>" maxlength="28"/>
                                <p class="description"><?php esc_html_e('Уникальный ярлык/ссылка фильтра','wescle'); ?></p>
                            </td>
                        </tr>
                        <tr class="form-field form-required">
                            <th scope="row" valign="top">
                                <label for="filter_public"><?php esc_html_e('Включить архивы?','wescle'); ?></label>
                            </th>
                            <td>
                                <input name="filter_public" id="filter_public" type="checkbox" value="1" <?php checked($att_public,1); ?> />
                                <p class="description"><?php esc_html_e('Фильтр становится ссылкой и его можно просматривать во фронтенде','wescle'); ?></p>
                            </td>
                        </tr>
                        <tr class="form-field form-required">
                            <th scope="row" valign="top">
                                <label for="filter_orderby"><?php esc_html_e('Порядок сортировки','wescle'); ?></label>
                            </th>
                            <td>
                                <select name="filter_orderby" id="filter_orderby">
                                    <option value="name" <?php selected($att_orderby,'name'); ?>><?php esc_html_e('Имя','wescle'); ?></option>
                                    <option value="name_num" <?php selected($att_orderby,'name_num'); ?>><?php esc_html_e('Имя (как число)','wescle'); ?></option>
                                    <option value="id" <?php selected($att_orderby,'id'); ?>><?php echo 'ID'; ?></option>
                                    <option value="count" <?php selected($att_orderby,'count'); ?>><?php esc_html_e('Количество записей','wescle'); ?></option>
                                    <option value="term_order" <?php selected($att_orderby,'term_order'); ?>><?php esc_html_e('Вручную','wescle'); ?></option>
                                </select>
                            </td>
                        </tr>
						<?php do_action('wescle_after_edit_filter_fields'); ?>
                        </tbody>
                    </table>
                    <p class="submit">
                        <button type="submit" name="save_filter" id="submit" class="button-primary" value="<?php esc_attr_e('Обновить','wescle'); ?>"><?php esc_html_e('Обновить','wescle'); ?></button>
                    </p>
	                <?php wp_nonce_field('wescle-save-filter_'.$edit); ?>
                </form>
			<?php } ?>
        </div>
		<?php }public function add_filter(){ ?>
        <div class="wrap wescle">
            <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
			<?php if(self::$edited_id>0){echo '<div id="message" class="updated"><p>'.esc_html__('Фильтр успешно добавлен','wescle').'</p></div>';self::$edited_id=null;} ?>
            <br class="clear"/>
            <div id="col-container">
                <div id="col-right">
                    <div class="col-wrap">
                        <table class="widefat filters-table wp-list-table ui-sortable" style="width:100%">
                            <thead>
                            <tr>
                                <th scope="col"><?php esc_html_e('Имя','wescle'); ?></th>
                                <th scope="col"><?php esc_html_e('Ярлык','wescle'); ?></th>
                                <th scope="col"><?php esc_html_e('Архив','wescle'); ?></th>
                                <th scope="col"><?php esc_html_e('Сортировка по','wescle'); ?></th>
                                <th scope="col"><?php esc_html_e('Значения','wescle'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
					        <?php $filter_taxonomies=self::get_filter_taxonomies();if($filter_taxonomies):foreach($filter_taxonomies as $tax): ?>
                                    <tr>
                                        <td>
                                            <strong><a href="edit-tags.php?taxonomy=<?php echo esc_attr(self::filter_taxonomy_name($tax->filter_name)); ?>&amp;post_type=<?php echo $tax->filter_post_type; ?>"><?php echo esc_html($tax->filter_label); ?></a></strong>

                                            <div class="row-actions">
                                                <span class="edit"><a href="<?php echo esc_url(add_query_arg('edit',$tax->id,'edit.php?post_type='.$tax->filter_post_type.'&amp;page=wescle_filters')); ?>"><?php esc_html_e('Изменить','wescle'); ?></a> | </span>
                                                <span class="delete"><a class="delete" href="<?php echo esc_url(wp_nonce_url(add_query_arg('delete',$tax->id,'edit.php?post_type='.$tax->filter_post_type.'&amp;page=wescle_filters'),'wescle-delete-filter_'.$tax->id)); ?>"><?php esc_html_e('Удалить','wescle'); ?></a></span>
                                            </div>
                                        </td>
                                        <td><?php echo esc_html($tax->filter_name); ?></td>
                                        <td><?php echo $tax->filter_public?'<span class="dashicons dashicons-yes"></span>':'<span class="dashicons dashicons-no-alt"></span>'; ?></td>
                                        <td>
									        <?php switch($tax->filter_orderby){case 'name':esc_html_e('Имя','wescle');break;case 'name_num':esc_html_e('Имя (как число)','wescle');break;case 'id':echo 'ID';break;case 'count':esc_html_e('Количество записей','wescle');break;default:esc_html_e('Вручную','wescle');break;} ?>
                                        </td>
                                        <td class="filter-terms">
											<?php $taxonomy=self::filter_taxonomy_name($tax->filter_name);if(taxonomy_exists($taxonomy)){$terms=get_terms(['taxonomy'=>$taxonomy,'hide_empty'=>false,'orderby'=>$tax->filter_orderby,]);$terms_string=implode(', ',wp_list_pluck($terms,'name'));if($terms_string){echo esc_html($terms_string);}else{echo '<span class="na">&ndash;</span>';}}else{echo '<span class="na">&ndash;</span>';} ?>
                                            <br/><a href="edit-tags.php?taxonomy=<?php echo esc_attr(self::filter_taxonomy_name($tax->filter_name)); ?>&amp;post_type=<?php echo $tax->filter_post_type; ?>" class="configure-terms"><?php esc_html_e('Добавить/Удалить значения','wescle'); ?></a>
                                        </td>
                                    </tr>
								<?php endforeach;else: ?>
                                <tr>
                                    <td colspan="6"><?php esc_html_e('Нет фильтров','wescle'); ?></td>
                                </tr>
							<?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div id="col-left">
                    <div class="col-wrap">
                        <div class="form-wrap">
                            <h2><?php esc_html_e('Создать фильтр','wescle'); ?></h2>
                            <form action="edit.php?post_type=<?php echo $this->post_type; ?>&amp;page=wescle_filters" method="post">
								<?php do_action('wescle_before_add_filter_fields'); ?>

                                <div class="form-field">
                                    <label for="filter_label"><?php esc_html_e('Имя','wescle'); ?></label>
                                    <input name="filter_label" id="filter_label" type="text" value=""/>
                                    <p class="description"><?php esc_html_e('Название фильтра (отображается во фронтенде)','wescle'); ?></p>
                                </div>

                                <div class="form-field">
                                    <label for="filter_name"><?php esc_html_e('Ярлык','wescle'); ?></label>
                                    <input name="filter_name" id="filter_name" type="text" value="" maxlength="28"/>
                                    <p class="description"><?php esc_html_e('Уникальный ярлык/ссылка фильтра','wescle'); ?></p>
                                </div>

                                <div class="form-field">
                                    <label for="filter_public"><input name="filter_public" id="filter_public" type="checkbox" value="1"/> <?php esc_html_e('Включить архивы?','wescle'); ?></label>

                                    <p class="description"><?php esc_html_e('Фильтр становится ссылкой и его можно просматривать во фронтенде','wescle'); ?></p>
                                </div>

                                <div class="form-field">
                                    <label for="filter_orderby"><?php esc_html_e('Порядок сортировки','wescle'); ?></label>
                                    <select name="filter_orderby" id="filter_orderby">
                                        <option value="name" selected><?php esc_html_e('Имя','wescle'); ?></option>
                                        <option value="name_num"><?php esc_html_e('Имя (как число)','wescle'); ?></option>
                                        <option value="id">ID</option>
                                        <option value="count"><?php esc_html_e('Количество записей','wescle'); ?></option>
                                        <option value="term_order"><?php esc_html_e('Вручную','wescle'); ?></option>
                                    </select>
                                </div>

                                <p class="submit">
                                    <button type="submit" name="add_new_filter" id="submit" class="button button-primary" value="<?php esc_attr_e('Добавить фильтр','wescle'); ?>"><?php esc_html_e('Добавить фильтр','wescle'); ?></button>
                                </p>
	                            <?php wp_nonce_field('wescle-add-new_filter'); ?>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <script type="text/javascript">
                /* <![CDATA[ */

                jQuery('a.delete').on('click', function () {
                    if (window.confirm('<?php esc_html_e('Вы уверены, что хотите удалить фильтр и все его значения?','wescle'); ?>')) {
                        return true;
                    }
                    return false;
                });

                /* ]]> */
            </script>
        </div>
		<?php }private static function create_filter($args){global $wpdb;$args=wp_unslash($args);$id=!empty($args['id'])?intval($args['id']):0;$format=array('%s','%s','%s','%d','%s');if(empty($args['name'])){return new WP_Error('missing_filter_name',__('Пожалуйста, укажите имя фильтра.','wescle'),array('status'=>400));}if(empty($args['slug'])){$slug=urldecode(sanitize_title(urldecode($args['name'])));}else{$slug=preg_replace('/^filter\_/','',urldecode(sanitize_title(urldecode($args['slug']))));}$utf_array=Helper::get_utf_symbols();$slug=strtr($slug,$utf_array);if(strlen($slug)>28){return new WP_Error('invalid_wescle_filter_slug_too_long',sprintf(__('Ярлык "%s" слишком длинный (максимум 28 символов).','wescle'),$slug),array('status'=>400));}elseif((0===$id&&taxonomy_exists(self::filter_taxonomy_name($slug)))||(isset($args['old_slug'])&&$args['old_slug']!==$slug&&taxonomy_exists(self::filter_taxonomy_name($slug)))){return new WP_Error('invalid_wescle_filter_slug_already_exists',sprintf(__('Ярлык "%s" уже существует.','wescle'),$slug),array('status'=>400));}$data=array('filter_label'=>$args['name'],'filter_name'=>$slug,'filter_orderby'=>$args['order_by'],'filter_public'=>isset($args['has_archives'])?(int) $args['has_archives']:0,'filter_post_type'=>$args['post_type'],);if(0===$id){$results=$wpdb->insert($wpdb->prefix.'wescle_filter_taxonomies',$data,$format);$id=$wpdb->insert_id;if(is_wp_error($results)){return new WP_Error('cannot_create_filter',$results->get_error_message(),array('status'=>400));}}else{$results=$wpdb->update($wpdb->prefix.'wescle_filter_taxonomies',$data,array('id'=>$id),$format,array('%d'));if(false===$results){return new WP_Error('cannot_update_filter',__('Фильтр не обновлен','wescle'),array('status'=>400));}$old_slug=!empty($args['old_slug'])?urldecode(sanitize_title(urldecode($args['old_slug']))):$slug;if($old_slug!==$slug){$wpdb->update($wpdb->term_taxonomy,array('taxonomy'=>self::filter_taxonomy_name($data['filter_name'])),array('taxonomy'=>'filter_'.$old_slug));$wpdb->update($wpdb->termmeta,array('meta_key'=>'order_pa_'.sanitize_title($data['filter_name'])),array('meta_key'=>'order_pa_'.sanitize_title($old_slug)));}}delete_transient('wescle_filter_taxonomies');delete_transient('wescle_filter_nav_counts_'.self::filter_taxonomy_name($data['filter_name']));wp_cache_delete('wescle_filters');self::$edited_id=$id;return $id;}public static function get_filter_taxonomies(){$cache_key='wescle_filters';$cache_value=wp_cache_get($cache_key);if(false!==$cache_value){return $cache_value;}$raw_filter_taxonomies=get_transient('wescle_filter_taxonomies');if(false===$raw_filter_taxonomies){global $wpdb;$raw_filter_taxonomies=$wpdb->get_results("SELECT * FROM {$wpdb->prefix}wescle_filter_taxonomies WHERE filter_name != '' ORDER BY filter_label ASC;");set_transient('wescle_filter_taxonomies',$raw_filter_taxonomies);}$filter_taxonomies=array();foreach($raw_filter_taxonomies as $result){$filter_taxonomies['id:'.$result->id]=$result;}wp_cache_set($cache_key,$filter_taxonomies);return $filter_taxonomies;}public static function filter_taxonomy_name($filter_name){return $filter_name?'filter_'.$filter_name:'';}public static function get_filter_taxs($only_public=true){global $wescle_filters;if(!$wescle_filters){foreach(self::get_filter_taxonomies()as $tax){$wescle_filters[self::filter_taxonomy_name($tax->filter_name)]=$tax;}}$tax_filters=[];if($wescle_filters){foreach($wescle_filters as $taxonomy=>$item){if($only_public){if($item->filter_public){$tax_filters[]=$taxonomy;}}else{$tax_filters[]=$taxonomy;}}}return $tax_filters;}public static function create_tables(){global $wpdb;$table_version='1.0';if(get_option("wescle_filter_table_version")==$table_version){return;}$collate='';if($wpdb->has_cap('collation')){$collate=$wpdb->get_charset_collate();}require_once ABSPATH.'wp-admin/includes/upgrade.php';$sql="
CREATE TABLE {$wpdb->prefix}wescle_filter_taxonomies (
    id BIGINT UNSIGNED NOT NULL auto_increment,
    filter_name varchar(200) NOT NULL,
    filter_label varchar(200) NULL,
    filter_orderby varchar(20) NOT NULL,
    filter_public int(1) NOT NULL DEFAULT 0,
    filter_post_type varchar(32) NOT NULL DEFAULT 'catalog_item',
    PRIMARY KEY (id),
    KEY filter_name (filter_name(20))
) $collate;";dbDelta($sql);update_option('wescle_filter_table_version',$table_version);delete_transient('wescle_filter_taxonomies');}public static function register_filter_taxonomies(){global $wescle_filters;$wescle_filters=array();$filter_taxonomies=self::get_filter_taxonomies();if($filter_taxonomies){foreach($filter_taxonomies as $tax){$name=self::filter_taxonomy_name($tax->filter_name);if($name){$tax->filter_public=absint(isset($tax->filter_public)?$tax->filter_public:1);$label=!empty($tax->filter_label)?$tax->filter_label:$tax->filter_name;$wescle_filters[$name]=$tax;$taxonomy_data=array('hierarchical'=>true,'labels'=>array('name'=>sprintf(__('Фильтр %s','wescle'),$label),'singular_name'=>$label,'search_items'=>sprintf(__('Найти %s','wescle'),$label),'all_items'=>sprintf(__('Все %s','wescle'),$label),'parent_item'=>sprintf(__('Родительский %s','wescle'),$label),'parent_item_colon'=>sprintf(__('Родительский %s:','wescle'),$label),'edit_item'=>sprintf(__('Редактировать %s','wescle'),$label),'update_item'=>sprintf(__('Обновить %s','wescle'),$label),'add_new_item'=>sprintf(__('Добавить %s','wescle'),$label),'new_item_name'=>sprintf(__('Новый %s','wescle'),$label),'not_found'=>sprintf(__('Не найдено','wescle'),$label),),'show_ui'=>true,'show_in_rest'=>true,'show_in_quick_edit'=>false,'show_in_menu'=>false,'meta_box_cb'=>false,'query_var'=>1===$tax->filter_public,'rewrite'=>false,'sort'=>false,'public'=>1===$tax->filter_public,'show_in_nav_menus'=>false,);if(1===$tax->filter_public&&sanitize_title($tax->filter_name)){$taxonomy_data['rewrite']=array('slug'=>urldecode(sanitize_title($tax->filter_name)));}$taxonomy_data=apply_filters("wescle_taxonomy_{$name}_args",$taxonomy_data,$name);register_taxonomy($name,array($tax->filter_post_type),$taxonomy_data);}}}}public function filter_with_metabox($taxs){$catalog_taxs=Helper::get_catalog_taxs();$taxs=array_merge($taxs,$catalog_taxs);return $taxs;}public function filter_with_sorting($taxs){$taxs=array_merge($taxs,WsclAdminFilters::get_filter_taxs(false));return $taxs;}public static function get_filter_nav_chosen(){if(!is_array(self::$chosen_filters)){self::$chosen_filters=array();if(!empty($_REQUEST)){foreach($_REQUEST as $key=>$value){if(0===strpos($key,'filters_')){$filter_name=str_replace('filters_','',$key);$taxonomy=self::filter_taxonomy_name($filter_name);$filter_terms=!empty($value)?explode(',',wp_unslash($value)):array();if(empty($filter_terms)||!taxonomy_exists($taxonomy)){continue;}$query_type=!empty($_REQUEST['query_type_'.$filter_name])&&in_array($_REQUEST['query_type_'.$filter_name],array('and','or'),true)?wp_unslash($_REQUEST['query_type_'.$filter_name]):'';self::$chosen_filters[$taxonomy]['query_type']=$query_type?$query_type:'and';self::$chosen_filters[$taxonomy]['terms']=array_map('sanitize_title',$filter_terms);}}}}return self::$chosen_filters;}public static function get_current_page_url($clear_link=false){if(is_page_template('templates/template-catalog_wescle.php')){$link=get_permalink(get_the_ID());}elseif(is_tax(Helper::get_catalog_taxs())){$queried_object=get_queried_object();$link=get_term_link($queried_object->slug,$queried_object->taxonomy);}if($clear_link){return $link;}if(get_search_query()){$link=add_query_arg('s',rawurlencode(htmlspecialchars_decode(get_search_query())),$link);}if($chosen_filters=self::get_filter_nav_chosen()){foreach($chosen_filters as $name=>$data){$filter_slug=str_replace('filter_','',$name);if(!empty($data['terms'])){$link=add_query_arg('filters_'.$filter_slug,implode(',',$data['terms']),$link);}if('or'===$data['query_type']){$link=add_query_arg('query_type_'.$filter_slug,'or',$link);}}}return $link;}public function pre_get_posts($query){$is_catalog=false;if($query->is_tax(Helper::get_catalog_taxs())&&$query->is_main_query()){$is_catalog=true;}if(isset($query->query_vars['post_type'])&&$query->query_vars['post_type']=='catalog_item'){$is_catalog=true;}if(!$is_catalog){return;}self::$filter_query=$query;$filter_chosen=self::get_filter_nav_chosen();if(!$filter_chosen){return;}$tax_query=isset($query->tax_query,$query->tax_query->queries)?$query->tax_query->queries:array();if(count($filter_chosen)>1){$tax_query['relation']='AND';}foreach($filter_chosen as $taxonomy=>$data){$tax_query[]=array('taxonomy'=>$taxonomy,'field'=>'slug','terms'=>$data['terms'],'operator'=>'and'===$data['query_type']?'AND':'IN','include_children'=>false,);}$query->set('tax_query',$tax_query);self::$filter_query=$query;}public static function get_filter_tax_query(){$tax_query=isset(self::$filter_query->tax_query,self::$filter_query->tax_query->queries)?self::$filter_query->tax_query->queries:array();if(is_tax('catalogcat_wescle')&&self::get_filter_nav_chosen()){$tax_query=isset(self::$filter_query->query_vars,self::$filter_query->query_vars['tax_query'])?self::$filter_query->query_vars['tax_query']:array();$tax_query[]=['taxonomy'=>get_queried_object()->taxonomy,'terms'=>get_queried_object()->term_id,];}return $tax_query;}}new WsclAdminFilters();