<?php

class MetaBoxWooProduct {

	protected $labels = [];

	public function __construct() {
		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}

	public function init() {
		$this->labels = [
			'title_icon'       => __( 'Иконка', 'wescle' ),
			'button_icon'      => __( 'Задать иконку', 'wescle' ),
			'button_add'       => __( 'Добавить', 'wescle' ),
			'button_remove'    => __( 'Удалить', 'wescle' ),
			'title_title'      => __( 'Название', 'wescle' ),
			'title_text'       => __( 'Описание', 'wescle' ),
			'button_add_item'  => __( 'Добавить характеристику', 'wescle' ),
			'title_badge'      => __( 'Значок', 'wescle' ),
			'button_add_badge' => __( 'Добавить значок', 'wescle' ),
		];

		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );
	}

	public function add_meta_box( $post_type ) {
		$post_types = array( 'product' );

		if ( in_array( $post_type, $post_types ) ) {
			add_filter( 'wescle_admin_server_data', function ( $server_data ) {
				$server_data['frame_media_title']  = $this->labels['title_icon'];
				$server_data['frame_media_button'] = $this->labels['button_icon'];

				return $server_data;
			} );

			add_meta_box(
				'wescle_meta_info',
				__( 'Характеристики товара', 'wescle' ),
				array( $this, 'render_meta_box_content' ),
				$post_type,
				'advanced',
				'low'
			);

			add_meta_box(
				'wescle_meta_info_badges',
				__( 'Значок продукта', 'wescle' ),
				array( $this, 'render_meta_box_badges' ),
				$post_type,
				'advanced',
				'low'
			);
		}
	}

	public function save( $post_id ) {

		if ( ! isset( $_POST['wescle_meta_info_nonce'] ) ) {
			return;
		}

		$nonce = $_POST['wescle_meta_info_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'wescle_meta_info' ) ) {
			return;
		}

		// Если это автосохранение ничего не делаем.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Проверяем права пользователя.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		$wescle_product_features = $_POST['wescle_product_features'];

		$data = [];
		if ( $wescle_product_features ) {
			foreach ( $wescle_product_features['image'] as $key => $img_id ) {
				$title = $wescle_product_features['title'][ $key ];
				$text  = $wescle_product_features['text'][ $key ];

				if ( $img_id || $title || $text ) {
					$data[] = [
						'img_id' => $img_id,
						'title'  => $title,
						'text'   => $text,
					];
				}
			}
		}
		update_post_meta( $post_id, 'wescle_product_features', $data );

		$wescle_product_badges = $_POST['wescle_product_badges'];
		if ( $wescle_product_badges ) {
			$wescle_product_badges = array_unique( $wescle_product_badges );
			foreach ( $wescle_product_badges as $key => $val ) {
				if ( ! $val ) {
					unset( $wescle_product_badges[ $key ] );
				}
			}
		}
		if ( $wescle_product_badges ) {
			update_post_meta( $post_id, 'wescle_product_badges', $wescle_product_badges );
		}
		else {
			delete_post_meta( $post_id, 'wescle_product_badges' );
		}

		$product_hide_on_sale = $_POST['product_hide_on_sale'] ?? false;
		if ( $product_hide_on_sale ) {
			update_post_meta( $post_id, 'product_hide_on_sale', $product_hide_on_sale );
		}
		else {
			delete_post_meta( $post_id, 'product_hide_on_sale' );
		}


		if ( $_POST['wescle_product_features_title'] ) {
			update_post_meta( $post_id, 'wescle_product_features_title', $_POST['wescle_product_features_title'] );
		}
		else {
			delete_post_meta( $post_id, 'wescle_product_features_title' );
		}

		$features_as_tabs = $_POST['wescle_product_features_as_tabs'] ?? false;
		if ( $features_as_tabs ) {
			update_post_meta( $post_id, 'wescle_product_features_as_tabs', $features_as_tabs );
		}
		else {
			delete_post_meta( $post_id, 'wescle_product_features_as_tabs' );
		}
	}

	public function render_meta_box_content( $post ) {
		wp_enqueue_media();

		$data_features = get_post_meta( $post->ID, 'wescle_product_features', true );
		?>
        <p>
            <input type="checkbox" id="wescle_product_features_as_tabs" name="wescle_product_features_as_tabs" value="1" <?php checked( '1', get_post_meta( $post->ID, 'wescle_product_features_as_tabs', 1 ) ); ?>>
            <label for="wescle_product_features_as_tabs"><?php _e( 'Переместить в табы', 'wescle' ); ?></label>
        </p>
        <p>
            <label>
				<?php _e( 'Заголовок', 'wescle' ); ?>
                <input type="text" class="widefat" name="wescle_product_features_title" value="<?php echo get_post_meta( $post->ID, 'wescle_product_features_title', 1 ); ?>">
            </label>
        </p>

        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_meta_info', 'wescle_meta_info_nonce' ); ?>
            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $data_features ) {
						foreach ( $data_features as $item ) {
							$img_src = '';
							if ( $item['img_id'] ) {
								$img     = wp_get_attachment_image_src( $item['img_id'], 'medium' );
								$img_src = 'src="' . $img[0] . '"';
							}
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_icon']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div><img <?php echo $img_src; ?> alt=""></div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" name="wescle_product_features[image][]" value="<?php echo $item['img_id']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['title_title']; ?>
                                        <input type="text" class="widefat" name="wescle_product_features[title][]" value="<?php echo esc_attr( $item['title'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['title_text']; ?>
                                        <input type="text" class="widefat" name="wescle_product_features[text][]" value="<?php echo esc_attr( $item['text'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_icon']; ?></label>
                                <div class="term__image__wrapper">
                                    <div><img alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="wescle_product_features[image][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['title_title']; ?>
                                    <input type="text" class="widefat" name="wescle_product_features[title][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['title_text']; ?>
                                    <input type="text" class="widefat" name="wescle_product_features[text][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}

	public function render_meta_box_badges( $post ) {
		wp_enqueue_media();

		$wescle_product_badges = get_post_meta( $post->ID, 'wescle_product_badges', true );
		if ( ! $wescle_product_badges ) {
			$wescle_product_badges = [];
		}

		$badge_data      = Helper::get_badges_data();
		$badge_posts_ids = [
			0 => __( 'Выбрать...', 'wescle' )
		];
		foreach ( $badge_data as $item ) {
			$badge_posts_ids[ $item['id'] ] = $item['title'];
		}
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_meta_info', 'wescle_meta_info_nonce' ); ?>
            <p>
                <input type="checkbox" id="product_hide_on_sale" name="product_hide_on_sale" value="1" <?php checked( '1', get_post_meta( $post->ID, 'product_hide_on_sale', 1 ) ); ?>>
                <label for="product_hide_on_sale"><?php _e( 'Отметьте, чтобы скрыть значок Woocommerce "Распродажа"', 'wescle' ); ?></label>
            </p>

            <div class="wrap-repeater-fields">
                <p><a href="<?php echo admin_url( 'post-new.php?post_type=badge_wescle' ); ?>" target="_blank"><?php _e( 'Добавить новый значок', 'wescle' ); ?></a></p>
                <div class="repeater-fields">
					<?php
					if ( $wescle_product_badges ) {
						foreach ( $wescle_product_badges as $badge_item_id ) {
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['title_badge']; ?>
                                        <select class="widefat" name="wescle_product_badges[]">
											<?php
											foreach ( $badge_posts_ids as $id => $name ) {
												echo '<option value="' . $id . '" ' . selected( $id, $badge_item_id, false ) . '>' . $name . '</option>';
											}
											?>
                                        </select>
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['title_badge']; ?>
                                    <select class="widefat" name="wescle_product_badges[]">
										<?php
										foreach ( $badge_posts_ids as $id => $name ) {
											echo '<option value="' . $id . '">' . $name . '</option>';
										}
										?>
                                    </select>
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_badge']; ?></button>
            </div>
        </div>
		<?php
	}
}

new MetaBoxWooProduct();