<?php

class MetaBoxVideoReview extends MetaBoxPost {

	public function __construct() {

		$this->fields = [
			[
				'type'        => 'text',
				'name'        => 'youtube_link',
				'label'       => esc_html__( 'Ссылка на YouTube', 'wescle' ),
				'description' => esc_html__( 'укажите ссылку с youtube.com', 'wescle' )
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'videoreview' ],
			'meta_box_title' => esc_html__( 'Настройки - Видео-отзыв', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}