<?php

class MetaBoxVideo extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'        => 'checkbox',
				'name'        => 'hide_page_title',
				'label'       => esc_html__( 'Скрыть заголовок страницы?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'        => 'checkbox',
				'name'        => 'hide_contents',
				'label'       => esc_html__( 'Скрыть "Cодержание поста"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'        => 'checkbox',
				'name'        => 'hide_breadcrumbs',
				'label'       => esc_html__( 'Скрыть "Хлебные крошки"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'time_duration',
				'label' => __( 'Длительность видео, время', 'wescle' ),
			],
			[
				'type'        => 'text',
				'name'        => 'custom_views',
				'label'       => __( 'Кастомное количество просмотров', 'wescle' ),
				'description' => __( 'по умолчанию показываются просмотры страницы', 'wescle' ),
			],
			[
				'type'  => 'checkbox',
				'name'  => 'hide_views',
				'label' => __( 'Не показывать просмотры страницы', 'wescle' ),
			],
			[
				'type'        => 'text',
				'name'        => 'custom_url',
				'label'       => __( 'Кастомный URL для кнопки "PLAY"', 'wescle' ),
				'description' => __( 'по умолчанию ссылка на страницу поста', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'play_tooltip',
				'label' => __( 'Текст для кнопки "PLAY"', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'info_tooltip',
				'label' => __( 'Текст для INFO tooltip', 'wescle' ),
			],
			[
				'type'        => 'text',
				'name'        => 'youtube_link',
				'label'       => esc_html__( 'Ссылка на YouTube', 'wescle' ),
				'description' => esc_html__( 'для блока "Видео" укажите ссылку с youtube.com', 'wescle' )
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'video_wescle' ],
			'meta_box_title' => __( 'Настройки видео', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}