<?php

class MetaBoxTeam extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'        => 'checkbox',
				'name'        => 'hide_page_title',
				'label'       => esc_html__( 'Скрыть заголовок страницы?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'        => 'checkbox',
				'name'        => 'hide_contents',
				'label'       => esc_html__( 'Скрыть "Cодержание поста"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'        => 'checkbox',
				'name'        => 'hide_breadcrumbs',
				'label'       => esc_html__( 'Скрыть "Хлебные крошки"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'position',
				'label' => __( 'Должность', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'email',
				'label' => __( 'E-mail', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'phone',
				'label' => __( 'Телефон', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'link_fb',
				'label' => __( 'Ссылка на профиль Facebook', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'link_twitter',
				'label' => __( 'Ссылка на профиль Twitter', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'link_inst',
				'label' => __( 'Ссылка на профиль Instagram', 'wescle' ),
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'team_wescle' ],
			'meta_box_title' => __( 'Настройки', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}