<?php

class MetaBoxTabs {

	protected $labels = [];

	public function __construct() {
		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}

	public function init() {
		$this->labels = [
			'title_icon'      => __( 'Изображение', 'wescle' ),
			'button_icon'     => __( 'Выбрать изображение', 'wescle' ),
			'button_add'      => __( 'Добавить', 'wescle' ),
			'button_remove'   => __( 'Удалить', 'wescle' ),
			'title'           => __( 'Заголовок', 'wescle' ),
			'text'            => __( 'Текст', 'wescle' ),
			'url'             => __( 'URL', 'wescle' ),
			'bg_color'        => __( 'Фон вокруг изображения', 'wescle' ),
			'button_add_item' => __( 'Добавить объект', 'wescle' ),
		];

		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}

	public function add_meta_box( $post_type ) {
		$post_types = array( 'tab_wescle' );

		if ( in_array( $post_type, $post_types ) ) {
			add_meta_box(
				'wescle_tab_info',
				__( 'Объекты в табе', 'wescle' ),
				array( $this, 'render_meta_box_content' ),
				$post_type,
				'advanced',
				'low'
			);
		}
	}

	public function save( $post_id ) {

		if ( ! isset( $_POST['wescle_tab_info_nonce'] ) ) {
			return;
		}

		$nonce = $_POST['wescle_tab_info_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'wescle_tab_info' ) ) {
			return;
		}

		// Если это автосохранение ничего не делаем.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Проверяем права пользователя.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		$wescle_tab_info = $_POST['wescle_tab_info'];

		$data = [];
		if ( $wescle_tab_info ) {
			foreach ( $wescle_tab_info['image'] as $key => $img_id ) {
				$title    = $wescle_tab_info['title'][ $key ];
				$text     = $wescle_tab_info['text'][ $key ];
				$url      = $wescle_tab_info['url'][ $key ];
				$bg_color = $wescle_tab_info['bg_color'][ $key ];

				if ( $title || $text ) {
					$data[] = [
						'img_id'   => $img_id,
						'title'    => $title,
						'text'     => $text,
						'url'      => $url,
						'bg_color' => $bg_color,
					];
				}
			}
		}

		update_post_meta( $post_id, 'wescle_tab_info', $data );
	}

	public function render_meta_box_content( $post ) {
		wp_enqueue_media();
		add_action( 'admin_print_footer_scripts', [ $this, 'script_color_picker' ], 99 );

		$wescle_tab_info = get_post_meta( $post->ID, 'wescle_tab_info', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_tab_info', 'wescle_tab_info_nonce' ); ?>

            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $wescle_tab_info ) {
						foreach ( $wescle_tab_info as $item ) {
							$img_src = '';
							if ( $item['img_id'] ) {
								$img     = wp_get_attachment_image_src( $item['img_id'], 'medium' );
								$img_src = 'src="' . $img[0] . '"';
							}
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_icon']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div><img <?php echo $img_src; ?> alt=""></div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" data-type="image" name="wescle_tab_info[image][]" value="<?php echo $item['img_id']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['bg_color']; ?>
                                    </label>
                                    <div>
                                        <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="wescle_tab_info[bg_color][]" value="<?php echo $item['bg_color']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['title']; ?>
                                        <input type="text" class="widefat" name="wescle_tab_info[title][]" value="<?php echo esc_attr( $item['title'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field" style="width: 20%">
                                    <label>
			                            <?php echo $this->labels['text']; ?>
                                        <textarea class="widefat" name="wescle_tab_info[text][]" rows="4"><?php echo esc_textarea( $item['text'] ); ?></textarea>
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['url']; ?>
                                        <input type="text" class="widefat" name="wescle_tab_info[url][]" value="<?php echo esc_url( @$item['url'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_icon']; ?></label>
                                <div class="term__image__wrapper">
                                    <div><img alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="wescle_tab_info[image][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['bg_color']; ?>
                                </label>
                                <div>
                                    <input type="text" class="widefat color-picker-init" data-alpha-enabled="true" name="wescle_tab_info[bg_color][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field">
                                <label>
			                        <?php echo $this->labels['title']; ?>
                                    <input type="text" class="widefat" name="wescle_tab_info[title][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field" style="width: 20%">
                                <label>
			                        <?php echo $this->labels['text']; ?>
                                    <textarea class="widefat" name="wescle_tab_info[text][]" rows="4"></textarea>
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
			                        <?php echo $this->labels['url']; ?>
                                    <input type="text" class="widefat" name="wescle_tab_info[url][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}

	public function enqueue_scripts() {
		$screen = get_current_screen();
		if ( $screen && 'post' == $screen->base && 'tab_wescle' == $screen->post_type ) {
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'wp-color-picker-alpha', get_template_directory_uri() . '/assets/admin/js/wp-color-picker-alpha.min.js', array( 'wp-color-picker' ), '3.0.0', true );
		}
	}

	public function script_color_picker() {
		?>
        <script>
            jQuery(document).ready(function ($) {
                function init_wpColorPicker() {
                    $('.repeater-row .color-picker').each(function () {
                        $(this).wpColorPicker();
                    });
                }

                init_wpColorPicker();

                $('body').on('wescle_repeater-add-item', function (e, block_fields) {
                    $.each($(block_fields).find('.repeater-row'), function (e, obj) {
                        if ($(obj).parent().hasClass('repeater-fields')) {
                            var input_color = $(obj).find('.color-picker-init');
                            if (input_color.length) {
                                input_color.removeClass('color-picker-init').wpColorPicker();
                            }
                        }
                    });
                });
            })
        </script>
		<?php
	}

}

new MetaBoxStories();