<?php

class MetaBoxTabProduct extends MetaBoxPost {

	public function __construct() {
		$this->set_settings( array(
			'post_type'      => [ 'woo_product_tab' ],
			'meta_box_title' => esc_html__( 'Настройки', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}

	public function set_fields() {
		$product_cats  = [];
		$product_terms = get_terms( [
			'taxonomy'   => 'product_cat',
			'hide_empty' => false
		] );
		foreach ( $product_terms as $term ) {
			$product_cats[ $term->term_id ] = $term->name;
		}

		$this->fields[] = [
			'type'        => 'select2',
			'name'        => 'tab_product_cat',
			'label'       => __( 'Категории товаров', 'wescle' ),
			'description' => __( 'Выберите категории, если вы хотите показывать вкладку только в выбранной категории', 'wescle' ),
			'classes'     => 'wescle-select2',
			'multiple'    => 99,
			'options'     => [ '' => __( 'Выбрать...', 'wescle' ) ] + $product_cats,
		];

		$this->fields[] = [
			'type'        => 'text',
			'name'        => 'tab_product_ids',
			'label'       => __( 'или укажите отдельные товары', 'wescle' ),
			'description' => __( 'Пропишите ID товаров через запятую', 'wescle' )
		];
	}
}

new MetaBoxTabProduct();