<?php

class MetaBoxStories {

	protected $labels = [];

	public function __construct() {
		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}

	public function init() {
		$this->labels = [
			'title_icon'      => __( 'Изображение / Превью для видео', 'wescle' ),
			'title_video'     => __( 'Видео', 'wescle' ) . ', *.mp4',
			'button_icon'     => __( 'Выбрать изображение', 'wescle' ),
			'button_add'      => __( 'Добавить', 'wescle' ),
			'button_remove'   => __( 'Удалить', 'wescle' ),
			'link_url'        => __( 'URL для ссылки', 'wescle' ),
			'link_label'      => __( 'Надпись для ссылки', 'wescle' ),
			'date'            => __( 'Дата', 'wescle' ),
			'button_add_item' => __( 'Добавить фото/видео', 'wescle' ),
		];

		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );
	}

	public function add_meta_box( $post_type ) {
		$post_types = array( 'stories_wescle' );

		if ( in_array( $post_type, $post_types ) ) {
			add_filter( 'wescle_admin_server_data', function ( $server_data ) {
				$server_data['frame_media_title'] = $this->labels['title_icon'];

				return $server_data;
			} );

			add_meta_box(
				'wescle_stories_info',
				__( 'Информация о сторис', 'wescle' ),
				array( $this, 'render_meta_box_content' ),
				$post_type,
				'advanced',
				'low'
			);
		}
	}

	public function save( $post_id ) {

		if ( ! isset( $_POST['wescle_stories_info_nonce'] ) ) {
			return;
		}

		$nonce = $_POST['wescle_stories_info_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'wescle_stories_info' ) ) {
			return;
		}

		// Если это автосохранение ничего не делаем.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Проверяем права пользователя.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		$wescle_stories_info = $_POST['wescle_stories_info'];

		$data = [];
		if ( $wescle_stories_info ) {
			foreach ( $wescle_stories_info['image'] as $key => $img_id ) {
				$file_id    = $wescle_stories_info['file'][ $key ];
				$link_url   = $wescle_stories_info['link_url'][ $key ];
				$link_label = $wescle_stories_info['link_label'][ $key ];
				$date       = $wescle_stories_info['date'][ $key ];

				if ( $img_id || $file_id ) {
					$data[] = [
						'img_id'     => $img_id,
						'file_id'    => $file_id,
						'link_url'   => $link_url,
						'link_label' => $link_label,
						'date'       => $date,
					];
				}
			}
		}

		update_post_meta( $post_id, 'wescle_stories_info', $data );

		update_post_meta( $post_id, 'time_length', intval( $_POST['time_length'] ) );
	}

	public function render_meta_box_content( $post ) {
		wp_enqueue_media();
		add_action( 'admin_print_footer_scripts', [ $this, 'script_datepicker' ], 99 );

		$stories_info = get_post_meta( $post->ID, 'wescle_stories_info', true );
		$time_length  = get_post_meta( $post->ID, 'time_length', 1 );
		if ( '' === $time_length ) {
			$time_length = 3;
		}
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_stories_info', 'wescle_stories_info_nonce' ); ?>
            <table class="form-table form-table-custom">
                <tbody>
                <tr>
                    <td>
                        <div><label for="sub_title"><?php _e( 'Длительность отображения фотографий, сек', 'wescle' ); ?></label></div>
                        <input type="number" id="time_length" name="time_length" placeholder="" value="<?php echo $time_length; ?>" style="width: 100%">
                    </td>
                </tr>
                </tbody>
            </table>

            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $stories_info ) {
						foreach ( $stories_info as $item ) {
							$img_src = '';
							if ( $item['img_id'] ) {
								$img     = wp_get_attachment_image_src( $item['img_id'], 'medium' );
								$img_src = 'src="' . $img[0] . '"';
							}

							$file_img_src = $filename = '';
							if ( $item['file_id'] ) {
								$file_img_src = 'src="' . home_url( '/wp-includes/images/media/video.png' ) . '"';
								$file_url     = wp_get_attachment_url( $item['file_id'] );
								if ( $file_url ) {
									$filename = basename( $file_url );
								}
							}
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_icon']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div><img <?php echo $img_src; ?> alt=""></div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" data-type="image" name="wescle_stories_info[image][]" value="<?php echo $item['img_id']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_video']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div class="thumbnail">
                                            <div class="centered"><img <?php echo $file_img_src; ?> class="icon" alt=""></div>
                                            <div class="filename">
                                                <div><?php echo $filename; ?></div>
                                            </div>
                                        </div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" data-type="video" name="wescle_stories_info[file][]" value="<?php echo $item['file_id']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['link_url']; ?>
                                        <input type="text" class="widefat" name="wescle_stories_info[link_url][]" value="<?php echo esc_url( $item['link_url'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['link_label']; ?>
                                        <input type="text" class="widefat" name="wescle_stories_info[link_label][]" value="<?php echo esc_attr( $item['link_label'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['date']; ?>
                                        <input type="text" class="widefat air-datepicker" name="wescle_stories_info[date][]" readonly value="<?php echo $item['date']; ?>">
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_icon']; ?></label>
                                <div class="term__image__wrapper">
                                    <div><img alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="wescle_stories_info[image][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_video']; ?></label>
                                <div class="term__image__wrapper">
                                    <div class="thumbnail">
                                        <div class="centered"><img class="icon" alt=""></div>
                                        <div class="filename">
                                            <div></div>
                                        </div>
                                    </div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" data-type="video" name="wescle_stories_info[file][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field">
                                <label>
			                        <?php echo $this->labels['link_url']; ?>
                                    <input type="text" class="widefat" name="wescle_stories_info[link_url][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
			                        <?php echo $this->labels['link_label']; ?>
                                    <input type="text" class="widefat" name="wescle_stories_info[link_label][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['date']; ?>
                                    <input type="text" class="widefat datetimepicker air-datepicker" name="wescle_stories_info[date][]" readonly value="">
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}

	public function script_datepicker() {
		$datepicker_lang = 'en';
		if ( 'uk' === get_locale() ) {
			$datepicker_lang = 'uk';
		}
        elseif ( 'ru_RU' === get_locale() ) {
			$datepicker_lang = 'ru';
		}
		?>
        <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/admin/js/air-datepicker/css/datepicker.min.css" media="all">
        <script src="<?php echo get_template_directory_uri(); ?>/assets/admin/js/air-datepicker/js/datepicker.min.js"></script>
        <script src="<?php echo get_template_directory_uri(); ?>/assets/admin/js/air-datepicker/js/i18n/datepicker.<?php echo $datepicker_lang; ?>.js"></script>
        <script>
            function init_air_datepicker() {
                jQuery('.air-datepicker').each(function () {
                    var input_value = jQuery(this).val();

                    if (!jQuery(this).hasClass('init')) {
                        var myDataPicker = jQuery(this).datepicker({
                            maxDate: new Date(),
                            timepicker: true,
                        }).data('datepicker');

                        if (input_value) {
                            var input_value_date = input_value.split(' ');
                            var input_value_date_d = input_value_date[0].split('.');

                            var date = input_value_date_d[2] + '-' + input_value_date_d[1] + '-' + input_value_date_d[0];
                            var time = 'T' + input_value_date[1] + ':00';

                            myDataPicker.selectDate(new Date(date + time));
                        }
                    }
                });
            }

            init_air_datepicker();
        </script>
		<?php
	}

}

new MetaBoxStories();