<?php

class MetaBoxSingularElemets extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'  => 'checkbox',
				'name'  => 'post_blocks_show_enabled',
				'label' => __( 'Применить настройки?', 'wescle' ),
			],
			[
				'type'    => 'radio_button',
				'name'    => 'about_version',
				'label'   => __( 'Версия шапки', 'wescle' ),
				'default' => 'v1',
				'options' => [
					'v1' => get_template_directory_uri() . '/assets/admin/img/post_v1.png',
					'v2' => get_template_directory_uri() . '/assets/admin/img/post_v2.png',
					'v3' => get_template_directory_uri() . '/assets/admin/img/post_v3.png',
					'v4' => get_template_directory_uri() . '/assets/admin/img/post_v4.png'
				],
			],
			[
				'type'  => 'checkbox',
				'name'  => 'about_full_height',
				'label' => esc_html__( 'Изображение на всю высоту страницы? ( 100vh )', 'wescle' ),
			],
			[
				'type'  => 'checkbox',
				'name'  => 'about_version_image',
				'label' => esc_html__( 'Показывать миниатюру в начале поста?', 'wescle' ),
			],
			[
				'type'  => 'checkbox',
				'name'  => 'about_image_height_variable',
				'label' => esc_html__( 'Гибкая высота главного фото?', 'wescle' ),
			],
			[
				'type'    => 'radio_button',
				'name'    => 'sidebar_position',
				'label'   => __( 'Позиция сайдбара', 'wescle' ),
				'options' => [
					'none'  => get_template_directory_uri() . '/assets/admin/img/sidebar-none.png',
					'left'  => is_rtl() ? get_template_directory_uri() . '/assets/admin/img/sidebar-right.png' : get_template_directory_uri() . '/assets/admin/img/sidebar-left.png',
					'right' => is_rtl() ? get_template_directory_uri() . '/assets/admin/img/sidebar-left.png' : get_template_directory_uri() . '/assets/admin/img/sidebar-right.png'
				],
			],
			[
				'type'  => 'checkbox',
				'name'  => 'custom_content_box_width',
				'label' => esc_html__( 'Изменить ширину контейнера?', 'wescle' ),
			],
			[
				'type'    => 'range',
				'name'    => 'content_box_width_val',
				'label'   => esc_html__( 'Максимальная ширина контейнера?', 'wescle' ),
				'default' => 1280,
				'min'     => apply_filters( 'wescle_min_box_width_post', 1000 ),
				'max'     => apply_filters( 'wescle_max_box_width_post', 1920 ),
				'step'    => 10,
			],
			[
				'type'    => 'range',
				'name'    => 'sidebar_box_width_val',
				'label'   => esc_html__( 'Ширина сайдбара', 'wescle' ),
				'default' => 30,
				'min'     => 10,
				'max'     => 50,
				'step'    => 1,
			],
			[
				'type'    => 'checkboxes',
				'name'    => 'post_blocks_show',
				'label'   => __( 'Отображаемые элементы', 'wescle' ),
				'options' => Helper::choices_post_blocks_hide()
			],
		];

		$this->set_settings( array(
			'meta_prekey'    => 'blocks_show_post_type_',
			'post_type'      => apply_filters( 'wescle_blocks_show_post_type', [ 'post', 'page', 'service', 'event_wescle', 'portfolio_wescle', 'product_wescle', 'video_wescle', 'team_wescle', 'catalog_item' ] ),
			'meta_box_title' => esc_html__( 'Индивидуальные настройки', 'wescle' ),
			'context'        => 'side',
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}

	public function set_fields() {
		$screen = get_current_screen();
		if ( $screen && $screen->post_type == 'catalog_item' ) {
			unset( $this->fields[1]['options']['v3'] );
			unset( $this->fields[1]['options']['v4'] );
			unset( $this->fields[2] );
			unset( $this->fields[3] );
			unset( $this->fields[4] );
		}
	}
}