<?php

class MetaBoxService extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'        => 'checkbox',
				'name'        => 'hide_page_title',
				'label'       => esc_html__( 'Скрыть заголовок страницы?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'        => 'checkbox',
				'name'        => 'hide_contents',
				'label'       => esc_html__( 'Скрыть "Cодержание поста"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'        => 'checkbox',
				'name'        => 'hide_breadcrumbs',
				'label'       => esc_html__( 'Скрыть "Хлебные крошки"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'price',
				'label' => esc_html__( 'Цена', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'price_old',
				'label' => esc_html__( 'Старая цена', 'wescle' )
			],
			[
				'type'  => 'text',
				'name'  => 'button_text',
				'label' => esc_html__( 'Надпись на кнопке', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'button_link',
				'label' => esc_html__( 'Ссылка для кнопки', 'wescle' ),
			],
			[
				'type'        => 'image',
				'name'        => 'service_icon',
				'label'       => esc_html__( 'Иконка', 'wescle' ),
				'description' => esc_html__( 'используется в блоке "Дополнительные услуги"', 'wescle' ),
			]
		];

		if ( class_exists( 'WPCF7_Mail' ) ) {
			$this->fields[] = [
				'type'        => 'checkbox',
				'name'        => 'show_form_after_content',
				'label'       => esc_html__( 'Показывать контактную форму после контента', 'wescle' ),
				'placeholder' => esc_html__( 'Да', 'wescle' ),
				'description' => esc_html__( 'Выбрать форму можно в Customizer -> Настройка внутренних страниц', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'text',
				'name'  => 'title_form_after_content',
				'label' => esc_html__( 'Заголовок для формы', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'textarea',
				'name'  => 'text_form_after_content',
				'label' => esc_html__( 'Описание для формы', 'wescle' ),
			];
		}

		$this->set_settings( array(
			'post_type'      => [ 'service' ],
			'meta_box_title' => esc_html__( 'Настройки - Услуги', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}