<?php

class MetaBoxReview extends MetaBoxPost {

	public function __construct() {

		$this->fields = [
			[
				'type'  => 'text',
				'name'  => 'sub_title',
				'label' => esc_html__( 'Должность/Город', 'wescle' )
			],
			[
				'type'  => 'text',
				'name'  => 'date_review',
				'label' => esc_html__( 'Дата публикации/размещения', 'wescle' )
			],
			[
				'type'        => 'number',
				'name'        => 'rating',
				'label'       => esc_html__( 'Рейтинг', 'wescle' ),
				'description' => esc_html__( 'от 1 до 5', 'wescle' ),
				'step'        => '0.1',
			],
			[
				'type'  => 'checkbox',
				'name'  => 'rating_after_title',
				'label' => esc_html__( 'Показывать рейтинг после имени?', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'source',
				'label' => esc_html__( 'URL, Источник', 'wescle' )
			],
			[
				'type'        => 'text',
				'name'        => 'youtube_link',
				'label'       => esc_html__( 'Ссылка на YouTube', 'wescle' ),
				'description' => esc_html__( 'для вставки видео-отзыва укажите ссылку с youtube.com', 'wescle' )
			],
			[
				'type'        => 'image',
				'name'        => 'thumbnail_video',
				'label'       => esc_html__( 'Превью видео-отзыва', 'wescle' ),
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'review' ],
			'meta_box_title' => esc_html__( 'Настройки - Отзыв', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}