<?php

class MetaBoxProgram extends MetaBoxPost {

	public function __construct() {
		$this->set_settings( array(
			'post_type'      => [ 'program_wescle' ],
			'meta_box_title' => esc_html__( 'Настройки - Программа', 'wescle' ),
		) );

		add_action( 'load-post.php', array( $this, 'init' ) );
		add_action( 'load-post-new.php', array( $this, 'init' ) );
	}

	public function set_fields() {
		$current_screen = get_current_screen();
		if ( in_array( $current_screen->post_type, $this->post_type ) ) {
			$this->fields = [
				[
					'type'  => 'checkbox',
					'name'  => 'is_bonus',
					'label' => esc_html__( 'Это дополнительный модуль / бонусная программа?', 'wescle' ),
				],
				[
					'type'  => 'text',
					'name'  => 'sub_title',
					'label' => esc_html__( 'Краткое описание программы', 'wescle' ),
				],

				[
					'type'    => 'select',
					'name'    => 'speacker_id',
					'label'   => esc_html__( 'Спикер', 'wescle' ),
					'options' => Helper::get_posts( array(
						'post_type' => 'speaker_program'
					), true ),
				],
			];
		}
	}
}