<?php

class MetaBoxProductTerms {

	public function __construct() {
		$taxonomies = apply_filters( 'product_taxonomies_custom_metabox', [ 'product_cat', 'product_tag' ] );

		foreach ( $taxonomies as $taxonomy ) {
			add_action( $taxonomy . '_edit_form_fields', array( $this, 'taxonomy_edit_meta_fields' ), 10, 2 );
			add_action( 'saved_' . $taxonomy, array( $this, 'taxonomy_saved_fields' ), 10 );
		}
	}

	public function taxonomy_edit_meta_fields( $term, $taxonomy ) {
		$description_bottom = get_term_meta( $term->term_id, 'description_bottom', 1 );

		$html = '<tr class="form-field">';
		$html .= '<th scope="row"><label for="description-bottom">' . __( 'Описание под товарами', 'wescle' ) . '</label></th>';
		$html .= '<td>';

		ob_start();
		wp_editor( $description_bottom, 'description-bottom', [ 'textarea_name' => 'description-bottom' ] );
		$html .= ob_get_clean();

		$html .= '<p class="description">' . __( 'Это описание будет отображаться под товарами', 'wescle' ) . '</p>';
		$html .= '</td>';
		$html .= '</tr>';

		echo $html;
	}

	public function taxonomy_saved_fields( $term_id ) {
		if ( isset( $_POST['description-bottom'] ) ) {
			update_term_meta( $term_id, 'description_bottom', $_POST['description-bottom'] );
		}
	}

}

new MetaBoxProductTerms();