<?php

class MetaBoxProduct extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'        => 'checkbox',
				'name'        => 'hide_page_title',
				'label'       => esc_html__( 'Скрыть заголовок страницы?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'        => 'checkbox',
				'name'        => 'hide_contents',
				'label'       => esc_html__( 'Скрыть "Cодержание поста"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'        => 'checkbox',
				'name'        => 'hide_breadcrumbs',
				'label'       => esc_html__( 'Скрыть "Хлебные крошки"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'price',
				'label' => esc_html__( 'Цена', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'price_old',
				'label' => esc_html__( 'Старая цена', 'wescle' )
			],
			[
				'type'        => 'checkbox',
				'name'        => 'gradient_disable',
				'placeholder' => esc_html__( 'Выкл', 'wescle' ),
				'label'       => esc_html__( 'Отключить градиент под изображением?', 'wescle' )
			],
			[
				'type'  => 'text',
				'name'  => 'button_text',
				'label' => esc_html__( 'Текст для кнопки', 'wescle' ),
			],
			[
				'type'        => 'text',
				'name'        => 'button_url',
				'label'       => esc_html__( 'URL для кнопки', 'wescle' ),
				'description' => __( '* чтобы кнопку сделать вызовом попапа звонка, пропишите <code>#modal-call</code>', 'wescle' ),
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'product_wescle' ],
			'meta_box_title' => esc_html__( 'Настройки - Продукт', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}