<?php

class MetaBoxPricePackage extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'        => 'text',
				'name'        => 'price',
				'label'       => esc_html__( 'Цена', 'wescle' ),
				'description' => esc_html__( 'надпись над кнопкой', 'wescle' )
			],
			[
				'type'  => 'text',
				'name'  => 'price_old',
				'label' => esc_html__( 'Старая цена', 'wescle' )
			],
			[
				'type'  => 'text',
				'name'  => 'label_after_button',
				'label' => esc_html__( 'Подпись под кнопкой', 'wescle' )
			],
			[
				'type'  => 'color',
				'name'  => 'block_color',
				'label' => esc_html__( 'Если нужно - то укажите уникальный цвет пакета', 'wescle' )
			],
			[
				'type'        => 'text',
				'name'        => 'button_url',
				'label'       => esc_html__( 'Если нужно - то укажите URL для кнопки заказа', 'wescle' ),
				'description' => esc_html__( 'по умолчанию открывается модальное окно с формой заказа', 'wescle' )
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'pricepackage_wescle' ],
			'meta_box_title' => esc_html__( 'Настройки - Пакет', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}