<?php

class MetaBoxPost {

	protected $meta_prekey = 'meta_posts_';
	protected $post_type = [ 'post' ];
	protected $context = 'advanced';
	protected $fields = [];
	protected $save_fields = [];
	protected $obj_id = 0;
	protected $meta_box_title = '';

	public function __construct() {

		$size_text = '';
		$size_text .= '<p><strong>' . __( 'Рекомендуемые размеры для вида карточек', 'wescle' ) . '</strong></p>';
		$size_text .= '<p>';
		$size_text .= sprintf( esc_html__( 'по умолчанию: %s', 'wescle' ), '<strong>450x0*</strong>' ) . '<br>';
		$size_text .= sprintf( esc_html__( 'вертикальный: %s', 'wescle' ), '<strong>554x675</strong>' ) . '<br>';
		$size_text .= sprintf( esc_html__( 'горизонтальный: %s', 'wescle' ), '<strong>520x387</strong>' ) . '<br>';
		$size_text .= '---' . '<br>';
		$size_text .= '*' . esc_html__( 'мягкая обрезка фото, без кропа, с фиксированной шириной', 'wescle' ) . '<br>';
		$size_text .= '</p>';

		$this->fields[] = [
			'type'        => 'checkbox',
			'name'        => 'hide_page_title',
			'label'       => esc_html__( 'Скрыть заголовок страницы?', 'wescle' ),
			'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
		];

		$this->fields[] = [
			'type'        => 'checkbox',
			'name'        => 'hide_contents',
			'label'       => esc_html__( 'Скрыть "Cодержание поста"?', 'wescle' ),
			'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
		];

		$this->fields[] = [
			'type'        => 'checkbox',
			'name'        => 'hide_breadcrumbs',
			'label'       => esc_html__( 'Скрыть "Хлебные крошки"?', 'wescle' ),
			'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
		];

		if ( class_exists( 'WPCF7_Mail' ) ) {
			$this->fields[] = [
				'type'        => 'checkbox',
				'name'        => 'show_form_after_content',
				'label'       => esc_html__( 'Показывать контактную форму после контента', 'wescle' ),
				'placeholder' => esc_html__( 'Да', 'wescle' ),
				'description' => esc_html__( 'Выбрать форму можно в Customizer -> Настройка внутренних страниц', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'text',
				'name'  => 'title_form_after_content',
				'label' => esc_html__( 'Заголовок для формы', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'textarea',
				'name'  => 'text_form_after_content',
				'label' => esc_html__( 'Описание для формы', 'wescle' ),
			];
		}

		$this->fields[] = [
			'type'        => 'image',
			'name'        => 'thumbnail_archive',
			'label'       => esc_html__( 'Миниатюра на архивных страницах, в слайдере', 'wescle' ),
			'description' => $size_text,
		];

		$this->fields[] = [
			'type'        => 'checkbox',
			'name'        => 'show_image_news_widget',
			'label'       => esc_html__( 'Показывать изображение записи в виджете "Новости"?', 'wescle' ),
			'placeholder' => esc_html__( 'Да', 'wescle' ),
		];

		$this->set_settings( array(
			'meta_prekey'    => $this->meta_prekey,
			'post_type'      => $this->post_type,
			'meta_box_title' => esc_html__( 'Настройки записи', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}

	public function set_settings( $args = array() ) {
		if ( ! empty( $args['meta_prekey'] ) ) {
			$this->meta_prekey = $args['meta_prekey'];
		}
		if ( ! empty( $args['post_type'] ) ) {
			$this->post_type = $args['post_type'];
		}
		if ( ! empty( $args['meta_box_title'] ) ) {
			$this->meta_box_title = $args['meta_box_title'];
		}
		if ( ! empty( $args['context'] ) ) {
			$this->context = $args['context'];
		}
	}

	public function init() {
		$this->set_fields();

		add_action( 'add_meta_boxes', array( $this, 'add_metafields' ) );
		add_action( 'save_post', array( $this, 'save_metafields' ), 11, 2 );

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}

	public function set_fields() {
	}

	public function enqueue_scripts() {
		$screen = get_current_screen();
		if ( $screen && 'post' == $screen->base && in_array( $screen->post_type, $this->post_type ) ) {
			foreach ( $this->fields as $field ) {
				if ( $field['type'] == 'date' ) {
					wp_enqueue_script( 'jquery-ui-datepicker' );

					wp_register_style( 'jquery-ui', get_template_directory_uri() . '/assets/admin/css/jquery-ui.min.css', [], '1.12.1' );
					wp_enqueue_style( 'jquery-ui' );
				}

				if ( $field['type'] == 'color' ) {
					wp_enqueue_script( 'wp-color-picker' );
					wp_enqueue_style( 'wp-color-picker' );
				}

				if ( $field['type'] == 'select2' ) {
					wp_enqueue_script( 'selectWoo', get_template_directory_uri() . '/libs/wscl/assets/vendor/selectWoo/js/select2.min.js', array( 'jquery' ), '1.0.1', true );
					wp_enqueue_style( 'selectWoo', get_template_directory_uri() . '/libs/wscl/assets/vendor/selectWoo/css/selectWoo.css', array(), '1.0.1' );
				}

				if ( $field['type'] == 'image' || $field['type'] == 'file' ) {
					wp_enqueue_media();
				}
			}
		}
	}

	public function add_metafields() {
		$priority = 'high';
		if ( 'side' == $this->context ) {
			$priority = 'low';
		}

		add_meta_box(
			$this->meta_prekey . 'meta_box',
			$this->meta_box_title,
			array( $this, 'html_metabox' ),
			$this->post_type,
			$this->context,
			$priority
		);
	}

	public function html_metabox( $post ) {

		// Set post id
		$this->obj_id = $post->ID;

		// Add nonce for security and authentication.
		wp_nonce_field( $this->meta_prekey . 'nonce_action', $this->meta_prekey . 'nonce' );


		// Form fields.
		echo '<table class="form-table form-table-custom form-table-metabox-' . current( $this->post_type ) . '">';

		$this->html_fields();

		echo '</table>';

		// fields to save
		echo '<input type="hidden" name="' . $this->meta_prekey . 'fields_to_save" value="' . esc_attr( base64_encode( json_encode( $this->save_fields ) ) ) . '">';

	}

	public function html_fields() {

		foreach ( $this->fields as $field ) {

			$field = wp_parse_args(
				(array) $field,
				array(
					'type'        => 'text',
					'name'        => '',
					'label'       => '',
					'placeholder' => '',
					'description' => '',
					'text'        => '',
					'default'     => '',
					'options'     => [],
					'args'        => [],
					'multiple'    => 0,
					'min'         => 0,
					'max'         => 100,
					'step'        => 1,
					'classes'     => '',
					'file_type'   => '',
				)
			);

			switch ( $field['type'] ) {
				case 'text_html':
				case 'text':
					$this->text_field( $field['name'], $field['label'], $field['placeholder'], $field['description'], $field['text'], $field['type'] );
					break;

				case 'textarea':
					$this->textarea_field( $field['name'], $field['label'], $field['placeholder'], $field['description'] );
					break;

				case 'image':
					$this->image_field( $field['name'], $field['label'], $field['placeholder'], $field['description'] );
					break;

				case 'file':
					$this->file_field( $field['name'], $field['label'], $field['file_type'], $field['description'] );
					break;

				case 'checkbox':
					$this->checkbox_field( $field['name'], $field['label'], $field['placeholder'], $field['description'] );
					break;

				case 'checkboxes':
					$this->checkboxes_field( $field['name'], $field['label'], $field['options'], $field['description'] );
					break;

				case 'date':
					$this->date_field( $field['name'], $field['label'], $field['placeholder'], $field['description'] );
					break;

				case 'select2':
				case 'select':
					$this->select_field( $field['name'], $field['label'], $field['options'], $field['description'], $field['multiple'], $field['classes'] );
					break;

				case 'radio_button':
					$this->radio_button_field( $field['name'], $field['label'], $field['options'], $field['description'], $field['default'] );
					break;

				case 'price_package':
					$this->price_package_field( $field['name'], $field['label'], $field['options'], $field['description'] );
					break;

				case 'color':
					$this->color_field( $field['name'], $field['label'], $field['text'], $field['description'] );
					break;

				case 'custom':
					$this->custom_field( $field['label'], $field['description'], $this->obj_id );
					break;

				case 'number':
					$this->number_field( $field['name'], $field['label'], $field['default'], $field['description'], $field['text'], $field['step'] );
					break;

				case 'range':
					$this->range_field( $field['name'], $field['label'], $field['default'], $field['min'], $field['max'], $field['step'] );
					break;

				default:
					echo 'Поле не найдено.';
			}

		}

	}

	public function save_metafields( $post_id, $post ) {

		// Add nonce for security and authentication.
		$nonce_name   = ( ! empty( $_POST[ $this->meta_prekey . 'nonce' ] ) ) ? $_POST[ $this->meta_prekey . 'nonce' ] : '';
		$nonce_action = $this->meta_prekey . 'nonce_action';

		// Check if a nonce is set.
		if ( ! isset( $nonce_name ) ) {
			return;
		}

		// Check if a nonce is valid.
		if ( ! wp_verify_nonce( $nonce_name, $nonce_action ) ) {
			return;
		}

		// Check if the user has permissions to save data.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}

		// Check if it's not an autosave.
		if ( wp_is_post_autosave( $post_id ) ) {
			return;
		}

		// Check if it's not a revision.
		if ( wp_is_post_revision( $post_id ) ) {
			return;
		}

		$fields_saved = json_decode( base64_decode( $_POST[ $this->meta_prekey . 'fields_to_save' ] ) );

		foreach ( $fields_saved as $field_save ) {

			if ( $field_save->type == 'textarea' ) {
				$field_variable = isset( $_POST[ $field_save->name ] ) ? sanitize_textarea_field( $_POST[ $field_save->name ] ) : '';
				update_post_meta( $post_id, $field_save->name, $field_variable );
			}
            elseif ( $field_save->type == 'text' ) {
				$field_variable = isset( $_POST[ $field_save->name ] ) ? sanitize_text_field( $_POST[ $field_save->name ] ) : '';
				update_post_meta( $post_id, $field_save->name, $field_variable );
			}
            elseif ( $field_save->type == 'date' ) {
				$field_variable = isset( $_POST[ $field_save->name ] ) ? date( 'Ymd', strtotime( $_POST[ $field_save->name ] ) ) : '';
				update_post_meta( $post_id, $field_save->name, $field_variable );
			}
			else {
				$field_variable = isset( $_POST[ $field_save->name ] ) ? $_POST[ $field_save->name ] : '';
				update_post_meta( $post_id, $field_save->name, $field_variable );
			}
		}
	}

	public function text_field( $name = '', $label = '', $placeholder = '', $description = '', $text = '', $type = 'text' ) {

		$this->saved_fields( $name, $type );

		$value = get_post_meta( $this->obj_id, $name, true );
		if ( empty( $value ) ) {
			$value = '';
		}

		echo '	<tr class="field-' . $name . '">';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label for="' . $name . '">' . $label . '</label></div>';
		}
		echo '			<input type="text" id="' . $name . '" name="' . $name . '" placeholder="' . esc_attr( $placeholder ) . '" value="' . esc_attr( $value ) . '" style="width: 100%"> ' . $text;
		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function textarea_field( $name = '', $label = '', $placeholder = '', $description = '' ) {

		$this->saved_fields( $name, 'textarea' );

		$value = get_post_meta( $this->obj_id, $name, true );
		if ( empty( $value ) ) {
			$value = '';
		}

		echo '	<tr class="field-' . $name . '">';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label for="' . $name . '">' . $label . '</label></div>';
		}
		echo '			<textarea id="' . $name . '" name="' . $name . '" placeholder="' . esc_attr( $placeholder ) . '" style="width: 100%">' . esc_textarea( $value ) . '</textarea>';
		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function image_field( $name = '', $label = '', $placeholder = '', $description = '' ) {

		$this->saved_fields( $name, 'image' );

		if ( ! $placeholder ) {
			$placeholder = __( 'Загрузить', 'wescle' );
		}

		$img_src = '';
		$value   = get_post_meta( $this->obj_id, $name, true );
		if ( empty( $value ) ) {
			$value = '';
		}
		else {
			$img = wp_get_attachment_image_src( $value, 'medium' );
			if ( $img ) {
				$img_src = $img[0];
			}
		}

		echo '<tr>';
		echo '<td>';
		if ( ! empty( $label ) ) {
			echo '<div><label for="' . $name . '">' . $label . '</label></div>';
		}

		if ( ! empty( $description ) ) {
			global $post;
			if ( $post->post_type != 'post' ) {
				echo '<div><p class="description">' . $description . '</p><div>';
			}
			else {
				echo '<div>' . $description . '<div>';
			}
		}

		echo '			<input type="hidden" id="' . $name . '" name="' . $name . '" value="' . esc_attr( $value ) . '" style="width: 100%">';

		if ( $img_src ) {
			echo '<div class="upload_thumbnail_archive_img profile_image"><img src="' . $img_src . '" alt=""><a href="#" class="profile-image-remove remove_thumbnail_archive" type="button">' . __( 'Remove' ) . '</a></div>';
		}
		else {
			echo '<div class="upload_thumbnail_archive_img profile_image"></div>';
		}

		echo '<button class="button upload_thumbnail_archive" type="button">' . $placeholder . '</button>';

		if ( ! empty( $description ) ) {
			echo '</div>';
		}

		echo '</td>';
		echo '</tr>';
	}

	public function file_field( $name = '', $label = '', $file_type = '', $description = '' ) {

		$this->saved_fields( $name, 'file' );

		$file_img_src = $filename = '';
		$file_id      = get_post_meta( $this->obj_id, $name, true );
		if ( $file_id ) {
			$file_img_src = 'src="' . home_url( '/wp-includes/images/media/video.png' ) . '"';
			$file_url     = wp_get_attachment_url( $file_id );
			if ( $file_url ) {
				$filename = basename( $file_url );
			}
		}

		echo '<tr>';
		echo '<td>';
		if ( ! empty( $label ) ) {
			echo '<div><label for="' . $name . '">' . $label . '</label></div>';
		}

		?>
        <div class="term__image__wrapper">
            <div class="thumbnail">
                <div class="centered"><img <?php echo $file_img_src; ?> class="icon" alt=""></div>
                <div class="filename">
                    <div><?php echo $filename; ?></div>
                </div>
            </div>
            <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
            <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

            <input type="hidden" class="term_imgid" data-type="<?php echo $file_type; ?>" name="<?php echo $name; ?>" value="<?php echo $file_id; ?>">
			<?php
			if ( ! empty( $description ) ) {
				echo '<div>' . $description . '<div>';
			}
			?>
        </div>
		<?php
		echo '</td>';
		echo '</tr>';
	}

	public function checkbox_field( $name = '', $label = '', $text = '', $description = '' ) {

		$this->saved_fields( $name, 'checkbox' );

		$value = get_post_meta( $this->obj_id, $name, true );

		echo '	<tr class="field-' . $name . '">';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label for="' . $name . '">' . $label . '</label></div>';
		}
		echo '			<input type="checkbox" id="' . $name . '" name="' . $name . '" value="1" ' . checked( $value, '1', false ) . '> <label for="' . $name . '">' . $text . '</label>';
		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function checkboxes_field( $name = '', $label = '', $options = [], $description = '' ) {

		$this->saved_fields( $name, 'checkboxes' );

		$values = get_post_meta( $this->obj_id, $name, true );
		if ( ! $values ) {
			$values = [];
		}

		echo '	<tr class="checkboxes">';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label>' . $label . '</label></div>';
		}

		foreach ( $options as $key => $val ) {
			echo '			<label class="wrap-input-checkbox checkbox__' . $key . '"><input type="checkbox" id="' . $name . '_' . $key . '" name="' . $name . '[]" value="' . $key . '" ' . checked( in_array( $key, $values ), true, false ) . '> ' . $val . '</label>';
		}

		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function date_field( $name = '', $label = '', $text = '', $description = '' ) {

		$this->saved_fields( $name, 'date' );

		$date_format = get_option( 'date_format' );
		if ( ! $date_format ) {
			$date_format = 'd.m.Y';
		}

		$value = get_post_meta( $this->obj_id, $name, true );
		if ( empty( $value ) ) {
			$value      = '';
			$date_value = '';
		}
		else {
			$date_value = date( $date_format, strtotime( $value ) );
		}

		echo '	<tr>';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label for="' . $name . '">' . $label . '</label></div>';
		}
		echo '			<input type="text" class="input-datepicker" data-id="' . $name . '" value="' . $date_value . '"> ' . $text;
		echo '			<input type="hidden" id="' . $name . '" name="' . $name . '" value="' . esc_attr( $value ) . '">';
		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function select_field( $name = '', $label = '', $options = array(), $description = '', $multiple = 0, $classes = '' ) {

		$this->saved_fields( $name, 'select' );

		$value = get_post_meta( $this->obj_id, $name, true );

		$select_id = $name;

		$multiple_attr = '';
		if ( $multiple && $multiple > 1 ) {
			$multiple_attr = 'multiple';
			$name          .= '[]';

			if ( ! $value || $value == 'all' ) {
				$value = [];
			}
		}

		$select_class = $classes ? ' class="' . $classes . '"' : '';

		echo '	<tr class="field-' . $select_id . '">';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label for="' . $select_id . '">' . $label . '</label></div>';
		}
		echo '			<select id="' . $select_id . '" name="' . $name . '" ' . $multiple_attr . $select_class . '>';

		foreach ( $options as $key => $option ) {
			if ( $multiple_attr ) {
				$selected = selected( true, in_array( $key, $value ), false );
			}
			else {
				$selected = selected( $value, $key, false );
			}

			echo '			<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
		}

		echo '			</select>';
		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function radio_button_field( $name = '', $label = '', $options = array(), $description = '', $default = '' ) {

		$this->saved_fields( $name, 'radio' );

		$value = get_post_meta( $this->obj_id, $name, true );
		if ( $value === '' ) {
			$value = $default;
		}

		echo '	<tr class="field-' . $name . '">';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label>' . $label . '</label></div>';
		}

		echo '<div class="radio-buttons">';
		foreach ( $options as $key => $option ) {
			$id = $name . '-' . $key;
			echo '<div><input type="radio" id="' . $id . '" name="' . $name . '" value="' . $key . '" ' . checked( $value, $key, false ) . '><label for="' . $id . '"><img src="' . $option . '" alt=""></label></div>';
		}
		echo '</div>';

		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function price_package_field( $name = '', $label = '', $text = '', $description = '' ) {

		$this->saved_fields( $name, 'price_package_checkbox' );

		$value = get_post_meta( $this->obj_id, $name, true );
		if ( empty( $value ) ) {
			$value = [];
		}

		$posts_package = get_posts( [
			'post_type'      => 'pricepackage_wescle',
			'posts_per_page' => - 1,
			'orderby'        => [ 'menu_order' => 'ASC' ]
		] );

		echo '	<tr>';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label for="' . $name . '">' . $label . '</label></div>';
		}

		echo '<div class="posts_package">';
		foreach ( $posts_package as $post_package ) {
			echo '<div><input type="checkbox" id="field_' . $post_package->ID . '" name="' . $name . '[]" value="' . $post_package->ID . '" ' . checked( in_array( $post_package->ID, $value ), true, false ) . '> <label for="field_' . $post_package->ID . '">' . $post_package->post_title . '</label></div>';
		}
		echo '</div>';

		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function color_field( $name = '', $label = '', $text = '', $description = '' ) {

		$this->saved_fields( $name, 'color' );

		$value = get_post_meta( $this->obj_id, $name, true );
		if ( empty( $value ) ) {
			$value = '';
		}

		echo '	<tr>';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label>' . $label . '</label></div>';
		}
		echo '			<input type="text" class="input-color" data-alpha-enabled="true" name="' . $name . '" value="' . $value . '"> ' . $text;
		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function custom_field( $label = '', $description = '', $post_id = '' ) {
		$label       = str_replace( '%post_id%', $post_id, $label );
		$description = str_replace( '%post_id%', $post_id, $description );

		echo '	<tr class="field-custom">';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label>' . $label . '</label></div>';
		}
		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function number_field( $name = '', $label = '', $default = 0, $description = '', $text = '', $step = 1 ) {

		$this->saved_fields( $name, 'text' );

		$value = get_post_meta( $this->obj_id, $name, 1 );
		if ( empty( $value ) && $value !== '0' ) {
			$value = $default;
		}

		echo '	<tr class="field-' . $name . '">';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label for="' . $name . '">' . $label . '</label></div>';
		}
		echo '			<input type="number" id="' . $name . '" name="' . $name . '" value="' . esc_attr( $value ) . '" class="small-text" step="' . $step . '"> ' . $text;
		if ( ! empty( $description ) ) {
			echo '      <p class="description">' . $description . '</p>';
		}
		echo '		</td>';
		echo '	</tr>';
	}

	public function range_field( $name = '', $label = '', $default = 0, $min = '', $max = '', $step = 1 ) {

		$this->saved_fields( $name, 'range' );

		$value = get_post_meta( $this->obj_id, $name, 1 );
		if ( empty( $value ) && $value !== '0' ) {
			$value = $default;
		}

		echo '	<tr class="field-' . $name . '">';
		echo '		<td>';
		if ( ! empty( $label ) ) {
			echo '		<div><label for="' . $name . '">' . $label . '</label></div>';
		}
		echo '			<div class="wrapper-range">';
		echo '			    <input type="range" id="' . $name . '" name="' . $name . '" min="' . $min . '" max="' . $max . '" step="' . $step . '" value="' . esc_attr( $value ) . '"> ';
		echo '				<span class="slider-reset dashicons dashicons-image-rotate" data-default="' . $default . '"></span><span class="value"><input type="text" value="' . esc_attr( $value ) . '"/></span>';
		echo '			</div>';
		echo '		</td>';
		echo '	</tr>';
	}

	public function saved_fields( $name = '', $type = 'text' ) {
		$this->save_fields[] = array( 'name' => $name, 'type' => $type );
	}

}