<?php

class MetaBoxPopup extends MetaBoxPost {

	public function __construct() {
		$this->set_settings( array(
			'post_type'      => [ 'popup_wescle' ],
			'meta_box_title' => __( 'Настройки попапа', 'wescle' ),
		) );

		add_action( 'load-post.php', array( $this, 'init' ) );
		add_action( 'load-post-new.php', array( $this, 'init' ) );
	}

	public function set_fields() {
		$current_screen = get_current_screen();
		if ( in_array( $current_screen->post_type, $this->post_type ) ) {
			$logic_items = Helper::get_posts_and_category();
			unset( $logic_items['0_logic_all'] );

			$this->fields = [
				[
					'type'  => 'checkbox',
					'name'  => 'modal_on',
					'label' => __( 'Включить попап?', 'wescle' ),
				],
				[
					'type'     => 'select',
					'name'     => 'show_logic',
					'label'    => esc_html__( 'На каких страницах отображать?', 'wescle' ),
					'multiple' => 999,
					'options'  => array_merge(
						[ 'all' => __( 'Любая страница сайта', 'wescle' ) ],
						$logic_items
					),
				],
				[
					'type'        => 'custom',
					'name'        => '',
					'label'       => __( 'ID попапа', 'wescle' ) . ': <code>#wescle-modal-%post_id%</code>',
					'description' => __( 'Для показа попапа при клике', 'wescle' ) . ' ' .
					                 sprintf( __( 'пропишите в %s ID попапа', 'wescle' ), '<code>href</code>' ) .
					                 '<br>' . __( 'или просто добавьте CSS класс кнопке/ссылке', 'wescle' ) . ' <code>wescle-modal-%post_id%</code>'
				],
				[
					'type'    => 'select2',
					'name'    => 'modal_work',
					'label'   => __( 'Режим работы', 'wescle' ),
					'options' => [
						'click' => 'Вызывать при клике по кнопке/ссылке',
						'auto'  => 'Показывать автоматически', // data-open-by-time
					]
				],
				[
					'type'    => 'number',
					'name'    => 'auto_timer',
					'label'   => __( 'Через сколько секунд показывать попап после загрузки страницы?', 'wescle' ),
					'default' => 0,
				],
				[
					'type'    => 'radio_button',
					'name'    => 'type',
					'label'   => __( 'Вид', 'wescle' ),
					'default' => 1,
					'options' => [
						'1' => get_template_directory_uri() . '/assets/admin/img/metabox/modal-1.jpg',
						'2' => get_template_directory_uri() . '/assets/admin/img/metabox/modal-2.jpg',
						'3' => get_template_directory_uri() . '/assets/admin/img/metabox/modal-3.jpg',
						'4' => get_template_directory_uri() . '/assets/admin/img/metabox/modal-4.jpg',
						'5' => get_template_directory_uri() . '/assets/admin/img/metabox/modal-5.jpg',
					]
				],
				[
					'type'    => 'select',
					'name'    => 'overlay',
					'label'   => __( 'Затемнение фона', 'wescle' ),
					'options' => [
						''      => __( 'по умолчанию', 'wescle' ),
						'white' => __( 'Светлое', 'wescle' ),
						'dark'  => __( 'Темное', 'wescle' ),
					]
				],
				[
					'type'    => 'select',
					'name'    => 'cf7',
					'label'   => __( 'Контактная форма', 'wescle' ),
					'options' => Helper::get_posts( array(
						'post_type' => 'wpcf7_contact_form'
					), true ),
				],
				[
					'type'  => 'textarea',
					'name'  => 'text_bottom',
					'label' => __( 'Текст под формой', 'wescle' ),
				],
				[
					'type'        => 'number',
					'name'        => 'time_cookie',
					'label'       => __( 'Укажите время жизни куки', 'wescle' ),
					'description' => __( '* модальное окно будет показываться одному посетителю только один раз в X дней', 'wescle' ),
					'default'     => 1,
				],
			];
		}
	}
}