<?php

class MetaBoxPartner extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'  => 'checkbox',
				'name'  => 'featured',
				'label' => __( 'Избранный партнер?', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'site_url',
				'label' => __( 'Сайт, URL', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'site_label',
				'label' => __( 'Сайт, Надпись', 'wescle' ),
			],
			[
				'type'        => 'textarea',
				'name'        => 'phone',
				'label'       => __( 'Телефоны', 'wescle' ),
				'description' => __( 'каждый телефон с новой строки', 'wescle' ),
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'partner_wescle' ],
			'meta_box_title' => __( 'Настройки партнера', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}