<?php

class MetaBoxPage extends MetaBoxPost {

	public function __construct() {
		$this->set_settings( array(
			'post_type'      => [ 'page' ],
			'meta_box_title' => esc_html__( 'Настройки - Страница', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}

	public function set_fields() {
		$current_screen = get_current_screen();
		if ( in_array( $current_screen->post_type, $this->post_type ) ) {
			$this->fields = [];

			if ( isset( $_GET['post'] ) && 'templates/template-brands.php' === get_post_meta( $_GET['post'], '_wp_page_template', 1 ) ) {
				$args           = array(
					'public'      => true,
					'object_type' => [ 'product' ]
				);
				$taxonomies     = get_taxonomies( $args );
				$this->fields[] = [
					'type'    => 'select',
					'name'    => 'taxonomy_brand',
					'label'   => esc_html__( 'Выберите таксономию для брендов', 'wescle' ),
					'options' => array_merge( [ '' => __( 'Выбрать...', 'wescle' ) ], $taxonomies ),
				];

				$this->fields[] = [
					'type'    => 'text',
					'name'    => 'title_popular',
					'label'   => esc_html__( 'Заголовок для блока с популярными терминами', 'wescle' ),
					'default' => Helper::get_default_theme_data( 'title_popular' )
				];
				$this->fields[] = [
					'type'    => 'number',
					'name'    => 'count_popular',
					'label'   => esc_html__( 'Количество популярных брендов', 'wescle' ),
					'default' => 10
				];
				$this->fields[] = [
					'type'    => 'number',
					'name'    => 'column_width',
					'label'   => esc_html__( 'Ширина колонок', 'wescle' ) . ', px',
					'default' => 150
				];
				$this->fields[] = [
					'type'  => 'custom',
					'label' => '<hr>',
				];
			}

			$this->fields[] = [
				'type'        => 'checkbox',
				'name'        => 'hide_page_title',
				'label'       => esc_html__( 'Скрыть заголовок страницы?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			];
			$this->fields[] = [
				'type'        => 'checkbox',
				'name'        => 'hide_contents',
				'label'       => esc_html__( 'Скрыть "Cодержание поста"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			];

			$this->fields[] = [
				'type'        => 'checkbox',
				'name'        => 'hide_breadcrumbs',
				'label'       => esc_html__( 'Скрыть "Хлебные крошки"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			];

			if ( class_exists( 'WPCF7_Mail' ) ) {
				$this->fields[] = [
					'type'        => 'checkbox',
					'name'        => 'show_form_after_content',
					'label'       => esc_html__( 'Показывать контактную форму после контента', 'wescle' ),
					'placeholder' => esc_html__( 'Да', 'wescle' ),
					'description' => esc_html__( 'Выбрать форму можно в Customizer -> Настройка внутренних страниц', 'wescle' ),
				];

				$this->fields[] = [
					'type'  => 'text',
					'name'  => 'title_form_after_content',
					'label' => esc_html__( 'Заголовок для формы', 'wescle' ),
				];

				$this->fields[] = [
					'type'  => 'textarea',
					'name'  => 'text_form_after_content',
					'label' => esc_html__( 'Описание для формы', 'wescle' ),
				];
			}
		}
	}
}