<?php

class MetaBoxMosaic extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'  => 'text',
				'name'  => 'label',
				'label' => __( 'Лейбл', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'url',
				'label' => __( 'URL', 'wescle' ),
			],
			[
				'type'    => 'select',
				'name'    => 'type',
				'label'   => __( 'Вид карточки', 'wescle' ),
				'options' => [
					''         => esc_html__( 'Стандарт', 'wescle' ),
					'long'     => esc_html__( 'Большой', 'wescle' ),
					'vertical' => esc_html__( 'Вертикальный', 'wescle' ),
				]
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'mosaic_wescle' ],
			'meta_box_title' => __( 'Настройки', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}

new MetaBoxMosaic();