<?php

class MetaBoxLicense extends MetaBoxPost {

	protected $labels = [];

	public function __construct() {
		$this->set_settings( array(
			'post_type'      => [ 'license_wescle' ],
			'meta_box_title' => __( 'Настройки лицензии', 'wescle' ),
		) );

		add_action( 'load-post.php', array( $this, 'init' ) );
		add_action( 'load-post-new.php', array( $this, 'init' ) );

		add_action( 'load-post.php', array( $this, 'init_cpt' ) );
		add_action( 'load-post-new.php', array( $this, 'init_cpt' ) );
	}

	public function set_fields() {
		$current_screen = get_current_screen();
		if ( in_array( $current_screen->post_type, $this->post_type ) ) {
			$this->fields = [
				[
					'type'  => 'checkbox',
					'name'  => 'is_special',
					'label' => __( 'Спец. условия?', 'wescle' ),
				],
				[
					'type'  => 'color',
					'name'  => 'color_gradient1',
					'label' => __( 'Градиент на плашке', 'wescle' ),
				],
				[
					'type'  => 'color',
					'name'  => 'color_text',
					'label' => __( 'Цвет текста', 'wescle' ),
				],
				[
					'type'  => 'color',
					'name'  => 'color_bg',
					'label' => __( 'Цвет фона', 'wescle' ),
				],
				[
					'type'        => 'select2',
					'name'        => 'related_product',
					'label'       => __( 'Укажите связь с продуктом', 'wescle' ),
					'options'     => Helper::get_posts( array(
						'post_type'      => 'product',
						'posts_per_page' => 200
					), true ),
					'description' => esc_html__( 'или ниже заполните поля с ценой', 'wescle' )
				],
				[
					'type'  => 'text_html',
					'name'  => 'price',
					'label' => __( 'Цена', 'wescle' ),
				],
				[
					'type'  => 'text',
					'name'  => 'sale_price',
					'label' => __( 'Цена распродажи', 'wescle' ),
				],
				[
					'type'  => 'text',
					'name'  => 'label_button',
					'label' => __( 'Надпись на кнопке', 'wescle' ),
				],
				[
					'type'        => 'text',
					'name'        => 'button_url',
					'label'       => esc_html__( 'Если нужно - то укажите URL для кнопки заказа', 'wescle' ),
					'description' => esc_html__( 'по умолчанию открывается выбранный продукт или модальное окно с формой заказа', 'wescle' )
				]
			];
		}
	}

	public function init_cpt() {
		$this->labels = [
			'type'            => __( 'Тип', 'wescle' ),
			'type_plus'       => __( 'Преимущество', 'wescle' ),
			'type_minus'      => __( 'Недостаток', 'wescle' ),
			'title'           => __( 'Заголовок', 'wescle' ),
			'text'            => __( 'Всплывающая подсказка', 'wescle' ),
			'button_remove'   => __( 'Удалить', 'wescle' ),
			'button_add_item' => __( 'Добавить', 'wescle' ),
		];

		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );
	}

	public function add_meta_box( $post_type ) {
		$post_types = array( 'license_wescle' );

		if ( in_array( $post_type, $post_types ) ) {
			add_meta_box(
				'wescle_license_info',
				__( 'Преимущества и недостатки', 'wescle' ),
				array( $this, 'render_meta_box_content' ),
				$post_type,
				'advanced',
				'low'
			);
		}
	}

	public function save( $post_id ) {

		if ( ! isset( $_POST['wescle_license_info_nonce'] ) ) {
			return;
		}

		$nonce = $_POST['wescle_license_info_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'wescle_license_info' ) ) {
			return;
		}

		// Если это автосохранение ничего не делаем.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Проверяем права пользователя.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		$wescle_license_info = $_POST['wescle_license_info'];

		$data = [];
		if ( $wescle_license_info ) {
			foreach ( $wescle_license_info['title'] as $key => $title ) {
				$type = $wescle_license_info['type'][ $key ];
				$text = $wescle_license_info['text'][ $key ];

				if ( $title || $text ) {
					$data[] = [
						'type'  => $type,
						'title' => $title,
						'text'  => $text,
					];
				}
			}
		}

		update_post_meta( $post_id, 'wescle_license_info', $data );
	}

	public function render_meta_box_content( $post ) {
		$wescle_license_info = get_post_meta( $post->ID, 'wescle_license_info', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_license_info', 'wescle_license_info_nonce' ); ?>

            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $wescle_license_info ) {
						foreach ( $wescle_license_info as $item ) {
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['type']; ?>
                                        <select class="widefat" name="wescle_license_info[type][]">
                                            <option value="plus" <?php selected( 'plus', $item['type'] ); ?>><?php echo $this->labels['type_plus']; ?></option>
                                            <option value="minus" <?php selected( 'minus', $item['type'] ); ?>><?php echo $this->labels['type_minus']; ?></option>
                                        </select>
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['title']; ?>
                                        <input type="text" class="widefat" name="wescle_license_info[title][]" value="<?php echo esc_attr( $item['title'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field" style="width: 20%">
                                    <label>
										<?php echo $this->labels['text']; ?>
                                        <textarea class="widefat" name="wescle_license_info[text][]" rows="4"><?php echo esc_textarea( $item['text'] ); ?></textarea>
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['type']; ?>
                                    <select class="widefat" name="wescle_license_info[type][]">
                                        <option value="plus"><?php echo $this->labels['type_plus']; ?></option>
                                        <option value="minus"><?php echo $this->labels['type_minus']; ?></option>
                                    </select>
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['title']; ?>
                                    <input type="text" class="widefat" name="wescle_license_info[title][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field" style="width: 20%">
                                <label>
									<?php echo $this->labels['text']; ?>
                                    <textarea class="widefat" name="wescle_license_info[text][]" rows="4"></textarea>
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}
}

new MetaBoxLicense();