<?php

class MetaBoxLanding {

	protected $labels = [];

	public function __construct() {
		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}

	public function init() {
		$this->labels = [
			'title_icon'           => __( 'Изображение', 'wescle' ),
			'button_icon'          => __( 'Выбрать изображение', 'wescle' ),
			'button_add'           => __( 'Добавить', 'wescle' ),
			'button_remove'        => __( 'Удалить', 'wescle' ),
			'overlay_off'          => __( 'Отключить оверлай?', 'wescle' ),
			'title'                => __( 'Заголовок', 'wescle' ),
			'title_string'         => __( 'Строка', 'wescle' ),
			'title_advantage'      => __( 'Преимущество', 'wescle' ),
			'text'                 => __( 'Текст', 'wescle' ),
			'text_width'           => __( 'Ширина текста', 'wescle' ),
			'text_color'           => __( 'Цвет текста', 'wescle' ),
			'price'                => __( 'Цена', 'wescle' ),
			'price_old'            => __( 'Старая цена', 'wescle' ),
			'button_link'          => __( 'Ссылка', 'wescle' ),
			'button_link_is_blank' => __( 'Открывать ссылку в новом окне?', 'wescle' ),
			'button_text'          => __( 'Надпись на кнопке', 'wescle' ),
			'button_add_item'      => __( 'Добавить баннер', 'wescle' ),
			'button_add_slide'     => __( 'Добавить слайд', 'wescle' ),
			'button_add_string'    => __( 'Добавить строку', 'wescle' ),
			'button_add_button'    => __( 'Добавить кнопку', 'wescle' ),
			'button_add_advantage' => __( 'Добавить преимущество', 'wescle' ),
			'text_align_h'         => __( 'Горизонтальное выравнивание текста', 'wescle' ),
			'text_align_v'         => __( 'Вертикальное выравнивание текста', 'wescle' ),
			'text_align_left'      => __( 'по левому краю', 'wescle' ),
			'text_align_center'    => __( 'по центру', 'wescle' ),
			'text_align_end'       => __( 'по правому краю', 'wescle' ),
			'text_align_bottom'    => __( 'снизу', 'wescle' ),
			'text_align_top'       => __( 'сверху', 'wescle' ),
			'title_file'           => __( 'Файл *.mp4', 'wescle' ),
			'video_autoplay'       => __( 'Автовоспроизведение', 'wescle' ),
			'video_loop'           => __( 'Зациклить видео', 'wescle' ),
			'video_control'        => __( 'Кнопки управления видео', 'wescle' ),
			'video_yt'             => __( 'или ссылка на Youtube', 'wescle' ),
		];

		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}

	public function add_meta_box( $post_type ) {
		global $post;
		$post_types = array( 'page' );

		if ( in_array( $post_type, $post_types ) ) {
			if ( Helper::is_gutenberg_active() ) {
				add_meta_box(
					'wescle_landing_info',
					__( 'Настройки лендинга', 'wescle' ),
					array( $this, 'render_meta_box_content' ),
					$post_type,
					'advanced',
					'high'
				);
			}
		}
	}

	public function save( $post_id ) {

		if ( ! isset( $_POST['wescle_landing_info_nonce'] ) ) {
			return;
		}

		$nonce = $_POST['wescle_landing_info_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'wescle_landing_info' ) ) {
			return;
		}

		// Если это автосохранение ничего не делаем.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Проверяем права пользователя.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		update_post_meta( $post_id, 'content_box', $_POST['content_box'] );
		update_post_meta( $post_id, 'content_box_width', $_POST['content_box_width'] );
		update_post_meta( $post_id, 'content_box_inner_width', $_POST['content_box_inner_width'] );

		$slider_layout = $_POST['slider_layout'];
		update_post_meta( $post_id, 'slider_layout', $slider_layout );

		if ( 'none' == $slider_layout ) {
			delete_post_meta( $post_id, 'slider_autoplay_speed' );
			delete_post_meta( $post_id, 'slider_dots' );
			delete_post_meta( $post_id, 'slider_arrows' );
			delete_post_meta( $post_id, 'slider_image_without_gradient' );
			delete_post_meta( $post_id, 'slider_image_opacity' );
			delete_post_meta( $post_id, 'home_slider_carousel_color_bg' );
		}
		else {
			update_post_meta( $post_id, 'slider_autoplay_speed', $_POST['slider_autoplay_speed'] );

			if ( isset( $_POST['slider_dots'] ) ) {
				update_post_meta( $post_id, 'slider_dots', 1 );
			}
			else {
				update_post_meta( $post_id, 'slider_dots', 0 );
			}

			if ( isset( $_POST['slider_arrows'] ) ) {
				update_post_meta( $post_id, 'slider_arrows', 1 );
			}
			else {
				update_post_meta( $post_id, 'slider_arrows', 0 );
			}

			if ( isset( $_POST['slider_image_without_gradient'] ) ) {
				update_post_meta( $post_id, 'slider_image_without_gradient', 1 );
			}
			else {
				delete_post_meta( $post_id, 'slider_image_without_gradient' );
			}
			update_post_meta( $post_id, 'slider_image_opacity', $_POST['slider_image_opacity'] );
			update_post_meta( $post_id, 'home_slider_carousel_color_bg', $_POST['home_slider_carousel_color_bg'] );

			if ( isset( $_POST['slider_columns_fullwidth'] ) ) {
				update_post_meta( $post_id, 'slider_columns_fullwidth', 1 );
			}
			else {
				delete_post_meta( $post_id, 'slider_columns_fullwidth' );
			}

			if ( isset( $_POST['slider_columns_fullheight'] ) ) {
				update_post_meta( $post_id, 'slider_columns_fullheight', 1 );
			}
			else {
				delete_post_meta( $post_id, 'slider_columns_fullheight' );
			}
		}

		if ( in_array( $slider_layout, [ 'columns_two', 'columns_one', 'columns_four' ] ) ) {
			update_post_meta( $post_id, 'slider_columns_two_category', @$_POST['slider_columns_two_category'] );
			update_post_meta( $post_id, 'slider_columns_two_limit', intval( $_POST['slider_columns_two_limit'] ) );
			update_post_meta( $post_id, 'slider_columns_two_posts', @$_POST['slider_columns_two_posts'] );
			update_post_meta( $post_id, 'slider_columns_two_meta', $_POST['sortable_meta'] );

			foreach ( choices_visibility_meta( true ) as $key => $label ) {
				$data_key = 'slider_columns_two_visibility_' . $key;
				if ( isset( $_POST[ $data_key ] ) ) {
					update_post_meta( $post_id, $data_key, $_POST[ $data_key ] );
				}
				else {
					update_post_meta( $post_id, $data_key, 0 );
				}
			}
		}

		if ( in_array( $slider_layout, [ 'columns_one_two', 'columns_one_four' ] ) ) {
			update_post_meta( $post_id, 'slider_left_block_category', @$_POST['slider_left_block_category'] );
			update_post_meta( $post_id, 'slider_left_block_category_posts', @$_POST['slider_left_block_category_posts'] );
			update_post_meta( $post_id, 'slider_left_block_sortable_meta', @$_POST['slider_left_block_sortable_meta'] );
			foreach ( choices_visibility_meta( true ) as $key => $label ) {
				$data_key = 'slider_left_block_visibility_' . $key;
				if ( isset( $_POST[ $data_key ] ) ) {
					update_post_meta( $post_id, $data_key, $_POST[ $data_key ] );
				}
				else {
					update_post_meta( $post_id, $data_key, 0 );
				}
			}

			update_post_meta( $post_id, 'slider_right_block_offset', intval( $_POST['slider_right_block_offset'] ) );
			update_post_meta( $post_id, 'slider_right_block_category', @$_POST['slider_right_block_category'] );
			update_post_meta( $post_id, 'slider_right_block_category_posts', @$_POST['slider_right_block_category_posts'] );
			update_post_meta( $post_id, 'slider_right_block_sortable_meta', @$_POST['slider_right_block_sortable_meta'] );
			foreach ( choices_visibility_meta( true ) as $key => $label ) {
				$data_key = 'slider_right_block_visibility_' . $key;
				if ( isset( $_POST[ $data_key ] ) ) {
					update_post_meta( $post_id, $data_key, $_POST[ $data_key ] );
				}
				else {
					update_post_meta( $post_id, $data_key, 0 );
				}
			}
		}

		if ( 'banner' == $slider_layout ) {
			if ( isset( $_POST['slider_banner_title_is_h1'] ) ) {
				update_post_meta( $post_id, 'slider_banner_title_is_h1', 1 );
			}
			else {
				delete_post_meta( $post_id, 'slider_banner_title_is_h1' );
			}

			update_post_meta( $post_id, 'slider_banner_slider_effect', $_POST['slider_banner_slider_effect'] );

			$data = [];

			$wescle_slider_banners = $_POST['wescle_slider_banners'];
			if ( $wescle_slider_banners ) {
				$text_width_key = 0;
				foreach ( $wescle_slider_banners['image'] as $key => $img_id ) {
					if ( ! $img_id && ! $wescle_slider_banners['video'][ $key ] ) {
						continue;
					}

					$data[] = [
						'image'          => $wescle_slider_banners['image'][ $key ],
						'title'          => $wescle_slider_banners['title'][ $key ],
						'text'           => $wescle_slider_banners['text'][ $key ],
						'text_h_align'   => $wescle_slider_banners['text_h_align'][ $key ],
						'text_v_align'   => $wescle_slider_banners['text_v_align'][ $key ],
						'text_width'     => $wescle_slider_banners['text_width'][ $text_width_key ],
						'text_color'     => $wescle_slider_banners['text_color'][ $key ],
						'button_link'    => $wescle_slider_banners['button_link'][ $key ],
						'button_text'    => $wescle_slider_banners['button_text'][ $key ],
						'button_link2'   => $wescle_slider_banners['button_link2'][ $key ],
						'button_text2'   => $wescle_slider_banners['button_text2'][ $key ],
						'video'          => $wescle_slider_banners['video'][ $key ],
						'video_autoplay' => $wescle_slider_banners['video_autoplay'][ $key ] ?? '',
						'video_loop'     => $wescle_slider_banners['video_loop'][ $key ] ?? '',
						'video_control'  => $wescle_slider_banners['video_control'][ $key ] ?? '',
						'video_yt'       => $wescle_slider_banners['video_yt'][ $key ],
					];

					$text_width_key ++;
				}
			}
			update_post_meta( $post_id, 'wescle_slider_banners', $data );

			update_post_meta( $post_id, 'slider_banner_height_desktop', $_POST['slider_banner_height_desktop'] );
			update_post_meta( $post_id, 'slider_banner_height_tablet', $_POST['slider_banner_height_tablet'] );
			update_post_meta( $post_id, 'slider_banner_height_mobile', $_POST['slider_banner_height_mobile'] );
		}

		if ( 'store' == $slider_layout ) {
			if ( isset( $_POST['slider_banner_title_is_h1'] ) ) {
				update_post_meta( $post_id, 'slider_banner_title_is_h1', 1 );
			}
			else {
				delete_post_meta( $post_id, 'slider_banner_title_is_h1' );
			}

			if ( isset( $_POST['slider_store_menu_enabled'] ) ) {
				update_post_meta( $post_id, 'slider_store_menu_enabled', 1 );
			}
			else {
				update_post_meta( $post_id, 'slider_store_menu_enabled', 0 );
			}

			if ( isset( $_POST['slider_store_one_fullwidth'] ) ) {
				update_post_meta( $post_id, 'slider_store_one_fullwidth', 1 );
			}
			else {
				update_post_meta( $post_id, 'slider_store_one_fullwidth', 0 );
			}

			if ( isset( $_POST['slider_store_one_fullheight'] ) ) {
				update_post_meta( $post_id, 'slider_store_one_fullheight', 1 );
			}
			else {
				update_post_meta( $post_id, 'slider_store_one_fullheight', 0 );
			}

			if ( isset( $_POST['slider_store_two_enabled'] ) ) {
				update_post_meta( $post_id, 'slider_store_two_enabled', 1 );
			}
			else {
				update_post_meta( $post_id, 'slider_store_two_enabled', 0 );
			}

			update_post_meta( $post_id, 'slider_store_one_type', $_POST['slider_store_one_type'] );
			update_post_meta( $post_id, 'slider_store_one_category', @$_POST['slider_store_one_category'] );
			update_post_meta( $post_id, 'slider_store_one_limit', $_POST['slider_store_one_limit'] );
			update_post_meta( $post_id, 'slider_store_one_products', @$_POST['slider_store_one_products'] );
			update_post_meta( $post_id, 'slider_store_one_button_label', $_POST['slider_store_one_button_label'] );
			update_post_meta( $post_id, 'slider_store_one_color_title', $_POST['slider_store_one_color_title'] );
			update_post_meta( $post_id, 'slider_store_one_color_price', $_POST['slider_store_one_color_price'] );

			update_post_meta( $post_id, 'slider_store_two_type', $_POST['slider_store_two_type'] );
			update_post_meta( $post_id, 'slider_store_two_category', @$_POST['slider_store_two_category'] );
			update_post_meta( $post_id, 'slider_store_two_limit', $_POST['slider_store_two_limit'] );
			update_post_meta( $post_id, 'slider_store_two_products', @$_POST['slider_store_two_products'] );
			update_post_meta( $post_id, 'slider_store_two_color_title', $_POST['slider_store_two_color_title'] );
			update_post_meta( $post_id, 'slider_store_two_color_price', $_POST['slider_store_two_color_price'] );

			$data                 = [];
			$wescle_slider_slides = $_POST['slider_store_one_slides'];
			if ( $wescle_slider_slides ) {
				foreach ( $wescle_slider_slides['image'] as $key => $img_id ) {
					if ( ! $img_id && ! $wescle_slider_slides['video'][ $key ] ) {
						continue;
					}

					$data[] = [
						'image'            => $wescle_slider_slides['image'][ $key ],
						'title'            => $wescle_slider_slides['title'][ $key ],
						'text'             => $wescle_slider_slides['text'][ $key ],
						'woo_text_h_align' => $wescle_slider_slides['woo_text_h_align'][ $key ],
						'woo_text_v_align' => $wescle_slider_slides['woo_text_v_align'][ $key ],
						'price'            => $wescle_slider_slides['price'][ $key ],
						'price_old'        => $wescle_slider_slides['price_old'][ $key ],
						'button_label'     => $wescle_slider_slides['button_label'][ $key ],
						'button_url'       => $wescle_slider_slides['button_url'][ $key ],
						'button_label2'    => $wescle_slider_slides['button_label2'][ $key ],
						'button_url2'      => $wescle_slider_slides['button_url2'][ $key ],
						'video'            => $wescle_slider_slides['video'][ $key ],
						'video_autoplay'   => $wescle_slider_slides['video_autoplay'][ $key ] ?? '',
						'video_loop'       => $wescle_slider_slides['video_loop'][ $key ] ?? '',
						'video_control'    => $wescle_slider_slides['video_control'][ $key ] ?? '',
						'video_yt'         => $wescle_slider_slides['video_yt'][ $key ],
					];
				}
			}
			update_post_meta( $post_id, 'slider_store_one_slides', $data );

			$data                 = [];
			$wescle_slider_slides = $_POST['slider_store_two_slides'];
			if ( $wescle_slider_slides ) {
				foreach ( $wescle_slider_slides['image'] as $key => $img_id ) {
					if ( ! $img_id ) {
						continue;
					}

					$data[] = [
						'image'            => $wescle_slider_slides['image'][ $key ],
						'title'            => $wescle_slider_slides['title'][ $key ],
						'woo_text_h_align' => $wescle_slider_slides['woo_text_h_align'][ $key ],
						'woo_text_v_align' => $wescle_slider_slides['woo_text_v_align'][ $key ],
						'price'            => $wescle_slider_slides['price'][ $key ],
						'price_old'        => $wescle_slider_slides['price_old'][ $key ],
						'button_url'       => $wescle_slider_slides['button_url'][ $key ],
					];
				}
			}
			update_post_meta( $post_id, 'slider_store_two_slides', $data );
		}

		if ( 'store' == $slider_layout || 'banner' == $slider_layout || 'animated' == $slider_layout || 'parallax' == $slider_layout ) {
			update_post_meta( $post_id, 'slider_button_type', $_POST['slider_button_type'] );
			update_post_meta( $post_id, 'slider_button_color', $_POST['slider_button_color'] );
			update_post_meta( $post_id, 'slider_button_color_hover', $_POST['slider_button_color_hover'] );
			update_post_meta( $post_id, 'slider_button_bg', $_POST['slider_button_bg'] );
			update_post_meta( $post_id, 'slider_button_bg_hover', $_POST['slider_button_bg_hover'] );
			update_post_meta( $post_id, 'slider_button_border', $_POST['slider_button_border'] );
			update_post_meta( $post_id, 'slider_button_border_hover', $_POST['slider_button_border_hover'] );
			update_post_meta( $post_id, 'slider_button_blick_color', $_POST['slider_button_blick_color'] );
			update_post_meta( $post_id, 'slider_button_blick_color_hover', $_POST['slider_button_blick_color_hover'] );
			update_post_meta( $post_id, 'slider_button_blick_speed', $_POST['slider_button_blick_speed'] );
		}

		if ( 'animated' == $slider_layout ) {
			$data  = [];
			$items = $_POST['animated_title_text_items'];
			if ( $items ) {
				foreach ( $items['item_text'] as $key => $item_text ) {
					if ( ! $item_text ) {
						continue;
					}

					$data[] = [
						'item_text'  => $items['item_text'][ $key ],
						'item_color' => $items['item_color'][ $key ]
					];
				}
			}
			update_post_meta( $post_id, 'animated_title_text_items', $data );

			$data  = [];
			$items = $_POST['animated_buttons'];
			if ( $items ) {
				foreach ( $items['button_text'] as $key => $button_text ) {
					if ( ! $button_text ) {
						continue;
					}

					$data[] = [
						'button_text' => $items['button_text'][ $key ],
						'button_url'  => $items['button_url'][ $key ],
						'is_blank'    => $items['is_blank'][ $key ] ?? ''
					];
				}
			}
			update_post_meta( $post_id, 'animated_buttons', $data );

			$data       = [];
			$text_items = $_POST['animated_advantages'];
			if ( $text_items ) {
				foreach ( $text_items as $item ) {
					if ( ! $item ) {
						continue;
					}

					$data[] = [
						'item_text' => $item
					];
				}
			}
			update_post_meta( $post_id, 'animated_advantages', $data );

			update_post_meta( $post_id, 'animated_label_text', $_POST['animated_label_text'] );
			update_post_meta( $post_id, 'animated_label_href', $_POST['animated_label_href'] );
			update_post_meta( $post_id, 'animated_title_1', $_POST['animated_title_1'] );
			update_post_meta( $post_id, 'parallax_title_type', $_POST['parallax_title_type'] );

			update_post_meta( $post_id, 'animated_title_2', $_POST['animated_title_2'] );
			update_post_meta( $post_id, 'animated_title_3', $_POST['animated_title_3'] );
			update_post_meta( $post_id, 'animated_bg_image_1', $_POST['animated_bg_image_1'] );
			update_post_meta( $post_id, 'animated_play_label', $_POST['animated_play_label'] );
			update_post_meta( $post_id, 'animated_video_href', $_POST['animated_video_href'] );

			update_post_meta( $post_id, 'animated_label_text_color', $_POST['animated_label_text_color'] );
			update_post_meta( $post_id, 'animated_label_bg_color', $_POST['animated_label_bg_color'] );
			update_post_meta( $post_id, 'animated_title_2_color', $_POST['animated_title_2_color'] );
			update_post_meta( $post_id, 'animated_advantages_img_color', $_POST['animated_advantages_img_color'] );
			update_post_meta( $post_id, 'animated_play_bg_color', $_POST['animated_play_bg_color'] );
			update_post_meta( $post_id, 'animated_play_color', $_POST['animated_play_color'] );
			update_post_meta( $post_id, 'animated_play_border_color', $_POST['animated_play_border_color'] );
			update_post_meta( $post_id, 'animated_play_color_text', $_POST['animated_play_color_text'] );

			update_post_meta( $post_id, 'animated_position_content', $_POST['animated_position_content'] );
			update_post_meta( $post_id, 'backgroundImage', $_POST['backgroundImage'] );
			update_post_meta( $post_id, 'backgroundImageTablet', $_POST['backgroundImageTablet'] );
			update_post_meta( $post_id, 'backgroundImagePhone', $_POST['backgroundImagePhone'] );
			update_post_meta( $post_id, 'animated_image_bg_fit', $_POST['animated_image_bg_fit'] );
			update_post_meta( $post_id, 'animated_image_bg_fit_tablet', $_POST['animated_image_bg_fit_tablet'] );
			update_post_meta( $post_id, 'animated_image_bg_fit_mobile', $_POST['animated_image_bg_fit_mobile'] );
		}

		if ( 'parallax' == $slider_layout ) {
			$data  = [];
			$items = $_POST['parallax_text_items'];
			if ( $items ) {
				foreach ( $items['text'] as $key => $item_text ) {
					if ( ! $item_text ) {
						continue;
					}

					$data[] = [
						'image' => $items['image'][ $key ],
						'text'  => $items['text'][ $key ]
					];
				}
			}
			update_post_meta( $post_id, 'parallax_text_items', $data );

			update_post_meta( $post_id, 'parallax_color_text', $_POST['parallax_color_text'] );

			update_post_meta( $post_id, 'animated_label_text', $_POST['animated_label_text'] );
			update_post_meta( $post_id, 'animated_label_text_color', $_POST['animated_label_text_color'] );
			update_post_meta( $post_id, 'animated_label_bg_color', $_POST['animated_label_bg_color'] );
			update_post_meta( $post_id, 'parallax_title_1', $_POST['parallax_title_1'] );
			update_post_meta( $post_id, 'parallax_title_type', $_POST['parallax_title_type'] );
			update_post_meta( $post_id, 'parallax_button_label', $_POST['parallax_button_label'] );
			update_post_meta( $post_id, 'parallax_button_url', $_POST['parallax_button_url'] );
			update_post_meta( $post_id, 'parallax_text_button', $_POST['parallax_text_button'] );
			update_post_meta( $post_id, 'parallax_text_button_bg', $_POST['parallax_text_button_bg'] );
			update_post_meta( $post_id, 'parallax_text_after_button', $_POST['parallax_text_after_button'] );
			update_post_meta( $post_id, 'parallax_bg_image_1', $_POST['parallax_bg_image_1'] );
			update_post_meta( $post_id, 'parallax_bg_image_2', $_POST['parallax_bg_image_2'] );

			update_post_meta( $post_id, 'animated_position_content', $_POST['animated_position_content'] );
			update_post_meta( $post_id, 'backgroundImage', $_POST['backgroundImage'] );
			update_post_meta( $post_id, 'backgroundImageTablet', $_POST['backgroundImageTablet'] );
			update_post_meta( $post_id, 'backgroundImagePhone', $_POST['backgroundImagePhone'] );
			update_post_meta( $post_id, 'animated_image_bg_fit', $_POST['animated_image_bg_fit'] );
			update_post_meta( $post_id, 'animated_image_bg_fit_tablet', $_POST['animated_image_bg_fit_tablet'] );
			update_post_meta( $post_id, 'animated_image_bg_fit_mobile', $_POST['animated_image_bg_fit_mobile'] );
		}
	}

	public function enqueue_scripts() {
		$screen = get_current_screen();
		if ( $screen && 'post' == $screen->base && 'page' == $screen->post_type ) {
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'wp-color-picker-alpha', get_template_directory_uri() . '/assets/admin/js/wp-color-picker-alpha.min.js', array( 'wp-color-picker' ), '3.0.0', true );

			wp_enqueue_script( 'selectWoo', get_template_directory_uri() . '/libs/wscl/assets/vendor/selectWoo/js/select2.min.js', array( 'jquery' ), '1.0.1', true );
			wp_enqueue_style( 'selectWoo', get_template_directory_uri() . '/libs/wscl/assets/vendor/selectWoo/css/selectWoo.css', array(), '1.0.1' );
		}
	}

	public function render_meta_box_content( $post ) {
		wp_enqueue_media();
		add_action( 'admin_print_footer_scripts', [ $this, 'script_landing_info' ], 99 );

		$meta_sortable = $this->sortable_card_blocks();

		$slider_layout         = get_post_meta( $post->ID, 'slider_layout', 1 );
		$slider_autoplay_speed = get_post_meta( $post->ID, 'slider_autoplay_speed', 1 );
		if ( ! $slider_autoplay_speed ) {
			$slider_autoplay_speed = 8;
		}
		$slider_dots = get_post_meta( $post->ID, 'slider_dots', 1 );
		if ( $slider_dots === '' ) {
			$slider_dots = 1;
		}
		$slider_arrows = get_post_meta( $post->ID, 'slider_arrows', 1 );

		$slider_image_without_gradient = get_post_meta( $post->ID, 'slider_image_without_gradient', 1 );
		$slider_image_opacity          = get_post_meta( $post->ID, 'slider_image_opacity', 1 );
		if ( ! $slider_image_opacity ) {
			$slider_image_opacity = 100;
		}
		$home_slider_carousel_color_bg = get_post_meta( $post->ID, 'home_slider_carousel_color_bg', 1 );
		?>
        <div class="wescle-metabox wescle-metabox-landing_info" style="display: none1">
			<?php wp_nonce_field( 'wescle_landing_info', 'wescle_landing_info_nonce' ); ?>

            <div id="wescle_landing_settings_info" style="padding-top: 10px;">
                <span class="customize-control-title"><?php _e( 'Для отображения настроек выберите шаблон страницы как "Landing Wescle"', 'wescle' ); ?></span>
            </div>
            <div id="wescle_landing_settings" style="display: none;">
                <ul class="control-section open form-table-custom">
                    <li id="customize-control-content_box" class="customize-control" style="">
                        <div>
                            <span class="customize-control-title"><?php esc_html_e( 'Ширина лендинга', 'wescle' ); ?></span>
                        </div>
						<?php
						$value = get_post_meta( $post->ID, 'content_box', 1 );
						if ( ! $value ) {
							$value = get_theme_mod( 'content_box', 'box' );
						}
						?>
                        <label class="wrap-input-checkbox">
                            <input type="radio" class="landing_content_box" name="content_box" value="default" <?php checked( $value, 'default' ); ?>>
							<?php esc_html_e( 'На всю ширину', 'wescle' ); ?>
                        </label>
                        <label class="wrap-input-checkbox">
                            <input type="radio" class="landing_content_box" name="content_box" value="box" <?php checked( $value, 'box' ); ?>>
							<?php esc_html_e( 'Ограниченная ширина', 'wescle' ); ?>
                        </label>
                        <label class="wrap-input-checkbox">
                            <input type="radio" class="landing_content_box" name="content_box" value="box_inner" <?php checked( $value, 'box_inner' ); ?>>
							<?php esc_html_e( 'Ограниченная ширина контентной части', 'wescle' ); ?>
                        </label>
                    </li>
                    <li id="customize-control-content_box_width" class="customize-control customize-control-kirki-slider">
                        <label>
                            <span class="customize-control-title"><?php esc_html_e( 'Максимальная ширина', 'wescle' ); ?></span>
							<?php
							$value = get_post_meta( $post->ID, 'content_box_width', 1 );
							if ( ! $value ) {
								$value = 1280;
							}
							?>
                            <div class="wrapper">
                                <div class="wrapper-range">
                                    <input type="range" name="content_box_width" min="1000" max="1920" step="10" value="<?php echo $value; ?>">
                                    <span class="slider-reset dashicons dashicons-image-rotate" data-default="1280"></span>
                                    <span class="value"><input type="text" value="<?php echo $value; ?>"></span>
                                </div>
                            </div>
                        </label>
                    </li>
                    <li id="customize-control-content_box_inner_width" class="customize-control customize-control-kirki-slider">
                        <label>
                            <span class="customize-control-title"><?php esc_html_e( 'Максимальная ширина контентной части', 'wescle' ); ?></span>
							<?php
							$value = get_post_meta( $post->ID, 'content_box_inner_width', 1 );
							if ( ! $value ) {
								$value = 1280;
							}
							?>
                            <div class="wrapper">
                                <div class="wrapper-range">
                                    <input type="range" name="content_box_inner_width" min="1000" max="1920" step="10" value="<?php echo $value; ?>">
                                    <span class="slider-reset dashicons dashicons-image-rotate" data-default="1280"></span>
                                    <span class="value"><input type="text" value="<?php echo $value; ?>"></span>
                                </div>
                            </div>
                        </label>
                    </li>

                    <li id="landing-slider_layout" class="customize-control customize-control-kirki-radio-image">
                        <label class="customizer-text">
                            <span class="customize-control-title"><?php _e( 'Выбрать шаблон "Первого экрана"', 'wescle' ); ?></span>
                            <span class="description customize-control-description"><?php _e( 'Каждый раз при смене шаблона активируются новые настройки.', 'wescle' ); ?></span>
                        </label>
                        <div id="input_slider_layout" class="image">
                            <input class="image-select" type="radio" value="none" name="slider_layout" checked="checked" id="slider_layoutnone" <?php checked( $slider_layout, 'none' ); ?>>
                            <label for="slider_layoutnone" class="slider_layoutnone">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/sidebar-none.png">
                                <span class="image-clickable"></span>
                            </label>
                            <input class="image-select" type="radio" value="columns_two" name="slider_layout" id="slider_layoutcolumns_two" <?php checked( $slider_layout, 'columns_two' ); ?>>
                            <label for="slider_layoutcolumns_two" class="slider_layoutcolumns_two">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/columns_two.png">
                                <span class="image-clickable"></span>
                            </label>
                            <input class="image-select" type="radio" value="columns_one" name="slider_layout" id="slider_layoutcolumns_one" <?php checked( $slider_layout, 'columns_one' ); ?>>
                            <label for="slider_layoutcolumns_one" class="slider_layoutcolumns_one">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/columns_one.png">
                                <span class="image-clickable"></span>
                            </label>
                            <input class="image-select" type="radio" value="columns_four" name="slider_layout" id="slider_layoutcolumns_four" <?php checked( $slider_layout, 'columns_four' ); ?>>
                            <label for="slider_layoutcolumns_four" class="slider_layoutcolumns_four">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/columns_four.png">
                                <span class="image-clickable"></span>
                            </label>
                            <input class="image-select" type="radio" value="columns_one_two" name="slider_layout" id="slider_layoutcolumns_one_two" <?php checked( $slider_layout, 'columns_one_two' ); ?>>
                            <label for="slider_layoutcolumns_one_two" class="slider_layoutcolumns_one_two">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/columns_one_two.png">
                                <span class="image-clickable"></span>
                            </label>
                            <input class="image-select" type="radio" value="columns_one_four" name="slider_layout" id="slider_layoutcolumns_one_four" <?php checked( $slider_layout, 'columns_one_four' ); ?>>
                            <label for="slider_layoutcolumns_one_four" class="slider_layoutcolumns_one_four">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/columns_one_four.png">
                                <span class="image-clickable"></span>
                            </label>
                            <input class="image-select" type="radio" value="banner" name="slider_layout" id="slider_layoutbanner" <?php checked( $slider_layout, 'banner' ); ?>>
                            <label for="slider_layoutbanner" class="slider_layoutbanner">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/banner.png">
                                <span class="image-clickable"></span>
                            </label>
							<?php if ( Helper::is_woocommerce_active() ) { ?>
                                <input class="image-select" type="radio" value="store" name="slider_layout" id="slider_layoutstore" <?php checked( $slider_layout, 'store' ); ?>>
                                <label for="slider_layoutstore" class="slider_layoutstore">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/store.png">
                                    <span class="image-clickable"></span>
                                </label>
							<?php } ?>
                            <input class="image-select" type="radio" value="animated" name="slider_layout" id="slider_layoutanimated" <?php checked( $slider_layout, 'animated' ); ?>>
                            <label for="slider_layoutanimated" class="slider_layoutanimated">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/banner50.png">
                                <span class="image-clickable"></span>
                            </label>
                            <input class="image-select" type="radio" value="parallax" name="slider_layout" id="slider_layoutparallax" <?php checked( $slider_layout, 'parallax' ); ?>>
                            <label for="slider_layoutparallax" class="slider_layoutparallax">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/parallax.png">
                                <span class="image-clickable"></span>
                            </label>
                        </div>
                    </li>
                    <li id="customize-control-slider_autoplay_speed" class="customize-control customize-control-kirki-slider" style="display: none;">
                        <label>
                            <span class="customize-control-title"><?php _e( 'Скорость смены слайдов, сек', 'wescle' ); ?></span>
                            <div class="wrapper">
                                <div class="wrapper-range">
                                    <input type="range" name="slider_autoplay_speed" min="1" max="20" step="1" value="<?php echo $slider_autoplay_speed; ?>">
                                    <span class="slider-reset dashicons dashicons-image-rotate" data-default="8"></span>
                                    <span class="value"><input type="text" value="<?php echo $slider_autoplay_speed; ?>"></span>
                                </div>
                            </div>
                        </label>
                    </li>
                    <li id="customize-control-slider_dots" class="customize-control" style="">
                        <div>
                            <label for="slider_dots"><span class="customize-control-title"><?php _e( 'Показывать точки переключения слайдов?', 'wescle' ); ?></span></label>
                        </div>
                        <input type="checkbox" id="slider_dots" name="slider_dots" value="1" <?php checked( $slider_dots, '1' ); ?>>
                    </li>
                    <li id="customize-control-slider_arrows" class="customize-control" style="">
                        <div>
                            <label for="slider_arrows"><span class="customize-control-title"><?php _e( 'Показывать стрелки переключения слайдов?', 'wescle' ); ?></span></label>
                        </div>
                        <input type="checkbox" id="slider_arrows" name="slider_arrows" value="1" <?php checked( $slider_arrows, '1' ); ?>>
                    </li>
                    <li id="customize-control-slider_image_without_gradient" class="customize-control" style="">
                        <div>
                            <label for="slider_image_without_gradient"><span class="customize-control-title"><?php _e( 'Отключить затемнение на слайдах?', 'wescle' ); ?></span></label>
                        </div>
                        <input type="checkbox" id="slider_image_without_gradient" name="slider_image_without_gradient" value="1" <?php checked( $slider_image_without_gradient, '1' ); ?>>
                    </li>
                    <li id="customize-control-slider_image_opacity" class="customize-control customize-control-kirki-slider" style="">
                        <label>
                            <span class="customize-control-title"><?php _e( 'Прозрачность затемнение', 'wescle' ); ?></span>
                            <div class="wrapper">
                                <div class="wrapper-range">
                                    <input type="range" id="slider_image_opacity" name="slider_image_opacity" min="10" max="100" step="10" value="<?php echo $slider_image_opacity; ?>">
                                    <span class="slider-reset dashicons dashicons-image-rotate" data-default="100"></span>
                                    <span class="value"><input type="text" value="<?php echo $slider_image_opacity; ?>"></span>
                                </div>
                            </div>
                        </label>
                    </li>
                    <li id="customize-control-parallax_color_text" class="customize-control customize-control-kirki-color">
                        <label>
                            <span class="customize-control-title"><?php _e( 'Цвет текста', 'wescle' ); ?></span>
                        </label>
		                <?php
		                $value = get_post_meta( $post->ID, 'parallax_color_text', 1 );
		                ?>
                        <div class="wp-picker-container">
                            <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="parallax_color_text" value="<?php echo $value ?>">
                        </div>
                    </li>
                    <li id="customize-control-home_slider_carousel_color_bg" class="customize-control customize-control-kirki-color">
                        <label>
                            <span class="customize-control-title"><?php _e( 'Фон блока', 'wescle' ); ?></span>
                        </label>
                        <div class="wp-picker-container">
                            <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="home_slider_carousel_color_bg" value="<?php echo $home_slider_carousel_color_bg; ?>">
                        </div>
                    </li>
                </ul>

                <div class="settings_first_screen" id="settings_first_screen">
                    <h4><?php _e( 'Настройка "Первого экрана"', 'wescle' ); ?></h4>
                    <table class="form-table form-table-custom">
                        <tbody>

                        <tr class="field-slider_columns_one field-slider_banner field-slider_columns_one_fullwidth">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'slider_columns_fullwidth', 1 );
								?>
                                <div><?php _e( 'На всю ширину страницы?', 'wescle' ); ?></div>
                                <label class="wrap-input-checkbox">
                                    <input type="checkbox" name="slider_columns_fullwidth" value="1" <?php checked( $value, '1' ); ?>>
                                </label>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_one field-slider_banner field-slider_columns_one_fullwidth">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'slider_columns_fullheight', 1 );
								?>
                                <div><?php _e( 'На всю высоту страницы?', 'wescle' ); ?></div>
                                <label class="wrap-input-checkbox">
                                    <input type="checkbox" name="slider_columns_fullheight" value="1" <?php checked( $value, '1' ); ?>>
                                </label>
                            </td>
                        </tr>
                        <tr class="field-slider_banner field-slider_store">
                            <td>
                                <div><?php _e( 'Включить H1 у заголовка первого баннера?', 'wescle' ); ?></div>
	                            <?php
	                            $value = get_post_meta( $post->ID, 'slider_banner_title_is_h1', 1 );
	                            ?>
                                <label class="wrap-input-checkbox">
                                    <input type="checkbox" name="slider_banner_title_is_h1" value="1" <?php checked( $value, '1' ); ?>>
                                </label>
                            </td>
                        </tr>

                        <tr class="field-slider_banner">
                            <td>
                                <div><?php _e( 'Эффект смены слайда', 'wescle' ); ?></div>
		                        <?php
		                        $value = get_post_meta( $post->ID, 'slider_banner_slider_effect', 1 );
		                        if ( ! $value ) {
			                        $value = 'slide';
		                        }
		                        ?>
                                <label class="wrap-input-checkbox"><input type="radio" name="slider_banner_slider_effect" value="slide" <?php checked( $value, 'slide' ); ?>> Slide</label>
                                <label class="wrap-input-checkbox"><input type="radio" name="slider_banner_slider_effect" value="fade" <?php checked( $value, 'fade' ); ?>> Fade</label>
                            </td>
                        </tr>

                        <tr class="field-slider_columns_two field-slider_columns_one field-slider_columns_four field-slider_columns_two_category">
                            <td>
                                <div><label><?php _e( 'Категория статей', 'wescle' ); ?></label></div>
                                <select name="slider_columns_two_category[]" class="wescle-select2" multiple>
			                        <?php
			                        $values = get_post_meta( $post->ID, 'slider_columns_two_category', 1 );
			                        if ( ! $values ) {
				                        $values = [];
			                        }
									$options       = Helper::get_terms( array( 'taxonomy' => 'category' ) );
									$multiple_attr = 'multiple';
									foreach ( $options as $key => $option ) {
										if ( $multiple_attr ) {
											$selected = selected( true, in_array( $key, $values ), false );
										}

										echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_two field-slider_columns_one field-slider_columns_four field-slider_columns_two_limit">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'slider_columns_two_limit', 1 );
								?>
                                <div><label><?php _e( 'Количество статей', 'wescle' ); ?></label></div>
                                <input type="number" name="slider_columns_two_limit" value="<?php echo $value; ?>">
                            </td>
                        </tr>
                        <tr class="field-slider_columns_two field-slider_columns_one field-slider_columns_four field-slider_columns_two_posts">
                            <td>
                                <div><label><?php _e( 'или Статьи', 'wescle' ); ?></label></div>
                                <select name="slider_columns_two_posts[]" class="wescle-select2" multiple>
									<?php
									$values = get_post_meta( $post->ID, 'slider_columns_two_posts', 1 );
									if ( ! $values ) {
										$values = [];
									}
									$options       = Helper::get_posts( array(
										'post_type' => 'post',
									) );
									$multiple_attr = 'multiple';
									foreach ( $options as $key => $option ) {
										if ( $multiple_attr ) {
											$selected = selected( true, in_array( $key, $values ), false );
										}

										echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_two field-slider_columns_one field-slider_columns_four field-slider_columns_two_sortable_meta">
                            <td>
								<?php
								$meta = get_post_meta( $post->ID, 'slider_columns_two_meta', 1 );
								if ( ! $meta ) {
									$meta = [
										'category',
										'title',
										'meta',
									];
								}
								?>
                                <div><label><?php _e( 'Порядок блоков', 'wescle' ); ?></label></div>
                                <ul class="sortable sortable_meta">
									<?php foreach ( $meta as $meta_key ) { ?>
                                        <li class="kirki-sortable-item">
                                            <i class="dashicons dashicons-sort"></i>
											<?php echo $meta_sortable[ $meta_key ]; ?>
                                            <input type="hidden" name="sortable_meta[]" value="<?php echo $meta_key; ?>">
                                        </li>
									<?php } ?>
                                </ul>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_two field-slider_columns_one field-slider_columns_four field-slider_columns_two_visibility">
                            <td>
                                <div><label><?php _e( 'Внешний вид', 'wescle' ); ?></label></div>
								<?php
								foreach ( choices_visibility_meta( true ) as $key => $label ) { ?>
									<?php
									if ( 'date_mod' === $key ) {
										continue;
									}

									$value = get_post_meta( $post->ID, 'slider_columns_two_visibility_' . $key, 1 );
									if ( '' === $value ) {
										$value = $key;
									}
									?>
                                    <label class="wrap-input-checkbox">
                                        <input type="checkbox" name="slider_columns_two_visibility_<?php echo $key; ?>" value="<?php echo $key; ?>" <?php checked( $value, $key ); ?>>
										<?php echo $label; ?>
                                    </label>
								<?php } ?>
                            </td>
                        </tr>

                        <tr class="field-slider_columns_one_two field-slider_columns_one_four">
                            <td>
                                <h4 class="section-subtitle"><?php _e( '1 колонка (1 пост)', 'wescle' ); ?></h4>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_one_two field-slider_columns_one_four field-slider_left_block_category">
                            <td>
                                <div><label><?php _e( 'Категория статей', 'wescle' ); ?></label></div>
                                <select name="slider_left_block_category[]" class="wescle-select2" multiple>
									<?php
									$values = get_post_meta( $post->ID, 'slider_left_block_category', 1 );
									if ( ! $values ) {
										$values = [];
									}
									$options       = Helper::get_terms( array( 'taxonomy' => 'category' ) );
									$multiple_attr = 'multiple';
									foreach ( $options as $key => $option ) {
										if ( $multiple_attr ) {
											$selected = selected( true, in_array( $key, $values ), false );
										}

										echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_one_two field-slider_columns_one_four field-slider_left_block_category_posts">
                            <td>
                                <div><label><?php _e( 'или Статьи', 'wescle' ); ?></label></div>
                                <select name="slider_left_block_category_posts[]" class="wescle-select2" multiple>
									<?php
									$values = get_post_meta( $post->ID, 'slider_left_block_category_posts', 1 );
									if ( ! $values ) {
										$values = [];
									}
									$options       = Helper::get_posts( array(
										'post_type' => 'post',
									) );
									$multiple_attr = 'multiple';
									foreach ( $options as $key => $option ) {
										if ( $multiple_attr ) {
											$selected = selected( true, in_array( $key, $values ), false );
										}

										echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_one_two field-slider_columns_one_four field-slider_columns_two_sortable_meta">
                            <td>
								<?php
								$meta = get_post_meta( $post->ID, 'slider_left_block_sortable_meta', 1 );
								if ( ! $meta ) {
									$meta = [
										'category',
										'title',
										'meta',
									];
								}
								?>
                                <div><label><?php _e( 'Порядок блоков', 'wescle' ); ?></label></div>
                                <ul class="sortable sortable_meta">
									<?php foreach ( $meta as $meta_key ) { ?>
                                        <li class="kirki-sortable-item">
                                            <i class="dashicons dashicons-sort"></i>
											<?php echo $meta_sortable[ $meta_key ]; ?>
                                            <input type="hidden" name="slider_left_block_sortable_meta[]" value="<?php echo $meta_key; ?>">
                                        </li>
									<?php } ?>
                                </ul>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_one_two field-slider_columns_one_four field-slider_columns_two_visibility">
                            <td>
                                <div><label><?php _e( 'Внешний вид', 'wescle' ); ?></label></div>
								<?php
								foreach ( choices_visibility_meta( true ) as $key => $label ) { ?>
									<?php
									if ( 'date_mod' === $key ) {
										continue;
									}

									$value = get_post_meta( $post->ID, 'slider_left_block_visibility_' . $key, 1 );
									if ( '' === $value ) {
										$value = $key;
									}
									?>
                                    <label class="wrap-input-checkbox">
                                        <input type="checkbox" name="slider_left_block_visibility_<?php echo $key; ?>" value="<?php echo $key; ?>" <?php checked( $value, $key ); ?>>
										<?php echo $label; ?>
                                    </label>
								<?php } ?>
                            </td>
                        </tr>

                        <tr class="field-slider_columns_one_two">
                            <td>
                                <h4 class="section-subtitle"><?php _e( '2 колонка (2 поста)', 'wescle' ); ?></h4>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_one_four">
                            <td>
                                <h4 class="section-subtitle"><?php _e( '2 колонка (4 поста)', 'wescle' ); ?></h4>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_one_two field-slider_columns_one_four">
                            <td>
                                <div><label><?php _e( 'Отступ от первого поста', 'wescle' ); ?></label></div>
                                <input type="number" name="slider_right_block_offset" value="<?php echo get_post_meta( $post->ID, 'slider_right_block_offset', 1 ); ?>">
                            </td>
                        </tr>
                        <tr class="field-slider_columns_one_two field-slider_columns_one_four field-slider_left_block_category">
                            <td>
                                <div><label><?php _e( 'Категория статей', 'wescle' ); ?></label></div>
                                <select name="slider_right_block_category[]" class="wescle-select2" multiple>
									<?php
									$values = get_post_meta( $post->ID, 'slider_right_block_category', 1 );
									if ( ! $values ) {
										$values = [];
									}
									$options       = Helper::get_terms( array( 'taxonomy' => 'category' ) );
									$multiple_attr = 'multiple';
									foreach ( $options as $key => $option ) {
										if ( $multiple_attr ) {
											$selected = selected( true, in_array( $key, $values ), false );
										}

										echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_one_two field-slider_columns_one_four field-slider_left_block_category_posts">
                            <td>
                                <div><label><?php _e( 'или Статьи', 'wescle' ); ?></label></div>
                                <select name="slider_right_block_category_posts[]" class="wescle-select2" multiple>
									<?php
									$values = get_post_meta( $post->ID, 'slider_right_block_category_posts', 1 );
									if ( ! $values ) {
										$values = [];
									}
									$options       = Helper::get_posts( array(
										'post_type' => 'post',
									) );
									$multiple_attr = 'multiple';
									foreach ( $options as $key => $option ) {
										if ( $multiple_attr ) {
											$selected = selected( true, in_array( $key, $values ), false );
										}

										echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>

                        <tr class="field-slider_columns_one_two field-slider_columns_one_four field-slider_columns_two_sortable_meta">
                            <td>
								<?php
								$meta = get_post_meta( $post->ID, 'slider_right_block_sortable_meta', 1 );
								if ( ! $meta ) {
									$meta = [
										'category',
										'title',
										'meta',
									];
								}
								?>
                                <div><label><?php _e( 'Порядок блоков', 'wescle' ); ?></label></div>
                                <ul class="sortable sortable_meta">
									<?php foreach ( $meta as $meta_key ) { ?>
                                        <li class="kirki-sortable-item">
                                            <i class="dashicons dashicons-sort"></i>
											<?php echo $meta_sortable[ $meta_key ]; ?>
                                            <input type="hidden" name="slider_right_block_sortable_meta[]" value="<?php echo $meta_key; ?>">
                                        </li>
									<?php } ?>
                                </ul>
                            </td>
                        </tr>
                        <tr class="field-slider_columns_one_two field-slider_columns_one_four field-slider_columns_two_visibility">
                            <td>
                                <div><label><?php _e( 'Внешний вид', 'wescle' ); ?></label></div>
								<?php
								foreach ( choices_visibility_meta( true ) as $key => $label ) { ?>
									<?php
									if ( 'date_mod' === $key ) {
										continue;
									}

									$value = get_post_meta( $post->ID, 'slider_right_block_visibility_' . $key, 1 );
									if ( '' === $value ) {
										$value = $key;
									}
									?>
                                    <label class="wrap-input-checkbox">
                                        <input type="checkbox" name="slider_right_block_visibility_<?php echo $key; ?>" value="<?php echo $key; ?>" <?php checked( $value, $key ); ?>>
										<?php echo $label; ?>
                                    </label>
								<?php } ?>
                            </td>
                        </tr>

                        <tr class="field-slider_banner">
                            <td>
                                <div><label><?php _e( 'Баннеры', 'wescle' ); ?></label></div>

                                <div class="wrap-repeater-fields">
                                    <div class="repeater-fields">
										<?php
										$wescle_slider_banners = get_post_meta( $post->ID, 'wescle_slider_banners', 1 );
										if ( $wescle_slider_banners ) {
											foreach ( $wescle_slider_banners as $key => $item ) {
												$img_src = '';
												if ( $item['image'] ) {
													if ( $img = wp_get_attachment_image_src( $item['image'], 'medium' ) ) {
														$img_src = 'src="' . $img[0] . '"';
													}
												}

												$file_img_src = $filename = '';
												if ( isset( $item['video'] ) && $item['video'] ) {
													$file_img_src = 'src="' . home_url( '/wp-includes/images/media/video.png' ) . '"';
													$file_url     = wp_get_attachment_url( $item['video'] );
													if ( $file_url ) {
														$filename = basename( $file_url );
													}
												}
												else {
													$item['video']          = '';
													$item['video_autoplay'] = '';
													$item['video_loop']     = '';
													$item['video_control']  = '';
													$item['video_yt']       = '';
												}
												?>
                                                <div class="repeater-row repeater-row__flex flex-wrap">
                                                    <div class="repeater-row__flex">
                                                        <div class="repeater-field">
                                                            <label><?php echo $this->labels['title_icon']; ?></label>
                                                            <div class="term__image__wrapper">
                                                                <div><img <?php echo $img_src; ?> alt=""></div>
                                                                <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                                <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                                <input type="hidden" class="term_imgid" name="wescle_slider_banners[image][]" value="<?php echo $item['image']; ?>">
                                                            </div>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['title']; ?>
                                                                <textarea class="widefat" name="wescle_slider_banners[title][]" rows="4"><?php echo esc_textarea( $item['title'] ); ?></textarea>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field" style="width: 20%">
                                                            <label>
																<?php echo $this->labels['text']; ?>
                                                                <textarea class="widefat" name="wescle_slider_banners[text][]" rows="4"><?php echo esc_textarea( $item['text'] ); ?></textarea>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php $woo_text_h_align = $item['text_h_align'] ?? 'left'; ?>
																<?php echo $this->labels['text_align_h']; ?><br/>
                                                                <select name="wescle_slider_banners[text_h_align][]">
                                                                    <option value="left" <?php selected( 'left', $woo_text_h_align ); ?>><?php echo $this->labels['text_align_left']; ?></option>
                                                                    <option value="center" <?php selected( 'center', $woo_text_h_align ); ?>><?php echo $this->labels['text_align_center']; ?></option>
                                                                    <option value="end" <?php selected( 'end', $woo_text_h_align ); ?>><?php echo $this->labels['text_align_end']; ?></option>
                                                                </select>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php $woo_text_v_align = $item['text_v_align'] ?? 'bottom'; ?>
																<?php echo $this->labels['text_align_v']; ?><br/>
                                                                <select name="wescle_slider_banners[text_v_align][]">
                                                                    <option value="bottom" <?php selected( 'bottom', $woo_text_v_align ); ?>><?php echo $this->labels['text_align_bottom']; ?></option>
                                                                    <option value="center" <?php selected( 'center', $woo_text_v_align ); ?>><?php echo $this->labels['text_align_center']; ?></option>
                                                                    <option value="top" <?php selected( 'top', $woo_text_v_align ); ?>><?php echo $this->labels['text_align_top']; ?></option>
                                                                </select>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field alignright">
                                                            <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                        </div>
                                                    </div>
                                                    <div class="repeater-row__flex">
                                                        <div class="repeater-field">
                                                            <label><?php echo $this->labels['title_file']; ?></label>
                                                            <div class="term__image__wrapper">
                                                                <div class="thumbnail">
                                                                    <div class="centered"><img <?php echo $file_img_src; ?> class="icon" alt=""></div>
                                                                    <div class="filename">
                                                                        <div><?php echo $filename; ?></div>
                                                                    </div>
                                                                </div>
                                                                <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                                <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                                <input type="hidden" class="term_imgid" data-type="video" name="wescle_slider_banners[video][]" value="<?php echo $item['video']; ?>">
                                                            </div>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['video_autoplay']; ?><br/>
                                                                <input type="checkbox" class="repeater-input-checkbox" data-input_name="wescle_slider_banners[video_autoplay][]" name="wescle_slider_banners[video_autoplay][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['video_autoplay'] ); ?>>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['video_loop']; ?><br/>
                                                                <input type="checkbox" class="repeater-input-checkbox" data-input_name="wescle_slider_banners[video_loop][]" name="wescle_slider_banners[video_loop][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['video_loop'] ); ?>>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['video_control']; ?><br/>
                                                                <input type="checkbox" class="repeater-input-checkbox" data-input_name="wescle_slider_banners[video_control][]" name="wescle_slider_banners[video_control][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['video_control'] ); ?>>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['video_yt']; ?><br/>
                                                                <input type="text" class="" name="wescle_slider_banners[video_yt][]" value="<?php echo $item['video_yt']; ?>">
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="repeater-row__flex">
                                                        <div class="repeater-field">
                                                            <label>
				                                                <?php echo $this->labels['text_width']; ?>
                                                            </label>
                                                            <div>
                                                                <label class="wrap-input-checkbox"><input type="radio" class="widefat banner_text_width" name="wescle_slider_banners[text_width][<?php echo $key; ?>]" value="50" <?php checked( 50, $item['text_width'] ); ?>> 50%</label>
                                                                <label class="wrap-input-checkbox"><input type="radio" class="widefat banner_text_width" name="wescle_slider_banners[text_width][<?php echo $key; ?>]" value="75" <?php checked( 75, $item['text_width'] ); ?>> 75%</label>
                                                                <label class="wrap-input-checkbox"><input type="radio" class="widefat banner_text_width" name="wescle_slider_banners[text_width][<?php echo $key; ?>]" value="100" <?php checked( 100, $item['text_width'] ); ?>> 100%</label>
                                                            </div>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label><?php echo $this->labels['text_color']; ?></label>
                                                            <div>
                                                                <input type="text" class="widefat color-picker" data-alpha-enabled="false" name="wescle_slider_banners[text_color][]" value="<?php echo $item['text_color']; ?>">
                                                            </div>
                                                        </div>
                                                        <div class="repeater-field repeater-field-button">
                                                            <label>
                                                                <span><?php echo $this->labels['button_link']; ?></span>
                                                                <input type="text" class="" name="wescle_slider_banners[button_link][]" value="<?php echo $item['button_link']; ?>">
                                                            </label>
                                                            <label>
                                                                <span><?php echo $this->labels['button_text']; ?></span>
                                                                <input type="text" class="" name="wescle_slider_banners[button_text][]" value="<?php echo esc_attr( $item['button_text'] ); ?>">
                                                            </label>
                                                        </div>

                                                        <div class="repeater-field repeater-field-button">
                                                            <label>
                                                                <span><?php echo $this->labels['button_link']; ?> 2</span>
                                                                <input type="text" class="" name="wescle_slider_banners[button_link2][]" value="<?php echo @$item['button_link2']; ?>">
                                                            </label>
                                                            <label>
                                                                <span><?php echo $this->labels['button_text']; ?> 2</span>
                                                                <input type="text" class="" name="wescle_slider_banners[button_text2][]" value="<?php echo esc_attr( @$item['button_text2'] ); ?>">
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
												<?php
											}
										}
										?>
                                        <div class="repeater-field-hidden">
                                            <div class="repeater-row repeater-row__flex flex-wrap">
                                                <div class="repeater-row__flex">
                                                    <div class="repeater-field">
                                                        <label><?php echo $this->labels['title_icon']; ?></label>
                                                        <div class="term__image__wrapper">
                                                            <div><img alt=""></div>
                                                            <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                            <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                            <input type="hidden" class="term_imgid" name="wescle_slider_banners[image][]" value="">
                                                        </div>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['title']; ?>
                                                            <textarea class="widefat" name="wescle_slider_banners[title][]" rows="4"></textarea>
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field" style="width: 20%">
                                                        <label>
															<?php echo $this->labels['text']; ?>
                                                            <textarea class="widefat" name="wescle_slider_banners[text][]" rows="4"></textarea>
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['text_align_h']; ?><br/>
                                                            <select name="wescle_slider_banners[text_h_align][]">
                                                                <option value="left"><?php echo $this->labels['text_align_left']; ?></option>
                                                                <option value="center"><?php echo $this->labels['text_align_center']; ?></option>
                                                                <option value="end"><?php echo $this->labels['text_align_end']; ?></option>
                                                            </select>
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['text_align_v']; ?><br/>
                                                            <select name="wescle_slider_banners[text_v_align][]">
                                                                <option value="bottom"><?php echo $this->labels['text_align_bottom']; ?></option>
                                                                <option value="center"><?php echo $this->labels['text_align_center']; ?></option>
                                                                <option value="top"><?php echo $this->labels['text_align_top']; ?></option>
                                                            </select>
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field alignright">
                                                        <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                    </div>
                                                </div>
                                                <div class="repeater-row__flex">
                                                    <div class="repeater-field">
                                                        <label><?php echo $this->labels['title_file']; ?></label>
                                                        <div class="term__image__wrapper">
                                                            <div class="thumbnail">
                                                                <div class="centered"><img alt=""></div>
                                                                <div class="filename">
                                                                    <div></div>
                                                                </div>
                                                            </div>
                                                            <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                            <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                            <input type="hidden" class="term_imgid" data-type="video" name="wescle_slider_banners[video][]" value="">
                                                        </div>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['video_autoplay']; ?><br/>
                                                            <input type="checkbox" class="repeater-input-checkbox" data-input_name="wescle_slider_banners[video_autoplay][]" value="1">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['video_loop']; ?><br/>
                                                            <input type="checkbox" class="repeater-input-checkbox" data-input_name="wescle_slider_banners[video_loop][]" value="1">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['video_control']; ?><br/>
                                                            <input type="checkbox" class="repeater-input-checkbox" data-input_name="wescle_slider_banners[video_control][]" value="1">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['video_yt']; ?><br/>
                                                            <input type="text" class="" name="wescle_slider_banners[video_yt][]" value="">
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="repeater-row__flex">
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['text_width']; ?>
                                                        </label>
                                                        <div>
                                                            <label class="wrap-input-checkbox"><input type="radio" class="widefat banner_text_width" name="wescle_slider_banners[text_width][]" value="50"> 50%</label>
                                                            <label class="wrap-input-checkbox"><input type="radio" class="widefat banner_text_width" name="wescle_slider_banners[text_width][]" value="75"> 75%</label>
                                                            <label class="wrap-input-checkbox"><input type="radio" class="widefat banner_text_width" name="wescle_slider_banners[text_width][]" value="100" checked> 100%</label>
                                                        </div>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label><?php echo $this->labels['text_color']; ?></label>
                                                        <div>
                                                            <input type="text" class="widefat color-picker-init" data-alpha-enabled="false" name="wescle_slider_banners[text_color][]" value="">
                                                        </div>
                                                    </div>
                                                    <div class="repeater-field repeater-field-button">
                                                        <label>
                                                            <span><?php echo $this->labels['button_link']; ?></span>
                                                            <input type="text" class="" name="wescle_slider_banners[button_link][]" value="">
                                                        </label>
                                                        <label>
                                                            <span><?php echo $this->labels['button_text']; ?></span>
                                                            <input type="text" class="" name="wescle_slider_banners[button_text][]" value="">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field repeater-field-button">
                                                        <label>
                                                            <span><?php echo $this->labels['button_link']; ?> 2</span>
                                                            <input type="text" class="" name="wescle_slider_banners[button_link2][]" value="">
                                                        </label>
                                                        <label>
                                                            <span><?php echo $this->labels['button_text']; ?> 2</span>
                                                            <input type="text" class="" name="wescle_slider_banners[button_text2][]" value="">
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
                                </div>

                            </td>
                        </tr>

                        <tr class="field-slider_banner">
                            <td>
                                <h4 class="section-subtitle"><?php _e( 'Высота баннера', 'wescle' ); ?>, px</h4>
                            </td>
                        </tr>
                        <tr class="field-slider_banner">
                            <td>
                                <label>
                                    <div><?php esc_html_e( 'на ПК (1280-1920)', 'wescle' ); ?></div>
                                    <input type="number" name="slider_banner_height_desktop" value="<?php echo get_post_meta( $post->ID, 'slider_banner_height_desktop', 1 ); ?>">
                                </label>
                            </td>
                        </tr>
                        <tr class="field-slider_banner">
                            <td>
                                <label>
                                    <div><?php esc_html_e( 'на планшете (768-1280)', 'wescle' ); ?></div>
                                    <input type="number" name="slider_banner_height_tablet" value="<?php echo get_post_meta( $post->ID, 'slider_banner_height_tablet', 1 ); ?>">
                                </label>
                            </td>
                        </tr>
                        <tr class="field-slider_banner">
                            <td>
                                <label>
                                    <div><?php esc_html_e( 'на телефоне (320-768)', 'wescle' ); ?></div>
                                    <input type="number" name="slider_banner_height_mobile" value="<?php echo get_post_meta( $post->ID, 'slider_banner_height_mobile', 1 ); ?>">
                                </label>
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
                                <h4 style="margin: 0"><?php _e( '1 колонка (меню)', 'wescle' ); ?></h4>
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
                                <div><?php esc_html_e( 'Отображать меню с категориями?', 'wescle' ); ?></div>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_menu_enabled', 1 );
								if ( '' === $value ) {
									$value = 1;
								}
								?>
                                <label class="wrap-input-checkbox">
                                    <input type="checkbox" name="slider_store_menu_enabled" value="1" <?php checked( $value, '1' ); ?>>
                                </label>
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
                                <h4 style="margin: 0"><?php _e( '2 колонка (горизонтальный слайдер)', 'wescle' ); ?></h4>
                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store-fullwidth">
                            <td>
                                <div><?php esc_html_e( 'На всю ширину страницы?', 'wescle' ); ?></div>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_one_fullwidth', 1 );
								?>
                                <label class="wrap-input-checkbox">
                                    <input type="checkbox" name="slider_store_one_fullwidth" value="1" <?php checked( $value, '1' ); ?>>
                                </label>
                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store-fullwidth">
                            <td>
                                <div><?php esc_html_e( 'На всю высоту страницы?', 'wescle' ); ?></div>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_one_fullheight', 1 );
								?>
                                <label class="wrap-input-checkbox">
                                    <input type="checkbox" name="slider_store_one_fullheight" value="1" <?php checked( $value, '1' ); ?>>
                                </label>
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
                                <div><label><?php esc_html_e( 'Тип слайдов', 'wescle' ); ?></label></div>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_one_type', 1 );
								if ( ! $value ) {
									$value = 'custom';
								}
								?>
                                <label class="wrap-input-checkbox">
                                    <input type="radio" name="slider_store_one_type" value="product" <?php checked( $value, 'product' ); ?>>
									<?php _e( 'Товары', 'wescle' ); ?>
                                </label>
                                <label class="wrap-input-checkbox">
                                    <input type="radio" name="slider_store_one_type" value="custom" <?php checked( $value, 'custom' ); ?>>
									<?php _e( 'Custom', 'wescle' ); ?>
                                </label>
                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store_one-type_custom">
                            <td>
                                <div><label><?php _e( 'Слайды', 'wescle' ); ?></label></div>

                                <div class="wrap-repeater-fields">
                                    <div class="repeater-fields">
										<?php
										$wescle_slider_slides = get_post_meta( $post->ID, 'slider_store_one_slides', 1 );
										if ( $wescle_slider_slides ) {
											foreach ( $wescle_slider_slides as $key => $item ) {
												$img_src = '';
												if ( $item['image'] ) {
													if ( $img = wp_get_attachment_image_src( $item['image'], 'medium' ) ) {
														$img_src = 'src="' . $img[0] . '"';
													}
												}

												$file_img_src = $filename = '';
												if ( $item['video'] ) {
													$file_img_src = 'src="' . home_url( '/wp-includes/images/media/video.png' ) . '"';
													$file_url     = wp_get_attachment_url( $item['video'] );
													if ( $file_url ) {
														$filename = basename( $file_url );
													}
												}
												?>
                                                <div class="repeater-row repeater-row__flex flex-wrap">
                                                    <div class="repeater-row__flex">
                                                        <div class="repeater-field">
                                                            <label><?php echo $this->labels['title_icon']; ?></label>
                                                            <div class="term__image__wrapper">
                                                                <div><img <?php echo $img_src; ?> alt=""></div>
                                                                <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                                <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                                <input type="hidden" class="term_imgid" name="slider_store_one_slides[image][]" value="<?php echo $item['image']; ?>">
                                                            </div>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['title']; ?><br/>
                                                                <input type="text" class="" name="slider_store_one_slides[title][]" value="<?php echo esc_attr( $item['title'] ); ?>">
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field" style="width: 20%">
                                                            <label>
																<?php echo $this->labels['text']; ?><br/>
                                                                <textarea class="widefat" name="slider_store_one_slides[text][]" rows="4"><?php echo esc_textarea( $item['text'] ); ?></textarea>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php $woo_text_h_align = $item['woo_text_h_align'] ?? 'left'; ?>
																<?php echo $this->labels['text_align_h']; ?><br/>
                                                                <select name="slider_store_one_slides[woo_text_h_align][]">
                                                                    <option value="left" <?php selected( 'left', $woo_text_h_align ); ?>><?php echo $this->labels['text_align_left']; ?></option>
                                                                    <option value="center" <?php selected( 'center', $woo_text_h_align ); ?>><?php echo $this->labels['text_align_center']; ?></option>
                                                                    <option value="end" <?php selected( 'end', $woo_text_h_align ); ?>><?php echo $this->labels['text_align_end']; ?></option>
                                                                </select>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php $woo_text_v_align = $item['woo_text_v_align'] ?? 'bottom'; ?>
																<?php echo $this->labels['text_align_v']; ?><br/>
                                                                <select name="slider_store_one_slides[woo_text_v_align][]">
                                                                    <option value="bottom" <?php selected( 'bottom', $woo_text_v_align ); ?>><?php echo $this->labels['text_align_bottom']; ?></option>
                                                                    <option value="center" <?php selected( 'center', $woo_text_v_align ); ?>><?php echo $this->labels['text_align_center']; ?></option>
                                                                    <option value="top" <?php selected( 'top', $woo_text_v_align ); ?>><?php echo $this->labels['text_align_top']; ?></option>
                                                                </select>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field alignright">
                                                            <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                        </div>
                                                    </div>
                                                    <div class="repeater-row__flex">
                                                        <div class="repeater-field">
                                                            <label><?php echo $this->labels['title_file']; ?></label>
                                                            <div class="term__image__wrapper">
                                                                <div class="thumbnail">
                                                                    <div class="centered"><img <?php echo $file_img_src; ?> class="icon" alt=""></div>
                                                                    <div class="filename">
                                                                        <div><?php echo $filename; ?></div>
                                                                    </div>
                                                                </div>
                                                                <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                                <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                                <input type="hidden" class="term_imgid" data-type="video" name="slider_store_one_slides[video][]" value="<?php echo $item['video']; ?>">
                                                            </div>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['video_autoplay']; ?><br/>
                                                                <input type="checkbox" class="repeater-input-checkbox" data-input_name="slider_store_one_slides[video_autoplay][]" name="slider_store_one_slides[video_autoplay][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['video_autoplay'] ); ?>>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['video_loop']; ?><br/>
                                                                <input type="checkbox" class="repeater-input-checkbox" data-input_name="slider_store_one_slides[video_loop][]" name="slider_store_one_slides[video_loop][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['video_loop'] ); ?>>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['video_control']; ?><br/>
                                                                <input type="checkbox" class="repeater-input-checkbox" data-input_name="slider_store_one_slides[video_control][]" name="slider_store_one_slides[video_control][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['video_control'] ); ?>>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['video_yt']; ?><br/>
                                                                <input type="text" class="" name="slider_store_one_slides[video_yt][]" value="<?php echo $item['video_yt']; ?>">
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="repeater-row__flex">
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['price']; ?><br/>
                                                                <input type="text" class="" name="slider_store_one_slides[price][]" value="<?php echo $item['price']; ?>">
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['price_old']; ?><br/>
                                                                <input type="text" class="" name="slider_store_one_slides[price_old][]" value="<?php echo $item['price_old']; ?>">
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field repeater-field-button">
                                                            <label>
																<?php echo $this->labels['button_text']; ?><br/>
                                                                <input type="text" class="" name="slider_store_one_slides[button_label][]" value="<?php echo esc_attr( $item['button_label'] ); ?>">
                                                            </label>
                                                            <label>
																<?php echo $this->labels['button_link']; ?><br/>
                                                                <input type="text" class="" name="slider_store_one_slides[button_url][]" value="<?php echo $item['button_url']; ?>">
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field repeater-field-button">
                                                            <label>
																<?php echo $this->labels['button_text']; ?> 2<br/>
                                                                <input type="text" class="" name="slider_store_one_slides[button_label2][]" value="<?php echo esc_attr( @$item['button_label2'] ); ?>">
                                                            </label>
                                                            <label>
																<?php echo $this->labels['button_link']; ?> 2<br/>
                                                                <input type="text" class="" name="slider_store_one_slides[button_url2][]" value="<?php echo @$item['button_url2']; ?>">
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
												<?php
											}
										}
										?>
                                        <div class="repeater-field-hidden">
                                            <div class="repeater-row repeater-row__flex flex-wrap">

                                                <div class="repeater-row__flex">
                                                    <div class="repeater-field">
                                                        <label><?php echo $this->labels['title_icon']; ?></label>
                                                        <div class="term__image__wrapper">
                                                            <div><img alt=""></div>
                                                            <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                            <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                            <input type="hidden" class="term_imgid" name="slider_store_one_slides[image][]" value="">
                                                        </div>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['title']; ?><br/>
                                                            <input type="text" class="" name="slider_store_one_slides[title][]" value="">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field" style="width: 20%">
                                                        <label>
															<?php echo $this->labels['text']; ?><br/>
                                                            <textarea class="widefat" name="slider_store_one_slides[text][]" rows="4"></textarea>
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['text_align_h']; ?><br/>
                                                            <select name="slider_store_one_slides[woo_text_h_align][]">
                                                                <option value="left"><?php echo $this->labels['text_align_left']; ?></option>
                                                                <option value="center"><?php echo $this->labels['text_align_center']; ?></option>
                                                                <option value="end"><?php echo $this->labels['text_align_end']; ?></option>
                                                            </select>
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['text_align_v']; ?><br/>
                                                            <select name="slider_store_one_slides[woo_text_v_align][]">
                                                                <option value="bottom"><?php echo $this->labels['text_align_bottom']; ?></option>
                                                                <option value="center"><?php echo $this->labels['text_align_center']; ?></option>
                                                                <option value="top"><?php echo $this->labels['text_align_top']; ?></option>
                                                            </select>
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field alignright">
                                                        <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                    </div>
                                                </div>
                                                <div class="repeater-row__flex">
                                                    <div class="repeater-field">
                                                        <label><?php echo $this->labels['title_file']; ?></label>
                                                        <div class="term__image__wrapper">
                                                            <div class="thumbnail">
                                                                <div class="centered"><img alt=""></div>
                                                                <div class="filename">
                                                                    <div></div>
                                                                </div>
                                                            </div>
                                                            <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                            <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                            <input type="hidden" class="term_imgid" data-type="video" name="slider_store_one_slides[video][]" value="">
                                                        </div>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['video_autoplay']; ?><br/>
                                                            <input type="checkbox" class="repeater-input-checkbox" data-input_name="slider_store_one_slides[video_autoplay][]" value="1">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['video_loop']; ?><br/>
                                                            <input type="checkbox" class="repeater-input-checkbox" data-input_name="slider_store_one_slides[video_loop][]" value="1">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['video_control']; ?><br/>
                                                            <input type="checkbox" class="repeater-input-checkbox" data-input_name="slider_store_one_slides[video_control][]" value="1">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['video_yt']; ?><br/>
                                                            <input type="text" class="" name="slider_store_one_slides[video_yt][]" value="">
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="repeater-row__flex">
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['price']; ?><br/>
                                                            <input type="text" class="" name="slider_store_one_slides[price][]" value="">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['price_old']; ?><br/>
                                                            <input type="text" class="" name="slider_store_one_slides[price_old][]" value="">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field repeater-field-button">
                                                        <label>
															<?php echo $this->labels['button_text']; ?><br/>
                                                            <input type="text" class="" name="slider_store_one_slides[button_label][]" value="">
                                                        </label>
                                                        <label>
															<?php echo $this->labels['button_link']; ?><br/>
                                                            <input type="text" class="" name="slider_store_one_slides[button_url][]" value="">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field repeater-field-button">
                                                        <label>
															<?php echo $this->labels['button_text']; ?> 2<br/>
                                                            <input type="text" class="" name="slider_store_one_slides[button_label2][]" value="">
                                                        </label>
                                                        <label>
															<?php echo $this->labels['button_link']; ?> 2<br/>
                                                            <input type="text" class="" name="slider_store_one_slides[button_url2][]" value="">
                                                        </label>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_slide']; ?></button>
                                </div>

                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store_one-type_product">
                            <td>
                                <div><label><?php esc_html_e( 'Категория товаров', 'wescle' ); ?></label></div>
                                <select name="slider_store_one_category[]" class="wescle-select2" multiple>
									<?php
									$values = get_post_meta( $post->ID, 'slider_store_one_category', 1 );
									if ( ! $values ) {
										$values = [];
									}
									$options       = Helper::get_terms( array( 'taxonomy' => 'product_cat' ) );
									$multiple_attr = 'multiple';
									foreach ( $options as $key => $option ) {
										if ( $multiple_attr ) {
											$selected = selected( true, in_array( $key, $values ), false );
										}

										echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store_one-type_product">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_one_limit', 1 );
								if ( ! $value ) {
									$value = 6;
								}
								?>
                                <div><label><?php esc_html_e( 'Количество товаров', 'wescle' ); ?></label></div>
                                <input type="number" name="slider_store_one_limit" step="1" max="12" value="<?php echo $value; ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store_one-type_product">
                            <td>
                                <div><label><?php esc_html_e( 'или выберите отдельные товары', 'wescle' ); ?></label></div>
                                <select name="slider_store_one_products[]" class="wescle-select2" multiple>
									<?php
									$values = get_post_meta( $post->ID, 'slider_store_one_products', 1 );
									if ( ! $values ) {
										$values = [];
									}
									$options       = Helper::get_posts( array(
										'post_type' => 'product',
									) );
									$multiple_attr = 'multiple';
									foreach ( $options as $key => $option ) {
										if ( $multiple_attr ) {
											$selected = selected( true, in_array( $key, $values ), false );
										}

										echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store_one-type_product">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_one_button_label', 1 );
								?>
                                <div><label><?php esc_html_e( 'Надпись на кнопке', 'wescle' ); ?></label></div>
                                <input type="text" name="slider_store_one_button_label" value="<?php echo $value; ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_one_color_title', 1 );
								?>
                                <div><label><?php esc_html_e( 'Цвет заголовка', 'wescle' ); ?></label></div>
                                <input type="text" class="color-picker" name="slider_store_one_color_title" value="<?php echo $value; ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_one_color_price', 1 );
								?>
                                <div><label><?php esc_html_e( 'Цвет текста с ценой', 'wescle' ); ?></label></div>
                                <input type="text" class="color-picker" name="slider_store_one_color_price" value="<?php echo $value; ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
                                <h4 style="margin: 0"><?php _e( '3 колонка (вертикальный слайдер)', 'wescle' ); ?></h4>
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
                                <div><?php esc_html_e( 'Включить блок', 'wescle' ); ?></div>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_two_enabled', 1 );
								if ( '' === $value ) {
									$value = '1';
								}
								?>
                                <label class="wrap-input-checkbox">
                                    <input type="checkbox" name="slider_store_two_enabled" value="1" <?php checked( $value, '1' ); ?>>
                                </label>
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
                                <div><label><?php esc_html_e( 'Тип слайдов', 'wescle' ); ?></label></div>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_two_type', 1 );
								if ( ! $value ) {
									$value = 'custom';
								}
								?>
                                <label class="wrap-input-checkbox">
                                    <input type="radio" name="slider_store_two_type" value="product" <?php checked( $value, 'product' ); ?>>
									<?php _e( 'Товары', 'wescle' ); ?>
                                </label>
                                <label class="wrap-input-checkbox">
                                    <input type="radio" name="slider_store_two_type" value="custom" <?php checked( $value, 'custom' ); ?>>
									<?php _e( 'Custom', 'wescle' ); ?>
                                </label>
                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store_two-type_custom">
                            <td>
                                <div><label><?php _e( 'Слайды', 'wescle' ); ?></label></div>

                                <div class="wrap-repeater-fields">
                                    <div class="repeater-fields">
										<?php
										$wescle_slider_slides = get_post_meta( $post->ID, 'slider_store_two_slides', 1 );
										if ( $wescle_slider_slides ) {
											foreach ( $wescle_slider_slides as $key => $item ) {
												$img_src = '';
												if ( $item['image'] ) {
													if ( $img = wp_get_attachment_image_src( $item['image'], 'medium' ) ) {
														$img_src = 'src="' . $img[0] . '"';
													}
												}
												?>
                                                <div class="repeater-row repeater-row__flex  flex-wrap">
                                                    <div class="repeater-row__flex">
                                                        <div class="repeater-field">
                                                            <label><?php echo $this->labels['title_icon']; ?></label>
                                                            <div class="term__image__wrapper">
                                                                <div><img <?php echo $img_src; ?> alt=""></div>
                                                                <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                                <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                                <input type="hidden" class="term_imgid" name="slider_store_two_slides[image][]" value="<?php echo $item['image']; ?>">
                                                            </div>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['title']; ?><br/>
                                                                <input type="text" class="" name="slider_store_two_slides[title][]" value="<?php echo esc_attr( $item['title'] ); ?>">
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php $woo_text_h_align = $item['woo_text_h_align'] ?? 'left'; ?>
																<?php echo $this->labels['text_align_h']; ?><br/>
                                                                <select name="slider_store_two_slides[woo_text_h_align][]">
                                                                    <option value="left" <?php selected( 'left', $woo_text_h_align ); ?>><?php echo $this->labels['text_align_left']; ?></option>
                                                                    <option value="center" <?php selected( 'center', $woo_text_h_align ); ?>><?php echo $this->labels['text_align_center']; ?></option>
                                                                    <option value="end" <?php selected( 'end', $woo_text_h_align ); ?>><?php echo $this->labels['text_align_end']; ?></option>
                                                                </select>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php $woo_text_v_align = $item['woo_text_v_align'] ?? 'bottom'; ?>
																<?php echo $this->labels['text_align_v']; ?><br/>
                                                                <select name="slider_store_two_slides[woo_text_v_align][]">
                                                                    <option value="bottom" <?php selected( 'bottom', $woo_text_v_align ); ?>><?php echo $this->labels['text_align_bottom']; ?></option>
                                                                    <option value="center" <?php selected( 'center', $woo_text_v_align ); ?>><?php echo $this->labels['text_align_center']; ?></option>
                                                                    <option value="top" <?php selected( 'top', $woo_text_v_align ); ?>><?php echo $this->labels['text_align_top']; ?></option>
                                                                </select>
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field alignright">
                                                            <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                        </div>
                                                    </div>
                                                    <div class="repeater-row__flex">
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['price']; ?><br/>
                                                                <input type="text" class="" name="slider_store_two_slides[price][]" value="<?php echo $item['price']; ?>">
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['price_old']; ?><br/>
                                                                <input type="text" class="" name="slider_store_two_slides[price_old][]" value="<?php echo $item['price_old']; ?>">
                                                            </label>
                                                        </div>
                                                        <div class="repeater-field">
                                                            <label>
																<?php echo $this->labels['button_link']; ?><br/>
                                                                <input type="text" class="" name="slider_store_two_slides[button_url][]" value="<?php echo $item['button_url']; ?>">
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
												<?php
											}
										}
										?>
                                        <div class="repeater-field-hidden">
                                            <div class="repeater-row repeater-row__flex flex-wrap">
                                                <div class="repeater-row__flex">
                                                    <div class="repeater-field">
                                                        <label><?php echo $this->labels['title_icon']; ?></label>
                                                        <div class="term__image__wrapper">
                                                            <div><img alt=""></div>
                                                            <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                            <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                            <input type="hidden" class="term_imgid" name="slider_store_two_slides[image][]" value="">
                                                        </div>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['title']; ?><br/>
                                                            <input type="text" class="" name="slider_store_two_slides[title][]" value="">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['text_align_h']; ?><br/>
                                                            <select name="slider_store_two_slides[woo_text_h_align][]">
                                                                <option value="left"><?php echo $this->labels['text_align_left']; ?></option>
                                                                <option value="center"><?php echo $this->labels['text_align_center']; ?></option>
                                                                <option value="end"><?php echo $this->labels['text_align_end']; ?></option>
                                                            </select>
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['text_align_v']; ?><br/>
                                                            <select name="slider_store_two_slides[woo_text_v_align][]">
                                                                <option value="bottom"><?php echo $this->labels['text_align_bottom']; ?></option>
                                                                <option value="center"><?php echo $this->labels['text_align_center']; ?></option>
                                                                <option value="top"><?php echo $this->labels['text_align_top']; ?></option>
                                                            </select>
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field alignright">
                                                        <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                    </div>
                                                </div>
                                                <div class="repeater-row__flex">
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['price']; ?><br/>
                                                            <input type="text" class="" name="slider_store_two_slides[price][]" value="">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['price_old']; ?><br/>
                                                            <input type="text" class="" name="slider_store_two_slides[price_old][]" value="">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['button_link']; ?><br/>
                                                            <input type="text" class="" name="slider_store_two_slides[button_url][]" value="">
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_slide']; ?></button>
                                </div>

                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store_two-type_product">
                            <td>
                                <div><label><?php esc_html_e( 'Категория товаров', 'wescle' ); ?></label></div>
                                <select name="slider_store_two_category[]" class="wescle-select2" multiple>
									<?php
									$values = get_post_meta( $post->ID, 'slider_store_two_category', 1 );
									if ( ! $values ) {
										$values = [];
									}
									$options       = Helper::get_terms( array( 'taxonomy' => 'product_cat' ) );
									$multiple_attr = 'multiple';
									foreach ( $options as $key => $option ) {
										if ( $multiple_attr ) {
											$selected = selected( true, in_array( $key, $values ), false );
										}

										echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store_two-type_product">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_two_limit', 1 );
								if ( ! $value ) {
									$value = 6;
								}
								?>
                                <div><label><?php esc_html_e( 'Количество товаров', 'wescle' ); ?></label></div>
                                <input type="number" name="slider_store_two_limit" step="1" max="12" value="<?php echo $value; ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_store field-slider_store_two-type_product">
                            <td>
                                <div><label><?php esc_html_e( 'или выберите отдельные товары', 'wescle' ); ?></label></div>
                                <select name="slider_store_two_products[]" class="wescle-select2" multiple>
									<?php
									$values = get_post_meta( $post->ID, 'slider_store_two_products', 1 );
									if ( ! $values ) {
										$values = [];
									}
									$options       = Helper::get_posts( array(
										'post_type' => 'product',
									) );
									$multiple_attr = 'multiple';
									foreach ( $options as $key => $option ) {
										if ( $multiple_attr ) {
											$selected = selected( true, in_array( $key, $values ), false );
										}

										echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
									}
									?>
                                </select>
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_two_color_title', 1 );
								?>
                                <div><label><?php esc_html_e( 'Цвет заголовка', 'wescle' ); ?></label></div>
                                <input type="text" class="color-picker" name="slider_store_two_color_title" value="<?php echo $value; ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_store">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'slider_store_two_color_price', 1 );
								?>
                                <div><label><?php esc_html_e( 'Цвет текста с ценой', 'wescle' ); ?></label></div>
                                <input type="text" class="color-picker" name="slider_store_two_color_price" value="<?php echo $value; ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'animated_label_text', 1 );
								?>
                                <div><label><?php esc_html_e( 'Текст перед заголовком', 'wescle' ); ?></label></div>
                                <input type="text" name="animated_label_text" class="regular-text" value="<?php echo esc_attr( $value ); ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'animated_label_href', 1 );
								?>
                                <div><label><?php esc_html_e( 'URL текста перед заголовком', 'wescle' ); ?></label></div>
                                <input type="text" name="animated_label_href" class="regular-text" value="<?php echo esc_attr( $value ); ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td class="customize-control-kirki-color">
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_label_text_color', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Цвет текста перед заголовком', 'wescle' ); ?></label></div>
                                <div class="wp-picker-container">
                                    <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="animated_label_text_color" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>
                        <tr class="field-slider_animated field-slider_parallax">
                            <td class="customize-control-kirki-color">
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_label_bg_color', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Цвет фона перед заголовком', 'wescle' ); ?></label></div>
                                <div class="wp-picker-container">
                                    <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="animated_label_bg_color" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td>
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_title_1', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Текст первой строки', 'wescle' ); ?></label></div>
                                <input type="text" name="animated_title_1" class="regular-text" value="<?php echo esc_attr( $value ); ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_parallax">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'parallax_title_1', 1 );
								?>
                                <div><label><?php echo $this->labels['title']; ?></label></div>
                                <input type="text" name="parallax_title_1" class="regular-text" value="<?php echo esc_attr( $value ); ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'parallax_title_type', 1 );
								?>
                                <div><label>Тип заголовка</label></div>
                                <select name="parallax_title_type">
                                    <option value="div" <?php selected( $value, 'div' ); ?>>DIV</option>
                                    <option value="h1" <?php selected( $value, 'h1' ); ?>>H1</option>
                                    <option value="h2" <?php selected( $value, 'h2' ); ?>>H2</option>
                                    <option value="h3" <?php selected( $value, 'h3' ); ?>>H3</option>
                                    <option value="h4" <?php selected( $value, 'h4' ); ?>>H4</option>
                                    <option value="h5" <?php selected( $value, 'h5' ); ?>>H5</option>
                                    <option value="h6" <?php selected( $value, 'h6' ); ?>>H6</option>
                                </select>
                            </td>
                        </tr>

                        <tr class="field-slider_parallax">
                            <td>
                                <div><label><?php _e( 'Строки с картинками', 'wescle' ); ?></label></div>

                                <div class="wrap-repeater-fields">
                                    <div class="repeater-fields">
										<?php
										$text_items = get_post_meta( $post->ID, 'parallax_text_items', 1 );
										if ( $text_items ) {
											foreach ( $text_items as $key => $item ) {
												$value   = $item['image'];
												$img_src = '';
												if ( $value ) {
													if ( $img = wp_get_attachment_image_src( $value, 'medium' ) ) {
														$img_src = 'src="' . $img[0] . '"';
													}
												}
												?>
                                                <div class="repeater-row repeater-row__flex flex-wrap animated_title_text_items">
                                                    <div class="repeater-field">
                                                        <label><?php echo $this->labels['title_icon']; ?></label>
                                                        <div class="term__image__wrapper">
                                                            <div><img <?php echo $img_src; ?> alt=""></div>
                                                            <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                            <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                            <input type="hidden" class="term_imgid" name="parallax_text_items[image][]" value="<?php echo $item['image']; ?>">
                                                        </div>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['text']; ?><br/>
                                                            <input type="text" class="regular-text" name="parallax_text_items[text][]" value="<?php echo esc_attr( $item['text'] ); ?>">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field alignright">
                                                        <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                    </div>
                                                </div>
												<?php
											}
										}
										?>
                                        <div class="repeater-field-hidden">
                                            <div class="repeater-row repeater-row__flex flex-wrap">
                                                <div class="repeater-field">
                                                    <label><?php echo $this->labels['title_icon']; ?></label>
                                                    <div class="term__image__wrapper">
                                                        <div><img alt=""></div>
                                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                                        <input type="hidden" class="term_imgid" name="parallax_text_items[image][]" value="">
                                                    </div>
                                                </div>
                                                <div class="repeater-field">
                                                    <label>
														<?php echo $this->labels['text']; ?><br/>
                                                        <input type="text" class="regular-text" name="parallax_text_items[text][]" value="">
                                                    </label>
                                                </div>
                                                <div class="repeater-field alignright">
                                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_string']; ?></button>
                                </div>

                            </td>
                        </tr>

                        <tr class="field-slider_parallax">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'parallax_button_label', 1 );
								?>
                                <div><label><?php echo $this->labels['button_text']; ?></label></div>
                                <input type="text" name="parallax_button_label" class="regular-text" value="<?php echo esc_attr( $value ); ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_parallax">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'parallax_button_url', 1 );
								?>
                                <div><label><?php esc_html_e( 'URL для кнопки', 'wescle' ); ?></label></div>
                                <input type="text" name="parallax_button_url" class="regular-text" value="<?php echo esc_attr( $value ); ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_parallax">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'parallax_text_button', 1 );
								?>
                                <div><label><?php esc_html_e( 'Анимационный текст на кнопке', 'wescle' ); ?></label></div>
                                <input type="text" name="parallax_text_button" class="regular-text" value="<?php echo esc_attr( $value ); ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_parallax">
                            <td class="customize-control-kirki-color">
					            <?php
					            $value = get_post_meta( $post->ID, 'parallax_text_button_bg', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Цвет фона анимационного текста', 'wescle' ); ?></label></div>
                                <div class="wp-picker-container">
                                    <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="parallax_text_button_bg" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_parallax">
                            <td class="customize-control-kirki-color">
					            <?php
					            $value = get_post_meta( $post->ID, 'parallax_text_after_button', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Текст под кнопкой', 'wescle' ); ?></label></div>
                                <div class="wp-picker-container">
                                    <textarea name="parallax_text_after_button" class="regular-text"><?php echo esc_textarea( $value ); ?></textarea>
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_parallax">
                            <td>
								<?php
								$value   = get_post_meta( $post->ID, 'parallax_bg_image_1', 1 );
								$img_src = '';
								if ( $value ) {
									if ( $img = wp_get_attachment_image_src( $value, 'medium' ) ) {
										$img_src = 'src="' . $img[0] . '"';
									}
								}
								?>
                                <div><label><?php esc_html_e( 'Изображение', 'wescle' ); ?></label></div>
                                <div class="term__image__wrapper">
                                    <div><img <?php echo $img_src; ?> alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="parallax_bg_image_1" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_parallax">
                            <td>
								<?php
								$value   = get_post_meta( $post->ID, 'parallax_bg_image_2', 1 );
								$img_src = '';
								if ( $value ) {
									if ( $img = wp_get_attachment_image_src( $value, 'medium' ) ) {
										$img_src = 'src="' . $img[0] . '"';
									}
								}
								?>
                                <div><label><?php esc_html_e( 'Параллакс-изображение', 'wescle' ); ?></label></div>
                                <div class="term__image__wrapper">
                                    <div><img <?php echo $img_src; ?> alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="parallax_bg_image_2" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td>
                                <div><label><?php _e( 'Анимационные строки', 'wescle' ); ?></label></div>

                                <div class="wrap-repeater-fields">
                                    <div class="repeater-fields">
										<?php
										$text_items = get_post_meta( $post->ID, 'animated_title_text_items', 1 );
										if ( $text_items ) {
											foreach ( $text_items as $key => $item ) {
												?>
                                                <div class="repeater-row repeater-row__flex flex-wrap animated_title_text_items">
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['title_string']; ?><br/>
                                                            <input type="text" class="regular-text" name="animated_title_text_items[item_text][]" value="<?php echo esc_attr( $item['item_text'] ); ?>">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label><?php echo $this->labels['text_color']; ?></label>
                                                        <div>
                                                            <input type="text" class="widefat color-picker" data-alpha-enabled="false" name="animated_title_text_items[item_color][]" value="<?php echo esc_attr( $item['item_color'] ); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="repeater-field alignright">
                                                        <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                    </div>
                                                </div>
												<?php
											}
										}
										?>
                                        <div class="repeater-field-hidden">
                                            <div class="repeater-row repeater-row__flex flex-wrap">
                                                <div class="repeater-field">
                                                    <label>
														<?php echo $this->labels['title_string']; ?><br/>
                                                        <input type="text" class="regular-text" name="animated_title_text_items[item_text][]" value="">
                                                    </label>
                                                </div>
                                                <div class="repeater-field">
                                                    <label><?php echo $this->labels['text_color']; ?></label>
                                                    <div>
                                                        <input type="text" class="widefat color-picker-init" data-alpha-enabled="false" name="animated_title_text_items[item_color][]" value="">
                                                    </div>
                                                </div>
                                                <div class="repeater-field alignright">
                                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="button-secondary repeater-add-item" data-limit="3"><?php echo $this->labels['button_add_string']; ?></button>
                                    <p class="limit"><?php _e( 'Ограничение', 'wescle' ); ?>: 3</p>
                                </div>

                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'animated_title_2', 1 );
								?>
                                <div><label><?php esc_html_e( 'Текст второй строки', 'wescle' ); ?></label></div>
                                <textarea name="animated_title_2" class="regular-text"><?php echo esc_textarea( $value ); ?></textarea>
                                <p class="description"><?php _e( 'для выделения текста цветом используйте код', 'wescle' ); ?> <code><?php echo htmlspecialchars( '<span class="colored-text">' ); ?>lorem ipsum dolor<?php echo htmlspecialchars( '</span>' ); ?></code></p>
                            </td>
                        </tr>
                        <tr class="field-slider_animated">
                            <td class="customize-control-kirki-color">
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_title_2_color', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Цвет выделенного текста второй строки', 'wescle' ); ?></label></div>
                                <div class="wp-picker-container">
                                    <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="animated_title_2_color" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td>
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_title_3', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Текст третьей строки', 'wescle' ); ?></label></div>
                                <textarea name="animated_title_3" class="regular-text"><?php echo esc_textarea( $value ); ?></textarea>
                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td>
                                <div><label><?php _e( 'Кнопки', 'wescle' ); ?></label></div>

                                <div class="wrap-repeater-fields">
                                    <div class="repeater-fields">
										<?php
										$animated_buttons = get_post_meta( $post->ID, 'animated_buttons', 1 );
										if ( $animated_buttons ) {
											foreach ( $animated_buttons as $key => $item ) {
												if ( ! isset( $item['is_blank'] ) ) {
													$item['is_blank'] = '';
												}
												?>
                                                <div class="repeater-row repeater-row__flex  flex-wrap">
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['button_text']; ?><br/>
                                                            <input type="text" class="regular-text" name="animated_buttons[button_text][]" value="<?php echo esc_attr( $item['button_text'] ); ?>">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['button_link']; ?><br/>
                                                            <input type="text" class="regular-text" name="animated_buttons[button_url][]" value="<?php echo esc_attr( $item['button_url'] ); ?>">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field">
                                                        <label>
															<?php echo $this->labels['button_link_is_blank']; ?><br/>
                                                            <input type="checkbox" class="repeater-input-checkbox" data-input_name="animated_buttons[is_blank][]" name="animated_buttons[is_blank][<?php echo $key; ?>]" value="1" <?php checked( $item['is_blank'], '1' ); ?>>
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field alignright">
                                                        <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                    </div>
                                                </div>
												<?php
											}
										}
										?>
                                        <div class="repeater-field-hidden">
                                            <div class="repeater-row repeater-row__flex flex-wrap">
                                                <div class="repeater-field">
                                                    <label>
					                                    <?php echo $this->labels['button_text']; ?><br/>
                                                        <input type="text" class="regular-text" name="animated_buttons[button_text][]" value="">
                                                    </label>
                                                </div>
                                                <div class="repeater-field">
                                                    <label>
					                                    <?php echo $this->labels['button_link']; ?><br/>
                                                        <input type="text" class="regular-text" name="animated_buttons[button_url][]" value="">
                                                    </label>
                                                </div>
                                                <div class="repeater-field">
                                                    <label>
					                                    <?php echo $this->labels['button_link_is_blank']; ?><br/>
                                                        <input type="checkbox" class="repeater-input-checkbox" data-input_name="animated_buttons[is_blank][]" value="1">
                                                    </label>
                                                </div>
                                                <div class="repeater-field alignright">
                                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_button']; ?></button>
                                </div>

                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td>
                                <div><label><?php _e( 'Преимущества', 'wescle' ); ?></label></div>

                                <div class="wrap-repeater-fields">
                                    <div class="repeater-fields">
										<?php
										$animated_advantages = get_post_meta( $post->ID, 'animated_advantages', 1 );
										if ( $animated_advantages ) {
											foreach ( $animated_advantages as $key => $item ) {
												?>
                                                <div class="repeater-row repeater-row__flex">
                                                    <div class="repeater-field repeater-field-one">
                                                        <label>
															<?php echo $this->labels['title_advantage']; ?><br/>
                                                            <input type="text" class="large-text" name="animated_advantages[]" value="<?php echo esc_attr( $item['item_text'] ); ?>">
                                                        </label>
                                                    </div>
                                                    <div class="repeater-field alignright">
                                                        <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                    </div>
                                                </div>
												<?php
											}
										}
										?>
                                        <div class="repeater-field-hidden">
                                            <div class="repeater-row repeater-row__flex flex-wrap">
                                                <div class="repeater-field repeater-field-one">
                                                    <label>
														<?php echo $this->labels['title_advantage']; ?><br/>
                                                        <input type="text" class="large-text" name="animated_advantages[]" value="">
                                                    </label>
                                                </div>
                                                <div class="repeater-field alignright">
                                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_advantage']; ?></button>
                                </div>

                            </td>
                        </tr>
                        <tr class="field-slider_animated">
                            <td class="customize-control-kirki-color">
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_advantages_img_color', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Цвет иконки преимуществ', 'wescle' ); ?></label></div>
                                <div class="wp-picker-container">
                                    <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="animated_advantages_img_color" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td>
					            <?php
					            $value   = get_post_meta( $post->ID, 'animated_bg_image_1', 1 );
					            $img_src = '';
					            if ( $value ) {
									if ( $img = wp_get_attachment_image_src( $value, 'medium' ) ) {
										$img_src = 'src="' . $img[0] . '"';
									}
								}
								?>
                                <div><label><?php esc_html_e( 'Изображение', 'wescle' ); ?></label></div>
                                <div class="term__image__wrapper">
                                    <div><img <?php echo $img_src; ?> alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="animated_bg_image_1" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td class="customize-control-kirki-color">
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_play_bg_color', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Цвет фона иконки play', 'wescle' ); ?></label></div>
                                <div class="wp-picker-container">
                                    <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="animated_play_bg_color" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>
                        <tr class="field-slider_animated">
                            <td class="customize-control-kirki-color">
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_play_color', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Цвет иконки play', 'wescle' ); ?></label></div>
                                <div class="wp-picker-container">
                                    <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="animated_play_color" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>
                        <tr class="field-slider_animated">
                            <td class="customize-control-kirki-color">
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_play_border_color', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Цвет границы круга иконки play', 'wescle' ); ?></label></div>
                                <div class="wp-picker-container">
                                    <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="animated_play_border_color" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>
                        <tr class="field-slider_animated">
                            <td class="customize-control-kirki-color">
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_play_color_text', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Цвет текста иконки play', 'wescle' ); ?></label></div>
                                <div class="wp-picker-container">
                                    <input type="text" class="widefat color-picker" data-alpha-enabled="true" name="animated_play_color_text" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td>
					            <?php
					            $value = get_post_meta( $post->ID, 'animated_play_label', 1 );
					            ?>
                                <div><label><?php esc_html_e( 'Надпись на play кнопке', 'wescle' ); ?></label></div>
                                <input type="text" name="animated_play_label" class="regular-text" value="<?php echo esc_attr( $value ); ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_animated">
                            <td>
								<?php
								$value = get_post_meta( $post->ID, 'animated_video_href', 1 );
								?>
                                <div><label><?php esc_html_e( 'Ссылка на видео с Youtube', 'wescle' ); ?></label></div>
                                <input type="text" name="animated_video_href" class="regular-text" value="<?php echo esc_attr( $value ); ?>">
                            </td>
                        </tr>

                        <tr class="field-slider_banner field-slider_store field-slider_animated field-slider_parallax">
                            <td>
                                <h4 class="section-subtitle"><?php _e( 'Стиль кнопок', 'wescle' ); ?></h4>
                            </td>
                        </tr>

                        <tr class="field-slider_banner field-slider_store field-slider_animated field-slider_parallax">
                            <td>
								<?php $button_type = get_post_meta( $post->ID, 'slider_button_type', 1 ); ?>
                                <select name="slider_button_type">
                                    <option value="default" <?php selected( 'default', $button_type ); ?>><?php _e( 'От настроек базового цвета', 'wescle' ); ?></option>
                                    <option value="custom" <?php selected( 'custom', $button_type ); ?>><?php _e( 'Обычная кнопка', 'wescle' ); ?></option>
                                    <option value="animation" <?php selected( 'animation', $button_type ); ?>><?php _e( 'Кнопка анимационная', 'wescle' ); ?></option>
                                </select>
                            </td>
                        </tr>

                        <tr class="field-slider_banner field-slider_store field-slider_animated field-slider_parallax field-button_type_custom">
                            <td>
                                <div><label><?php esc_html_e( 'Цвет текста', 'wescle' ); ?></label></div>
								<?php $value = get_post_meta( $post->ID, 'slider_button_color', 1 ); ?>
                                <input type="text" class="color-picker" name="slider_button_color" value="<?php echo $value; ?>">

                                <div><label><?php esc_html_e( 'Цвет текста', 'wescle' ); ?>&nbsp;<?php _e( 'при наведении', 'wescle' ); ?></label></div>
								<?php $value = get_post_meta( $post->ID, 'slider_button_color_hover', 1 ); ?>
                                <input type="text" class="color-picker" name="slider_button_color_hover" value="<?php echo $value; ?>">

                                <div><label><?php esc_html_e( 'Фон', 'wescle' ); ?> </label></div>
								<?php $value = get_post_meta( $post->ID, 'slider_button_bg', 1 ); ?>
                                <input type="text" class="color-picker" name="slider_button_bg" value="<?php echo $value; ?>">

                                <div><label><?php esc_html_e( 'Фон', 'wescle' ); ?>&nbsp;<?php _e( 'при наведении', 'wescle' ); ?></label></div>
								<?php $value = get_post_meta( $post->ID, 'slider_button_bg_hover', 1 ); ?>
                                <input type="text" class="color-picker" name="slider_button_bg_hover" value="<?php echo $value; ?>">

                                <div><label><?php esc_html_e( 'Обводка', 'wescle' ); ?> </label></div>
								<?php $value = get_post_meta( $post->ID, 'slider_button_border', 1 ); ?>
                                <input type="text" class="color-picker" name="slider_button_border" value="<?php echo $value; ?>">

                                <div><label><?php esc_html_e( 'Обводка', 'wescle' ); ?>&nbsp;<?php _e( 'при наведении', 'wescle' ); ?></label></div>
								<?php $value = get_post_meta( $post->ID, 'slider_button_border_hover', 1 ); ?>
                                <input type="text" class="color-picker" name="slider_button_border_hover" value="<?php echo $value; ?>">

                                <div class="field-button_settings_animation">
                                    <div><label><?php esc_html_e( 'Цвет блика анимационного', 'wescle' ); ?> </label></div>
									<?php $value = get_post_meta( $post->ID, 'slider_button_blick_color', 1 ); ?>
                                    <input type="text" class="color-picker" name="slider_button_blick_color" value="<?php echo $value; ?>">

                                    <div><label><?php esc_html_e( 'Цвет блика анимационного', 'wescle' ); ?>&nbsp;<?php _e( 'при наведении', 'wescle' ); ?></label></div>
									<?php $value = get_post_meta( $post->ID, 'slider_button_blick_color_hover', 1 ); ?>
                                    <input type="text" class="color-picker" name="slider_button_blick_color_hover" value="<?php echo $value; ?>">

                                    <div><label><?php esc_html_e( 'Скорость анимации на кнопке', 'wescle' ); ?></label></div>
									<?php
									$value = get_post_meta( $post->ID, 'slider_button_blick_speed', 1 );
									$value = $value ? $value : 4;
									?>
                                    <input type="number" name="slider_button_blick_speed" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
                                <h4 class="section-subtitle"><?php _e( 'Позиционирование', 'wescle' ); ?></h4>
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
								<?php $position = get_post_meta( $post->ID, 'animated_position_content', 1 ); ?>
                                <select name="animated_position_content">
                                    <option value="default" <?php selected( 'default', $position ); ?>><?php _e( 'По умолчанию', 'wescle' ); ?></option>
                                    <option value="left" <?php selected( 'left', $position ); ?>><?php _e( 'Слева', 'wescle' ); ?></option>
                                    <option value="center" <?php selected( 'center', $position ); ?>><?php _e( 'Центр', 'wescle' ); ?></option>
                                    <option value="right" <?php selected( 'right', $position ); ?>><?php _e( 'Справа', 'wescle' ); ?></option>
                                </select>
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
                                <h4 class="section-subtitle"><?php _e( 'Кастомизация стиля блока', 'wescle' ); ?></h4>
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
								<?php
								$value   = get_post_meta( $post->ID, 'backgroundImage', 1 );
								$img_src = '';
								if ( $value ) {
									if ( $img = wp_get_attachment_image_src( $value, 'medium' ) ) {
										$img_src = 'src="' . $img[0] . '"';
									}

								}
								?>
                                <div><label><?php esc_html_e( 'Фоновое изображение', 'wescle' ); ?>&nbsp;<?php esc_html_e( 'на ПК (1280-1920)', 'wescle' ); ?></label></div>
                                <div class="term__image__wrapper">
                                    <div><img <?php echo $img_src; ?> alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="backgroundImage" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
                                <div><label><?php esc_html_e( 'Режим заполнения', 'wescle' ); ?> (object-fit), <?php esc_html_e( 'на ПК (1280-1920)', 'wescle' ); ?></label></div>
								<?php $bg_fit = get_post_meta( $post->ID, 'animated_image_bg_fit', 1 ); ?>
                                <select name="animated_image_bg_fit">
                                    <option value="cover" <?php selected( 'cover', $bg_fit ); ?>>cover</option>
                                    <option value="contain" <?php selected( 'contain', $bg_fit ); ?>>contain</option>
                                    <option value="fill" <?php selected( 'fill', $bg_fit ); ?>>fill</option>
                                    <option value="none" <?php selected( 'none', $bg_fit ); ?>>none</option>
                                </select>
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
								<?php
								$value   = get_post_meta( $post->ID, 'backgroundImageTablet', 1 );
								$img_src = '';
								if ( $value ) {
									if ( $img = wp_get_attachment_image_src( $value, 'medium' ) ) {
										$img_src = 'src="' . $img[0] . '"';
									}
								}
								?>
                                <div><label><?php esc_html_e( 'Фоновое изображение', 'wescle' ); ?>&nbsp;<?php esc_html_e( 'на планшете (768-1280)', 'wescle' ); ?></label></div>
                                <div class="term__image__wrapper">
                                    <div><img <?php echo $img_src; ?> alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="backgroundImageTablet" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
                                <div><label><?php esc_html_e( 'Режим заполнения', 'wescle' ); ?> (object-fit), <?php esc_html_e( 'на планшете (768-1280)', 'wescle' ); ?></label></div>
								<?php $bg_fit = get_post_meta( $post->ID, 'animated_image_bg_fit_tablet', 1 ); ?>
                                <select name="animated_image_bg_fit_tablet">
                                    <option value="cover" <?php selected( 'cover', $bg_fit ); ?>>cover</option>
                                    <option value="contain" <?php selected( 'contain', $bg_fit ); ?>>contain</option>
                                    <option value="fill" <?php selected( 'fill', $bg_fit ); ?>>fill</option>
                                    <option value="none" <?php selected( 'none', $bg_fit ); ?>>none</option>
                                </select>
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
								<?php
								$value   = get_post_meta( $post->ID, 'backgroundImagePhone', 1 );
								$img_src = '';
								if ( $value ) {
									if ( $img = wp_get_attachment_image_src( $value, 'medium' ) ) {
										$img_src = 'src="' . $img[0] . '"';
									}
								}
								?>
                                <div><label><?php esc_html_e( 'Фоновое изображение', 'wescle' ); ?>&nbsp;<?php esc_html_e( 'на телефоне (320-768)', 'wescle' ); ?></label></div>
                                <div class="term__image__wrapper">
                                    <div><img <?php echo $img_src; ?> alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="backgroundImagePhone" value="<?php echo $value; ?>">
                                </div>
                            </td>
                        </tr>

                        <tr class="field-slider_animated field-slider_parallax">
                            <td>
                                <div><label><?php esc_html_e( 'Режим заполнения', 'wescle' ); ?> (object-fit), <?php esc_html_e( 'на телефоне (320-768)', 'wescle' ); ?></label></div>
								<?php $bg_fit = get_post_meta( $post->ID, 'animated_image_bg_fit_mobile', 1 ); ?>
                                <select name="animated_image_bg_fit_mobile">
                                    <option value="cover" <?php selected( 'cover', $bg_fit ); ?>>cover</option>
                                    <option value="contain" <?php selected( 'contain', $bg_fit ); ?>>contain</option>
                                    <option value="fill" <?php selected( 'fill', $bg_fit ); ?>>fill</option>
                                    <option value="none" <?php selected( 'none', $bg_fit ); ?>>none</option>
                                </select>
                            </td>
                        </tr>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
		<?php
	}

	public function script_landing_info() {
		?>
        <script>
            jQuery(document).ready(function ($) {
                function show_hide_wescle_landing_settings(template) {
                    if ('templates/template-landing.php' == template) {
                        $('#wescle_landing_settings_info').hide();
                        $('#wescle_landing_settings').show();
                        $('#blocks_show_post_type_meta_box').hide();
                    } else {
                        $('#wescle_landing_settings_info').show();
                        $('#wescle_landing_settings').hide();
                        $('#blocks_show_post_type_meta_box').show();
                    }
                }

                show_hide_wescle_landing_settings(server_data.template);

                $('body').on('change', '.interface-interface-skeleton__sidebar select', function () {
                    let select_val = $(this).val();
                    if (select_val.indexOf('templates/') != -1) {
                        show_hide_wescle_landing_settings(select_val);
                    }
                })

                //$('.wescle-select2').select2();
                $('.sortable_meta').sortable();

                $('.customize-control-kirki-color .color-picker, .field-slider_store .color-picker').each(function () {
                    $(this).wpColorPicker();
                });

                if ($('#landing-slider_layout').length) {
                    $('.form-table-custom .customize-control-kirki-slider').each(function () {
                        var block = $(this);

                        var rangeInput = block.find('input[type="range"]');
                        var textInput = block.find('input[type="text"]');
                        var rangeReset = block.find('.slider-reset');

                        rangeInput.on('change input', function () {
                            textInput.val(rangeInput.val());
                        });

                        textInput.on('keyup', function () {
                            rangeInput.val(textInput.val());
                        });

                        rangeReset.on('click', function () {
                            rangeInput.val(rangeReset.attr('data-default')).trigger('change');
                        });
                    });
                }

                function show_hide_slider_layout_blocks() {
                    var block_settings = $('#settings_first_screen');
                    var block_speed = $('#customize-control-slider_autoplay_speed');
                    var block_arrows = $('#customize-control-slider_dots, #customize-control-slider_arrows');
                    var block_gradient = $('#customize-control-slider_image_without_gradient');
                    var block_bg = $('#customize-control-home_slider_carousel_color_bg');
                    var parallax_color_text = $('#customize-control-parallax_color_text');

                    block_settings.hide();
                    block_speed.hide();
                    block_arrows.hide();
                    block_gradient.hide();
                    block_bg.hide();
                    parallax_color_text.hide();

                    var slider_layout = $('#input_slider_layout input:checked').val();
                    if (slider_layout == 'none' || slider_layout == 'animated' || slider_layout == 'parallax') {
                        if (slider_layout == 'animated' || slider_layout == 'parallax') {
                            block_settings.show();
                            block_bg.show();
                        }
                        if (slider_layout == 'parallax') {
                            parallax_color_text.show();
                        }
                    } else {
                        block_settings.show();
                        block_gradient.show();
                        block_bg.show();

                        if (slider_layout == 'columns_one_two' || slider_layout == 'columns_one_four') {

                        } else {
                            block_speed.show();
                            block_arrows.show();
                        }
                    }

                    block_settings.find('tr').each(function () {
                        if ($(this).hasClass('field-slider_' + slider_layout)) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });
                }

                show_hide_slider_layout_blocks();
                $('#input_slider_layout input').change(function () {
                    show_hide_opacity_setting();
                    show_hide_slider_layout_blocks();
                    show_hide_button_settings();
                });

                function show_hide_opacity_setting() {
                    var slider_layout = $('#input_slider_layout input:checked').val();
                    if ($('#slider_image_without_gradient').prop('checked') || slider_layout == 'none' || slider_layout == 'animated' || slider_layout == 'parallax') {
                        $('#customize-control-slider_image_opacity').hide();
                    } else {
                        $('#customize-control-slider_image_opacity').show();
                    }
                }

                show_hide_opacity_setting();
                $('#slider_image_without_gradient').change(function () {
                    show_hide_opacity_setting();
                });

                function show_hide_content_box() {
                    if ('default' == $('.landing_content_box:checked').val()) {
                        $('#customize-control-content_box_width').hide();
                        $('#customize-control-content_box_inner_width').hide();
                    } else if ('box' == $('.landing_content_box:checked').val()) {
                        $('#customize-control-content_box_width').show();
                        $('#customize-control-content_box_inner_width').hide();
                    } else if ('box_inner' == $('.landing_content_box:checked').val()) {
                        $('#customize-control-content_box_width').hide();
                        $('#customize-control-content_box_inner_width').show();
                    }
                }

                show_hide_content_box();
                $('.landing_content_box').change(function () {
                    show_hide_content_box();
                });

                function init_wpColorPicker() {
                    $('.repeater-row .color-picker').each(function () {
                        $(this).wpColorPicker();
                    });
                }

                init_wpColorPicker();

                $('body').on('wescle_repeater-add-item', function (e, block_fields) {
                    set_radio_checkbox_keys();

                    $.each($(block_fields).find('.repeater-row'), function (e, obj) {
                        if ($(obj).parent().hasClass('repeater-fields')) {
                            var input_color = $(obj).find('.color-picker-init');
                            if (input_color.length) {
                                input_color.removeClass('color-picker-init').wpColorPicker();
                            }
                        }
                    });
                });

                $('body').on('wescle_repeater-remove-item', function (e, block_fields) {
                    set_radio_checkbox_keys();
                });

                function set_radio_checkbox_keys() {
                    $('.wescle-metabox .repeater-fields > .repeater-row').each(function (index_row, obj) {
                        $(this).find('.banner_text_width').each(function () {
                            $(this).attr('name', 'wescle_slider_banners[text_width][' + index_row + ']');
                        });
                    });

                    $('.wescle-metabox .repeater-fields').each(function (index_row, obj_parent) {
                        var ind_keys = 0;
                        $(obj_parent).find('.repeater-row').each(function (ind, obj) {

                            $(this).find('.repeater-input-checkbox').each(function () {
                                var name = $(this).attr('data-input_name');
                                name = name.replace('[]', '[' + ind_keys + ']');
                                $(this).attr('name', name);
                            });
                            ind_keys++;

                        });
                    });
                }

                function show_hide_store_settings(value, type) {
                    var slider_layout = $('#input_slider_layout input:checked').val();
                    if (slider_layout == 'store') {
                        if ('custom' == value) {
                            $('.field-slider_store_' + type + '-type_product').hide();
                            $('.field-slider_store_' + type + '-type_custom').show();
                        } else {
                            $('.field-slider_store_' + type + '-type_product').show();
                            $('.field-slider_store_' + type + '-type_custom').hide();
                        }
                    } else {
                        $('.field-slider_store_one-type_product').hide();
                        $('.field-slider_store_one-type_custom').hide();
                        $('.field-slider_store_two-type_product').hide();
                        $('.field-slider_store_two-type_custom').hide();
                    }
                }

                $('input[name="slider_store_one_type"]').change(function () {
                    show_hide_store_settings($(this).val(), 'one');
                });

                $('input[name="slider_store_two_type"]').change(function () {
                    show_hide_store_settings($(this).val(), 'two');
                });

                show_hide_store_settings($('input[name="slider_store_one_type"]:checked').val(), 'one');
                show_hide_store_settings($('input[name="slider_store_two_type"]:checked').val(), 'two');

                function show_hide_button_settings(value, type) {
                    var slider_layout = $('#input_slider_layout input:checked').val();
                    if (slider_layout == 'store' || slider_layout == 'banner' || slider_layout == 'animated' || slider_layout == 'parallax') {
                        var button_type = $('select[name="slider_button_type"]').val();
                        if (button_type == 'default' || type == 'default') {
                            $('.field-button_type_custom').hide();
                        } else {
                            $('.field-button_type_custom').show();
                        }

                        if (button_type == 'animation') {
                            $('.field-button_settings_animation').show();
                        } else {
                            $('.field-button_settings_animation').hide();
                        }
                    }
                }

                show_hide_button_settings();

                $('select[name="slider_button_type"]').change(function () {
                    show_hide_button_settings();
                });
            });
        </script>
		<?php
	}

	public function sortable_card_blocks() {
		return [
			'category' => esc_html__( 'Категория', 'wescle' ),
			'title'    => esc_html__( 'Заголовок', 'wescle' ),
			'meta'     => esc_html__( 'Мета', 'wescle' ),
		];
	}
}

new MetaBoxLanding();