<?php

class MetaBoxInfoTab extends MetaBoxPost {

	protected $labels = [];

	public function __construct() {
		$this->set_settings( array(
			'post_type'      => [ 'infotab_wescle' ],
			'meta_box_title' => esc_html__( 'Настройки - Инфо-таб', 'wescle' ),
		) );

		add_action( 'load-post.php', array( $this, 'init' ) );
		add_action( 'load-post-new.php', array( $this, 'init' ) );

		add_action( 'load-post.php', array( $this, 'init_cpt' ) );
		add_action( 'load-post-new.php', array( $this, 'init_cpt' ) );
	}

	public function set_fields() {
		$current_screen = get_current_screen();
		if ( in_array( $current_screen->post_type, $this->post_type ) ) {
			$type_title_field            = header_title_type_block();
			$type_title_field['options'] = $type_title_field['choices'];
			$type_title_field['name']    = 'title_type';

			$this->fields[] = [
				'type'  => 'image',
				'name'  => 'icon',
				'label' => __( 'Изображение', 'wescle' )
			];

			$this->fields[] = [
				'type'  => 'color',
				'name'  => 'color_active',
				'label' => __( 'Цвет активного таба', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'text',
				'name'  => 'tooltip',
				'label' => __( 'Всплывающий текст, подсказка', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'text',
				'name'  => 'custom_title',
				'label' => __( 'Кастомный заголовок', 'wescle' ),
			];

			$this->fields[] = $type_title_field;

			$this->fields[] = [
				'type'  => 'text',
				'name'  => 'button_text',
				'label' => esc_html__( 'Надпись на кнопке', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'text',
				'name'  => 'button_link',
				'label' => esc_html__( 'Ссылка для кнопки', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'checkbox',
				'name'  => 'button_link_is_blank',
				'label' => esc_html__( 'Открывать ссылку в новом окне?', 'wescle' ),
			];
		}
	}

	public function init_cpt() {
		$this->labels = [
			'title_icon'       => __( 'Изображение', 'wescle' ),
			'button_icon'      => __( 'Выбрать изображение', 'wescle' ),
			'button_add'       => __( 'Добавить', 'wescle' ),
			'button_remove'    => __( 'Удалить', 'wescle' ),
			'title'            => __( 'Заголовок', 'wescle' ),
			'text'             => __( 'Текст', 'wescle' ),
			'url'              => __( 'URL', 'wescle' ),
			'bg_color'         => __( 'Фон вокруг изображения', 'wescle' ),
			'button_add_image' => __( 'Добавить изображение', 'wescle' ),
			'button_add_item'  => __( 'Добавить объект', 'wescle' ),
		];

		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );
	}

	public function add_meta_box( $post_type ) {
		if ( in_array( $post_type, $this->post_type ) ) {
			add_meta_box(
				'wescle_gallery_images',
				__( 'Галерея', 'wescle' ),
				array( $this, 'render_wescle_gallery_images' ),
				$post_type,
				'advanced',
				'low'
			);

			add_meta_box(
				'wescle_infotab_info',
				__( 'Объекты в табе', 'wescle' ),
				array( $this, 'render_meta_box_content' ),
				$post_type,
				'advanced',
				'low'
			);
		}
	}

	public function save( $post_id ) {

		if ( ! isset( $_POST['wescle_infotab_info_nonce'] ) ) {
			return;
		}

		$nonce = $_POST['wescle_infotab_info_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'wescle_infotab_info' ) ) {
			return;
		}

		// Если это автосохранение ничего не делаем.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Проверяем права пользователя.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		$option = $_POST['gallery_slider'] ? 1 : '';
		update_post_meta( $post_id, 'gallery_slider', $option );

		$option = $_POST['slider_arrows'] ? 1 : '';
		update_post_meta( $post_id, 'slider_arrows', $option );

		$option = $_POST['slider_dots'] ? 1 : '';
		update_post_meta( $post_id, 'slider_dots', $option );

		$option = $_POST['slider_autoplay'] ? 1 : '';
		update_post_meta( $post_id, 'slider_autoplay', $option );

		update_post_meta( $post_id, 'slider_autoplay_speed', $_POST['slider_autoplay_speed'] );
		update_post_meta( $post_id, 'slider_count', $_POST['slider_count'] );
		update_post_meta( $post_id, 'count_in_row', $_POST['count_in_row'] );

		$wescle_images = $_POST['gallery_images'] ?? [];
		$data          = [];
		if ( $wescle_images ) {
			foreach ( $wescle_images['image'] as $key => $img_id ) {
				if ( $img_id ) {
					$title = $wescle_images['title'][ $key ];
					$url   = $wescle_images['url'][ $key ];

					$data[] = [
						'img_id' => intval( $img_id ),
						'title'  => $title,
						'url'    => $url,
					];
				}
			}
		}
		if ( $data ) {
			update_post_meta( $post_id, 'gallery_images', $data );
		}
		else {
			delete_post_meta( $post_id, 'gallery_images' );
		}

		$wescle_infotab_info = $_POST['infotab_info'];
		$data                = [];
		if ( $wescle_infotab_info ) {
			foreach ( $wescle_infotab_info['image'] as $key => $img_id ) {
				$title = $wescle_infotab_info['title'][ $key ];
				$text  = $wescle_infotab_info['text'][ $key ];

				if ( $title || $text ) {
					$data[] = [
						'img_id' => $img_id,
						'title'  => $title,
						'text'   => $text,
					];
				}
			}
		}
		update_post_meta( $post_id, 'infotab_info', $data );
	}

	public function render_meta_box_content( $post ) {
		wp_enqueue_media();

		$wescle_infotab_info = get_post_meta( $post->ID, 'infotab_info', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_infotab_info', 'wescle_infotab_info_nonce' ); ?>

            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $wescle_infotab_info ) {
						foreach ( $wescle_infotab_info as $item ) {
							$img_src = '';
							if ( $item['img_id'] ) {
								$img     = wp_get_attachment_image_src( $item['img_id'], 'medium' );
								$img_src = 'src="' . $img[0] . '"';
							}
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_icon']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div><img <?php echo $img_src; ?> alt=""></div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" data-type="image" name="infotab_info[image][]" value="<?php echo $item['img_id']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['title']; ?>
                                        <input type="text" class="widefat" name="infotab_info[title][]" value="<?php echo esc_attr( $item['title'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field" style="width: 20%">
                                    <label>
										<?php echo $this->labels['text']; ?>
                                        <textarea class="widefat" name="infotab_info[text][]" rows="4"><?php echo esc_textarea( $item['text'] ); ?></textarea>
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_icon']; ?></label>
                                <div class="term__image__wrapper">
                                    <div><img alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="infotab_info[image][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['title']; ?>
                                    <input type="text" class="widefat" name="infotab_info[title][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field" style="width: 20%">
                                <label>
									<?php echo $this->labels['text']; ?>
                                    <textarea class="widefat" name="infotab_info[text][]" rows="4"></textarea>
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}

	public function render_wescle_gallery_images( $post ) {
		add_action( 'admin_print_footer_scripts', [ $this, 'footer_scripts' ], 99 );

		$data_images = get_post_meta( $post->ID, 'gallery_images', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_infotab_info', 'wescle_infotab_info_nonce' ); ?>

            <p class="wrap-count_in_row">
                <label for="count_in_row"><?php _e( 'Количество изображений в ряду', 'wescle' ); ?></label>
                <input type="number" id="count_in_row" name="count_in_row" value="<?php echo get_post_meta( $post->ID, 'count_in_row', 1 ); ?>" placeholder="5" class="small-text">
            </p>

            <p>
                <input type="checkbox" id="gallery_slider" name="gallery_slider" value="1" <?php checked( get_post_meta( $post->ID, 'gallery_slider', 1 ), '1' ); ?>>
                <label for="gallery_slider"><?php _e( 'Включить слайдер?', 'wescle' ); ?></label>
            </p>

            <div class="gallery_slider_settings">
                <p>
                    <input type="checkbox" id="slider_arrows" name="slider_arrows" value="1" <?php checked( get_post_meta( $post->ID, 'slider_arrows', 1 ), '1' ); ?>>
                    <label for="slider_arrows"><?php _e( 'Показывать кнопки "стрелки" слайдера?', 'wescle' ); ?></label>
                </p>
                <p>
                    <input type="checkbox" id="slider_dots" name="slider_dots" value="1" <?php checked( get_post_meta( $post->ID, 'slider_dots', 1 ), '1' ); ?>>
                    <label for="slider_dots"><?php _e( 'Добавить кнопки "точки" слайдера?', 'wescle' ); ?></label>
                </p>
                <p>
                    <label for="slider_count"><?php _e( 'Количество слайдов', 'wescle' ); ?></label>
                    <input type="number" step="0.1" id="slider_count" name="slider_count" value="<?php echo get_post_meta( $post->ID, 'slider_count', 1 ); ?>" placeholder="5" class="small-text">
                    <span class="description"><?php printf( __( 'например: %s или %s', 'wescle' ), '<code>4</code>', '<code>3.5</code>' ); ?></span>
                </p>
                <p>
                    <input type="checkbox" id="slider_autoplay" name="slider_autoplay" value="1" <?php checked( get_post_meta( $post->ID, 'slider_autoplay', 1 ), '1' ); ?>>
                    <label for="slider_autoplay"><?php _e( 'Включить автоматическое переключение слайдов?', 'wescle' ); ?></label>
                </p>
                <p>
                    <label for="slider_autoplay_speed"><?php _e( 'Скорость переключения слайдов, сек', 'wescle' ); ?></label>
                    <input type="number" id="slider_autoplay_speed" name="slider_autoplay_speed" value="<?php echo get_post_meta( $post->ID, 'slider_autoplay_speed', 1 ); ?>" class="small-text">
                </p>
            </div>

            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $data_images ) {
						foreach ( $data_images as $item ) {
							$img_src = '';
							if ( $item['img_id'] ) {
								$img     = wp_get_attachment_image_src( $item['img_id'], 'medium' );
								$img_src = 'src="' . $img[0] . '"';
							}
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_icon']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div><img <?php echo $img_src; ?> alt=""></div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" name="gallery_images[image][]" value="<?php echo $item['img_id']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['title']; ?>
                                        <input type="text" class="widefat" name="gallery_images[title][]" value="<?php echo esc_attr( $item['title'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['url']; ?>
                                        <input type="text" class="widefat" name="gallery_images[url][]" value="<?php echo esc_attr( $item['url'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_icon']; ?></label>
                                <div class="term__image__wrapper">
                                    <div><img alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="gallery_images[image][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field">
                                <label>
			                        <?php echo $this->labels['title']; ?>
                                    <input type="text" class="widefat" name="gallery_images[title][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
			                        <?php echo $this->labels['url']; ?>
                                    <input type="text" class="widefat" name="gallery_images[url][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_image']; ?></button>
            </div>
        </div>
		<?php
	}

	public function footer_scripts() {
		?>
        <script>
            jQuery(document).ready(function ($) {
                function slider_settings_visible() {
                    if ($('#gallery_slider').prop('checked')) {
                        $('.gallery_slider_settings').show();
                        $('.wrap-count_in_row').hide();
                    } else {
                        $('.gallery_slider_settings').hide();
                        $('.wrap-count_in_row').show();
                    }
                }

                slider_settings_visible();

                $('#gallery_slider').change(function () {
                    slider_settings_visible();
                });
            })
        </script>
		<?php
	}
}

new MetaBoxInfoTab();