<?php

class MetaBoxGallery {

	protected $labels = [];

	public function __construct() {
		$this->labels = [
			'title_icon'      => __( 'Изображение', 'wescle' ),
			'button_icon'     => __( 'Выбрать изображение', 'wescle' ),
			'button_add'      => __( 'Добавить', 'wescle' ),
			'button_remove'   => __( 'Удалить', 'wescle' ),
			'button_add_item' => __( 'Добавить', 'wescle' ),
		];

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init_cpt' ) );
			add_action( 'load-post-new.php', array( $this, 'init_cpt' ) );
		}
	}

	public function init_cpt() {
		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );
	}

	public function add_meta_box( $post_type ) {
		if ( 'gallery_wescle' === $post_type ) {
			add_meta_box(
				'wescle_gallery_images',
				__( 'Другие изображения', 'wescle' ),
				array( $this, 'render_wescle_gallery_images' ),
				$post_type,
				'advanced',
				'low'
			);
		}
	}

	public function save( $post_id ) {

		if ( ! isset( $_POST['wescle_gallery_info_nonce'] ) ) {
			return;
		}

		$nonce = $_POST['wescle_gallery_info_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'wescle_meta_info' ) ) {
			return;
		}

		// Если это автосохранение ничего не делаем.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Проверяем права пользователя.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		$wescle_images = $_POST['gallery_images'] ?? [];
		$data          = [];
		if ( $wescle_images ) {
			foreach ( $wescle_images['image'] as $key => $img_id ) {
				if ( $img_id ) {
					$data[] = [
						'img_id' => intval( $img_id ),
					];
				}
			}
		}
		if ( $data ) {
			update_post_meta( $post_id, 'gallery_images', $data );
		}
		else {
			delete_post_meta( $post_id, 'gallery_images' );
		}
	}

	public function render_wescle_gallery_images( $post ) {
		$data_images = get_post_meta( $post->ID, 'gallery_images', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_meta_info', 'wescle_gallery_info_nonce' ); ?>
            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $data_images ) {
						foreach ( $data_images as $item ) {
							$img_src = '';
							if ( $item['img_id'] ) {
								$img     = wp_get_attachment_image_src( $item['img_id'], 'medium' );
								$img_src = 'src="' . $img[0] . '"';
							}
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_icon']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div><img <?php echo $img_src; ?> alt=""></div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" name="gallery_images[image][]" value="<?php echo $item['img_id']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_icon']; ?></label>
                                <div class="term__image__wrapper">
                                    <div><img alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="gallery_images[image][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}
}

new MetaBoxGallery();