<?php

class MetaBoxEvent extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'        => 'checkbox',
				'name'        => 'hide_page_title',
				'label'       => esc_html__( 'Скрыть заголовок страницы?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'        => 'checkbox',
				'name'        => 'hide_contents',
				'label'       => esc_html__( 'Скрыть "Cодержание поста"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'        => 'checkbox',
				'name'        => 'hide_breadcrumbs',
				'label'       => esc_html__( 'Скрыть "Хлебные крошки"?', 'wescle' ),
				'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
			],
			[
				'type'  => 'date',
				'name'  => 'event_date',
				'label' => esc_html__( 'Дата мероприятия', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'event_info',
				'label' => esc_html__( 'Время / Город / Дополнительная информация', 'wescle' ),
			]
		];

		if ( class_exists( 'WPCF7_Mail' ) ) {
			$this->fields[] = [
				'type'        => 'checkbox',
				'name'        => 'show_form_after_content',
				'label'       => esc_html__( 'Показывать контактную форму после контента', 'wescle' ),
				'placeholder' => esc_html__( 'Да', 'wescle' ),
				'description' => esc_html__( 'Выбрать форму можно в Customizer -> Настройка внутренних страниц', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'text',
				'name'  => 'title_form_after_content',
				'label' => esc_html__( 'Заголовок для формы', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'textarea',
				'name'  => 'text_form_after_content',
				'label' => esc_html__( 'Описание для формы', 'wescle' ),
			];
		}

		$this->set_settings( array(
			'post_type'      => [ 'event_wescle' ],
			'meta_box_title' => esc_html__( 'Настройки - Мероприятия', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}