<?php

class MetaBoxCourse extends MetaBoxPost {

	protected $labels = [];

	public function __construct() {
		$this->fields = [
			[
				'type'        => 'text',
				'name'        => 'advantages_title',
				'label'       => __( 'Заголовок для блока с преимуществами', 'wescle' ),
				'description' => __( 'По умолчанию', 'wescle' ) . ': <strong>' . get_theme_mod( 'course_advantages_title', Helper::get_default_theme_data( 'course_advantages_title' ) ) . '</strong>',
			],
			[
				'type'        => 'text',
				'name'        => 'tags_title',
				'label'       => __( 'Заголовок для блока с навыками', 'wescle' ),
				'description' => __( 'По умолчанию', 'wescle' ) . ': <strong>' . get_theme_mod( 'course_tags_title', Helper::get_default_theme_data( 'course_tags_title' ) ) . '</strong>',
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'course_wescle' ],
			'meta_box_title' => __( 'Настройки курса', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );

			add_action( 'load-post.php', array( $this, 'init_cpt' ) );
			add_action( 'load-post-new.php', array( $this, 'init_cpt' ) );
		}
	}

	public function init_cpt() {
		$this->labels = [
			'title_icon'      => __( 'Изображение', 'wescle' ),
			'button_icon'     => __( 'Выбрать изображение', 'wescle' ),
			'button_add'      => __( 'Добавить', 'wescle' ),
			'button_remove'   => __( 'Удалить', 'wescle' ),
			'title'           => __( 'Заголовок', 'wescle' ),
			'text'            => __( 'Текст', 'wescle' ),
			'button_add_item' => __( 'Добавить', 'wescle' ),
		];

		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}

	public function enqueue_scripts() {
		$screen = get_current_screen();
		if ( $screen && 'post' == $screen->base && in_array( $screen->post_type, $this->post_type ) ) {
			//wp_enqueue_style( 'wp-color-picker' );
			//wp_enqueue_script( 'wp-color-picker-alpha', get_template_directory_uri() . '/assets/admin/js/wp-color-picker-alpha.min.js', array( 'wp-color-picker' ), '3.0.0', true );

			wp_enqueue_script( 'selectWoo', get_template_directory_uri() . '/libs/wscl/assets/vendor/selectWoo/js/select2.min.js', array( 'jquery' ), '1.0.1', true );
			wp_enqueue_style( 'selectWoo', get_template_directory_uri() . '/libs/wscl/assets/vendor/selectWoo/css/selectWoo.css', array(), '1.0.1' );
		}
	}

	public function add_meta_box( $post_type ) {
		if ( in_array( $post_type, $this->post_type ) ) {
			add_meta_box(
				'wescle_course_advantages',
				__( 'Преимущества', 'wescle' ),
				array( $this, 'render_wescle_course_advantages' ),
				$post_type,
				'advanced',
				'low'
			);

			add_meta_box(
				'wescle_course_video_ids',
				__( 'Видео для курса', 'wescle' ),
				array( $this, 'render_wescle_course_video_ids' ),
				$post_type,
				'advanced',
				'low'
			);

			add_meta_box(
				'wescle_course_info',
				__( 'Информация о курсе в сайдбаре', 'wescle' ),
				array( $this, 'render_wescle_course_info' ),
				$post_type,
				'advanced',
				'low'
			);
		}
	}

	public function save( $post_id ) {

		if ( ! isset( $_POST['wescle_course_info_nonce'] ) ) {
			return;
		}

		$nonce = $_POST['wescle_course_info_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'wescle_course_info' ) ) {
			return;
		}

		// Если это автосохранение ничего не делаем.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Проверяем права пользователя.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		$wescle_course_info = $_POST['wescle_course_advantages'];
		$data               = [];
		if ( $wescle_course_info ) {
			foreach ( $wescle_course_info['text'] as $key => $text ) {
				if ( $text ) {
					$data[] = [
						'text' => $text,
					];
				}
			}
		}
		update_post_meta( $post_id, 'wescle_course_advantages', $data );


		$wescle_course_video_ids = $_POST['course_video_ids'];
		$course_video_ids        = [];
		if ( $wescle_course_video_ids ) {
			foreach ( $wescle_course_video_ids as $course_video_id ) {
				if ( $course_video_id ) {
					$course_video_ids[] = $course_video_id;
				}
			}
		}
		$course_video_ids = array_unique( $course_video_ids );
		update_post_meta( $post_id, 'course_video_ids', $course_video_ids );


		$wescle_course_info = $_POST['wescle_course_info'];
		$data = [];
		if ( $wescle_course_info ) {
			foreach ( $wescle_course_info['image'] as $key => $img_id ) {
				$title = $wescle_course_info['title'][ $key ];
				$text  = $wescle_course_info['text'][ $key ];

				if ( $title || $text ) {
					$data[] = [
						'img_id' => $img_id,
						'title'  => $title,
						'text'   => $text,
					];
				}
			}
		}
		update_post_meta( $post_id, 'wescle_course_info', $data );
	}

	public function render_wescle_course_advantages( $post ) {
		$wescle_course_advantages = get_post_meta( $post->ID, 'wescle_course_advantages', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_course_info', 'wescle_course_info_nonce' ); ?>

            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $wescle_course_advantages ) {
						foreach ( $wescle_course_advantages as $item ) {
							?>
                            <div class="repeater-row repeater-row__flex repeater-row__count-2">
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['text']; ?>
                                        <textarea class="widefat" name="wescle_course_advantages[text][]" rows="4"><?php echo esc_textarea( $item['text'] ); ?></textarea>
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex repeater-row__count-2">
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['text']; ?>
                                    <textarea class="widefat" name="wescle_course_advantages[text][]" rows="4"></textarea>
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}

	public function render_wescle_course_video_ids( $post ) {
		$course_video_ids = get_post_meta( $post->ID, 'course_video_ids', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_course_info', 'wescle_course_info_nonce' ); ?>

            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					$options_course_video = Helper::get_posts( array(
						'post_type'      => 'course_video',
						'posts_per_page' => - 1,
					), true );
					if ( $course_video_ids ) {
						foreach ( $course_video_ids as $course_video_id ) {
							?>
                            <div class="repeater-row repeater-row__flex repeater-row__count-2">
                                <div class="repeater-field">
                                    <select name="course_video_ids[]" class="widefat wescle-select2">
										<?php
										foreach ( $options_course_video as $key => $option ) {
											$selected = selected( $key, $course_video_id, false );

											echo '<option value="' . $key . '" ' . $selected . '> ' . $option . '</option>';
										}
										?>
                                    </select>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex repeater-row__count-2">
                            <div class="repeater-field">
                                <select name="course_video_ids[]" class="widefat wescle-select2-init">
									<?php
									foreach ( $options_course_video as $key => $option ) {
										echo '<option value="' . $key . '"> ' . $option . '</option>';
									}
									?>
                                </select>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}

	public function render_wescle_course_info( $post ) {
		$wescle_course_info = get_post_meta( $post->ID, 'wescle_course_info', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_course_info', 'wescle_course_info_nonce' ); ?>

            <div class="wrap-repeater-fields">
                <p><?php printf( __( 'Для вывода информации <a href="%s" target="_blank">добавьте виджет</a> "HTML-код" в область "Виджеты на странице курса" и вставьте шорткод', 'wescle' ) . '&nbsp;<code>[course_info]</code>', admin_url( 'widgets.php' ) ); ?></p>
                <div class="repeater-fields">
					<?php
					if ( $wescle_course_info ) {
						foreach ( $wescle_course_info as $item ) {
							$img_src = '';
							if ( $item['img_id'] ) {
								$img     = wp_get_attachment_image_src( $item['img_id'], 'medium' );
								$img_src = 'src="' . $img[0] . '"';
							}
							?>
                            <div class="repeater-row repeater-row__flex repeater-row__count-4">
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_icon']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div><img <?php echo $img_src; ?> alt=""></div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" data-type="image" name="wescle_course_info[image][]" value="<?php echo $item['img_id']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['title']; ?>
                                        <input type="text" class="widefat" name="wescle_course_info[title][]" value="<?php echo esc_attr( $item['title'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['text']; ?>
                                        <textarea class="widefat" name="wescle_course_info[text][]" rows="4"><?php echo esc_textarea( $item['text'] ); ?></textarea>
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex repeater-row__count-4">
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_icon']; ?></label>
                                <div class="term__image__wrapper">
                                    <div><img alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="wescle_course_info[image][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['title']; ?>
                                    <input type="text" class="widefat" name="wescle_course_info[title][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['text']; ?>
                                    <textarea class="widefat" name="wescle_course_info[text][]" rows="4"></textarea>
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}
}

new MetaBoxCourse();

class MetaBoxVideoCourse extends MetaBoxPost {

	public function __construct() {

		$this->fields = [
			[
				'type'        => 'text',
				'name'        => 'youtube_link',
				'label'       => esc_html__( 'Ссылка на YouTube', 'wescle' ),
				'description' => esc_html__( 'укажите ссылку с youtube.com', 'wescle' )
			],
			[
				'type'  => 'text',
				'name'  => 'time_duration',
				'label' => __( 'Длительность видео, время', 'wescle' ),
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'course_video' ],
			'meta_box_title' => esc_html__( 'Настройки - Видео', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}

new MetaBoxVideoCourse();