<?php

class MetaBoxCategory {

	public function __construct() {
		add_action( 'admin_init', array( $this, 'init' ) );
	}

	public function init() {
		$taxonomies = apply_filters( 'taxonomies_with_metabox', [ 'category', 'post_tag', 'productcat_wescle', 'service_cat', 'videocat_wescle' ] );

		foreach ( $taxonomies as $taxonomy ) {
			add_action( $taxonomy . '_edit_form_fields', array( $this, 'taxonomy_edit_meta_fields' ), 10, 2 );
			add_action( 'saved_' . $taxonomy, array( $this, 'taxonomy_saved_fields' ), 10 );
		}
	}

	public function taxonomy_edit_meta_fields( $term, $taxonomy ) {
		$description_bottom = get_term_meta( $term->term_id, 'description_bottom', 1 );
		$html               = '';

		$html .= '<tr class="form-field">';
		$html .= '<th scope="row"><label for="description-bottom">' . __( 'Описание под постами', 'wescle' ) . '</label></th>';
		$html .= '<td>';

		ob_start();
		wp_editor( $description_bottom, 'description-bottom', [ 'textarea_name' => 'description-bottom' ] );
		$html .= ob_get_clean();

		$html .= '<p class="description">' . __( 'Это описание будет отображаться под постами', 'wescle' ) . '</p>';
		$html .= '</td>';
		$html .= '</tr>';

		echo $html;
	}

	public function taxonomy_saved_fields( $term_id ) {
		if ( isset( $_POST['description-bottom'] ) ) {
			update_term_meta( $term_id, 'description_bottom', $_POST['description-bottom'] );
		}

		if ( isset( $_POST['term_color'] ) ) {
			update_term_meta( $term_id, 'term_color', $_POST['term_color'] );
		}
	}

}

new MetaBoxCategory();