<?php

class MetaBoxCatalogItem extends MetaBoxPost {

	protected $labels = [];

	public function __construct() {
		$this->labels = [
			'title_icon'       => __( 'Изображение', 'wescle' ),
			'button_icon'      => __( 'Выбрать изображение', 'wescle' ),
			'button_add'       => __( 'Добавить', 'wescle' ),
			'button_remove'    => __( 'Удалить', 'wescle' ),
			'title'            => __( 'Заголовок', 'wescle' ),
			'text'             => __( 'Текст', 'wescle' ),
			'text_strong'      => __( 'Сделать жирным?', 'wescle' ),
			'text_color'       => __( 'Выделить цветом?', 'wescle' ),
			'button_add_item'  => __( 'Добавить', 'wescle' ),
			'title_badge'      => __( 'Лейбл', 'wescle' ),
			'button_add_badge' => __( 'Добавить лейбл', 'wescle' ),
			'title_map_icon'   => __( 'Иконка', 'wescle' ),
			'youtube_title'    => __( 'Ссылка на YouTube', 'wescle' ),
			'youtube_desc'     => __( 'для вставки видео укажите ссылку с youtube.com или загрузите файл *.mp4', 'wescle' ),
			'title_video'      => __( 'Видео-файл', 'wescle' ) . ', *.mp4',
			'title_price'      => __( 'Цена', 'wescle' ),
		];

		$this->fields[] = [
			'type'        => 'checkbox',
			'name'        => 'hide_page_title',
			'label'       => esc_html__( 'Скрыть заголовок страницы?', 'wescle' ),
			'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
		];

		$this->fields[] = [
			'type'        => 'checkbox',
			'name'        => 'hide_contents',
			'label'       => esc_html__( 'Скрыть "Cодержание поста"?', 'wescle' ),
			'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
		];

		$this->fields[] = [
			'type'        => 'checkbox',
			'name'        => 'hide_breadcrumbs',
			'label'       => esc_html__( 'Скрыть "Хлебные крошки"?', 'wescle' ),
			'placeholder' => esc_html__( 'Скрыть', 'wescle' ),
		];

		$this->fields[] = [
			'type'  => 'custom',
			'name'  => '',
			'label' => '<hr>',
		];

		$this->fields[] = [
			'type'  => 'checkbox',
			'name'  => 'is_top',
			'label' => esc_html__( 'Топ предложение?', 'wescle' )
		];

		$this->fields[] = [
			'type'  => 'checkbox',
			'name'  => 'object_fit_contain',
			'label' => esc_html__( 'Включить режим заполнения', 'wescle' ) . ' (object-fit) "contain"?'
		];

		$this->fields[] = [
			'type'        => 'text',
			'name'        => 'youtube_link',
			'label'       => $this->labels['youtube_title'],
			'description' => $this->labels['youtube_desc'],
		];

		$this->fields[] = [
			'type'      => 'file',
			'name'      => 'video_file',
			'file_type' => 'video',
			'label'     => $this->labels['title_video'],
		];

		$this->fields[] = [
			'type'  => 'checkbox',
			'name'  => 'order_checkbox_disabled',
			'label' => esc_html__( 'Отключить выбор чекбоксов на странице объекта каталога', 'wescle' ),
		];

		$this->fields[] = [
			'type'  => 'text',
			'name'  => 'custom_url',
			'label' => esc_html__( 'Кастомная ссылка', 'wescle' ),
		];

		$this->fields[] = [
			'type'  => 'text',
			'name'  => 'button_text',
			'label' => esc_html__( 'Надпись на кнопке', 'wescle' ),
		];

		$this->fields[] = [
			'type'        => 'text',
			'name'        => 'button_link',
			'label'       => esc_html__( 'Ссылка для кнопки', 'wescle' ),
			'description' => __( '* чтобы кнопку сделать вызовом попапа формы заказа, пропишите <code>#wescle-modal-catalog_item</code>', 'wescle' ),
		];

		$this->fields[] = [
			'type'  => 'checkbox',
			'name'  => 'button_link_is_blank',
			'label' => esc_html__( 'Открывать ссылку в новом окне?', 'wescle' ),
		];

		$this->fields[] = [
			'type'  => 'text',
			'name'  => 'button2_text',
			'label' => esc_html__( 'Надпись на кнопке', 'wescle' ) . ' №2',
		];

		$this->fields[] = [
			'type'  => 'text',
			'name'  => 'button2_link',
			'label' => esc_html__( 'Ссылка для кнопки', 'wescle' ) . ' №2',
		];

		$this->fields[] = [
			'type'  => 'checkbox',
			'name'  => 'button2_link_is_blank',
			'label' => esc_html__( 'Открывать ссылку в новом окне?', 'wescle' ),
		];

		if ( class_exists( 'WPCF7_Mail' ) ) {
			$this->fields[] = [
				'type'        => 'checkbox',
				'name'        => 'show_form_after_content',
				'label'       => esc_html__( 'Показывать контактную форму после контента', 'wescle' ),
				'placeholder' => esc_html__( 'Да', 'wescle' ),
				'description' => esc_html__( 'Выбрать форму можно в Customizer -> Настройка внутренних страниц', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'text',
				'name'  => 'title_form_after_content',
				'label' => esc_html__( 'Заголовок для формы', 'wescle' ),
			];

			$this->fields[] = [
				'type'  => 'textarea',
				'name'  => 'text_form_after_content',
				'label' => esc_html__( 'Описание для формы', 'wescle' ),
			];
		}

		$this->fields[] = [
			'type'  => 'custom',
			'name'  => '',
			'label' => '<hr><br><h4>' . __( 'Управление запасами, статусы', 'wescle' ) . '</h4>',
		];
		$this->fields[] = [
			'type'  => 'checkbox',
			'name'  => 'manage_stock',
			'label' => esc_html__( 'Включить управление количеством в запасе', 'wescle' ),
		];
		$this->fields[] = [
			'type'    => 'number',
			'name'    => 'stock',
			'label'   => esc_html__( 'Количество в запасе', 'wescle' ),
			'default' => 0,
		];
		$this->fields[] = [
			'type'    => 'select',
			'name'    => 'stock_status',
			'label'   => esc_html__( 'Статус наличия', 'wescle' ),
			'options' => array_merge( [ '' => '' ], Catalog::get_statuses() )
		];

		$this->set_settings( array(
			'post_type'      => [ 'catalog_item' ],
			'meta_box_title' => __( 'Настройки', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );

			add_action( 'load-post.php', array( $this, 'init_cpt' ) );
			add_action( 'load-post-new.php', array( $this, 'init_cpt' ) );
		}
	}

	public function set_fields() {
		if ( Helper::is_woocommerce_active() ) {
			$this->fields[] = [
				'type'  => 'custom',
				'name'  => '',
				'label' => '<hr>',
			];
			$this->fields[] = [
				'type'        => 'select2',
				'name'        => 'related_product',
				'label'       => __( 'Укажите связь с продуктом', 'wescle' ),
				'options'     => Helper::get_posts( array(
					'post_type'      => 'product',
					'posts_per_page' => 200
				), true ),
				'description' => __( 'Если Вы выбираете связь с WooCommerce, тогда форма заменяется на товар, и происходит переход на страницу чекаут', 'wescle' )
			];
		}
	}

	public function init_cpt() {
		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ), 20 );
		add_action( 'save_post', array( $this, 'update_price_from_product' ), 200, 2 );

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}

	public function enqueue_scripts() {
		$screen = get_current_screen();
		if ( $screen && 'post' == $screen->base && in_array( $screen->post_type, $this->post_type ) ) {
			//wp_enqueue_style( 'wp-color-picker' );
			//wp_enqueue_script( 'wp-color-picker-alpha', get_template_directory_uri() . '/assets/admin/js/wp-color-picker-alpha.min.js', array( 'wp-color-picker' ), '3.0.0', true );

			wp_enqueue_script( 'selectWoo', get_template_directory_uri() . '/libs/wscl/assets/vendor/selectWoo/js/select2.min.js', array( 'jquery' ), '1.0.1', true );
			wp_enqueue_style( 'selectWoo', get_template_directory_uri() . '/libs/wscl/assets/vendor/selectWoo/css/selectWoo.css', array(), '1.0.1' );
		}
	}

	public function add_meta_box( $post_type ) {
		if ( in_array( $post_type, $this->post_type ) ) {
			add_meta_box(
				'wescle_meta_info_badges',
				__( 'Лейблы', 'wescle' ),
				array( $this, 'render_meta_box_badges' ),
				$post_type,
				'advanced',
				'low'
			);

			if ( get_theme_mod( 'module_catalog_gallery_enabled' ) ) {
				add_meta_box(
					'wescle_catalog_images',
					__( 'Другие изображения', 'wescle' ),
					array( $this, 'render_wescle_catalog_images' ),
					$post_type,
					'advanced',
					'low'
				);
			}

			add_meta_box(
				'wescle_catalog_advantages_title',
				__( 'Характеристики над заголовком', 'wescle' ),
				array( $this, 'render_wescle_advantages_title' ),
				$post_type,
				'advanced',
				'low'
			);

			add_meta_box(
				'wescle_catalog_advantages',
				__( 'Характеристики', 'wescle' ),
				array( $this, 'render_wescle_advantages' ),
				$post_type,
				'advanced',
				'low'
			);

			add_meta_box(
				'wescle_info_items',
				__( 'Инфо-блоки', 'wescle' ),
				array( $this, 'render_info_items' ),
				$post_type,
				'advanced',
				'low'
			);

			add_meta_box(
				'wescle_info_map',
				__( 'GPS-координаты', 'wescle' ),
				array( $this, 'render_info_map' ),
				$post_type,
				'advanced',
				'low'
			);
		}
	}

	public function save( $post_id ) {

		if ( ! isset( $_POST['wescle_catalog_info_nonce'] ) ) {
			return;
		}

		$nonce = $_POST['wescle_catalog_info_nonce'];

		if ( ! wp_verify_nonce( $nonce, 'wescle_meta_info' ) ) {
			return;
		}

		// Если это автосохранение ничего не делаем.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Проверяем права пользователя.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		$wescle_images = $_POST['wescle_catalog_images'] ?? [];
		$data          = [];
		if ( $wescle_images ) {
			foreach ( $wescle_images['image'] as $key => $img_id ) {
				if ( $img_id ) {
					$data[] = [
						'img_id'       => intval( $img_id ),
						'file_id'      => $wescle_images['file_id'][ $key ],
						'youtube_link' => $wescle_images['youtube_link'][ $key ],
					];
				}
			}
		}
		if ( $data ) {
			update_post_meta( $post_id, 'wescle_catalog_images', $data );
		}
		else {
			delete_post_meta( $post_id, 'wescle_catalog_images' );
		}

		$wescle_features = $_POST['wescle_advantages_title'];
		$data            = [];
		if ( $wescle_features ) {
			foreach ( $wescle_features['text'] as $key => $text ) {
				if ( $text ) {
					$data[] = [
						'text' => $text,
					];
				}
			}
		}
		update_post_meta( $post_id, 'wescle_advantages_title', $data );

		$wescle_features = $_POST['wescle_advantages'];
		$data            = [];
		if ( $wescle_features ) {
			foreach ( $wescle_features['image'] as $key => $img_id ) {
				$title = $wescle_features['title'][ $key ];
				$text  = $wescle_features['text'][ $key ];

				if ( $img_id || $title || $text ) {
					$data[] = [
						'img_id' => $img_id,
						'title'  => $title,
						'text'   => $text,
					];
				}
			}
		}
		update_post_meta( $post_id, 'wescle_advantages', $data );

		$check = $_POST['info_items_as_list'] ?? false;
		if ( $check ) {
			update_post_meta( $post_id, 'info_items_as_list', $check );
		}
		else {
			delete_post_meta( $post_id, 'info_items_as_list' );
		}

		$info_items = $_POST['info_items'];
		$data       = [];
		$min_prices = [];
		if ( $info_items ) {
			foreach ( $info_items['title'] as $key => $title ) {
				$text  = $info_items['text'][ $key ];
				$text2 = $info_items['text2'][ $key ];

				if ( $title || $text || $text2 ) {
					$data[] = [
						'title'        => $title,
						'title_strong' => $info_items['title_strong'][ $key ] ?? '',
						'title_color'  => $info_items['title_color'][ $key ] ?? '',
						'text'         => $text,
						'text_strong'  => $info_items['text_strong'][ $key ] ?? '',
						'text_color'   => $info_items['text_color'][ $key ] ?? '',
						'text2'        => $text2,
						'text2_strong' => $info_items['text2_strong'][ $key ] ?? '',
						'text2_color'  => $info_items['text2_color'][ $key ] ?? '',
						'price'        => $info_items['price'][ $key ] ?? '',
					];

					if ( $info_items['price'][ $key ] ) {
						$min_prices[] = floatval( $info_items['price'][ $key ] );
					}
				}
			}
		}
		sort( $min_prices );
		$min_price = $min_prices ? current( $min_prices ) : 0;

		update_post_meta( $post_id, 'info_items', $data );
		update_post_meta( $post_id, 'price', $min_price );

		$catalog_item_badges = $_POST['catalog_item_badges'];
		if ( $catalog_item_badges ) {
			$catalog_item_badges = array_unique( $catalog_item_badges );
			foreach ( $catalog_item_badges as $key => $val ) {
				if ( ! $val ) {
					unset( $catalog_item_badges[ $key ] );
				}
			}
		}
		if ( $catalog_item_badges ) {
			update_post_meta( $post_id, 'catalog_item_badges', $catalog_item_badges );
		}
		else {
			delete_post_meta( $post_id, 'catalog_item_badges' );
		}

		update_post_meta( $post_id, 'lat', floatval( $_POST['lat'] ) );
		update_post_meta( $post_id, 'lng', floatval( $_POST['lng'] ) );
		if ( $_POST['zoom'] ) {
			update_post_meta( $post_id, 'zoom', $_POST['zoom'] );
		}
		update_post_meta( $post_id, 'map_image', $_POST['map_image'] );

		// Set price
		$related_product = $_POST['related_product'];
		if ( $related_product ) {
			$product = wc_get_product( $related_product );
			if ( $product ) {
				update_post_meta( $post_id, 'price', $product->get_price() );
			}
		}

		$count_order = get_post_meta( $post_id, 'count_order', 1 );
		if ( $count_order === '' ) {
			update_post_meta( $post_id, 'count_order', 0 );
		}
	}

	public function update_price_from_product( $post_id, $post ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if ( wp_is_post_revision( $post_id ) ) {
			return;
		}

		if ( $post->post_status == 'auto-draft' ) {
			return;
		}

		if ( $post->post_type !== 'product' ) {
			return;
		}

		$catalog_posts = get_posts( [
			'post_type'      => 'catalog_item',
			'posts_per_page' => 1,
			'meta_key'       => 'related_product',
			'meta_value'     => $post_id,
		] );
		if ( $catalog_posts ) {
			$catalog_post = current( $catalog_posts );
			$product      = wc_get_product( $post_id );
			update_post_meta( $catalog_post->ID, 'price', $product->get_price() );
		}
	}

	public function render_wescle_catalog_images( $post ) {
		$data_images = get_post_meta( $post->ID, 'wescle_catalog_images', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_meta_info', 'wescle_catalog_info_nonce' ); ?>
            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $data_images ) {
						foreach ( $data_images as $item ) {
							$img_src = '';
							if ( $item['img_id'] ) {
								$img     = wp_get_attachment_image_src( $item['img_id'], 'medium' );
								$img_src = 'src="' . $img[0] . '"';
							}

							$file_img_src = $filename = '';
							if ( $item['file_id'] ) {
								$file_img_src = 'src="' . home_url( '/wp-includes/images/media/video.png' ) . '"';
								$file_url     = wp_get_attachment_url( $item['file_id'] );
								if ( $file_url ) {
									$filename = basename( $file_url );
								}
							}
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_icon']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div><img <?php echo $img_src; ?> alt=""></div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" name="wescle_catalog_images[image][]" value="<?php echo $item['img_id']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['youtube_title']; ?>
                                        <input type="text" class="widefat" name="wescle_catalog_images[youtube_link][]" value="<?php echo $item['youtube_link']; ?>">
                                    </label>
                                    <p class="description"><?php echo $this->labels['youtube_desc']; ?></p>
                                </div>
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_video']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div class="thumbnail">
                                            <div class="centered"><img <?php echo $file_img_src; ?> class="icon" alt=""></div>
                                            <div class="filename">
                                                <div><?php echo $filename; ?></div>
                                            </div>
                                        </div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" data-type="video" name="wescle_catalog_images[file_id][]" value="<?php echo $item['file_id']; ?>">
                                    </div>
                                </div>

                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_icon']; ?></label>
                                <div class="term__image__wrapper">
                                    <div><img alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="wescle_catalog_images[image][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field">
                                <label>
			                        <?php echo $this->labels['youtube_title']; ?>
                                    <input type="text" class="widefat" name="wescle_catalog_images[youtube_link][]" value="">
                                </label>
                                <p class="description"><?php echo $this->labels['youtube_desc']; ?></p>
                            </div>
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_video']; ?></label>
                                <div class="term__image__wrapper">
                                    <div class="thumbnail">
                                        <div class="centered"><img class="icon" alt=""></div>
                                        <div class="filename">
                                            <div></div>
                                        </div>
                                    </div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" data-type="video" name="wescle_catalog_images[file_id][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}

	public function render_wescle_advantages_title( $post ) {
		$data_features = get_post_meta( $post->ID, 'wescle_advantages_title', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_meta_info', 'wescle_catalog_info_nonce' ); ?>
            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $data_features ) {
						foreach ( $data_features as $item ) {
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['text']; ?>
                                        <input type="text" class="widefat" name="wescle_advantages_title[text][]" value="<?php echo esc_attr( $item['text'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['text']; ?>
                                    <input type="text" class="widefat" name="wescle_advantages_title[text][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}

	public function render_wescle_advantages( $post ) {
		wp_enqueue_media();

		$data_features = get_post_meta( $post->ID, 'wescle_advantages', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_meta_info', 'wescle_catalog_info_nonce' ); ?>
            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $data_features ) {
						foreach ( $data_features as $item ) {
							$img_src = '';
							if ( $item['img_id'] ) {
								$img = wp_get_attachment_image_src( $item['img_id'], 'medium' );
								if ( $img ) {
									$img_src = 'src="' . $img[0] . '"';
								}
							}
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label><?php echo $this->labels['title_icon']; ?></label>
                                    <div class="term__image__wrapper">
                                        <div><img <?php echo $img_src; ?> alt=""></div>
                                        <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                        <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                        <input type="hidden" class="term_imgid" name="wescle_advantages[image][]" value="<?php echo $item['img_id']; ?>">
                                    </div>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['title']; ?>
                                        <input type="text" class="widefat" name="wescle_advantages[title][]" value="<?php echo esc_attr( $item['title'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['text']; ?>
                                        <input type="text" class="widefat" name="wescle_advantages[text][]" value="<?php echo esc_attr( $item['text'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label><?php echo $this->labels['title_icon']; ?></label>
                                <div class="term__image__wrapper">
                                    <div><img alt=""></div>
                                    <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                                    <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                                    <input type="hidden" class="term_imgid" name="wescle_advantages[image][]" value="">
                                </div>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['title']; ?>
                                    <input type="text" class="widefat" name="wescle_advantages[title][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['text']; ?>
                                    <input type="text" class="widefat" name="wescle_advantages[text][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}

	public function render_info_items( $post ) {
		add_action( 'admin_print_footer_scripts', [ $this, 'script_metabox_catalog' ], 99 );

		$data_features = get_post_meta( $post->ID, 'info_items', true );
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_meta_info', 'wescle_catalog_info_nonce' ); ?>
            <p>
                <input type="checkbox" id="info_items_as_list" name="info_items_as_list" value="1" <?php checked( '1', get_post_meta( $post->ID, 'info_items_as_list', 1 ) ); ?>>
                <label for="info_items_as_list"><?php _e( 'Отображать инфо-блоки в виде списка?', 'wescle' ); ?></label>
                <br/>
                <span class="description"><?php _e( 'по умолчанию отображаются в виде таблицы', 'wescle' ); ?></span>
            </p>
            <div class="wrap-repeater-fields">
                <div class="repeater-fields">
					<?php
					if ( $data_features ) {
						foreach ( $data_features as $key => $item ) {
							if ( ! isset( $item['price'] ) ) {
								$item['price'] = '';
							}
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['text']; ?> 1
                                        <input type="text" class="widefat" name="info_items[title][]" value="<?php echo esc_attr( $item['title'] ); ?>">
                                    </label>
                                    <label>
                                        <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[title_strong][]" name="info_items[title_strong][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['title_strong'] ); ?>>
										<?php echo $this->labels['text_strong']; ?>
                                    </label>
                                    <label>
                                        <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[title_color][]" name="info_items[title_color][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['title_color'] ); ?>>
										<?php echo $this->labels['text_color']; ?>
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['text']; ?> 2
                                        <input type="text" class="widefat" name="info_items[text][]" value="<?php echo esc_attr( $item['text'] ); ?>">
                                    </label>
                                    <label>
                                        <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[text_strong][]" name="info_items[text_strong][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['text_strong'] ); ?>>
	                                    <?php echo $this->labels['text_strong']; ?>
                                    </label>
                                    <label>
                                        <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[text_color][]" name="info_items[text_color][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['text_color'] ); ?>>
		                                <?php echo $this->labels['text_color']; ?>
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['text']; ?> 3
                                        <input type="text" class="widefat" name="info_items[text2][]" value="<?php echo esc_attr( $item['text2'] ); ?>">
                                    </label>
                                    <label>
                                        <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[text2_strong][]" name="info_items[text2_strong][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['text2_strong'] ); ?>>
			                            <?php echo $this->labels['text_strong']; ?>
                                    </label>
                                    <label>
                                        <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[text2_color][]" name="info_items[text2_color][<?php echo $key; ?>]" value="1" <?php checked( 1, $item['text2_color'] ); ?>>
			                            <?php echo $this->labels['text_color']; ?>
                                    </label>
                                </div>
                                <div class="repeater-field">
                                    <label>
			                            <?php echo $this->labels['title_price']; ?>
                                        <input type="number" class="widefat" name="info_items[price][]" value="<?php echo esc_attr( $item['price'] ); ?>">
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['text']; ?> 1
                                    <input type="text" class="widefat" name="info_items[title][]" value="">
                                </label>
                                <label>
                                    <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[title_strong][]" value="1">
									<?php echo $this->labels['text_strong']; ?>
                                </label>
                                <label>
                                    <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[title_color][]" value="1">
									<?php echo $this->labels['text_color']; ?>
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['text']; ?> 2
                                    <input type="text" class="widefat" name="info_items[text][]" value="">
                                </label>
                                <label>
                                    <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[text_strong][]" value="1">
									<?php echo $this->labels['text_strong']; ?>
                                </label>
                                <label>
                                    <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[text_color][]" value="1">
	                                <?php echo $this->labels['text_color']; ?>
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
			                        <?php echo $this->labels['text']; ?> 3
                                    <input type="text" class="widefat" name="info_items[text2][]" value="">
                                </label>
                                <label>
                                    <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[text2_strong][]" value="1">
			                        <?php echo $this->labels['text_strong']; ?>
                                </label>
                                <label>
                                    <input type="checkbox" class="repeater-input-checkbox" data-input_name="info_items[text2_color][]" value="1">
			                        <?php echo $this->labels['text_color']; ?>
                                </label>
                            </div>
                            <div class="repeater-field">
                                <label>
			                        <?php echo $this->labels['title_price']; ?>
                                    <input type="number" class="widefat" name="info_items[price][]" value="">
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
            </div>
        </div>
		<?php
	}

	public function render_info_map( $post ) {
		?>
        <div class="wescle-metabox wescle-metabox-map">
			<?php wp_nonce_field( 'wescle_meta_info', 'wescle_catalog_info_nonce' ); ?>
            <table class="form-table form-table-custom">
                <tbody>
                <tr class="field-map_lat">
                    <td>
                        <div><label for="map_lat"><?php _e( 'Широта', 'wescle' ); ?></label></div>
                        <input type="text" id="map_lat" name="lat" value="<?php echo get_post_meta( $post->ID, 'lat', 1 ); ?>">
                    </td>
                </tr>
                <tr class="field-map_lng">
                    <td>
                        <div><label for="map_lng"><?php _e( 'Долгота', 'wescle' ); ?></label></div>
                        <input type="text" id="map_lng" name="lng" value="<?php echo get_post_meta( $post->ID, 'lng', 1 ); ?>">
                    </td>
                </tr>
                <tr class="field-map_lng">
                    <td>
                        <div><label for="map_zoom"><?php _e( 'Увеличение (zoom)', 'wescle' ); ?></label></div>
                        <input type="text" id="map_zoom" name="zoom" value="<?php echo get_post_meta( $post->ID, 'zoom', 1 ); ?>" placeholder="7">
                    </td>
                </tr>
                <tr class="field-map_lng">
                    <td>
                        <div><label><?php echo $this->labels['title_map_icon']; ?></label></div>
		                <?php
		                $img_src = '';
		                $img_id  = get_post_meta( $post->ID, 'map_image', 1 );
		                if ( $img_id ) {
			                $img = wp_get_attachment_image_src( $img_id );
			                if ( $img ) {
				                $img_src = 'src="' . $img[0] . '"';
			                }
		                }
		                ?>
                        <div class="term__image__wrapper">
                            <div><img <?php echo $img_src; ?> alt=""></div>
                            <input type="button" class="button button-secondary termeta_img_button" value="<?php echo $this->labels['button_add']; ?>"/>
                            <input type="button" class="button button-secondary termeta_img_remove" value="<?php echo $this->labels['button_remove']; ?>"/>

                            <input type="hidden" class="term_imgid" name="map_image" value="<?php echo $img_id; ?>">
                        </div>
                        <p class="description"><?php echo __( 'рекомендуемые размеры', 'wescle' ) . ', px: 32х32'; ?></p>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
		<?php
	}

	public function render_meta_box_badges( $post ) {
		$catalog_item_badges = get_post_meta( $post->ID, 'catalog_item_badges', true );
		if ( ! $catalog_item_badges ) {
			$catalog_item_badges = [];
		}

		$badge_data      = Helper::get_badges_data( 'wescle_badge_catalog_data' );
		$badge_posts_ids = [
			0 => __( 'Выбрать...', 'wescle' )
		];
		foreach ( $badge_data as $item ) {
			$badge_posts_ids[ $item['id'] ] = $item['title'];
		}
		?>
        <div class="wescle-metabox">
			<?php wp_nonce_field( 'wescle_meta_info', 'wescle_catalog_info_nonce' ); ?>
            <div class="wrap-repeater-fields">
                <p><a href="<?php echo admin_url( 'post-new.php?post_type=badge_catalog' ); ?>" target="_blank"><?php _e( 'Добавить новый лейбл', 'wescle' ); ?></a></p>
                <div class="repeater-fields">
					<?php
					if ( $catalog_item_badges ) {
						foreach ( $catalog_item_badges as $badge_item_id ) {
							?>
                            <div class="repeater-row repeater-row__flex">
                                <div class="repeater-field">
                                    <label>
										<?php echo $this->labels['title_badge']; ?>
                                        <select class="widefat" name="catalog_item_badges[]">
											<?php
											foreach ( $badge_posts_ids as $id => $name ) {
												echo '<option value="' . $id . '" ' . selected( $id, $badge_item_id, false ) . '>' . $name . '</option>';
											}
											?>
                                        </select>
                                    </label>
                                </div>
                                <div class="repeater-field alignright">
                                    <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                </div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="repeater-field-hidden">
                        <div class="repeater-row repeater-row__flex">
                            <div class="repeater-field">
                                <label>
									<?php echo $this->labels['title_badge']; ?>
                                    <select class="widefat" name="catalog_item_badges[]">
										<?php
										foreach ( $badge_posts_ids as $id => $name ) {
											echo '<option value="' . $id . '">' . $name . '</option>';
										}
										?>
                                    </select>
                                </label>
                            </div>
                            <div class="repeater-field alignright">
                                <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_badge']; ?></button>
            </div>
        </div>
		<?php
	}

	public function script_metabox_catalog() {
		?>
        <script>
            jQuery(document).ready(function ($) {
                $('body').on('wescle_repeater-add-item', function (e, block_fields) {
                    set_radio_checkbox_keys();
                });

                $('body').on('wescle_repeater-remove-item', function (e, block_fields) {
                    set_radio_checkbox_keys();
                });

                function set_radio_checkbox_keys() {
                    $('.wescle-metabox .repeater-fields').each(function (index_row, obj_parent) {
                        var ind_keys = 0;
                        $(obj_parent).find('.repeater-row').each(function (ind, obj) {
                            $(this).find('.repeater-input-checkbox').each(function () {
                                var name = $(this).attr('data-input_name');
                                name = name.replace('[]', '[' + ind_keys + ']');
                                $(this).attr('name', name);
                            });
                            ind_keys++;
                        });
                    });
                }

                function setting_stock_show_hide() {
                    if ($('#manage_stock').prop('checked')) {
                        $('.field-stock').show();
                        $('.field-stock_status').hide();
                    } else {
                        $('.field-stock').hide();
                        $('.field-stock_status').show();
                    }
                }

                setting_stock_show_hide();

                $('body').on('change', '#manage_stock', function () {
                    setting_stock_show_hide();
                });
            });
        </script>
		<?php
	}

}

new MetaBoxCatalogItem();


class MetaBoxBadgeCatalog extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'  => 'color',
				'name'  => 'bg_color',
				'label' => esc_html__( 'Цвет фона', 'wescle' ),
			],
			[
				'type'  => 'color',
				'name'  => 'title_color',
				'label' => esc_html__( 'Цвет текста', 'wescle' ),
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'badge_catalog' ],
			'meta_box_title' => esc_html__( 'Настройки', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}

new MetaBoxBadgeCatalog();

class MetaBoxInfoCatalog extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'  => 'image',
				'name'  => 'icon_id',
				'label' => esc_html__( 'Иконка', 'wescle' ),
			],
			[
				'type'  => 'text',
				'name'  => 'text',
				'label' => esc_html__( 'Описание', 'wescle' ),
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'info_catalog' ],
			'meta_box_title' => esc_html__( 'Настройки', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}

new MetaBoxInfoCatalog();

class MetaBoxCatalogCategory {

	public function __construct() {
		$this->labels = [
			'button_remove'   => __( 'Удалить', 'wescle' ),
			'title_filter'    => __( 'Фильтр', 'wescle' ),
			'button_add_item' => __( 'Добавить фильтр', 'wescle' ),
		];

		add_action( 'admin_init', array( $this, 'init' ) );
	}

	public function init() {
		$taxonomies = [ 'catalogcat_wescle' ];

		foreach ( $taxonomies as $taxonomy ) {
			add_action( $taxonomy . '_edit_form_fields', array( $this, 'taxonomy_edit_meta_fields' ), 10, 2 );
			add_action( 'saved_' . $taxonomy, array( $this, 'taxonomy_saved_fields' ), 10 );
		}
	}

	public function taxonomy_edit_meta_fields( $term, $taxonomy ) {
		$items = get_term_meta( $term->term_id, 'category_filters', true );
		?>
        <tr class="form-field">
            <th scope="row"><label for="description-bottom"><?php _e( 'Фильтры на странице с картой', 'wescle' ); ?></label></th>
            <td>
                <div class="wescle-metabox">
                    <div class="wrap-repeater-fields">
                        <div class="repeater-fields">
							<?php
							if ( $items ) {
								foreach ( $items as $filter_taxonomy ) {
									?>
                                    <div class="repeater-row repeater-row__flex">
                                        <div class="repeater-field">
                                            <label>
												<?php echo $this->labels['title_filter']; ?>
                                                <select class="widefat" name="category_filters[]">
													<?php
													foreach ( Helper::get_catalog_filter_choices() as $id => $name ) {
														echo '<option value="' . $id . '" ' . selected( $id, $filter_taxonomy, false ) . '>' . $name . '</option>';
													}
													?>
                                                </select>
                                            </label>
                                        </div>
                                        <div class="repeater-field alignright">
                                            <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                        </div>
                                    </div>
									<?php
								}
							}
							?>
                            <div class="repeater-field-hidden">
                                <div class="repeater-row repeater-row__flex">
                                    <div class="repeater-field">
                                        <label>
											<?php echo $this->labels['title_filter']; ?>
                                            <select class="widefat" name="category_filters[]">
												<?php
												foreach ( Helper::get_catalog_filter_choices() as $id => $name ) {
													echo '<option value="' . $id . '">' . $name . '</option>';
												}
												?>
                                            </select>
                                        </label>
                                    </div>
                                    <div class="repeater-field alignright">
                                        <button type="button" class="button-link button-link-delete"><?php echo $this->labels['button_remove']; ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="button-secondary repeater-add-item"><?php echo $this->labels['button_add_item']; ?></button>
                    </div>
                </div>
            </td>
        </tr>
		<?php
	}

	public function taxonomy_saved_fields( $term_id ) {
		if ( isset( $_POST['category_filters'] ) ) {
			$category_filters = [];
			foreach ( $_POST['category_filters'] as $filter_taxonomy ) {
				if ( $filter_taxonomy ) {
					$category_filters[] = $filter_taxonomy;
				}
			}
			update_term_meta( $term_id, 'category_filters', $category_filters );
		}
	}

}

new MetaBoxCatalogCategory();