<?php

class MetaBoxBadgeProduct extends MetaBoxPost {

	public function __construct() {
		$this->fields = [
			[
				'type'  => 'color',
				'name'  => 'bg_color',
				'label' => esc_html__( 'Цвет фона', 'wescle' ),
			],
			[
				'type'  => 'color',
				'name'  => 'title_color',
				'label' => esc_html__( 'Цвет текста', 'wescle' ),
			],
			[
				'type'  => 'checkbox',
				'name'  => 'image_long',
				'label' => esc_html__( 'Увеличенный размер изображения?', 'wescle' ),
			],
		];

		$this->set_settings( array(
			'post_type'      => [ 'badge_wescle' ],
			'meta_box_title' => esc_html__( 'Настройки', 'wescle' ),
		) );

		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init' ) );
			add_action( 'load-post-new.php', array( $this, 'init' ) );
		}
	}
}

new MetaBoxBadgeProduct();