<?php

class Video {

	protected $post_type = 'video_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );

		add_filter( 'posts_related_args', [ $this, 'posts_related_args' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Видео', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Видео', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Видео', 'wescle' ),
			'name_admin_bar'     => __( 'Видео', 'wescle' ),
			'all_items'          => __( 'Все видео', 'wescle' ),
			'add_new_item'       => __( 'Добавить новое видео', 'wescle' ),
			'add_new'            => __( 'Добавить видео', 'wescle' ),
			'new_item'           => __( 'Новое видео', 'wescle' ),
			'edit_item'          => __( 'Редактировать видео', 'wescle' ),
			'update_item'        => __( 'Обновить видео', 'wescle' ),
			'view_item'          => __( 'Просмотреть видео', 'wescle' ),
			'search_items'       => __( 'Найти видео', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Видео', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'excerpt', 'thumbnail', 'revisions', 'comments', 'page-attributes' ),
			'show_in_rest'      => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => true,
			'rewrite'           => array( 'slug' => 'video' ),
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-format-video',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args, $this->post_type );

		register_post_type( $this->post_type, $args );

		$args_tax = array(
			'hierarchical'      => true,
			'labels'            => array(
				'name'          => _x( 'Категории видео', 'taxonomy general name', 'wescle' ),
				'singular_name' => _x( 'Категория видео', 'taxonomy singular name', 'wescle' ),
				'add_new_item'  => __( 'Добавить новую категорию', 'wescle' ),
				'new_item_name' => __( 'Новая категория видео', 'wescle' ),
			),
			'public'            => true,
			'show_ui'           => true,
			'show_in_rest'      => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'video-category' ),
			'show_admin_column' => true,
		);
		$args_tax = apply_filters( 'wescle_cpt_videocat_wescle_args', $args_tax, 'videocat_wescle' );

		register_taxonomy(
			'videocat_wescle',
			array( $this->post_type ),
			$args_tax
		);
	}

	public function posts_related_args( $args ) {
		global $post;

		$taxonomy = 'videocat_wescle';

		if ( $post->post_type == $this->post_type ) {
			$terms = get_the_terms( $post, $taxonomy );
			if ( $terms ) {
				$args['tax_query'] = [
					[
						'taxonomy' => $taxonomy,
						'terms'    => wp_list_pluck( $terms, 'term_id' )
					]
				];
			}
		}

		return $args;
	}
}