<?php

class Team {

	protected $post_type = 'team_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );

		add_filter( 'posts_related_args', [ $this, 'posts_related_args' ] );
	}

	public function register_post_type() {
		$labels = array(
			'name'                  => _x( 'Команда', 'Post Type General Name', 'wescle' ),
			'singular_name'         => _x( 'Человек', 'Post Type Singular Name', 'wescle' ),
			'menu_name'             => __( 'Команда', 'wescle' ),
			'name_admin_bar'        => __( 'Члена команды', 'wescle' ),
			'all_items'             => __( 'Все люди', 'wescle' ),
			'add_new_item'          => __( 'Добавить нового человека', 'wescle' ),
			'add_new'               => __( 'Добавить человека', 'wescle' ),
			'new_item'              => __( 'Новый человек', 'wescle' ),
			'edit_item'             => __( 'Редактировать человека', 'wescle' ),
			'update_item'           => __( 'Обновить человека', 'wescle' ),
			'view_item'             => __( 'Просмотреть человека', 'wescle' ),
			'search_items'          => __( 'Найти человека', 'wescle' ),
			'not_found'             => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash'    => __( 'В корзине пусто', 'wescle' ),
			'featured_image'        => __( 'Изображение', 'wescle' ),
			'set_featured_image'    => __( 'Выбрать изображение', 'wescle' ),
			'remove_featured_image' => __( 'Удалить изображение', 'wescle' ),
			'use_featured_image'    => __( 'Установить изображение', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Человек', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'editor', 'thumbnail', 'revisions', 'comments', 'page-attributes' ),
			'show_in_rest'      => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => true,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => false,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-groups',
		);
		$args = apply_filters( 'wescle_cpt_' . $this->post_type . '_args', $args, $this->post_type );

		register_post_type( $this->post_type, $args );

		register_taxonomy(
			'teamcat_wescle',
			array( $this->post_type ),
			array(
				'hierarchical'      => true,
				'labels'            => array(
					'name'          => _x( 'Категории команды', 'taxonomy general name', 'wescle' ),
					'singular_name' => _x( 'Категория команды', 'taxonomy singular name', 'wescle' ),
					'add_new_item'  => __( 'Добавить новую категорию', 'wescle' ),
					'new_item_name' => __( 'Новая категория команды', 'wescle' ),
				),
				'public'            => false,
				'show_ui'           => true,
				'show_in_rest'      => true,
				'query_var'         => true,
				'rewrite'           => array( 'slug' => 'team-category' ),
				'show_admin_column' => true,
			)
		);
	}

	public function posts_related_args( $args ) {
		global $post;

		$taxonomy = 'teamcat_wescle';

		if ( $post->post_type == $this->post_type ) {
			$terms = get_the_terms( $post, $taxonomy );
			if ( $terms ) {
				$args['tax_query'] = [
					[
						'taxonomy' => $taxonomy,
						'terms'    => wp_list_pluck( $terms, 'term_id' )
					]
				];
			}
		}

		return $args;
	}
}