<?php

class Tabs {

	protected $post_type = 'tab_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Табы', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Таб', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Табы с объектами', 'wescle' ),
			'name_admin_bar'     => __( 'Таб', 'wescle' ),
			'all_items'          => __( 'Все табы', 'wescle' ),
			'add_new_item'       => __( 'Добавить новый таб', 'wescle' ),
			'add_new'            => __( 'Добавить таб', 'wescle' ),
			'new_item'           => __( 'Новый таб', 'wescle' ),
			'edit_item'          => __( 'Редактировать таб', 'wescle' ),
			'update_item'        => __( 'Обновить таб', 'wescle' ),
			'view_item'          => __( 'Просмотреть таб', 'wescle' ),
			'search_items'       => __( 'Найти таб', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Таб', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'thumbnail', 'page-attributes' ),
			//'show_in_rest'        => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			//'menu_icon'         => '',
		);

		register_post_type( $this->post_type, $args );
	}
}