<?php

class Stories {

	protected $post_type = 'stories_wescle';

	public function __construct() {
		add_action( 'init', [ $this, 'register_post_type' ] );
	}

	public function register_post_type() {

		$labels = array(
			'name'               => _x( 'Сторисы', 'Post Type General Name', 'wescle' ),
			'singular_name'      => _x( 'Сторис', 'Post Type Singular Name', 'wescle' ),
			'menu_name'          => __( 'Сторисы', 'wescle' ),
			'name_admin_bar'     => __( 'Сторис', 'wescle' ),
			'all_items'          => __( 'Все сторисы', 'wescle' ),
			'add_new_item'       => __( 'Добавить новый сторис', 'wescle' ),
			'add_new'            => __( 'Добавить сторис', 'wescle' ),
			'new_item'           => __( 'Новый сторис', 'wescle' ),
			'edit_item'          => __( 'Редактировать сторис', 'wescle' ),
			'update_item'        => __( 'Обновить сторис', 'wescle' ),
			'view_item'          => __( 'Просмотреть сторис', 'wescle' ),
			'search_items'       => __( 'Найти сторис', 'wescle' ),
			'not_found'          => __( 'Не найдено', 'wescle' ),
			'not_found_in_trash' => __( 'В корзине пусто', 'wescle' ),
		);

		$args = array(
			'label'             => __( 'Сторис', 'wescle' ),
			'labels'            => $labels,
			'supports'          => array( 'title', 'thumbnail', 'page-attributes' ),
			//'show_in_rest'        => true, // Add Gutenberg Support
			'hierarchical'      => false,
			'public'            => false,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'menu_position'     => 5,
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => false,
			'can_export'        => true,
			'capability_type'   => 'post',
			'menu_icon'         => 'dashicons-instagram',
		);

		register_post_type( $this->post_type, $args );
	}
}